@echo off
if "%1"=="" goto usage
:jump
echo %1
goto %1

:usage
echo Usage: makepvm PART
echo PART:
echo   src              - pvmd3.exe, libpvm3.a
echo   console          - pvm.exe
echo   fortran          - libfpvm3.a
echo   groups           - pvmgs.exe, pvmgstat.exe, libgpvm3.a
echo   xdr              - xdr.a   (see Readme.os2)
echo   clean            - cleans all leftovers from build
echo Shortcuts:
echo   all (all of the above - except for clean)
goto end

:all
call makepvm  src console fortran groups
goto next

:src
cd src
cd os2
dmake -f makepvm.mk
echo Copying pvmd3.exe to pvm3\lib\os2
copy pvmd3.exe ..\..\lib\os2
echo Copying libpvm3.a to pvm3\lib\os2
copy libpvm3.a ..\..\lib\os2
cd ..\..
goto next

:console
cd console
cd os2
dmake -f makecons.mk
echo Copying pvm.exe to pvm3\lib\os2
copy pvm.exe ..\..\lib\os2
cd ..\..
goto next

:fortran
cd libfpvm
cd os2
dmake -f makefpvm.mk
echo Copying libfpvm3.a to pvm3\lib\os2
copy libfpvm3.a ..\..\lib\os2
cd ..\..
goto next

:groups
cd pvmgs
cd os2
dmake -f makegpvm.mk all
echo Copying libgpvm3.a to pvm3\lib\os2
copy libgpvm3.a ..\..\lib\os2
echo Copying pvmgs.exe to pvm3\lib\os2
copy pvmgs.exe ..\..\lib\os2
echo Copying pvmgstat.exe to pvm3\lib\os2
copy pvmgstat.exe ..\..\lib\os2
cd ..\..
goto next

:xdr
cd xdr
dmake -f makexdr.mk
copy xdr.a ..\implib
echo Library xdr.a was copied to pvm3\implib
cd ..
goto next

:clean
cd src
cd os2
dmake -f makepvm.mk clean
cd ..\..
cd console
cd os2
dmake -f makecons.mk clean
cd ..\..
cd libfpvm
cd os2
dmake -f makefpvm.mk clean
cd ..\..
cd pvmgs
cd os2
dmake -f makegpvm.mk clean
cd ..\..
cd xdr
dmake -f makexdr.mk clean
cd ..
echo  Cleaning is done
goto next

:next
shift
if not "%1" == "" goto jump
:end
