/* intrins.h:
   List of intrinsic functions for use by find_intrinsic
   and check_intrins_args.  You may add locally available intrinsics
   to this list (order not important).

    Copyright (C) 1992 by Robert K. Moniot.
    This program is free software.  Permission is granted to
    modify it and/or redistribute it, retaining this notice.
    No guarantees accompany this software.


*/


	/* Define positional flags to allow specifying more
	   than one allowed type of argument for generics.
	 */

#define I   (1 << type_INTEGER)
#define R   (1 << type_REAL)
#define D   (1 << type_DP)
#define C   (1 << type_COMPLEX)
#define L   (1 << type_LOGICAL)
#define STR (1 << type_STRING)


	/* Table contains: name, num_args, arg_type, result_type.
	   Note: num_args == -1 means 1 or 2 args, -2 means 2 or more args.
	 */

{"INT", 	1,	I|R|D|C,type_INTEGER},
{"IFIX",	1,	R,	type_INTEGER},
{"IDINT",	1,	D,	type_INTEGER},
{"REAL",	1,	I|R|D|C,type_REAL},
{"FLOAT",	1,	I,	type_REAL},
{"SNGL",	1,	D,	type_REAL},
{"DBLE",	1,	I|R|D|C,type_DP},
{"CMPLX",	-1,	I|R|D|C,type_COMPLEX},
{"ICHAR",	1,	STR,	type_INTEGER},
{"CHAR",	1,	I,	type_STRING},
{"AINT",	1,	R|D,	type_GENERIC},
{"DINT",	1,	D,	type_DP},
{"ANINT",	1,	R|D,	type_GENERIC},
{"DNINT",	1,	D,	type_DP},
{"NINT",	1,	R|D,	type_INTEGER},
{"IDNINT",	1,	D,	type_INTEGER},
{"ABS", 	1,	I|R|D|C,type_GENERIC},
{"IABS",	1,	I,	type_INTEGER},
{"DABS",	1,	D,	type_DP},
{"CABS",	1,	C,	type_REAL},
{"MOD", 	2,	I|R|D,	type_GENERIC},
{"AMOD",	2,	R,	type_REAL},
{"DMOD",	2,	D,	type_DP},
{"SIGN",	2,	I|R|D,	type_GENERIC},
{"ISIGN",	2,	I,	type_INTEGER},
{"DSIGN",	2,	D,	type_DP},
{"DIM",		2,	I|R|D,	type_GENERIC},
{"IDIM",	2,	I,	type_INTEGER},
{"DDIM",	2,	D,	type_DP},
{"DPROD",	2,	R,	type_DP},
{"MAX",		-2,	I|R|D,	type_GENERIC},
{"MAX0",	-2,	I,	type_INTEGER},
{"AMAX1",	-2,	R,	type_REAL},
{"DMAX1",	-2,	D,	type_DP},
{"AMAX0",	-2,	I,	type_REAL},
{"MAX1",	-2,	R,	type_INTEGER},
{"MIN", 	-2,	I|R|D,	type_GENERIC},
{"MIN0",	-2,	I,	type_INTEGER},
{"AMIN1",	-2,	R,	type_REAL},
{"DMIN1",	-2,	D,	type_DP},
{"AMIN0",	-2,	I,	type_REAL},
{"MIN1",	-2,	R,	type_INTEGER},
{"LEN", 	1,	STR,	type_INTEGER},
{"INDEX",	2,	STR,	type_INTEGER},
{"AIMAG",	1,	C,	type_REAL},
{"CONJG",	1,	C,	type_COMPLEX},
{"SQRT",	1,	R|D|C,	type_GENERIC},
{"DSQRT",	1,	D,	type_DP},
{"CSQRT",	1,	C,	type_COMPLEX},
{"EXP",		1,	R|D|C,	type_GENERIC},
{"DEXP",	1,	D,	type_DP},
{"CEXP",	1,	C,	type_COMPLEX},
{"LOG", 	1,	R|D|C,	type_GENERIC},
{"ALOG",	1,	R,	type_REAL},
{"DLOG",	1,	D,	type_DP},
{"CLOG",	1,	C,	type_COMPLEX},
{"LOG10",	1,	R|D,	type_GENERIC},
{"ALOG10",	1,	R,	type_REAL},
{"DLOG10",	1,	D,	type_DP},
{"SIN", 	1,	R|D|C,	type_GENERIC},
{"DSIN",	1,	D,	type_DP},
{"CSIN",	1,	C,	type_COMPLEX},
{"COS", 	1,	R|D|C,	type_GENERIC},
{"DCOS",	1,	D,	type_DP},
{"CCOS",	1,	C,	type_COMPLEX},
{"TAN", 	1,	R|D,	type_GENERIC},
{"DTAN",	1,	D,	type_DP},
{"ASIN",	1,	R|D,	type_GENERIC},
{"DASIN",	1,	D,	type_DP},
{"ACOS",	1,	R|D,	type_GENERIC},
{"DACOS",	1,	D,	type_DP},
{"ATAN",	1,	R|D,	type_GENERIC},
{"DATAN",	1,	D,	type_DP},
{"ATAN2",	2,	R|D,	type_GENERIC},
{"DATAN2",	2,	D,	type_DP},
{"SINH",	1,	R|D,	type_GENERIC},
{"DSINH",	1,	D,	type_DP},
{"COSH",	1,	R|D,	type_GENERIC},
{"DCOSH",	1,	D,	type_DP},
{"TANH",	1,	R|D,	type_GENERIC},
{"DTANH",	1,	D,	type_DP},
{"LGE", 	2,	STR,	type_LOGICAL},
{"LGT", 	2,	STR,	type_LOGICAL},
{"LLE", 	2,	STR,	type_LOGICAL},
{"LLT", 	2,	STR,	type_LOGICAL},
