#include "rect.h"

#include "ordcltn.h"
// -gmv above required for: Rectangle::areasOutside()

#define THIS    Rectangle
#define BASE    Object
DEFINE_CLASS(Rectangle,Object);

Rectangle::Rectangle(int left, int top, int width, int height)
{
    tl = Point(left,top);
    //br = Point(left+width,top+height);
    br = Point(left+width-1,top+height-1);  //-gmv
}

Rectangle::Rectangle(Point o, Point c)
{
    tl = o;
    br = c;
}

bool Rectangle::operator==(const Rectangle& r) const
{
    return (tl==((Rectangle*)&r)->tl && br==((Rectangle*)&r)->br);
}

bool Rectangle::operator!=(const Rectangle& r) const
{
    return (tl!=((Rectangle*)&r)->tl || br!=((Rectangle*)&r)->br);
}

Rectangle Rectangle::operator&&(const Rectangle& r) const
{
    return Rectangle(tl.max(((Rectangle*)&r)->tl),
                     br.min(((Rectangle*)&r)->br));
}

Rectangle Rectangle::operator||(const Rectangle& r) const
{
    return Rectangle(tl.min(((Rectangle*)&r)->tl),
                     br.max(((Rectangle*)&r)->br));
}

void Rectangle::operator+=(const Point& p)
{
    tl += p;
    br += p;
}

void Rectangle::operator-=(const Point& p)
{
    tl -= p;
    br -= p;
}

#if 1
OrderedCltn& Rectangle::areasOutside(const Rectangle& r) const
{
    OrderedCltn& areas = *new OrderedCltn(4);
    short yOrigin, yCorner;
    if ((tl > ((Rectangle*)&r)->br) || (((Rectangle*)&r)->tl > br))
    {
        areas.add(*this);   // rectangles do not intersect 
        return areas;
    }
    if (r.tl.y() > tl.y())
        areas.add(*new Rectangle(tl, Point(br.x(), yOrigin = r.tl.y())));
    else    yOrigin = tl.y();
    if (r.br.y() < br.y())
        areas.add(*new Rectangle(Point(tl.x(), yCorner = r.br.y()), br));
    else    yCorner = br.y();
    if (r.tl.x() > tl.x())
        areas.add(*new Rectangle(Point(tl.x(), yOrigin),
                                 Point(r.tl.x(), yCorner)));
    if (r.br.x() < br.x())
        areas.add(*new Rectangle(Point(r.br.x(), yOrigin),
                                 Point(br.x(), yCorner)));
    return areas;
}
#endif

bool Rectangle::contains(const Point& p) const
{
    return (tl <= p) && (p <= br);
}

bool Rectangle::contains(const Rectangle& r) const
{
    return (contains(((Rectangle*)&r)->tl)
            &&
            contains(((Rectangle*)&r)->br));
}

bool Rectangle::intersects(const Rectangle& r) const
{
    if (tl.max(((Rectangle*)&r)->tl)
        <
        br.min(((Rectangle*)&r)->br))
    {
        return YES;
    }
    return NO;
}

void Rectangle::moveTo(const Point& p)
{
    br += p-tl;
    tl = p;
}

Object* Rectangle::copy() const
{
    return shallowCopy();
}

void Rectangle::deepenShallowCopy() {}

unsigned Rectangle::hash() const
{
    return tl.hash()^br.hash();
}

bool Rectangle::isEqual(const Object& r) const
{
    return r.isSpecies(class_Rectangle)
           &&
           *this==*(Rectangle*)&r;
}

const Class* Rectangle::species() const
{
    return &class_Rectangle;
}

void Rectangle::printOn(ostream& strm) const
{
    tl.printOn(strm);
    strm << " corner: ";
    br.printOn(strm);
}
