/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 47                        
                                                                            
 Demonstrates the use of the wfilesel routine. It will draw some random     
 images on the screen and then call the file selector which will appear     
 superimposed on the screen. The user may select a BLK file to be loaded    
 and displayed.                                                             
                                                                            
  PROJECT                                                             
 This program requires the WGT4.LIB and WFILE.LIB files to be linked.       
                                                                            
  DATA FILES                                                          
 LITTLE.WFN must be in the executable directory.                            
                                                                            
ͼ
*/

#include <stdlib.h>
#include <conio.h>
#include <wgt4.h>


void main (void)
{
  block screenbuf;
  color pal[256];
  char *filename;
  int oldmode;
  wgtfont little;
  int ctr;

  if ( !vgadetected() )
  {
    printf ("Error - VGA card required for any WGT program.\n");
    exit (0);
  }

  oldmode = wgetmode();		/* Store current video mode 	*/
  vga256();			/* Initialize WGT system	*/

  for (ctr = 0; ctr < 100; ctr++)             /* Create a random screen */
  {
    wsetcolor (rand () % 256);
    wline (rand () % 320, rand () % 200, rand () % 320, rand () % 200);
  }
    
  screenbuf = wnewblock (0, 0, 319, 199);       /* Preserve the screen */

  minit ();                                     /* Mouse must be on */

  wreadpalette (0, 255, pal);                   /* Store current palette */

  /* The file selector uses color indices 253-255, so you must set these
     to represent the colors you'd like */
  wsetrgb (253, 63, 63, 63, pal);         /* White */
  wsetrgb (254, 40, 40, 40, pal);         /* Light Gray */
  wsetrgb (255, 30, 30, 30, pal);         /* Dark Gray */
  wsetpalette (253, 255, pal);            /* Set the colors */

  little = wloadfont ("little.wfn");	/* Load our font for selector */
  filefont = little;			/* Set the font variable */

  /* Now open a moveable file selector which will prompt for BLK files */
  filename = wfilesel ("BLK", "Load Block File", 40, 10, screenbuf);
  moff ();
  mdeinit ();

  wfreefont (little);		    /* Deallocate the font */
  wfreeblock (screenbuf);           /* Free the screen buffer */
  if (filename != NULL)             /* Did the user select a file? */
  {
    screenbuf = wloadblock (filename);          /* Load the image */
    wputblock (0, 0, screenbuf, NORMAL);        /* Display it */
    wfreeblock (screenbuf);                     /* Free the memory */
    getch ();                                   /* Wait for a keypress */
  }
  wsetmode (oldmode);
}