"""
t3MCLD.py

Provides a class representing a metaclass dependency list block in a t3 image
file.
"""

import struct
from t3Block import *

class MCLD_Block(Block):
	"""
	The metaclass dependency list block. There must be one such block in an
	image file.
	"""
	name = "Metaclass Dependency List Block"

	def __init__(self, datastream, image, attribs):
		Block.__init__(self, datastream, image, attribs)
		self.read_block()
		
	def read_block(self):
		"""
		Reads the data included in the block.
		"""
		n = struct.unpack("<H", self.datastream.read(2))[0]
		entries = []
		for i in xrange(n):
			edict = {}
			offsettonext, bytesinname = struct.unpack("<HB", self.datastream.read(3))
			edict["s_name"] = self.datastream.read(bytesinname)
			numberofids, sizeofrecord = struct.unpack("<2H", self.datastream.read(4))
			edict["l_properties"] = []
			for j in xrange(numberofids):
				edict["l_properties"].append(struct.unpack("<H", 
									self.datastream.read(sizeofrecord))[0])
			entries.append(edict)
		self.data["l_entries"] = entries

	def report_data(self):
		sl = []
		for entry in self.data["l_entries"]:
			sl.append("\n")
			sl.append("name: " + str(entry["s_name"]) + "\n" + 
					"properties: " + str(entry["l_properties"]) + "\n")
		return "".join(sl)