"""
t3ENTP.py

Provides a class representing an entrypoint block in a t3 image file.
"""

import struct
from t3Block import *

class ENTP_Block(Block):
	"""
	The entrypoint block. An image file must have one and only one such
	block.
	"""
	
	name = "Entrypoint Block"

	def __init__(self, datastream, image, attribs):
		Block.__init__(self, datastream, image, attribs)
		self.read_block()
		
	def read_block(self):
		"""Reads the data included in the block."""
		offset, mh, et, dlt, dth, dtsrh, drvn = struct.unpack("<I6H", self.datastream.read(16))
		self.data["i_offset"] = offset
		self.data["i_methodHeaderSize"] = mh
		self.data["i_exceptionTableEntrySize"] = et
		self.data["i_debuggerLineTableEntrySize"] = dlt
		self.data["i_debugTableHeaderSize"] = dth
		self.data["i_debugTableLocalSymbolRecordHeaderSize"] = dtsrh
		self.data["i_debugRecordsVersionNumber"] = drvn

	def report_data(self):
		sl = []
		sl.append("offset: " + str(self.data["i_offset"]) + "\n")
		sl.append("method header size: " +
					str(self.data["i_methodHeaderSize"]) + "\n")
		sl.append("exception table entry size: " + 
				str(self.data["i_exceptionTableEntrySize"]) + "\n")
		sl.append("debugger line table entry size: " + 
					str(self.data["i_debuggerLineTableEntrySize"]) + "\n")
		sl.append("debug table header size: " + 
					str(self.data["i_debugTableHeaderSize"]) + "\n")
		sl.append("debug table local symbol record header size: " +
					str(self.data["i_debugTableLocalSymbolRecordHeaderSize"]) + "\n")
		sl.append("debug records version number: " + 
					str(self.data["i_debugRecordsVersionNumber"]) + "\n")
		return "".join(sl)