/*
** GndParse.t is where I do all of my wacky parser fiddling.
**
** Copyright (c) 1999, Stephen Granade. All rights reserved.
*/

#pragma C+

// The mascara (in gndjean.t) is known by the appelation "pink and green
// tube". However, the parser doesn't handle "pink and green" properly.
// I'll assume that anytime it's used it is referring to the mascara and
// change it to "pink-and-green".
// At the same time, I'll look for "odds and ends" (in gndfrank.t) and
// turn it into "odds-and-ends".
// I'll also check to see if the player typed in a command of the form
// "take ...", so that the game can tell the difference between e.g. take
// and get.
preparse: function(str)
{
    local ret, newstr;

    if (reSearch(' *take', str) != nil)
	takeVerb.takeTyped = true;
    else takeVerb.takeTyped = nil;

    ret = reSearch('pink +and +green', str);
    if (ret != nil) {
	newstr = substr(str, 1, ret[1] - 1) + 'pink-and-green' +
	    substr(str, ret[1] + ret[2], length(str) - (ret[1] + ret[2]) + 1);
	return newstr;
    }
    ret = reSearch('odds +and +ends', str);
    if (ret != nil) {
	newstr = substr(str, 1, ret[1] - 1) + 'odds-and-ends' +
	    substr(str, ret[1] + ret[2], length(str) - (ret[1] + ret[2]) + 1);
	return newstr;
    }
    return true;
}

// At the end of each action, see if frankMe or debMe have acceptingActions
// set to true. If so, call addAction in 'em.
// (Note that, if global.pauseRecorder == true, we do no recording.)
// In addition, we check to see if the actor's location is of the class
// count
postAction: function(actor, verb, dobj, prep, iobj, status)
{
    if (isclass(uberloc(actor), turnCountRoom))
	uberloc(actor).updateCounter;

    // Since special commands (like SAVE) abort, we don't record Jeanie's
    // action if abort is called.
    if (status == EC_ABORT || global.pauseRecorder)
	return;
    if (frankMe.acceptingActions)
	frankMe.addAction;
    if (debMe.acceptingActions)
	debMe.addAction;
}

// I need open door to, by default, ignore doors of class autoDoor,
// since opening them just makes you move thru them.
// I'm also going to favor opening the house door over the car door.
modify openVerb
    disambigDobj(actor, prep, iobj, verprop, wordlist, objlist,
		 flaglist, numWanted, isAmbig, silent) = {
        local i, len, list = [], retlist = [], carDoorFlag = nil,
	    houseDoorFlag = nil;

        if (!isAmbig)
	    return DISAMBIG_CONTINUE;
	len = length(objlist);
	for (i = 1; i <= len; i++) {
	    if (!isclass(objlist[i], autoDoor)) {
		if (objlist[i] == house_door)
		    houseDoorFlag = flaglist[i];
		else if (objlist[i] == car_door)
		    carDoorFlag = flaglist[i];
		list += objlist[i];
		list += flaglist[i];
	    }
	}
	if (houseDoorFlag != nil && carDoorFlag != nil) {
	    list -= car_door;
	    list -= carDoorFlag;
	}
	if ((length(list) / 2) <= numWanted)
	    retlist += DISAMBIG_DONE;
	else retlist += DISAMBIG_CONTINUE;
	retlist += list;

	return retlist;
    }
;

// I want closeVerb to favor closing the car door over the house door
modify closeVerb
    disambigDobj(actor, prep, iobj, verprop, wordlist, objlist,
		 flaglist, numWanted, isAmbig, silent) = {
        local i, len, list = [], retlist = [], carDoorFlag = nil,
	    houseDoorFlag = nil;

        if (!isAmbig)
	    return DISAMBIG_CONTINUE;
	len = length(objlist);
	for (i = 1; i <= len; i++) {
	    if (objlist[i] == house_door)
		houseDoorFlag = flaglist[i];
	    else if (objlist[i] == car_door)
		carDoorFlag = flaglist[i];
	    else {
		list += objlist[i];
		list += flaglist[i];
	    }
	}
	if (houseDoorFlag != nil && carDoorFlag == nil) {
	    list += house_door;
	    list += houseDoorFlag;
	}
	if (carDoorFlag != nil) {
	    list += car_door;
	    list += carDoorFlag;
	}
	if ((length(list) / 2) <= numWanted)
	    retlist += DISAMBIG_DONE;
	else retlist += DISAMBIG_CONTINUE;
	retlist += list;

	return retlist;
    }
;

// I also want takeVerb to ignore the single can if it's a choice between
// that and the cans in the fridge
modify takeVerb
    disambigDobj(actor, prep, iobj, verprop, wordlist, objlist,
		 flaglist, numWanted, isAmbig, silent) = {
        local i, len, list = [], retlist = [];

        if (!isAmbig)
	    return DISAMBIG_CONTINUE;
	len = length(objlist);
	for (i = 1; i <= len; i++) {
	    if (objlist[i] != single_can) {
		list += objlist[i];
		list += flaglist[i];
	    }
	}
	if ((length(list) / 2) <= numWanted)
	    retlist += DISAMBIG_DONE;
	else retlist += DISAMBIG_CONTINUE;
	retlist += list;

	return retlist;
    }
;

// I don't want the player to find out about the stereo power cord
// through disambiguation.
modify deepverb
    disambigDobj(actor, prep, iobj, verprop, wordlist, objlist,
		 flaglist, numWanted, isAmbig, silent) = {
        local i, len, list = [], retlist = [], stereoCordFlag = nil,
	    frayedCordFlag = nil;

	// Don't do anything if we're unambiguous or if the player
	// has already played with the stereo power cord
        if (!isAmbig || stereo_power_cord.playerHasNoticedMe)
	    return DISAMBIG_CONTINUE;
	len = length(objlist);
	for (i = 1; i <= len; i++) {
	    if (objlist[i] == stereo_power_cord)
		stereoCordFlag = flaglist[i];
	    else if (objlist[i] == frayed_power_cord)
		frayedCordFlag = flaglist[i];
	    else {
		list += objlist[i];
		list += flaglist[i];
	    }
	}
	if (stereoCordFlag != nil && frayedCordFlag == nil) {
	    list += stereo_power_cord;
	    list += stereoCordFlag;
	}
	if (frayedCordFlag != nil) {
	    list += frayed_power_cord;
	    list += frayedCordFlag;
	}
	if ((length(list) / 2) <= numWanted)
	    retlist += DISAMBIG_DONE;
	else retlist += DISAMBIG_CONTINUE;
	retlist += list;

	return retlist;
    }
;

// A complicated filter which changes single quotes "'" to &rsquo; unless
// a) they fall within HTML tags (i.e. <font face='courier'>), b) they
// fall within formatting strings (i.e. %you're%), c) they are preceeded
// by a backslash
changeQuotes: function(str)
{
    local ret, newstr;

    // Check for HTML tags
    ret = reSearch('<[^>]+\'[^>]*>', str);
    if (ret == nil) {
	// Check for format tags
	ret = reSearch('%%[^\'%]+\'[^%]*%%', str);
    }
    // If we found one of the tags, ignore it recursively
    if (ret != nil && !(ret[1] != 1 && substr(str, ret[1] - 1, 1) == '\\')) {
	newstr = changeQuotes(substr(str, 1, ret[1] - 1)) + ret[3] +
	    changeQuotes(substr(str, ret[1] + ret[2], length(str) -
				(ret[1] + ret[2]) + 1));
	return newstr;
    }

    newstr = str;
    ret = find(newstr, '\'');
    while (ret != nil) {
	// If "\\'" is found in the string, leave the quote be. This means
	// that changeQuotes must be called recursively to handle the last
	// part of the string.
	if (ret > 2 && substr(newstr, ret - 2, 2) == '\\') {
	    newstr = substr(newstr, 1, ret - 3) + '\'' +
		changeQuotes(substr(newstr, ret + 1, length(newstr) - ret));
	    ret = nil;
	}
	else {
	    newstr = substr(newstr, 1, ret - 1) + '&rsquo;' +
		substr(newstr, ret + 1, length(newstr) - ret);
	    ret = find(newstr, '\'');
	}
    }
    return newstr;
}
