/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import tcl.lang.Channel;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclRuntimeError;

class StdChannel
extends Channel {
    private static BufferedReader in = null;
    private int stdType;
    static final int STDIN = 0;
    static final int STDOUT = 1;
    static final int STDERR = 2;
    private static final int BUF_SIZE = 1024;

    StdChannel() {
        in = null;
        this.stdType = -1;
    }

    StdChannel(String stdName) {
        if (stdName.equals("stdin")) {
            this.open(0);
        } else if (stdName.equals("stdout")) {
            this.open(1);
        } else if (stdName.equals("stderr")) {
            this.open(2);
        } else {
            throw new TclRuntimeError("Error: unexpected type for StdChannel");
        }
    }

    StdChannel(int type) {
        this.open(type);
    }

    String open(int type) {
        switch (type) {
            case 0: {
                this.mode = 1;
                if (in != null) break;
                in = new BufferedReader(new InputStreamReader(System.in));
                break;
            }
            case 1: {
                this.mode = 2;
                break;
            }
            case 2: {
                this.mode = 2;
                break;
            }
        }
        this.stdType = type;
        this.setChanName("file" + type);
        return this.getChanName();
    }

    String read(Interp interp, int readType, int numBytes) throws IOException, TclException {
        if (this.stdType != 0) {
            throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for reading");
        }
        switch (readType) {
            case 1: {
                boolean byteRead = false;
                char[] charArr = new char[1024];
                StringBuffer sbuf = new StringBuffer();
                while (in.read(charArr, 0, 1024) != -1) {
                    sbuf.append(charArr);
                }
                return sbuf.toString();
            }
            case 2: {
                return in.readLine();
            }
            case 3: {
                char[] charArr = new char[numBytes];
                in.read(charArr, 0, numBytes);
                return new String(charArr);
            }
        }
        throw new TclRuntimeError("StdChannel.read: Incorrect read mode.");
    }

    void write(Interp interp, String s) throws IOException, TclException {
        if (this.stdType != 1 && this.stdType != 2) {
            throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for writing");
        }
        if (this.stdType == 1) {
            System.out.print(s);
        } else {
            System.err.print(s);
        }
    }

    void close() throws IOException {
        switch (this.stdType) {
            case 0: {
                if (in == null) break;
                in.close();
                in = null;
                break;
            }
            case 1: {
                System.out.close();
                break;
            }
            case 2: {
                System.err.close();
                break;
            }
            default: {
                throw new TclRuntimeError("Error: unexpected stdType for StdChannel");
            }
        }
    }

    void flush(Interp interp) throws IOException, TclException {
        switch (this.stdType) {
            case 0: {
                throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for writing");
            }
            case 1: {
                System.out.flush();
                break;
            }
            case 2: {
                System.err.flush();
                break;
            }
            default: {
                throw new TclRuntimeError("Error: unexpected stdType for StdChannel");
            }
        }
    }

    void seek(long offset, int mode) throws IOException {
        switch (mode) {
            default: 
        }
    }

    long tell() throws IOException {
        return -1L;
    }

    boolean eof() {
        return false;
    }
}

