#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine number (value, rightj, chrstr)


***************************************************************
*                                                             *
*   Subroutine Write_Number_Into_String                       *
*                                                             *
*     This routine selects an appropriate format for a        *
*     real value, writes that value into a 10 character       *
*     string (right or left justified), and returns the       *
*     character string.                                       *
*                                                             *
***************************************************************


        Real value, tmpval
        Logical rightj
        Character *10 chrstr, temp
        Integer j
*
        chrstr = ' '
        tmpval = abs(value)
*
*  Select proper format.  If tmpval is between 1 and 10**7, write it
*  in a normal real number format.  Otherwise, use exponential form.
*
        IF (tmpval .GE. 1.0 .AND. tmpval .LT. 1e+07) THEN
          Write (chrstr,10) value
   10     Format (F10.1)
*
*       Adjust it correctly.
*
          IF (.NOT. rightj) THEN
               j = 1
   12          CONTINUE
               IF (chrstr(j:j) .EQ. ' ') THEN
                    j = j + 1
                    GOTO 12
               ENDIF
               temp = chrstr(j:)
               chrstr = temp
          ENDIF
        ELSEIF (value .EQ. 0.0) THEN
          IF (rightj) THEN
            chrstr = '         0'
          ELSE
            chrstr = '0'
          ENDIF
        ELSE
          Write (chrstr,20) value
   20     Format (E10.3)
        ENDIF

        Return
        End
