/*
 * Copyright (C) 1995, 1996 Systemics Ltd (http://www.systemics.com/)
 * All rights reserved.
 */

package cryptix.pgp;

import java.io.DataInput;
import java.io.IOException;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;

import cryptix.crypt.rsa.PublicKey;
import cryptix.crypt.rsa.SecretKey;

public final class KeyRing
{
	private Hashtable users = new Hashtable();
	
	public KeyRing( DataInput in )
		throws IOException
	{
		init( in );
	}
	
	public final PublicKey
	getUsersPublicKey( String username )
	{
		Object obj = users.get( username );
		if ( obj instanceof PublicKey )
			return (PublicKey)obj;
		Enumeration e = users.keys();
		while( ( obj = getIfBegins( e, username ) ) != null )
		{
			if ( obj instanceof PublicKey )
				return (PublicKey)obj;
		}
		return null;
	}

	public final SecretKey
	getUsersSecretKey( String username, String passphrase )
		throws IOException, DecryptException
	{
		Object obj = users.get( username );
		if ( obj instanceof SecretKeyCertificate )
			return ( (SecretKeyCertificate)obj ).getSecretKey( passphrase );
		Enumeration e = users.keys();
		while( ( obj = getIfBegins( e, username ) ) != null )
		{
			if ( obj instanceof SecretKeyCertificate )
				return ( (SecretKeyCertificate)obj ).getSecretKey( passphrase );
		}
		return null;
	}

	public final String[]
	getFullUserNameList()
	{
		int len = users.size();
		String ret[] = new String[len];
		if ( len > 0 )
		{
			Enumeration e = users.keys();
			for ( int i = 0; i < len; i++ )
				ret[i] = (String)e.nextElement();
		}
		return ret;
	}

	public final String[]
	getPublickeyUserNameList()
	{
		int len = users.size();
		if ( len > 0 )
		{
			Enumeration e;
			Vector v = new Vector();
			e = users.keys();
			for ( int i = 0; i < len; i++ )
			{
				Object obj = e.nextElement();
				if ( users.get( obj ) instanceof PublicKey )
					v.addElement( obj );
			}
			len = v.size();
			String ret[] = new String[len];
			e = v.elements();
			for ( int i = 0; i < len; i++ )
				ret[i] = (String)e.nextElement();
			return ret;
		}
		return new String[0];
	}

	public final String[]
	getSecretkeyUserNameList()
	{
		int len = users.size();
		if ( len > 0 )
		{
			Enumeration e;
			Vector v = new Vector();
			e = users.keys();
			for ( int i = 0; i < len; i++ )
			{
				Object obj = e.nextElement();
				if ( users.get( obj ) instanceof SecretKeyCertificate )
					v.addElement( obj );
			}
			len = v.size();
			String ret[] = new String[len];
			e = v.elements();
			for ( int i = 0; i < len; i++ )
				ret[i] = (String)e.nextElement();
			return ret;
		}
		return new String[0];
	}
	
	private final void
	init( DataInput in )
		throws IOException
	{
		Packet pkt, certificate = null;
		while ( ( pkt = PacketFactory.read( in ) ) != null )
		{
			if ( ( pkt instanceof PublicKeyCertificate ) || ( pkt instanceof SecretKeyCertificate ) )
				certificate = pkt;
			else if ( ( pkt instanceof UserId ) &&  ( certificate != null ) )
			{
				if ( certificate instanceof PublicKeyCertificate )
					users.put( pkt.toString(), ( (PublicKeyCertificate)certificate ).publickey() );
				else
					users.put( pkt.toString(), certificate );
			}
		}
	}
	
	private final Object
	getIfBegins( Enumeration e, String username )
	{
		while( e.hasMoreElements() )
		{
			String key = (String)e.nextElement();
			if ( key.startsWith( username ) )
				return users.get( key );
		}
		return null;
	}
}
