/*
 * Copyright (C) 1995, 1996 Systemics Ltd (http://www.systemics.com/)
 * All rights reserved.
 *
 * This library and applications are FREE FOR COMMERCIAL AND NON-COMMERCIAL USE
 * as long as the conditions within the COPYRIGHT file are adhered to.
 *
 */
 
package cryptix.crypt;

/**
 *
 * <p>Copyright (C) 1995, 1996 Systemics Ltd (http://www.systemics.com/)
 * All rights reserved.
 */
public class CFB extends StreamCipher
{
	protected BlockCipher cipher;
	protected int blocksize;

	protected byte iv[];
	protected byte k[];
	protected int bytesLeft;

	public CFB( BlockCipher cipher_)
	{
		cipher = cipher_;
		blocksize = cipher_.blockLength();
		iv = new byte [blocksize];
		k = new byte [blocksize];
		reset();
	}

	public int keyLength() { return cipher.keyLength(); }

	public void next_block() { bytesLeft = 0; }

	public void reset()
	{
		bytesLeft = 0;
		for (int i = blocksize-1; i >= 0; --i) { iv[i] = 0; }
	}



	/**
	 * This function encrypts a block of data.
	 * The contents of the array in remain unchanged,
	 * with the result stored in the array out.
	 * The arrays can, however, be the same.
	 * @param in          The plain text to be encrypted.
	 * @param in_offset   The offset within the in buffer.
	 * @param out         Where the encrypted cipher text will be stored.
	 * @param out_offset  The offset within the out buffer.
	 * @param length      The length to encrypt.
	 */
	public void 
	encrypt( byte in[], int in_offset, byte out[], int out_offset, int length )
	{
		for ( int i = 0; i < length; i++ )
			out[i + out_offset] = encryptByte( in[i + in_offset] );
	}

	/**
	 * This function decrypts a block of data.
	 * The contents of the array in will not be changed,
	 * but will instead store the result in the array out.
	 * The arrays can, however, be the same.
	 * @param in          The cipher text to be decrypted.
	 * @param in_offset   The offset within the in buffer.
	 * @param out         Where the decrypted plain text will be stored.
	 * @param out_offset  The offset within the out buffer.
	 * @param length      The length to decrypt.
	 */
	public void
	decrypt( byte in[], int in_offset, byte out[], int out_offset, int length )
	{
		for ( int i = 0; i < length; i++ )
			out[i + out_offset] = decryptByte( in[i + in_offset] );
	}

	private byte
	encryptByte( byte b )
	{
		if (bytesLeft <= 0)
		{
			bytesLeft = blocksize;
			cipher.encrypt(iv, 0, k, 0);
		}
		b ^= k[blocksize-bytesLeft];
		System.arraycopy(iv, 1, iv, 0, blocksize-1);
		iv[blocksize-1] = b;
		bytesLeft--;
		return b;
	}
	
	private byte
	decryptByte( byte b )
	{
		if (bytesLeft <= 0)
		{
			bytesLeft = blocksize;
			cipher.encrypt(iv, 0, k, 0);
		}
		byte t = b;
		b ^= k[blocksize-bytesLeft];
		System.arraycopy(iv, 1, iv, 0, blocksize-1);
		iv[blocksize-1] = t;
		bytesLeft--;
		return b;
	}

}
