/*
This code is copyright (C) 1998 Robert O'Callahan.
This code is free for non-commercial use. Modification in all forms is permitted.
This license continues to apply to any modified versions. This license text must be
reproduced and distributed with any modified versions.
As a matter of courtesy I (Robert O'Callahan) would like to be informed of
any potentially useful modifications.
*/

#ifndef __FWD_H
#define __FWD_H

#define FWD_REMOTE_CONNECTED 0x01
#define FWD_LOCAL_CONNECTED  0x02
#define FWD_CLOSED_REMOTE_IN 0x04
#define FWD_CLOSED_REMOTE_OUT 0x08
#define FWD_CLOSED_LOCAL_IN  0x10
#define FWD_CLOSED_LOCAL_OUT 0x20

typedef struct {
  int status;
  int remote_num;
  SOCKET local_socket;
  int request_num;
} FWDChannel;

#define FWD_LOCAL_TO_REMOTE 1
#define FWD_REMOTE_TO_LOCAL 2
#define FWD_REMOTE_X11_TO_LOCAL 3

typedef struct {
  int type;
  int from_port;
  char to_host[256];
  int to_port;
  SOCKET listening_socket;

  uint32 to_host_addr;
  char FAR * to_host_hostent_buf;
  HANDLE to_host_lookup_handle;
} FWDRequest;

typedef struct {
  HWND accept_wnd;
  WNDPROC old_accept_wnd_proc;
  int num_requests;
  FWDRequest FAR * requests;
  int num_channels;
  FWDChannel FAR * channels;
  uint32 * local_host_IP_numbers;
} FWDState;

void FWD_init(struct _TInstVar FAR * pvar);
void FWD_prep_forwarding(struct _TInstVar FAR * pvar);
void FWD_enter_interactive_mode(struct _TInstVar FAR * pvar);
void FWD_open(struct _TInstVar FAR * pvar, uint32 remote_channel_num,
  char FAR * local_hostname, int local_port, char FAR * originator, int originator_len);
void FWD_confirmed_open(struct _TInstVar FAR * pvar, uint32 local_channel_num,
  uint32 remote_channel_num);
void FWD_failed_open(struct _TInstVar FAR * pvar, uint32 local_channel_num);
void FWD_received_data(struct _TInstVar FAR * pvar, uint32 local_channel_num,
  unsigned char FAR * data, int length);
void FWD_channel_input_eof(struct _TInstVar FAR * pvar, uint32 local_channel_num);
void FWD_channel_output_eof(struct _TInstVar FAR * pvar, uint32 local_channel_num);
void FWD_end(struct _TInstVar FAR * pvar);

#endif
