(* An: Thomas Tempelmann    29.5.94
   Von: Jens Biele, Gaustr. 17, 67655 Kaiserslautern, tel. 0631-69787
   User-Nr. A 050.003.010.5, Update 4/94 auf Compiler 4.3c
   System: Mega ST 2+2 mit FPU, unter MagiX!/Ease
   Wg. Internem Fehler, Ref. Telefonat am 28.5.94              *)

(* Es folgen 2 Module, IMP "Astronomy" und HauptModul "Tidal", wo letzteres
   praktisch nur die gekrzte Form von ersterm ist *)

(* Noch eine Frage: Manchmal erscheint beim Abspeichern von Texten, z.B. aus
   dem GME, rechts in der Menueleiste : <Schreibfehler #000>; die Texte
   werden aber i.d.R. korrekt abgespeichert. Was soll das bedeuten ?    *)
(*
MODULE Astronomy;
FROM MathLib0 IMPORT sin,cos, sincos;
FROM InOut    IMPORT ReadLReal,WriteReal,WriteLn, RedirectOutput,CloseOutput;
FROM SysUtil0 IMPORT ClearVar;
TYPE FELD106   = ARRAY[1..106] OF LONGREAL;
     FELD106_5 = ARRAY[1..106],[1..5] OF SHORTINT;
     FELD93    = ARRAY[1..93 ] OF LONGREAL;
     FELD27    = ARRAY[1..27 ] OF LONGREAL;
     FELD5     = ARRAY[1..5  ] OF LONGREAL;
     FELD93_11 = ARRAY[1..93],[1..11] OF SHORTINT;
     FELD27_11 = ARRAY[1..27],[1..11] OF SHORTINT;
     FELD5_11  = ARRAY[1..5 ],[1..11] OF SHORTINT;
     FELD62    = ARRAY[1..62] OF LONGREAL;
     FELD62_5  = ARRAY[1..62],[1..5] OF SHORTINT;
(* CONST LEERFELD5_11  = FELD5_11  {{0 BY 11} BY 5};
   ergibt z.Zt. internen Fehler, Adresse nicht ansprechbar,
   >V#3592: 18500,108538,55788,81534 *)

VAR  CoeffLong0  : FELD106;    (* KOEFFIZIENTEN FR DIE NUTATION  *)
     CoeffLong1  : FELD106;
     CoeffObl0   : FELD106;
     CoeffObl1   : FELD106;
     Arg_Nut     : FELD106_5;  (* NUTATIONS-ARGUMENTE *)
     Coeff_Tidal : FELD62;     (* YODER-TERMS *)
     Coeff_Tidal_S1 : FELD62;  (* ZONAL TIDES INCL. OCEAN EFFECTS *)
     Coeff_Tidal_S2 : FELD62;  (*  " , OUT OF PHASE               *)
     Arg_Tidal   : FELD62_5;   (* ARGUMENTS FOR TIDAL TERMS       *)
     A : FELD93;               (* KOEFF. UND ARGUMENTE FR DELTA_TB *)
     B : FELD27;
     C : FELD5;
     D1: LONGREAL;
     Arg_TB_A : FELD93_11;
     Arg_TB_B : FELD27_11;
     Arg_TB_C : FELD5_11;
     
     i,j,min,max :INTEGER; sum:LONGREAL;
                           JD: LONGREAL;
                            N: Nutat;
     
PROCEDURE DeltaTB_TT(JD:LONGREAL):LONGREAL;
 BEGIN
  RETURN 0.0165214
 END DeltaTB_TT;

PROCEDURE Argumente0(JD:LONGREAL;VAR ARG: ARRAY OF LONGREAL);
 BEGIN
 END Argumente0;
  
PROCEDURE Nutation(JD:LONGREAL;IAU:BOOLEAN):Nutat;
(* WENN BOOLEAN, DANN WIRD NUR IAU-FORMEL GENOMMEN *)
 CONST rev = 1296000.0; (* 2 pi in arcsec *)
       rad = 2.0/rev;
 VAR N:Nutat;
     i,k: INTEGER;
     T,l,l_strich,F,D,OMEGA,x,y,theta,d_deltaphi,d_deltaeps: LONGREAL;
     Arg: ARRAY[1..106] OF LONGREAL;
 BEGIN
   T:=(JD-2451545.0)/36525.0; (* Zeit in jul. Jhd. seit J2000.0 *)
   l       :=(485866.733+(((0.064*T)+31.310*T)+1325.0*rev+715922.633)*T)*rad;
   l_strich:=(1287099.804+(((-0.012*T)-0.577*T)+99.0*rev+715922.633)*T)*rad;
   F       :=(335778.877+(((0.011*T)-13.257*T)+1342.0*rev+295263.137)*T)*rad;
   D       :=(1072261.307+(((0.019*T)-6.891*T)+1236.0*rev+1105601.328)*T)*rad;
   OMEGA   :=(450160.280+(((0.008*T)+7.455*T)-5.0*rev-482890.539)*T)*rad;
   (* l : mean anomaly of the moon;
      lstrich : mean anomaly of the sun;
      F       : difference L-OMEGA, where L is the mean longitude of the moon;
      D       : mean elongation of the moon from the sun;
      OMEGA   : long. of the asc. node of the moon's mean orbit on the
                ecliptic, measured from the mean equinox of date         *)
   (* Umwandlung von arcsec ins Bogenmass und Zurueckfuehrung auf das Inter-
      vall 0..2 pi  *)
         WriteReal(l,20,10); WriteLn;
         WriteReal(l_strich,20,10); WriteLn;
         WriteReal(F,20,10);WriteLn;
         WriteReal(D,20,10);WriteLn;
         WriteReal(OMEGA,20,10); WriteLn;
   N.Long:=0.0; N.Obl:=0.0;
   FOR i:=1 TO 106 DO
     Arg[i]:= l*LFLOAT(Arg_Nut[i,1])
             +l_strich*LFLOAT(Arg_Nut[i,2])
             +F*LFLOAT(Arg_Nut[i,3])
             +D*LFLOAT(Arg_Nut[i,4])
             +OMEGA*LFLOAT(Arg_Nut[i,5]);
     sincos(Arg[i],x,y);
     N.Long:=N.Long+(CoeffLong0[i]+CoeffLong1[i]*T)*x;
     N.Obl :=N.Obl+(CoeffObl0[i]+CoeffObl1[i]*T)*y;
   END;
   (* Geodesic Nutation, Fukushima, 1990; in IERS techn. note #13 *)
   N.Long:=N.Long-0.000153*sin(l_strich)-0.000002*sin(2.0*l_strich);
   IF (NOT IAU) THEN
   (* Apply differential corrections d_deltaphi,d_deltaeps for highest
      precision !! *)
   theta:=T*36525.0*2.0/418.0; (* Argument of free core nutation *)
   sincos(theta,x,y);
   d_deltaphi:=-35.0-273.5*T+0.815*x+0.124*y;  (* bias,slope,free core *)
   d_deltaeps:=-4.1-4.7*T+0.091*x+0.315*y;
   sincos(Arg[ 1],x,y);                        (* Nutation corrections *)
   d_deltaphi:=d_deltaphi-5.80*x+3.34*y;
   d_deltaeps:=d_deltaeps+2.16*x+2.68*y;
   sincos(Arg[ 9],x,y);
   d_deltaphi:=d_deltaphi+1.482*x-1.215*y;
   d_deltaeps:=d_deltaeps-0.441*x-0.482*y;
   sincos(Arg[31],x,y);
   d_deltaphi:=d_deltaphi-0.537*x-0.067*y;
   d_deltaeps:=d_deltaeps-0.102*x+0.303*y;
   sincos(Arg[ 2],x,y);
   d_deltaphi:=d_deltaphi+1.100*x;
   d_deltaeps:=d_deltaeps-0.100*y;
   sincos(Arg[10],x,y);
   d_deltaphi:=d_deltaphi+5.210*x+1.059*y;
   d_deltaeps:=d_deltaeps-0.270*x+2.010*y;
   sincos(Arg[32],x,y);
   d_deltaphi:=d_deltaphi-0.107*x-0.104*y;
   d_deltaeps:=d_deltaeps+0.030*x-0.043*y;
   sincos(Arg[11],x,y);
   d_deltaphi:=d_deltaphi-0.037*x+0.008*y;
   d_deltaeps:=d_deltaeps-0.051*x+0.040*y;
   sincos(Arg[33],x,y);
   d_deltaphi:=d_deltaphi-0.314*x-0.094*y;
   d_deltaeps:=d_deltaeps-0.011*x+0.050*y;
   sincos(Arg[34],x,y);
   d_deltaphi:=(d_deltaphi-0.234*x-0.087*y)*0.001;
   d_deltaeps:=(d_deltaeps-0.006*x+0.056*y)*0.001;
   N.Long:=N.Long+d_deltaphi;
   N.Obl :=N.Obl +d_deltaeps;
   END; (*IF NOT IAU *)
   RETURN N
 END Nutation;
 
 
BEGIN (* Astronomy, Initialisierung der konstanten Variablen *)
(* 1980 IAU Theory of Nutation *)

  CoeffLong0:=FELD106 {-171996.,2062.,46.,11.,-3.,-3.,-2.,1.,-13187.,1426.,-517.,217.,129.,
  48.,-22.,17.,-15.,-16.,-12.,-6.,-5.,4.,4.,-4.,1.,1.,-1.,1.,1.,-1.,-2274.,712.,-386.,-301.,-158.,
  123.,63.,63.,-58.,-59.,-51.,-38.,29.,29.,-31.,26.,21.,16.,-13.,-10.,-7.,7.,-7.,-8.,6.,6.,-6.,-7.,6.,
  -5.,5.,-5.,-4.,4.,-4.,3.,3.,-3.,-3.,-2.,-3.,-3.,2.,-2.,2.,-2.,2.,2.,1.,-1.,1.,-2.,-1.,1.,-1.,-1.,1.,1.,1.,
  -1.,-1.,1.,1.,-1.,1.,1.,-1. BY 7,1.,-1.,1.};
  
  CoeffLong1:=FELD106 {-174.2,0.2,0.0 BY 6, -1.6,-3.4,1.2,-0.5,0.1,0.0,0.0,
  -0.1,0.0,0.1,0.0 BY 12, -0.2,0.1,-0.4,0.0 BY 4, 0.1,-0.1, 0.0 BY 67};
  
  CoeffObl0:=FELD106 {92085.,-895.,-24.,0.,1.,0.,1.,0.,5736.,54.,224.,-95.,-70.,1.,0.,0.,9.,
  7.,6.,3.,3.,-2.,-2.,0. BY 7, 977.,-7.,200.,129.,-1.,-53.,-2.,-33.,32.,26.,27.,16.,-1.,-12.,13.,
  -1.,-10.,-8.,7.,5.,0.,-3.,3.,3.,0.,-3.,3.,3.,-3.,3.,0.,3.,0. BY 5, 1. BY 5, -1.,1.,-1.,1.,0.,-1.,-1.,
  0.,-1.,1.,0.,-1.,1.,1.,0.,0.,-1.,0. BY 17};
  
  CoeffObl1:=FELD106 {8.9,0.5,0.0 BY 6, -3.1,-0.1,-0.6,0.3,0.0 BY 18, -0.5,0.0,
  0.0,-0.1,0.0 BY 72};
  
  Arg_Nut:=FELD106_5  {{  0,  0,  0,  0,  1  },
                       {  0,  0,  0,  0,  2  },
                       { -2,  0,  2,  0,  1  },
                       {  2,  0, -2,  0,  0  },
                       { -2,  0,  2,  0,  2  },
                       {  1, -1,  0, -1,  0  },
                       {  0, -2,  2, -2,  1  },
                       {  2,  0, -2,  0,  1  },
                       {  0,  0,  2, -2,  2  },
                       {  0,  1,  0,  0,  0  },
                       {  0,  1,  2, -2,  2  },
                       {  0, -1,  2, -2,  2  },
                       {  0,  0,  2, -2,  1  },
                       {  2,  0,  0, -2,  0  },
                       {  0,  0,  2, -2,  0  },
                       {  0,  2,  0,  0,  0  },
                       {  0,  1,  0,  0,  1  },
                       {  0,  2,  2, -2,  2  },
                       {  0, -1,  0,  0,  1  },
                       { -2,  0,  0,  2,  1  },
                       {  0, -1,  2, -2,  1  },
                       {  2,  0,  0, -2,  1  },
                       {  0,  1,  2, -2,  1  },
                       {  1,  0,  0, -1,  0  },
                       {  2,  1,  0, -2,  0  },
                       {  0,  0, -2,  2,  1  },
                       {  0,  1, -2,  2,  0  },
                       {  0,  1,  0,  0,  2  },
                       { -1,  0,  0,  1,  1  },
                       {  0,  1,  2, -2,  0  },
                       {  0,  0,  2,  0,  2  },
                       {  1,  0,  0,  0,  0  },
                       {  0,  0,  2,  0,  1  },
                       {  1,  0,  2,  0,  2  },
                       {  1,  0,  0, -2,  0  },
                       { -1,  0,  2,  0,  2  },
                       {  0,  0,  0,  2,  0  },
                       {  1,  0,  0,  0,  1  },
                       { -1,  0,  0,  0,  1  },
                       { -1,  0,  2,  2,  2  },
                       {  1,  0,  2,  0,  1  },
                       {  0,  0,  2,  2,  2  },
                       {  2,  0,  0,  0,  0  },
                       {  1,  0,  2, -2,  2  },
                       {  2,  0,  2,  0,  2  },
                       {  0,  0,  2,  0,  0  },
                       { -1,  0,  2,  0,  1  },
                       { -1,  0,  0,  2,  1  },
                       {  1,  0,  0, -2,  1  },
                       { -1,  0,  2,  2,  1  },
                       {  1,  1,  0, -2,  0  },
                       {  0,  1,  2,  0,  2  },
                       {  0, -1,  2,  0,  2  },
                       {  1,  0,  2,  2,  2  },
                       {  1,  0,  0,  2,  0  },
                       {  2,  0,  2, -2,  2  },
                       {  0,  0,  0,  2,  1  },
                       {  0,  0,  2,  2,  1  },
                       {  1,  0,  2, -2,  1  },
                       {  0,  0,  0, -2,  1  },
                       {  1, -1,  0,  0,  0  },
                       {  2,  0,  2,  0,  1  },
                       {  0,  1,  0, -2,  0  },
                       {  1,  0, -2,  0,  0  },
                       {  0,  0,  0,  1,  0  },
                       {  1,  1,  0,  0,  0  },
                       {  1,  0,  2,  0,  0  },
                       {  1, -1,  2,  0,  2  },
                       { -1, -1,  2,  2,  2  },
                       { -2,  0,  0,  0,  1  },
                       {  3,  0,  2,  0,  2  },
                       {  0, -1,  2,  2,  2  },
                       {  1,  1,  2,  0,  2  },
                       { -1,  0,  2, -2,  1  },
                       {  2,  0,  0,  0,  1  },
                       {  1,  0,  0,  0,  2  },
                       {  3,  0,  0,  0,  0  },
                       {  0,  0,  2,  1,  2  },
                       { -1,  0,  0,  0,  2  },
                       {  1,  0,  0, -4,  0  },
                       { -2,  0,  2,  2,  2  },
                       { -1,  0,  2,  4,  2  },
                       {  2,  0,  0, -4,  0  },
                       {  1,  1,  2, -2,  2  },
                       {  1,  0,  2,  2,  1  },
                       { -2,  0,  2,  4,  2  },
                       { -1,  0,  4,  0,  2  },
                       {  1, -1,  0, -2,  0  },
                       {  2,  0,  2, -2,  1  },
                       {  2,  0,  2,  2,  2  },
                       {  1,  0,  0,  2,  1  },
                       {  0,  0,  4, -2,  2  },
                       {  3,  0,  2, -2,  2  },
                       {  1,  0,  2, -2,  0  },
                       {  0,  1,  2,  0,  1  },
                       { -1, -1,  0,  2,  1  },
                       {  0,  0, -2,  0,  1  },
                       {  0,  0,  2, -1,  2  },
                       {  0,  1,  0,  2,  0  },
                       {  1,  0, -2, -2,  0  },
                       {  0, -1,  2,  0,  1  },
                       {  1,  1,  0, -2,  1  },
                       {  1,  0, -2,  2,  0  },
                       {  2,  0,  0,  2,  0  },
                       {  0,  0,  2,  4,  2  },
                       {  0,  1,  0,  1,  0  }};

  (* Time Transformation TB-TT, L. Fairhead & P. Bretagnon 1990 *)

  A:=FELD93 {1656.674564,22.417471,13.839792,4.770086,4.676740,2.256707,
  1.694205,1.554905,1.276839,1.193379,1.115322,0.794185,0.600309,0.496817,
  0.486306,0.468597,0.447061,0.435206,0.432392,0.375510,0.243085,0.230685,
  0.203747,0.173435,0.159080,0.143935,0.137927,0.119979,0.118971,0.116120,
  0.101868,0.098358,0.080164,0.079645,0.075019,0.064397,0.063814,0.062617,
  0.058844,0.054139,0.048373,0.048042,0.046551,0.042732,0.042560,0.042411,
  0.040759,0.040480,0.040184,0.036955,0.036564,0.036507,0.034867,0.033529,
  0.033477,0.032438,0.032423,0.030215,0.029862,0.029247,0.028244,0.027567,
  0.025196,0.024816,0.022567,0.022509,0.021691,0.020937,0.020322,0.017673,
  0.017806,0.016155,0.015974,0.015949,0.015078,0.014751,0.014318,0.014223,
  0.013671,0.012462,0.012420,0.011942,0.011847,0.011707,0.011622,0.010962,
  0.010825,0.010396,0.010453,0.010099,0.009858,0.009963,0.009370};
                                            
  B:=FELD27 {102.156724,1.706807,0.269668,0.265919,0.210568,0.077996,0.059146,
  0.054764,0.034420,0.033595,0.032088,0.029198,0.027764,0.025190,0.024976,
  0.022997,0.021774,0.017925,0.013794,0.013276,0.012869,0.012152,0.011774,
  0.011081,0.010143,0.010084,0.009357};
                                            
  C := FELD5 {4.322990,0.12,0.11,0.01245,0.084541};
                                            
  D1:= 0.143388;
                       
  Arg_TB_A :=FELD93_11 {{  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  1,  0, -1,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  1,  0,  0, -1,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0  },
                        {  0,  0,  4, -8,  3,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0  },
                        {  0,  2, -2,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  1,  0, -2,  0,  0,  0,  0,  0,  0  },
                        {  0,  1, -1,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  2,  0, -2,  0,  0,  0,  0,  0,  0  },
                        {  0,  2, -3,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  1,  0,  0,  0, -1,  0,  0,  0,  0  },
                        {  0,  0,  2, -2,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  1,  0,  0,  0,  0, -1,  0,  0,  0  },
                        {  0,  8,-13,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  1, -2,  0,  0,  1,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, -1  }};
                        
  Arg_TB_B := FELD27_11 {{  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  },
                        {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0  }};
                                            
  ClearVar(Arg_TB_C);
                              Arg_TB_C[1,3]:=1;
                              Arg_TB_C[2,3]:=2;
                              Arg_TB_C[3,6]:=1;
                              Arg_TB_C[4,5]:=1;
                              Arg_TB_C[5,3]:=4;
                              Arg_TB_C[5,4]:=-8;
                              Arg_TB_C[5,5]:=3;
                              
                              
                              
  Arg_Tidal:= FELD62_5 {{ 1,0,2,2,2  },
                        { 2,0,2,0,1  },
                        { 2,0,2,0,2  },
                        { 0,0,2,2,1  },
                        { 0,0,2,2,2  },
                        { 1,0,2,0,0  },
                        { 1,0,2,0,1  },
                        { 1,0,2,0,2  },
                        { 3,0,0,0,0  },
                        { -1,0,2,2,1 },
                        { -1,0,2,2,2 },
                        { 1,0,0,2,0  },
                        { 2,0,2,-2,2 },
                        { 0,1,2,0,2  },
                        { 0,0,2,0,0  },
                        { 0,0,2,0,1  },
                        { 0,0,2,0,2  },
                        { 2,0,0,0,-1 },
                        { 2,0,0,0,0  },
                        { 2,0,0,0,1  },
                        { 0,-1,2,0,2 },
                        { 0,0,0,2,-1 },
                        { 0,0,0,2,0  },
                        { 0,0,0,2,1  },
                        { 0,-1,0,2,0 },
                        { 1,0,2,-2,1 },
                        { 1,0,2,-2,2 },
                        { 1,1,0,0,0  },
                        { -1,0,2,0,0 },
                        { -1,0,2,0,1 },
                        { -1,0,2,0,2 },
                        { 1,0,0,0,-1 },
                        { 1,0,0,0,0  },
                        { 1,0,0,0,1  },
                        { 0,0,0,1,0  },
                        { 1,-1,0,0,0 },
                        { -1,0,0,2,-1},
                        { -1,0,0,2,0 },
                        { -1,0,0,2,1 },
                        { 1,0,-2,2,-1},
                        { -1,-1,0,2,0},
                          
                        { 0,2,2,-2,2 },
                        { 0,1,2,-2,1 },
                        { 0,1,2,-2,2 },
                        { 0,0,2,-2,0 },
                        { 0,0,2,-2,1 },
                        { 0,0,2,-2,2 },
                        { 0,2,0,0,0  },
                        { 2,0,0,-2,-1},
                        { 2,0,0,-2,0 },
                        { 2,0,0,-2,1 },
                        { 0,-1,2,-2,1},
                        { 0,1,0,0,-1 },
                        { 0,-1,2,-2,2},
                        { 0,1,0,0,0  },
                        { 0,1,0,0,1  },
                        { 1,0,0,-1,0 },
                        { 2,0,-2,0,0 },
                        { -2,0,2,0,1 },
                        { -1,1,0,1,0 },
                        { 0,0,0,0,2  },
                        { 0,0,0,0,1  }};
                           
  Coeff_Tidal := FELD62 {  -0.024,
                    -0.040,
                    -0.099,
                    -0.051,
                    -0.123,
                    -0.039,
                    -0.411,
                    -0.993,
                    -0.018,
                    -0.082,
                    -0.197,
                    -0.076,
                     0.022,
                     0.025,
                    -0.299,
                    -3.208,
                    -7.757,
                     0.022,
                    -0.338,
                     0.018,
                    -0.024,
                     0.047,
                    -0.734,
                    -0.053,
                    -0.051,
                     0.050,
                     0.101,
                     0.039,
                     0.047,
                     0.177,
                     0.435,
                     0.534,
                    -8.261,
                     0.544,
                     0.047,
                    -0.055,
                     0.118,
                    -1.824,
                     0.132,
                     0.018,
                    -0.086,
                    
                    -0.057,
                     0.033,
                    -1.885,
                     0.251,
                     1.170,
                   -48.247,
                    -0.194,
                     0.049,
                    -0.547,
                     0.037,
                    -0.045,
                     0.092,
                     0.828,
                   -15.359,
                    -0.138,
                     0.035,
                    -0.137,
                     0.422,
                     0.040,
                     7.900,
                 -1617.268   };
   (* Based on YODER et al., 1981  ; 1991 IERS Annual Report, pp.I-19/29 *)
                 
  Coeff_Tidal_S1 := FELD62 {  -0.02,
                      -0.04,
                      -0.10,
                      -0.05,
                      -0.12,
                      -0.04,
                      -0.40,
                      -0.98,
                      -0.02,
                      -0.08,
                      -0.20,
                      -0.08,
                       0.02,
                       0.03,
                      -0.30,
                      -3.20,
                      -7.73,
                       0.02,
                      -0.34,
                       0.02,
                      -0.02,
                       0.05,
                      -0.72,
                      -0.05,
                      -0.05,
                       0.05,
                       0.10,
                       0.04,
                       0.05,
                       0.18,
                       0.44,
                       0.53,
                      -8.33,
                       0.54,
                       0.05,
                      -0.06,
                       0.12,
                      -1.84,
                       0.13,
                       0.02,
                      -0.09,
                      
                      -0.06,
                       0.03,
                      -1.88,
                       0.25,
                       1.17,
                     -48.84,
                      -0.19,
                       0.05,
                      -0.55,
                       0.04,
                      -0.05,
                       0.09,
                       0.83,
                     -15.55,
                      -0.14,
                       0.03,
                      -0.14,
                       0.42,
                       0.04,
                       7.90,
                   -1637.68};  (* Zonal Tide Terms UT1S incl. Ocean Effects
                                  (Dickmann 1991; n. IERS T.N.13, table 10.2 *)
                 
  ClearVar(Coeff_Tidal_S2);
  Coeff_Tidal_S2[ 7]:= 0.01;
  Coeff_Tidal_S2[ 8]:= 0.03;
  Coeff_Tidal_S2[16]:= 0.09;
  Coeff_Tidal_S2[17]:= 0.21;
  Coeff_Tidal_S2[23]:= 0.02;
  Coeff_Tidal_S2[33]:= 0.12;
  Coeff_Tidal_S2[38]:= 0.02;
  Coeff_Tidal_S2[47]:= 0.11;
  Coeff_Tidal_S2[55]:= 0.02;
  Coeff_Tidal_S2[62]:= 0.10;   (* Zonal Tide Terms , out-of-phase (cos) *)
                      
                                
  (* zu testzwecken *)
(*  RedirectOutput('D:\SUM3.DAT',FALSE);
  FOR i:=5 TO 1 BY -1 DO
    sum:=0.0;
    FOR j:= i TO 5 DO
      sum:=sum+C[j];
    END;
    WriteReal(sum,15,7); WriteLn;
  END;
  CloseOutput;   WriteReal(9999999.,20,10);
  REPEAT
    ReadLReal(JD);
    N:=Nutation(JD);
    WriteReal(N.Long,15,7); WriteLn;
    WriteReal(N.Obl,15,7); WriteLn;
  UNTIL JD<=0.0;  *)
END Astronomy.
*)

(**************************************************************************)


MODULE TIDAL;

FROM MathLib0 IMPORT sin,cos, sincos;
FROM InOut    IMPORT ReadLReal,WriteReal,WriteLn, RedirectOutput,CloseOutput;
FROM SysUtil0 IMPORT ClearVar;

TYPE FELD62    = ARRAY[1..62] OF LONGREAL;
     FELD62_5  = ARRAY[1..62],[1..5] OF SHORTINT;

VAR  Coeff_Tidal : FELD62;     (* YODER-TERMS *)
     Coeff_Tidal_S1 : FELD62;  (* ZONAL TIDES INCL. OCEAN EFFECTS *)
     Coeff_Tidal_S2 : FELD62;  (*  " , OUT OF PHASE               *)
     Arg_Tidal   : FELD62_5;   (* ARGUMENTS FOR TIDAL TERMS       *)

BEGIN
  Arg_Tidal:= FELD62_5 {{ 1,0,2,2,2  },
                        { 2,0,2,0,1  },
                        { 2,0,2,0,2  },
                        { 0,0,2,2,1  },
                        { 0,0,2,2,2  },
                        { 1,0,2,0,0  },
                        { 1,0,2,0,1  },
                        { 1,0,2,0,2  },
                        { 3,0,0,0,0  },
                        { -1,0,2,2,1 },
                        { -1,0,2,2,2 },
                        { 1,0,0,2,0  },
                        { 2,0,2,-2,2 },
                        { 0,1,2,0,2  },
                        { 0,0,2,0,0  },
                        { 0,0,2,0,1  },
                        { 0,0,2,0,2  },
                        { 2,0,0,0,-1 },
                        { 2,0,0,0,0  },
                        { 2,0,0,0,1  },
                        { 0,-1,2,0,2 },
                        { 0,0,0,2,-1 },
                        { 0,0,0,2,0  },
                        { 0,0,0,2,1  },
                        { 0,-1,0,2,0 },
                        { 1,0,2,-2,1 },
                        { 1,0,2,-2,2 },
                        { 1,1,0,0,0  },
                        { -1,0,2,0,0 },
                        { -1,0,2,0,1 },
                        { -1,0,2,0,2 },
                        { 1,0,0,0,-1 },
                        { 1,0,0,0,0  },
                        { 1,0,0,0,1  },
                        { 0,0,0,1,0  },
                        { 1,-1,0,0,0 },
                        { -1,0,0,2,-1},
                        { -1,0,0,2,0 },
                        { -1,0,0,2,1 },
                        { 1,0,-2,2,-1},
                        { -1,-1,0,2,0},
                          
                        { 0,2,2,-2,2 },
                        { 0,1,2,-2,1 },
                        { 0,1,2,-2,2 },
                        { 0,0,2,-2,0 },
                        { 0,0,2,-2,1 },
                        { 0,0,2,-2,2 },
                        { 0,2,0,0,0  },
                        { 2,0,0,-2,-1},
                        { 2,0,0,-2,0 },
                        { 2,0,0,-2,1 },
                        { 0,-1,2,-2,1},
                        { 0,1,0,0,-1 },
                        { 0,-1,2,-2,2},
                        { 0,1,0,0,0  },
                        { 0,1,0,0,1  },
                        { 1,0,0,-1,0 },
                        { 2,0,-2,0,0 },
                        { -2,0,2,0,1 },
                        { -1,1,0,1,0 },
                        { 0,0,0,0,2  },
                        { 0,0,0,0,1  }};
                           
  Coeff_Tidal := FELD62 {  -0.024,
                    -0.040,
                    -0.099,
                    -0.051,
                    -0.123,
                    -0.039,
                    -0.411,
                    -0.993,
                    -0.018,
                    -0.082,
                    -0.197,
                    -0.076,
                     0.022,
                     0.025,
                    -0.299,
                    -3.208,
                    -7.757,
                     0.022,
                    -0.338,
                     0.018,
                    -0.024,
                     0.047,
                    -0.734,
                    -0.053,
                    -0.051,
                     0.050,
                     0.101,
                     0.039,
                     0.047,
                     0.177,
                     0.435,
                     0.534,
                    -8.261,
                     0.544,
                     0.047,
                    -0.055,
                     0.118,
                    -1.824,
                     0.132,
                     0.018,
                    -0.086,
                    
                    -0.057,
                     0.033,
                    -1.885,
                     0.251,
                     1.170,
                   -48.247,
                    -0.194,
                     0.049,
                    -0.547,
                     0.037,
                    -0.045,
                     0.092,
                     0.828,
                   -15.359,
                    -0.138,
                     0.035,
                    -0.137,
                     0.422,
                     0.040,
                     7.900,
                 -1617.268   };
   (* Based on YODER et al., 1981  ; 1991 IERS Annual Report, pp.I-19/29 *)
                 
  Coeff_Tidal_S1 := FELD62 {  -0.02,
                      -0.04,
                      -0.10,
                      -0.05,
                      -0.12,
                      -0.04,
                      -0.40,
                      -0.98,
                      -0.02,
                      -0.08,
                      -0.20,
                      -0.08,
                       0.02,
                       0.03,
                      -0.30,
                      -3.20,
                      -7.73,
                       0.02,
                      -0.34,
                       0.02,
                      -0.02,
                       0.05,
                      -0.72,
                      -0.05,
                      -0.05,
                       0.05,
                       0.10,
                       0.04,
                       0.05,
                       0.18,
                       0.44,
                       0.53,
                      -8.33,
                       0.54,
                       0.05,
                      -0.06,
                       0.12,
                      -1.84,
                       0.13,
                       0.02,
                      -0.09,
                      
                      -0.06,
                       0.03,
                      -1.88,
                       0.25,
                       1.17,
                     -48.84,
                      -0.19,
                       0.05,
                      -0.55,
                       0.04,
                      -0.05,
                       0.09,
                       0.83,
                     -15.55,
                      -0.14,
                       0.03,
                      -0.14,
                       0.42,
                       0.04,
                       7.90,
                   -1637.68};  (* Zonal Tide Terms UT1S incl. Ocean Effects
                                  (Dickmann 1991; n. IERS T.N.13, table 10.2 *)
                 
  ClearVar(Coeff_Tidal_S2);
  Coeff_Tidal_S2[ 7]:= 0.01;
  Coeff_Tidal_S2[ 8]:= 0.03;
  Coeff_Tidal_S2[16]:= 0.09;
  Coeff_Tidal_S2[17]:= 0.21;
  Coeff_Tidal_S2[23]:= 0.02;
  Coeff_Tidal_S2[33]:= 0.12;
  Coeff_Tidal_S2[38]:= 0.02;
  Coeff_Tidal_S2[47]:= 0.11;
  Coeff_Tidal_S2[55]:= 0.02;
  Coeff_Tidal_S2[62]:= 0.10;   (* Zonal Tide Terms , out-of-phase (cos) *)
                      

END TIDAL.
