 (*$G+,C-*)
 module stichwort;
 (*$Z+, [-*)
 
 (* Stichwortverzeichnis einlesen und sortieren
 
#Format der Eingabedatei:
#{ LeadIn [SeitenNr] <cr> | Eintrag <cr> | LeadSpec cardinal SepSign String }
#
#Format der Ausgabedatei:
#{ Eintrag <tab> SeitenNr {',' SeitenNr} }
#
#Format einer SeitenNr:
#integer  SepSign  integer
#
#jm 5.10.87   erste Version
#jm 2.11.87   SeitenNr nach LeadIn optional; falls keine
0SeitenNr angegeben, wird Seite um 1 erhht;
0LeadSpec erlaubt Definition spezieller Kapitelnamen, die
0durch entspr. negative Kapitelnummern angesprochen werden
%10.12.87   Spaces vor Tabulatoren jetzt nicht mehr ntig
0(Signum2 verarbeitet TABs korrekt)
%09.10.90   Kapitelnummern knnen nun trotzdem Seitennummern haben
 *)
 
 from files         import file, access, replacemode, open, create, close, eof;
 import text, numberio, FuncStrings, strconv;
 from inout         import writestring, writeln, readstring, writecard;
 from strings       import Append, Compare, Relation, StrEqual, Delete,
8Assign, Empty, Lower, Length, Pos, PosLen, Copy;
 from easygem1 import selectfile;
 
 const   datsize = 5000;
(WortLen = 40;
(SepSign = '-';
)LeadIn = '#';
'LeadSpec = '$';
 
 type  String = ARRAY [0..255] OF CHAR;
&StringWortLen = ARRAY [0..WortLen] OF CHAR;
 
 type  eintrag = record
2stichwort: stringWortLen;
4kapitel,
6seite: integer
0end;
 
'daten = array [0..datsize] of eintrag;
%spIndex = integer [1..99];
 
 var     special: array spIndex of string;
(ok: BOOLEAN;
 
 PROCEDURE StrToInt (ref line: ARRAY OF CHAR): INTEGER;
"VAR p: CARDINAL;
"BEGIN
$p:= 0;
$RETURN StrConv.StrToInt (line, p, ok)
"END StrToInt;
 
 procedure prepare (s: ARRAY OF CHAR): string;
"var s1: string;
$i, j: cardinal;
"begin
$Lower (s);
$s1 := '';
$(*$R-*)
$for i:=0 to length (s)-1 do
&case s [i] of
('':  Append ('u', s1, ok); Append ('e', s1, ok) |
('':  Append ('a', s1, ok); Append ('e', s1, ok) |
('':  Append ('o', s1, ok); Append ('e', s1, ok) |
('':  Append ('s', s1, ok); Append ('s', s1, ok) |
&else
(Append (s [i], s1, ok)
&end
$end;
$(*$R=*)
$return s1
"end prepare;
 
 procedure gross (ref d1, d2: eintrag): boolean;
"begin
$if strequal (d1.stichwort, d2.stichwort) then
&if d1.kapitel = d2.kapitel then
(return d1.seite > d2.seite
&else
(return d1.kapitel > d2.kapitel
&end
$else
&return Compare (prepare (d1.stichwort), prepare (d2.stichwort)) = greater
&(*
(return Compare (FuncStrings.LowStr (d1.stichwort),
8FuncStrings.LowStr (d2.stichwort)) = greater
&*)
$end;
"end gross;
"
 
 procedure mischSort (var d, hilf: daten; start, len: cardinal);
"
"var   start2, len2, i, j, k: cardinal;
"
"begin
$if len > 1 then
&len2 := len div 2;
&start2 := start + len2;
&mischSort (d, hilf, start, len2);
&mischSort (d, hilf, start2, len - len2);
&
&(* solange in beiden Hlften Daten, zusammenmischen *)
&
&i := start;
&j := start2;
&k := 0;
&while (i < start2) & (j < start+len) do
(if gross (d [i], d[j]) then
*hilf [k] := d [j]; inc (j)
(else
*hilf [k] := d [i]; inc (i)
(end;
(inc (k)
&end;
&
&(* Rest aus briggebliebener Hlfte bernehmen *)
&
&if i < start2 then
(repeat
*hilf [k] := d [i]; inc (k); inc (i)
(until k = len
&else  (* mu Rest bei j sein *)
(repeat
*hilf [k] := d [j]; inc (k); inc (j)
(until k = len
&end;
*
&(* aus dem Hilfsfeld zurckkopieren *)
&
&for k := 0 to len -1 do
(d [start+k] := hilf [k]
&end;
$
$end (* if nichttrivial *)
"end mischSort;
$
 
 procedure einlesen (var d: daten; var len: cardinal);
"
"var    f: file;
&line: string;
'kap,
'sei,
)i: integer;
 
"begin
$kap := 1;
$sei := 1;
$len := 0;
$line:= 'index.roh';
$Selectfile ('Roh-Datei?', line, ok);
$IF NOT ok THEN RETURN END;
$Open (f, line, readSeqTxt);
$while not eof (f) do
&Text.Readstring (f, line);
&if not eof (f) then
(if line [0] = LeadIn then
*delete (line, 0, 1, ok);
*if not empty (FuncStrings.EatSpc (line)) then
,kap := StrToInt (line);
,delete (line, 0, pos (sepsign, line, 1)+1, ok);
,sei := StrToInt (line);
*else
,inc (sei)
*end
(elsif line [0] = LeadSpec then
*delete (line, 0, 1, ok);
*i := StrToInt (line);
*delete (line, 0, pos (sepsign, line, 0)+1, ok);
*special [i] := line
(elsif (line[0] # 0C) then
*with d [len] do
,copy (line, 0, WortLen, stichwort, ok);
,kapitel := kap;
,seite := sei;
*end;
*inc (len)
(end;
&end
$end;
$close (f);
"end einlesen;
"
 
 procedure mypos (ref target, source: array of char): INTEGER;
"var p: INTEGER;
"begin
$return poslen (target, source, 0);
$(*
&p := pos (target, source, 0);
&if p >= 0 then
(return p
&else
(return length (source)
&end
$*)
"end mypos;
"
 
 procedure schreiben (var d: daten; len: cardinal);
"
"const   tab = 9c;
"
"var   i: cardinal;
(f: file;
%help,
%last,
%lead: stringWortLen;
%name: String;
$first,
"myfirst: char;
&
"procedure fwritepage (f: file; k, s: integer);
$begin
&if k >= 0 then
(NumberIO.Writeint (f, k, 0);
&else
(Text.Writestring (f, special [-k])
&end;
&if s > 0 then
(Text.Write (f, sepsign);
(NumberIO.Writeint (f, s, 0);
&end
$end fwritepage;
$
"begin
$i := 0;
$last := '';
$lead := 'xxx';
$first := 'z';
$name:= 'index.gar';
$Selectfile ('Gar-Datei?', name, ok);
$IF NOT ok THEN RETURN END;
$Create (f, name, writeSeqTxt, replaceOld);
$while i < len do
&with d [i] do
(myfirst := cap (stichwort [0]);
(case myfirst of
*'': myfirst:= 'A'|
*'': myfirst:= 'O'|
*'': myfirst:= 'U'
(else
(end;
(if myfirst # first then
*first := myfirst;
*Text.Writeln (f); Text.Writeln (f);
*Text.Writestring (f, first);
*Text.Writeln (f);
(end;
(if strequal (stichwort, last) then
*Text.Writestring (f, ', ');
*fwritepage (f, kapitel, seite);
(else
*copy (stichwort, 0, mypos (',', stichwort), help, ok);
*if strequal (help, lead) then
,Text.Writeln (f);
,Text.Writestring (f, '  - ');
,copy (stichwort, mypos (',', stichwort)+1, 99, help, ok);
,Text.Writestring (f, help);
,Text.Writestring (f, tab);
,fwritepage (f, kapitel, seite);
,last := stichwort;
*else
,Text.Writeln (f);
,Text.Writestring (f, stichwort);
,Text.Writestring (f, tab);
,fwritepage (f, kapitel, seite);
,last := stichwort;
,copy (stichwort, 0, mypos (',', stichwort), lead, ok);
*end;
(end
&end (* with *);
&inc (i)
$end (* while *);
$Text.Writeln (f);
$close (f);
"end schreiben;
(
(
 var  Liste, Hilf: Daten;
,size: cardinal;
,
 begin
"einlesen  (liste, size);
"writeln; writecard (size, 5); writestring (' Eintrge gelesen');
"
"mischsort (liste, hilf, 0, size);
"writeln; writestring (' ... sortiert');
"
"schreiben (liste, size);
"writeln; writestring (' ... geschrieben');
 end Stichwort.
 
  
(* $FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$00000977$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$FFEB289F$00000713T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000856$000006FA$FFEDCE26$FFEDCE26$FFEDCE26$000006B1$00000856$0000002C$0000071D$00000713$00000856$0000002C$FFEDCE26$00000419$FFEDCE26$00000862*)
