 
 (* Autor: Ulf Reimann, Am Faerberhof 11, 8520 Erlangen *)
 (* Gepard -> Atari-Anpassung: Thomas Tempelmann *)
 
 (*
!* Huffmann-Kodierung
!*
!* Achtung: Kann keine Null-Bytes verarbeiten! Daher nur fr Texte,
!* nicht fr Binrdateien geeignet!
!*)
 
 MODULE Pack;
 (*$Q+,C-*)
 
 FROM SYSTEM IMPORT ADDRESS, ASSEMBLER;
 
 IMPORT Storage;
 IMPORT Text;
 FROM InOut      IMPORT WriteString, WriteLn, WriteCard, BusyRead,
8Write, KeyPressed, ReadString;
 FROM Files      IMPORT Open, Close, Remove, Access, Create,
8EOF, ReplaceMode, File;
 FROM Binary     IMPORT Seek, SeekMode, ReadBytes, WriteBytes, FileSize;
 FROM Files      IMPORT GetStateMsg, State;
 FROM Strings    IMPORT Compare, Relation, StrEqual, Length, Append,
8String, Space, Empty, Assign;
 
 TYPE    MaxStr = ARRAY [0..99] OF CHAR;
 
 VAR strok: BOOLEAN;
 
 TYPE charset=SET OF [0C..255C];
%pms=POINTER TO MaxStr;
%noderef=POINTER TO node;
%node=
'RECORD
)cnt:LONGCARD;
)bitcnt:CARDINAL;
)bitstr:BitSet;
)left:noderef;
)right:noderef;
)key:pms;
'END;
%coderef=POINTER TO code;
%code=
'RECORD
)left:coderef;
)right:coderef;
)CASE :CARDINAL OF
)0: nod:noderef |
)1: key:pms
)END
'END;
%itemref=POINTER TO item;
%item=
'RECORD
)cnt:LONGCARD;
)cod:coderef;
)nxt:itemref;
)next:itemref
'END;
 
 CONST alpha=charset{'0'..'9','@','A'..'Z','_','a'..'z'};
 
 VAR f,outf:File;
$filename,ofilename:MaxStr;
$warning,wordmode:BOOLEAN;
$ioerr,blocks,bitptr,stotal:CARDINAL;
$minmem,bytes,chars,treesize,codesize:LONGCARD;
$bufptr,pbuf:ADDRESS;
$noderoot:noderef;
$itemroot:itemref;
$coderoot:coderef;
 
 (*$L-,R-*)
 
 PROCEDURE putbyte(b:CARDINAL);
 BEGIN
 ASSEMBLER
#MOVE.L  bufptr,A0
#MOVE    -(A3),D0
#MOVE.B  D0,(A0)+
#MOVE.L  A0,bufptr
 END
 END putbyte;
 
 PROCEDURE putlong(b:LONGCARD);
 BEGIN
 ASSEMBLER
#MOVE.L  bufptr,A0
#MOVE.L  -(A3),(A0)+
#MOVE.L  A0,bufptr
 END
 END putlong;
 
 PROCEDURE putstring(s:pms);
 BEGIN
 ASSEMBLER
#MOVE.L  bufptr,A0
#MOVE.L  -(A3),A1
 lp MOVE.B  (A1)+,(A0)+
#BNE     lp
 ok MOVE.L  A0,bufptr
 END
 END putstring;
 
 PROCEDURE putbit(b:BOOLEAN);
 BEGIN
 ASSEMBLER
#MOVE.L  bufptr,A0
#MOVE    bitptr,D0
#TST     -(A3)
#BNE     b1
#BSET    D0,(A0)
#BRA     b2
 b1 BCLR    D0,(A0)
 b2 ADDQ    #1,D0
#ANDI    #7,D0
#BNE     b3
#ADDQ.L  #1,A0
#MOVE.L  A0,bufptr
 b3 MOVE    D0,bitptr
 END
 END putbit;
 
 PROCEDURE getbit:BOOLEAN;
 BEGIN
 ASSEMBLER
#MOVE.L  bufptr,A0
#MOVE    bitptr,D0
#MOVEQ   #0,D1
#BTST    D0,(A0)
#SNE     D1
 b2 ADDQ    #1,D0
#ANDI    #7,D0
#BNE     b3
#ADDQ.L  #1,A0
#MOVE.L  A0,bufptr
 b3 MOVE    D0,bitptr
#NEG.B   D1
#MOVE    D1,(A3)+
 END
 END getbit;
 
 PROCEDURE getbyte():CHAR;
 BEGIN
 ASSEMBLER
#MOVE.L  bufptr,A0
#MOVEQ   #0,D0
#MOVE.B  (A0)+,D0
#MOVE.L  A0,bufptr
#MOVE.B  D0,(A3)+
#ADDQ.L  #1,A3
 END
 END getbyte;
 
 PROCEDURE getlong(VAR b:LONGCARD);
 BEGIN
 ASSEMBLER
#MOVE.L  bufptr,A0
#MOVE.L  -(A3),A1
#MOVE.L  (A0)+,(A1)
#MOVE.L  A0,bufptr
 END
 END getlong;
 
 PROCEDURE getstring(VAR s:MaxStr);
 BEGIN
 ASSEMBLER
#MOVE.L  bufptr,A0
#MOVE.L  -(A3),A1
 lp MOVE.B  (A0)+,(A1)+
#BNE     lp
 ok MOVE.L  A0,bufptr
 END
 END getstring;
 
 (*$L+,R=*)
 
 PROCEDURE Lex(VAR s1,s2:ARRAY OF CHAR):INTEGER;
"BEGIN
$RETURN INTEGER (ORD (Compare (s1,s2))) - 1
"END Lex;
 
 PROCEDURE LEN(VAR s:ARRAY OF CHAR):CARDINAL;
"BEGIN
$RETURN Length (s)
"END LEN;
 
 PROCEDURE KbRead (VAR ch:CHAR);
"BEGIN
$REPEAT
&BusyRead (ch)
$UNTIL ch#0C
"END KbRead;
 
 PROCEDURE WriteRpt (n:CARDINAL;c:CHAR);
"VAR i: CARDINAL;
"BEGIN
$FOR i:= 1 TO n DO
&Write (c)
$END
"END WriteRpt;
 
 PROCEDURE Allocate(VAR a:ADDRESS; s:LONGCARD);
 BEGIN
"Storage.Allocate(a,s);
"IF a=NIL THEN WriteString('Out of mem');HALT END;
"IF Storage.MemAvail() < minmem THEN
$minmem:= Storage.MemAvail()
"END
 END Allocate;
 
 PROCEDURE DeAllocate(VAR a:ADDRESS; s:LONGCARD);
 BEGIN
"Storage.DeAllocate(a,s)
 END DeAllocate;
 
 PROCEDURE isOK(f:File;abort:BOOLEAN):BOOLEAN;
 VAR s:String;
 BEGIN
"IF State (f) < 0 THEN
$GetStateMsg (State(f),s);
$WriteLn;
$WriteString (s);
$WriteLn;
$IF abort THEN HALT END;
$RETURN false
"ELSE
$RETURN true
"END
 END isOK;
 
 (*$D-*)
 PROCEDURE search(VAR symbol:MaxStr);
"PROCEDURE subsearch(VAR n1:noderef);
$VAR n:noderef;
"BEGIN
$n:=n1;
$IF n=NIL THEN
&NEW(n);
&WITH n^ DO
(Allocate(key,LONG(LEN(symbol)+1));
(Assign (symbol,key^,strok);
(cnt:=1L; bitcnt:=0; bitstr:=BitSet{}; left:=NIL; right:=NIL
&END;
&n1:=n;
&INC(stotal)
$ELSE
&CASE Lex(symbol,n^.key^) OF
&-1:subsearch(n^.left)|
'1:subsearch(n^.right)|
'0:INC(n^.cnt)
&END
$END
"END subsearch;
 BEGIN
"IF ~Empty(symbol) THEN
$subsearch(noderoot);
$symbol:=''
"END
 END search;
 (*$D-*)
 
 PROCEDURE gentree;
"VAR ch:CHAR; symbol:MaxStr;
 (*$D-*)
 BEGIN
"symbol:=''; chars:=0L; stotal:=0; noderoot:=NIL;
"LOOP
$Text.Read(f,ch); INC(chars);
$IF isOK(f,true) THEN END;
$IF EOF(f) THEN search(symbol); EXIT
$ELSIF wordmode & (ch IN alpha) THEN Append(ch,symbol,strok);
$ELSIF ch#0C THEN search(symbol); Assign (ch, symbol, strok); search(symbol)
$ELSE warning:=true
$END
"END
 END gentree;
 (*$D-*)
 
 PROCEDURE sorttree(VAR itemroot:itemref; noderoot:noderef);
"PROCEDURE subsort(n:noderef);
$PROCEDURE sortin(VAR i:itemref);
&VAR i1:itemref;
$BEGIN
&IF (i=NIL) OR (n^.cnt<i^.cnt) THEN
(NEW(i1);
(WITH i1^ DO
*cnt:=n^.cnt;
*nxt:=i;
*next:=i;
*NEW(cod);
*WITH cod^ DO
,cnt:=n^.cnt;
,nod:=n;
,left:=NIL;
,right:=NIL;
*END
(END;
(i:=i1
&ELSE
(sortin(i^.next);
(i^.nxt:=i^.next
&END
$END sortin;
"BEGIN
$IF n#NIL THEN
&subsort(n^.left);
&sortin(itemroot);
&subsort(n^.right);
$END
"END subsort;
 BEGIN
"itemroot:=NIL;
"subsort(noderoot)
 END sorttree;
 
 PROCEDURE codetree(VAR c:coderef; i:itemref; s:CARDINAL);
"VAR i1:itemref; sum:LONGCARD;
"PROCEDURE codesortin(VAR i:itemref);
"BEGIN
$IF (i=NIL) OR (sum<i^.cnt) THEN
&i1^.next:=i;
&i:=i1
$ELSE
&codesortin(i^.next);
$END
"END codesortin;
 (*$D-*)
 BEGIN
"WHILE s>1 DO
$NEW(c);
$WITH c^ DO
&nod:=NIL; left:=i^.cod; right:=i^.next^.cod;
&IF (left = NIL) OR (right = NIL) THEN HALT END;
$END;
$sum:=i^.cnt+i^.next^.cnt;
$i1:=i;
$i:=i^.next^.next;
$WITH i1^ DO
&cnt:=sum; cod:=c;
$END;
$codesortin(i);
$DEC(s)
"END
 END codetree;
 (*$D-*)
 
 PROCEDURE itemdisp(i:itemref);
"VAR i1:itemref;
 BEGIN
"WHILE i#NIL DO
$i1:=i^.nxt;
$DISPOSE(i);
$i:=i1
"END
 END itemdisp;
 
 PROCEDURE nodedisp(n:noderef);
 BEGIN
"IF n#NIL THEN
$WITH n^ DO
&DISPOSE(key);
&nodedisp(left);
&nodedisp(right);
$END;
$DISPOSE(n)
"END
 END nodedisp;
 
 PROCEDURE codedisp(c:coderef);
 BEGIN
"WITH c^ DO
$IF nod=NIL THEN
&codedisp(left);
&codedisp(right);
$END;
$DISPOSE(c)
"END
 END codedisp;
 
 PROCEDURE dcodedisp(c:coderef);
 BEGIN
"WITH c^ DO
$IF nod=NIL THEN
&dcodedisp(left);
&dcodedisp(right);
$ELSE
&DeAllocate(key,0L)
$END;
$DISPOSE(c)
"END
 END dcodedisp;
 
 PROCEDURE measure(c:coderef; depth:CARDINAL):LONGCARD;
 VAR l:LONGCARD;
 (*$D-*)
 BEGIN
"WITH c^ DO
$IF nod=NIL THEN
&INC(treesize);
&l:=measure(ADDRESS(left),depth+1)+measure(ADDRESS(right),depth+1);
&RETURN l
$ELSE
&WITH nod^ DO
(INC(treesize);
(IF wordmode THEN INC(treesize,LEN(key^)) END;
(RETURN LONG(depth)*cnt
&END
$END
"END
 END measure;
 (*$D-*)
 
 PROCEDURE makebuffer(VAR buf:ADDRESS; bsize:LONGCARD; VAR blocks:CARDINAL);
 BEGIN
"blocks:=SHORT((bsize+1023L) DIV 1024L);
"Allocate(buf,1024L*LONG(blocks+1));
 END makebuffer;
 
 
 PROCEDURE putcodetree(codesize:LONGCARD; coderoot:coderef);
"PROCEDURE subput(c:coderef; dep:CARDINAL; str:BitSet);
"BEGIN
$WITH c^ DO
&IF nod=NIL THEN
(putbyte(0);
(subput(left, dep+1, str);
(INCL(str,dep);
(subput(right, dep+1, str)
&ELSE
(WITH nod^ DO
*IF wordmode THEN putstring(key) ELSE putbyte(ORD(key^[0])) END;
*bitcnt:=dep-1;
*bitstr:=str
(END
&END
$END
"END subput;
 BEGIN
"putlong(codesize);
"putbyte(ORD(wordmode));
"subput(coderoot, 0, BitSet{})
 END putcodetree;
 
 PROCEDURE getcodetree(VAR csize:LONGCARD; VAR croot:coderef);
"VAR symbol:MaxStr; c:coderef; wordflag:BOOLEAN; ch:CHAR;
"PROCEDURE subget(VAR c:coderef);
"BEGIN
$NEW(c);
$WITH c^ DO
&IF wordflag THEN
(getstring(symbol);
(IF LEN(symbol)=0 THEN
*key:=NIL; subget(left); subget(right)
(ELSE
*Allocate(key,LONG(LEN(symbol)+1));
*Assign (symbol,key^,strok);
*left:=NIL; right:=NIL
(END
&ELSE
(ch:=getbyte();
(IF ch=0C THEN
*key:=NIL; subget(left); subget(right)
(ELSE
*Allocate(key,2L);
*Assign (ch, key^, strok);
*left:=NIL; right:=NIL
(END
&END
$END
"END subget;
 BEGIN
"getlong(csize);
"wordflag:= BOOLEAN (ORD(getbyte()));
"subget(croot)
 END getcodetree;
 
 PROCEDURE encode;
"VAR ch:CHAR; symbol:MaxStr;
"PROCEDURE encsym(n:noderef);
$VAR i:CARDINAL;
"BEGIN
$IF LEN(symbol)>0 THEN
&LOOP
(IF n=NIL THEN WriteString('Serious error'); HALT
(ELSE
*CASE Lex(symbol,n^.key^) OF
*-1:n:=n^.left |
+1:n:=n^.right |
+0:FOR i:=0 TO n^.bitcnt DO putbit(i IN n^.bitstr) END; EXIT
*END
(END
&END;
&symbol:=''
$END
"END encsym;
 BEGIN
"bitptr:=0; symbol:='';
"LOOP
$Text.Read(f,ch);
$IF isOK(f,true) THEN END;
$IF EOF(f) THEN encsym(noderoot); EXIT
$ELSIF wordmode & (ch IN alpha) THEN Append (ch,symbol,strok)
$ELSIF ch#0C THEN encsym(noderoot); Assign (ch, symbol, strok); encsym(noderoot)
$ELSE warning:=true
$END
"END
 END encode;
 
 PROCEDURE decode(disp:BOOLEAN);
"VAR c:coderef; lines:CARDINAL; cr:MaxStr; stop,flow:BOOLEAN; ch:CHAR;
 BEGIN
"getcodetree(codesize,coderoot);
"bitptr:=0;
"c:=coderoot;
"cr:=15C;
"lines:=0;
"stop:=false;
"flow:=false;
"LOOP
$IF codesize=0L THEN EXIT END;
$IF getbit() THEN
&c:=c^.left
$ELSE
&c:=c^.right
$END;
$DEC(codesize);
$IF c^.key#NIL THEN
&WITH c^ DO
(IF disp THEN
*WriteString(key^);
*IF (LEN(key^)=1) & StrEqual(key^,cr) THEN
,INC(lines);
,BusyRead (ch);
,IF ch#0C THEN
.flow:=false; stop:=true
,ELSIF NOT flow & (stop OR (lines>20)) THEN
.WriteString(' More. /?/ for help');
.KbRead(ch);
.WriteRpt(19,10C);WriteRpt(19,' ');WriteRpt(19,10C);
.IF ch='?' THEN
0WriteString('/space/ to stop, /return/ for flow, ');
0WriteString('letter for 10 lines, ctrl-key for 20');
0WriteLn
.ELSIF ch>' ' THEN
0lines:=10; stop:=false; flow:=false;
.ELSE
0IF ch=' ' THEN
2stop:=true; flow:=false;
0ELSIF ch=33C THEN EXIT
0ELSIF ch=15C THEN
2flow:=true; stop:=false;
0END;
0lines:=0
.END;
,END
*END
(ELSE
*Text.WriteString(outf,key^)
(END
&END;
&c:=coderoot
$END
"END;
"dcodedisp(coderoot);
 END decode;
 
 PROCEDURE packfile;
"VAR ch:CHAR;
 BEGIN
"minmem:=Storage.MemAvail();
"filename:='';
"WriteString('Pack what text? ');
"ReadString (filename);
"IF Empty (filename) THEN RETURN END;
"WriteLn;
"WriteString('Use W(ord or C(har-packing algorithm? ');
"REPEAT KbRead(ch); UNTIL CAP(ch) IN charset{'W','C',33C};
"IF ch=33C THEN RETURN END;
"Write(ch); WriteLn; WriteLn;
"wordmode:=CAP(ch)='W';
"Open(f,filename,readOnly);
"IF isOK(f,false) THEN
$(* AssignString(ofilename,LEN(ofilename)-3,'Pack'); *)
$WriteString('output-filename? ');
$ReadString (ofilename);
$IF Empty (ofilename) THEN
&Close(f); RETURN
$END;
$warning:=false;
$WriteLn;
$WriteString('first pass.');WriteLn;
$gentree;
$IF warning THEN
&WriteString('Warning: ASCII-Null ignored!');WriteLn;
$END;
$WriteString('sorting.');WriteLn;
$sorttree(itemroot,noderoot);
$WriteString('building code.');WriteLn;
$codetree(coderoot,itemroot,stotal);
$treesize:=5L; codesize:=measure(coderoot,0);
$itemdisp(itemroot);
$bytes:=treesize+(codesize+7L) DIV 8L;
$makebuffer(pbuf,bytes,blocks);
$bufptr:=pbuf;
$putcodetree(codesize,coderoot);
$codedisp(coderoot);
$Seek (f,0,fromBegin);
$IF isOK(f,false) THEN
&WriteString('second pass.');WriteLn;
&encode;
&Create(outf,ofilename,writeOnly,replaceOld);
&IF isOK(outf,false) THEN
(WriteBytes(outf,pbuf,LONG(blocks)*1024L);
(IF isOK(outf,false) THEN
*DeAllocate(pbuf,0L);
*Close(outf);
*IF isOK(outf,false) THEN
,(*
.WriteString('maximum memory used:');
.WriteCard(Storage.MemAvail()-minmem,7);WriteLn;
,*)
,WriteString('chars read         :');
,WriteCard(chars,7);WriteLn;
,WriteString('unique symbols     :');
,WriteCard(stotal,7);WriteLn;
,WriteString('bytes written      :');
,WriteCard(bytes,7);WriteLn;
,WriteString('percentage         :');
,WriteCard((100L*bytes) DIV chars,7); WriteLn
*END
(ELSE
*Remove(outf)
(END
&ELSE
(Remove (outf)
&END;
&nodedisp(noderoot);
&Close(f)
$END
"END
 END packfile;
 
 PROCEDURE unpackfile;
 VAR bread:LONGCARD;
 BEGIN
"filename:='';
"WriteString('Unpack what file? ');
"ReadString (filename);
"IF Empty (filename) THEN RETURN END;
"WriteLn;
"Open(f,filename,readOnly);
"IF isOK(f,false) THEN
$makebuffer(pbuf,FileSize(f),blocks);
$bufptr:=pbuf;
$ReadBytes(f,pbuf,LONG(blocks)*1024L,bread);
$IF isOK(f,false) THEN
&Close(f);
&ofilename:='';
&WriteString('To what file ? ');
&ReadString (ofilename);
&IF ~Empty (ofilename) THEN
(Create(outf,ofilename,writeSeqTxt,replaceOld);
(IF isOK(outf,false) THEN
*decode(false);
*Close(outf)
(END
&END
$ELSE
&Close(f)
$END;
$DeAllocate(pbuf,0L)
"END (* IF isOK *)
 END unpackfile;
 
 
 VAR ch:CHAR;
 
 BEGIN
"LOOP
$WriteLn;
$WriteString('Do you want to... P(ack, U(npack or Q(uit ? ');
$REPEAT
&KbRead(ch)
$UNTIL CAP(ch) IN charset{'P','U','Q',33C};
$WriteLn; WriteLn;
$IF CAP(ch)='P' THEN packfile
$ELSIF CAP(ch)='U' THEN unpackfile
$ELSE EXIT
$END
"END;
"WriteString('Bye.');
"WriteLn
 END Pack.
  
(* $00001813$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$00002FAC$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$00001B8C$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$FFFC8A4A$00002FBFT.......T.......T.......TT......T.......T.......T.......T.......T.......T.......$0000014F$00002FA9$00002F61$00002FBF$0000184F$00001BE9$FFEE44C4$FFEE44C4$00000CF6$00000D23$00000D68$00000D7C$00000D87$00000CB9$00000100$0000004E*)
