 MODULE CompDeb;
 
 (*$H+,Z+*)
 
 (*$N+*)
 IMPORT Runtime;
 FROM SYSTEM IMPORT ASSEMBLER, LONGWORD;
 FROM ShellMsg IMPORT CompilerArgs;
 FROM EasyExceptions IMPORT Call, Exception, StdErrNo, NormalReturn;
 FROM HdlError IMPORT GetErrorMsg;
 FROM ModCtrl IMPORT FirstModuleStart, ReleaseModule, InstallModule;
 FROM MOSGlobals IMPORT MEM, MemArea;
 FROM CompTree IMPORT TreeBase, DisplayStack, RelocationStack, NoItem,
(TreeType, ScanWholeTree, PtrItem, ScanItem, Flags, Kind,
(GetItemDesc, ItemDesc, ItemEntry, EntryType, FindItemByName,
(SystemType, ScanLocalTree, GetNameOfItem;
 FROM Terminal IMPORT WriteString, Write, Read, WriteLn, BusyRead,
(ReadString, WritePg;
 FROM StrConv IMPORT CardToStr, LHexToStr;
 FROM AESForms IMPORT FormAlert;
 FROM Strings IMPORT String, Space;
 
 VAR ok: BOOLEAN;
$wsp, termwsp: MemArea;
$stack: ARRAY [1..50000] OF CARDINAL; (* 100 KB Stack *)
$s: String;
$exc: Exception;
$ch: CHAR;
$Indent: CARDINAL;
 
 PROCEDURE WriteCard (l: LONGCARD; n: CARDINAL);
"BEGIN
$WriteString (CardToStr (l, n))
"END WriteCard;
 
 PROCEDURE WriteHex (l: LONGWORD; n: CARDINAL);
"BEGIN
$WriteString (LHexToStr (l, n))
"END WriteHex;
 
 PROCEDURE WriteIndent;
"BEGIN
$WriteString (Space (Indent));
"END WriteIndent;
 
 FORWARD WriteItem (item: PtrItem);
 
 
 PROCEDURE showName (REF name: ARRAY OF CHAR; item: PtrItem);
"BEGIN
$WriteString (name);
$Write (' ');
$BusyRead (ch);
$IF ch # 0C THEN Read (ch) END
"END showName;
 
 PROCEDURE showNameAndDef (REF name: ARRAY OF CHAR; item: PtrItem);
"BEGIN
$WriteLn;
$WriteIndent;
$WriteString (name);
$Write (' ');
$WriteItem (item);
$BusyRead (ch);
$IF ch # 0C THEN
&Read (ch)
$END;
"END showNameAndDef;
 
 
 CONST maxRek = 3;
 
 VAR rek: [0..maxRek];
$ptrStack: ARRAY [1..maxRek] OF PtrItem;
 
 PROCEDURE WriteItem (item: PtrItem);
"
"VAR wasRelay: BOOLEAN;
"
"PROCEDURE processed (item: PtrItem): BOOLEAN;
$(* erkennt Rekusionen *)
$VAR i: [0..maxRek];
$BEGIN
&FOR i:= 1 TO rek DO
(IF item = ptrStack[i] THEN
*RETURN TRUE
(END
&END;
&IF rek = maxRek THEN
(RETURN TRUE
&END;
&INC (rek);
&ptrStack[rek]:= item;
&RETURN FALSE
$END processed;
$
"PROCEDURE scanItem (REF entry: ItemEntry; more: BOOLEAN);
$VAR desc: ItemDesc; ok: BOOLEAN; s: String;
$BEGIN
&WITH entry DO
(IF wasRelay THEN
*WriteItem (ptrVal);
*RETURN
(END;
(IF type = const THEN
*WriteCard (constVal, 0)
(ELSIF type = pointer THEN
*IF GetItemDesc (ptrVal, desc) THEN
,WriteString (Kind (desc));
,IF NOT SystemType (desc) THEN
.GetNameOfItem (ptrVal, s, ok);
.IF ok THEN
0Write (':');
0WriteString (s)
.END;
.IF NOT processed (ptrVal) THEN
0WriteString (' (> ');
0ScanItem (scanItem, ptrVal);
0WriteString (' <) ');
0DEC (rek)
.END;
,END;
*ELSE
,WriteString ('NIL')
*END;
(ELSE
*WriteString (' << Local scope: ');
*INC (Indent, 4);
*IF ptrVal # 0 THEN
,IF NOT processed (ptrVal) THEN
.ScanLocalTree (showNameAndDef, ptrVal);
.DEC (rek)
,END;
*END;
*DEC (Indent, 4);
*WriteString (' >> ');
(END
&END;
&IF more THEN Write (' ') END;
$END scanItem;
 
"VAR desc: ItemDesc;
 
"BEGIN
$IF GetItemDesc (item, desc) THEN;
&wasRelay:= desc.kind = 0;
&WriteHex (item, 7); Write (':');
&WriteString (Kind (desc));
&WriteString (' (');
&WriteString (Flags (desc));
&Write (')');
&WriteLn;
&IF NOT processed (item) THEN
(WriteIndent;
(WriteString (' (');
(ScanItem (scanItem, item);
(Write (')');
(DEC (rek)
&END;
$ELSE
&WriteString ('NIL')
$END;
"END WriteItem;
 
 
 PROCEDURE WriteAll (full: BOOLEAN);
 
"PROCEDURE newTree (typ: TreeType): BOOLEAN;
$BEGIN
&WriteLn;
&CASE typ OF
&| local: WriteString ('** local **')
&| global: WriteString ('** global **')
&| newscope: WriteString ('** new scope **')
&| module: WriteString ('** module **')
&| pervasive: WriteString ('** pervasive **')
&END;
&IF ~full THEN WriteLn END;
&RETURN (typ <= module)
$END newTree;
"
"BEGIN
$IF full THEN
&ScanWholeTree (showNameAndDef, newTree)
$ELSE
&WriteIndent;
&ScanWholeTree (showName, newTree)
$END;
$WriteLn;
$WriteString ('EOT.');
"END WriteAll;
 
 PROCEDURE GetPtr (item: PtrItem): BOOLEAN;
"VAR ok: BOOLEAN;
"BEGIN
$HALT;
$RETURN FALSE
"END GetPtr;
 
 PROCEDURE WriteName (item: PtrItem);
"VAR ok: BOOLEAN; name: String;
"BEGIN
$GetNameOfItem (item, name, ok);
$IF ok THEN
&WriteString (name)
$ELSE
&WriteString ("No item")
$END
"END WriteName;
 
 PROCEDURE GetName (VAR item: PtrItem): BOOLEAN;
"VAR name: String;
"BEGIN
$WriteString ('Name? ');
$ReadString (name);
$FindItemByName (name, item);
$IF item # NoItem THEN
&RETURN TRUE
$ELSE
&WriteLn;
&WriteString ('Not found!');
&RETURN FALSE
$END
"END GetName;
 
 PROCEDURE Menu;
 
"PROCEDURE list;
$BEGIN
&WriteString ('TreeBase: '); WriteHex (TreeBase, 7); WriteLn;
&WriteString ('S: short list of all items'); WriteLn;
&WriteString ('L: long  list of all items'); WriteLn;
&WriteString ('N: list item by name'); WriteLn;
&WriteString ('P: list item by ptr'); WriteLn;
&WriteString ('Q: quit'); WriteLn;
$END list;
 
"VAR item: PtrItem;
"BEGIN
$WriteLn;
$list;
$LOOP
&LOOP
(BusyRead (ch);
(IF CAP (ch) = 'Q' THEN
*RETURN
(ELSIF CAP (ch) = 'S' THEN
*WriteAll (FALSE); EXIT
(ELSIF CAP (ch) = 'L' THEN
*WriteAll (TRUE); EXIT
(ELSIF CAP (ch) = 'N' THEN
*IF GetName (item) THEN
,WriteString (': ');
,WriteItem (item)
*END;
*EXIT
(ELSIF CAP (ch) = 'P' THEN
*IF GetPtr (item) THEN
,WriteName (item);
,WriteString (': ');
,WriteItem (item)
*END;
*EXIT
(ELSIF ch = ' ' THEN
*EXIT
(END;
&END;
&WriteLn;
&IF ch = ' ' THEN
(list;
&END
$END;
"END Menu;
 
 PROCEDURE Entry;
!(*
"* Einsprungsprozedur vom Compiler
"*)
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  A0,DisplayStack
(MOVE.L  A1,TreeBase
(MOVE.L  D0,RelocationStack
(MOVE.L  A3,D0
(MOVE.L  A7,D1
(LEA     wsp,A2
(MOVE.L  MemArea.bottom(A2),A3
(MOVE.L  A3,A0
(ADDA.L  MemArea.length(A2),A0
(MOVE.L  A0,A7
(MOVE.L  D1,-(A7)        ; A7
(MOVE.L  D0,-(A7)        ; A3
#END;
#WriteLn;
#Call (Menu, exc);
#IF exc # NormalReturn () THEN
%WriteLn;
%WriteLn;
%WriteString ('Exception: ');
%GetErrorMsg (StdErrNo (exc), s);
%WriteString (s);
%WriteLn;
%WriteString ('>>> Press Esc <<<');
%REPEAT Read (ch) UNTIL ch = 33C;
#END;
#ASSEMBLER
(MOVE.L  (A7)+,A3
(MOVE.L  (A7)+,A7
$END
"END Entry;
"(*$L=*)
 
 PROCEDURE term;
"BEGIN
$CompilerArgs:= "";
$ReleaseModule;
"END term;
 
 VAR card: CARDINAL;
 
 BEGIN
"rek:= 0;
"Indent:= 0;
"IF FirstModuleStart () THEN
$wsp:= MEM (stack);
$IF ODD (wsp.length) THEN DEC (wsp.length) END; (* wg. Fehler in MEM *)
$InstallModule (term, termwsp);  (* Modul resident machen *)
$FormAlert(1, "[0][ CompDeb now installed ][OK]", card);
$CompilerArgs:= "/DCompDeb.Entry";
"ELSE
$FormAlert(2, "[0][ CompDeb is installed ][Leave|Remove]", card);
$IF card = 2 THEN
&term
$END
"END
 END CompDeb.
 
(* $FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFDE18AD$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$FFECF4FB$00000945T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000958$0000094E$00000945$FFE07114$FFE208F6$000006DF$000007DB$00000855$00000831$000006E0$0000066A$0000076F$00000762$00000C90$00000C74$00000C8C*)
