 IMPLEMENTATION MODULE SFP004;
 (*$Y+, L-, N+, M-*)
 
 (*
"25.10.90  TT  Format Error wird erkannt
"17.12.90  TT  FPUReset setzt FPU auch nach Fehler wieder richtig zurck
"20.02.91  TT  FPUError: LINK fr Scanning eingesetzt
"16.01.94  TT  FPUInit ruft nicht mehr SysInfo.FPU() auf sondern prft direkt
0auf Vorhandensein der FPU.
"08.02.94  TT  Kein Byte-Zugriff mehr auf fpstat+1.
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER;
 FROM SystemError IMPORT Abort;
 FROM MOSSupport IMPORT ToSuper, ToUser;
 IMPORT MOSGlobals;
 
 CONST fpstat  =  $fffa40;       (* Response word of MC68881 read *)
&fpctrl  =  $fffa42;       (* Control word of MC68881 write *)
&fpsave  =  $fffa44;
&fpcmd   =  $fffa4a;       (* Command word of MC68881 write *)
&fpop    =  $fffa50;       (* Operand long of MC68881 read/write *)
 
 PROCEDURE FPUReset;
"BEGIN
$ASSEMBLER
(TST.W   fpstat
(MOVE.W  #3,fpctrl       ; Reset FPU
(CMPI.W  #$0802,fpstat
(BEQ     idle
(; die FSAVE-Anforderung mu erst beendet werden:
&again:
(MOVE.W  fpstat,D0
(TST.B   D0
(BNE     endRead
(TST.L   fpop
(BRA     again
&endRead:
(MOVE.W  #3,fpctrl       ; Reset FPU
&idle:
(; FMOVE  #$0000F400,FPCR
(;   Bedeutung der Bits: Take Exception on...
(;    - Operand Error
(;    - Overflow
(;    - Div By Zero
(;    - NAN
(;    - Bcc/Scc on unordered
(TST.W   fpstat
(MOVE.W  #$9000,fpcmd
%RL MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     RL
(MOVE.L  #$0000F400,fpop
(TST.W   fpstat
$END
"END FPUReset;
 
 PROCEDURE FPUError;
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE    fpstat,-(A7)
(MOVE    fpsave,-(A7)
(JSR     FPUReset
(MOVE    (A7)+,D1
(MOVE    (A7)+,D0
 
(ANDI    #$FF00,D1
(CMPI    #$0200,D1
(BNE     noFormatError
(
(TRAP    #6
(DC.W    -22-$E000  ; Gen. FP error: Text follows, callerCaused, noCont
(ACZ     'Format Error (FSAVE/FRESTORE)'
(SYNC
(UNLK    A5
(RTS
(
 noFormatError:
(CMPI.B  #$0D,D0
(BNE     no0D
(TRAP    #6
(DC.W    -22-$C000  ; Gen. FP error: Text follows, callerCaused, mayCont
(ACZ     'FPU Protocol Violation'
(SYNC
(UNLK    A5
(RTS
&no0D
(CMPI.B  #$32,D0
(BNE     no32
(TRAP    #6
(DC.W    -5-$4000  ; div by zero: callerCaused, mayCont
(UNLK    A5
(RTS
&no32
(CMPI.B  #$34,D0
(BNE     no34
(TRAP    #6
(DC.W    -6-$4000  ; out of range (operand error): callerCaused, mayCont
(UNLK    A5
(RTS
&no34
(CMPI.B  #$35,D0
(BNE     no35
(TRAP    #6
(DC.W    -7-$4000  ; Overflow: callerCaused, mayCont
(UNLK    A5
(RTS
&no35
(TRAP    #6
(DC.W    -22-$4000  ; Gen. FP error: callerCaused, mayCont
(UNLK    A5
$END
"END FPUError;
 
 (*$Z+*)
 PROCEDURE hasSFP (): BOOLEAN;
 (*$Z=*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #4,A7
(JSR     ToSuper
 
(MOVEQ   #FALSE,D0
(MOVE.L  A7,D2
(MOVE.L  $08,D1          ; BusError-Exc-Vektor
(LEA     b(PC),A0
(MOVE.L  A0,$08
(TST.W   fpstat
(MOVEQ   #TRUE,D0
&b MOVE.L  D2,A7
(MOVE.L  D1,$08
 
(JSR     ToUser
(ADDQ.L  #4,A7
$END
"END hasSFP;
 
 PROCEDURE FPUInit;
"BEGIN
$(* 16.1.94:
%* Es wird nur direkt auf die SFP004 geprft, weil SysInfo.FPU() beim
%* Vorhandensein einer internalFPU gar nicht mehr auf die externe prft.
%* So liefert FPU() dann "internalFPU", obwohl auch die gesuchte
%* SFP004 installiert wre.
%*)
$IF NOT hasSFP () (* vormals: FPU () # externalFPU *) THEN
&ASSEMBLER
(MOVE.W  #MOSGlobals.fUnknownDevice,(A3)+
(JMP     Abort
&END
$END;
$FPUReset
"END FPUInit;
 
 END SFP004.
 
(* $FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$00000755$FFE39FCE$00000D6F$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$00000157T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000165$00000157$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE$FFE39FCE*)
