 IMPLEMENTATION MODULE MOSCtrl; (* V#0193 *)
 (*$Y+,N+,C+,L-,R-,M-*)
 
 (*
"22.07.87: Bei Terminierung des gesamten MOS-Prozesses werden alle noch
,aktiven Modlevels abgebaut mit jew. Termprocess-Aufruf.
"30.08.87: ModLevel wird bei Push/PopPDB verndert. Bei unterstem ModLevel
,ist der Wert = 1.
"01.10.88: PopPDB wird bei Ende des untersten Prozesse aufgerufen, damit
,f. residente Prgs ModLevel dann auf Null steht.
"23.10.88: GetPDB liefert ggf. NIL (siehe Def-Text); Removal-Behandlung neu;
,Term-Handler wird bei residenten Programmen erst beim Freigeben
,ausgelinkt.
"15.01.89: PushPDB aktualisiert ggf. BaseProcess und ActMosProcess, da bei
.ACCs sonst Unsinn drin stnde.
"26.07.89: 408-Vektor wird auch bei residenten Prgs bei Prozeende ausgelinkt.
"04.08.89: 408-Vektor wird mit XBRA ('MM2T') eingelinkt.
"16.08.89: Kein infinite Loop, wenn Runtime-Error bei Removal-Calls
"20.11.89: Process-ID wird bei TOS 1.0 wieder korrekt ermittelt - MM2 luft
,nun wieder mit TOS 1.0
"21.11.90: Term-Handler: Wird bei ACCs nicht installiert, dafr aber nach
,Aushngung beim erneuten PushPDB (damit's mit ModLoad klappt);
,wenn whrend der Terminierung wieder Pterm aufgerufen wird, wird
,weitergemacht, als sei nix gewesen (die restlichen Term-Handler
,werden trotzdem aufgerufen usw).
,-nicht getestet!-
"25.11.90: Term-Handler: Wenn ein Modul mit TermProcess(0) zurckkehrt, wird
,der vorherige ExitCode/termState nicht verndert.
"08.12.90: Term-Handler: Der SSP wird nicht mehr aus Proze-Daten ermittelt
-(denn das Format knnte sich ja mal ndern), sondern wird auf
-den Startwert vom Prgstart zurckgesetzt.
"05.07.91: Term-Handler: ExitCode-Position wird gesucht, damit's auch mit
-KAOS klappt.
"03.02.92: 408-Vektor wird wg. MiNT per Bios-Funktion gesetzt.
"14.02.92: Wenn MiNT installiert, keine ExitCode-Positionssuche und Term-Hdlr
,luft als Subroutine statt ein 2. Pterm am Ende zu machen.
"17.02.92: Wenn MiNT installiert, wird Term-Handler bei jedem neuen Proze
,in SetProcessState neu installiert. Achtung: bisher wird jedoch
,der alte Vektor vom Base-Proze jedesmal weiterhin gechained,
,obwohl MiNT eigentlich fr den neuen Proze keine anderen Term-Hdlr
,mehr drin hat -> 'vSave' in der XBRA-Struktur mte in PushPDB
,gestacked werden und jedesmal in SetProcessState neu gesetzt werden!
"19.02.92: Nun wird bei neuem Proze unabh. v. MiNT geprft, ob der Term-Hdler
,noch in der etv_term-Kette installiert ist und ggf. neu installiert;
,Auf 408-Vektor wird wieder direkt statt ber BIOS zugegriffen.
,Leider darf die Exitcode-Suche weiterhin nicht unter MiNT erfolgen,
,weil der nchste Supexec-Aufruf nach Pterm() zum Terminate fhrt.
"08.01.94: Mag!X-Anpassung (v. Dirk Steins): Ebenfalls keine Exitcode-Suche
"17.01.94: Neues Termination-Handling: 'PrgCtrl.TermProcess' fhrt bereits die
,Term-Handler vor Pterm() aus. Stellen wir im etv_term-Handler fest,
,da noch nicht alles abgemeldet wurde, versuchen wir nicht mehr,
,den Exitcode zu korrigieren, denn das Abbrechen des Programms per
,Pterm() ist nicht mehr als "saubere" Methode erlaubt.
,Der etv_term-Handler wird am Ende immer per Pterm verlassen, auch
,bei MiNT/Magix.
"08.02.94: Korrektur seit 17.01.94: Falls wir, z.B. durch im Tochterproze
,noch installiertem GEMError, einen fremden Proze beenden, fhren
,wir natrlich nicht die eigenen Term-Handler aus sondern rufen
,Pterm sofort auf.
"03.06.94: Noch ein Versuch wg. Problemen, falls ein Prg trotzdem GEMDOS-Pterm
,direkt aufruft und MetaDOS o.a. Prgs installiert sind, die im
,GEMDOS-Trap hngen und whrend des Pterm-Handlings mit aufgerufen
,werden und es nicht mgen, wenn dann der SSP auf dem fixen Pterm-
,Stack bereits steht: Vor Aufruf der Exit-Procs wird der SSP auf
,den Programm-USP gesetzt und der USP 512 Byte darunter. Am Ende,
,wenn die Exit-Procs ausgefhrt wurden, wird wieder der alte SSP
,zurckgesetzt, damit es hoffentlich weiter mit rekursiven
,Pterms, wie bei Magix mglich, klappt.
"24.06.94: Falls ModCtrl BaseResident auf TRUE gesetzt hat und wir den
,Basisproze beenden, wird am Ende Ptermres statt Pterm aufgerufen.
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER, ADR, WORD, ADDRESS, TSIZE, LONGWORD, BYTE;
 
 FROM MOSGlobals IMPORT MemArea;
 
 (*
"FROM CookieJar IMPORT GetCookie;
 *)
 
 (* ! Storage darf nicht importiert werden ! *)
 
 
 CONST layout = 4;
 
&(*
'* Die folg. Konstante legt fest, wie viel Sicherheitsbereich der SSP
'* erhalten soll - gleich darunter wird der USP gelegt.
'*)
&SupervisorStackAmount = 512;
&
&(*
'* Ist die folg Konstanten TRUE, wird bei MiNT & Mag!X am Ende der
'* Prozeterminierung im etv_term-Handler nicht erneut Pterm()
'* aufgerufen, sondern ein RTS ausgefhrt. Das klappt auch, ist
'* aber z.Zt. offenbar berflssig, da das Verfahren des wiederholten
'* Pterm-Aufrufs genausogut in allen Situationen zu klappen scheint.
'*)
&MiNTaware = FALSE;
 
 VAR termVectorInstalled: BOOLEAN;
$TOSHdr: LONGWORD;
$(*$?MiNTaware:
&MagXavail, MiNTavail: BOOLEAN;
$*)
 
 VAR PtermSSP, mySSP, myUSP: LONGCARD;
$didPterm: BYTE;
$makeResident: BYTE; (* wird gesetzt, falls InstallModule aufgerufen *)
8(* wurde, um dann Ptermres() aufzurufen         *)
 
 VAR rem408carrier: RemovalEntry;
 
 (*
 VAR LastSR : WORD;
 
 PROCEDURE DisableIR;
"BEGIN
$ASSEMBLER
(PEA     upro(PC)
(MOVE    #38,-(A7)
(TRAP    #14
(ADDQ.L  #6,A7
(RTS
"upro  MOVE    SR,LastSR
(ORI     #$0700,SR
$END
"END DisableIR;
 
 PROCEDURE EnableIR;
"BEGIN
$ASSEMBLER
(PEA     upro(PC)
(MOVE    #38,-(A7)
(TRAP    #14
(ADDQ.L  #6,A7
(RTS
"upro  MOVE    LastSR,SR
$END
"END EnableIR;
 *)
 
 PROCEDURE GetPDB ( VAR pdbp : PtrPDB; VAR p: ADDRESS );
"BEGIN
$ASSEMBLER
(MOVE.L  ProcessID,A1
(MOVE.L  (A1),D1           ; D1: akt. Proze
(MOVE.L  -(A3),A0
(MOVE.L  D1,(A0)
(MOVE.L  -(A3),A0
(TST     BaseIsAccessory   ; ist Programm ein ACC ?
(BEQ     notAcc
(CMPI    #1,ModLevel       ; und ist Acc-Proze aktiv?
(BEQ     mos               ; -> dann wird PDB geliefert
&notAcc
(CMP.L   ActMOSProcess,D1  ; Akt. Proze gleich letztem MOS-Proze ?
(BEQ     mos
(TST     ModLevel          ; oder kein MOS-Proze mehr aktiv ?
(BEQ     mos
(CLR.L   (A0)              ;  nein -> pdbp:= NIL
(RTS
&mos
(MOVE.L  ActPDB,(A0)
$END
"END GetPDB;
 
 FORWARD HdlTerm;
 
 PROCEDURE LookTermHdlr;
"BEGIN
$ASSEMBLER
(; Term-Handler suchen
(MOVE    SR,D2
(ORI     #$0700,SR
(LEA     HdlTerm,A2
(ADDA.W  #12,A2
(LEA     $408,A0         ; A0: Vektoradr.
%l: MOVE.L  (A0),A1
(CMPA.L  A2,A1           ; 'entry' gefunden?
(BEQ     f
(CMPI.L  #$58425241,-12(A1) ; Ist dies ein XBRA-Eintrag?
(BNE     n               ; Nein -> entry hier trotzdem austragen
(LEA     -4(A1),A0       ; Vorige Vektoradr. nach A0
(BRA     l
%n: MOVE.L  A2,A1
%f:
$END
"END LookTermHdlr;
 
 PROCEDURE LinkOut408;
"BEGIN
$ASSEMBLER
(CLR.L   -(A7)
(MOVE    #$20,-(A7)      ; Super()
(TRAP    #1
(MOVE.L  D0,2(A7)
(
(; Term-Handler auslinken
(JSR     LookTermHdlr
(MOVE.L  -4(A1),(A0)     ; Entry.old eintragen
(CLR.W   termVectorInstalled
(MOVE    D2,SR
(
(TRAP    #1
(ADDQ.L  #6,A7
$END
"END LinkOut408;
 
 PROCEDURE PushPDB ( pdb: PtrPDB; process: ADDRESS );
"BEGIN
$ASSEMBLER
(; JSR     DisableIR
(MOVE.L  -(A3),D1
(BLE.W   err
(MOVE.L  -(A3),D0
(BLE.W   err
(MOVE.L  D0,A0
(CMPI    #layout,PDB.layout(A0)
(BNE.W   err2
 
(MOVE.L  D1,ActMOSProcess
(MOVE.L  PDB.basePageAddr(A0),A2
(LEA     ActPDB,A1
(MOVE.L  (A1),PDB.prev(A0)
(BNE     notBase
 
(; *** unterster PDB wird init. ***
 
(MOVE.L  A2,BaseProcess
(MOVE.L  A2,ActMOSProcess
(TST.L   $24(A2)
(SEQ     D0
(ANDI    #1,D0
(MOVE    D0,BaseIsAccessory
(MOVE.W  PDB.flags(A0),D0
(ANDI    #3,D0
(MOVE    D0,RealMode
 
((*$?MiNTaware:
*MOVEM.L A0-A2,-(A7)
*
*; Ist MiNT installiert?
*MOVE.L  #$4D694E54,(A3)+
*SUBQ.L  #4,A7
*MOVE.L  A7,(A3)+
*JSR     GetCookie
*ADDQ.L  #4,A7           ; value ist uninteressant
*MOVE.W  -(A3),MiNTavail
"
*; Ist Mag!X installiert?
*MOVE.L  #$4D616758,(A3)+
*SUBQ.L  #4,A7
*MOVE.L  A7,(A3)+
*JSR     GetCookie
*ADDQ.L  #4,A7           ; value ist uninteressant
*MOVE.W  -(A3),MagXavail
"
*MOVEM.L (A7)+,A0-A2
(*)
 
&notBase
(MOVE.L  A0,(A1)
(LEA     HdlTerm,A1      ; alten etv_term-Link retten, da er ggf. in
(MOVE.L  8(A1),PDB.prevTermHdlr(A0)   ; SetProcessState vernd. wird.
(MOVE.W  #2,PDB.termState(A0)
(CLR     ExitCode
(ADDQ.W  #1,ModLevel
 
(; Da ACCs nie terminieren, braucht auch kein Term-Vektor installiert
(; werden. Ansonsten mu er immer so bald wie mglich installiert werden.
(; Dies ist der Fall beim 1. PushPDB-Aufruf in normalen Prgs und bei
(; einem Proze-Aufruf innerhalb von ACCs. Die Deinstallation mu auf
(; dem selben Level erfolgen. Macht sich z.B. ein Prg resident, mu
(; der Term-Vektor raus, aber wenn das res. Prg (z.B. ModLoad) dann
(; wieder einen Proze startet, mu der Term-Vektor wieder rein.
(TST.L   $24(A2)
(BEQ     noTermInstall   ; bei ACC-Proze keinen Term-Vektor installieren
(TST.W   termVectorInstalled
(BNE     noTermInstall   ; ansonsten installieren, wenn nicht schon getan
 
(CLR.L   -(A7)
(MOVE    #$20,-(A7)      ; Super()
(TRAP    #1
(MOVE.L  D0,2(A7)
(
(; Pterm-Handler installieren
(LEA     HdlTerm,A1
(ADDA.W  #12,A1
(LEA     $408,A0         ; A0: Vektoradr.
(MOVE.L  (A0),-4(A1)     ; alten Vektor retten (in XBRA-Struktur)
(MOVE.L  A1,(A0)
(
(TRAP    #1              ; Super() - zurck in Usermode
(ADDQ.L  #6,A7
(
(; Catcher installieren, der beim Removal den etv_term wieder aushngt
(LEA     rem408carrier,A0
(MOVE.L  #LinkOut408,RemovalEntry.call(A0)
(MOVEQ   #0,D0
(MOVE.L  D0,RemovalEntry.wsp.bottom(A0)
(MOVE.L  D0,RemovalEntry.wsp.length(A0)
(LEA     RemovalRoot,A2               ; A2: root
(MOVE.L  A2,RemovalEntry.next(A0)
(MOVE.L  RemovalEntry.prev(A2),A1     ; A1: root.prev
(MOVE.L  A1,RemovalEntry.prev(A0)
(MOVE.L  A0,RemovalEntry.next(A1)
(MOVE.L  A0,RemovalEntry.prev(A2)
(
(MOVE    #1,termVectorInstalled
(
&noTermInstall:
(; JMP     EnableIR
(RTS
 
&err2
(; JSR     EnableIR
(TRAP    #6
(DC.W    -16     ; internal fault
(RTS
&err
(; JSR     EnableIR
(TRAP    #6
(DC.W    -14     ; illegal call
$END
"END PushPDB;
 
 PROCEDURE PopPDB;
"BEGIN
$ASSEMBLER
(; JSR     DisableIR
(LEA     ActPDB,A1
(MOVE.L  (A1),D0
(BEQ     err
(MOVE.L  D0,A0
(MOVE.L  PDB.prev(A0),(A1)
(LEA     HdlTerm,A1              ; alten etv_term-Link restaurieren
(MOVE.L  PDB.prevTermHdlr(A0),8(A1)
(MOVE.L  ProcessID,A0
(MOVE.L  (A0),ActMOSProcess
(SUBQ.W  #1,ModLevel
(BRA     ok
&err
(TRAP    #6
(DC.W    -14     ; illegal call
&ok
(; JSR     EnableIR
$END
"END PopPDB;
 
 PROCEDURE SetProcessState ( state: CARDINAL );
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),D1
(MOVE.L  ActPDB,D0
(BEQ     err
(MOVE.L  D0,A0
(MOVE.W  D1,PDB.processState(A0)
(CMPI    #1,D1
(BNE     notOne
(
(; neuer Proze gestartet
(;------------------------
(
(; zuerst in den Supervisormode
(CLR.L   -(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(MOVE.L  D0,2(A7)
(
(; SSP des Prozesses ermitteln
(MOVE.L  ActPDB,A0
(MOVE.L  D0,PDB.initialSSP(A0)
(
(; Term-Handler suchen
(JSR     LookTermHdlr    ; D2 enth. noch altes SR!
(
(; wenn TermHdlr noch installiert, ist alles OK
(BEQ     stillAvail
(
(; HdlTerm neu installieren
(MOVEA.W #$408,A0
(LEA     HdlTerm,A1
(ADDA.W  #12,A1
(MOVE.L  (A0),-4(A1)     ; alten Vektor retten (in XBRA-Struktur)
(MOVE.L  A1,(A0)
(
&stillAvail:
(MOVE    D2,SR           ; SR von LookTermHdlr zurcksetzen
(
(; zurck in der Usermode
(TRAP    #1
(ADDQ.L  #6,A7
(
&notOne:
(RTS
(
&err:
(TRAP    #6
(DC.W    -14     ; illegal call
$END
"END SetProcessState;
 
 
 PROCEDURE CallSub ( subRoutine: PROC; VAR wsp: MemArea );
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0                ; ^wsp
(MOVE.L  -(A3),A1                ; subRoutine
(
(MOVE.L  A3,-(A7)                ; A3 retten
(MOVE.L  A7,D1                   ; alten SP laden zum Retten
(
(MOVE.L  MemArea.bottom(A0),D0   ; neuen SP-Bottom
(BEQ     useOld                  ; alten SP verwenden
(MOVE.L  MemArea.length(A0),D2
(BEQ     useOld                  ; alten SP verwenden
(
(CMPI.L  #20,D2
(BCS     noStack                 ; Stack zu klein
(
(; neuen SP verwenden
(MOVE.L  D0,A3
(ADD.L   D2,D0
(MOVE.L  D0,A7
(
&useOld
(MOVE.L  D1,-(A7)                ; alten SP retten
(
(JSR     (A1)
(
(MOVE.L  (A7)+,A7
(MOVE.L  (A7)+,A3
(RTS
(
&noStack
(TRAP    #6
(DC.W    -10             ; out of stack space
$END
"END CallSub;
 
 
 PROCEDURE CallTermProcs;
"BEGIN
$ASSEMBLER
(MOVE.L  ActPDB,D0
(BEQ     listEnd         ; Drfte eigentlich nicht vorkommen
(MOVE.L  D0,A0
(LEA     PDB.termProcs(A0),A2
 lstLoop MOVE.L  (A2),D0
(BEQ     listEnd
(MOVE.L  D0,A0                     ; A0: POINTER TO ProcField
(MOVE.L  TermEntry.next(A0),(A2)   ; to be called next
(MOVE.L  TermEntry.call(A0),(A3)+  ; function to be called now
(LEA     TermEntry.wsp(A0),A1
(MOVE.L  A1,(A3)+
(MOVE.L  A2,-(A7)
(JSR     CallSub                   ; call term-function
(MOVE.L  (A7)+,A2
(BRA     lstLoop
 listEnd
$END
"END CallTermProcs;
 
 
 PROCEDURE CallRemoveProcs;
"(* alle Catcher in umgekehrter Anmeldereihenfolge aufrufen *)
"BEGIN
$ASSEMBLER
&l LEA     RemovalRoot,A2
(LEA     RemovalEntry.prev(A2),A2
(MOVE.L  (A2),A1
(CMPA.L  #RemovalRoot,A1
(BEQ     end2
(MOVE.L  RemovalEntry.prev(A1),(A2)      ; to be called next
(MOVE.L  RemovalEntry.call(A1),(A3)+
(LEA     RemovalEntry.wsp(A1),A0
(MOVE.L  A0,(A3)+
(JSR     CallSub
(BRA     l
&end2
$END
"END CallRemoveProcs;
 
 
 PROCEDURE callExitProcs;
"BEGIN
$ASSEMBLER
(JSR     CallTermProcs           ; Prozeende mitteilen
(MOVE.L  ProcessID,A0
(MOVE.L  (A0),D0
(CMP.L   BaseProcess,D0          ; wird Basisproze beendet ?
(BNE     noBaseTerm
(TST.W   BaseResident            ; und ist Prg nicht resident ?
(BNE     noRemove
(JSR     CallRemoveProcs         ; -> Modul-Entfernung mitteilen
(BRA     doneRemove
 noRemove:
(ST      makeResident
 doneRemove:
(; Prg terminiert
(; **************
(CLR.L   BaseProcess
(CLR.L   ActMOSProcess
(CLR     ModLevel
 noBaseTerm:
$END
"END callExitProcs;
 
 PROCEDURE setTermCode;
"BEGIN
$ASSEMBLER
(; Wenn ein Modul in der Deinit-Phase mit Exitcode 0 terminiert,
(; ist das kein Fehler.
(CMPI.W  #2,PDB.processState(A0) ; Init- oder Run-Phase?
(BLS     termNormal              ; ja, dann Exitcode auf jeden Fall nehmen
(TST     D1                      ; Deinit: Exitcode=0?
(BEQ     noError                 ; ja, dann alten Exitcode belassen
&termNormal:
(MOVE    D1,ExitCode
(MOVE.W  PDB.processState(A0),PDB.termState(A0)
&noError:
$END
"END setTermCode;
 
 PROCEDURE terminateResident;
"BEGIN
$ASSEMBLER
(; ptermres (topOfStack-basepage, ExitCode)
(SF      makeResident
(MOVE.W  ExitCode,-(A7)
(MOVE.L  ActPDB,A0
(MOVE.L  PDB.topOfStack(A0),D0
(SUB.L   PDB.basePageAddr(A0),D0
(MOVE.L  D0,-(A7)
(MOVE    #$31,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
$END
"END terminateResident;
 
 PROCEDURE HdlTerm;
"BEGIN
$ASSEMBLER
(ASC     'XBRA'  ; XBRA-Kennung
(ASC     'MM2T'  ; eigene Kennung
 save408 DC.L    0       ; old vector
 
(; We're now in supervisor mode!
(MOVE.L  save408(PC),-(A7)
 
(MOVE.L  ProcessID,A0
(MOVE.L  (A0),A1
(CMPA.L  BaseProcess,A1
(BEQ     term1
(CMPA.L  ActMOSProcess,A1
(BNE.W   notThis
 
 term1   MOVE.L  ActPDB,D0
(BEQ.W   ende                    ; nanu?!
(MOVE.L  D0,A0
 
(CMPI.W  #4,PDB.processState(A0)
(BCC.W   term2                   ; Proze ist bereits vollst. terminiert
 
(; *** Prozeterminierung nachholen ***
(
(MOVE    ExitCode,D1
(BNE     tellCode                ; falls kein ExitCode gesetzt,
(MOVEQ   #-1,D1                  ; -1 setzen (schlielich sollten wir
&tellCode:                         ; hier normalerweise nicht ankommen)
(JSR     setTermCode
(
(CMPI.W  #3,PDB.processState(A0)  ; bereits Deinit-Phase?
(BNE     firstPterm               ;   nein: Pterm-SSP merken
(TST.B   didPterm                 ; bereits Pterm-SSP ermittelt?
(BEQ     firstPterm               ;   nein: Pterm-SSP merken
(
((*
(idee: da am ende eh die bei rekursiven pterms benutzten stacks
(verworfen werden, kann gleich immer derselbe stack verwendet
(werden, so wie bei A3. allerdings mu ssp immer noch auf eigenen
(bereich zeigen (evtl. initialSSP?) und usp/ssp mssen
(geprft werden, ob sie innerhalb des eigenen stacks bereits
(liegen und dann immer dieser wert verwendet werden, anstatt
(den stack neu auf dem vollbereich zu nutzen.
(*)
(
(MOVE.L  mySSP,A7        ; den bereits verwendeten SSP erneut benutzen
(BRA     noNewSSP
(
&firstPterm:
(MOVE.W  #3,PDB.processState(A0)  ; nun Deinit-Phase einleiten
(MOVE.L  A7,PtermSSP
(ST      didPterm
(
(; *** SSP & USP setzen ***
(; Dabei prfen, ob der Pterm-SSP evtl. innerhalb unseres Proze-Stacks
(; liegt (z.B. verwendet MetaDOS bei Pterm den USP als SSP und ruft
(; dann selbst etv_term() auf). In diesem Fall wird der SSP weiterver-
(; wendet.
(CMPA.L  PDB.bottomOfStack(A0),A7
(BLS     notInside
(CMPA.L  PDB.topOfStack(A0),A7
(BLS     isInside
&notInside:
(MOVE.L  PDB.topOfStack(A0),A7    ; new SSP: USP of terminated process
&isInside:
(MOVE.L  A7,mySSP
(
&noNewSSP:
(; *** setup Stack Pointers & enter User Mode ***
(MOVE.L  PDB.bottomOfStack(A0),A3 ; use stackptrs of terminated process
(MOVE.L  A7,A1
(SUBA.W  #SupervisorStackAmount,A1
(MOVE.L  A1,USP                  ; set USP to some bytes below SSP
(ANDI    #$DFFF,SR
(
(; *** call installed termination procedures ***
(; (last of them removes this handler from the etv_term vector)
(MOVE.L  A0,-(A7)                ; save PDB
(JSR     callExitProcs
(MOVE.L  (A7)+,A0                ; PDB zurck
(
(; *** process is terminated, all exit procs have been called ***
(MOVE.W  #4,PDB.processState(A0) ; process state: finished
(
(; *** call final 'Pterm' ***
(; (get into Superv Mode to restore SSP)
(CLR.L   -(A7)
(MOVE.W  #$20,-(A7)
(TRAP    #1                      ; enter Supervisor Mode to reset SSP
(MOVE.L  PtermSSP,A7             ; reset Pterm-SSP from first Pterm()
(TST.B   makeResident
(BNE     doTermRes
(; (no need to get back to User Mode)
(MOVE    ExitCode,-(A7)
(MOVE    #$4C,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(BRA     ende
&doTermRes:
(JMP     terminateResident
 
 term2:
 ende:
 notThis:
(; RTS-Wert ist geretteter $408-Vektor
$END
"END HdlTerm;
 
 PROCEDURE Pterm (exitCode: INTEGER);
"BEGIN
$ASSEMBLER
(; Pterm-Behandlung von 'TermProcess' und M2Init aus.
(
(TST.L   ActPDB
(BEQ     term0                   ; nanu?!
(
(; ist es berhaupt unser eigener Proze, den wir hier beenden?
(MOVE.L  ProcessID,A1
(MOVE.L  (A1),A1
(CMPA.L  BaseProcess,A1
(BEQ     term1
(CMPA.L  ActMOSProcess,A1
(BEQ     term1
(
(; fremden Proze beenden -> Pterm() direkt aufrufen.
 term0:  MOVE    -(A3),-(A7)
(MOVE    #$4C,-(A7)
(TRAP    #1
 
 term1:  ; eigenen Proze beenden -> vorher eigene Term-Handler aufrufen
 
(; first get into User Mode
(MOVEQ   #1,D0
(MOVE.L  D0,-(A7)
(MOVE    #$20,-(A7)
(TRAP    #1              ; Super (1) - Get Mode
(ADDQ.L  #1,D0
(BNE     isUser
(ANDI    #$DFFF,SR       ; enter User Mode
&isUser:
(ADDQ.L  #6,A7
(
(MOVE    -(A3),D1        ; get exitCode
(MOVE.L  ActPDB,A0
 
(JSR     setTermCode
(
(CMPI.W  #3,PDB.processState(A0)
(BEQ     notFirst
(MOVE.W  #3,PDB.processState(A0)  ; nun Deinit-Phase einleiten
(SF      didPterm
&notFirst:
 
(; reload USP, do not change SSP here
(MOVE.L  PDB.bottomOfStack(A0),A3 ; use stackptrs of terminated process
(MOVE.L  PDB.topOfStack(A0),A7    ; new USP
(
(MOVE.L  A0,-(A7)                ; save PDB
(JSR     callExitProcs           ; may call this Pterm rekursively
(MOVE.L  (A7)+,A0                ; PDB zurck
(MOVE.W  #4,PDB.processState(A0)
(
(; call final 'Pterm'.
(TST.B   makeResident
(BNE     doTermRes
(; (no need to get back to User Mode)
(MOVE    ExitCode,-(A7)
(MOVE    #$4C,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(BRA     ende
&doTermRes:
(JMP     terminateResident
&ende:
$END
"END Pterm;
 
 BEGIN
"ASSEMBLER
(; supervisor mode:
(CLR.L   -(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(MOVE.L  D0,2(A7)
(MOVE.L  $4F2,A0         ; ^TOS-Header
(MOVE.L  8(A0),TOSHdr    ; wg. altem AHDI
(; back to user mode:
(TRAP    #1
(ADDQ.L  #6,A7
(
(MOVE.L  TOSHdr,A0
(CMPI    #$0102,2(A0)
(BCC     a
(MOVE    $1C(A0),D1
(LSR     #1,D1           ; PAL-Bit entfernen
(CMPI    #4,D1           ; Spanisches TOS?
(BEQ     b
(MOVE.L  #$602C, ProcessID
(BRA     e
%b: MOVE.L  #$873C, ProcessID
(BRA     e
%a: MOVE.L  $28(A0),ProcessID
%e:
(CLR     BaseIsAccessory
(CLR.L   BaseProcess
(CLR.W   BaseResident
(CLR.L   ActMOSProcess
(CLR.L   ActPDB
(CLR.W   ModLevel
(CLR.W   termVectorInstalled
(SF      makeResident
(LEA     EnvRoot,A0
(MOVE.L  A0,EnvEntry.prev(A0)
(MOVE.L  A0,EnvEntry.next(A0)
(LEA     RemovalRoot,A0
(MOVE.L  A0,RemovalEntry.next(A0)
(MOVE.L  A0,RemovalEntry.prev(A0)
"END
 END MOSCtrl.
  
(* $FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$00001045$FFE3657B$000052D0$FFE3657B$00004857$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$FFE3657B$00001042T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000D74$00001045$00000FBA$00001042$00001005$00001042$00004840$0000476E$FFDFF4EA$00004F18$00004EFC$00004F15$00004E43$000045BB$0000319C$000000F9*)
