 IMPLEMENTATION MODULE Loader;
 (*$Y+,C-,R-,P-*)
 
 (* V#477 *)
 (*----------------------------------------------------------------------------
"25.10.86  TT  Grundversion
"27.02.87  TT  VarSpc wird beim Start gelscht.
"03.03.87  TT  Layout wird endlich berprft.
"22.03.87  TT  TermProcs werden nun richtig am Ende des Modlevels aufgerufen.
"16.05.87  TT  Komplette Umstrukturierung zusammen mit 'ModCtrl'
"01.07.87  TT  Paths.SearchFile wird verwendet.
"18.07.87  TT  Proc-Vars Loading/Releasing neu, varRef/Len und code/sourceName
0werden aus Codefile geholt; ReadMod fhrt Directory-Search fort,
0wenn beim Importieren der Modulname nicht stimmt.
"23.07.87  TT  ExecBody rettet/restauriert SR und SSP
"11.08.87  TT  DeAllocate korrekt, wenn Fehler bei ReadMod
"25.08.87  TT  SplitName korigiert.
"26.08.87  TT  CallModule kann auch gelinkte (TOS) Prg. starten
"08.09.87  TT  Bei neuem Process wird "parent's basepage" gesetzt
"17.10.87  TT  LoadModule auch fr TOS-Prgs.
"15.01.88  TT  ReadMod: Erkennt illeg. Layout sofort; FClose, wenn RETURN
0aus ReadMod wg. 'no memory'.
0Seltsam. Ich meine, ich htte diese Fehler schon mal behoben...
"16.01.88  TT  Kennung/Bit 4 als Flag f. 'procSym' wird erkannt
"22.01.88  TT  Kein Search bei Call/Load v. Prgs.; beim Laden v. Prgs. wird
0erste Hlfte der Basepage gerettet und bei Exec zurckkopiert
"23.01.88  TT  Search wieder drin, Current Dirs/Drv werden bei prgExec gesetzt
"04.03.88  TT  layout zw. 0 und 15 erlaubt (bisher nur 0).
"14.05.88  TT  Module mit Namen > 8 Zeichen ausfhrbar.
"08.06.88  TT  Gecrunchte Module knnen gelinkt werden. Nur wenn Exportliste
0nicht vorhanden ist, gibt's 'ne Fehlermeldung.
"10.06.88  TT  PRG-Files werden wiedergefunden, wenn geladen.
"27.06.88  TT  Wenn Modul nicht gefunden, wird wieder richtige Melgung ange-
0zeigt.
"30.09.88  TT  ALLOCATE statt SysAlloc bei InitPrgSpace (da sowieso gleich
0wieder freigegeben).
"05.11.88  TT  Release nun im Loader ber Proc-Var implementiert
"10.12.88  TT  Pexec gendert, damit mit MOSLink lauffhig
"20.12.88  TT  Pexec korrigiert: Speicher wird wieder freigegeben
"01.01.89  TT  Infinite loop bei PrepareExec & release0 behoben (zirk. Importe)
"17.02.89  TT  Nicht geladene, gelinkte Prgs liefern wieder korrekten Exitcode
"12.06.89  TT  zirkulare Importe werden im Loader automatisch gelst, Freigabe
0nun auch schneller.
"04.07.89  TT  Release nochmals berarbeitet und korrigiert
0>>> Freigabe zusammen mit MODCtrl/MODBase in MAUS M & MS.
"04.07.89  TT  Bei geladenen Prgs wird DATA-Bereich erst beim Starten kopiert.
"06.07.89  TT  Importierte Module drfen Load/CallModule schon aufrufen, bevor
0Hauptmodul init. ist (um z.B. Treiber nachzuladen). Es gibt
0brigens *keine* Probleme, wenn beide Programm dasselbe Modul
0importieren. Je nach Import-Reihenfolge wird dann das Modul
0entweder schon im 1. Proze init. und bleibt dann auch fr den
02. Proze aktiv oder es wird erst im 2. Proze init., aber dann
0wird es dort bei dem Prozeende auch wieder deinit. und beim
01. Proze wiederum neu initialisiert.
"20.08.89  TT  Pexec verwendet nun wieder mode 0 -> Modload wiederum anpassen
"08.09.89  TT  Kein Hnger mehr bei Removals
"05.11.89  TT  Removals werden nun in korrekter Reihenfolge aufgerufen
"20.12.89  TT  hahaha! 5.11. war auch nicht OK: Reihenfolge war genau andersrum
"01.01.90  TT  Ich kapiert gar nix mehr... nun wieder wie am 5.11.
"31.05.90  TT  Non-reentry-Behandlung fertig
"16.07.90  TT  Nun werden ALLE importierten Module mit non-reentry initial.;
0ExecMod rumt Speicher auch bei Fehlern korrekt wieder auf,
0dadurch geht auch kein Speicher mehr beim Start geladener Prgs
0verloren.
"02.10.90  TT  prgExec bergibt Prgname, damit TEMPUS 2.10 nicht abstrzt
"11.10.90  TT  Neue Real-Codes im Header ausgewertet
"18.11.90  TT  CallModule: DriverList- und Stacksize-Parms raus. Die sollen
0spter im Modulcode enthalten sein oder von CallModule in
0einem extra File selbst gesucht werden.
"26.11.90  TT  ExecMod: "tooManyMods"-Fehler eingefhrt (tritt auf, wenn
0ExecList berluft)
"06.12.90  TT  MaxModExec jetzt dynamisch in MOSConfig bestimmbar; IsModule()
0schliet nun Datei nach Zugriff; Module/Prgs werden nicht mehr
0anhand von Suffix sondern am Header erkannt.
"14.12.90  TT  Die Module mit $Y- werden NACH Aufruf aller Envelope-Routinen
0fr den Vater-Proze aufgerufen, damit die Envlp-Handler dann
0noch auf die Vars des Vaters zugreifen knnen (um z.B. Werte
0vom Vater an den Sohn zu kopieren - s. GEMEnv).
"17.12.90  TT  Die Stacksize wird aus dem Modheader bernommen, falls # 0.
"05.02.91  TT  Pfad wird aus Modulname bei Error-Msgs entfernt (errHandler);
0"BadLayout"-Fehler kommt, wenn's kein Prg/Modul ist (check-
0ExecRes).
"24.02.91  TT  Beim Start von geladenen Prgs wird "p_hitpa" nun korrekt
0verwaltet, so da z.B. TEMPUS 2.10 wieder fehlerfrei luft;
0DefaultStackSize kann nun jeden Wert annehmen, auch Null.
"28.02.91  TT  CallModule: Wenn 'arg[0]=CHR(127)', wird kein Lngenbyte
0eingefgt; Geladene Module/Prgs werden freigegeben, sobald der
0Clienten-Proze terminiert und das Modul nicht mit SysAlloc
0geladen wurde.
"18.04.91  TT  gesetztes Bit 7 (68020-Code) erzeugt keine Fehlermeldung wg.
0falscher FPU mehr.
"15.09.91  MS  Relocate zerstrt nicht mehr D3/A4
"14.02.92  TT  CallSuper statt Supexec
"23.02.92  TT  Stack wird in "CreateBasePage" alloziert.
"12.12.93  TT  prgFlags werden bei MM2-Modulen ausgewertet (f. TT-RAM usw.),
0bei gelinkten, geladenen Prgs vorerst nicht, da hier nicht klar
0ist, wie das geht.
"16.01.94  TT  Um das zu eigene Real-Format zu ermitteln, wird nicht mehr
0FPU() aufgerufen, weil das nicht mit den gelinkten Libs ber-
0einstimmen mu, sondern es wird RealMode abgefragt.
 *---------------------------------------------------------------------------*)
 
 (* Beim Relozieren Bus/Addr-Error abfangen ! *)
 
 FROM MOSGlobals IMPORT SfxStr, NameStr, PfxStr, MemArea, Overflow, IllegalState;
 
 FROM PrgCtrl IMPORT EnvlpCarrier, SetEnvelope, RemoveEnvelope, TermProcess;
 
 FROM MOSSupport IMPORT CallSuper;
 
 IMPORT SystemError;
 
 FROM SYSTEM IMPORT ASSEMBLER, CADR, ADR, WORD, ADDRESS, TSIZE, LONGWORD, BYTE;
 
 FROM Strings IMPORT Upper, Concat, Length, Pos, Copy, Append, Insert, PosLen,
4Compare, Relation, Empty, String, Assign, Split, Delete,
4StrEqual;
 
 FROM Storage IMPORT Inconsistent, SysAlloc, MemAvail, DeAllocate, ALLOCATE;
 FROM StorBase IMPORT FullStorBaseAccess;
 
 FROM MOSCtrl IMPORT RemovalRoot, RemovalEntry, CallSub, ProcessID, RealMode;
 
 FROM SysTypes IMPORT PtrBP;
 
 FROM ModBase IMPORT CallEnvelopes, ModLst, ModRef, ModStr, ModEntry,
0GetModRef, Release, ModStates, ModState, SearchDesc,
0SplitModName, ModLoaded, MarkState, Criterion, PtrBSS,
0FreeMod, ExecProcess, CreateBasePage, ModHeader;
 
 FROM Lists IMPORT ResetList, NextEntry, AppendEntry, RemoveEntry,
(FindEntry, List, LDir;
 
 FROM Paths IMPORT SearchFile, ListPos;
 FROM PathCtrl IMPORT PathList;
 
 FROM MOSConfig IMPORT LoaderMsg, MaxModExec;
 
 FROM Directory IMPORT MakeFullPath;
 FROM FileNames IMPORT FileSuffix, SplitName, FilePrefix, SplitPath;
 IMPORT FileNames;
 
 FROM SysInfo IMPORT UseStackFrame, CPU;
 FROM MOSSupport IMPORT ToSuper, ToUser;
 IMPORT XBRA;
 IMPORT Block;
 
 (*
"FROM Terminal IMPORT WriteLn, WriteString, Read, Write;
 *)
 
 CONST Trace = FALSE;
&Trace0 = FALSE; (* Prg Start *)
&Trace2 = FALSE; (* release *)
&Trace3 = FALSE; (* init *)
 
 (*$ ? Trace OR Trace0 OR Trace2 OR Trace3:
"VAR inch: CHAR;
 *)
 
 CONST
#MaxModNest = 15;
'anykey = 0L;        (* Joker fuer Modul-Key *)
 
&Kennung = "MM2L";
 
 TYPE tCallPtr = [0..MaxModNest];
 
 
'ExecCondition = (ExecAlways, ExecNever, ExecNew);
'
'ArgStr = ARRAY [0..127] OF CHAR;
&FileStr = ARRAY [0..141] OF CHAR;
 
 VAR
&CallPtr: tCallPtr;
$ChainName: ARRAY tCallPtr OF FileStr;
%ChainArg: ARRAY tCallPtr OF ArgStr;
 
$error, ok: BOOLEAN;
 
&ExecPtr: CARDINAL;
%ExecList: POINTER TO ARRAY [0..5000] OF ModRef;
 
 (* das geht nun ber msr2:
"PROCEDURE willBeInit (ref0:ModRef):BOOLEAN;
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.W  ExecPtr,D0
(MOVE.L  ExecList,A0
(MOVE.L  -(A3),D1
(BRA     c
&l CMP.L   (A0)+,D1
&c DBEQ    D0,l
(SEQ     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
&END
$END willBeInit;
$(*$L=*)
 *)
 
 PROCEDURE markForInit (ref0: ModRef): BOOLEAN;
"BEGIN
$(*$ ? Trace3: WriteLn; WriteString (ref0^.codeName^); WriteString (' marked for init.'); *)
$IF ExecPtr > MaxModExec THEN
&RETURN FALSE
$ELSE
&ExecList^[ExecPtr]:= ref0; inc (ExecPtr);
&RETURN TRUE
$END
"END markForInit;
 
 
 VAR enterFailed: BOOLEAN;
 
 PROCEDURE enterMods (open, child: BOOLEAN; VAR exitcode: INTEGER);
"(* jedes Modul vorbereiten, ggf. VarSpace retten/lschen *)
"VAR execThis: CARDINAL; ad: PtrBSS;
"BEGIN
$IF open & NOT child THEN
&(* wir sind der letzte Env-Handler *)
&execThis:= 0;
&WHILE execThis < ExecPtr DO
(WITH ExecList^[execThis]^ DO
*IF ~(initialized IN state) THEN
,Block.Clear (varRef, varLen)
*ELSIF ~(reentrant IN state) & ~(installed IN state) THEN
,(* bei nicht-reentrant-fhigen Modulen wird das alte BSS gerettet
-* und dann der BSS-Bereich wie blich gelscht *)
,(*$ ? Trace: WriteLn; WriteString (codename^); WriteString (' gets new BSS'); *)
,ALLOCATE (ad, varLen + 4L);
,IF ad = NIL THEN
.enterfailed:= TRUE;
.exitcode:= -39; (* out of mem *)
.RETURN
,END;
,Block.Copy (varRef, varLen, ADDRESS(ad) + 4L);
,ad^.prev:= prevBSS;
,prevBSS:= ad;
,Block.Clear (varRef, varLen)
*END;
(END;
(INC (execThis);
&END;
&enterfailed:= FALSE;
$END
"END enterMods;
 
 
 PROCEDURE Fopen ( REF fname: ARRAY OF CHAR; mode : Cardinal;
2VAR handle : Cardinal; VAR ior : Integer ) : Boolean;
"BEGIN
$ASSEMBLER
(MOVE    mode(A6),-(A7)
(MOVE.L  fname(A6),-(A7)
(MOVE    #$3D,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
(CLR     D1
(TST.L   D0
(BMI     err
(MOVE    D0,D1
(CLR     D0
"err   MOVE.L  ior(A6),A0
(MOVE    D0,(A0)
(MOVE.L  handle(A6),A0
(MOVE    D1,(A0)
$END;
$RETURN ior = 0
"END Fopen;
 
 PROCEDURE Fseek (handle:Cardinal; n:LongCard; mode:Cardinal; VAR p:Longword);
"BEGIN
$ASSEMBLER
(MOVE    mode(A6),-(A7)
(MOVE    handle(A6),-(A7)
(MOVE.L  n(A6),-(A7)
(MOVE    #$42,-(A7)
(TRAP    #1
(ADDA.W  #10,A7
(MOVE.L  p(A6),A0
(MOVE.L  D0,(A0)
$END;
"END Fseek;
 
 PROCEDURE Fclose (handle:Cardinal);
"BEGIN
$ASSEMBLER
(MOVE    handle(A6),-(A7)
(MOVE    #$3E,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
$END
"END Fclose;
 
 PROCEDURE Fread (handle:Cardinal; p: Address; l:LongInt): LONGINT;
"VAR res: LONGINT;
"BEGIN
$ASSEMBLER
(MOVE.L  p(A6),-(A7)
(MOVE.L  l(A6),-(A7)
(MOVE    handle(A6),-(A7)
(MOVE    #$3F,-(A7)
(TRAP    #1
(ADDA.W  #12,A7
(MOVE.L  D0,res(A6)
$END;
$RETURN res
"END Fread;
 
 
 PROCEDURE ldHead (handle: CARDINAL;
2VAR mlen: LONGCARD;
2VAR mid: BYTE;
2VAR loadres: LoaderResults);
"VAR chead: RECORD
/id: ARRAY [0..7] OF CHAR;
/layout: BYTE;
/modId: BYTE;
/res: ARRAY [1..8] OF BYTE;
/modlen: LONGCARD;
-END;
&l: LONGINT; modId2: CARDINAL;
"BEGIN
$l:= Fread (handle, ADR (chead), SIZE (chead));
$IF l < 0L THEN
&loadres := badFile;
$ELSE
&modId2:= ORD (chead.modId) MOD 16;
&IF (Compare ("MM2Code", chead.id) # equal)
&OR (ORD(chead.layout)>15)
&OR ( (modId2#1) & (modId2#2) ) THEN
(loadres:= badLayout;
&ELSE
(loadres:= noError;
(mlen:= chead.modlen;
(mid:= chead.modId
&END
$END;
"END ldHead;
 
 
 PROCEDURE IsModule ( REF fileName: ARRAY OF CHAR ): BOOLEAN;
"VAR handle: CARDINAL; ior: INTEGER; r: BOOLEAN; res: LoaderResults;
&lc: LONGCARD; b: BYTE;
"BEGIN
$IF Fopen (fileName,0,handle,ior) THEN
&ldHead (handle, lc, b, res);
&r:= res = noError;
&Fclose (handle)
$ELSE
&r:= FALSE
$END;
$RETURN r
"END IsModule;
 
 
 PROCEDURE SetChain ( REF ModName, Arg : ARRAY OF Char );
"(*
#* Modul fuer Chaining vormerken
#*)
"BEGIN
$Assign (ModName, ChainName [CallPtr],ok);
$Copy (arg,0,127,ChainArg [CallPtr],ok);
"END SetChain;
 
 
 PROCEDURE prgLoad (REF n:ARRAY OF CHAR): LONGINT;
"(*$L-*)
"BEGIN
$ASSEMBLER
(CLR.L   -(A7)           ; Environment
(MOVE.L  A7,-(A7)        ; Cmd-Line: Zeigt auf Leerstring
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)     ; Name des Prg.
(MOVE    #3,-(A7)        ; Load-Cmd
(MOVE    #$4B,-(A7)      ; Pexec()
(TRAP    #1
(ADDA.W  #16,A7
(MOVE.L  D0,(A3)+
$END
"END prgLoad;
"(*$L=*)
 
 
 PROCEDURE SetMsg (n: CARDINAL; VAR s: ARRAY OF CHAR);
"BEGIN
$IF LoaderMsg # NIL THEN
&Assign (LoaderMsg^[n], s, ok);
$END
"END SetMsg;
 
 PROCEDURE checkExecRes (execRes: INTEGER; VAR myRes: LoaderResults;
9REF name: ARRAY OF CHAR; VAR myMsg: ARRAY OF CHAR);
"VAR n: CARDINAL;
"BEGIN
$IF execRes = 0 THEN
&myRes:= noError;
&myMsg[0]:= ''
$ELSE
&IF (execRes = -46) OR (execRes = -33) OR (execRes = -34) THEN
(myRes:= notFound;
(n:= 11
&ELSIF (execRes = -39) THEN
(myRes:= outOfMemory;
(n:= 6
&ELSIF (execRes = -66) THEN
(myRes:= badLayout;
(n:= 4;
&ELSE
(myRes:= badFile;
(n:= 10
&END;
&SetMsg (n, myMsg);
&IF n = 4 THEN
(n:= PosLen ('@I',myMsg,0);
(Delete (myMsg,n,2,ok);
(Insert (FilePrefix(name),n,myMsg,ok);
&END
$END
"END checkExecRes;
 
 
 PROCEDURE MovStr (VAR s:ARRAY OF CHAR;d:Longword);
"(*$L-*)
"BEGIN
$ASSEMBLER
&MOVE.L  -10(A3),(A3)+
&MOVE.W  -10(A3),(A3)+
&JSR     Length
&MOVE.W  -(A3),D0
&CMPI    #127,D0
&BLS     ok0
&MOVEQ   #127,D0
$ok0
&MOVE.L  -(A3),A2
&SUBQ.L  #2,A3
&MOVE.L  -(A3),A1
&MOVE.B  D0,(A2)+
&BRA     cop
$clrlp
&MOVE.B  (A1)+,(A2)+
$cop
&DBRA    D0,clrlp
$END
"END MovStr;
"(*$L=*)
 
 
 PROCEDURE Mfree (addr: ADDRESS);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #$49,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
$END
"END Mfree;
"(*$L=*)
 
 PROCEDURE prgUnload (bp:PtrBP);
"BEGIN
$(* nicht DEALLOCATE verwenden, da sonst u.U. Fehler passieren?! *)
$Mfree (bp^.p_env); (* Environment freigeben *)
$Mfree (bp)         (* TPA / Prg. *)
"END prgUnload;
 
 PROCEDURE Mshrink (addr: ADDRESS; newAmount: LONGCARD);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(CLR.W   -(A7)
(MOVE    #$4A,-(A7)
(TRAP    #1
(ADDA.W  #12,A7
$END
"END Mshrink;
"(*$L=*)
 
 PROCEDURE envLength (env: ADDRESS): LONGCARD;
"(* Liefert die Lnge eines Environment-Strings *)
"VAR (*$Reg*) p: POINTER TO CHAR;
"BEGIN
$p:= env;
$WHILE p^ # 0C DO
&REPEAT
(INC (p)
&UNTIL p^ = 0C;
&INC (p)
$END;
$RETURN ADDRESS (p) - env + 2
"END envLength;
 
 PROCEDURE CodeSize (bp: PtrBP): LONGCARD;
"(* Liefert Lnge des statisch belegten Bereichs ohne den Heap-Bonus *)
"BEGIN
$WITH bp^ DO RETURN 256 + p_tlen + p_dlen + p_blen END
"END CodeSize;
 
 PROCEDURE prgPrepare (bp:PtrBP; heap:LONGCARD): BOOLEAN;
"VAR newlen:LONGCARD; bpsize: LONGCARD;
"BEGIN
$(* belegter Speicher (TPA): *)
$bpsize:= LONGCARD (bp^.p_hitpa) - LONGCARD (bp);
$(* bentigter Speicher: *)
$newlen:= CodeSize (bp) + heap;
$(* Haben wir genug im TPA erhalten? *)
$IF newlen > bpsize THEN
&prgUnload (bp);
&RETURN FALSE
$END;
$(* TPA verkleinern *)
$Mshrink (bp, newlen);
$bp^.p_hitpa:= ADDRESS (bp) + newlen;
$RETURN TRUE
"END prgPrepare;
 
 VAR     CurrentField, CurrentBasePage: ADDRESS;
(TPAOffset: LONGCARD;
(GemdosEntry: ADDRESS;
(StackFrameOffs: SHORTCARD;
(Carrier: XBRA.Carrier;
 
 PROCEDURE removeGemdosHdler;
"(*
#* Trgt den hiesigen GEMDOS-Handler (hdlGemdos) aus.
#*)
"(*$L-*)
"BEGIN
$ASSEMBLER
(LEA     Carrier,A2
(ADDA.W  #12,A2
(LEA     $84,A0          ; A0: Vektoradr.
%l: MOVE.L  (A0),A1
(CMPA.L  A2,A1           ; 'entry' gefunden?
(BEQ     f
(CMPI.L  #$58425241,-12(A1) ; Ist dies ein XBRA-Eintrag?
(BNE     n               ; Nein -> Ende
(LEA     -4(A1),A0       ; Vorige Vektoradr. nach A0
(CMPA.L  (A0),A1         ; Vektor zeigt auf sich selbst?
(BEQ     n
(BRA     l
%f: MOVE.L  -4(A1),(A0)     ; Entry.old eintragen
%n:
$END;
"END removeGemdosHdler;
"(*$L=*)
 
 PROCEDURE hdlGemdos;
 (*
!* Diese Funktion hngt im GEMDOS-TRAP-Handler und wartet darauf, da
!* das ber 'CallProgram' gestartete Programm die 'Mshrink'-Funktion
!* aufruft. Dann wird daraus die bentigte Heap-Gre ermittelt und
!* diese Funktion wieder ausgehngt.
!*)
"(*$L-*)
"BEGIN
$ASSEMBLER
(BTST.B  #5,(A7)         ; War Supervisormode aktiv ?
(BNE.B   super           ; Ja, dann stehen Arg. auf SSP
(MOVE.L  USP,A0
(CMPI.W  #$4A,(A0)       ; Mshrink - Funktion ?
(BEQ.B   hdlMshrinkUser
 dos     ; normale GEMDOS-Funktion ausfhren
(MOVE.L  GemdosEntry,A0
(MOVE.L  -4(A0),A0
(JMP     (A0)
 super   MOVE.W  StackFrameOffs,D0 ; damit es auch mit einer 68010/20/30 geht
(CMPI.W  #$4A,6(A7,D0.W) ; Mshrink - Funktion ?
(BNE.B   dos             ; Nein -> GEMDOS aufrufen
(LEA     6(A7,D0.W),A0   ; Basis d. Argumente nach A0
 hdlMshrinkUser
(MOVE.L  4(A0),A1        ; Argument 'addr' von Mshrink (addr, newamount)
(CMPA.L  CurrentBasePage,A1 ; ist es die TPA des gesuchten Programms?
(BNE     dos
(MOVE.L  8(A0),D0        ; 'newamount'-Parm von Mshrink: neue TPA-Gre
(MOVE.L  D0,D1
(ADD.L   A1,D0
(CMP.L   4(A1),D0        ; newamout > p_hitpa (alte TPA-Gre)?
(BHI     noNewHi         ;  dann ist zu wenig Speicher da
(MOVE.L  D0,4(A1)        ; p_hitpa in Base Page neu setzen
 noNewHi
 (*
(TST.L   UsedHeapSize
(BPL     ignore          ; Heap-Gre wurde bereits ermittelt
(SUB.L   TPAOffset,D1    ; Subtr. die Gre des stat. Bereichs ohne Heap
(MOVE.L  D1,UsedHeapSize ; Das ist die gesuchte Heap-Gre
(MOVE.L  CurrentField,A0
(MOVE.L  D1,PrgEntry.neededHeapSize(A0)
(CMP.L   PrgEntry.currentHeapSize(A0),D1
(BCC     ignore
(MOVE.L  D1,PrgEntry.currentHeapSize(A0)
 ignore
 *)
(; Diese Routine kann nun aus dem GEMDOS-TRAP entfernt werden
(JSR     removeGemdosHdler
(BRA     dos     ; Nun lassen wir endlich Mshrink ausfhren
$END
"END hdlGemdos;
"(*$L=*)
 
 PROCEDURE prgExec (bp:PtrBP; name: ADDRESS; REF arg: ArgStr;
3env: ADDRESS; VAR res: INTEGER): BOOLEAN;
"(*
#* geladenes, gelinktes Programm starten
#*)
 
"VAR el, dl: LONGCARD; envcopy, hitpa, data: ADDRESS;
 
"BEGIN
$dl:= bp^.p_dlen + 128L;  (* Lnge des zu rettenden Data/Basepage-Bereichs *)
$ALLOCATE (data,dl);
$IF data = NIL THEN
&RETURN FALSE
$END;
$Block.Copy (bp,128,data);
$Block.Copy (bp^.p_dbase,bp^.p_dlen,data+128L);
$Block.Clear (bp^.p_bbase, bp^.p_hitpa - bp^.p_bbase);
 
$(* Environment kopieren, da Pexec dies wie so vieles *
%* beim Nur-Starten flschlicherweise nicht tut.    *)
$
$IF env # 0 THEN
&el:= envLength (env);
&ALLOCATE (envcopy, el);
&IF envcopy = NIL THEN
(RETURN FALSE
&END;
&Block.Copy (env, el, envcopy);
&bp^.p_env:= envcopy; (* p_env wird am Ende wg. ganzer BP restauriert *)
$END;
 
$Block.Copy (CADR(arg),128,ADR(bp^.cmdline));
$(*$?Trace0:Write('4');Read(inch);IF Inconsistent() THEN HALT END;*)
$ASSEMBLER
(MOVE.L  bp(A6),A0
(
(; Pfade v. Parent bernehmen
(MOVE.L  ProcessID,A2
(MOVE.L  (A2),A2
(MOVE.B  $37(A2),$37(A0) ; Default-Drive
(MOVEQ   #7,D0           ; 16 Pfade (Bytes-Handles)
(LEA     $40(A0),A1
(LEA     $40(A2),A2
&lll:
(MOVE.W  (A2)+,(A1)+
(DBRA    D0,lll
(
(; DTA auf Cmdline
(MOVE.L  A0,A1
(ADDA.W  #128,A1
(MOVE.L  A1,PtrBP.p_dta(A0)
$END;
 
$(* 'hdlGemdos' in TRAP #1 einhngen *)
$XBRA.Create (Carrier, Kennung, ADDRESS (hdlGemdos), GemdosEntry);
$XBRA.Install (GemdosEntry, $84);
 
$(* Proze starten *)
$TPAOffset:= CodeSize (bp);
$CurrentBasePage:= bp;
$ASSEMBLER
(; GEMDOS.Pexec (4, filename, bp, env, exitcode);
(MOVE.L  env(A6),-(A7)   ; unused
(MOVE.L  bp(A6),-(A7)    ; ^basepage
(MOVE.L  name(A6),-(A7)  ; unused, f. Kompatibilitt: ^path
(MOVE    #4,-(A7)        ; Exec-Cmd
(MOVE    #$4B,-(A7)      ; Pexec()
(TRAP    #1
(ADDA.W  #16,A7
(MOVE.L  res(A6),A0
(MOVE.W  D0,(A0)
$END;
$CurrentBasePage:= NIL;
 
$(* 'hdlGemdos' wieder aushngen *)
$ASSEMBLER
(PEA     removeGemdosHdler
(JSR     CallSuper
(ADDQ.L  #4,A7
$END;
$
$IF env # 0 THEN
&DEALLOCATE (envcopy, 0)  (* Kopie vom Environment wieder freigeben *)
$END;
 
$(*$?Trace0:Write('5');Read(inch);IF Inconsistent() THEN HALT END;*)
$hitpa:= bp^.p_hitpa;
$Block.Copy (data,128,bp);
$bp^.p_hitpa:= hitpa;
$Block.Copy (data+128L,bp^.p_dlen,bp^.p_dbase);
$DEALLOCATE (data, 0L);
$RETURN TRUE
"END prgExec;
 
 (*
 PROCEDURE tosPrg (VAR mname:ARRAY OF Char): BOOLEAN;
"VAR sfx: SfxStr; i:CARDINAL;
"BEGIN
$sfx:= FileSuffix (mname);
$IF sfx[0] # 0C THEN
&Upper (sfx);
&FOR i:=1 TO NoOfPrgSfx DO
(IF StrEqual (PrgSfx [i], sfx) THEN
*RETURN TRUE
(END
&END
$END;
$RETURN FALSE
"END tosPrg;
 *)
 
 MODULE loader0;
 
 IMPORT ASSEMBLER, ExecList, ExecPtr, ModRef, TermProcess, Block,
'Monitor, ModState, ADDRESS, ModEntry (*, ModUtil2 *),
'CPU, ToSuper, ToUser;
 
 EXPORT initMods;
 
 PROCEDURE execBody (mod0: ModRef; mon: ADDRESS);
"(*$L-*)
"BEGIN
$ASSEMBLER
&MOVE.L    -(A3),D0
&MOVE.L    -(A3),A1
&MOVEM.L D3-D7/A3-A6,-(A7)
 
&PEA     modReturn(PC)
 
&MOVE.L  ModEntry.header(A1),A1
&ADDA.L  6(A1),A1     ;Adresse des Rumpfes berechnen
&PEA     (A1)
 
&TST.L   D0
&BNE     moncall
&RTS
$moncall
&MOVE.L  D0,A1
&JMP     (A1)
&
$modReturn
&MOVEM.L (A7)+,D3-D7/A3-A6
$END
"END execBody;
"(*$L=*)
 
 PROCEDURE initMods;
"VAR execThis: CARDINAL; mod0: ModRef; mon: ADDRESS;
"BEGIN
$execThis:= 0;
$mon:= NIL;
$WHILE execThis < ExecPtr DO
&mod0:= ExecList^[execThis];
&INC (execThis);
&WITH mod0^ DO
(IF ~(initialized IN state) THEN
*INCL (state,initialized);
*INCL (state,firstcall);
(END;
&END;
&IF execThis = ExecPtr THEN
(mon:= ADDRESS (Monitor);
&END;
&(* ModUtil2.CallBody (mod0); *)
&execBody (mod0, mon);
&(* ModUtil2.LeaveBody (mod0); *)
&EXCL (mod0^.state,firstcall)
$END;
"END initMods;
 
 END loader0;
 
 
 PROCEDURE outerErrHandler (REF name, clientname: ARRAY OF CHAR;
;nowImport: BOOLEAN; errtype: LoaderResults;
;VAR errmsg: ARRAY OF CHAR);
"PROCEDURE get (idx,n:CARDINAL);
$BEGIN
&SetMsg (idx, errmsg);
&IF n#0 THEN
(idx:= PosLen ('@I',errmsg,0);
(Delete (errmsg,idx,2,ok);
(Insert (FilePrefix(name),idx,errmsg,ok);
(IF n=2 THEN
*idx:= PosLen ('@C',errmsg,0);
*Delete (errmsg,idx,2,ok);
*Insert (clientname,idx,errmsg,ok);
(END
&END
$END get;
"BEGIN
$CASE errtype OF
&badversion:
(get (5,2)|
&BadLayout:
(get (4,1)|
&NotFound:
(IF nowImport THEN
*get (1,2)
(ELSE
*get (0,1)
(END|
&BadFile:
(get (2,1)|
&BadData:
(get (3,1)|
&OutOfMemory:
(get (6,0)|
&denied:
(get (7,1)|
&initFault:
(get (12,0)|
&exitFault:
(get (13,0)|
&notLinkable:
(get (14,1)|
&wrongRealForm:
(get (15,1)|
&wrongFPUType:
(get (16,1)|
&tooManyMods:
(get (17,0)|
$ELSE HALT
$END
"END outerErrHandler;
 
 (*$X+*)
 PROCEDURE FlushCPUCache ();
"BEGIN
$ASSEMBLER
(JSR     CPU
(SUBQ.L  #4,A7
(JSR     ToSuper
(MOVE.L  -(A3),D0
(CMPI.L  #68020,D0
(BCS     ende
(CMPI.L  #68040,D0
(BCS     fl30
(NOP
(DC.W    $F4F8           ; CPUSHA BC
(BRA     ende
"fl30: MOVEC   CACR,D0
(ORI     #$0808,D0
(MOVEC   D0,CACR
"ende: JSR     ToUser
(ADDQ.L  #4,A7
$END
"END FlushCPUCache;
 (*$X=*)
 
 PROCEDURE ExecMod (REF mainName: ARRAY OF CHAR;  (* Name des gewuenschten Moduls *)
4exec: ExecCondition;  (* wann ausfuehren? *)
3Paths: PathList;
1REF Arg: ArgStr;
5env: ADDRESS;
,VAR ExitCode: Integer;
.VAR ErrMsg: ARRAY OF CHAR;
-VAR loadres: LoaderResults)
8: ModRef;         (* vergebener Index *)
8
#VAR nowimport: Boolean;
'clientname: ModStr;
 
"PROCEDURE errHandler (REF name:ARRAY OF CHAR; errtype:loaderresults);
$BEGIN
&outerErrHandler (name, clientname, nowImport, errtype, errmsg)
$END errHandler;
 
"PROCEDURE LinkMod (msname: ARRAY OF Char; (* Name des Moduls *)
4reqkey: LONGCARD;       (* gewuenschter Key *)
6exec: ExecCondition;  (* wann ausfuehren? *)
4client: ModRef)         (* Index des Klienten *)
:: ModRef;         (* vergebener Index *)
"
"(* Laedt das Modul "msname" und liefert dessen Index in der "ModLst"
#* als Ergebnis.
#* Der Modulkey "reqkey" wird erwartet und ueberprueft;
#* Falls ein Fehler beim Relozieren oder Laden auftritt,
#* wird der benoetigte Speicher freigegeben und als Ergebnis
#* "NIL" geliefert
#*)
$
$VAR newname: FileStr;
"
$PROCEDURE MakeImpList (ref0:ModRef); (* Importliste erstellen *)
&
&PROCEDURE getImport (VAR p:ADDRESS; VAR name: ARRAY OF CHAR): BOOLEAN;
((*$L-*)
(BEGIN
*ASSEMBLER
2MOVE    -(A3),D1
2MOVE.L  -(A3),A0
2MOVE.L  -(A3),A2
2MOVE.L  (A2),A1
2TST.L   (A1)+           ; KEY
2BEQ     F
2; NAMEN HOLEN
0L MOVE.B  (A1)+,D0
2CMPI.B  #$FE,D0
2BCC     E
2MOVE.B  D0,(A0)+
2DBRA    D1,L
2BRA     T
0E CLR.B   (A0)+
2BRA     T
0M MOVE.B  (A1)+,D0
0T ADDQ.B  #1,D0
2BNE     M
2; ENDE DES NAMENS ERREICHT; LISTENENDE SUCHEN
0q TST     (A1)+
2BEQ     O
2ADDQ.L  #4,A1
2BRA     q
0O MOVE.L  A1,(A2)
2MOVE    #1,(A3)+
2RTS
0F CLR     (A3)+
*END
(END getImport;
((*$L+*)
&
&VAR implist: ADDRESS;
*name: ModStr;
*n: CARDINAL;
*s: SearchDesc;
*
&BEGIN (* MakeImpList *)
(ASSEMBLER
*MOVE.L  ref0(A6),A0
*MOVE.L  modref.header(A0),A1
*MOVE.L  $E(A1),D0
*ADD.L   A1,D0
*MOVE.L  D0,modref.imports(A0)
*MOVE.L  D0,implist(A6)
(END;
(n:=0;
(WHILE getImport (implist,name) DO
*s.mode:= modName;
*s.mname:= ADR (name);
*GetModRef (s,ref0^.imports^[n]);
*INC (n)
(END;
(ref0^.imports^[n]:= NIL
&END MakeImpList;
 
$PROCEDURE ReadMod (REF fname: ARRAY OF CHAR;
7VAR mname: ARRAY OF CHAR): ModRef;
$(*-----------------------------------------------*)
$(* Laedt ein Modul in den Speicher, ueberprueft das Format
%* und traegt in die Modul-Liste ein. Reloziert nicht!
%* Wenn ein Fehler auftritt, wird der benutzte Speicher
%* freigegeben und als Modul-Index NIL geliefert.
%* 'fname': Dateiname; 'mname': Modulname, wird ggf. korrgiert.
%*)
&
$
$TYPE BSET = SET OF [0..7];
$
$VAR modad: ADDRESS;
'maxlen: LongCard;
&loadlen,
)cend,
&headlen,
'modlen: LongCard;
'cstart: ADDRESS;
(cname: POINTER TO ModStr;
'cname0: ModStr;
'cname1: ModStr;
'dummyl,
)flen: LongCard;
%foundkey: LONGCARD;
(found: boolean;
(modId: BYTE;
'modId3: BSET;
%realCode: CARDINAL;
'handle: Cardinal;
#searchMode: ListPos;
*ior: INTEGER;
(modst: ModRef;
&reenter: BOOLEAN;
 
$BEGIN (* ReadMod *)
&(*$ ? Trace: WriteLn; WriteString ('ReadMod: '); WriteString (fname); *)
&searchMode:= fromStart;
&IF nowimport THEN
(Assign (mname, cname1, ok);
(Upper (cname1);
&ELSE
((* Pfad entfernen fr evtl. Fehlermeldung *)
(SplitPath (mname, cname1(*dummy*), mname);
&END;
&REPEAT
(SearchFile (fname,Paths,searchMode,found,newname);
(IF ~found THEN
*(*$ ? Trace: WriteLn; WriteString ('exit: not found'); *)
*loadres:= notfound;
*RETURN NIL
(END;
(searchMode:= fromNext;
(
(MakeFullPath (newname, ior);
(IF ~Fopen (newname,0,handle,ior) THEN
*IF (ior = -33) OR (ior = -34) OR (ior = -46) THEN
,(*$ ? Trace: WriteLn; WriteString ('exit: not found 2'); *)
,loadres:= notfound;
*ELSE
,(*$ ? Trace: WriteLn; WriteString ('exit: bad file'); *)
,loadres:= badFile;
*END;
*RETURN NIL
(END;
(
(ldHead (handle, modLen, modId, loadres);
(IF loadres # noError THEN
*Fclose (handle);
*RETURN NIL
(END;
(Fseek (handle,0,2,flen);           (* Get length of file *)
(Fseek (handle,8,0,dummyl);         (* Seek hinter "MM2Code" *)
(DEC (flen, 8); (* weil erst ab 8. byte geladen wird *)
 
(modId3:= BSET (modId);
(ASSEMBLER
*MOVE.B  modId(A6),D0
*LSR.B   #5,D0
*ANDI.W  #3,D0
*MOVE.W  D0,realCode(A6)
(END;
 
(IF flen > modlen THEN (* !!! *)
*loadlen := flen
(ELSE
*loadlen := modlen
(END;
 
(loadLen:= loadLen + TSIZE (ModEntry);
 
(SysAlloc (modst, loadlen);
(IF modst = NIL THEN
*(* ! Eigentlich sollte hier der Fehler noch nicht auftreten, weil
+*   noch nicht sicher ist, ob dies berhaupt das richtige File ist.*)
*(*$ ? Trace:
,WriteLn; WriteString ('exit: no memory');
**)
*Fclose (handle);
*loadres:= outofmemory;
*RETURN NIL
(END;
(
(modad:= ADDRESS (modst) + TSIZE (ModEntry);
(
(IF Fread (handle,modad,flen) <= 0L THEN
*(*$ ? Trace:
,WriteLn; WriteString ('exit: bad file 3');
**)
*Fclose (handle);
*loadres := badFile;
*DeAllocate (modst,0L);
*RETURN NIL
(END;
(
(Fclose (handle);
(
(ASSEMBLER
*MOVE.L  modad(A6),A0
*MOVE.L  2(A0),foundkey(A6)
*MOVE.L  42(A0),D0
*MOVE.L  D0,headlen(A6)
*ADD.L   A0,D0
*MOVE.L  D0,cstart(A6)
*MOVE.L  22(A0),cend(A6)
*MOVE.L  46(A0),D0     ; Options laden
*BTST    #25,D0        ; $Y+? dann ist Modul-Reentry mglich
*SNE     D0
*ANDI    #1,D0
*MOVE    D0,reenter(A6)
*MOVE.L  30(A0),D0
*ADD.L   A0,D0
*MOVE.L  D0,cname(A6)
(END;
(cname0:=cname^;
(Upper (cname0);
&UNTIL ~nowimport OR StrEqual (cname0,cname1);
&(*$ ? Trace:
(WriteLn; WriteString ('read ok');
&*)
 
&IF realCode # 0 THEN
((*
)* Falls das Modul Reals benutzt, mu geprft werden, ob
)* die vorhandenen Libs das richtige Format und die richtigen
)* Runtime-Calls untersttzt. Da wir auf jeden Fall Runtime
)* eingelinkt haben, knnen wir pauschal davon ausgehen, da0
)* zumindest einer der 3 mgl. Real-Modi gesetzt ist (theoretisch
)* gbe es ja noch den Fall, da keine der gelinkten Libs Reals
)* benutzt und daher das Format noch undefiniert wre).
)*)
(IF RealMode # realCode THEN
*IF (realCode > 1) & (RealMode > 1) THEN
,loadres:= wrongFPUType; (* beides IEEE, aber falsche FPU *)
*ELSE
,loadres:= wrongRealForm; (* IEEE <-> MM2Reals *)
*END;
*Fclose (handle);
*DeAllocate (modst,0L);
*RETURN NIL
(END;
&END;
&
&Assign (cname^, mname, ok);
&
&IF (reqkey#anykey) & (reqkey#foundkey) THEN
((*$ ? Trace:
*WriteLn; WriteString ('exit: bad version');
(*)
(loadres := badversion;
(DeAllocate (modst,0L);
(RETURN NIL
&END;
&
&(* Modul in ModLst eintragen *)
&
&AppendEntry(ModLst,modst,error);
&IF error THEN
((*$ ? Trace:
*WriteLn; WriteString ('exit: no memory 2');
(*)
(DeAllocate (modst,0L);
(loadres:= outofmemory;
(RETURN NIL
&END;
&WITH modst^ DO
(codeName:= ADDRESS (cname);
(Assign (cname0,codeNameUp,ok);
((*SplitPath (newname, filePath, fn); SplitName (fn, fileName, sfx);*)
(fileName:= FilePrefix (newname);
(header:= modad;
(codeStart:= cstart;
(codeLen:= cend-headlen;
(varRef:= cend+modad;
(varLen:= modlen-cend;
(state:= ModStates {};
(IF 4 IN modId3 THEN INCL (state, procSym) END;
(IF reenter THEN INCL (state, reentrant) END;
(imports:= NIL;
(prevBSS:= NIL;
(IF FullStorBaseAccess () THEN
*owner:= NIL
(ELSE
*owner:= ProcessID^
(END
&END;
&Assign (cname^,clientname,ok);
&loadres:= noError;
&RETURN modst
$END ReadMod;
$
$
$PROCEDURE Relocate ( header: Address;
8myIndex: ModRef;
;exec: ExecCondition): BOOLEAN;
$
$VAR  Result: Boolean;
$
$BEGIN
&ASSEMBLER
,MOVEM.L D3/A4, -(SP)     ; !MS D3/A4 retten
,CLR.W   Result(A6)       ;kann nur noch besser werden
,MOVE.L  header(A6),A4    ;A4 zeigt auf zu relozierendes Modul
,MOVE.L  22(A4),A0
,ADDA.L  A4,A0
&!RE3  MOVE.L  (A0)+,D0    ;Var/Proc-Liste abarbeiten
,BEQ     RE1
,MOVE.L  (A0)+,D1
,ADD.L   A4,D1
&!RE2  MOVE.L  0(A4,D0.L),D2
,MOVE.L  D1,0(A4,D0.L)
,MOVE.L  D2,D0
,BNE     RE2
,BRA     RE3
,
&!RE1  MOVE.L  14(A4),A1   ;A1 zeigt auf Import-Liste
,ADDA.L  A4,A1
&!RE5  MOVE.L  (A1)+,D0    ;Key des importierten Moduls
,BEQ.L   RE4         ;keine IMPORTs mehr
,
,; wir bereiten den Filenamen vor. Zuerstmal auf den A3 Stack
,CLR.W   D1
&!RE13 MOVE.B  (A1)+,D2
,CMPI.B  #$FE,D2     ;statt BMI, damit auf  mglich ist.
,BCC     RE12
,MOVE.B  D2,(A3)+
,ADDQ.W  #1,D1
,BRA     RE13
&!RE12 ADDQ.B  #1,D2       ;Sync A1
,BEQ     RE14
,ADDQ.L  #1,A1
&!RE14 CLR.B   (A3)+
,MOVE.L  A3,D2
,BTST    #0,D2
,BEQ     nosync
,ADDQ    #1,D1
,ADDQ.L  #1,A3
%nosync ; nun den Kram aufn A7 Stack
,MOVE    D1,D2
,ADDQ    #1,D2
,LSR     #1,D2
,SUBQ    #1,D2
$trfname MOVE    -(A3),-(A7)
,DBRA    D2,trfname
,MOVE.L  A7,(A3)+    ;und die Adresse des Strings aufn A3
,MOVE.W  D1,(A3)+    ;samt dem High-Wert
,
,MOVE.L  D0,(A3)+           ;Key
,MOVE.W  exec(A6),(A3)+
,MOVE.L  myIndex(A6),(A3)+  ;myIndex ist klienten-Index
,MOVEM.L D1/A4/A1,-(A7)
,MOVE.L  (A6),A0            ;Dynamic Link fuer ProcCall
,MOVE.L  (A0),D2
,BSR     LinkMod
,(*$ ? Trace:
.END;
0Read (inch);
.ASSEMBLER
,*)
,MOVEM.L (A7)+,D1/A4/A1
,ADDQ.W  #1,D1
,ADDA.W  D1,A7       ;mname vom Stack runter
,MOVE.L  -(A3),D0    ;Index des importierten Moduls
,BEQ     BAD         ;da gab's wohl irgendwo einen Fehler
,MOVE.L  D0,A2
,MOVE.L  ModEntry.header(A2),A2
&!RE6  MOVE.W  (A1)+,D0    ;imp. ItemNr
,BEQ     RE5
,MOVE.L  18(A2),D3   ;Offset zur Exp.liste
,BEQ     BAD         ;keine da
,ADD.L   A2,D3
,MOVE.L  (A1)+,D1    ;importiertes Item
,BEQ     RE6
,MOVE.L  D3,A0
&!RE9  MOVE.W  (A0)+,D2    ;Item in Exportliste suchen
,BEQ     BAD
,CMP.W   D2,D0
,BEQ     RE10
,ADDQ.L  #4,A0
,BRA     RE9
&!RE10 MOVE.L  (A0)+,D2    ;abs. ItemAdr ausrechnen
,ADD.L   A2,D2
&!RE11 MOVE.L  0(A4,D1.L),D0 ;ItemAdr im Modul nachtragen
,MOVE.L  D2,0(A4,D1.L)
,MOVE.L  D0,D1
,BNE     RE11
,BRA     RE6
&!RE4  MOVE.W  #1,Result(A6) ;alles klar
&!BAD  MOVEM.L (SP)+, D3/A4  ; !MS Register restaurieren
&END;
&FlushCPUCache ();
&RETURN Result
$END Relocate;
"
"PROCEDURE PrepareExec (ref0:ModRef; mustBeDeInit:BOOLEAN): BOOLEAN;
$(*
%* Bereitet das geladene Modul und ggf. seine zu initialisierenden
%* Importe auf ein Init vor.
%* mustBeDeInit: "Modul mu deinit. sein, um gestartet werden zu drfen"
%*)
$VAR j: POINTER TO ModRef;
$BEGIN
&WITH ref0^ DO
(INCL (state, msr1);
(IF ~(initialized IN state)              (* noch nicht init.? *)
(OR ~mustBeDeInit & (installed IN state) (* oder installed? *) THEN
*(*
+* Da das Modul noch nicht init. ist, wird es dafr vorgemerkt.
+* Zuvor mssen aber noch seine Importe geprft werden:
+*)
*IF imports # NIL THEN
,j:= ADDRESS (imports);
,LOOP
.IF j^=NIL THEN EXIT END;
.IF NOT (msr1 IN j^^.state) THEN
0IF NOT PrepareExec (j^, TRUE) THEN RETURN FALSE END
.END;
.INC (j, 4)
,END
*END;
*(*$ ? Trace OR Trace3: WriteLn; WriteString (codename^); WriteString (' will be executed'); *)
*IF NOT (msr2 IN ref0^.state) THEN
,INCL (ref0^.state, msr2);
,IF NOT markForInit (ref0) THEN
.loadRes:= tooManyMods;
.errHandler (mainName,loadRes);
.RETURN FALSE
,END;
*END
(END;
&END;
&RETURN TRUE
$END PrepareExec;
"
"VAR fname : FileStr;
&execRel: ExecCondition;
&ref0: ModRef;
&basepage: PtrBP;
&ior: INTEGER;
&ploadres: LONGINT;
&found: BOOLEAN;
&fn: NameStr;
&sfx: ARRAY [0..2] OF CHAR;
 
"PROCEDURE prgInstall (): BOOLEAN;
$VAR err: BOOLEAN;
$BEGIN
&SysAlloc (ref0,TSIZE (ModEntry));
&IF ref0 # NIL THEN
(Block.Clear (ref0,SIZE(ref0^));
(AppendEntry(ModLst,ref0,err);
&ELSE
(err:= TRUE;
&END;
&RETURN ~err
$END prgInstall;
 
"BEGIN (* of LinkMod *)
$FlushCPUCache ();
$(*$ ? Trace: WriteLn; WriteString ('LinkMod: '); WriteString (msname); *)
$IF client # NIL THEN
&clientname := client^.codename^
$END;
$
$IF ModLoaded (msname,nowimport,fname,ref0) THEN
&(*$ ? Trace: WriteString (', already in RAM, '); *)
&WITH ref0^ DO
(IF program IN state THEN
*(*$ ? Trace: WriteString (' is program'); *)
*RETURN ref0
(ELSIF (reqkey#anykey) & (reqkey#header^.key) THEN
*(*$ ? Trace: WriteString ('bad version'); *)
*loadres := badversion;
*errHandler (codeName^,badversion);
*RETURN NIL
(ELSE (* tatsaechlich: wir haben das richtige Modul im RAM *)
*(*$ ? Trace: WriteString ('version ok.'); *)
*IF exec = execAlways (* zu startendes Hauptmodul *) THEN
,IF (installed IN state) OR ~(initialized IN state) THEN
.IF NOT (msr1 IN state) THEN
0IF NOT PrepareExec (ref0, FALSE) THEN
2RETURN NIL
0END
.END
,ELSE
.(*$ ? Trace: WriteLn; WriteString ('error: already initialized !'); *)
.loadres := denied;
.errHandler (codeName^,denied);
.RETURN NIL
,END
*ELSIF exec = execNew (* importiertes, bereits nachgeladenes Modul *) THEN
,IF NOT (msr1 IN state) THEN
.IF NOT PrepareExec (ref0, TRUE) THEN
0RETURN NIL
.END
,END
*END;
*RETURN ref0
(END
&END
$END;
$
$(*
%* Hier kommen wir an, wenn Modul nicht im RAM liegt
%*)
$
$IF Empty (FilePrefix (fname)) THEN
&(* ungltiger Modul-/Dateiname *)
&loadres:= notfound;
&SetMsg (8, errmsg);
&RETURN NIL
$END;
$
$ref0 := ReadMod (fname, msname);
$(*$ ? Trace: Read (inch); *)
$IF ref0 # NIL THEN (* Load war erfolgreich *)
&(*$ ? Trace: WriteLn; WriteString (msname); WriteString (': load ok'); *)
&nowimport:= True;
&IF exec = execNever THEN execRel:= execNever ELSE execRel:= execNew END;
&(*
'* Wir mssen hier schon das Modul markieren, weil sonst bei
'* zirkulren Importen dies Modul zu frh init. wrde (z.B. beim
'* Compiler)
'*)
&INCL (ref0^.state, msr2);
&IF Relocate (ref0^.header, ref0, execRel) THEN
((*$ ? Trace: WriteLn; WriteString (msname); WriteString (': relocate ok, '); *)
(MakeImpList (ref0);
(IF exec # execNever THEN
*(*$ ? Trace: WriteString ('will be executed.'); *)
*IF NOT markForInit (ref0) THEN
,loadRes:= tooManyMods;
,errHandler (mainName,loadRes);
,Release (ref0,FALSE,FALSE);
,RETURN NIL
*END
(END;
(WITH ref0^ DO
*Loading (codeName^,newName,codeStart,codeLen,varRef,varLen);
(END;
(RETURN ref0
&ELSE (* Relocate ist schiefgegangen *)
((*$ ? Trace: WriteLn; WriteString (msname); WriteString (': relocate error'); *)
(IF loadRes = noError THEN
*loadRes:= notLinkable;
*errHandler (ref0^.codeName^,loadRes)
(END;
(MakeImpList (ref0); (* damit alle imp. Module wieder freigegb. werden*)
(Release (ref0,FALSE,FALSE);
(RETURN NIL
&END;
$ELSE (* Load ist schiefgegangen *)
&IF loadres # badLayout THEN
((*$ ? Trace: WriteLn; WriteString (msname); WriteString (': load error'); *)
(errHandler (msname,loadres);
(RETURN NIL
&ELSE
((* ...dann mte es ein TOS-Prg sein *)
((*$ ? Trace: WriteString (', loading program.'); *)
(ploadres:= prgLoad (newname);
(IF ploadres < 0L THEN
*checkExecRes (SHORT (ploadres), loadRes, msname, errmsg);
*RETURN NIL
(ELSE
*errMsg[0]:=0C;
*basepage:= PtrBP (ploadres);
*IF prgPrepare (basepage, DefaultStackSize) & prgInstall() THEN
,WITH ref0^ DO
.(*SplitPath (newname, filePath, fn); SplitName (fn, fileName, sfx);*)
.fileName:= FilePrefix (newname);
.Assign (fileName, codeNameUp, ok); (* geht, weil fileName ohne Sfx*)
.codeName:= ADR (codeNameUp);
.codeStart:= basepage;
.header:= codeStart;
.codeLen:= basepage^.p_tlen;
.state:= ModStates {mainMod,program};
.owner:= ProcessID^;
.Loading (codeNameUp,newname,codeStart,codeLen,NIL,0L)
,END;
,loadRes:= NoError;
,RETURN ref0
*ELSE
,DEALLOCATE (ref0,0L);
,prgUnload (basepage);
,loadRes:= outOfMemory;
,errHandler (newname,loadRes);
,RETURN NIL
*END
(END
&END
$END (* IF tosPrg ... ELSE *)
"END LinkMod;
 
"VAR DTA: ARRAY [1..22] OF WORD;
&basepage: PtrBP;
&stacksize: LONGCARD;
 
"PROCEDURE exitMods;
$(* alten VarSpace wiederherstellen *)
$VAR execThis: CARDINAL; ad: PtrBSS;
$BEGIN
&execThis:= 0;
&WHILE execThis < ExecPtr DO
(WITH ExecList^[execThis]^ DO
*IF prevBSS # NIL THEN
,(*$ ? Trace: WriteLn; WriteString (codename^); WriteString (' restores BSS'); *)
,ad:= prevBSS;
,prevBSS:= prevBSS^.prev;
,Block.Copy (ADDRESS(ad) + 4L, varLen, varRef);
,DEALLOCATE (ad, 0);
*END;
(END;
(INC (execThis);
&END;
$END exitMods;
 
"PROCEDURE initPrgSpace (prgFlags: LONGWORD) : Boolean;
$BEGIN
&(*$ ? Trace: WriteLn; WriteString ('CreatePB'); *)
&IF ~CreateBasePage (basepage, stacksize, CADR (mainName), prgFlags) THEN
(basepage:= NIL;
(RETURN FALSE
&END;
&Block.Copy (CADR(arg),128,ADR(basepage^.cmdline));
&basepage^.p_dta:= ADR(DTA);
&(*$ ? Trace: WriteString (' ok.'); *)
&RETURN true
$END initPrgSpace;
 
"PROCEDURE removePrgSpace;
$BEGIN
&IF basepage # NIL THEN
((* nicht DEALLOCATE verwenden, da sonst u.U. Fehler passieren?! *)
(Mfree (basepage^.p_env);
(Mfree (basepage)
&END;
$END removePrgSpace;
"
"PROCEDURE outOfMem;
$BEGIN
&loadres := outofmemory;
&errHandler ('',loadres);
$END outOfMem;
"
"PROCEDURE reset (st: ModStates); (* Flags 'msr1' & 'msr2' lschen *)
$VAR i: ModRef;
$BEGIN
&ResetList (ModLst);
&LOOP
(i:= NextEntry (ModLst);
(IF i=NIL THEN EXIT END;
(i^.state:= i^.state - st
&END
$END reset;
 
"PROCEDURE initNonReentrants (): BOOLEAN;
$(*
%* Es reicht nicht aus, in PrepareExec() alle Importe zum Init. zu prfen.
%* Denn es kann vorkommen, da z.B. ber Treiber weitere Module abhngig
%* sind. Zwar sind diese schon initialisiert, wenn sie jedoch nicht
%* reentrant sind, mssen sie erneut init. werden.
%* Dies sollte darber funktionieren, da die Driver-Liste ausgewertet
%* wird. Solange dies noch nicht impl. ist, mu anders vorgegangen
%* werden:
%* Es werden zur Sicherheit einfach alle Module init., die schon
%* initialisiert & non-reentrant $ ~mainMod sind. Damit werden u.U.
%* zwar mehr Module als ntig init, das sollte aber nicht schaden.
%*)
$
$PROCEDURE check (i: ModRef): BOOLEAN;
&VAR j: POINTER TO ModRef;
&BEGIN
(WITH i^ DO
*INCL (state, msr1);
*IF imports # NIL THEN
,j:= ADDRESS (imports);
,LOOP
.IF j^ = NIL THEN EXIT END;
.IF NOT (msr1 IN j^^.state) THEN
0IF NOT check (j^) THEN RETURN FALSE END
.END;
.INC (j, 4)
,END
*END;
*IF NOT (reentrant IN state) & (initialized IN state)
*&  NOT (mainMod IN state)
*&  NOT (installed IN state) THEN
,IF NOT (msr2 IN i^.state) THEN
.INCL (i^.state, msr2);
.(*$ ? Trace OR Trace3: WriteLn; WriteString (codename^); WriteString (' will be executed'); *)
.IF NOT markForInit (i) THEN RETURN FALSE END
,END
*END
(END;
(RETURN TRUE
&END check;
$
$VAR i: ModRef;
$
$BEGIN
&ResetList (ModLst);
&LOOP
(i:= NextEntry (ModLst);
(IF i=NIL THEN EXIT END;
(IF NOT (msr1 IN i^.state) THEN
*IF NOT check (i) THEN
,RETURN FALSE
*END
(END
&END;
&RETURN TRUE
$END initNonReentrants;
 
"VAR usedIndex: ModRef; lastExecPtr, termState: CARDINAL;
&ehdl: EnvlpCarrier;
&initOK: BOOLEAN; lastExecList: ADDRESS;
 
 BEGIN (* ExecMod *)
"(*$?Trace0:Write('1');Read(inch);IF Inconsistent() THEN HALT END;*)
"errMsg[0]:=0C;
"loadres := noError;
"lastExecList:= ExecList;
"lastExecPtr:= ExecPtr;
"ALLOCATE (ExecList, (MaxModExec+1)*SIZE (ExecList^[0]));
"usedIndex:= NIL;
"IF ExecList = NIL THEN
$outOfMem
"ELSE
$ExecPtr := 0;
$nowimport := False;
$clientname:= '';
$IF exec # execNever THEN
&reset (ModStates{msr1,msr2});
&initOK:= initNonReentrants ();
&reset (ModStates{msr1})
$ELSE
&initOK:= TRUE
$END;
$IF initOK THEN
&usedIndex := LinkMod (mainName, anykey, exec, NIL);
&IF exec # execNever THEN reset (ModStates{msr1,msr2}) END;
&(*$ ? Trace OR Trace3: Read (inch); *)
&(*$?Trace0:Write('2');Read(inch);IF Inconsistent() THEN HALT END;*)
&IF usedIndex # NIL THEN
(INCL (usedIndex^.state, mainMod);
(IF program IN usedIndex^.state THEN
*(*$?Trace0:Write('3');Read(inch);IF Inconsistent() THEN HALT END;*)
*IF exec # ExecNever THEN
,IF NOT prgExec (usedIndex^.codeStart, CADR (mainName), arg, env, exitCode) THEN
.outOfMem
,END;
,(*$?Trace0:Write('6');Read(inch);IF Inconsistent() THEN HALT END;*)
*END
(ELSIF ExecPtr > 0 THEN
*stacksize:= usedIndex^.header^.stackSize;
*IF stacksize = 0 THEN
,stacksize := Defaultstacksize
*END;
*IF stacksize < 1024L THEN stacksize := 1024 END;
*IF odd (stacksize) THEN dec (stacksize) END;
*(*$ ? Trace: WriteLn; WriteString ('initPrgSpace'); *)
*IF ~initPrgSpace (usedIndex^.header^.prgFlags) THEN
,(*$ ? Trace: WriteString (' failed'); *)
,outOfMem;
,termState:= 2
*ELSE
,enterMods (TRUE, FALSE, exitCode);
,IF enterFailed THEN
.exitCode:= 0; outOfMem; termState:= 2
,ELSE
.(*$ ? Trace: WriteLn; WriteString ('ExecProcess'); *)
.INCL (usedIndex^.state, running);
.(*
0SetEnvelope (ehdl, enterMods, MemArea {NIL,0});
.*)
.ExecProcess (basepage, initMods, CADR (mainName),
;usedIndex^.header^.prgFlags, termState, exitCode);
.(*
0IF enterFailed THEN exitCode:= 0; outOfMem; termState:= 2 END;
0RemoveEnvelope (ehdl);
.*)
.EXCL (usedIndex^.state, running);
,END;
*END;
*(*$ ? Trace: WriteLn; WriteString ('removePrgSpace'); *)
*removePrgSpace;
*(*$?Trace0:Write('7');Read(inch);IF Inconsistent() THEN HALT END;*)
*exitMods;
*(*$?Trace0:Write('8');Read(inch);IF Inconsistent() THEN HALT END;*)
*IF termState#2 THEN
,IF termState<2 THEN
.loadres:= initFault
,ELSE
.loadres:= exitFault
,END;
,errHandler ('',loadres)
*END
(END
&END;
$ELSE
&loadRes:= tooManyMods;
&errHandler (mainName,loadRes)
$END;
$DEALLOCATE (ExecList, 0);
"END;
"ExecPtr:= lastExecPtr;
"ExecList:= lastExecList;
"(*$ ? Trace: WriteLn; WriteString ('End ExecMod'); *)
"(*$?Trace0:Write('9');Read(inch);IF Inconsistent() THEN HALT END;*)
"RETURN usedIndex
 END ExecMod;
 
 
 PROCEDURE Pexec ( VAR name, arg: ARRAY OF CHAR; env: ADDRESS; VAR execRes: INTEGER ): INTEGER;
"(*
#* Programm von Disk laden und starten
#*)
"VAR s:FileStr; i:INTEGER;
"BEGIN
$Assign (name,s,ok);
$ASSEMBLER
(MOVE.L  env(A6),-(A7)
(MOVE.L  arg(A6),-(A7)
(PEA     s(A6)
(CLR     -(A7)
(MOVE    #$4B,-(A7)
(TRAP    #1
(ADDA.W  #16,A7
(MOVE.L  execRes(A6),A0
(TST.L   D0
(BPL     execOK
(CLR     i(A6)
(MOVE.W  D0,(A0)
(BRA     ende
 execOK  MOVE    D0,i(A6)
(CLR.W   (A0)
 ende
&END;
$RETURN i
"END Pexec;
 
 
 TYPE modList = RECORD p: CARDINAL;
6a: POINTER TO ARRAY [0..5000] OF ModRef END;
 VAR exitList, removeList: modList;
 
 PROCEDURE freeLists (olda, oldb: ADDRESS);
"BEGIN
$DEALLOCATE (exitList.a, 0);
$DEALLOCATE (removeList.a, 0);
$exitList.a:= olda;
$removeList.a:= oldb
"END freeLists;
 
 PROCEDURE allocLists (VAR olda, oldb: ADDRESS): BOOLEAN;
"BEGIN
$olda:= exitList.a;
$oldb:= removeList.a;
$ALLOCATE (exitList.a, (MaxModExec+1)*SIZE(exitList.a^[0]));
$ALLOCATE (removeList.a, (MaxModExec+1)*SIZE(removeList.a^[0]));
$IF (exitList.a # NIL) & (removeList.a # NIL) THEN
&RETURN TRUE
$ELSE
&freeLists (olda, oldb);
&RETURN FALSE
$END
"END allocLists;
 
 
 PROCEDURE CallModule ( REF name     : ARRAY OF Char;
;Paths    : PathList;
7REF Arg      : ARRAY OF Char;
;env      : ADDRESS;
7VAR ExitCode : Integer;
7VAR ErrMsg   : ARRAY OF CHAR;
7VAR Result   : LoaderResults);
 
"VAR myindex: ModRef;   (* Index wird gebraucht fuer Release *)
&mname: FileStr;
&fname: FileStr;
&arg0: ArgStr;
&myres: LoaderResults;
&mymsg: String;
&execRes: INTEGER;
&isPrg, isLoaded, found: BOOLEAN;
&save1, save2: ADDRESS;
 
"PROCEDURE search (REF name: ARRAY OF CHAR);
$BEGIN
&SearchFile (name,Paths,fromStart,found,fname);
&isPrg:= found & ~IsModule (fname);
$END search;
 
"BEGIN
$ExitCode := 0;
$errmsg[0]:= 0C;
$IF callptr = MaxModNest-1 THEN
&SetMsg (9, errmsg);
&Result := tooManyCalls
$ELSE
&inc (callptr);
&Assign (name,mname,ok);
&Assign (arg,arg0,ok);
&REPEAT
(IF arg0[0] # CHR(127) THEN
*Insert (CHR(Length(arg0)),0,arg0,ok)
(END;
(myMsg[0]:=0C;
(chainname [callptr] := '';
(isLoaded:= ModLoaded (mname, FALSE, fname, myindex);
(IF isLoaded & ~(loaded IN myindex^.state) & (LENGTH (FileSuffix(mname))>0) THEN
*(* Hier soll offenbar ein Prg. gestartet werden, das mit dem
+* selben Namen auch schon als residentes Modul vorkommt.
+* Prfen, ob das File existiert und dann doch das File starten. *)
*search (mname);
*IF isPrg THEN isLoaded:= FALSE END
(ELSIF ~isLoaded THEN
*search (fname);
(END;
(IF ~isLoaded & ~found THEN
*myres:= notfound;
*mname:= '';
*outerErrHandler (FileNames.FileName (fname), '', FALSE, notfound, mymsg)
(ELSIF ~isLoaded & isPrg THEN
*exitCode:= Pexec (fname,arg0,env,execRes);
*mname:= '';
*checkExecRes (execRes, myRes, fname, myMsg);
(ELSE
*IF ~allocLists (save1, save2) THEN
,mname:= '';
,SetMsg (6, mymsg);
,myres := outofmemory;
*ELSE
,myindex:= execmod (mname,execalways,paths,arg0,env,exitcode,mymsg,myres);
,IF myindex # NIL THEN
.Release (myindex,FALSE,FALSE)
,END;
,freeLists (save1, save2);
,mname := chainname [callptr];
,arg0 := chainarg [callptr]
*END
(END
&UNTIL mname[0] = 0C;
&Assign (mymsg,ErrMsg,ok);
&Result:= myres;
&DEC (callptr);
$END
"END CallModule;
 
 
 PROCEDURE LoadModule ( REF mname   : ARRAY OF CHAR;
;paths   : PathList;
7VAR mname0  : ARRAY OF CHAR;
7VAR errMsg  : ARRAY OF CHAR;
7VAR result  : LoaderResults);
"
"VAR   dummy:INTEGER;
(sdum: ArgStr;
(idx: CARDINAL;
(save1, save2: ADDRESS;
(ref0:ModRef;
 
"BEGIN
$(* darf hier nicht stehen wg. ggf. Alias zu 'mname': mname0[0]:= 0C; *)
$errmsg[0]:= 0C;
$IF ~allocLists (save1, save2) THEN
&SetMsg (6, errmsg);
&mname0[0]:= 0C;
&Result := outofmemory;
$ELSE
&ref0 := execmod (mname, execnever, paths, sdum, 0, dummy, errmsg, result);
&freeLists (save1, save2);
&IF ref0 # NIL THEN
(Assign (ref0^.codename^,mname0,ok);
(IF linked IN ref0^.state THEN
*result := denied;
*SetMsg (7, errmsg);
*idx:= PosLen ('@I',errmsg,0);
*Delete (errmsg,idx,2,ok);
*Insert (ref0^.codeName^,idx,errmsg,ok);
(ELSE
*INCL (ref0^.state,loaded);
(END
&ELSE
(mname0[0]:= 0C;
&END
$END
"END LoadModule;
 
 
 PROCEDURE freeModule (ref0: ModRef; VAR result: LoaderResults);
 
"VAR save1, save2: ADDRESS;
 
"BEGIN
$result := NoError;
$IF program IN ref0^.state THEN
&prgUnload (ref0^.codeStart);
&FindEntry (ModLst, ref0, ok);
&IF ok THEN
(RemoveEntry (ModLst,ok)
&END;
&DEALLOCATE (ref0,0L)
$ELSE
&IF loaded IN ref0^.state THEN
(EXCL (ref0^.state, loaded);
(IF ~ allocLists (save1, save2) THEN
*Result := outofmemory;
(ELSE
*Release (ref0, FALSE, FALSE);
*freeLists (save1, save2);
*IF ref0#NIL THEN
,result := notRemoved
*END
(END
&ELSE
(result:= denied (* Modul ist nicht geladen *)
&END;
$END
"END freeModule;
 
 PROCEDURE UnLoadModule ( REF mname : ARRAY OF Char;
9VAR result: LoaderResults);
 
"VAR ref0: ModRef; dummy: FileStr;
 
"BEGIN
$IF ModLoaded (mname,FALSE,dummy,ref0) THEN
&freeModule (ref0,result)
$ELSE
&result := notFound
$END
"END UnLoadModule;
 
 
 
 PROCEDURE FullRelease (VAR client: ModRef; dummy1, dummy2: BOOLEAN);
"(* 'client' wird auf NIL gesetzt, wenn Modul wirklich freigegeben wird *)
 
"PROCEDURE DoRemoveInfo ( ad: ADDRESS; len: LONGCARD );
$BEGIN
&ASSEMBLER
(; Suche nach Prozeduren, die im angegebenen Code-Bereich liegen:
(MOVE.L  ad(A6),D1
(MOVE.L  D1,D2
(ADD.L   len(A6),D2
(LEA     RemovalRoot,A0
(MOVE.L  A0,A1
&l MOVE.L  RemovalEntry.prev(A0),A0 ; Liste rckwrts durchgehen
(CMPA.L  A1,A0                   ; Listenende ?
(BEQ     e
(MOVE.L  RemovalEntry.call(A0),D0
(CMP.L   D1,D0                   ; call < Code-Beginn ?
(BCS     l                       ;   ja, weitersuchen
(CMP.L   D2,D0                   ; call > Code-Ende ?
(BCC     l                       ;   ja, weitersuchen
(; Proc gefunden -> auslinken und Remove-Info
(MOVEM.L D1/D2/A0/A1,-(A7)
(MOVE.L  RemovalEntry.next(A0),A1
(MOVE.L  RemovalEntry.prev(A0),A2
(MOVE.L  A1,RemovalEntry.next(A2)
(MOVE.L  A2,RemovalEntry.prev(A1)
(MOVE.L  D0,(A3)+
(LEA     RemovalEntry.wsp(A0),A0
(MOVE.L  A0,(A3)+
(JSR     CallSub
(MOVEM.L (A7)+,D1/D2/A0/A1
(BRA     l                       ; falls mehrere Removals im Modul
&e
&END
$END DoRemoveInfo;
 
"PROCEDURE markNonFree;
 
$(*
%* Die Module werden folgendermaen markiert:
%*   - folgende erhalten 'msr1' in 'state':
%*       - linked
%*       - program
%*       - mainMod & running + Importe
%*       - installed         + Importe
%*   - folgende erhalten 'loadImp' in 'state':
%*       - loaded            + Importe   (ohne die, die schon 'msr1' haben)
%*
%* Alle, die 'msr1' haben, knnen nicht deinitialisiert werden.
%* Alle, die 'msr1' oder 'loadImp' haben, knnen nicht freigegeben werden.
%*)
 
$PROCEDURE presetFlags;
&VAR i: ModRef;
&BEGIN
(ResetList (ModLst);
(LOOP
*i:= NextEntry (ModLst);
*IF i=NIL THEN EXIT END;
*EXCL (i^.state, loadImp);
*IF (linked IN i^.state) OR (program IN i^.state) THEN
,INCL (i^.state, msr1);  (* Markiert fertige Module *)
*ELSE
,EXCL (i^.state, msr1);
*END
(END
&END presetFlags;
 
$PROCEDURE markImported (i: ModRef; s: ModState);
&VAR j: POINTER TO ModRef;
&BEGIN
(INCL (i^.state, s);
(IF i^.imports # NIL THEN
*j:= ADR (i^.imports^);
*WHILE j^ # NIL DO
,IF NOT ( (msr1 IN j^^.state) OR (loadImp IN j^^.state) ) THEN
.markImported (j^, s);
,END;
,INC (j, 4)
*END
(END;
&END markImported;
 
$VAR i: ModRef; s: ModStates;
 
$BEGIN (* markNonFree *)
&presetFlags;
&ResetList (ModLst);
&LOOP
(i:= NextEntry (ModLst);
(IF i=NIL THEN EXIT END;
(s:= i^.state;
(IF NOT (msr1 IN s) THEN
*IF ( (mainMod IN s) AND (running IN s) ) OR (installed IN s) THEN
,markImported (i, msr1)
*ELSIF loaded IN s THEN
,markImported (i, loadImp)
*END
(END
&END;
&(*$ ? Trace:
(WriteLn;
(WriteString ('Freie Module:');
(ResetList (ModLst);
(LOOP
*i:= NextEntry (ModLst);
*IF i=NIL THEN EXIT END;
*IF NOT (msr1 IN i^.state) THEN
,WriteString (i^.codeName^);
,WriteString ('  ');
*END
(END;
(WriteLn;
(Read(inch);
&*)
$END markNonFree;
 
"PROCEDURE release0 (VAR client: ModRef);
 
$PROCEDURE add (VAR list: modList);
&BEGIN
(WITH list DO
*IF p > MaxModExec THEN
,ASSEMBLER
0TRAP    #6
0DC.W    Overflow-$8000
0ACZ     'Release: Too many modules'
,END
*END;
*a^[p]:= client;
*INC (p);
(END;
&END add;
 
$VAR j, j2: ModRef; pj: POINTER TO ModRef; deInit, removable: BOOLEAN;
 
$BEGIN (* release0 *)
&(*$ ? Trace: WriteLn; WriteString ('Release: '); WriteString (client^.codeName^); *)
&IF msr1 IN client^.state THEN
((*$ ? Trace: WriteString (' / is linked or already removed - no action'); *)
&ELSE
(INCL (client^.state,msr1);
(deInit:= initialized IN client^.state;
(removable:= NOT (loadImp IN client^.state);
(pj:= ADDRESS (client^.imports);
(IF pj # NIL THEN
*(*$ ? Trace: WriteLn; WriteString ('< releasing imports of '); WriteString (client^.codeName^); *)
*LOOP
,j:= pj^;
,IF j = NIL THEN EXIT END;
,j2:= j;
,pj^:= NIL;
,release0 (j2);  (* 'j2' wird ggf. auf NIL gesetzt *)
,pj^:= j;
,INC (pj, SIZE (pj^));
*END;
*(*$ ? Trace: WriteLn; WriteString ('> end of releasing imports of '); WriteString (client^.codeName^); *)
(END;
(IF deInit THEN add (exitList) END;
(IF removable THEN
*add (removeList);
*client:= NIL
(END
&END;
&(*$ ? Trace: Read(inch) *)
$END release0;
 
"VAR listCnt: CARDINAL;
 
"BEGIN (* FullRelease *)
$(*$ ? Trace2: WriteLn; WriteString ('Begin Release!'); *)
$IF NOT (program IN client^.state) & NOT (linked IN client^.state) THEN
&markNonFree;
&exitList.p:= 0;
&removeList.p:= 0;
&release0 (client);
&WITH exitList DO
(WHILE p > 0 DO
*DEC (p);
*(*$ ? Trace2 OR Trace: WriteLn; WriteString ('deinit '); WriteString (a^[p]^.codeName^); *)
*WITH a^[p]^ DO
,DoRemoveInfo (codeStart, codeLen);
,EXCL (state, initialized);
*END
(END
&END;
&WITH removeList DO
(WHILE p > 0 DO
*DEC (p);
*(*$ ? Trace: WriteLn; WriteString ('dealloc '); WriteString (a^[p]^.codeName^); *)
*FindEntry (ModLst, a^[p], ok);
*IF ok THEN
,RemoveEntry (ModLst,error);
,FreeMod (a^[p])
*ELSE
,ASSEMBLER
0TRAP    #6
0DC.W    IllegalState    ; interner Fehler!
,END
*END;
(END
&END;
&(*$ ? Trace2: Read(inch); *)
$END;
"END FullRelease;
 
 
 PROCEDURE DummyMonitor;
"(*$L-*)
"BEGIN
"END DummyMonitor;
"(*$L+*)
 
 PROCEDURE DummyLoading (REF a,b:ARRAY OF CHAR;c:ADDRESS;d:LONGCARD;e:ADDRESS;f:LONGCARD);
"BEGIN
"END DummyLoading;
 
 PROCEDURE envelope (open, child: BOOLEAN; VAR exitcode: INTEGER);
"(*
#* Kontrollieren, ob der Proze endet, unter dem ein Modul geladen wurde.
#* Dann das Modul freigeben. Da der 'owner' nur dann gesetzt wird, wenn
#* kein SysAlloc (FullStorBaseAccess) erfolgen konnte, passiert dies nur
#* auf dem TT oder wenn kein erw. Storage-Access erlaubt wird.
#*)
"VAR i: ModRef; result: LoaderResults;
"BEGIN
$IF NOT open AND child THEN
&ResetList (ModLst);
&LOOP
(i:= NextEntry (ModLst);
(IF i=NIL THEN EXIT END;
(IF (loaded IN i^.state) & (i^.owner = ProcessID^) THEN
*freeModule (i, result);
*ResetList (ModLst); (* wieder von vorn *)
(END
&END;
$END
"END envelope;
 
 VAR ehdl: EnvlpCarrier;
 
 BEGIN (* of Loader *)
"SetEnvelope (ehdl, envelope, MemArea {NIL,0});
"IF UseStackFrame () THEN StackFrameOffs:= 2 ELSE StackFrameOffs:= 0 END;
"callptr:= 1;
"ExecPtr:= 0;
"DefaultStackSize:= 16384;
"Loading:= DummyLoading;
"Monitor:= DummyMonitor;
"Release:= FullRelease;
"(*$P+*)
 END Loader.
 
(* $0000662F$000021CC$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$00005177$FFF09768$0000DC29$FFF09768$0000515F$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$00008304$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$FFF09768$00001C77T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$FFAD4838$FFAD4838$00005162$00008834$00008822$FFAD4838$00008822$00005967$FFAD4838$00001CA5$FFAD4838$00005173$0000515F$00001C77$00005949$FFAD4838*)
