 IMPLEMENTATION MODULE Convert; (* V#130 *)
 (*$Y+,R-,C-,X+,H+ *)
 (*$M-  mu global sein, weil sonst dummy-Verkettungen zw. den Tables bleiben *)
 (*$J-  ist ntig fr ConvReal! *)
 
 (* !!! Noch zu implementieren: Wenn bei Get-Routinen DEL-Zeichen
'geholt wird, dies richtig auswerten.
 
#14.06.87  jm  Atari-Realformat eingefhrt
#18.06.87  jm  in ConvFix & ConvEng hoffentlich ordentliche Rundung.
1Jetzt Ausgabe von max. 14 signifikanten Stellen;
1dazu RoundKonst-Tabelle um einen Eintrag erweitert.
#19.06.87  jm  ConvLInt & ConvLCard raus
#22.06.87  TT  Neben SPACE wird auch TAB am Anfang berlesen
#08.07.87  TT  TRAP-Nummern korrigiert; 'ten' liefert valid-Wert statt TRAP
1auszulsen; Reg D3-D7 berall gerettet;
1Scanning erreicht immer Aufrufer.
#27.10.87  jm  Rundung in ConvFix, ConvEng nochmals korrigiert
#01.03.88  TT  ConvFix, ConvEng: ten-Aufruf: valid-Argument fehlte,
3fhrte zu Addre/Buserrors.
#01.04.88  TT  ConvReal entscheidet nun richtig zw. Float/Fix.
 
#20.06.88  ubu Convert-procs f. 68020/881 eingebaut.
#26.08.88  MR  Convert-procs f. 68881-solo.
 
#10.09.88  TT  ConvToLNum, ConvToNum bei allen Basen korrekt.
#17.09.88  TT  ConvToLNum bei Zahlen > 16 Bit korrekt
#16.04.89  TT  ConvFix/Eng runden richtig (roundKonst -> half)
#12.06.89  TT  Kein String-Overflow bei WriteFix & optimiertem Linken
#15.06.89  TT  Include-File f. Prozessoren
#16.06.89  TT  ConvToReal f. A68881 rief Buserror bei neg. Mantisse hervor,
3weil ein '#' fehlte (es war da ein Space - ein Datenfehler?)
1Fr FPU Error-Behandlung berarbeitet.
#17.06.89  TT  ConvFloat/Fix/Eng von GS bernommen - CFloat aber noch nicht,
3weil da erst Anpassung der A68881-Routinen ntig ist!
#18.08.89  TT  fillchar-Parameter bei ConvNum
#06.03.90  TT  Rundung bei ConvFix/ConvEng korrigiert: Bei max. Mantisse wird
314 statt 13 nach D0 geladen
#30.05.90  TT  ConvFix/Eng lsen bei FPU-Benutzung keinen Fehler bei 0.0 aus
#04.07.90  TT  alte Runtime-Aufrufe raus
#17.10.90  TT  ST-FPU: ConvToReal setzt bei Error die FPU zurck und rumt
1Stack korrekt ab.
#24.10.90  TT  $H+ implementiert
#19.02.91  TT  Ein paar mehr Warteschleifen fr ST-FPU; keine Laufzeitfehler
1mehr bei TT-FPU (nicht getestet).
#25.03.91  TT  ConvToNum/ConvToLNum wieder korrekt bei Werten > 256.
#28.02.91  TT  Laufzeitfehler bei TT-FPU getestet/korrigiert.
#08.02.94  TT  Kein Byte-Zugriff mehr auf fpstat+1 wg. STE.
#15.02.94  TT  Warteschleife bei 'movl3' hinzugefgt.
 *)
 
 FROM SYSTEM IMPORT CompilerVersion, ASSEMBLER, LONGWORD, WORD, ADDRESS;
 FROM MOSConfig IMPORT RadixChar, FixToFloatMin, FixToFloatMax;
 FROM MOSGlobals IMPORT StringOverflow, Overflow, OutOfRange;
 FROM SFP004 IMPORT FPUReset, FPUError;
 
 (*$I FPU.CNF *)
 
 (*$? A68881:
 CONST
(fpstat  =  $fffa40;       (* Response word of MC68881 read *)
(fpctrl  =  $fffa42;       (* Control  word of MC68881 write *)
(fpcmd   =  $fffa4a;       (* Command  word of MC68881 write *)
(fpcond  =  $fffa4e;       (* Condition word of MC68881 write *)
(fpop    =  $fffa50;       (* Operand  long of MC68881 read/write *)
 *)
 
 
 (*$L-*)
 PROCEDURE @RMUL;
"BEGIN
$ASSEMBLER
(SUBQ.L  #8,A3
(MOVE.L  A3,A0
(LEA     -8(A3),A1
(JMP     @LMUL
$END
"END @RMUL;
 
 (*$L-*)
 PROCEDURE @RADD;
"BEGIN
$ASSEMBLER
(SUBQ.L  #8,A3
(MOVE.L  A3,A0
(LEA     -8(A3),A1
(JMP     @LADD
$END
"END @RADD;
 
 (*$L-*)
 PROCEDURE @RDIV;
"BEGIN
$ASSEMBLER
(SUBQ.L  #8,A3
(MOVE.L  A3,A0
(LEA     -8(A3),A1
(JMP     @LDIV
$END
"END @RDIV;
 
 
 TYPE LStr = RECORD
-p:POINTER TO ARRAY [0..0] OF CHAR;
-h:Cardinal;
-l:Cardinal;
+END;
 
 (*$L-*)
 PROCEDURE getch;
 BEGIN
 ASSEMBLER
(MOVEM.L D0/D2/A0/A1/A2,-(A7)
(MOVE.L  A2,(A3)+        ; ^ GetInfo
(MOVE.L  (A0)+,A1
(MOVE.L  (A0),D2
(JSR     (A1)
(MOVEM.L (A7)+,D0/D2/A0/A1/A2
(MOVEQ   #0,D1
(MOVE.B  GetInfo.ch(A2),D1
(CMPI.B  #$5F,D1
(BLE     getch1
(BCLR    #5,D1
 !getch1
 END
 END getch;
 
 (*$L-*)
 PROCEDURE StrToLC;
 BEGIN
 ASSEMBLER
(CMPI   #'+',D1
(BNE    noplus
(JSR    getch
 !noplus CMPI   #'%',D1
(BEQ    bin
(CMPI   #'$',D1
(BNE.L  dez
(BRA    hex
 
 finis2  BRA.L  finis
 
 !hex    JSR    getch
(SUBI.B #'0',D1
(BCS    finis2
(CMPI.B #9,D1
(BLS    hex1
(SUBQ.B #7,D1
(CMPI.B #$A,D1
(BCS    finis2
(CMPI.B #$F,D1
(BHI    finis2
 !hex1   MOVE   D1,D0
(MOVEQ  #1,D2
 hex2    JSR    getch
(SUBI.B #'0',D1
(BCS    finis2
(CMPI.B #9,D1
(BLS    hex3
(SUBQ.B #7,D1
(CMPI.B #$A,D1
(BCS    finis2
(CMPI.B #$F,D1
(BHI    finis2
 !hex3   ROL.L  #4,D0
(MOVE.B D0,D5
(ANDI   #$F,D5
(BNE    hex4
 hex5    OR.B   D1,D0
(BRA    hex2
 hex4    MOVEQ  #0,D2
(ANDI.B #$F0,D0
(BRA    hex5
 
 !bin    JSR    getch
(SUBI.B #'0',D1
(BCS    finis
(CMPI.B #1,D1
(BHI    finis2
(MOVE.B D1,D0
(MOVEQ  #1,D2
 !bin2   JSR    getch
(SUBI.B #'0',D1
(BCS    finis2
(CMPI.B #1,D1
(BHI    finis2
(ASL.L  #1,D0
(BCC    bin3
(MOVEQ  #0,D2    ; overflow
 bin3    OR.B   D1,D0
(BRA    bin2
(
 !dez    SUBI.B #'0',D1
(BCS    finis
(CMPI.B #9,D1
(BHI    finis
(MOVE   D1,D0
(MOVE   #1,D2
(JSR    getch
 dez2    SUBI.B #'0',D1
(BCS    finis
(CMPI.B #9,D1
(BHI    finis
(MOVE.L D0,D5
(LSL.L  #1,D5
(BCS    dez3
(LSL.L  #1,D5
(BCS    dez3
(ADD.L  D5,D0
(BCS    dez3
(LSL.L  #1,D0
(BCS    dez3
(ADD.L  D1,D0
 dez4    JSR    getch
(BRA    dez2
 dez3    MOVEQ  #0,D2
(BRA    dez4
 finis
 END
 END StrToLC;
 
 (*$L-*)
 PROCEDURE skip; (* berliest Spaces und TABs *)
"BEGIN
$ASSEMBLER
%l: JSR    getch
(CMPI   #' ',D1
(BEQ    l
(CMPI   #9,D1    ; TAB
(BEQ    l
$END
"END skip;
 
 (*$L-*)
 PROCEDURE ConvToLCard(    get   : GetProc;
6VAR info  : GetInfo;
6VAR valid : BOOLEAN ): LONGCARD;
 BEGIN
 ASSEMBLER
(MOVEM.L D3-D6,-(A7)
(MOVE.L -(A3),A1
(MOVE.L -(A3),A2
(LEA    -8(A3),A0
(MOVEQ  #0,D0
(MOVEQ  #0,D2
(JSR    skip
(JSR    StrToLC
(MOVE   D2,(A1)  ; valid
(SUBQ.L #8,A3
(MOVE.L D0,(A3)+
(MOVEM.L (A7)+,D3-D6
 END
 END ConvToLCard;
 
 (*$L-*)
 PROCEDURE ConvToCard(    get   : GetProc;
4VAR info  : GetInfo;
4VAR valid : BOOLEAN ): CARDINAL;
 BEGIN
 ASSEMBLER
(JSR    ConvToLCard
(MOVE   -(A3),D0
(TST    -(A3)
(BEQ    finis
(CLR    (A1)     ; valid
 !finis  MOVE   D0,(A3)+
 END
 END ConvToCard;
 
 (*$L-*)
 PROCEDURE ConvToLInt(    get   : GetProc;
4VAR info  : GetInfo;
4VAR valid : BOOLEAN ): LONGINT;
 BEGIN
 ASSEMBLER
(MOVEM.L D3-D6,-(A7)
(MOVE.L -(A3),A1
(MOVE.L -(A3),A2
(LEA    -8(A3),A0
(MOVEQ  #0,D0       ;Ergebnis
(MOVEQ  #0,D2       ;Valid
(JSR    skip
(CMPI   #'-',D1
(SEQ    D6
(BNE    nosign
(JSR    getch
 !nosign JSR    StrToLC
(TST.B  D6
(BEQ    finis1
(NEG.L  D0
 !finis1 MOVE   D2,(A1)  ; valid
(SUBQ.L #8,A3
(MOVE.L D0,(A3)+
(MOVEM.L (A7)+,D3-D6
 END
 END ConvToLInt;
 
 (*$L-*)
 PROCEDURE ConvToInt(     get   : GetProc;
4VAR info  : GetInfo;
4VAR valid : BOOLEAN ): INTEGER;
 BEGIN
 ASSEMBLER
(JSR    ConvToLInt
(MOVE   -2(A3),D0
(EXT.L  D0
(MOVE.L -(A3),D1
(CMP.L  D0,D1
(BEQ    finis
(CLR    (A1)     ; valid
 !finis  MOVE   D0,(A3)+
 END
 END ConvToInt;
 
 
 (*$L-*)
 PROCEDURE ConvLN;
 BEGIN
 ASSEMBLER
 hex     SUBI.B  #'0',D1
(BCS     finis
(CMPI.B  #9,D1
(BLS     hex1
(SUBQ.B  #7,D1
(CMPI.B  #$A,D1
(BCS     finis
 !hex1   CMP.B   D5,D1
(BCC     finis
(TST     D2
(BMI     inval   ; zahl nicht mehr gltig
(MOVEQ   #1,D2   ; valid:= TRUE
(; Long-Multiplikation
(MOVE.L  D0,D6
(MULU    D5,D0
(SWAP    D6
(TST.W   D6
(BEQ     ok
(MULU    D5,D6
(SWAP    D6
(TST.W   D6
(BNE     notval
(ADD.L   D6,D0
(BCC     ok
 notval  MOVEQ   #-1,D2
 ok      ADD.L   D1,D0
 inval   JSR     getch
(BRA     hex
 
 !finis  TST     D2
(BPL     ende
(MOVEQ   #0,D2
 ende
 END
 END ConvLN;
 
 (*$L-*)
 PROCEDURE ConvToLNum (    get   : GetProc;
6VAR info  : GetInfo;
:base  : CARDINAL;
6VAR valid : BOOLEAN ): LONGCARD;
 BEGIN
 ASSEMBLER
(MOVEM.L D3-D6,-(A7)
(MOVE.L -(A3),A1
(MOVE   -(A3),D5
(MOVE.L -(A3),A2
(LEA    -8(A3),A0
(CLR.B  GetInfo.ch(A2)
(MOVEQ  #0,D0
(MOVEQ  #0,D2
(JSR    skip
(CMPI   #1,D5
(BLS    err
(CMPI   #36,D5
(BHI    err
(JSR    ConvLN
 err     MOVE   D2,(A1)  ; valid
(SUBQ.L #8,A3
(MOVE.L D0,(A3)+
(MOVEM.L (A7)+,D3-D6
 END
 END ConvToLNum;
 
 (*$L-*)
 PROCEDURE ConvToNum (    get   : GetProc;
4VAR info  : GetInfo;
8base  : CARDINAL;
4VAR valid : BOOLEAN ): CARDINAL;
 BEGIN
 ASSEMBLER
(JSR    ConvToLNum
(MOVE   -(A3),D0
(TST    -(A3)
(BEQ    finis
(CLR    (A1)     ; valid
 !finis  MOVE   D0,(A3)+
 END
 END ConvToNum;
 
 
 TABLE.L eins:   $000A8000,$00000000;
(tenpot: $0022A000,$00000000,$003AC800,$00000000,
0$00729C40,$00000000,$00DABEBC,$20000000,
0$01B28E1B,$C9BF0400,$035A9DC5,$ADA82B70,
0$06AAC278,$1F49FFCD,$0D5293BA,$47C980E5,
0$1A9AAA7E,$EBFB9DEF,$352AE319,$A0AEA5F1,
0$6952C976,$75868140;
 
 (*$L-*)
 PROCEDURE ten(e:INTEGER; VAR valid: BOOLEAN):LONGREAL; (* / *)
 BEGIN
 ASSEMBLER
(;ten:= 10 ^ e
(MOVE   D6,-(A7)
(MOVE.L -(A3),A1         ;A1: ADR (valid)
(LEA    @LMUL,A2         ;A2: @LMUL/@LDIV
(MOVE   -(A3),D6
(BPL    check
(LEA    @LDIV,A2
(NEG    D6
(BPL    check
(CLR    D6
 !check  CMPI   #1232,D6
(BCS    ok
(CLR.W  (A1)             ;valid:=FALSE
(CLR.L  (A3)+
(CLR.L  (A3)+
(MOVE   (A7)+,D6
(RTS
 !ok     LEA    tenpot,A0        ;A0: ADR(tenpot-tbl)
(MOVE.L A3,A1            ;A1: ADR(result)
(MOVE.L eins,(A3)+
(CLR.L  (A3)+
 !lbl    BTST   #0,D6
(BEQ    notodd
(MOVEM.L A0-A2,-(A7)
(JSR     (A2)
(MOVEM.L (A7)+,A0-A2
 !notodd ADDQ.L #8,A0
(ASR    #1,D6
(BNE    lbl
(MOVE   (A7)+,D6
 END
 END ten;
 
 (*$L+*)
 
 (*$? ~M68881 AND ~A68881:
 
 PROCEDURE ConvToReal(    get   : GetProc;        (* / *)
5VAR info  : GetInfo;
5VAR valid : BOOLEAN ): LONGREAL;
 
 VAR mneg, eneg, isdigit: BOOLEAN;
6i: CARDINAL;
4exp: INTEGER;
6c: CHAR;
6x: LONGREAL;
 BEGIN
"ASSEMBLER
*MOVEM.L D3-D6,-(A7)
*BRA    start
*
"!chrget MOVE.L  A0,-(A7)
*MOVE.L  info(A6),(A3)+
*MOVE.L  get(A6),A0
*MOVE.L  get+4(A6),D2
*JSR     (A0)
*MOVE.L  (A7)+,A0
*MOVE.L  info(A6),A1
*MOVEQ   #0,D0
*MOVE.B  GetInfo.ch(A1),D0
*MOVE.B  D0,c(A6)
*SUBI.B  #'0',D0
*CMPI.B  #9,D0
*SLS     D2
"!nodig  MOVE.B  D2,isdigit(A6)
*RTS
*
"!mulx10 LEA    x(A6),A0
*MOVE.L (A0)+,(A3)+
*MOVE.L (A0),(A3)+
*LEA    tenpot,A0
*MOVE.L (A0)+,(A3)+
*MOVE.L (A0),(A3)+
*JSR    @RMUL
*MOVEQ  #0,D0
*MOVE.B c(A6),D0
*SUBI.B #'0',D0
*MOVE.L A3,A0
*ADDQ.L #8,A3
*JSR    @LC2D
*JSR    @RADD
*LEA    x(A6),A0
*MOVE.L -(A3),4(A0)
*MOVE.L -(A3),(A0)
*TST    (A0)
*BEQ    nosig
*ADDQ   #1,i(A6)
"!nosig  RTS
*
"!start  MOVE.L valid(A6),A1
*CLR    (A1)
"!skpblk BSR    chrget
*CMPI.B #' ',c(A6)
*BEQ    skpblk
*CMPI.B #9,c(A6)       ; TAB
*BEQ    skpblk
*
*CMPI.B #'-',c(A6)
*SEQ    mneg(A6)
*BNE    nomneg
*BSR    chrget
"!nomneg CMPI.B #'+',c(A6)
*BNE    nompos
*BSR    chrget
"!nompos LEA    x(A6),A0
*CLR.L  (A0)+
*CLR.L  (A0)
*CLR    i(A6)
*CLR    exp(A6)
"!mant1  TST.B  isdigit(A6)
*BEQ    point
*MOVE.L valid(A6),A1
*MOVE   #1,(A1)
*CMPI   #14,i(A6)
*BGE    dont
*BSR    mulx10
*BRA    inci
"!dont   ADDQ   #1,exp(A6)
"!inci   BSR    chrget
*BRA    mant1
"!point  MOVE.B c(A6),D0
*CMP.B  RadixChar,D0
*BNE    expon
*BSR    chrget
"!mant2  TST.B  isdigit(A6)
*BEQ    expon
*MOVE.L valid(A6),A1
*MOVE   #1,(A1)
*CMPI   #14,i(A6)
*BGE    dont1
*BSR    mulx10
*SUBQ   #1,exp(A6)
"!dont1  BSR    chrget
*BRA    mant2
"!expon  CMPI.B #'E',c(A6)
*BEQ    expon0
*CMPI.B #'e',c(A6)
*BNE    retrn
"!expon0 BSR    chrget
*CMPI.B #'-',c(A6)
*SEQ    eneg(A6)
*BNE    noeneg
*BSR    chrget
"!noeneg CMPI.B #'+',c(A6)
*BNE    noepos
*BSR    chrget
"!noepos CLR    i(A6)
"!expon1 TST.B  isdigit(A6)
*BEQ    expon2
*MOVE   i(A6),D0
*MULU   #10,D0
*MOVE.B c(A6),D1
*ANDI   #$F,D1
*ADD    D1,D0
*MOVE   D0,i(A6)
*BSR    chrget
*BRA    expon1
"!expon2 MOVE   i(A6),D0
*TST.B  eneg(A6)
*BEQ    expon3
*NEG    D0
"!expon3 ADD    D0,exp(A6)
"!retrn  TST.B  mneg(A6)
*BEQ    retrn1
*TST    x(A6)
*BEQ    retrn1
*BSET   #0,x+1(A6)     ;jm 14.6.
"!retrn1 MOVEM.L (A7)+,D3-D6
"END;
"RETURN x * ten(exp,valid)
 END ConvToReal;
 
%(* <-- 68000 *) *)
 
 (*$? M68881 OR A68881:
 
 PROCEDURE ConvToReal(    get   : GetProc;        (* / *)
5VAR info  : GetInfo;
5VAR valid : BOOLEAN ): LONGREAL;
 
 VAR mneg, eneg, isdigit: BOOLEAN;
6i: CARDINAL;
4exp: INTEGER;
6c: CHAR;
6x: LONGREAL;
 BEGIN
"ASSEMBLER
"(*$? M68881:
*FMOVE.L FPCR,-(A7)
*FMOVE.L #0,FPCR               ; keine Exceptions auslsen
"*)
*MOVE.L D3,-(A7)
*BRA.L  start
 
"!chrget MOVE.L  A0,-(A7)
*MOVE.L  info(A6),(A3)+
*MOVE.L  get(A6),A0
*MOVE.L  get+4(A6),D2
*JSR     (A0)
*MOVE.L  (A7)+,A0
*MOVE.L  info(A6),A1
*MOVEQ   #0,D0
*MOVE.B  GetInfo.ch(A1),D0
*MOVE.B  D0,c(A6)
*SUBI.B  #'0',D0
*CMPI.B  #9,D0
*SLS     D2
"!nodig  MOVE.B  D2,isdigit(A6)
*RTS
 
"(*$? M68881:
"Error   MOVE.L valid(A6),A1
*CLR.W  (A1)
*RTS
"!mulx10 (* x in FP0 *)
*FMOVE.L #0,FPSR               ; Accrued Exc Byte lschen
*FMUL.W #10,FP0
*MOVEQ  #0,D0
*MOVE.B c(A6),D0
*SUBI.B #'0',D0
*FADD.W D0,FP0
*FMOVE.L FPSR,D0
*ANDI.B  #11010000%,D0 ; InvalidOperation, Overflow oder DivByZero?
*BNE     Error
*RTS
"*)
"(*$? A68881:
#Error  MOVE.L valid(A6),A1
*CLR.W  (A1)
*JMP    FPUReset
"!mulx10 (* x in FP0 *)
*MOVE.W fpstat,D0
*TST.B  D0
*BEQ    mulx10
*MOVE.W #$5023,fpcmd ; FMUL.W
"!mulxl  MOVE.W fpstat,D0
*TST.B  D0
*BEQ    mulxl
*SUBQ.B #2,D0
*BNE    Error
*MOVE.W #10,fpop    ; #10
*MOVEQ  #0,D2
*MOVE.B c(A6),D2
*TST.W  fpstat
*SUBI.B #'0',D2
#!addx2 MOVE.W fpstat,D0
*TST.B  D0
*BEQ    addx2
*MOVE.W #$5022,fpcmd ; FADD.W
#!addxl MOVE.W fpstat,D0
*TST.B  D0
*BEQ    addxl
*SUBQ.B #2,D0
*BNE    Error
*MOVE.W D2,fpop     ; digit addieren
#!addx3 MOVE.W fpstat,D0
*TST.B  D0
*BEQ    addx3
*SUBQ.B #2,D0
*BNE    Error
*RTS
#
#protViol
*JSR    FPUError
*BRA.W  error2
"*)
 
"!start  MOVE.L valid(A6),A1
*CLR    (A1)
"!skpblk BSR    chrget
*CMPI.B #' ',c(A6)
*BEQ    skpblk
*CMPI.B #9,c(A6)       ; TAB
*BEQ    skpblk
*
*CMPI.B #'-',c(A6)
*SEQ    mneg(A6)
*BNE    nomneg
*BSR    chrget
"!nomneg CMPI.B #'+',c(A6)
*BNE    nompos
*BSR    chrget
*
"(*$? M68881:
"!nompos
*FMOVE.W #0,FP0
"*)
"(*$? A68881:
"!nompos MOVE.W fpstat,D0
*TST.B  D0
*BEQ     nompos
*SUBQ.B  #2,D0
*BEQ     noError
*JSR     FPUError
"noError MOVE.W  #$5C0F,fpcmd ; FMOVECR 0.0,FP0
"waitFpu MOVE.W  fpstat,D0
*TST.B   D0
*BEQ     waitFpu
*SUBQ.B  #2,D0
*BNE     protViol
"*)
*CLR    exp(A6)
"!mant1  TST.B  isdigit(A6)
*BEQ    point
*MOVE.L valid(A6),A1
*MOVE   #1,(A1)
*BSR    mulx10
*MOVE.L valid(A6),A1
*TST.W  (A1)
*BEQ.W  error2
"!inci   BSR    chrget
*BRA    mant1
"!point  MOVE.B c(A6),D0
*CMP.B  RadixChar,D0
*BNE    expon
*BSR    chrget
"!mant2  TST.B  isdigit(A6)
*BEQ    expon
*MOVE.L valid(A6),A1
*MOVE   #1,(A1)
*BSR    mulx10
*SUBQ   #1,exp(A6)
"!dont1  BSR    chrget
*BRA    mant2
"!expon  CMPI.B #'E',c(A6)
*BEQ    expon0
*CMPI.B #'e',c(A6)
*BNE    retrn
"!expon0 BSR    chrget
*CLR    eneg(A6)
*CMPI.B #'-',c(A6)
*SEQ    eneg(A6)
*BNE    noeneg
*BSR    chrget
"!noeneg CMPI.B #'+',c(A6)
*BNE    noepos
*BSR    chrget
"!noepos CLR    D3
"!expon1 TST.B  isdigit(A6)
*BEQ    expon2
*MULU   #10,D3
*MOVE.B c(A6),D1
*ANDI   #$F,D1
*ADD    D1,D3
*BSR    chrget
*BRA    expon1
"!expon2
*TST.B  eneg(A6)
*BEQ    expon3
*NEG    D3
"!expon3 ADD.W  exp(A6),D3
*MOVE.W D3,D0
*BPL    testex
*NEG    D0
"!testex CMPI.W #307,D0
*BLE    expon4
*MOVE.L valid(A6),A1
*CLR.W  (A1)
"!expon4 MOVE.W D3,exp(A6)
"!retrn  TST.B  mneg(A6)
*BEQ    retrn1
 (*$? M68881:
*FMOVE.L #0,FPSR               ; Accrued Exc Byte lschen
*FTST.X FP0
*FBEQ   retrn1
*FNEG.X FP0
"!retrn1 MOVE.L  (A7)+,D3
*FTENTOX.W exp(A6),FP1
*FMUL.X FP1,FP0
*FMOVE.D FP0,x(A6)
*FMOVE.L FPSR,D0
*FMOVE.L (A7)+,FPCR
*ANDI.B  #11010000%,D0 ; InvalidOperation, Overflow oder DivByZero?
*BEQ     ende
*MOVE.L  valid(A6),A1
*CLR     (A1)
*BRA     error3
"error2  MOVE.L  (A7)+,D3
*FMOVE.L (A7)+,FPCR
"error3  CLR.L   x(A6)
*CLR.L   x+4(A6)
 *)
 (*$? A68881:
"!tst2   MOVE.W fpstat,D3
*TST.B  D3
*BEQ    tst2
*MOVE.W #$3A,fpcmd ; FTST FP0
"!tstl   MOVE.W fpstat,D3
*TST.B  D3
*BEQ    tstl
*MOVE.W #1,fpcond      ; FBEQ retrn1
*MOVE.W fpstat,D3     ; Response
*CMPI.W #$0802,fpstat
*BNE    protviol
*TST.B  D3
*BNE    retrn1
*MOVE.W #$1A,fpcmd   ; FNEG FP0
"!retrn1 MOVE.L (A7)+,D3
"!negl   MOVE.W fpstat,D0
*TST.B  D0
*BEQ    negl
*MOVE.W #$5092,fpcmd ; FTENTOX.W ?,FP1
"!tenl   MOVE.W fpstat,D0
*TST.B  D0
*BEQ    tenl
*SUBQ.B #2,D0
*BNE    error1
*MOVE.W exp(A6),fpop
"!neg2   MOVE.W fpstat,D0
*TST.B  D0
*BEQ    neg2
*MOVE.W #$423,fpcmd  ; FMUL  FP1,FP0
"!mull   MOVE.W fpstat,D0
*TST.B  D0
*BEQ    mull
*MOVE.W #$7400,fpcmd ; FMOVE.D FP0,?
"!movl1  MOVE.W fpstat,D0
*TST.B  D0
*BEQ    movl1
*SUBQ.B #8,D0
*BNE    error1
*MOVE.L fpop,x(A6)
*TST.W  fpstat
*MOVE.L fpop,x+4(A6)
$movl2 MOVE.W fpstat,D0
*TST.B  D0
*BEQ    movl2
*SUBQ.B #2,D0
*BEQ    Ende
*BRA    Error1
"Error2  MOVE.L (A7)+,D3
"Error1  JSR    FPUReset
*CLR.L  x(A6)
*CLR.L  x+4(A6)
*MOVE.L valid(A6),A0
*CLR.W  (A0)
 *)
&Ende
"END;
"RETURN x
 END ConvToReal;
 
$(*  <-- 68020 *) *)
 
 (*$L-*)
 PROCEDURE reverse; (* ^str:A0, High(str):D5, space:D6, len(str):D4 *)
 BEGIN
 ASSEMBLER
(LEA    0(A0,D4.W),A1
(SUBQ   #1,D6
(BCS    revers
(CMP    D5,D6
(BHI    error
(SUB    D4,D6
(BCS    revers
(MOVE   D5,D1
(SUB    D4,D1
(BCS    revers
(MOVE   D7,D0
 !spclp  MOVE.B D0,(A1)+
(ADDQ   #1,D4
(SUBQ   #1,D1
(DBCS   D6,spclp
 !revers MOVE.L A0,-(A7)
 loop0   MOVE.B (A0),D0
(MOVE.B -(A1),(A0)+
(MOVE.B D0,(A1)
(CMPA.L A0,A1
(BHI    loop0
(MOVE.L (A7)+,A0
(CMP    D5,D4
(BHI    finis
(CLR.B  0(A0,D4.W)
(BRA    finis
 error   TRAP   #6
(DC.W   StringOverflow-$4000  ; string overflow
 finis   MOVEM.L (A7)+,D3-D7
(UNLK    A5
 END
 END reverse;
 
 (*$L-*)
 PROCEDURE LCToStr; (* lc:D3.L, ^str:A0, High(str):D5  => D4:len(str) *)
 BEGIN
 ASSEMBLER
(; D6 erhalten !
(MOVEQ  #0,D4
 !lbl    CMP    D5,D4
(BHI    error
(MOVEQ  #10,D0
(MOVE.L D3,D1
(MOVEQ  #0,D2
(MOVEQ  #0,D3
 !cd1    CMP.L  D0,D1
(BLS    cd2
(ADDQ   #1,D2
(ASL.L  #1,D0
(BPL    cd1
 !cd2    ASL.L  #1,D3
(CMP.L  D0,D1
(BCS    cd3
(SUB.L  D0,D1
(ADDQ.B #1,D3
 !cd3    LSR.L  #1,D0
(DBF    D2,cd2
(ADDI   #'0',D1
(MOVE.B D1,0(A0,D4.W)
(ADDQ   #1,D4
(TST.L  D3
(BNE    lbl
(RTS
 error   TRAP   #6
(DC.W   StringOverflow-$4000  ; string overflow
 END
 END LCToStr;
 
 (*$L-*)
 PROCEDURE ConvCard(lc:LONGCARD; space:CARDINAL; VAR str: ARRAY OF CHAR);
 BEGIN
 ASSEMBLER
(LINK   A5,#0
(MOVEM.L D3-D7,-(A7)
(MOVE   -(A3),D5         ; HIGH (str)
(MOVE.L -(A3),A0         ; ^str
(MOVE   -(A3),D6         ; space
(MOVE.L -(A3),D3         ; lc
(JSR    LCToStr
(MOVEQ  #' ',D7
(JMP    reverse
 END
 END ConvCard;
 
 (*$L-*)
 PROCEDURE LItoStr;
 BEGIN
 ASSEMBLER
(TST.L  D3
(BPL    notneg
(NEG.L  D3
(SUBQ.L #1,D5            ; HIGH verringern fr '-' Zeichen
(BCS    error
(JSR    LCToStr
(ADDQ   #1,D5
(MOVE.B #'-',0(A0,D4.W)
(ADDQ   #1,D4
(BRA    finis
 !notneg JSR    LCToStr
 !finis  MOVEQ  #' ',D7
(JMP    reverse
 error   TRAP    #6
(DC.W    StringOverflow-$4000  ; string overflow
(MOVEM.L (A7)+,D3-D7
(UNLK    A5
 END
 END LIToStr;
 
 (*$L-*)
 PROCEDURE ConvInt(i:LONGINT; space:CARDINAL; VAR str: ARRAY OF CHAR);
 BEGIN
 ASSEMBLER
(LINK   A5,#0
(MOVEM.L D3-D7,-(A7)
(MOVE   -(A3),D5         ; HIGH (str)
(MOVE.L -(A3),A0         ; ^str
(MOVE   -(A3),D6         ; space
(MOVE.L -(A3),D3
(JMP    LItoStr
 END
 END ConvInt;
 
 (*$L-*)
 PROCEDURE LHtoStr;
 BEGIN
 ASSEMBLER
(MOVEQ  #0,D2
(SUBQ   #1,D0
 !lbl    CMP    D5,D2
(BEQ    error
(MOVE.B D1,D3
(ANDI.B #$F,D3
(ORI.B  #'0',D3
(CMPI.B #'9',D3
(BLS    noadd
(ADDQ.B #7,D3
 !noadd  MOVE.B D3,0(A0,D2.W)
(ADDQ.B #1,D2
(BMI    dollar           ; Falls space zu gro
(SUBQ   #1,D0
(LSR.L  #4,D1
(BNE    lbl
(TST    D0
(BGT    lbl
 dollar  MOVE.B #'$',0(A0,D2.W)
(LEA    1(A0,D2.W),A1
 !revers MOVE.L A0,-(A7)
 l       MOVE.B (A0),D1
(MOVE.B -(A1),(A0)+
(MOVE.B D1,(A1)
(CMPA.L A0,A1
(BHI    l
(MOVE.L (A7)+,A0
(CMP    D5,D2
(BEQ    finis
(CLR.B  1(A0,D2.W)
(BRA    finis
 error   TRAP   #6
(DC.W   StringOverflow-$4000  ; string overflow
 !finis  MOVEM.L (A7)+,D3-D6
(UNLK    A5
 END
 END LHtoStr;
 
 (*$L-*)
 PROCEDURE ConvLHex(l:LONGWORD; space:CARDINAL; VAR str: ARRAY OF CHAR);
 BEGIN
 ASSEMBLER
(LINK   A5,#0
(MOVEM.L D3-D6,-(A7)
(MOVE   -(A3),D5         ; HIGH (str)
(MOVE.L -(A3),A0         ; ^str
(MOVE   -(A3),D0         ; space
(MOVE.L -(A3),D1         ; l
(JMP    LHToStr
 END
 END ConvLHex;
 
 (*$L-*)
 PROCEDURE ConvHex(w:WORD; space:CARDINAL; VAR str: ARRAY OF CHAR);
 BEGIN
 ASSEMBLER
(LINK   A5,#0
(MOVEM.L D3-D6,-(A7)
(MOVE   -(A3),D5         ; HIGH (str)
(MOVE.L -(A3),A0         ; ^str
(MOVE   -(A3),D0         ; space
(MOVEQ  #0,D1
(MOVE   -(A3),D1
(JMP    LHToStr
 END
 END ConvHex;
 
 (*$L-*)
 PROCEDURE LBToStr;
 BEGIN
 ASSEMBLER
(MOVEQ  #0,D2
(SUBQ   #1,D0
 !lbl    CMP    D5,D2
(BEQ    error
(MOVE.B D1,D3
(ANDI.B #$1,D3
(ORI.B  #'0',D3
(MOVE.B D3,0(A0,D2.W)
(ADDQ.B #1,D2
(BMI    proznt           ; Falls space zu gro
(SUBQ   #1,D0
(LSR.L  #1,D1
(BNE    lbl
(TST    D0
(BGT    lbl
 !proznt MOVE.B #'%',0(A0,D2.W)
(LEA    1(A0,D2.W),A1
 !revers MOVE.L A0,-(A7)
 l       MOVE.B (A0),D1
(MOVE.B -(A1),(A0)+
(MOVE.B D1,(A1)
(CMPA.L A0,A1
(BHI    l
(MOVE.L (A7)+,A0
(CMP    D5,D2
(BEQ    finis
(CLR.B  1(A0,D2.W)
(BRA    finis
 error   TRAP   #6
(DC.W   StringOverflow-$4000  ; string overflow
 !finis  MOVEM.L (A7)+,D3-D6
(UNLK    A5
 END
 END LBToStr;
 
 (*$L-*)
 PROCEDURE ConvLBin(l:LONGWORD; space:CARDINAL; VAR str: ARRAY OF CHAR);
 BEGIN
 ASSEMBLER
(LINK   A5,#0
(MOVEM.L D3-D6,-(A7)
(MOVE   -(A3),D5         ; HIGH (str)
(MOVE.L -(A3),A0         ; ^str
(MOVE   -(A3),D0         ; space
(MOVE.L -(A3),D1         ; l
(JMP    LBToStr
 END
 END ConvLBin;
 
 (*$L-*)
 PROCEDURE ConvBin(W:WORD; space:CARDINAL; VAR str: ARRAY OF CHAR);
 BEGIN
 ASSEMBLER
(LINK   A5,#0
(MOVEM.L D3-D6,-(A7)
(MOVE   -(A3),D5         ; HIGH (str)
(MOVE.L -(A3),A0         ; ^str
(MOVE   -(A3),D0         ; space
(MOVEQ  #0,D1
(MOVE   -(A3),D1
(JMP    LBToStr
 END
 END ConvBin;
 
 
 (*$L-*)
 PROCEDURE ConvLNum(l:LONGWORD; base,space:CARDINAL; fillCh: CHAR;
(VAR str: ARRAY OF CHAR);
 BEGIN
 ASSEMBLER
(LINK   A5,#0
(MOVEM.L D3-D7,-(A7)
(MOVE   -(A3),D5         ; HIGH (str)
(MOVE.L -(A3),A0         ; ^str
(SUBQ.L #1,A3
(MOVE.B -(A3),D7         ; fillCh
(MOVE   -(A3),D6         ; space
(MOVEQ  #0,D2
(MOVE   -(A3),D2         ; base
(MOVE.L -(A3),D1         ; l
(CMPI   #1,D2
(BLS    err
(CMPI   #36,D2
(BLS    ok
 
 err     CLR.B  (A0)
(TRAP   #6
(DC.W   OutOfRange-$4000
(MOVEM.L (A7)+,D3-D7
(UNLK    A5
(RTS
 
 ok      MOVEQ  #0,D4
 !lbl    CMP    D5,D4            ; HIGH (str) erreicht ?
(BHI    error
(MOVE.L D1,(A3)+
(MOVE.L D2,(A3)+
(MOVEM.L D1/D2,-(A7)
(JSR    @CMOD
(MOVEM.L (A7)+,D1/D2
(MOVE.L -(A3),D3
(ADDI.B #'0',D3
(CMPI.B #'9',D3
(BLS    noadd
(ADDQ.B #7,D3
 !noadd  MOVE.B D3,0(A0,D4.W)
(ADDQ.B #1,D4
(BMI    revers           ; Falls space zu gro
(MOVE.L D1,(A3)+
(MOVE.L D2,(A3)+
(MOVEM.L D1-D2,-(A7)
(JSR    @CDIV
(MOVEM.L (A7)+,D1-D2
(MOVE.L -(A3),D1
(BNE    lbl
 revers  JMP    reverse
 error   TRAP   #6
(DC.W   StringOverflow-$4000  ; string overflow
 !finis  MOVEM.L (A7)+,D3-D7
(UNLK    A5
 END
 END ConvLNum;
 
 (*$L-*)
 PROCEDURE ConvNum(w:WORD; base,space:CARDINAL; fillCh: CHAR;
0VAR str: ARRAY OF CHAR);
 BEGIN
 ASSEMBLER
(LINK   A5,#0
(MOVEM.L D3-D7,-(A7)
(MOVE   -(A3),D5         ; HIGH (str)
(MOVE.L -(A3),A0         ; ^str
(SUBQ.L #1,A3
(MOVE.B -(A3),D7         ; fillCh
(MOVE   -(A3),D6         ; space
(MOVE   -(A3),D2         ; base
(MOVEQ  #0,D1
(MOVE   -(A3),D1         ; w
(CMPI   #1,D2
(BLS    err
(CMPI   #36,D2
(BLS    ok
 
 err     CLR.B  (A0)
(TRAP   #6
(DC.W   OutOfRange-$4000
(MOVEM.L (A7)+,D3-D7
(UNLK    A5
(RTS
 
 ok      MOVEQ  #0,D4
 !lbl    CMP    D5,D4            ; HIGH (str) erreicht ?
(BHI    error
(DIVU   D2,D1
(SWAP   D1
(ADDI.B #'0',D1
(CMPI.B #'9',D1
(BLS    noadd
(ADDQ.B #7,D1
 !noadd  MOVE.B D1,0(A0,D4.W)
(ADDQ.B #1,D4
(BMI    revers           ; Falls space zu gro
(CLR    D1
(SWAP   D1
(BNE    lbl
 revers  JMP    reverse
 error   TRAP   #6
(DC.W   StringOverflow-$4000  ; string overflow
 !finis  MOVEM.L (A7)+,D3-D7
(UNLK    A5
 END
 END ConvNum;
 
 
 (*$? ~M68881 AND ~A68881:
 
 TABLE.L zehntel:    $FFEACCCC,$CCCCCCCC;
(half:       $00028000,$00000000;
(roundkonst: $FFE2CCCC,$CCCCCCCC,$FFCAA3D7,$0A3D70A3,
4$FFB28312,$6E978D2F,$FF92D1B7,$1758E219,
4$FF7AA7C5,$AC471B47,$FF628637,$BD05AF6C,
4$FF42D6BF,$94D5E57A,$FF2AABCC,$77118461,
4$FF128970,$5F4136B4,$FEF2DBE6,$FECEBDED,
4$FEDAAFEB,$FF0BCB24,$FEC28CBC,$CC096F50,
4$FEA2E12E,$13424BB4,$FE8AB424,$DC358000;
 
 (*$L-*)
 PROCEDURE norm;
"(*
&normiert Realzahl (A2) auf 0.1 <= (A2) < 1.0;
&korrigert dabei Integer-Exponent (A1).
"*)
 BEGIN
 ASSEMBLER
(;0.1<=x<1.0
(;A1:=^e; A2:=^x
(MOVE.L A1,-(A7)
(MOVE.L A2,-(A7)
 !norm0  MOVE.L (A7),A1
(LEA    eins,A0
(JSR    @LRGE
(TST    D0
(BEQ    norm1
(MOVE.L (A7),A1
(LEA    tenpot,A0
(JSR    @LDIV
(MOVE.L 4(A7),A1
(ADDQ   #1,(A1)
(BRA    norm0
 !norm1  MOVE.L (A7),A1
(LEA    zehntel,A0
(JSR    @LRLT
(TST    D0
(BEQ    norm2
(MOVE.L (A7),A1
(LEA    tenpot,A0
(JSR    @LMUL
(MOVE.L 4(A7),A1
(SUBQ   #1,(A1)
(BRA    norm1
 !norm2  ADDQ.L #8,A7
 END
 END norm;
 
 
 (*$L-*)
 PROCEDURE put;
 BEGIN
 ASSEMBLER
(;ein Zeichen in <line> zuweisen
(;A0:=^Str, D0:=Zeichen
(MOVE    LStr.l(A0),D6
(CMP     LStr.h(A0),D6
(BHI     overfl
(ADDQ    #1,LStr.l(A0)
(MOVE.L  LStr.p(A0),A1
(MOVE.B  D0,0(A1,D6.W)
(CMP     D0,D0           ; liefert EQ
 overfl                          ; liefert NE
 END
 END put;
 
 (*$L-*)
 PROCEDURE digit;
 BEGIN
 ASSEMBLER
(CMPI   #13,D5
(BLS    ok
(MOVEQ  #0,D0
(BEQ    digout
 !ok     ADDQ   #1,D5
(MOVE.L D0,D2    ;A0=^line, (D0,D1)=x
(MOVE.L D1,D3    ;benutzt D2,D3
(ASL.L  #1,D3    ;D5=Zaehler
(ROXL.L #1,D2
(ASL.L  #1,D3
(ROXL.L #1,D2
(ADD.L  D3,D1
(ADDX.L D2,D0
(ASL.L  #1,D1
(ROXL.L #1,D0
(SWAP   D0
 !digout ORI    #'0',D0
(JSR    put
(BNE    finis
(CLR    D0
(SWAP   D0
(CMP    D0,D0    ; liefert EQ
 finis
 END
 END digit;
 
 (*$L-*)
 PROCEDURE bintodezexp;
 BEGIN
 ASSEMBLER
(ASR.W  #3,D2    ;jm 15.6.
(; EXT.L  D2
(BPL    noadd
(ADDQ.L #1,D2
 !noadd  MULS   #77,D2
(ASR.L  #0,D2    ;das sind natrlich 8 Shifts! 77/256 ~ log 2
(BMI    noadd1
(ADDQ   #1,D2
 !noadd1
 END
 END bintodezexp;
 
 (*$L-*)
 PROCEDURE insSpc ( VAR lin:ARRAY OF CHAR; len:Cardinal; spc:Cardinal );
 (* ^str:A0, High(str):D5, space:D6, len(str):D4 *)
 BEGIN
 ASSEMBLER
(MOVE   -(A3),D6
(MOVE   -(A3),D4
(MOVE   -(A3),D5
(MOVE.L -4(A3),A0
(
(LEA    0(A0,D4.W),A1
 rev2    MOVE.B (A0),D0
(MOVE.B -(A1),(A0)+
(MOVE.B D0,(A1)
(CMPA.L A0,A1
(BHI    rev2
(
(MOVE.L -(A3),A0
(
(LEA    0(A0,D4.W),A1
(SUBQ   #1,D6
(BCS    revers
(CMP    D5,D6
(BHI    error
(SUB    D4,D6
(BCS    revers
(MOVE   D5,D1
(SUB    D4,D1
(BCS    revers
(MOVEQ  #' ',D0
 !spclp  MOVE.B D0,(A1)+
(ADDQ   #1,D4
(SUBQ   #1,D1
(DBCS   D6,spclp
 !revers MOVE.L A0,-(A7)
 l       MOVE.B (A0),D0
(MOVE.B -(A1),(A0)+
(MOVE.B D0,(A1)
(CMPA.L A0,A1
(BHI    l
(MOVE.L (A7)+,A0
(CMP    D5,D4
(BHI    finis
(CLR.B  0(A0,D4.W)
(BRA    finis
 error   TRAP   #6
(DC.W   StringOverflow-$4000 ; string overflow
 finis
 END
 END insSpc;
 
 (*$L+*)
 PROCEDURE ConvFloat(x:LONGREAL; space,n:CARDINAL; VAR lin: ARRAY OF CHAR);
 VAR e:INTEGER; line:LStr;
 BEGIN
"ASSEMBLER
*;1 Stelle vor, n nach Komma, E+-DDDD
*
*MOVEM.L D3-D6,-(A7)
*
*MOVE.L lin(A6),line.p(A6)
*MOVE.W lin+4(A6),line.h(A6)  ; HIGH (lin)
*CLR.W  line.l(A6)
*
*LEA    line(A6),A0
*MOVE   x(A6),D2
*BNE    notzer
*MOVEQ  #'0',D0      ;x = 0.0
*JSR    put
*BNE.L  overfl
*MOVE.B RadixChar,D0
*JSR    put
*BNE.L  overfl
*MOVEQ  #'0',D0
*MOVE   n(A6),D1
*BEQ    nozero
"!zeros  JSR    put
*BNE.L  overfl
*SUBQ   #1,D1
*BNE    zeros
"!nozero MOVE   #1,e(A6)
*BRA.L  putexp
"!notzer BCLR   #0,D2         ;jm 14.6.
*BEQ    notneg
*MOVE   D2,x(A6)      ;x < 0.0: jetzt positiv gemacht
*MOVEQ  #'-',D0
*JSR    put
*BNE.L  overfl
"!notneg JSR    bintodezexp
*MOVE   D2,e(A6)
*LEA    x(A6),A0      ;x:=x/ten(e)
*MOVE.L (A0)+,(A3)+
*MOVE.L (A0),(A3)+
*MOVE   D2,(A3)+
*SUBQ.L #2,A7
*MOVE.L A7,(A3)+    ;'valid'-Para; nur dummy, weil Overflow unmglich
*JSR    ten
*ADDQ.L #2,A7
*JSR    @RDIV
*LEA    x(A6),A2     ;0.1<=x<1.0
*MOVE.L -(A3),4(A2)
*MOVE.L -(A3),(A2)
*LEA    e(A6),A1
*JSR    norm
*MOVE   n(A6),D0     ;Runden: Anzahl Nachkommastellen
*CMPI   #13,D0
*BLS    okrund
*MOVEQ  #13,D0
"!okrund ASL    #3,D0
*LEA    roundkonst,A0
*ADDA   D0,A0          ;Zugriff auf 0.5 / 10^(n+1)
@; (beachte 0.1 <= Zahl < 1.0, daher n+1)
*MOVE.L (A0)+,(A3)+
*MOVE.L (A0),(A3)+
*LEA    x(A6),A0
*MOVE.L (A0)+,(A3)+
*MOVE.L (A0),(A3)+
*JSR    @RADD           ;0.1<=x<1.0
*LEA    x(A6),A2
*MOVE.L -(A3),4(A2)
*MOVE.L -(A3),(A2)
*LEA    e(A6),A1
*JSR    norm
*LEA    x(A6),A0        ;trunc(x) in 48-bit Mantisse
*MOVE.L (A0)+,D0
*MOVE.L (A0),D1
*SWAP   D0
*MOVE   D0,D2          ;Exponentenwort
*CLR    D0
*SWAP   D0             ;in D0 Exp.wort geloescht
*
*ASR    #3,D2
*BPL    finis          ;bei Exp >= 0 fertig
*NOT    D2             ;Exp -1 ergibt Zhlwert 0 in D2 (NEG D2, DEC D2)
*; SUBI   #$0FFF,D2
*; BGT    finis        ;bei Exp > -1 fertig
*; NEG    D2
"
"!shr    LSR    #1,D0
*ROXR.L #1,D1
*DBF    D2,shr
*BCC    finis          ;evtl. aufrunden
*ADDQ.L #1,D1
*BCC    finis
*ADDQ.W #1,D0
"!finis  LEA    line(A6),A0    ;Vorkommastelle berechnen
*MOVEQ  #0,D5
*JSR    digit
*BNE.L  overfl
*MOVE.L D0,D2
*MOVE   n(A6),D4
*BEQ    putexp
*MOVE.B RadixChar,D0
*JSR    put
*BNE.L  overfl
*MOVE.L D2,D0
"!putman JSR    digit          ;n Nachkommastellen berechnen
*BNE.L  overfl
*SUBQ   #1,D4
*BNE    putman
"!putexp SUBQ   #1,e(A6)
*MOVEQ  #'E',D0
*JSR    put
*BNE.L  overfl
*MOVEQ  #'+',D0
*MOVE   e(A6),D1
*BPL    posit
*NEG    D1
*MOVEQ  #'-',D0
"!posit  JSR    put
*BNE.L  overfl
*MOVE   D1,D0
*MOVEQ  #'0',D1
*DIVU   #1000,D0
*OR     D1,D0
*JSR    put
*BNE.L  overfl
*CLR    D0
*SWAP   D0
*DIVU   #100,D0
*OR     D1,D0
*JSR    put
*BNE.L  overfl
*CLR    D0
*SWAP   D0
*DIVU   #10,D0
*OR     D1,D0
*JSR    put
*BNE    overfl
*SWAP   D0
*OR     D1,D0
*JSR    put
*BNE    overfl
"END;
"insSpc (lin,line.l,space);
"ASSEMBLER
*BRA    ende
"overfl  TRAP   #6
*DC.W   StringOverflow-$4000 ; string overflow
"ende    MOVEM.L (A7)+,D3-D6
"END
 END ConvFloat;
 
 (*$L+*)
 PROCEDURE ConvEng(x:LONGREAL; space,n:CARDINAL; VAR lin: ARRAY OF CHAR);
 VAR line:LStr;
$e:INTEGER;
 BEGIN
"ASSEMBLER
*;1-3 Stelle vor, n nach Komma, E+-DDDD
*
*MOVEM.L D3-D6,-(A7)
*
*MOVE.L lin(A6),line.p(A6)
*MOVE.W lin+4(A6),line.h(A6)  ; HIGH (lin)
*CLR.W  line.l(A6)
*
*LEA    line(A6),A0
*MOVE   x(A6),D2
*BNE    notzer
*MOVEQ  #'0',D0      ;x = 0.0
*JSR    put
*BNE.L  overfl
*MOVE.B RadixChar,D0
*JSR    put
*BNE.L  overfl
*MOVEQ  #'0',D0
*MOVE   n(A6),D1
*BEQ    nozero
"!zeros  JSR    put
*BNE.L  overfl
*SUBQ   #1,D1
*BNE    zeros
"!nozero CLR    e(A6)
*BRA.L  putexp
"!notzer BCLR   #0,D2         ;jm 14.6.
*BEQ    notneg
*MOVE   D2,x(A6)
*MOVEQ  #'-',D0
*JSR    put
*BNE.L  overfl
"
"!notneg JSR    bintodezexp
*MOVE   D2,e(A6)
*LEA    x(A6),A0      ;x:=x/ten(e)
*MOVE.L (A0)+,(A3)+
*MOVE.L (A0),(A3)+
*MOVE   D2,(A3)+
*SUBQ.L #2,A7
*MOVE.L A7,(A3)+    ;'valid'-Para; nur dummy, weil Overflow unmglich
*JSR    ten
*ADDQ.L #2,A7
*JSR    @RDIV
*LEA    x(A6),A2     ;0.1<=x<1.0
*MOVE.L -(A3),4(A2)
*MOVE.L -(A3),(A2)
*LEA    e(A6),A1
*JSR    norm         ;0.1<=x<1.0
*MOVE   n(A6),D0     ;Runden
*
*; zustzlich zu Nachkommastellen haben wir e MOD 3 Vorkommastellen;
*; Rundung soll hinter der letzten ausgegebenen Ziffer erfolgen
*
*MOVEQ  #0,D1        ; berechne e MOD 3
*MOVE   e(A6),D1
*ADD    #1235,D1
*DIVU   #3,D1
*SWAP   D1
)
*ADD    D1,D0        ; addieren zur Gesamtstellenzahl
*ADDQ   #1,D0
*CMPI   #14,D0
*BLS    okrund
*MOVEQ  #14,D0
"!okrund ASL    #3,D0
*LEA    roundkonst,A0  ; dummy, um Weg-Optimierung zu verhindern
*LEA    half,A0
*ADDA   D0,A0
*MOVE.L (A0)+,(A3)+
*MOVE.L (A0),(A3)+
*LEA    x(A6),A0
*MOVE.L (A0)+,(A3)+
*MOVE.L (A0),(A3)+
*JSR    @RADD
*LEA    x(A6),A2
*MOVE.L -(A3),4(A2)
*MOVE.L -(A3),(A2)
*LEA    e(A6),A1
*JSR    norm
 noRund    LEA    x(A6),A0        ;trunc(x) in 48-bit Mantisse
*MOVE.L (A0)+,D0
*MOVE.L (A0),D1
*SWAP   D0
*MOVE   D0,D2
*CLR    D0
*SWAP   D0
*
*ASR    #3,D2
*BPL    finis          ;bei Exp >= 0 fertig
*NOT    D2             ;Exp -1 ergibt Zhlwert 0 in D2 (NEG D2, DEC D2)
*; SUBI   #$0FFF,D2
*; BGT    finis        ;bei Exp > -1 fertig
*; NEG    D2
"
"!shr    LSR    #1,D0
*ROXR.L #1,D1
*DBF    D2,shr
*BCC    finis          ;evtl. aufrunden
*ADDQ.L #1,D1
*BCC    finis
*ADDQ.W #1,D0
"!finis  LEA    line(A6),A0    ;1-3 Vorkommastellen berechnen
*MOVEQ  #0,D5          ;Zaehler fuer ausgegebene Stellen
"!putvor JSR    digit
*BNE.L  overfl
*MOVEQ  #0,D4
*MOVE   e(A6),D4
*SUBQ   #1,D4
*MOVE   D4,e(A6)
*ADD    #1233,D4
*DIVU   #3,D4
*SWAP   D4
*TST    D4
*BNE    putvor
*MOVE   n(A6),D4
*BEQ    putexp
*MOVE.L D0,D2
*MOVE.B RadixChar,D0
*JSR    put
*BNE.L  overfl
*MOVE.L D2,D0
"!putman JSR    digit          ;n Nachkommastellen berechnen
*BNE.L  overfl
*SUBQ   #1,D4
*BNE    putman
"!putexp MOVEQ  #'E',D0
*JSR    put
*BNE.L  overfl
*MOVEQ  #'+',D0
*MOVE   e(A6),D1
*BPL    posit
*NEG    D1
*MOVEQ  #'-',D0
"!posit  JSR    put
*BNE.L  overfl
*MOVE   D1,D0
*MOVEQ  #'0',D1
*DIVU   #1000,D0
*OR     D1,D0
*JSR    put
*BNE.L  overfl
*CLR    D0
*SWAP   D0
*DIVU   #100,D0
*OR     D1,D0
*JSR    put
*BNE    overfl
*CLR    D0
*SWAP   D0
*DIVU   #10,D0
*OR     D1,D0
*JSR    put
*BNE    overfl
*SWAP   D0
*OR     D1,D0
*JSR    put
*BNE    overfl
"END;
"insSpc (lin,line.l,space);
"ASSEMBLER
*BRA    ende
"overfl  TRAP   #6
*DC.W   StringOverflow-$4000 ; string overflow
"ende    MOVEM.L (A7)+,D3-D6
"END
 END ConvEng;
 
 (*$L+*)
 PROCEDURE ConvFix(x:LONGREAL; space,n:CARDINAL; VAR lin: ARRAY OF CHAR);
 VAR line:LStr;
$e:INTEGER;
 BEGIN
"ASSEMBLER
*MOVEM.L D3-D6,-(A7)
*
*MOVE.L lin(A6),line.p(A6)
*MOVE.W lin+4(A6),line.h(A6)  ; HIGH (lin)
*CLR.W  line.l(A6)
*
*LEA    line(A6),A0
*MOVE   x(A6),D2
*BNE    notzer
*MOVEQ  #'0',D0      ;x = 0.0
*JSR    put
*BNE.L  overfl
*MOVE.B RadixChar,D0
*JSR    put
*BNE.L  overfl
*MOVEQ  #'0',D0
*MOVE   n(A6),D1
*BEQ    nozero
"!zeros  JSR    put
*BNE.L  overfl
*SUBQ   #1,D1
*BNE    zeros
"!nozero BRA.L  ende
"!notzer BCLR   #0,D2         ;jm 14.6.
*BEQ    notneg
*MOVE   D2,x(A6)
*MOVEQ  #'-',D0
*JSR    put
*BNE.L  overfl
"!notneg JSR    bintodezexp
*MOVE   D2,e(A6)
*LEA    x(A6),A0      ;x:=x/ten(e)
*MOVE.L (A0)+,(A3)+
*MOVE.L (A0),(A3)+
*MOVE   D2,(A3)+
*SUBQ.L #2,A7
*MOVE.L A7,(A3)+    ;'valid'-Para; nur dummy, weil Overflow unmglich
*JSR    ten
*ADDQ.L #2,A7
*JSR    @RDIV
*LEA    x(A6),A2
*MOVE.L -(A3),4(A2)
*MOVE.L -(A3),(A2)
*LEA    e(A6),A1
*JSR    norm
*MOVE   n(A6),D0      ;Runden: ausgegeben werden n Nachkomma-
?; stellen und e Vorkommastellen!
?; Auf nomalisierte Mantisse daher hinter
?; der (n+e). Stelle 0.5 addieren!
*ADD    e(A6),D0
*BMI    norund
*CMPI   #14,D0
*BLS    okrund
*MOVEQ  #14,D0
"!okrund ASL    #3,D0
*LEA    roundkonst,A0  ; dummy, um Weg-Optimierung zu verhindern
*LEA    half,A0
*ADDA   D0,A0
*MOVE.L (A0)+,(A3)+
*MOVE.L (A0),(A3)+
*LEA    x(A6),A0
*MOVE.L (A0)+,(A3)+
*MOVE.L (A0),(A3)+
*JSR    @RADD
*LEA    x(A6),A2
*MOVE.L -(A3),4(A2)
*MOVE.L -(A3),(A2)
*LEA    e(A6),A1
*JSR    norm
"!norund LEA    x(A6),A0       ;trunc(x) in 48-bit Mantisse
*MOVE.L (A0)+,D0
*MOVE.L (A0),D1
*SWAP   D0
*MOVE   D0,D2
*CLR    D0
*SWAP   D0
*
*ASR    #3,D2
*BPL    finis          ;bei Exp >= 0 fertig
*NOT    D2             ;Exp -1 ergibt Zhlwert 0 in D2 (NEG D2, DEC D2)
*; SUBI   #$0FFF,D2
*; BGT    finis        ;bei Exp > -1 fertig
*; NEG    D2
"
"!shr    LSR    #1,D0
*ROXR.L #1,D1
*DBF    D2,shr
*BCC    finis          ;evtl. aufrunden
*ADDQ.L #1,D1
*BCC    finis
*ADDQ.W #1,D0
"!finis  LEA    line(A6),A0
*MOVEQ  #0,D5
*TST    e(A6)
*BLE    vork0
"!vork   JSR    digit
*BNE.L  overfl
*SUBQ   #1,e(A6)
*BGT    vork
*BRA    decpt
"!vork0  MOVE.L D0,D2
*MOVEQ  #'0',D0
*JSR    put
*BNE.L  overfl
*MOVE.L D2,D0
"!decpt  MOVE   n(A6),D4
*BLE    ende
*MOVE.L D0,D2
*MOVE.B RadixChar,D0
*JSR    put
*BNE.L  overfl
*MOVE.L D2,D0
"!putman TST    e(A6)
*BGE    putmdg
*ADDQ   #1,e(A6)
*MOVE.L D0,D2
*MOVEQ  #'0',D0
*JSR    put
*BNE.L  overfl
*MOVE.L D2,D0
*SUBQ   #1,D4
*BGT    putman
*BRA    ende
"!putmdg JSR    digit
*BNE    overfl
*SUBQ   #1,D4
"!ende   BGT    putmdg
"
"END;
"insSpc (lin,line.l,space);
"ASSEMBLER
*BRA    ende0
"overfl  TRAP   #6
*DC.W   StringOverflow-$4000 ; string overflow
"ende0   MOVEM.L (A7)+,D3-D6
"END
 END ConvFix;
((*  <-- 68000 *) *)
 
 (*$? M68881 OR A68881:
 
 (*$L+*)
 
 PROCEDURE CFloat(v:LONGREAL;VAR mpos,epos : BOOLEAN;kfact : INTEGER;
1VAR decstr : ARRAY OF CHAR;
1VAR exponi : INTEGER);
 
 VAR ostr : ARRAY[0..2] OF LONGINT;
$lepos: BOOLEAN;
 
 BEGIN
"ASSEMBLER
(; WIRD NICHT BENUTZT!? MOVE.W  kfact(A6),D0         ;Dynamic k-factor
"(*$? M68881:
(FMOVE.L FPCR,D1
(FMOVE.L #0,FPCR               ; keine Exceptions auslsen
(FMOVE.D v(A6),FP0
(LEA     ostr(A6),A0
(FMOVE.P FP0,(A0){17}
(FMOVE.L D1,FPCR
"*)
"(*$? A68881:
 !movl1  MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     movl1
(SUBQ.B  #2,D0
(BEQ     noError
(JSR     FPUError
 noError
(MOVE.W  #$5400,fpcmd         ; FMOVE.D v(A6),FP0
 !movl2  MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     movl2
(MOVE.L  v(A6),fpop
(TST.W   fpstat
(MOVE.L  v+4(A6),fpop
 !movl22 MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     movl22
(LEA     ostr(A6),A0
(MOVE.W  #$6C11,fpcmd    ;FMOVE.P FP0,(A0){#17}
 !movl3  MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     movl3
(MOVE.L  fpop,(A0)+
(TST.W   fpstat
(MOVE.L  fpop,(A0)+
(TST.W   fpstat
(MOVE.L  fpop,(A0)
(TST.W   fpstat
(SUBQ.L  #8,A0
"*)
(CMPI.B  #$A,3(A0)            ; Coprozessorfehler abfangen (A ~ 10)
(BNE     no10pot
(MOVE.B  #1,3(A0)
 !no10pot
(MOVEA.L mpos(A6),A1
(CLR.W   (A1)
(BTST.B  #7,(A0)
(BNE     m_pos
(MOVE.W  #1,(A1)
(MOVEQ   #1,D2
 !m_pos  MOVEA.L epos(A6),A1
(CLR.W   (A1)
(CLR.W   lepos(A6)
(BTST.B  #6,(A0)
(BNE     e_pos
(MOVE.W  #1,lepos(A6)
(MOVE.W  #1,(A1)
 !e_pos
(ADDA.W  #12,A0               ; (A0) := ostr{12+}
(MOVEA.L decstr(A6),A1        ; A1 := ADR(decstr)
(MOVEA.L A1,A2
(ADDA.W  #17,A2               ; (A2) := decstr{17+}
(MOVEQ   #7,D0                ; count := 8
(; UNPACK scheint nicht richtig zu laufen (Errata-Sheet nachschauen !)
 !unplp  ; UNPK    -(A0),-(A2),#48
E; unpack mantissa
(CLR.W   D1
(MOVE.B  -(A0),D1
(LSL.W   #4,D1
(LSR.B   #4,D1
(ADD.W   #$3030,D1
(MOVE.B  D1,-(A2)
(LSR.W   #8,D1
(MOVE.B  D1,-(A2)
 (*      MOVE.W  D1,-(A2)    Durch die beiden Moves ersetzt 19.08. MR *)
(DBRA    D0,unplp
(MOVE.B  -(A0),D1
(ANDI.B  #$0F,D1
(ADD.B   #$30,D1
(MOVE.B  D1,-(A2)
(MOVEA.L A1,A2                ; unpack exponent
(ADDA.W  #20,A2
(SUBQ.L  #1,A0
(CLR.W   D1
(MOVE.B  -(A0),D1
(CLR.W   D2
(MOVE.B  D1,D2
(LSR.B   #4,D2
(MULU    #10,D2
(LSL.W   #4,D1
(LSR.B   #4,D1
(CLR.W   D0
(MOVE.B  D1,D0
(ADD.W   D2,D0
(ADD.W   #$3030,D1
(MOVE.W  D1,-(A2)
(MOVE.B  -(A0),D1
(ANDI.B  #$F,D1
(MOVE.B  D1,D2
(MULU    #100,D2
(ADD.W   D2,D0
(ADD.B   #$30,D1
(MOVE.B  D1,-(A2)
(TST.W   lepos(A6)
(BNE     e2_pos
(NEG.W   D0
 !e2_pos MOVEA.L exponi(A6),A0
(MOVE.W  D0,(A0)
"END;
 END CFloat;
 
 
 (* neue Routinen von GS: *)
 
 (*$L-*)
 PROCEDURE getExp(r : LONGREAL) : INTEGER;
 
"BEGIN
$ASSEMBLER
 (*$? M68881:
(FMOVE.L         FPCR,D0
(FMOVE.L         #0,FPCR               ; keine Exceptions auslsen
(FABS.D          -(A3),FP0
(FLOG10.X        FP0
(FMOVE.W         FP0,(A3)+
(FMOVE.L         D0,FPCR
 *)
 (*$? A68881:
%l0 MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     l0
(SUBQ.B  #2,D0
(BEQ     noError
(JSR     FPUError
%noError:
(MOVE.W  #$5418,fpcmd   ; FABS.D <ea>,FP0
(MOVE.L  -(A3),D2
(MOVE.L  -(A3),D1
(MOVE.W  fpstat,D0
(SUBQ.B  #8,D0
(BNE     Error
(MOVE.L  D1,fpop
(TST.W   fpstat
(MOVE.L  D2,fpop
%l5 MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     l5
(MOVE.W  #$0015,fpcmd   ; FLOG10.X FP0
%l2 MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     l2
(SUBQ.B  #2,D0
(BNE     Error
(MOVE.W  #$7000,fpcmd   ; FMOVE.W FP0,<ea>
%l3 MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     l3
(SUBQ.B  #2,D0
(BNE     Error
(MOVE.W  fpop,(A3)+
%l4 MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     l4
(SUBQ.B  #2,D0
(BNE     Error
(RTS
%Error
(JSR     FPUError
(CLR.W   (A3)+
 *)
$END
"END getExp;
 (*$L+*)
 
 PROCEDURE ConvFloat(    v      : LONGREAL;
8spc, n : CARDINAL;
4VAR str    : ARRAY OF CHAR);
 
"VAR
"
$len, numLen :       CARDINAL;
$numStr      :       ARRAY [0..19] OF CHAR;
$epos, mpos  :       BOOLEAN;
$expon       :       INTEGER;
$kfact,
$cptr, i     :       CARDINAL;
$over,
$fatal       :       BOOLEAN;
$
"BEGIN
$fatal := FALSE;
$over := FALSE;
$len := HIGH(str) + 1;
$IF spc > len THEN
&over := TRUE;
&spc := len
$END;
$IF n < 17 THEN
&kfact := INTEGER(n) + 1
$ELSE
&kfact := 17
$END;
$cFloat(v, mpos, epos, kfact, numStr, expon);
$numLen := 7 + n ;                              (* x.E+xxx + <n> *)
$IF ~mpos THEN
&INC(numLen)
$END;
$IF spc < numLen THEN
&IF numLen > len THEN
(over := TRUE;
(fatal := TRUE
&ELSE
(cptr := 0
&END
$ELSE
&cptr := spc - numLen
$END;
$IF ~fatal THEN
&IF cptr > 0 THEN
(FOR i := 0 TO cptr - 1 DO
*str[i] := ' '
(END
&END;
&IF ~mpos THEN
(str[cptr] := '-';
(INC(cptr)
&END;
&str[cptr] := numStr[0];
&INC(cptr);
&str[cptr] := '.';
&INC(cptr);
&FOR i := 1 TO n DO
(IF i < 17 THEN
*str[cptr] := numStr[i]
(ELSE
*str[cptr] := '0'
(END;
(INC(cptr)
&END;
&str[cptr] := 'E';
&INC(cptr);
&IF epos THEN
(str[cptr] := '+'
&ELSE
(str[cptr] := '-'
&END;
&INC(cptr);
&FOR i := 17 TO 19 DO
(str[cptr] := numStr[i];
(INC(cptr)
&END;
&IF cptr < len THEN
(str[cptr] := 0C
&END
$ELSE (* IF ~fatal *)
&FOR i := 0 TO len - 1 DO
(str[i] := '?'
&END
$END;
$IF over THEN
&ASSEMBLER
2TRAP            #6
2DC.W            -8-$4000
&END
$END
"END ConvFloat;
"
 
 PROCEDURE ConvEng(    v      : LONGREAL;
6spc, n : CARDINAL;
2VAR str    : ARRAY OF CHAR);
 
"VAR
"
$len,
$numLen,
$deccnt      :       CARDINAL;
$numStr      :       ARRAY [0..19] OF CHAR;
$istr        :       ARRAY [1..3] OF CHAR;
$normex,
$expon       :       INTEGER;
$epos, mpos  :       BOOLEAN;
$kfact,
$cptr,
$i, vork     :       CARDINAL;
$over,
$fatal       :       BOOLEAN;
 
"BEGIN
$fatal := FALSE;
$over := FALSE;
$len := HIGH(str) + 1;
$IF spc > len THEN
&over := TRUE;
&spc := len
$END;
$IF ABS (v) = 0R THEN
&vork:= 1;
&normex:= 0
$ELSE
&expon := getExp(v);
&normex := expon;
&IF normex < 0 THEN
(normex := normex - 2
&END;
&normex := (normex DIV 3) * 3;
&vork := expon - normex + 1;
$END;
$IF (vork + n) < 17 THEN
&kfact := vork + n
$ELSE
&kfact := 17
$END;
$cFloat(v, mpos, epos, kfact, numStr, expon);
$numLen := 7 + vork + n ;                        (* x..x. + <n> + E+xxxx *)
$IF ~mpos THEN
&INC(numLen)
$END;
$IF spc < numLen THEN
&IF numLen > len THEN
(over := TRUE;
(fatal := TRUE
&ELSE
(cptr := 0
&END
$ELSE
&cptr := spc - numLen
$END;
$IF ~fatal THEN
&IF cptr > 0 THEN
(FOR i := 0 TO cptr - 1 DO
*str[i] := ' '
(END
&END;
&IF ~mpos THEN
(str[cptr] := '-';
(INC(cptr)
&END;
&deccnt := 0;
&FOR i := vork TO 1 BY -1 DO
(str[cptr] := numStr[deccnt];
(INC(cptr);
(INC(deccnt)
&END;
&str[cptr] := '.';
&INC(cptr);
&FOR i := 1 TO n DO
(IF deccnt < 17 THEN
*str[cptr] := numStr[deccnt]
(ELSE
*str[cptr] := '0'
(END;
(INC(cptr);
(INC(deccnt)
&END;
&str[cptr] := 'E';
&INC(cptr);
&IF normex < 0 THEN
(str[cptr] := '-';
(normex := -normex
&ELSE
(str[cptr] := '+'
&END;
&INC(cptr);
&str[cptr] := '0';
&INC(cptr);
&ConvInt(normex, 3, istr);
&FOR i := 1 TO 3 DO
(IF istr[i] = ' ' THEN
*str[cptr] := '0'
(ELSE
*str[cptr] := istr[i]
(END;
(INC(cptr)
&END;
&IF cptr < len THEN
(str[cptr] := 0C
&END
$ELSE (* IF ~fatal *)
&FOR i := 0 TO len - 1 DO
(str[i] := '?'
&END
$END;
$IF over THEN
&ASSEMBLER
2TRAP            #6
2DC.W            -8-$4000
&END
$END
"END ConvEng;
"
 
 PROCEDURE ConvFix(    v      : LONGREAL;
6spc, n : CARDINAL;
2VAR str    : ARRAY OF CHAR);
 
"VAR
"
$len,
$numLen      :       CARDINAL;
$numStr      :       ARRAY [0..19] OF CHAR;
$kfact,
$deccnt,
$expon       :       INTEGER;
$epos, mpos  :       BOOLEAN;
$cptr,
$i, vork     :       CARDINAL;
$over,
$fatal       :       BOOLEAN;
 
"BEGIN
$fatal := FALSE;
$over := FALSE;
$len := HIGH(str) + 1;
$IF spc > len THEN
&over := TRUE;
&spc := len
$END;
$IF ABS (v) = 0R THEN
&kfact := n + 1;
$ELSE
&expon := getExp(v);
&kfact := expon + INTEGER(n) + 1;
$END;
$IF kfact > 17 THEN
&kfact := 17
$END;
$IF kfact > 0 THEN
&cFloat(v, mpos, epos, kfact, numStr, expon)
$END;
$IF expon < 0 THEN
&vork := 1
$ELSE
&vork := 1 + expon
$END;
$numLen := 1 + vork + n ;                               (* x..x. + <n> *)
$IF ~mpos THEN
&INC(numLen)
$END;
$IF spc < numLen THEN
&IF numLen > len THEN
(over := TRUE;
(fatal := TRUE
&ELSE
(cptr := 0
&END
$ELSE
&cptr := spc - numLen
$END;
$IF ~fatal THEN
&IF cptr > 0 THEN
(FOR i := 0 TO cptr-1 DO
*str[i] := ' '
(END
&END;
&IF ~mpos THEN
(str[cptr] := '-';
(INC(cptr)
&END;
&IF expon < 0 THEN
(deccnt := expon
&ELSE
(deccnt := 0
&END;
&FOR i := vork TO 1 BY -1 DO
(IF ~(deccnt < 0) AND (deccnt < 17) THEN
*str[cptr] := numStr[deccnt]
(ELSE
*str[cptr] := '0'
(END;
(INC(cptr);
(INC(deccnt)
&END;
&str[cptr] := '.';
&INC(cptr);
&FOR i := 1 TO n DO
(IF ~(deccnt < 0) AND (deccnt < 17) THEN
*str[cptr] := numStr[deccnt]
(ELSE
*str[cptr] := '0'
(END;
(INC(cptr);
(INC(deccnt)
&END;
&IF cptr < len THEN
(str[cptr] := 0C
&END
$ELSE (* IF ~fatal *)
&FOR i := 0 TO len - 1 DO
(str[i] := '?'
&END
$END;
$IF over THEN
&ASSEMBLER
2TRAP            #6
2DC.W            -8-$4000
&END
$END
"END ConvFix;
 
 (* noch eingeklammert, knnte aber mal bernommen werden!
 
((****************************************************************************)
((*                                                                          *)
((*                      C O N V E R T    -   6 8 0 2 0                      *)
((*                                                                          *)
((* Errorchecks eingebaut, mehere kleine Fehler beseitigt, zum Teil          *)
((* neu programmiert.                                                  (GS)  *)
((*                                                                          *)
((****************************************************************************)
(
0
((*$L-*)
(PROCEDURE getExp(r : REAL) : INTEGER;
9
*BEGIN
,ASSEMBLER
8FABS.D          -(A3),FP0      ; kein Runtime-Error mglich
8FLOG10.X        FP0
8FMOVE.W         FP0,(A3)+
,END
*END getExp;
((*$L+*)
9
9
(PROCEDURE cFloat(    r          : REAL;             (* stark gendert GS *)
9VAR mpos, epos : BOOLEAN;
=kfaktor    : CARDINAL;
9VAR decstr     : ARRAY OF CHAR;
9VAR exponent   : INTEGER       );
(
*(* decstr hat folgenden Aufbau :                                          *)
*(*   Der String ist 20 Zeichen lang, linksbndig die Mantisse mit kfaktor *)
*(*   signifikanten Stellen, rechtsbndig der dreistellige Exponent        *)
*
*VAR
*
,BCDst       : ARRAY[0..2] OF LONGINT;
(
*BEGIN
,ASSEMBLER
8MOVE            kfaktor(A6),D0
8FMOVE.D         r(A6),FP0
8LEA             BCDst(A6),A0
8FMOVE.P         FP0,(A0){D0}
8MOVEA.L         mpos(A6),A2
8CLR             (A2)
8BTST.B          #7,(A0)       ; sign of mantissa
8BNE             m_neg
8MOVE            #1,(A2)
.
.!m_neg    MOVEA.L         epos(A6),A2
8CLR             (A2)
8BTST.B          #6,(A0)       ; sign of exponent
8BNE             e_neg
8MOVE            #1,(A2)
.
.!e_neg    MOVEA.L         decstr(A6),A1
8ADDA.W          D0,A1         ; A1 after last digit
8ADDQ            #4,A0      ; A0 points after first mantissa dig.
8MOVE            D0,D1
8LSR             #1,D1
8ADDA.W          D1,A0      ; A0 points after last mantissa digit
8SUBQ            #1,D0
8BTST            #0,D0
8BEQ             cont1
8
8MOVE.B          -(A0),D1
8LSR             #4,D1
8ADD.B           #'0',D1
8MOVE.B          D1,-(A1)
8
.!cont1    MOVE            D0,D1
8LSR             #1,D1
8BRA             entry
8
.!unploop  UNPK            -(A0),-(A1),#$3030
.!entry    DBRA            D1,unploop
8
8MOVE.B          -(A0),D1
8ANDI            #$0F,D1
8ADD.B           #'0',D1
8MOVE.B          D1,-(A1)
8
.!done     MOVEA.L         decstr(A6),A1
8LEA             20(A1),A1
8LEA             BCDst(A6),A0
8ADDQ            #2,A0
8UNPK            -(A0),-(A1),#$3030
8
8MOVE.B          -(A0),D1
8ANDI            #$0F,D1
8ADD.B           #'0',D1
8MOVE.B          D1,-(A1)
-
8MOVEA.L         decstr(A6),A1
8LEA             17(A1),A1
8
8MOVEQ           #0,D0
8MOVEQ           #0,D1
8MOVEQ           #2,D2
8
0!Loop   MOVE.B          (A1)+,D0
8SUB.B           #'0',D0
8MULU            #10,D1
8ADD             D0,D1
8DBRA            D2,Loop
8
8TST             (A2)
8BNE             e_pos2
8NEG             D1
/!e_pos2  MOVEA.L         exponent(A6),A0
8MOVE            D1,(A0)
-END;
+END cFloat;
0
*
(PROCEDURE ConvToReal(    get   : GetProc;
=VAR info  : GetInfo;
=VAR valid : BOOLEAN ) : REAL;
(
*VAR
*
,mneg, eneg,
,isdigit     :       BOOLEAN;
,i           :       CARDINAL;
,exp         :       INTEGER;
,c           :       CHAR;
,x           :       REAL;
,
,
*BEGIN
,ASSEMBLER
8MOVE.L          D3,-(A7)
8BRA             start
8
.!getchr   MOVE.L          A0,-(A7)
8MOVE.L          info(A6),(A3)+
8MOVE.L          get(A6),A0
8JSR             (A0)
8MOVE.L          (A7)+,A0
8MOVE.L          info(A6),A1
8MOVEQ           #0,D0
8MOVE.B          GetInfo.ch(A1),D0
8MOVE.B          D0,c(A6)
8SUBI.B          #'0',D0
8CMPI.B          #9,D0
8SLS             D2
8MOVE.B          D2,isdigit(A6)
8RTS
8
.!mulx10                                         (* x in FP0 *)
8FMUL.W          #10,FP0
8MOVEQ           #0,D0
8MOVE.B          c(A6),D0
8SUBI.B          #'0',D0
8FADD.W          D0,FP0
8RTS
8
.!start    MOVE.L          valid(A6),A1
8CLR             (A1)
.!skipspc  BSR             getchr
8CMPI.B          #' ',c(A6)
8BEQ             skipspc
8CMPI.B          #9,c(A6)                 ; TAB
8BEQ             skipspc
8
8CMPI.B          #'-',c(A6)
8SEQ             mneg(A6)
8BNE             numneg
8BSR             getchr
.!numneg   CMPI.B          #'+',c(A6)
8BNE             numpos
8BSR             getchr
.
.!numpos   FMOVE.W         #0,FP0
8
8CLR             exp(A6)
.!mant1    TST.B           isdigit(A6)
8BEQ             point
8MOVE.L          valid(A6),A1
8MOVE            #1,(A1)
8BSR             mulx10
8BSR             getchr
8BRA             mant1
.!point    MOVE.B          c(A6),D0
8CMP.B           RadixChar,D0
8BNE             expon
8BSR             getchr
.!mant2    TST.B           isdigit(A6)
8BEQ             expon
8MOVE.L          valid(A6),A1
8MOVE            #1,(A1)
8BSR             mulx10
8SUBQ            #1,exp(A6)
.!dont1    BSR             getchr
8BRA             mant2
.!expon    CMPI.B          #'E',c(A6)
8BEQ             expon0
8CMPI.B          #'e',c(A6)
8BNE             return
.!expon0   BSR             getchr
8CLR             eneg(A6)
8CMPI.B          #'-',c(A6)
8SEQ             eneg(A6)
8BNE             noeneg
8BSR             getchr
.!noeneg   CMPI.B          #'+',c(A6)
8BNE             noepos
8BSR             getchr
.!noepos   CLR             D3
.!expon1   TST.B           isdigit(A6)
8BEQ             expon2
8MULU            #10,D3
8MOVE.B          c(A6),D1
8ANDI            #$F,D1
8ADD             D1,D3
8BSR             getchr
8BRA             expon1
.
.!expon2   TST.B           eneg(A6)
8BEQ             expon3
8NEG             D3
.!expon3   ADD             exp(A6),D3
8MOVE            D3,D0
8BPL             testex
8NEG             D0
.!testex   CMPI            #307,D0
8BLE             expon4
8MOVE.L          valid(A6),A1
8CLR             (A1)
8
.!expon4   MOVE            D3,exp(A6)
.!return   TST.B           mneg(A6)
8BEQ             return1
8FTST.X          FP0
8FBEQ            return1
8FNEG.X          FP0
.!return1  MOVE.L          (A7)+,D3
8FTENTOX.W       exp(A6),FP1
8FMUL.X          FP1,FP0
8FMOVE.D         FP0,x(A6)
8FMOVE.L         FPSR,D0
8AND.B           #$40,D0
8BEQ             ok
8MOVE.L          valid(A6),A1
8CLR             (A1)
8FMOVE.L         #$00,FPSR
.!ok                           ; ubu 31.5.88
L; GS 7.9.88
,END;
,RETURN x
*END ConvToReal;
(
(
(PROCEDURE ConvFloat(    v      : REAL;
@spc, n : CARDINAL;
<VAR str    : ARRAY OF CHAR);
(
*VAR
*
,len, numLen :       CARDINAL;
,numStr      :       ARRAY [0..19] OF CHAR;
,epos, mpos  :       BOOLEAN;
,expon       :       INTEGER;
,kfact,
,cptr, i     :       CARDINAL;
,over,
,fatal       :       BOOLEAN;
,
*BEGIN
,fatal := FALSE;
,over := FALSE;
,len := HIGH(str) + 1;
,IF spc > len THEN
.over := TRUE;
.spc := len
,END;
,IF n < 17 THEN
.kfact := INTEGER(n) + 1
,ELSE
.kfact := 17
,END;
,cFloat(v, mpos, epos, kfact, numStr, expon);
,numLen := 7 + n ;                              (* x.E+xxx + <n> *)
,IF ~mpos THEN
.INC(numLen)
,END;
,IF spc < numLen THEN
.IF numLen > len THEN
0over := TRUE;
0fatal := TRUE
.ELSE
0cptr := 0
.END
,ELSE
.cptr := spc - numLen
,END;
,IF ~fatal THEN
.IF cptr > 0 THEN
0FOR i := 0 TO cptr - 1 DO
2str[i] := ' '
0END
.END;
.IF ~mpos THEN
0str[cptr] := '-';
0INC(cptr)
.END;
.str[cptr] := numStr[0];
.INC(cptr);
.str[cptr] := '.';
.INC(cptr);
.FOR i := 1 TO n DO
0IF i < 17 THEN
2str[cptr] := numStr[i]
0ELSE
2str[cptr] := '0'
0END;
0INC(cptr)
.END;
.str[cptr] := 'E';
.INC(cptr);
.IF epos THEN
0str[cptr] := '+'
.ELSE
0str[cptr] := '-'
.END;
.INC(cptr);
.FOR i := 17 TO 19 DO
0str[cptr] := numStr[i];
0INC(cptr)
.END;
.IF cptr < len THEN
0str[cptr] := 0C
.END
,ELSE (* IF ~fatal *)
.FOR i := 0 TO len - 1 DO
0str[i] := '?'
.END
,END;
,IF over THEN
.ASSEMBLER
:TRAP            #6
:DC.W            -8-$4000
.END
,END
*END ConvFloat;
*
(
(PROCEDURE ConvEng(    v      : REAL;
>spc, n : CARDINAL;
:VAR str    : ARRAY OF CHAR);
(
*VAR
*
,len,
,numLen,
,deccnt      :       CARDINAL;
,numStr      :       ARRAY [0..19] OF CHAR;
,istr        :       ARRAY [1..3] OF CHAR;
,normex,
,expon       :       INTEGER;
,epos, mpos  :       BOOLEAN;
,kfact,
,cptr,
,i, vork     :       CARDINAL;
,over,
,fatal       :       BOOLEAN;
(
*BEGIN
,fatal := FALSE;
,over := FALSE;
,len := HIGH(str) + 1;
,IF spc > len THEN
.over := TRUE;
.spc := len
,END;
,expon := getExp(v);
,normex := expon;
,IF normex < 0 THEN
.normex := normex - 2
,END;
,normex := (normex DIV 3) * 3;
,vork := expon - normex + 1;
,IF (vork + n) < 17 THEN
.kfact := vork + n
,ELSE
.kfact := 17
,END;
,cFloat(v, mpos, epos, kfact, numStr, expon);
,numLen := 7 + vork + n ;                        (* x..x. + <n> + E+xxxx *)
,IF ~mpos THEN
.INC(numLen)
,END;
,IF spc < numLen THEN
.IF numLen > len THEN
0over := TRUE;
0fatal := TRUE
.ELSE
0cptr := 0
.END
,ELSE
.cptr := spc - numLen
,END;
,IF ~fatal THEN
.IF cptr > 0 THEN
0FOR i := 0 TO cptr - 1 DO
2str[i] := ' '
0END
.END;
.IF ~mpos THEN
0str[cptr] := '-';
0INC(cptr)
.END;
.deccnt := 0;
.FOR i := vork TO 1 BY -1 DO
0str[cptr] := numStr[deccnt];
0INC(cptr);
0INC(deccnt)
.END;
.str[cptr] := '.';
.INC(cptr);
.FOR i := 1 TO n DO
0IF deccnt < 17 THEN
2str[cptr] := numStr[deccnt]
0ELSE
2str[cptr] := '0'
0END;
0INC(cptr);
0INC(deccnt)
.END;
.str[cptr] := 'E';
.INC(cptr);
.IF normex < 0 THEN
0str[cptr] := '-';
0normex := -normex
.ELSE
0str[cptr] := '+'
.END;
.INC(cptr);
.str[cptr] := '0';
.INC(cptr);
.ConvInt(normex, 3, istr);
.FOR i := 1 TO 3 DO
0IF istr[i] = ' ' THEN
2str[cptr] := '0'
0ELSE
2str[cptr] := istr[i]
0END;
0INC(cptr)
.END;
.IF cptr < len THEN
0str[cptr] := 0C
.END
,ELSE (* IF ~fatal *)
.FOR i := 0 TO len - 1 DO
0str[i] := '?'
.END
,END;
,IF over THEN
.ASSEMBLER
:TRAP            #6
:DC.W            -8-$4000
.END
,END
*END ConvEng;
*
(
(PROCEDURE ConvFix(    v      : REAL;
>spc, n : CARDINAL;
:VAR str    : ARRAY OF CHAR);
(
*VAR
*
,len,
,numLen      :       CARDINAL;
,numStr      :       ARRAY [0..19] OF CHAR;
,kfact,
,deccnt,
,expon       :       INTEGER;
,epos, mpos  :       BOOLEAN;
,cptr,
,i, vork     :       CARDINAL;
,over,
,fatal       :       BOOLEAN;
(
*BEGIN
,fatal := FALSE;
,over := FALSE;
,len := HIGH(str) + 1;
,IF spc > len THEN
.over := TRUE;
.spc := len
,END;
,expon := getExp(v);
,kfact := expon + INTEGER(n) + 1;
,IF kfact > 17 THEN
.kfact := 17
,END;
,IF kfact > 0 THEN
.cFloat(v, mpos, epos, kfact, numStr, expon)
,END;
,IF expon < 0 THEN
.vork := 1
,ELSE
.vork := 1 + expon
,END;
,numLen := 1 + vork + n ;                               (* x..x. + <n> *)
,IF ~mpos THEN
.INC(numLen)
,END;
,IF spc < numLen THEN
.IF numLen > len THEN
0over := TRUE;
0fatal := TRUE
.ELSE
0cptr := 0
.END
,ELSE
.cptr := spc - numLen
,END;
,IF ~fatal THEN
.IF cptr > 0 THEN
0FOR i := 0 TO cptr-1 DO
2str[i] := ' '
0END
.END;
.IF ~mpos THEN
0str[cptr] := '-';
0INC(cptr)
.END;
.IF expon < 0 THEN
0deccnt := expon
.ELSE
0deccnt := 0
.END;
.FOR i := vork TO 1 BY -1 DO
0IF ~(deccnt < 0) AND (deccnt < 17) THEN
2str[cptr] := numStr[deccnt]
0ELSE
2str[cptr] := '0'
0END;
0INC(cptr);
0INC(deccnt)
.END;
.str[cptr] := '.';
.INC(cptr);
.FOR i := 1 TO n DO
0IF ~(deccnt < 0) AND (deccnt < 17) THEN
2str[cptr] := numStr[deccnt]
0ELSE
2str[cptr] := '0'
0END;
0INC(cptr);
0INC(deccnt)
.END;
.IF cptr < len THEN
0str[cptr] := 0C
.END
,ELSE (* IF ~fatal *)
.FOR i := 0 TO len - 1 DO
0str[i] := '?'
.END
,END;
,IF over THEN
.ASSEMBLER
:TRAP            #6
:DC.W            -8-$4000
.END
,END
*END ConvFix;
0
0
 (*****************************************************************************)
 (*                                                                           *)
 (*                                   E N D E (von GS)                        *)
 (*                                                                           *)
 (*****************************************************************************)
 *)
 
 (*  <-- 68020 *) *)
 
 (*$L-*)
 PROCEDURE ConvReal(x:LONGREAL; space,n:CARDINAL; VAR str: ARRAY OF CHAR);
 BEGIN
"(* Die folgende Wrgerei hat den Zweck, da das Scanning bei einem
#* 'string overflow'-Fehler den Aufrufer dieser Funktion erreicht.  *)
"ASSEMBLER
(MOVE.L  A6,-(A7)
 (*$? CompilerVersion > 3:
(LEA     (A3),A6
 *)
 (*$? CompilerVersion <= 3:
(LEA     -18(A3),A6
 *)
"END;
"IF (ABS(x)=0R) OR (FixToFloatMin<=ABS(X)) & (ABS(X)<=FixToFloatMax) THEN
$ASSEMBLER
(MOVE.L  (A7)+,A6
(JMP     ConvFix
$END
"ELSE
$ASSEMBLER
(MOVE.L  (A7)+,A6
(JMP     ConvFloat
$END
"END
 END ConvReal;
 
 END Convert.
  
(* $00003F7D$0000A3BE$00007F84$00008C8B$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$000096D2$FFF317C4$0000EB26$FFF317C4$00009F3E$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$FFF317C4$000009A5T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$0000A0EA$0000A150$000009BB$00000991$00009662$000096E2$00000984$000009B8$000009AB$000096DF$000009A5$0000963E$000096BF$00009EE9$0000A014$0000A06D*)
