 IMPLEMENTATION MODULE Block;
 (*$Y+*)
 
 (*$L-,N+*)
 
 (*
!*  Autor: Wolfgang Keller   (W.K)        Copyright (C) 1989
!*         Dieter   Hametner (D.H)
!*
!*  Erstellt: 23.08.89                  System: MEGAMAX Modula-2 V1.1
!*
!*  --------------------------------------------------------------------------
!*  Datum     Version   Autor   Arbeitsbericht
!*  --------------------------------------------------------------------------
!*  23.08.89 |  0001  |  W.K  | neues universelles ByteCopy implementiert.
!*              0005  |  W.K  | Clear implementiert.
!*                            | Ganzes Modul fertig ausgetestet.
!*              0007  |  T.T  | Clear: End-Lschen optimiert.
!*  30.08.89 |  0007  |  T.T  | Clear allg. korrigiert; Copy optimiert;
!*                              D3 wird nicht mehr zerstrt
!*
!*  --------------------------------------------------------------------------
!*  Interne Modulversion V#0007#
!*  --------------------------------------------------------------------------
!*)
 
 FROM SYSTEM IMPORT ASSEMBLER, ADDRESS;
 
 
 PROCEDURE Copy (from: ADDRESS; n: LONGCARD; to: ADDRESS);
"(*
#*  Kopiert 'n' Byte vom Adresse 'from' nach Adresse 'to' und
#*  bercksichtigt dabei berschneidungen.
#*)
#
"BEGIN
$ASSEMBLER
)MOVE.L  -(A3),A1       ; A1 := to
)MOVE.L  -(A3),D0       ; D0 := n
)MOVE.L  -(A3),A0       ; A0 := from
 
)MOVE.L  A1,D2
)SUB.L   A0,D2
)BLT.L   normcopy
)CMP.L   D0,D2
)BLT.L   revcopy
 
 normcopy
)MOVE.L  A0,D1          ; D1 := ODD( from )
)AND.B   #1,D1          ;
)BNE     fromIsOdd
 
)MOVE.L  A1,D1          ; D1 := ODD( to )
)AND.B   #1,D1          ;
)BNE.L   calcbytecopy
)BRA     calcmulticopy
 
 fromIsOdd
)MOVE.L  A1,D1          ; D1 := ODD( to )
)AND.B   #1,D1          ;
)BNE     moveOneByte
)BRA.L   calcbytecopy
 
 moveOneByte
)SUBQ.L  #1,D0
)BCS.W   ende
)MOVE.B  (A0)+,(A1)+
 
 calcmulticopy
)MOVE.L  D0,D2          ; D2 := n
 
)AND.W   #$FF,D0        ; D0 := n MOD 256
 
@; D2 korrekt berechnet fr multicopy
@; D0 restbytes
 
)MOVE.W  D0,D1
)AND.W   #7,D1          ; D1 := n MOD 8   (Parameter fr restcopy)
)LSR.W   #3,D0          ; D0 := n DIV 8   (Parameter fr longcopy)
 
)LSR.L   #8,D2          ; D2 := n DIV 256
 
)BEQ.L   longcopy       ; Fall D2 = 0 gleich nach longcopy
 multicopy
)MOVEM.L D0-D1/D3-D7/A2-A6,-(A7)
)SWAP    D2
)MOVE.L  D2,-(A7)
)SWAP    D2
)BRA     startmulti
 
 multiloop1
)MOVE.L  D2,(A7)
)SWAP    D2
 multiloop2
)MOVE.W  D2,(A7)
); 256 Byte kopieren
)MOVEM.L (A0)+,D0-D7/A2-A6     ; LOAD
)MOVEM.L D0-D7/A2-A6,(A1)      ; STORE
)ADDA.W  #52,A1
)MOVEM.L (A0)+,D0-D7/A2-A6     ; LOAD
)MOVEM.L D0-D7/A2-A6,(A1)      ; STORE
)ADDA.W  #52,A1
)MOVEM.L (A0)+,D0-D7/A2-A6     ; LOAD
)MOVEM.L D0-D7/A2-A6,(A1)      ; STORE
)ADDA.W  #52,A1
)MOVEM.L (A0)+,D0-D7/A2-A6     ; LOAD
)MOVEM.L D0-D7/A2-A6,(A1)      ; STORE
)ADDA.W  #52,A1
)MOVEM.L (A0)+,D1-D7/A2-A6     ; LOAD
)MOVEM.L D1-D7/A2-A6,(A1)      ; STORE
)ADDA.W  #48,A1
)MOVE.W  (A7),D2
 startmulti
)DBF     D2,multiloop2
)SWAP    D2
)MOVE.W  2(A7),D2
)DBF     D2,multiloop1
 
)ADDQ.L  #4,A7
)MOVEM.L (A7)+,D0-D1/D3-D7/A2-A6
)BRA.L   longcopy
 
 longloop
)MOVE.L  (A0)+,(A1)+    ; copy Longwords
)MOVE.L  (A0)+,(A1)+    ; copy Longwords
 longcopy DBF     D0,longloop
 
)BRA     restcopy
 
 calcbytecopy
)MOVE.W  D0,D1          ; D1 := n
)AND.W   #7,D1          ; D1 := n MOD 8
)LSR.L   #3,D0          ; D0 := n DIV 8
)BRA     bytecopy
 byteloop1
)SWAP    D0
 byteloop2
)MOVE.B  (A0)+,(A1)+
)MOVE.B  (A0)+,(A1)+
)MOVE.B  (A0)+,(A1)+
)MOVE.B  (A0)+,(A1)+
)MOVE.B  (A0)+,(A1)+
)MOVE.B  (A0)+,(A1)+
)MOVE.B  (A0)+,(A1)+
)MOVE.B  (A0)+,(A1)+
 bytecopy DBF     D0,byteloop2
)SWAP    D0
)DBF     D0,byteloop1
 
)BRA     restcopy
 restloop MOVE.B  (A0)+,(A1)+
 restcopy DBF     D1,restloop
 ende     RTS                    ; ende von bytecopy
 
 revcopy
)ADDA.L   D0,A1         ; to := to + n
)ADDA.L   D0,A0         ; from := from + n;
 
)MOVE.L  A0,D1          ; D1 := ODD( from )
)AND.B   #1,D1          ;
)BNE     rfromIsOdd
 
)MOVE.L  A1,D1          ; D1 := ODD( to )
)AND.B   #1,D1          ;
)BNE.L   rcalcbytecopy
)BRA     rcalcmulticopy
 
 rfromIsOdd
)MOVE.L  A1,D1          ; D1 := ODD( to )
)AND.B   #1,D1          ;
)BNE     rmoveOneByte
)BRA.L   rcalcbytecopy
 
 rmoveOneByte
)SUBQ.L  #1,D0
)BCS     ende
)MOVE.B  -(A0),-(A1)
 
 rcalcmulticopy
)MOVE.L  D0,D2          ; D2 := n
 
)AND.W   #$FF,D0        ; D0 := n MOD 256
 
@; D2 korrekt berechnet fr multicopy
@; D0 restbytes
 
)MOVE.W  D0,D1
)AND.W   #7,D1          ; D1 := n MOD 8   (Parameter fr restcopy)
)LSR.W   #3,D0          ; D0 := n DIV 8   (Parameter fr longcopy)
 
)LSR.L   #8,D2          ; D2 := n DIV 256
 
)BEQ.L   rlongcopy       ; Fall D2 = 0 gleich nach longcopy
 rmulticopy
)MOVEM.L D0-D1/D3-D7/A2-A6,-(A7)
)SWAP    D2
)MOVE.L  D2,-(A7)
)SWAP    D2
)BRA     rstartmulti
)
 rmultiloop1
)MOVE.L  D2,(A7)
)SWAP    D2
 rmultiloop2
)MOVE.W  D2,(A7)
); 256 Byte kopieren
)SUBA.W  #52,A0
)MOVEM.L (A0),D0-D7/A2-A6       ; LOAD
)MOVEM.L D0-D7/A2-A6,-(A1)      ; STORE
)SUBA.W  #52,A0
)MOVEM.L (A0),D0-D7/A2-A6       ; LOAD
)MOVEM.L D0-D7/A2-A6,-(A1)      ; STORE
)SUBA.W  #52,A0
)MOVEM.L (A0),D0-D7/A2-A6       ; LOAD
)MOVEM.L D0-D7/A2-A6,-(A1)      ; STORE
)SUBA.W  #52,A0
)MOVEM.L (A0),D0-D7/A2-A6       ; LOAD
)MOVEM.L D0-D7/A2-A6,-(A1)      ; STORE
)SUBA.W  #48,A0
)MOVEM.L (A0),D1-D7/A2-A6       ; LOAD
)MOVEM.L D1-D7/A2-A6,-(A1)      ; STORE
)MOVE.W  (A7),D2
 rstartmulti
)DBF     D2,rmultiloop2
)SWAP    D2
)MOVE.W  2(A7),D2
)DBF     D2,rmultiloop1
 
)ADDQ.L  #4,A7
)MOVEM.L (A7)+,D0-D1/D3-D7/A2-A6
)BRA.L   rlongcopy
 rlongloop
)MOVE.L  -(A0),-(A1)    ; copy Longwords
)MOVE.L  -(A0),-(A1)    ; copy Longwords
 rlongcopy DBF     D0,rlongloop
 
)BRA     rrestcopy
 
 rcalcbytecopy
)MOVE.W  D0,D1          ; D1 := n
)AND.W   #7,D1          ; D1 := n MOD 8
)LSR.L   #3,D0          ; D0 := n DIV 8
)BRA     rbytecopy
 rbyteloop1
)SWAP    D0
 rbyteloop2
)MOVE.B  -(A0),-(A1)
)MOVE.B  -(A0),-(A1)
)MOVE.B  -(A0),-(A1)
)MOVE.B  -(A0),-(A1)
)MOVE.B  -(A0),-(A1)
)MOVE.B  -(A0),-(A1)
)MOVE.B  -(A0),-(A1)
)MOVE.B  -(A0),-(A1)
 rbytecopy DBF     D0,rbyteloop2
)SWAP    D0
)DBF     D0,rbyteloop1
)
)BRA     rrestcopy
 rrestloop
)MOVE.B  -(A0),-(A1)
 rrestcopy DBF     D1,rrestloop
 
$END;
"END Copy;
 
 
 PROCEDURE Clear (from: ADDRESS; n: LONGCARD);
"(*
#*  Lscht ab 'from' 'n' Byte.
#*)
"
"BEGIN
$ASSEMBLER
)MOVE.L  -(A3),D0       ; D0 := n
)MOVE.L  -(A3),A0       ; A0 := from
)BEQ     ende
)ADDA.L  D0,A0          ; A0 := from + n
 
)MOVEQ.L #0,D2
 
)MOVE.L  A0,D1          ; D1 := ODD( from )
)AND.B   #1,D1          ;
)BEQ     calcmulticlear
 
 fromIsOdd
)MOVE.B  D2,-(A0)       ; Clear one byte
)SUBQ.L  #1,D0          ; jetzt ist A0 gerade !
)BRA     calcmulticlear
 
 ende     RTS
 
 calcmulticlear
)MOVE.L  D0,D1          ; D1 := n
 
)AND.W   #$FF,D0        ; D0 := n MOD 256
@; in D0 sind also die restbytes
)LSR.L   #8,D1          ; D1 := n DIV 256
 
)BEQ.L   calclongclear      ; Fall D1 = 0 gleich nach calclongclear
 
 multiclear
)MOVEM.L D0/D3-D7/A3-A6,-(A7)
)MOVE.L  D2,D0
)MOVE.L  D2,D3
)MOVE.L  D2,D4
)MOVE.L  D2,D5
)MOVE.L  D2,D6
)MOVE.L  D2,D7
)MOVE.L  D2,A1
)MOVE.L  D2,A2
)MOVE.L  D2,A3
)MOVE.L  D2,A4
)MOVE.L  D2,A5
)MOVE.L  D2,A6
)BRA     startmulti
 
 multiloop1
)SWAP    D1
 multiloop2
); clear 256 Byte
)MOVEM.L D0/D2-D7/A1-A6,-(A0)   ; 52
)MOVEM.L D0/D2-D7/A1-A6,-(A0)   ; 52
)MOVEM.L D0/D2-D7/A1-A6,-(A0)   ; 52
)MOVEM.L D0/D2-D7/A1-A6,-(A0)   ; 52
)MOVEM.L D2-D7/A1-A6,-(A0)      ; 48
 startmulti
)DBF     D1,multiloop2
)SWAP    D1
)DBF     D1,multiloop1
 
)MOVEM.L (A7)+,D0/D3-D7/A3-A6
 
 calclongclear                   ; Parameter in D0
)MOVE.W  D0,D1          ; D1 := n          die restlichen bytes
)AND.W   #7,D1          ; D1 := n MOD 8   (Parameter fr restclear)
)LSR.W   #3,D0          ; D0 := n DIV 8   (Parameter fr longclear)
)BRA     longclear
 
 longloop
)MOVE.L  D2,-(A0)       ; copy Longwords
)MOVE.L  D2,-(A0)       ; copy Longwords
 longclear
)DBF     D0,longloop
 
)BRA     restclear
 restloop
)MOVE.B  D2,-(A0)
 restclear
)DBF     D1,restloop
$END;
"END Clear;
 
 
 END Block.
 
(* $FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$FFEE3173$000018FET........T.......T......T.......T.......T.......T.......T.......T.......T.......$00002039$00001FD7$00001FCB$000015FA$00000EF3$00000DC4$00001695$0000172D$000017C9$000018FE$00000439$0000002B$FFEDB15C$FFEDB15C$00000034$FFEE3173*)
