 IMPLEMENTATION MODULE TextWindows;
 (*$Y+*)
 
 (*
 IMPORT Terminal;        (*  for debuging only  *)
 *)
 
 
 (*      Implementation des 'TextWindows' Modul der Megamax Modula-2 Library
!*
!*      Written and copyright by Manuel Chakravarty
!*
!*      Version 2.10   V#0891                   Created 24.09.1987
!*)
!
!
 (* 24.09.87     | Definitionen; 'levelCounter', 'Close' und 'Open' impl.
!* 25.09.87     | 'writeSpaceBlock' mit drumherum impl. +
!*                'WriteString' ohne VT-52, dabei auch 'writeStringPart'
!* 27.09.87     | 'WriteString' optimiert
!* 28.09.87     | 'WriteString' optimiert (jetzt Terminal:Windows ~ 1:4)
!*                scrolling + 'Write' impl.
!* 29.09.87     | 'Read' impl. + 'ReadString' vorl. Vers. + Redraw
!* 30.09.87     | Verarbeitung der window events
!* 01.10.87     | Modul  verwendet Sys... und bercksichtigt fremde
!*                'GemHandle's richtig.
!* 02.10.87     | V 0.2: Umdef. von Open-Param.; besserer Redraw
!* 06.10.87     | Neues 'windowText'            ; Anpassung an GEM V 0.9
!*                + VT-52 Emulator (Teile)
!* 07.10.87     | 'SelectChar' impl.
!* 08.10.87     | VT-52 fertiggestellt + 'IsTop' + 'CursorPos'
!* 09.10.87     | Scrolling im Hintergrund funkt. endlich + 'WasClosed'
!* 13.10.87     | 'ReSpecify' impl.
!* 14.10.87     | Enhanced output + 'getCharSize' ber VDI
!* 07.11.87     | Anpassung an GEM V 0.10 + 'WindowHandle' -> 'Window' +
!*                'SelectChar' gibt Zeichenbox mit zurck
!* ??.11.87     | Anpassung an endgltige Definitionen
!*                'SelectChar' -> 'FindChar', usw.
!* 02.12.87     | Redrawgeschwindigkeit erhht
!* 03.12.87     | 'Open' auf endgltige Def gebracht und 'EditString' von
!*                'Terminal' geklaut
!* 07.12.87     | 'ReSpecify' fordert neuen Speicher nur an, falls sich
!*                die Bufferausmae gendert haben. Enhanced-Status abge-
!*                sichert, dazu 'enhcdWind' eingefhrt.
!* 08.12.87     | Check auf Zeilenende wird immer vor der Ausgabe sicht-
!*                barer Zeichen durchgefhrt.
!* 22.12.87     | 'DetectChar' lt jetzt auch 'NoWind' als Element im
!*                open array zu (Ermglicht Fenstercheck ohne das beim
!*                Aufrufer irgendwelche 'Window'-Handle bekannt sind)
!* 27.12.87     | 'takeCareOfForce' auch am Anfang einer Stringausgabe
!* 12.01.88     | 'copyOpaque' impl.
!* 13.01.88     | CTRL-E/F fr 'EnhancedOutput (TRUE/FALSE)'
!*              | Neues 'adjust'
!* 17.01.88     | Falls Fensterausmae bei 'Open' zu klein sind werden
!*                sie auf Min.mae vergert.
!* 21.01.88     | 'WasClosed' bereinigt A3 und 'copyOpaque's hoffentlich
!*                letzten Fehler beseitigt.
!* 24.01.88     | 'nextChar' in ASM und 'forceLine' eingefhrt
!* 26.01.88     | 'copyOpaque' macht vdiCopy bei Farbe.
!* 31.01.88     | Whrend der Behandlung eines Events (watch dog) darf
!*                kein 'ShareTime' gemacht werden => siehe 'eventHandling'
!* 05.04.88     | 'KeyPressed' arbeitet jetzt mit globalem Tastenbuffer fr
!*                ein Zeichen.
!*                'ReadString' schaltet Cursor nicht ein, falls
!*                noch Zeichen im Tastaturpuffer vorliegen.
!*                Bei 'interpretCtrl' werden auch die nicht interpretierbaren
!*                Ctrl-Zeichen nicht angezeigt.
!* 06.04.88     | Beim Schreiben in unsichtbare Fenster wird nun auch im
!*                enhanced mode der Mauscursor nicht mehr versteckt.
!*                Lokales Modul 'Timer'.
!* 07.04.88     | VT-52-Emulation fr ESC-L und ESC-M impl.
!*
!*  02.02.89 MCH 0.04   | Beginn der Umstellung auf 'WindowBase' und der
!*                        Trennung der Bufferschreibenden und -lesenden
!*                        Vorgnge.
!*  15.02.89 MCH 0.04   | Pipes + 'insertIntoWritePipe'.
!*  16.02.89 MCH 0.04   | write proc.s newly + 'escAutomat' impl.
!*  21.02.89 MCH 0.04   | 'flushWritePipe' impl.
!*  22.02.89 MCH 0.04   | 'doWaitingRedraws' + server proc.s impl.
!*  23.02.89 MCH 0.04   | server proc.s weiter
!*  26.02.89 MCH 0.04   | Debugging.
!*  27.02.89 MCH 0.04   | No internal esc sequences.
!*  28.02.89 MCH 0.04   | While redrawing, background is cleared first.
!*                        'insertIntoWritePipe' copys until a 0C is matched.
!*                        'SetPosAndSize', 'SetTop' and 'ReadTextBuffer' impl.
!*  01.03.89 MCH 2.00   | The 'escAutomat' sets the 'status.state' to the
!*                        right value, at the end of 'gotoXY', 'fgCol' and
!*                        'bgCol'.
!*                        THE NEW VERSION IS COMPLETELY IMPLEMENTED.
!*  04.06.89 MCH 2.01   | 'takeCareOfForce' is not applied at hidden wdw.s
!*  27.06.89 MCH 2.02   | Uses 'ResCtrl'
!*  30.07.89 MCH 2.03   | 'doWaitingRedraws' inserted into 'scrollUp/Down',
!*                        Not Tested!
!*  31.07.89 MCH 2.03   | While enhanced mode on, no redraw before scrolling;
!*                        movement of redraw area, while scrolling.
!*  01.08.89 MCH 2.04   | 'takeCareOfForce' uses 'SetWindowSliderPos'
!*  02.08.89 MCH 2.04   | Uses 'SysCreateWindow' and 'FlushEvents';
!*                        'SetTop' -> 'PutOnTop'
!*  11.08.89 MCH 2.05   | Uses 'reverseWrt'; 'maxCharPerRow' raus; 
!*                        'pointToCharPos' arbeitet jetzt auch richtig, wenn
!*                        das 'WindowBase'-Fenster grer als der Puffer ist.
!*  15.08.89 MCH 2.06   | Uses 'WindowBase' V0.12 
!*  16.08.89 MCH 2.06   | Some changes in 'checkSpec'
!*  17.08.89 MCH 2.06   | 'pipeEscStatus' eingefhrt
!*  19.08.89 MCH 2.07   | 'GetGSX' und 'GetKey' def. + impl.
!*  30.08.89 TT  2.08   | ReadLine, EditLine, ReadToken, UndoRead;
!*                        keyBuffer-Verwaltung gendert (neue BOOLEAN-Var);
!*                        Done-Funktion neu (ebenso done-feld in Window-Record)
!*  15.02.90 MCH 2.9    | Anpassung an Compilerversion 4.0 (REFs)
!*  06.04.90 MCH 2.9    | 'DetectChar' liefert jetzt hoffentlich korrekte 'box'
!*  25.11.90 TT         | GrafMouse-Aufruf nun in connectToGem statt in
!*                        levelCounter, weil sont ModLoad nicht funktioniert
!*  17.12.90 TT         | FastGEM0-Import erstmal entfernt, da immer noch
!*                        Fehler bei Bigscreen
!*  15.02.91 TT         | 'scrollDown' (reverse LF) benutzt copyVertWdw statt
!*                        copyHorWdw; 'insert/deleteLine' funktionieren auch in
!*                        1. Zeile (Abfrage auf f.y>0 durch f.y>=0 ersetzt);
!*                        Cursor ist wieder sichtbar (cursorOn: / gg. + ers.).
!*  02.03.91 TT         | Close mit undef. Ptr meldet keinen Laufzeitfehler
!*  08.04.91 TT         | Open: Wenn alle Fenster belegt, liefert success FALSE
!*  15.09.91 MS         | Open: Speicher f. redrawStr wird bei Fehlern wieder
!*                        freigegeben.
!*  21.05.93 TT         | Mittels Respecify kann nun auch der Font bestimmt
!*                        werden; SetPosAndSize rundet nicht mehr ab.
!*  07.06.93 TT         | Auch wenn kein Force-Modus, wird bei Eingaben (Read)
!*                        das Fenster getopped und Cursor sichtbar gescrollt.
!*  14.01.94 TT         | checkSpec korrigiert.
!*)
 
 (*  =============== to do: ====================
!*
!*  =============== docu: =====================
!*
!*)
!
!
 FROM SYSTEM     IMPORT ASSEMBLER, WORD, ADDRESS, BYTE,
7TSIZE, ADR;
 
 (*  MOS  *)
 
 IMPORT StringEditor, MOSConfig;
 
 FROM Calls      IMPORT CallSupervisor;
 
 FROM Storage    IMPORT SysAlloc, DEALLOCATE;
 
 FROM MOSGlobals IMPORT IllegalPointer, GeneralErr, MemArea, Key;
 
 FROM PrgCtrl    IMPORT EnvlpCarrier, TermCarrier,
7SetEnvelope, CatchProcessTerm;
 
 FROM ResCtrl    IMPORT RemovalCarrier,
7CatchRemoval;
 
 FROM Strings    IMPORT Assign, Length, StrEqual, Delete;
 
 (*  GEM  *)
 
 FROM GrafBase           IMPORT Point, Rectangle, MemFormDef, white, black,
?BitOperation, LongPnt, LongRect,
?Pnt, Rect, TransRect, ClipRect, GetBlitterMode,
?GetScreen, MinPoint, MaxPoint, FrameRects,
?WritingMode, LPnt, LRect;
5
 FROM GEMGlobals         IMPORT TextEffect, TEffectSet, GemChar, MButtonSet,
?THorJust, TVertJust,
?SpecialKeySet, MouseButton, FillType;
 
 FROM GEMEnv             IMPORT RC, GemHandle, DeviceHandle, GDOSAvailable,
?SysInitGem, ExitGem, CurrGemHandle, PtrDevParm,
?DeviceParameter, SetCurrGemHandle, GemActive;
 
 FROM AESEvents          IMPORT Event, RectEnterMode;
 
 FROM AESGraphics        IMPORT MouseForm, GrafMouse;
 
 FROM VDIControls        IMPORT LoadFonts, SetClipping, DisableClipping;
 
 FROM VDIAttributes      IMPORT SetTextColor, SetTextEffects, SetFillColor,
?SetFillType, SetFillPerimeter, SetWritingMode,
?SetPtsTHeight, SetAbsTHeight, SetTextFace;
 
 FROM VDIOutputs         IMPORT FillRectangle, GrafText;
 
 FROM VDIInputs          IMPORT HideCursor, ShowCursor;
 
 FROM VDIInquires        IMPORT GetTextStyle, GetFaceName, GetFaceInfo;
 
 IMPORT AESWindows, GEMBase;
 
 (*  Beyond GEM  *)
 
 FROM EventHandler       IMPORT EventProc, WatchDogCarrier,
?SysInstallWatchDog, DeInstallWatchDog,
?HandleEvents, FlushEvents;
 
 IMPORT WindowBase;
 
 FROM VDIRasters  IMPORT CopyOpaque;
 
 CONST   TestVersion     = FALSE; (*  Debugging?  *)
 
 (*$? NOT TestVersion:  (*$R-*)
!*)
 
 
 CONST   windowMagic     = 170469;       (* Woher kommt diese Zahl ??!? *)
(
(bufMax          = MaxCard;
(maxNameLen      = 80;
(
(pipeMax         = 512;  (*  Number of elem.s per pipe  *)
(
(fractionBaseL   = 10000L;
/
(noErrorTrap     = 6;
(
((*  char const.s  *)
(
(null            = 0C;
(ctrlE           = 5C;
(ctrlF           = 6C;
(bell            = 7C;
(bs              = 10C;
(lf              = 12C;
(cr              = 15C;
(ctrlP           = 20C;
(esc             = 33C;
(space           = 40C;
 
 
 TYPE    twoChars        = ARRAY[0..1] OF CHAR;
(fourChars       = ARRAY[0..3] OF CHAR;
 
((*  pipes
)*)
(pipe            = POINTER TO pipeDesc;
(pipeDesc        = RECORD
<data        : ARRAY[1..pipeMax] OF CHAR;
<head,                       (*  write here  *)
<tail        : CARDINAL;     (*  read here  *)
:END;
(
((*  esc automat
)*)
(escState        = (normalEsc, escEsc, gotoXEsc, gotoYEsc, fgEsc, bgEsc);
(escStatusDesc   = RECORD
<state        : escState;
<first        : CHAR;
:END;
(escComand       = (normalCharEsc, nothingEsc, cursUpEsc, cursDownEsc,
;cursLeftEsc, cursRightEsc, clsEsc, homeEsc,
;eraseEOPEsc, reverseLfEsc, clrEOLEsc, insLnEsc,
;delLnEsc, gotoXYEsc, fgColEsc, bgColEsc,
;eraseBegDispEsc, cursOnEsc, cursOffEsc,
;saveCursPosEsc, restoreCursPosEsc, eraseLnEsc,
;eraseBegLnEsc, reverseOnEsc, reverseOffEsc,
;wrapOnEsc, wrapOffEsc, flushEsc, enhanceOffEsc,
;enhanceOnEsc);
(escResultDesc   = RECORD
(
<comand      : escComand;
<
<(*  valid, if 'comand = normalCharEsc'.
=*)
<ch          : CHAR;
<
<(*  valid, if 'comand = gotoXYEsc'.
=*)
<x, y,
<
<(*  valid, if 'comand = fgColEsc'.
=*)
<fgCol,
<
<(*  valid, if 'comand = bgColEsc'.
=*)
<bgCol       : CARDINAL;
<
:END;
(
((*  types for the text buffer.
)*)
(effect          = (inverse);
(effectSet       = SET OF effect;
(bufferElem      = RECORD         (* TSIZE (bufferElem) = 2 !!!!! *)
<effects      : effectSet;
<ch           : CHAR;
:END;
(ptrBufferElem   = POINTER TO bufferElem;
(bufRange        = [0..bufMax];
 
((*  window descriptor.
)*)
(ptrWindow       = POINTER TO window;
(window          = RECORD
<handle       : WindowBase.Window;  (* AES handle *)
<columns, rows: CARDINAL;  (* Textausmae *)
<force        : ForceMode;
<quality      : WQualitySet;
<
<ctrlMode     : CtrlMode;  (* Ctrl-Zeichen drucken?*)
<echoMode     : EchoMode;  (* Echo bei Read's? *)
<wrapAround   : BOOLEAN;   (* Verhalten am Zeilenende*)
<
<bgCol, fgCol : CARDINAL;  (* Hinter-/Vordergrund *)
<fontHdl      : CARDINAL;
<fontSize     : CARDINAL;  (* Gre in Pts *)
<charW, charH : INTEGER; (* Breite und Hhe einer Zeichenzelle *)
<topToBase    : INTEGER; (* Abstand von top- zu baseline *)
<minADE, maxADE: CHAR; (* Kleinstes und grtes Zeichen des Fonts *)
<
<noCursHides  : CARDINAL;  (* number of curs. hides*)
<cursX, cursY : CARDINAL;  (* Cursorposition *)
<cursIndex    : bufRange;  (* Curs.pos. als Index *)
<
<revMode      : BOOLEAN;   (* Reverse mode? *)
<
<closed       : BOOLEAN;
<
<pipeEscStatus,
<escStatus    : escStatusDesc; (*  VT52  *)
<cursXSave,
<cursYSave    : CARDINAL;
<
<done         : BOOLEAN;   (* f. Done-Funktion *)
<
<enhanced     : BOOLEAN;   (* enhanced-mode? *)
<
<writePipe    : pipe;      (* buffers the in-stream*)
<redrawArea   : Rectangle; (* '.w = 0' means none *)
<
<textOrg      : bufRange;  (* Zeichen links oben *)
<buffer       : POINTER TO (* Textbuffer *)
MARRAY bufRange OF bufferElem;
<
<redrawStr    : POINTER TO ARRAY[0..32767] OF CHAR;
<
<magic        : LONGCARD;
<level        : INTEGER;   (* modLevel bei Anmeldung *)
<next         : ptrWindow; (* Listenzeiger *)
:END;
(Window          = ptrWindow;
(
 CONST   noWindPtr       = ptrWindow (NoWind);
(
 
 VAR     windowRoot      : ptrWindow;
(eventHandling   : BOOLEAN;      (*  '= TRUE' ~ Event-Behandlung  *)
(gemHdl          : GemHandle;
(device          : DeviceHandle;
(stdMFDB         : MemFormDef;
(Fonts           : CARDINAL;
(StdFontHdl      : CARDINAL;
(StdFontHeight   : CARDINAL;
(stdCharW, stdCharH: CARDINAL;
(
(voidO           : BOOLEAN;  (* BOOLEAN-Var. zum Param. fllen *)
(voidI           : INTEGER;
(voidC           : CARDINAL;
(
(modLevel        : INTEGER;  (*  0 ~ SysLevel; -1 nach 'removalProc'  *)
(
(globToken       : BOOLEAN;
(globHdl         : Window;
 
 
(
 MODULE Timer;           (*  Lokales Modul, das eine Proc. regelmig aufruft  *)
 
 
 IMPORT ASSEMBLER, ADDRESS, MemArea,
'ADR, CallSupervisor;
 
 EXPORT installTimeProc, careOfTime;
 
 
 VAR     timeProc                : PROC;
(timeGap                 : CARDINAL;
(passedTime              : LONGCARD;
(
(
 PROCEDURE installTimeProc (proc:PROC; gap:CARDINAL);
 
"BEGIN
$timeProc:=proc; timeGap:=gap; passedTime:=0L;
"END installTimeProc;
"
 VAR     readTimeLast    : LONGCARD;
 
 PROCEDURE readTime (adr:ADDRESS);
 
"VAR     _hz_200 [$4BA]  : LONGCARD;
*_timer_ms [$442]: CARDINAL;
"
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #4,A3
(
(MOVE.L  _hz_200,D0
(SUB.L   readTimeLast,D0
(MULU    _timer_ms,D0
(ADD.L   passedTime,D0
(MOVE.L  D0,passedTime
"END;
"END readTime;
"(*$L=*)
 
 PROCEDURE careOfTime;
 
"VAR     stack   : ARRAY[0..511] OF CARDINAL;
*wsp     : MemArea;
"
"BEGIN
$IF timeGap > 0 THEN
&wsp.bottom:=ADR (stack); wsp.length:=SIZE (stack);
&CallSupervisor (readTime, NIL, wsp);
&IF passedTime >= LONG (timeGap) THEN passedTime:=0L; timeProc END;
$END;
"END careOfTime;
 
 
 BEGIN
"timeGap:=0;
"readTimeLast:=0L;
 END Timer;              (*  -- Ende des lokalen Moduls --  *)
 
 
8(*  graphic proc.s  *)
8(*  ==============  *)
 
 (*  grafText -- Gibt String mit Effekten aus.
!*              REF wegen Effizenz (und wegen bergabe von 'MaxCard + 1'
!*              Elementen).
!*)
 
 PROCEDURE grafText (    device : DeviceHandle;
8p      : Point;
4REF str    : ARRAY OF CHAR;
8effects: effectSet);
 
"BEGIN
$IF inverse IN effects THEN SetWritingMode (device, reverseWrt) END;
$
$(*  GrafText (device, p, str);
%*
%*  Damit nicht 'MaxCard + 1' als Stringlnge bergeben wird, mu dies in
%*  Assembler geschrieben werden.
%*)
$ASSEMBLER
$
(;  Berechne: D0 := Length (str)
(;
(MOVE.W  #1, D0
(MOVE.L  str(A6), A0
 loop1
(ADDQ.W  #1, D0
(TST.B   (A0)+
(BNE     loop1
(ANDI.W  #-2, D0         ; gerade Anzahl!
(
(;  call 'GrafText'
(;
(MOVE.L  device(A6), (A3)+
(MOVE.L  p(A6), (A3)+
(MOVE.L  str(A6), (A3)+
(MOVE.W  D0, (A3)+
(JSR     GrafText
$END;
%
$IF inverse IN effects THEN SetWritingMode (device, replaceWrt) END;
"END grafText;
 
 
8(*  misc.  *)
8(*  =====  *)
(
 (*  getCharSize -- Liefert die Breite 'w' und Hhe 'h' einer Zeichenzelle
!*                 und den Abstand von der topline zur baseline 'tb' und
!*                 grtes und kleinstes Zeichen des aktuellen Fonts.
!*)
 
 PROCEDURE getCharSize (VAR w, h, tb: CARDINAL; VAR minADE, maxADE: CHAR);
 
"VAR     min, max        : CARDINAL;
*bottom, top     : CARDINAL;
*width           : INTEGER;
"
"BEGIN
$GetFaceInfo (device, min,max, bottom,voidC,voidC,voidC, top,
1width ,voidI,voidI,voidI);
0
$minADE := CHR (min); maxADE := CHR (max);
$tb := CARDINAL (top);
$w := CARDINAL (width);
$h := CARDINAL (bottom) + tb + 1;     (* Topline selber mitzhlen *)
"END getCharSize;
 
 PROCEDURE setFont (hdl, size: INTEGER);
"VAR c: CARDINAL;
"BEGIN
$SetTextFace (device, hdl);
$SetAbsTHeight (device, size, c, c, c, c); (* Gre setzen *)
"END setFont;
 
 PROCEDURE getCharSizes (hdl: ptrWindow);
"VAR   w, h, tb        : CARDINAL;
"BEGIN
$WITH hdl^ DO
&getCharSize(w, h, tb, minADE, maxADE);
&charW := INTEGER (w);
&charH := INTEGER (h);
&topToBase := INTEGER (tb);
$END
"END getCharSizes;
 
 
8(*  calc. proc.s  *)
8(*  ============  *)
 
 (*  buffer  *)
 
 (*  pointToCharPos - Berechnet die Zeichenposition, die dem Bildschirm-
!*                   pixel 'p' entspricht. Liegt 'p' nicht in 'hdl', so
!*                   ist 'success = FALSE'.
!*                   Dabei berschreiten die Ergebnisse nie die maximal
!*                   Werte fr Zeilen- und Spaltenposition.
!*)
!
 PROCEDURE pointToCharPos (    hdl    :ptrWindow;
>p      :Point;
:VAR column,
>row    : CARDINAL;
:VAR success: BOOLEAN);
 
"VAR   lp: LongPnt;
"
"BEGIN
$WITH hdl^ DO
$
&WindowBase.CalcWindowCoor (handle, p, lp, success);
&IF NOT success THEN RETURN END;
&
&column := CARDINAL (SHORT (lp.x DIV LONG (charW)));
&row := CARDINAL (SHORT (lp.y DIV LONG (charH)));
&IF column >= hdl^.columns THEN column := hdl^.columns - 1 END;
&IF row >= hdl^.rows THEN row := hdl^.rows - 1 END;
&
$END;
"END pointToCharPos;
"
 (*  charToPointPos - Calculates the real pixel coor.s of the char. coor.s
!*                   (column/row).
!*)
!
 PROCEDURE charToPointPos (hdl: ptrWindow; column, row: CARDINAL): Point;
 
"VAR   result: Point;
"
"BEGIN
$WITH hdl^ DO
&WindowBase.CalcScreenCoor (handle,
ALPnt (LONG (INTEGER (column)) * LONG (charW),
GLONG (INTEGER (row)) * LONG (charH)),
Aresult, voidO);
$END;
$RETURN result
"END charToPointPos;
 
 (*  textBufferIndex - Calc.s the index in the text buffer for the char.
!*                    pos. specified.
!*)
 
 PROCEDURE textBufferIndex (hdl: ptrWindow; column, row: CARDINAL): bufRange;
 
"VAR     (* $Reg*)a, b    : CARDINAL;
"
"BEGIN
$IF (column >= hdl^.columns) OR (row >= hdl^.rows) THEN RETURN 0 END;
$WITH hdl^ DO
&a := textOrg + row * columns + column;
&b := rows * columns;
$END;
$IF a >= b THEN RETURN a - b ELSE RETURN a END;
"END textBufferIndex;
 
 
8(*  misc. gem proc.s  *)
8(*  ================  *)
 
 PROCEDURE connectToGem (): BOOLEAN;
 
"VAR     w, h            : CARDINAL;
"VAR     c               : CHAR;
*proc            : EventProc;
*success         : BOOLEAN;
*devpar          : PtrDevParm;
*mode    : WritingMode;
*hor     : THorJust;
*vert    : TVertJust;
 
"BEGIN
$SysInitGem(RC,device, success);
$IF success THEN
$
&gemHdl := CurrGemHandle ();
&
&AESWindows.UpdateWindow (TRUE);
&
&IF GDOSAvailable () THEN
(LoadFonts (device, 0, Fonts)
&ELSE
(Fonts:= 0;
&END;
&devpar:= DeviceParameter (device);
&INC (Fonts, devpar^.fonts); (* Anzahl der Fonts: Systemfonts mitzhlen *)
&
&IF StdFontHeight = 0 THEN
((* Systemfont ermitteln *)
(GetTextStyle (device, StdFontHdl, w, w, hor, vert, mode, 
0stdCharW, stdCharH, w, w);
(getCharSize (w, h, StdFontHeight, c, c);
&END;
&
&SetTextColor (device, white);
&SetTextEffects (device, TEffectSet{});
&SetFillPerimeter (device, FALSE);
&
&GrafMouse (arrow, NIL);
&
&AESWindows.UpdateWindow (FALSE);
&
$END;
$RETURN success
"END connectToGem;
 
 PROCEDURE deConnectFromGem;
 
"BEGIN
%ExitGem (gemHdl);
%gemHdl := GemHandle (0);
"END deConnectFromGem;
"
 (*  saveCurrHdl -- Rettet das aktuelle GEM-Hdl. in 'saveArea' und setzt
!*                 stattdessen das handle von 'TextWindows' ein. Tritt
!*                 beim Setzen ein Fehler auf, so wird ein Laufzeitfehler
!*                 ausgelt.
!*)
 
 PROCEDURE saveCurrHdl (VAR saveArea : GemHandle);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     CurrGemHandle
(MOVE.L  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.L  D0,(A0)
(
(MOVE.L  gemHdl,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     SetCurrGemHandle
(TST.W   (A7)+
(BNE     ende
(
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $E000
(ACZ     "TextWindows:Can't set own GEMHdl"
(SYNC
(
 ende
$END;
"END saveCurrHdl;
"(*$L=*)
 
 (*  restoreCurrHdl -- Setzt 'saveArea' als GEM-Hdl. ein. Falls dabei ein
!*                    Fehlere auftritt, wird ein Laufzeitfehler ausgelt.
!*)
(
 PROCEDURE restoreCurrHdl (saveArea : GemHandle);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(TST.L   -4(A3)
(BEQ     ende            ; jump, if 'saveArea = noGem'
(
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     SetCurrGemHandle
(TST.W   (A7)+
(BNE     ende
(
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $E000
(ACZ     "TextWindows:Can't set old GEMHdl"
(SYNC
(
 ende
$END;
"END restoreCurrHdl;
"(*$L=*)
 
 
8(*  pipes  *)
8(*  =====  *)
 
 (*  createPipe -- Alloc.s and init.s a new pipe.
!*                'success = FALSE', if out of memory.
!*)
!
 PROCEDURE createPipe (VAR p: pipe; VAR success: BOOLEAN);
 
"BEGIN
$SysAlloc (p, SIZE (p^));
$success := (p # NIL);
$IF ~ success THEN RETURN END;
$
$WITH p^ DO
&head := 1;
&tail := 1;
$END;
"END createPipe;
 
 (*  deletePipe -- Dealloc.s pipe.
!*)
!
 PROCEDURE deletePipe (VAR p: pipe);
 
"BEGIN
$DEALLOCATE (p, SIZE (p^));
"END deletePipe;
 
 (*  pipeFull -- Returns, if the pipe is full (further insertions would be
!*              ignored).
!*)
!
 PROCEDURE pipeFull (p: pipe): BOOLEAN;
 
"BEGIN
$RETURN p^.tail = p^.head MOD pipeMax + 1
"END pipeFull;
 
 (*  pipeEmpty -- Returns, if the pipe is empty (further read operations
!*               would be ignored.
!*)
!
 PROCEDURE pipeEmpty (p: pipe): BOOLEAN;
 
"BEGIN
$RETURN p^.head = p^.tail
"END pipeEmpty;
 
 (*  writeIntoPipe -- Writes one character into the pipe, if it is none full,
!*                   else the call is ignored.
!*)
 
 PROCEDURE writeIntoPipe (VAR p: pipe; ch: CHAR);
 
"BEGIN
$IF ~ pipeFull (p)
$THEN
&WITH p^ DO
(data[head] := ch;
(head := head MOD pipeMax + 1;
&END;
$END;
"END writeIntoPipe;
 
 (*  readFromPipe  -- Reads the element from the pipe which was inserted first
!*                   (fifo), means the one, that is in there the longest time.
!*                   If the pipe is empty, 0C is returned.
!*)
 
 PROCEDURE readFromPipe (VAR p: pipe; VAR ch: CHAR);
 
"BEGIN
$IF ~ pipeEmpty (p)
$THEN
&WITH p^ DO
(ch := data[tail];
(tail := tail MOD pipeMax + 1;
&END;
$ELSE ch := 0C END;
"END readFromPipe;
"
 
8(*  misc. managment  *)
8(*  ===============  *)
 
 PROCEDURE isValid (hdl: ptrWindow; errorMsg: BOOLEAN): BOOLEAN;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     careOfTime      ; evtl. zeitabhnige Proc. aufrufen
(
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A0
(CMPA.L  #NIL,A0
(BNE     cont
(;       ???? Falls hier etwas eingesetzt wird, mu body gendert werden
(MOVE.W  #FALSE,(A3)+
(BRA     return
 cont
(MOVE.L  A0,D0
(AND.W   #$FFFE,D0               ; Keine ungeraden Adr. zulassen
(MOVE.L  D0,A0
(MOVE.L  window.magic(A0),D0
(CMP.L   #windowMagic,D0
(BEQ     cont2
(TST.W   D1
(BEQ     noMsg                   ; keinen Laufzeitfehler auslsen
(TRAP    #noErrorTrap
(DC.W    IllegalPointer
 noMsg   MOVE.W  #FALSE,(A3)+
(BRA     return
 cont2
(MOVE.W  #TRUE,(A3)+
 return
$END;
"END isValid;
"(*$L=*)
"
 PROCEDURE notValid (hdl: Window; errorMsg: BOOLEAN): BOOLEAN;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     isValid
(EORI.W  #1,-2(A3)
$END;
"END notValid;
"(*$L=*)
"
 PROCEDURE isMagicOrNIL (hdl: ptrWindow): BOOLEAN;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -4(A3),D0
(BNE     cont
(SUBQ.L  #4,A3
(MOVE.W  #TRUE,(A3)+
(BRA     ende
 
 cont    MOVE.W  #TRUE,(A3)+
(JSR     isValid
 ende
$END;
"END isMagicOrNIL;
"(*$L=*)
 
 
8(*  misc. window managment proc.s  *)
8(*  =============================  *)
 
 (*  isHidden -- Returns 'TRUE', if 'hdl's window is not visible.
!*)
!
 PROCEDURE isHidden (hdl: ptrWindow): BOOLEAN;
 
"BEGIN
$RETURN WindowBase.hiddenWdw IN WindowBase.WindowFlags (hdl^.handle)
"END isHidden;
 
 (*  isTop -- Returns 'TRUE, if 'hdl's window is the top window.
!*)
 
 PROCEDURE isTop (hdl: ptrWindow): BOOLEAN;
 
"BEGIN
$RETURN WindowBase.topWdw IN WindowBase.WindowFlags (hdl^.handle)
"END isTop;
 
 (*  setPosAndSize -- Sets the current window position and size.
!*                   The parm.s are in char. coor.s and the special
!*                   values 'CenterWindow' and 'MaxWindow' are allowed.
!*)
 
 PROCEDURE setPosAndSize (hdl: ptrWindow; x, y, w, h: INTEGER);
 
"BEGIN
$WITH hdl^ DO
&IF x = CenterWindow THEN x := WindowBase.CenterWdw ELSE x := x * INT(stdCharW) END;
&IF y = CenterWindow THEN y := WindowBase.CenterWdw ELSE y := y * INT(stdCharH) END;
&IF w = MaxWindow THEN w := WindowBase.MaxWdw ELSE w := w * charW END;
&IF h = MaxWindow THEN h := WindowBase.MaxWdw ELSE h := h * charH END;
&WindowBase.SetWindowWorkArea (handle, Rect (x, y, w, h));
$END
"END setPosAndSize;
"
"
8(*  VT52-Emulator, Part I  *)
8(*  =====================  *)
 
 (*  escAutomat -- Does one step of the finite automat for the VT52-Emulator.
!*
!*                in: 'status' - current automat state
!*                    'ch'     - char to accept
!*
!*                out: 'status' - new automat state
!*                     'result' - generated data (VT52-Comand)
!*
!*                fct: Calculates the new automat state and generates a
!*                     VT52-Comand, while accepting 'ch'.
!*)
!
 PROCEDURE escAutomat (VAR status: escStatusDesc;
:inCh  : CHAR;
6VAR result: escResultDesc);
 
"BEGIN
$WITH result DO
$
&comand := nothingEsc;
&ch := null;
&
&CASE status.state OF
&
(normalEsc: IF inCh = esc THEN status.state := escEsc
3ELSE ch := inCh; comand := normalCharEsc END|
(
(escEsc   : status.state := normalEsc;
3CASE inCh OF
(
5ctrlE: comand := enhanceOnEsc|
5ctrlF: comand := enhanceOffEsc|
5ctrlP: comand := flushEsc|
(
5'A'  : comand := cursUpEsc|
5'B'  : comand := cursDownEsc|
5'C'  : comand := cursRightEsc|
5'D'  : comand := cursLeftEsc|
5'E'  : comand := clsEsc|
5'H'  : comand := homeEsc|
5'J'  : comand := eraseEOPEsc|
5'I'  : comand := reverseLfEsc|
5'K'  : comand := clrEOLEsc|
5'L'  : comand := insLnEsc|
5'M'  : comand := delLnEsc|
5'Y'  : status.state := gotoYEsc|
5'b'  : status.state := fgEsc|
5'c'  : status.state := bgEsc|
5'd'  : comand := eraseBegDispEsc|
5'e'  : comand := cursOnEsc|
5'f'  : comand := cursOffEsc|
5'j'  : comand := saveCursPosEsc|
5'k'  : comand := restoreCursPosEsc|
5'l'  : comand := eraseLnEsc|
5'o'  : comand := eraseBegLnEsc|
5'p'  : comand := reverseOnEsc|
5'q'  : comand := reverseOffEsc|
5'v'  : comand := wrapOnEsc|
5'w'  : comand := wrapOffEsc|
5
3END|
3
(gotoXEsc : IF (inCh >= space) AND (status.first >= space)
3THEN
5x := ORD (inCh) - ORD (space);
5y := ORD (status.first) - ORD (space);
5comand := gotoXYEsc;
3END;
3status.state := normalEsc|
3
(gotoYEsc : status.first := inCh;
3status.state := gotoXEsc|
3
(fgEsc   : IF (ORD (inCh) >= ORD ('0')) AND (ORD (inCh) <= ORD ('?'))
2THEN
4fgCol := ORD (inCh) - ORD ('0');
4comand := fgColEsc;
2END;
2status.state := normalEsc|
2
(bgEsc   : IF (ORD (inCh) >= ORD ('0')) AND (ORD (inCh) <= ORD ('?'))
2THEN
4bgCol := ORD (inCh) - ORD ('0');
4comand := bgColEsc;
2END;
2status.state := normalEsc|
&
&END;
&
$END;
"END escAutomat;
 
 
8(*  buffer reading proc.s  *)
8(*  =====================  *)
 
 (*  window server  *)
 
 PROCEDURE update (wdw   : WindowBase.Window;
2env   : ADDRESS;
2source,
2dest,
2new   : Rectangle);
 
"VAR   hdl             : ptrWindow;
(oldHdl          : GemHandle;
(
(currElemPtr     : ptrBufferElem;
(l, t, r, b, c   : CARDINAL;
(dRev            : effectSet;
(p               : Point;
(collectSpaces   : BOOLEAN;
((* $Reg*)x, j, sp,
0row     : CARDINAL;
"
"BEGIN
$IF source.w # 0 THEN
&DisableClipping (device);
&CopyOpaque (device, ADR (stdMFDB), ADR (stdMFDB), source, dest, onlyS);
$END;
$
$IF (new.w <= 0) OR (new.h <= 0) THEN RETURN END;
$
$hdl := ptrWindow (env);
$saveCurrHdl (oldHdl);
$
$WITH hdl^ DO
&
&pointToCharPos (hdl, Pnt (new.x, new.y), l, t, voidO);
&pointToCharPos (hdl, Pnt (new.x + new.w - 1, new.y + new.h - 1),
6r, b, voidO);
&
&SetWritingMode (device, replaceWrt);
&SetFillType (device, solidFill);
&SetFillColor (device, bgCol);
&SetClipping (device, new);
&FillRectangle (device, new);
&
&SetTextColor (device, fgCol);
&setFont (fontHdl, topToBase);
&
&FOR row := t TO b DO
&
(currElemPtr := ADR (buffer^[textBufferIndex (hdl, l, row)]);
(x := l;
(REPEAT
(
*j := 0; sp := 0;
*p := charToPointPos (hdl, x, row);
*dRev := currElemPtr^.effects;
*REPEAT
,redrawStr^[j] := currElemPtr^.ch;
,IF (redrawStr^[j] < minADE)
/OR (redrawStr^[j] > maxADE)
,THEN
.redrawStr^[j] := ' ';
,END;
*
,IF redrawStr^[j] = ' ' THEN INC (sp) ELSE sp := 0 END;
,collectSpaces := (sp > 2);
-
,INC (currElemPtr, SIZE (currElemPtr^)); INC (x); INC (j);
*UNTIL (x > r) OR (dRev # currElemPtr^.effects) OR collectSpaces;
*
*IF NOT collectSpaces THEN sp := 0 END;
*redrawStr^[j - sp] := 0C;
*IF redrawStr^[0] # 0C THEN
*
,p.y := p.y + topToBase;
,
,(*  Achtung: String hat 'MaxCard + 1' Elemente (REF ntig) *)
,grafText (device, p, redrawStr^, dRev);
*
*END;
*IF collectSpaces THEN
*
,DEC (x, sp); DEC (currElemPtr, SHORT (SIZE (currElemPtr^)) * sp);
,sp := 0;
,p := charToPointPos (hdl, x, row);
,REPEAT
.INC (currElemPtr, SIZE (currElemPtr^)) ; INC (x) ; INC (sp);
,UNTIL (x > r) OR (dRev # currElemPtr^.effects)
2OR (currElemPtr^.ch # ' ');
2
,IF inverse IN dRev THEN
.SetFillColor (device, fgCol);
.FillRectangle (device, Rect (p.x, p.y,
KINTEGER (sp) * charW, charH));
,END;
*
*END;
*
(UNTIL x > r;
(
&END;(*FOR*)
&
&DisableClipping (device);
#
$END;(*WITH*)
"
$restoreCurrHdl (oldHdl);
"END update;
 
 PROCEDURE activated (wdw: WindowBase.Window; env: ADDRESS);
 
"END activated;
 
 PROCEDURE close (wdw: WindowBase.Window; env: ADDRESS);
 
"VAR   hdl: ptrWindow;
 
"BEGIN
$hdl := ptrWindow (env);
$
$hdl^.closed := TRUE;
"END close;
 
 PROCEDURE checkSpec (    wdw   : WindowBase.Window;
9env   : ADDRESS;
5VAR spec  : WindowBase.WindowSpec;
9border: LongRect             );
"
"CONST charAlign       = 8L;
"
"VAR   hdl: ptrWindow;
(amt: LONGINT;
$
"BEGIN
$hdl := ptrWindow (env);
$
$WITH spec DO
$
&WITH hdl^ DO
(IF visible.w > LONG (INTEGER (columns)) * LONG (charW)
(THEN visible.w := LONG (INTEGER (columns)) * LONG (charW) END;
(IF visible.h > LONG (INTEGER (rows)) * LONG (charH)
(THEN visible.h := LONG (INTEGER (rows)) * LONG (charH) END;
&END;
&
&(*  Umrechnen in Weltkoor.
'*)
&INC (virtual.x, visible.x);
&INC (virtual.y, visible.y);
&
&border.w := border.x + border.w - 1L;
&border.h := border.y + border.h - 1L;
&IF virtual.x < border.x THEN virtual.x := border.x END;
&IF virtual.y < border.y THEN virtual.y := border.y END;
&IF virtual.x > border.w THEN virtual.x := border.w END;
&IF virtual.y > border.h THEN virtual.y := border.h END;
&(* 'visible' erst nach _korrigiertem_ 'virtual' bestimmen: 14.01.94 TT *)
&visible.w := virtual.x + visible.w - 1L;
&visible.h := virtual.y + visible.h - 1L;
&IF visible.w < border.x THEN visible.w := border.x END;
&IF visible.h < border.y THEN visible.h := border.y END;
&IF visible.w > border.w THEN visible.w := border.w END;
&IF visible.h > border.h THEN visible.h := border.h END;
&visible.w := visible.w - virtual.x + 1L;
&visible.h := visible.h - virtual.y + 1L;
&
&INC (virtual.x, charAlign - 1L); DEC (virtual.x, virtual.x MOD charAlign);
&
&DEC (virtual.x, visible.x);
&DEC (virtual.y, visible.y);
&
&WITH hdl^ DO
(amt := visible.x MOD LONG (charW);
(INC (virtual.x, amt); DEC (visible.x, amt);
(amt := visible.y MOD LONG (charH);
(INC (virtual.y, amt); DEC (visible.y, amt);
(
(DEC (visible.w, visible.w MOD LONG (charW));
(DEC (visible.h, visible.h MOD LONG (charH));
&END
$END;
"END checkSpec;
 
 PROCEDURE scrollAmt (wdw    : WindowBase.Window;
5env    : ADDRESS;
5toDo   : WindowBase.WindowScrollMode): LONGINT;
2
"VAR   spec: WindowBase.WindowSpec; w: ptrWindow;
"
"BEGIN
$w:= env;
$WindowBase.GetWindowSpec (wdw, spec);
$CASE toDo OF
&WindowBase.pageLeftWdw,
&WindowBase.pageRightWdw  : RETURN spec.visible.w|
&WindowBase.pageUpWdw,
&WindowBase.pageDownWdw   : RETURN spec.visible.h|
&WindowBase.columnLeftWdw,
&WindowBase.columnRightWdw: RETURN LONG (w^.charW)|
&WindowBase.rowUpWdw,
&WindowBase.rowDownWdw    : RETURN LONG (w^.charH)|
$END;
"END scrollAmt;
 
 
 (*  misc.  *)
 
 PROCEDURE takeCareOfForce (hdl: ptrWindow);
 
"CONST   horPuffer       = 4;
*vertPuffer      = 1;
"
"PROCEDURE adjust (puffer        :INTEGER;
4minP,   maxP,
4smallP, highP,
4targetP       :CARDINAL) :INTEGER;
"
$VAR   (* $Reg*) result : INTEGER;
*min, max, small,
*high, target    : INTEGER;
*left, right     : BOOLEAN;
$
$BEGIN
&min := INTEGER (minP); max := INTEGER (maxP);
&small := INTEGER (smallP); high := INTEGER (highP);
&target := INTEGER (targetP);
&
&left := ((small + puffer) > target);
&right := ((high - puffer) < target);
&IF left = right THEN RETURN 0
&ELSIF left THEN result := target - small - 2 * puffer
&ELSE result:=target - high + 2 * puffer END;
&
&IF (small + result) < min THEN result := min - small END;
&IF (high + result) > max THEN result := max - high END;
&
&RETURN result;
$END adjust;
"
"VAR     right, bottom,
*left, top      : CARDINAL;
*rowAmt, colAmt : INTEGER;
*spec           : WindowBase.WindowSpec;
*(* $Reg*)changed: BOOLEAN;
"
"BEGIN
$IF isHidden (hdl) THEN RETURN END;
$
$WITH hdl^ DO
%IF force # noForce  THEN
$
&IF NOT isTop (hdl) THEN
(WindowBase.PutWindowOnTop (handle);
(FlushEvents;                    (* Gib AES Zeit fr redraw message *)
&END;
&
&IF (force = forceCursor) OR (force = forceLine) THEN
*
(WindowBase.GetWindowSpec (handle, spec);
(left := CARDINAL (SHORT (spec.visible.x DIV LONG (charW)));
(top := CARDINAL (SHORT (spec.visible.y DIV LONG (charH)));
(right := left + CARDINAL (SHORT (spec.visible.w DIV LONG (charW))) - 1;
(bottom := top + CARDINAL (SHORT (spec.visible.h DIV LONG (charH))) - 1;
(
(IF force = forceCursor THEN
*colAmt := adjust (horPuffer, 0, columns - 1, left, right,
<cursX) * charW
(ELSE
*colAmt := 0
(END;
(rowAmt := adjust (vertPuffer, 0, rows - 1, top, bottom, cursY)
2* charH;
(
(IF (SHORT (spec.visible.x) + colAmt) < 0
(THEN
*changed := (spec.visible.w # 0L);
*spec.visible.x := 0L;
(ELSE
*changed := (colAmt # 0);
*INC (spec.visible.x, colAmt);
(END;
(IF (SHORT (spec.visible.y) + rowAmt) < 0 THEN
*changed := changed OR (spec.visible.y # 0L);
*spec.visible.y := 0L;
(ELSE
*changed := changed OR (rowAmt # 0);
*INC (spec.visible.y, rowAmt);
(END;
(IF changed THEN
*WindowBase.SetWindowSliderPos (handle,
Ispec.visible.x, spec.visible.y);
(END;
*
&END;
&
%END;
$END;
"END takeCareOfForce;
"
 PROCEDURE doWaitingRedraws (hdl: ptrWindow);
 
"BEGIN
$WITH hdl^ DO WITH redrawArea DO
$
&IF w # 0 THEN
(WindowBase.UpdateWindow (handle, update, hdl,
ALRect (LONG (x) * LONG (charW),
HLONG (y) * LONG (charH),
HLONG (w) * LONG (charW),
HLONG (h) * LONG (charH)),
AWindowBase.noCopyWdw, 0L);
(w := 0;
&END;
&
$END END;
$takeCareOfForce (hdl);
"END doWaitingRedraws;
"
8(*  redraw pipe proc.s  *)
8(*  ==================  *)
 
 (*  addRedrawArea -- Adds a new area, to the area(s), that have to be
!*                   redrawn. 'area' contains virtual char. coor.s.
!*                   May call the redraw proc.
!*)
 
 PROCEDURE addRedrawArea (hdl: ptrWindow; area: Rectangle);
 
"VAR   new: Rectangle;
"
"BEGIN
$WITH hdl^ DO
$
&IF redrawArea.w = 0 THEN redrawArea := area
&ELSE
&
(new := FrameRects (redrawArea, area);
(IF LONG (new.w) * LONG (new.h)
+> 2L * (LONG (area.w) * LONG (area.h)
3+ LONG (redrawArea.w) * LONG (redrawArea.h))
(THEN
*doWaitingRedraws (hdl); redrawArea := area
(ELSE
*redrawArea := new
(END;
(
&END;
&
$END;
"END addRedrawArea;
"
"
8(*  buffer writing proc.s  *)
8(*  =====================  *)
 
 (*  out of write pipe  *)
 
 (*  writeSpaceBlock - Der angegebene Bereich zwischen den beiden Zeichen
!*                    positionen wird mit spaces aufgefllt. Cursorsicht-
!*                    barkeit und -position wird nicht beachtet.
!*                    'suppressRedraw = TRUE' bedeutet, da der Bereich
!*                    zwar mit Leerzeichen aufgefllt wird, aber nicht
!*                    in die noch neuzuzeichnenden Bereiche eingetragen
!*                    wird.
!*)
 
 PROCEDURE writeSpaceBlock (hdl           : ptrWindow;
;left,
;top,
;right,
;bottom        : CARDINAL;
;suppressRedraw: BOOLEAN);
 
"VAR     i      : bufRange;
*j, line: CARDINAL;
*elem   : bufferElem;
 
"BEGIN
$elem.ch := ' ';
$elem.effects := effectSet{};
$IF hdl^.revMode THEN INCL (elem.effects, inverse) END;
$
$FOR line := top TO bottom DO
$
&i := textBufferIndex (hdl, left, line);
&FOR j := 1 TO right - left + 1 DO hdl^.buffer^[i] := elem; INC (i) END;
&
$END;
$
$IF NOT suppressRedraw
$THEN
&addRedrawArea (hdl, Rect (left, top, right - left + 1, bottom - top + 1));
$END;
"END writeSpaceBlock;
 
 PROCEDURE scrollUp (hdl: ptrWindow);
 
"BEGIN
$WITH hdl^ DO
$
&(*  clear top row, cause it becomes the new bottom row.
'*)
&writeSpaceBlock (hdl, 0, 0, columns - 1, 0, TRUE);
E
&(*  move waiting redraws
'*)
&WITH redrawArea DO
(IF y > 0 THEN DEC (y) ELSE DEC (h) END;
&END;
&
&IF textOrg >= ((rows - 1) * columns) THEN
(textOrg := 0;
&ELSE
(textOrg := textOrg + columns
&END;
&cursIndex := textBufferIndex (hdl, cursX, cursY);
&
&WindowBase.UpdateWindow (handle, update, hdl,
?LRect (0L, 0L,
FLONG (INTEGER (columns)) * LONG (charW),
FLONG (INTEGER (rows)) * LONG (charH)),
?WindowBase.copyVertWdw, LONG (-charH) );
E
$END;
"END scrollUp;
"
 PROCEDURE scrollDown (hdl: ptrWindow);
 
"BEGIN
$WITH hdl^ DO
&
&(*  clear bottom row, cause it becomes the new top row.
'*)
&writeSpaceBlock (hdl, 0, rows - 1, columns - 1, rows - 1, TRUE);
 
&(*  move waiting redraws
'*)
&WITH redrawArea DO
(INC (y);
(IF y + h > INTEGER (rows) - 1 THEN DEC (h) END;
&END;
&
&IF textOrg = 0 THEN
(textOrg := (rows - 1) * columns
&ELSE
(textOrg := textOrg - columns
&END;
&cursIndex := textBufferIndex (hdl, cursX, cursY);
&
&WindowBase.UpdateWindow (handle, update, hdl,
?LRect (0L, 0L,
FLONG (INTEGER (columns)) * LONG (charW),
FLONG (INTEGER (rows)) * LONG (charH)),
?WindowBase.copyVertWdw, LONG (charH) );
 
$END;
"END scrollDown;
 
 PROCEDURE cursorOff (hdl: ptrWindow);
 
"BEGIN
$WITH hdl^ DO
&IF noCursHides = 0 THEN
&
(IF cursX < columns THEN
*WITH buffer^[cursIndex] DO effects := effects / effectSet{inverse} END;
*addRedrawArea (hdl, Rect (cursX, cursY, 1, 1));
(END;
(
&END;
&INC (noCursHides);
$END;
"END cursorOff;
 
 PROCEDURE cursorOn (hdl: ptrWindow);
 
"BEGIN
$WITH hdl^ DO
&IF noCursHides = 1 THEN
&
(IF cursX < columns THEN
*WITH buffer^[cursIndex] DO effects := effects + effectSet{inverse} END;
*addRedrawArea (hdl, Rect (cursX, cursY, 1, 1));
(END;
(
&END;
&DEC (noCursHides);
$END;
"END cursorOn;
 
 PROCEDURE setCursor (hdl: ptrWindow; col, row: INTEGER);
 
"BEGIN
$cursorOff (hdl);
$
$WITH hdl^ DO
$
&IF col > INTEGER (columns) THEN cursX := columns - 1
&ELSIF col < 0 THEN cursX := 0
&ELSE cursX := CARDINAL (col) END;
&
&IF row >= INTEGER (rows) THEN cursY := rows - 1
&ELSIF row < 0 THEN cursY := 0
&ELSE cursY := CARDINAL (row) END;
&
&cursIndex := textBufferIndex (hdl, cursX, cursY);
$
$END;
$
$cursorOn (hdl);
"END setCursor;
"
 PROCEDURE clearToEndOfLine (hdl: ptrWindow);
 
"BEGIN
$WITH hdl^ DO
$
&IF cursX < columns
&THEN
(cursorOff (hdl);
(writeSpaceBlock(hdl, cursX, cursY, columns - 1, cursY, FALSE);
(cursorOn (hdl);
&END;
&
$END;
"END clearToEndOfLine;
 
 PROCEDURE eraseBegOfLine (hdl: ptrWindow);
 
"VAR (* $Reg*) oldCursX: CARDINAL;
"
"BEGIN
$cursorOff (hdl);
$
$WITH hdl^
$DO
&oldCursX := cursX;
&IF oldCursX = columns THEN DEC (oldCursX) END;
&writeSpaceBlock (hdl, 0, cursY, oldCursX, cursY, FALSE);
$END;
$
$cursorOn (hdl);
"END eraseBegOfLine;
 
 PROCEDURE eraseToEndOfPage (hdl: ptrWindow);
 
"BEGIN
$cursorOff (hdl);
$
$WITH hdl^ DO
&IF cursX < columns THEN
(writeSpaceBlock (hdl, cursX, cursY, columns - 1, cursY, FALSE)
&END;
&IF (cursY + 1) < rows THEN
(writeSpaceBlock (hdl, 0, cursY + 1, columns - 1, rows - 1, FALSE)
&END;
$END;
$
$cursorOn (hdl);
"END eraseToEndOfPage;
 
 PROCEDURE eraseBegOfDisp (hdl: ptrWindow);
 
"VAR (* $Reg*) oldCursX   : CARDINAL;
"
"BEGIN
$cursorOff (hdl);
$
$WITH hdl^ DO
$
&oldCursX := cursX;
&IF oldCursX = columns THEN DEC (oldCursX) END;
&writeSpaceBlock (hdl, 0, cursY, oldCursX, cursY, FALSE);
&IF cursY > 0 THEN
(writeSpaceBlock (hdl, 0, 0, columns - 1, cursY - 1, FALSE);
&END;
&
$END;
$
$cursorOn (hdl);
"END eraseBegOfDisp;
 
 PROCEDURE eraseEntireLine (hdl: ptrWindow);
 
"BEGIN
$cursorOff (hdl);
$
$WITH hdl^
$DO
&writeSpaceBlock (hdl, 0, cursY, columns - 1, cursY, FALSE);
&setCursor (hdl, 0, cursY);
$END;
$
$cursorOn (hdl);
"END eraseEntireLine;
 
 PROCEDURE cursorHome (hdl: ptrWindow);
 
"BEGIN
$setCursor (hdl, 0, 0);
"END cursorHome;
 
 PROCEDURE clearScreen (hdl: ptrWindow);
 
"BEGIN
$cursorHome (hdl);
$eraseToEndOfPage (hdl);
"END clearScreen;
 
 PROCEDURE insertLine (hdl: ptrWindow);
 
"VAR   f            : Rectangle;
1n,
((*$Reg*) max,
((*$Reg*) i,
((*$Reg*) j: CARDINAL;
"
"BEGIN
$cursorOff (hdl);
$
$WITH hdl^ DO
$
&(*  Bufferinhalt ab Cursor nach unten schieben.
'*)
'
&max := columns * rows - 1;
&IF textOrg = 0 THEN j := max ELSE j := textOrg - 1 END;
&IF j < columns THEN i := max - columns + j ELSE i := j - columns END;
&FOR n:= 1 TO (rows - 1 - cursY) * columns DO
(buffer^[j] := buffer^[i];
(IF i = 0 THEN i := max ELSE DEC (i) END;
(IF j = 0 THEN j := max ELSE DEC (j) END;
&END;
'
&(*  Zeile in der Curs. steht, lschen.
'*)
$
&FOR i := textBufferIndex (hdl, 0,cursY)
/TO textBufferIndex (hdl, columns - 1,cursY) DO
(WITH buffer^[i] DO
*ch := ' ';
*effects := effectSet{};
*IF hdl^.revMode THEN INCL (effects, inverse) END;
(END;
&END;
&setCursor (hdl, 0, hdl^.cursY);
&
&(*  Fensterinhalt restaurieren.
'*)
&f.x := 0; f.w := INTEGER (columns) * charW;
&f.y := INTEGER (cursY) * charH; f.h := INTEGER (rows) * charH - f.y;
&IF (f.y >= 0) AND (f.h > 0) THEN
(WindowBase.UpdateWindow (hdl^.handle, update, hdl,
ALRect (LONG (f.x), LONG (f.y),
HLONG (f.w), LONG (f.h)),
AWindowBase.copyVertWdw, charH);
&END;
(
$END;
$
$cursorOn (hdl);
"END insertLine;
 
 PROCEDURE deleteLine (hdl: ptrWindow);
 
"VAR   f            : Rectangle;
((*$Reg*) i, (*$Reg*) j: CARDINAL;
(n, (*$Reg*) max       : CARDINAL;
"
"BEGIN
$cursorOff (hdl);
$
$WITH hdl^ DO
$
&(*  Bufferinhalt ab Cursor nach oben schieben.
'*)
'
&max := columns * rows - 1;
&j := textBufferIndex (hdl, 0,cursY);
&i := j + columns;
&IF i > max THEN i := i - max - 1 END;
&FOR n:= 1 TO (rows - 1 - cursY) * columns DO
(buffer^[j]:=buffer^[i];
(IF i = max THEN i := 0 ELSE INC (i) END;
(IF j = max THEN j := 0 ELSE INC (j) END;
&END;
'
&(*  Letzte Zeile lschen.
'*)
$
&FOR i := textBufferIndex (hdl, 0,rows - 1) TO
/textBufferIndex (hdl, columns - 1,rows - 1) DO
(WITH buffer^[i] DO
*ch := ' ';
*effects := effectSet{};
*IF hdl^.revMode THEN INCL (effects, inverse) END;
(END;
&END;
&setCursor (hdl, 0, hdl^.cursY);
&
&(*  Fensterinhalt restaurieren.
'*)
&f.x := 0; f.w := INTEGER (columns) * charW;
&f.y := INTEGER (cursY) * charH; f.h := INTEGER (rows) * charH - f.y;
&IF (f.y >= 0) AND (f.h > 0) THEN
(WindowBase.UpdateWindow (hdl^.handle, update, hdl,
ALRect (LONG (f.x), LONG (f.y),
HLONG (f.w), LONG (f.h)),
AWindowBase.copyVertWdw, LONG (-charH));
&END;
$
$END;
$
$cursorOn (hdl);
"END deleteLine;
"
 PROCEDURE doBell;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  #$00020007,-(A7)
(MOVE.W  #$3,-(A7)
(TRAP    #13             ; BIOS (3) -- Bconout (2, CHR (7))
(ADDQ.W  #6,A7
$END;
"END doBell;
"(*$L=*)
 
 PROCEDURE initEscAutomat (VAR escStatus: escStatusDesc);
 
"BEGIN
$escStatus.state := normalEsc;
"END initEscAutomat;
 
 (*  insertIntoBuffer -- Inserts a single character at the current cursor
!*                      position into the text buffer.
!*                      If neccesary, interpretation of control characters.
!*)
 
 PROCEDURE insertIntoBuffer (hdl: ptrWindow; newCh: CHAR);
 
"VAR   done      : BOOLEAN;
(newEffects: effectSet;
 
"BEGIN
$WITH hdl^ DO
"
&(*  if neccasary, interpret the control characters.
'*)
'
&done := FALSE;
&IF (newCh < ' ') AND (ctrlMode = interpretCtrl)
&THEN
(CASE newCh OF
(
*bell: doBell; done := TRUE|
*
*bs  : setCursor (hdl, cursX - 1, cursY);
0done := TRUE|
0
*lf  : cursorOff (hdl);
0IF (cursY + 1) < rows THEN setCursor (hdl, cursX, cursY + 1)
0ELSE scrollUp (hdl) END;
0cursorOn (hdl);
0done := TRUE|
0
*cr  : IF cursX # 0 THEN setCursor (hdl, 0, cursY) END;
0done := TRUE|
*
(END;
&END;
&
&(*  if no interpretation, then insert character at cursor position and
'*  set cursor to new position (includes: insert area into "redraw pipe").
'*)
&
&IF NOT done THEN
(
(cursorOff (hdl);
(
(IF cursX >= columns THEN
*IF (cursY + 1) = rows THEN scrollUp (hdl) END;
*setCursor (hdl, 0, cursY + 1);
(END;
&
(newEffects := effectSet{};
(IF revMode THEN INCL (newEffects, inverse) END;
(WITH buffer^[cursIndex]
(DO
*ch := newCh;
*effects := newEffects;
(END;
(addRedrawArea (hdl, Rect (cursX, cursY, 1, 1));
(
(IF (wrapAround AND (cursX = columns - 1)) OR (cursX < columns - 1) THEN
*setCursor (hdl, cursX + 1, cursY);
(END;
(
(cursorOn (hdl);
$
&END;
$
$END;
"END insertIntoBuffer;
"
 (*  flushWritePipe -- Reads the write pipe of 'hdl' char by char and
!*                    and inserts that char into the esc Automat. De-
!*                    pending on the result of the automat, the text
!*                    buffer is changed and data is written into the
!*                    "redraw pipe".
!*)
!
 PROCEDURE flushWritePipe (hdl: ptrWindow);
 
"VAR   ch       : CHAR;
(escResult: escResultDesc;
(flush    : BOOLEAN;
(
"BEGIN
$flush := FALSE;
$WITH hdl^ DO
&WHILE NOT pipeEmpty (writePipe) DO
$
(readFromPipe (writePipe, ch);
(escAutomat (escStatus, ch, escResult);
(
(CASE escResult.comand OF
(
*nothingEsc       : |
*normalCharEsc    : insertIntoBuffer (hdl, ch)|
*
*cursUpEsc        : setCursor (hdl, cursX, cursY - 1)|
*cursDownEsc      : setCursor (hdl, cursX, cursY + 1)|
*cursLeftEsc      : setCursor (hdl, cursX - 1, cursY)|
*cursRightEsc     : setCursor (hdl, cursX + 1, cursY)|
=
*clsEsc           : clearScreen (hdl)|
*homeEsc          : cursorHome (hdl)|
*eraseEOPEsc      : eraseToEndOfPage (hdl)|
*
*reverseLfEsc     : cursorOff (hdl);
=IF cursY > 0
=THEN setCursor (hdl, cursX, cursY - 1)
=ELSE scrollDown (hdl) END;
=cursorOn (hdl)|
=
*clrEOLEsc        : clearToEndOfLine (hdl)|
*insLnEsc         : insertLine (hdl)|
*delLnEsc         : deleteLine (hdl)|
*gotoXYEsc        : setCursor (hdl, escResult.x, escResult.y)|
*fgColEsc         : fgCol := escResult.fgCol|
*bgColEsc         : bgCol := escResult.bgCol|
*eraseBegDispEsc  : eraseBegOfDisp (hdl)|
*cursOnEsc        : IF noCursHides = 1 THEN cursorOn (hdl) END|
*cursOffEsc       : IF noCursHides = 0 THEN cursorOff (hdl) END|
*
*saveCursPosEsc   : cursXSave := cursX;
=cursYSave := cursY|
=
*restoreCursPosEsc: setCursor (hdl, cursXSave, cursYSave);
=cursXSave := 0; cursYSave := 0|
=
*eraseLnEsc       : eraseEntireLine (hdl)|
*eraseBegLnEsc    : eraseBegOfLine (hdl)|
*reverseOnEsc     : revMode := TRUE|
*reverseOffEsc    : revMode := FALSE|
*wrapOnEsc        : wrapAround := TRUE|
*wrapOffEsc       : wrapAround := FALSE|
*flushEsc         : flush := TRUE|
*enhanceOffEsc    : enhanced := FALSE; flush := TRUE|
*enhanceOnEsc     : enhanced := TRUE; flush := TRUE|
*
(END;
(
&END;
&IF NOT enhanced OR flush THEN doWaitingRedraws (hdl) END;
$END;
"END flushWritePipe;
"
 
 (*  into write pipe  *)
 
 (*  insertIntoWritePipe -- Appends a string to a windows write pipe and
!*                         checks for enhanced or flush esc sequences.
!*                         Calls write pipe flush proc.
!*)
 
 PROCEDURE insertIntoWritePipe (hdl: Window; REF str: ARRAY OF CHAR);
 
"VAR   (* $Reg*) i: CARDINAL;
(escResult : escResultDesc;
(
"BEGIN
$WITH hdl^ DO
$
&i := 0;
&WHILE (i <= HIGH (str)) AND (str[i] # 0C) DO
&
(IF pipeFull (writePipe) THEN flushWritePipe (hdl) END;
(writeIntoPipe (writePipe, str[i]);
(
(escAutomat (pipeEscStatus, str[i], escResult);
(IF (escResult.comand = flushEsc) OR (escResult.comand = enhanceOffEsc)
+OR (escResult.comand = enhanceOnEsc)
(THEN flushWritePipe (hdl) END;
(
(INC (i);
&END;
&IF NOT enhanced THEN flushWritePipe (hdl) END;
&
$END;
"END insertIntoWritePipe;
 
 
8(*  misc. help proc.s  *)
8(*  =================  *)
 
 (*  internal... -- These proc.s are used to execute some esc sequences,
!*                 without using the 'writePipe', to avoid conflict with
!*                 user esc sequences.
!*                 They are for internal use only and flush all pipes.
!*)
 
 PROCEDURE internalFlushPipe (hdl: ptrWindow);
 
"BEGIN
$flushWritePipe (hdl);
$doWaitingRedraws (hdl);
"END internalFlushPipe;
 
 PROCEDURE internalCursorOn (hdl: ptrWindow);
"VAR oldForce: ForceMode;
"BEGIN
$oldForce:= hdl^.force;
$hdl^.force:= forceCursor;
$flushWritePipe (hdl);
$cursorOn (hdl);
$doWaitingRedraws (hdl);
$hdl^.force:= oldForce
"END internalCursorOn;
"
 PROCEDURE internalCursorOff (hdl: ptrWindow);
 
"BEGIN
$flushWritePipe (hdl);
$cursorOff (hdl);
$doWaitingRedraws (hdl);
"END internalCursorOff;
 
 PROCEDURE myShow (hdl: Window);
"BEGIN
$IF notValid (hdl, TRUE) THEN RETURN END;
$IF isHidden (hdl) THEN
&internalFlushPipe (hdl);
&WindowBase.OpenWindow (hdl^.handle);
$END;
$FlushEvents;
"END myShow;
 
8(*  exported proc.s  *)
8(*  ===============  *)
 
 (*  managmant proc.s  (ignoring pipe and similiar objects) *)
 
 PROCEDURE Open (VAR hdl            : Window;      newColumns, newRows: CARDINAL;
4qualities      : WQualitySet; mode               : ShowMode;
4newForce       : ForceMode;   wName     : ARRAY OF CHAR;
4colOrg, rowOrg : INTEGER;     wOrg, hOrg         : INTEGER;
0VAR success        : BOOLEAN);
 
"VAR   a               : LONGCARD;
(maxPnt          : Point;
(elems           : WindowBase.WdwElemSet;
(spec            : WindowBase.WindowSpec;
(oldGem          : RECORD
<active : BOOLEAN;
<hdl    : GemHandle;
:END;
 
"BEGIN
$oldGem.active := GemActive ();
$IF oldGem.active THEN oldGem.hdl := CurrGemHandle() END;
$
$IF Length (wName) > maxNameLen THEN wName[maxNameLen] := 0C END;
$
$IF windowRoot = noWindPtr THEN
&success := connectToGem ();
&IF ~ success THEN RETURN END;
$END;
$SetCurrGemHandle (gemHdl, success);
$
$SysAlloc (hdl, SIZE (hdl^));
$IF (hdl = NIL) OR ~ success THEN
&IF windowRoot = noWindPtr THEN deConnectFromGem END;
&success := FALSE;
&IF oldGem.active THEN SetCurrGemHandle (oldGem.hdl, voidO) END;
&RETURN
$END;
$SysAlloc (hdl^.redrawStr, newColumns + 1);
$IF hdl^.redrawStr = NIL THEN
&IF windowRoot = noWindPtr THEN deConnectFromGem END;
&success := FALSE;
&IF oldGem.active THEN SetCurrGemHandle (oldGem.hdl, voidO) END;
&DEALLOCATE (hdl, SIZE (hdl^));
&RETURN
$END;
$
$AESWindows.UpdateWindow (TRUE);
$setFont (StdFontHdl, StdFontHeight);
$getCharSizes (hdl);
$AESWindows.UpdateWindow (FALSE);
$WITH hdl^ DO
&fontHdl:= StdFontHdl;
&ctrlMode := interpretCtrl;
&echoMode := restrictedEcho;
&wrapAround := TRUE;
&initEscAutomat (escStatus);
&initEscAutomat (pipeEscStatus);
&closed := FALSE;
&bgCol := white;
&fgCol := black;
&revMode := FALSE;
&cursX := 0;
&cursY := 0;
&cursIndex := 0;
&noCursHides := 1;      (* Noch ist er aus *)
&textOrg := 0;
&columns := newColumns;
&rows := newRows;
&force := newForce;
&quality := qualities;
&enhanced := FALSE;
 
&createPipe (writePipe, success);
&IF ~ success THEN
(DEALLOCATE( hdl^.redrawStr, 0L);  (* !MS *)
(DEALLOCATE (hdl, 0L);
(IF windowRoot = noWindPtr THEN deConnectFromGem END;
(IF oldGem.active THEN SetCurrGemHandle (oldGem.hdl, voidO) END;
(RETURN
&END;
 
&redrawArea.w := 0;
 
&a := LONG (rows) * LONG (columns);
&IF a <= LONG (bufMax) THEN
(SysAlloc (buffer, a * TSIZE (bufferElem))
&END;
&IF (a > LONG (bufMax)) OR (buffer = NIL) THEN
(deletePipe (writePipe);
(DEALLOCATE( hdl^.redrawStr, 0L);  (* !MS *)
(DEALLOCATE (hdl, 0L);
(IF windowRoot = noWindPtr THEN deConnectFromGem END;
(success := FALSE;
(IF oldGem.active THEN SetCurrGemHandle (oldGem.hdl, voidO) END;
(RETURN
&END;
&
&elems := WindowBase.WdwElemSet {};
&IF titled IN qualities THEN INCL (elems, WindowBase.titleElem) END;
&IF movable IN qualities THEN INCL (elems, WindowBase.moveElem) END;
&IF dynamic IN qualities THEN
(elems := elems + WindowBase.WdwElemSet {WindowBase.sizeElem,
PWindowBase.scrollElem}
&END;
&IF closable IN qualities THEN INCL (elems, WindowBase.closeElem) END;
&WindowBase.SysCreateWindow (handle, elems,
Bupdate, checkSpec, scrollAmt, activated, close,
Bhdl);
&
&IF WindowBase.WindowState (handle) # WindowBase.okWdw THEN
(WindowBase.ResetWindowState (handle);
(DEALLOCATE (buffer, 0L);
(deletePipe (writePipe);
(DEALLOCATE (hdl^.redrawStr, 0L);        (* !MS *)
(DEALLOCATE (hdl, 0L);
(IF windowRoot = noWindPtr THEN deConnectFromGem END;
(success := FALSE;
(IF oldGem.active THEN SetCurrGemHandle (oldGem.hdl, voidO) END;
(RETURN
&END;
&WindowBase.GetWindowSpec (handle, spec);
&spec.virtual.w := LONGINT (LONG (columns)) * LONG (charW);
&spec.virtual.h := LONGINT (LONG (rows)) * LONG (charH);
&WindowBase.SetWindowSpec (handle, spec);
&setPosAndSize (hdl, colOrg, rowOrg, wOrg, hOrg);
&
&IF titled IN quality THEN
(WindowBase.SetWindowString (handle, WindowBase.titleWdwStr, wName)
&END;
&
&next := windowRoot;        (* Einketten *)
&windowRoot := hdl;
&magic := windowMagic;
&level := modLevel;
&clearScreen (hdl);
&IF noHideWdw = mode THEN
(myShow (hdl);
(success := WindowBase.WindowState (handle) = WindowBase.okWdw;
(WindowBase.ResetWindowState (handle);
(IF NOT success THEN Close (hdl) END;
&END;  (* 'Show' macht 'FlushEvents'  *)
&(*  Mu hier noch ein evtl. gesetzter Enhanced-Status abgemeldet werden
'*  oder sendet das GEM einen 'NewTop'-Event, bei dem dies erledigt wird?
'*)
$
$END;(*WITH*)
$
$IF oldGem.active THEN SetCurrGemHandle (oldGem.hdl, voidO) END;
"END Open;
 
 PROCEDURE SysOpen (VAR hdl           : Window;     columns, rows: CARDINAL;
7qualitys      : WQualitySet;mode         : ShowMode;
7force         : ForceMode;  wName    : ARRAY OF CHAR;
7colOrg, rowOrg: INTEGER;    wOrg, hOrg   : INTEGER;
3VAR success       : BOOLEAN);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -32(A3),-(A7)
(MOVE.L  -4(A3),-(A7)
(JSR     Open
(MOVE.L  (A7)+,A0
(MOVE.L  (A7)+,A1
(TST     (A0)
(BEQ     ende
(CLR.W   Window.level(A1)
&ende:
$END
"END SysOpen;
"(*$L=*)
 
 
 PROCEDURE ReSpecify (    hdl        : Window;
9newColumns,
9newRows    : CARDINAL;
9wName      : ARRAY OF CHAR;
5VAR success    : BOOLEAN);
"(*
#* TT: Wenn newColumns = 0, wird in "wName" ein Fontname und in "newRows"
#*     die gewnschte Gre in "Pts" erwartet. Ist "hdl" NIL, wird
#*     der Standard-Font damit definiert, sonst der fr das Fenster.
#*     Der Standard-Font wird bei allen neu erzeugten Fenstern verwendet.
#*)
 
"VAR     a       : LONGCARD;
*newAddr : ADDRESS;
*sizeChg : BOOLEAN;      (* Wurde Gre des Buffers verndert? *)
*spec    : WindowBase.WindowSpec;
*fontname: ARRAY [0..64] OF CHAR;
*fontnr  : CARDINAL;
*w, h, c : CARDINAL;
*ch      : CHAR;
*aespb   : GEMBase.AESPB;
*vdipb   : GEMBase.VDIPB;
*newFont : BOOLEAN;
*oldGem  : RECORD active: BOOLEAN; hdl: GemHandle; END;
 
"BEGIN
$IF notValid (hdl, TRUE) & ((hdl#NIL) OR (newColumns#0)) THEN RETURN END;
$
$newFont:= FALSE;
$IF newColumns = 0 THEN
&(*
'* Font setzen
'*)
&IF hdl = NIL THEN
(oldGem.active := GemActive ();
(IF oldGem.active THEN oldGem.hdl := CurrGemHandle() END;
(IF windowRoot = noWindPtr THEN
*success := connectToGem ();
*IF ~success THEN RETURN END;
(END;
(SetCurrGemHandle (gemHdl, success);
&END;
&GEMBase.GetPBs (gemHdl, vdipb, aespb); (* fr "GetFaceName" *)
&success:= FALSE;
&FOR fontnr:= 1 TO Fonts DO
(GetFaceName (device, fontnr, fontname);
(IF StrEqual (fontname, wName) THEN
*success:= TRUE;
*IF hdl = NIL THEN
,StdFontHdl:= vdipb.iooff^[0];
,SetTextFace (device, StdFontHdl);
,SetPtsTHeight (device, newRows, c, c, c, c); (* Gre setzen *)
,getCharSize (w, h, StdFontHeight, ch, ch);
,IF windowRoot = noWindPtr THEN deConnectFromGem END;
,IF oldGem.active THEN SetCurrGemHandle (oldGem.hdl, voidO) END;
,RETURN
*ELSE
,WITH hdl^ DO
.IF fontHdl # ORD (vdipb.iooff^[0]) THEN
0fontHdl:= vdipb.iooff^[0];
0newFont:= TRUE
.END;
.IF fontSize # newRows THEN
0fontSize:= newRows;
0newFont:= TRUE
.END
,END
*END
(END;
&END;
&IF ~newFont THEN
(IF hdl = NIL THEN
*IF windowRoot = noWindPtr THEN deConnectFromGem END;
*IF oldGem.active THEN SetCurrGemHandle (oldGem.hdl, voidO) END;
(END;
(RETURN
&END;
$END;
 
$IF Length (wName) > maxNameLen THEN wName[maxNameLen] := 0C END;
 
$WITH hdl^ DO
&sizeChg := (newColumns # columns) OR (newRows # rows);
&IF sizeChg THEN
(IF newFont THEN
*SetTextFace (device, fontHdl);
*SetPtsTHeight (device, newRows, c, c, c, c); (* Gre setzen *)
*getCharSizes (hdl);
(ELSE
*a := LONG (newRows) * LONG (newColumns);
*IF a <= LONG (bufMax) THEN SysAlloc (newAddr,a * TSIZE (bufferElem)) END;
*IF (a > LONG (bufMax)) OR (newAddr = NIL) THEN
,success := FALSE;
,RETURN
*END;
*DEALLOCATE (buffer, 0L);
*columns := newColumns;
*rows := newRows;
*buffer := newAddr;
*textOrg := 0;
*cursIndex := 0;
(END;
(
(WindowBase.GetWindowSpec (handle, spec);
(spec.virtual.w := LONGINT (LONG (columns)) * LONG (charW);
(spec.virtual.h := LONGINT (LONG (rows)) * LONG (charH);
(WindowBase.SetWindowSpec (handle, spec);
 
(IF newFont THEN
*WindowBase.RedrawWindow (handle);
(ELSE
*clearScreen (hdl);
(END;
(FlushEvents;              (* Mgl. zu redraw geben *)
&END;
&
&IF ~newFont & (titled IN quality) THEN
(WindowBase.SetWindowString (handle, WindowBase.titleWdwStr, wName)
&END;
&
$END;(*WITH*)
$success:= TRUE
"END ReSpecify;
 
 PROCEDURE Close (VAR hdl: Window);
 
"PROCEDURE delete (VAR ptr: ptrWindow; toDelete: ptrWindow);
 
$BEGIN
&IF ptr = NIL THEN HALT END;  (* Drfte nie vorkommen!! *)
&IF ptr = toDelete THEN
(ptr := toDelete^.next;
(DEALLOCATE (toDelete, 0L);
&ELSE delete (ptr^.next, toDelete) END;
$END delete;
 
"BEGIN
$IF notValid (hdl, FALSE) THEN RETURN END;
$
$WITH hdl^ DO
 (*
&IF NOT isHidden (hdl) THEN
((* evtl. 'ShrinkBox' *)
(WindowBase.CloseWindow (handle)
&END;
!*)
&WindowBase.DeleteWindow (handle);
&DEALLOCATE (buffer, 0L);
&DEALLOCATE (redrawStr, columns + 1);
&deletePipe (hdl^.writePipe);
&magic := 0L;
$END;
$
$delete (windowRoot, hdl);
$hdl := NIL; (* Ist wohl unntig, da es DEALLOCATE macht. *)
"
$FlushEvents;
$
$IF windowRoot = noWindPtr THEN deConnectFromGem END;
"END Close;
 
 PROCEDURE Hide (hdl: Window);
 
"BEGIN
$IF notValid (hdl, TRUE) THEN RETURN END;
$IF ~ isHidden (hdl) THEN
$
&WindowBase.CloseWindow (hdl^.handle);
&WindowBase.ResetWindowState (hdl^.handle);
&FlushEvents;
&
$END;
"END Hide;
 
 PROCEDURE Show (hdl: Window);
 
"BEGIN
$myShow (hdl);
$WindowBase.ResetWindowState (hdl^.handle);
"END Show;
 
 PROCEDURE GetPosAndSize (hdl: Window; VAR col, row, w, h: INTEGER);
 
"VAR   frame: Rectangle;
 
"BEGIN
$IF notValid (hdl, TRUE) THEN col := 0; row := 0 ; w := 0; h := 0; RETURN END;
$WITH hdl^ DO
&frame:= WindowBase.WindowWorkArea (handle);
&col:= (frame.x+INT(stdCharW) DIV 2) DIV INT(stdCharW);
&row:= (frame.y+INT(stdCharH) DIV 2) DIV INT(stdCharH);
&w:= (frame.w) DIV charW; h:= (frame.h) DIV charH;
$END
"END GetPosAndSize;
 
 PROCEDURE SetPosAndSize (hdl: Window; col, row, w, h: INTEGER);
 
"BEGIN
$IF notValid (hdl, TRUE) THEN RETURN END;
$
$setPosAndSize (hdl, col, row, w, h);
"END SetPosAndSize;
 
 PROCEDURE IsTop (hdl: Window): BOOLEAN;
 
"BEGIN
$IF notValid (hdl, TRUE) THEN RETURN FALSE END;
$
$RETURN isTop (hdl)
"END IsTop;
 
 PROCEDURE PutOnTop (hdl: Window);
 
"BEGIN
$IF notValid (hdl, TRUE) THEN RETURN END;
$
$WindowBase.PutWindowOnTop (hdl^.handle);
"END PutOnTop;
"
 PROCEDURE WasClosed (hdl: Window): BOOLEAN;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -4(A3),-(A7)
(MOVE.W  #TRUE,(A3)+
(JSR     isValid
(TST.W   -(A3)
(BNE     valid
(ADDQ.L  #4,A7
(MOVE.W  #FALSE,(A3)+
(BRA     ende
 valid
(
(MOVE.L  (A7)+,A0
(MOVE.W  window.closed(A0),(A3)+
(MOVE.W  #FALSE,window.closed(A0)
 ende
$END;
"END WasClosed;
"(*$L=*)
 
 
 VAR     spot       : Point;
(validBut   : BOOLEAN;
(
 PROCEDURE butCatcher (clicks  : CARDINAL;
6loc     : Point;
6buts    : MButtonSet;
6specials: SpecialKeySet): BOOLEAN;
 
"BEGIN
$spot := loc;
$validBut := TRUE;
$
$RETURN FALSE;
"END butCatcher;
 
 PROCEDURE DetectChar (REF targets: ARRAY OF Window; noTrg: CARDINAL;
:mode   : DetectMode;
6VAR p  : Point;
6VAR hdl: Window;      VAR column,row  : CARDINAL;
6VAR box: Rectangle;   VAR result      : DetectResult);
4
"VAR   oldGem  : GemHandle;
(success,
(doInit  : BOOLEAN;
(i       : CARDINAL;
(wdw     : WindowBase.Window;
(wbRes   : WindowBase.DetectWdwResult;
(
(proc    : EventProc;
:
"BEGIN
$(*  Init. exit val.s, for possible RETURN.
%*)
$result := foundNothing;
$hdl := noWindPtr;
$IF mode = requestPnt THEN p := Pnt (0, 0) END;
$
$(*  Test target validity.
%*)
$IF (noTrg = 0) OR (noTrg > (HIGH (targets) + 1)) THEN noTrg := HIGH (targets)
$ELSE DEC (noTrg) END;
$FOR i := 0 TO noTrg DO IF ~ isMagicOrNIL (targets[i]) THEN RETURN END END;
$
$(*  Init. GEM or set 'TW's gem handle.
%*)
$doInit := (windowRoot = noWindPtr);
$IF doInit THEN IF ~ connectToGem () THEN RETURN END;
$ELSE saveCurrHdl (oldGem) END;
$
$(*  get pos. if required.
%*)
$IF mode = requestPnt THEN
&proc.event := mouseButton;
&proc.butHdler := butCatcher;
&REPEAT
(HandleEvents(1, MButtonSet{msBut1}, MButtonSet{msBut1},
5lookForEntry, Rect(0,0,0,0), lookForEntry, Rect(0,0,0,0),
50L,
5proc, 0);
&UNTIL validBut;
&p := spot;
$END;
 
$i := 0;
$LOOP
$
&WindowBase.DetectWindow (targets[i]^.handle, 0, p, wdw, wbRes);
&
&IF wbRes = WindowBase.foundWdwDWR THEN
&
(result := foundWindow;
(hdl := targets[i];
(pointToCharPos (hdl, p, column, row, success);
(IF success THEN
*box := TransRect (Rect (0, 0, hdl^.charW, hdl^.charH),
<charToPointPos (hdl, column, row) );
*result := foundChar;
(END;
(
(EXIT
(
&ELSIF wbRes = WindowBase.unkownWdwDWR THEN result := foundWindow END;
&
&IF i >= noTrg THEN EXIT ELSE INC (i) END;
&
$END;
$
$IF doInit THEN deConnectFromGem ELSE restoreCurrHdl (oldGem) END;
"END DetectChar;
"
 
 (*  write proc.s  (only writing to the pipe) *)
 
 PROCEDURE Write (hdl: Window; ch: CHAR);
 
"VAR   oldGem: GemHandle;
"
"BEGIN
$IF notValid (hdl, TRUE) OR (ch = 0C) THEN RETURN END;
$saveCurrHdl (oldGem);
$
$insertIntoWritePipe (hdl, ch);
$
$restoreCurrHdl (oldGem);
"END Write;
 
 PROCEDURE WriteString (hdl: Window; REF str: ARRAY OF CHAR);
 
"VAR   oldGem: GemHandle;
 
"BEGIN
$IF notValid (hdl, TRUE) THEN RETURN END;
$saveCurrHdl (oldGem);
$
$insertIntoWritePipe (hdl, str);
$
$restoreCurrHdl (oldGem);
"END WriteString;
 
 PROCEDURE WriteLn (hdl: Window);
 
"BEGIN
$WriteString (hdl, twoChars{cr, lf});
"END WriteLn;
 
 PROCEDURE GotoXY (hdl: Window; column, row: CARDINAL);
 
"BEGIN
$WriteString (hdl, fourChars{esc, 'Y', CHR (ORD (space) + row),
@CHR (ORD (space) + column)});
"END GotoXY;
 
 PROCEDURE WritePg (hdl: Window);
"
"BEGIN
$WriteString (hdl, twoChars{esc, 'E'});
"END WritePg;
 
 PROCEDURE SetCtrlMode (hdl: Window; mode: CtrlMode);
 
"BEGIN
$IF notValid (hdl, TRUE) THEN RETURN END;
$hdl^.ctrlMode := mode;
"END SetCtrlMode;
 
 PROCEDURE SetEchoMode (hdl: Window; mode: EchoMode);
 
"BEGIN
$IF notValid (hdl, TRUE) THEN RETURN END;
$hdl^.echoMode := mode;
"END SetEchoMode;
 
 PROCEDURE EnhancedOutput (hdl: Window; start: BOOLEAN);
 
"VAR   str: ARRAY[0..1] OF CHAR;
 
"BEGIN
$str[0] := esc;
$IF start THEN str[1] := ctrlE ELSE str[1] := ctrlF END;
$WriteString (hdl, str);
"END EnhancedOutput;
 
 PROCEDURE FlushPipe (hdl: Window);
 
"BEGIN
$WriteString (hdl, twoChars{esc, ctrlP});
"END FlushPipe;
"
 
 (*  read proc.s  (flushing the pipe, before action) *)
 
 
 VAR     keyBuffer       : GemChar;
(specialsBuffer  : SpecialKeySet;
(keyBufferEmpty  : BOOLEAN;
 
 PROCEDURE keyProc (VAR ch: GemChar; VAR specials: SpecialKeySet): BOOLEAN;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3), A0
(MOVE.B  (A0), specialsBuffer
(MOVE.L  -(A3), A0
(MOVE.W  (A0), keyBuffer
(MOVE.W  #FALSE, (A3)+
(CLR     keyBufferEmpty
$END;
"END keyProc;
"(*$L=*)
 
 PROCEDURE timeProc (): BOOLEAN;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.W  #FALSE,(A3)+
$END;
"END timeProc;
"(*$L=*)
 
 PROCEDURE read (VAR ch: GemChar; VAR specials: SpecialKeySet): BOOLEAN;
 
"VAR     procs: ARRAY[1..2] OF EventProc;
*gotit: BOOLEAN;
 
"BEGIN
$IF keyBufferEmpty THEN
 
&procs[1].event := keyboard;
&procs[1].keyHdler := keyProc;
&procs[2].event := timer;
&procs[2].timeHdler := timeProc;
&HandleEvents (0, MButtonSet{}, MButtonSet{},
4lookForEntry, Rect (0,0,0,0), lookForEntry, Rect (0,0,0,0),
40L,
4procs, 0);
4
$END;
$
$ch := keyBuffer;
$specials := specialsBuffer;
$gotit:= NOT keyBufferEmpty;
$keyBufferEmpty:= TRUE;
 
$RETURN gotit
"END read;
 
 PROCEDURE AbortRead (hdl: Window);
"BEGIN
$(*!!! mu noch impl. werden!!!*)
$(* dabei beachten, da window auch geschlossen sein darf - dann
%*  keinen fehler melden!
%*)
"END AbortRead;
"
 
 PROCEDURE Read (hdl: Window; VAR ch: CHAR);
"
"VAR   wait   : BOOLEAN;
(gCh    : GemChar;
(voidSp : SpecialKeySet;
(noHides: CARDINAL;
(oldGem : GemHandle;
"
"BEGIN
$IF notValid (hdl, TRUE) THEN RETURN END;
$saveCurrHdl (oldGem);
$
$WITH hdl^ DO
&wait := NOT read (gCh, voidSp);
&IF wait THEN                (* Evtl. Cursor an und auf Zeichen warten *)
(noHides := noCursHides;
(IF echoMode = noEcho THEN
*noHides := 0
(ELSE
*noCursHides := 1;
*internalCursorOn (hdl);         (*  does also a flush  *)
(END;
(REPEAT UNTIL read (gCh, voidSp);
(IF noHides # 0 THEN
*internalCursorOff (hdl);        (*  does also a flush  *)
*noCursHides := noHides;
(END;
&END;
&ch := gCh.ascii;
&CASE echoMode OF
(noEcho         : |
(restrictedEcho : IF ch >= ' ' THEN Write (hdl, ch) END|
(fullEcho       : Write (hdl, ch)|
&END;
&IF wait THEN internalFlushPipe (hdl) END;
$END;
$restoreCurrHdl (oldGem);
"END Read;
 
 PROCEDURE Done (hdl: Window): BOOLEAN;
 
"BEGIN
$RETURN hdl^.done
"END Done;
 
 PROCEDURE moveX (no: INTEGER);
 
"BEGIN
$flushWritePipe (globHdl);
$setCursor (globHdl, INTEGER (globHdl^.cursX) + no, globHdl^.cursY)
"END moveX;
 
 PROCEDURE myWrite (c: CHAR);
 
"BEGIN
$insertIntoWritePipe (globHdl, c);
"END myWrite;
 
 VAR globLeadingBlanks: BOOLEAN;
 
 PROCEDURE rdCmd (VAR c: StringEditor.Commands; VAR ch: CHAR);
"VAR k: Key; again, isSep: BOOLEAN;
"BEGIN
$internalFlushPipe (globHdl);
$again:= FALSE;
$REPEAT
&GetKey (k);
&ch:= k.ch;
&c:= StringEditor.StdCmd (k);
&IF globToken THEN
(isSep:= ch IN MOSConfig.Separators;
(IF globLeadingBlanks THEN
*IF isSep THEN
,IF ch >= ' ' THEN
.myWrite (ch)
,END;
,again:= TRUE;
*ELSE
,globLeadingBlanks:= FALSE
*END
(ELSIF isSep THEN
*IF ch >= ' ' THEN
,myWrite (ch)
*END;
*c:= StringEditor.enter
(END
&END
$UNTIL ~again;
$globHdl^.done:= (c # StringEditor.abort);
"END rdCmd;
 
 PROCEDURE myWriteString (REF c: ARRAY OF CHAR);
"BEGIN
$insertIntoWritePipe (globHdl, c);
"END myWriteString;
 
 PROCEDURE myEditLine( VAR dStr: ARRAY OF CHAR; mayCtrl, token: BOOLEAN);
"BEGIN
$globToken:= token;
$globLeadingBlanks:= TRUE;
$WriteString (globHdl, twoChars{esc, ctrlE}); (* enhanced output on *)
$StringEditor.Edit (dStr, mayCtrl, myWrite, myWriteString, moveX, rdCmd);
$WriteString (globHdl, twoChars{esc, ctrlF}); (* enhanced output off *)
"END myEditLine;
 
 PROCEDURE EditLine (hdl: Window; VAR str: ARRAY OF CHAR);
 
"VAR   success     : BOOLEAN;
(i           : CARDINAL;
(ch          : GemChar;
(oldEnh      : BOOLEAN;
(oldEscStatus: escStatusDesc;
(oldGem      : GemHandle;
"
"BEGIN
$IF notValid (hdl, TRUE) THEN RETURN END;
$saveCurrHdl (oldGem);
$
$WITH hdl^ DO
$
&internalFlushPipe (hdl);
&oldEnh := enhanced;
&oldEscStatus := escStatus;
&enhanced := FALSE;
&initEscAutomat (escStatus);
&internalCursorOn (hdl);
&
&globHdl:= hdl;
&myEditLine (str, ctrlMode = writeCtrl, FALSE);
"
&internalCursorOff (globHdl);
&escStatus := oldEscStatus;
&enhanced := oldEnh;
$
$END;
&
$restoreCurrHdl (oldGem);
"END EditLine;
 
 PROCEDURE ReadLine (hdl: Window; VAR str: ARRAY OF CHAR);
 
"BEGIN
$str[0]:= 0C;
$EditLine (hdl, str)
"END ReadLine;
 
 PROCEDURE ReadString (hdl: Window; VAR str: ARRAY OF CHAR);
"(*$L-*)
"BEGIN
$ASSEMBLER
(JMP     ReadLine
$END
"END ReadString;
"(*$L=*)
 
 PROCEDURE ReadToken (hdl: Window; VAR str: ARRAY OF CHAR);
 
"VAR   success     : BOOLEAN;
(i           : CARDINAL;
(ch          : GemChar;
(oldEnh      : BOOLEAN;
(oldEscStatus: escStatusDesc;
(oldCtrlMode : CtrlMode;
(
(oldGem      : GemHandle;
"
"BEGIN
$IF notValid (hdl, TRUE) THEN RETURN END;
$saveCurrHdl (oldGem);
$
$WITH hdl^ DO
$
&internalFlushPipe (hdl);
&oldCtrlMode := ctrlMode;
&oldEnh := enhanced;
&oldEscStatus := escStatus;
&ctrlMode := interpretCtrl;
&enhanced := FALSE;
&initEscAutomat (escStatus);
&internalCursorOn (hdl);
&
&globHdl:= hdl;
&myEditLine (str, FALSE, TRUE);
&
&internalCursorOff (globHdl);
&escStatus := oldEscStatus;
&enhanced := oldEnh;
&ctrlMode := oldCtrlMode;
$
$END;
$
$restoreCurrHdl (oldGem);
"END ReadToken;
 
 PROCEDURE UndoRead;
"BEGIN
$keyBufferEmpty:= FALSE
"END UndoRead;
 
 
 PROCEDURE GetPos (hdl: Window; VAR column, row: CARDINAL);
"
"BEGIN
$IF notValid (hdl, TRUE) THEN row := 0; column := 0; RETURN END;
$
$column := hdl^.cursX; row := hdl^.cursY;
"END GetPos;
 
 PROCEDURE GetCtrlMode (hdl: Window; VAR mode: CtrlMode);
 
"BEGIN
$IF notValid (hdl, TRUE) THEN mode := interpretCtrl; RETURN END;
$mode := hdl^.ctrlMode;
"END GetCtrlMode;
 
 PROCEDURE GetEchoMode (hdl: Window; VAR mode: EchoMode);
 
"BEGIN
$IF notValid (hdl, TRUE) THEN mode := restrictedEcho; RETURN END;
$mode := hdl^.echoMode;
"END GetEchoMode;
"
 PROCEDURE ReadTextBuffer (    hdl    : Window;
>col,
>row,
>amount : CARDINAL;
:VAR buffer : ARRAY OF CHAR;
:VAR nextCol, nextRow: CARDINAL);
 
"VAR   effects    : effectSet;
(currElemPtr: ptrBufferElem;
(i, spaces,
(max        : CARDINAL;
 
"PROCEDURE insSpaces;
$
$BEGIN
&WHILE spaces > 0 DO
(buffer[i] := ' ';
(INC (i);
(DEC (spaces);
&END;
$END insSpaces;
$
"PROCEDURE ins (ch: CHAR);
"
$BEGIN
&insSpaces;
&buffer[i] := ch;
&INC (i);
&DEC (max);
$END ins;
$
"BEGIN
$IF notValid (hdl, TRUE) THEN RETURN END;
$
$internalFlushPipe (hdl);
$IF (amount = 0) OR (amount > HIGH (buffer)) THEN
&amount := HIGH (buffer)
$END;
$max := HIGH (buffer) + 1;
$
$spaces := 0;
$i := 0;
$effects := effectSet{}; (* !!! Stimmt das? Wohl nicht, aber wie besser?  *)
$WHILE (row < hdl^.rows) AND (amount > 0) AND (max > 0) DO
&
&IF col = hdl^.columns THEN
(IF row + 1 < hdl^.rows THEN
*IF max < 2 THEN max := 0
*ELSE
,ins (cr);
,ins (lf);
,col := 0;
,INC (row);
*END;
(ELSE max := 0 END;
&END;
(
&currElemPtr := ADR (hdl^.buffer^[textBufferIndex (hdl, col, row)]);
&
&WHILE (col < hdl^.columns) AND (amount > 0) AND (max > 0) DO
(
(IF effects # currElemPtr^.effects THEN
(
*effects := currElemPtr^.effects;
*IF max < 3 THEN max := 0 ELSE
,ins (esc);
,IF inverse IN effects THEN ins ('p') ELSE ins ('q') END;
*END;
*
(END;
(
(IF max > 0 THEN
*IF currElemPtr^.ch = ' ' THEN INC (spaces); DEC (max);
*ELSE ins (currElemPtr^.ch) END;
(END;
(INC (currElemPtr, SIZE (currElemPtr^));
(INC (col);
(DEC (amount);
(
&END;
&
&IF (amount = 0) AND (col < hdl^.columns) THEN insSpaces
&ELSE
(INC (max, spaces);
(spaces := 0;
&END;
$
$END;
$
$IF i <= HIGH (buffer) THEN buffer[i] := 0C END;
$nextCol := col;
$nextRow := row;
"END ReadTextBuffer;
"
 
 (*  window independent proc.s  *)
 
 PROCEDURE KeyPressed (): BOOLEAN;
 
 VAR     ch      : GemChar;
(gotone  : BOOLEAN;
(voidSp  : SpecialKeySet;
 
"BEGIN
$gotone:= read (ch, voidSp); (*  NICHT: 'valid:=read (keyBuffer)' wegen VAR-Parm.  *)
$keyBufferEmpty:= NOT gotone;
$RETURN gotone
"END KeyPressed;
 
 PROCEDURE CondRead (VAR ch: CHAR; VAR success: BOOLEAN);
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     read
(ADDQ.L  #2,A7
(MOVE.W  (A7)+,D1
(MOVE    -(A3),D0
(MOVE.L  -(A3),A0
(MOVE    D0,(A0)
(MOVE.L  -(A3),A0
(BEQ     c
(MOVE.B  D1,(A0)
(RTS
&c CLR.B   (A0)
$END
"END CondRead;
"(*$L=*)
 
 PROCEDURE BusyRead (VAR ch:CHAR);
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     CondRead
(ADDQ.L  #2,A7
$END
"END BusyRead;
"(*$L=*)
 
 PROCEDURE FlushKbd;
"(*$L-*)
"BEGIN
$ASSEMBLER
&c JSR     KeyPressed
(TST     -(A3)
(BEQ     ende
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     read
(ADDQ.L  #4,A7
(SUBQ.L  #2,A3
(BRA     c
&ende
$END
"END FlushKbd;
"(*$L=*)
"
 PROCEDURE GetChar (VAR ch: CHAR);
"VAR   gCh   : GemChar;
(voidSp: SpecialKeySet;
"BEGIN
$REPEAT UNTIL read (gCh, voidSp);
$ch:= gCh.ascii;
"END GetChar;
 
 PROCEDURE GetKey (VAR k: Key);
"VAR   gCh: GemChar;
(sks: SpecialKeySet;
"BEGIN
$REPEAT UNTIL read (gCh, sks);
$ASSEMBLER
(MOVE.L  k(A6),A0
(MOVE.W  gCh(A6),D1      ; |scan| asc|
(MOVE.B  sks(A6),D0
(LSR.B   #1,D0
(BCC     n
(BSET    #0,D0
%n: ANDI.B  #1111%,D0
(SWAP    D1
(CLR     D1
(ROL.L   #8,D1
(MOVE.L  D1,(A0)         ; | asc|   0|   0|scan|
(MOVE.B  D0,1(A0)
$END
"END GetKey;
 
 PROCEDURE GetGemChar (VAR ch: GemChar; VAR specials: SpecialKeySet);
"BEGIN
$REPEAT UNTIL read (ch, specials);
"END GetGemChar;
 
 
8(*  misc. managment  *)
8(*  ===============  *)
 
 PROCEDURE levelCounter (start, child: BOOLEAN; VAR id: INTEGER);
 
"VAR     ptr     : ptrWindow;
*again   : BOOLEAN;
"
"BEGIN
$IF child THEN
$
&IF start THEN
(INC (modLevel)
&ELSE
&
(REPEAT
*again := FALSE;
*ptr := windowRoot;
*LOOP
*
,IF ptr = NIL THEN EXIT END;
,IF ptr^.level >= modLevel THEN
.Close (ptr);
.again := TRUE;
.EXIT;
,END;
,ptr := ptr^.next;
,
*END;(*LOOP*)
(UNTIL ~ again;
(
(DEC (modLevel);
(
&END;(*IF start ELSE*)
&
$END;
"END levelCounter;
 
 PROCEDURE termProc;
 
"BEGIN
 (*$? TestVersion:
"Terminal.WriteString ("'TextWindows' terminating."); Terminal.WriteLn;
!*)
$(* Zum Zeitpunkt des Aufrufs dieser Proc, ist modLevel=0 *)
$levelCounter (FALSE,TRUE, voidI);(* Alle Elem. bis incl. modLevel=0 abmelden *)
"END termProc;
 
 PROCEDURE removalProc;
 
"BEGIN
 (*$? TestVersion:
"Terminal.WriteString ("'TextWindows' removing."); Terminal.WriteLn;
!*)
$(* Zum Zeitpunkt des Aufrufs dieser Proc, ist modLevel=0 *)
$levelCounter (FALSE,TRUE, voidI);(* Alle Elem. bis incl. modLevel=0 abmelden *)
"END removalProc;
 
 
 VAR     envlpProcHdl    : EnvlpCarrier;
(termProcHdl     : TermCarrier;
(removalProcHdl  : RemovalCarrier;
(wsp             : MemArea;
(
(ok              : BOOLEAN;
(
 BEGIN
"windowRoot := noWindPtr;
"modLevel := 1;
"
"stdMFDB.start := NIL;
"
"keyBufferEmpty:= TRUE;
 
"eventHandling := FALSE;
"
"installTimeProc (FlushEvents, 500);  (*  Alle 1/2 sec. 'FlushEvents'  *)
"
"SetEnvelope (envlpProcHdl, levelCounter, wsp);
"CatchProcessTerm (termProcHdl, termProc, wsp);
"CatchRemoval (removalProcHdl, removalProc, wsp);
 END TextWindows.
  
(* $FFEC5D1D$FFEBA329$0000871F$FFF749DC$FFF749DC$FFF749DC$FFF749DC$FFF749DC$FFF749DC$FFED5D35$FFF749DC$00000031$FFF749DC$00012F02$FFF749DC$0000C62F$FFF749DC$FFF749DC$FFF749DC$FFF749DC$FFF749DC$FFF749DC$FFF749DC$FFF749DC$FFE9E66C$FFF749DC$FFF749DC$FFF749DC$FFF749DC$FFF749DC$FFF749DC$00005522$FFF749DC$FFF749DC$0000DC62$FFF749DC$FFF749DC$FFF749DC$FFF749DC$FFEC5D1D$FFF749DC$FFF749DC$00007D20........T.......T.......T.......T.......T.......T.......T.......T.......T.......$00001C7B$00001C97$00007D67$00007D20$FFDF398E$00007BE8$FFDF398E$00007DC2$00007D20$00001CA9$00001BD9$FFDF398E$FFDF398E$00001CA9$00001C83$00001CA6*)
