DEFINITION MODULE GEMEnv;


(*      Megamax Modula-2 GEM Library: Diverse Kontrollfunktionen
 *
 *      Autor: Manuel Chakravarty       Erstellt: Mrz-Oktober 1987
 *
 *      Version 2.2     V#0062
 *)

(*      Mit den Routinen dieses Moduls kann sich eine Anwendung beim GEM
 *      An- und Abmelden, auerdem erfolgt hier die Anmeldung weiterer
 *      VDI-Gerte.
 *)
 
 
FROM GrafBase IMPORT Point, Rectangle;

FROM GEMGlobals IMPORT TEffectSet;


                        (*  Kontroll Funktionen  *)
                        (*  ===================  *)
                
                
TYPE    GemHandle;      (*  Dient zur Identifizierung einer kompletten
                         *  Anmeldung (per 'InitGem') beim GEM.
                         *  (GEM-Referenz)
                         *)

        DeviceHandle;   (*  Dient zur Identifizierung eines VDI-Gertes.
                         *  Siehe auch 'OpenDevice'. (Gerte-Referenz)
                         *)
                         
                         
CONST   NoDevice        = DeviceHandle (NIL);   (* Wert fr ein nicht besetz-
                                                 * tes Gerte-handle
                                                 *)

        NDC             = 0;             (*  Normalisierte Koordinaten  *)
        RC              = 2;             (*  Raster Koordinaten  *)


PROCEDURE InitGem (    sysKoor: CARDINAL;
                   VAR handle : DeviceHandle;
                   VAR success: BOOLEAN);

        (*  Anmeldung einer Application beim GEM und Erffnen einer
         *  virtuellen Bildschirmarbeitsstation.
         *
         *  'sysKoor' -- Bestimmt das zu benutzenden Koordinatensystem,
         *               dabei steht 'RC' fr Rasterkoordinaten und NDC
         *               fr normalisierte Koordinaten.
         *  'handle'  -- Liefert die Gertereferenz der virtuellen Bild-
         *               schirmarbeitsstation. Diese Referenz mu bei
         *               jedem VDI-Aufruf als erster Parameter angege-
         *               ben werden.
         *  'success' -- Meldet ob die Anmeldung erfolgreich verlaufen
         *               ist. Ist dies nicht der Fall, so ist auch der
         *               Wert von 'handle' ungltig.
         *
         *  Ein Aufruf dieser Prozedur sollte am Anfang jeder Benutzung
         *  der GEM Bibliothek stehen. Wird er nicht durchgefhrt, so
         *  kann es zum Absturz des Systems kommen.
         *  Alternativ kann aber, wenn keine VDI-Funktionen bentigt
         *  werden, 'InitApplication' (s.u.) aufgerufen werden.
         *
         *  Falls die Prozedur 'GemActive' den Wert 'TRUE' liefert,
         *  sind AES-Aufruf ohne jede Vorbereitung und VDI-Aufruf nach
         *  dem Erzeugen einer (virtuellen) Arbeitstation mit 'OpenDevice'
         *  ohne Benutzung von 'InitGem' mglich. Doch sollte
         *  diese Vorgehensweise nur in Ausnahmefllen gewhlt werden,
         *  da dann z.B. keine autom. Abmeldung von Fenstern u.. bei
         *  Prozessende durchgefhrt wird.
         *
         *  Die Variablen des Moduls 'PathEnv' werden zudem initialisiert:
         *
         *  'HomePath' wird in der Regel mit dem Pfad besetzt, von dem dies
         *  Programm stammt. Dies erlaubt dann z.B. die Verwendung von '*'
         *  (HomeSymbol) in Pfadlisten fr 'Paths.SearchFile'. Siehe dazu
         *  die Hinweise im PathEnv-Modul!
         *
         *  'SelectFile' erhlt je nach GEM-Version die Funktion 'SelectFile'
         *  bzw. 'SelectFileExtended' aus dem Modul 'AESMisc' zugewiesen.
         *
         *  ACHTUNG: Alle bisherigen GEM Versionen untersttzen nur
         *           Rasterkoordinaten um normalisierte Koordinaten
         *           benutzen zu knnen, mu das GDOS geladen werden.
         *)

PROCEDURE GemActive (): BOOLEAN;

        (*  Erfragt, ob ein anderes Modul schon einen 'InitGem'- oder
         *  'InitApplication'-Aufruf gettigt hat, d.h. ob ein benutz-
         *  barer 'GemHandle' vorhanden ist. (Siehe auch 'InitGem')
         *)

PROCEDURE ExitGem (VAR handle: GemHandle);

        (*  Dient zum Abmelden einer Application beim GEM.
         *
         *  Es werden autom. alle noch offenen Fenster geschlossen, alle
         *  angemeldeten Gerte beim VDI abgemeldet und eventuell noch
         *  nicht rckgnig gemachte 'HideCursor', 'WindowUpdate' etc.
         *  Aufrufe zurckgesetzt.
         *  Sobald ein Modul terminiert wird fr jedes auf dieser Modul-
         *  ebene durchgefhrten 'InitGem', welches noch nicht rckgngig
         *  gemacht wurde, ein 'ExitGem' durchgefhrt, dies gilt insbe-
         *  sondere fr Laufzeitfehler.
         *)


PROCEDURE InitApplication (VAR success: BOOLEAN);  (* "appl_init" *)

        (*  Wie 'InitGem', jedoch werden weder eine virtuelle "Workstation"
         *  mit 'OpenDevice' geffnet, noch die PathEnv-Variablen initiali-
         *  siert. Diese Funktion kann statt 'InitGem' aufgerufen werden,
         *  wenn keine VDI-Funktionen benutzt werden. Dies ist beispielsweise
         *  bei vielen Accessories der Fall. Die Abmeldung kann mit
         *  'ExitGem (gemHandle)', wobei 'gemHandle' die mit 'CurrGemHandle'
         *  erfragte Referenz enthalten mu oder mit 'ExitApplication'
         *  durchgefhrt werden.
         *)

PROCEDURE ExitApplication ();  (* "appl_exit" *)

        (*  Abmeldung der mit 'InitApplication' durchgefhrten AES-Anmeldung.
         *)


PROCEDURE GrafHandle (VAR charW, charH,
                          cellW, cellH: CARDINAL;
                      VAR hdl         : CARDINAL);

        (*  Ermittelt die VDI-Referenz, welche das AES bei seinem 'Open
         *  Workstation' Aufruf erhalten hat. Zustzlich werden noch die
         *  Ausmae eines Zeichens des Systemzeichensatzes zurckgegeben.
         *
         *  'charW', 'charH',
         *  'cellW', 'cellH'  -- Ausmae eines Zeichens des Systemzeichen-
         *                       satzes.
         *  'hdl'             -- VDI-Referenz des AES. Hiermit kann man
         *                       mit 'OpenDevice' weitere virtuelle Bild-
         *                       schirmarbeitsstationen erffnen.
         *
         *  ACHTUNG: Die Werte von 'charW', 'charH', 'cellW', cellH'
         *           werden vom GEM nicht korrekt geliefert. Daher
         *           ist von ihrer Verwendung abzuraten.
         *)


CONST   NonVirtual      = 0;    (*  Gert soll mit Open Workstation geffnet
                                 *  werden.
                                 *)

PROCEDURE OpenDevice (dev, sysKoor, mode: CARDINAL; VAR hdl: DeviceHandle);

        (*  Dient zum ffnen einer (virtuellen) Arbeitsstation.
         *
         *  Eingabeparameter:
         *  -----------------
         *
         *  'dev'     -- Gibt das zu ffnende Gert an. Entspricht der
         *               in 'ASSIGN.SYS' angegebenen Gertenummer.
         *  'sysKoor' -- Bestimmt das zu benutzenden Koordinatensystem,
         *               dabei steht 'RC' fr Rasterkoordinaten und NDC
         *               fr normalisierte Koordinaten.
         *  'mode'    -- Wird hier 'NonVirtual' angegeben, so wird ein
         *               eine neue Arbeitsstation erffnet. Wird aber
         *               das VDI-Handle einer Arbeitsstation (z.B. mit
         *               'GrafHandle' ermittelt) bergeben, so wird zu
         *               dieser Arbeitsstation eine virtuelle Arbeits-
         *               station geffnet.
         *
         *  Ausgabeparameter:
         *  -----------------
         *
         *  'hdl'     -- Die neue Gertereferenz. Sie mu bei jedem VDI-
         *               Aufruf, der an dieses Gert gehen soll als erster
         *               Parameter bergeben werden.
         *
         *  ACHTUNG: Das ffnen weitere nicht virtueller Arbeitsstationen
         *           ist nur mit geledenem GDOS mglich.
         *)
         
PROCEDURE CloseDevice (handle: DeviceHandle);

        (*  Die (virtuelle) Arbeitsstation wird geschlossen.
         *
         *  Bei einem Aufruf von 'ExitGem', werden alle Gerte, die unter
         *  dem abgemeldeten 'GemHandle' geffnet wurden autom. geschlossen.
         *)
         
        
TYPE    GDPAttribute = (lineOp, markerOp, textOp, fillOp, noAttribute,
                        notAvaible);
        GDPFkt       = (barGDP, arcGDP, pieGDP, circleGDP, ellipseGDP,
                        eArcGDP,  ePieGDP, rRectGDP, fRectGDP, jTextGDP);
        InputDev     = (keybd, other);
        DeviceType   = (outDev, inDev, inoutDev, reservedDev, metafile);
        ScreenType   = (noScreen, difCtrlDifScrn, difCtrlSamScrn,
                        samCtrlDifMem, samCtrlSamMem);
        TextRotType  = (noTextRot, step90, everyDirec);
        
        PtrDevParm   = POINTER TO DevParm;
        DevParm      = RECORD
        
                         (*  Diese 4 Werte entsprechen den von
                          *  'GrafHandle' gelieferten Werten.
                          *)
                         charWidth, charHeight,
                         cellWidth, cellHeight,
                         
                         (*  Breite und Hhe des Pixelrasters
                          *  [0..rasterWidth] und [0..rasterHeight]
                          *)
                         rasterWidth, rasterHeight,
                         
                         (*  Breite und Hhe eines Pixels in mm/1000
                          *)
                         pointWidth, pointHeight,
                         
                         (*  Anzahl der Schriftgren (0 bed. kontinuierlich)
                          *)
                         fontSizes,
                         
                         (*  Anzahl der Linienarten und -strken
                          *  (bei Letzterem bedeutet 0 kontinuierlich)
                          *)
                         lTypes, lWidths,
                         
                         (*  Anzahl der Makierungsarten und -gren
                          *  (bei Letzterem bedeutet 0 kontinuierlich)
                          *)
                         mTypes, mSizes,
                         
                         (*  Anzahl der verfgbaren Zeichenstze
                          *)
                         fonts,
                         
                         (*  Anzahl der Fllmuster und Schraffuren
                          *)
                         fPatterns, fHatchings,
                         
                         (*  Anzahl der gleichzeitig darstellbaren Farben
                          *)
                         noColors,
                         
                         (*  Minimale und maximale Zeichenbreite und -hhe
                          *)
                         minWChar, maxWChar,
                         minHChar, maxHChar,
                         
                         (*  Minimale und maximale Zeilenbreite
                          *)
                         minWRow, maxWRow,
                         
                         (*  Minimale und maximale Breite und Hhe
                          *  von Makierungen
                          *)
                         minWMark, maxWMark,
                         minHMark, maxHMark,
                         
                         (*  Anzahl der verfgbaren Hintergrundfarben
                          *)
                         bgColors,
                         
                         (*  Anzahl der Farbebenen (planes)
                          *)
                         maxRasterPls,
                         
                         (*  Anzahl der 16x16 Pixel Rasteroperationen pro sec.
                          *)
                         op16PerSec,
                         
                         (*  Anzahl der Schreibmodi
                          *)
                         noWrtModes,
                         
                         (*  Hchster Eingabemodus (0 ~ keine Eingabe,
                          *  1 ~ Nachfragemodus, 2 ~ Testmodus)
                          *)
                         maxInMode,
                         
                         (*  Maximale Anzahl von Punkten in einem
                          *  Punkte-Array und maximale Anzahl von
                          *  Zeichen in einem Zeichen-Array
                          *)
                         maxMarker, maxStrLen,
                         
                         (*  Anzahl der Mausknpfe
                          *)
                         noMButts,
                         
                         (*  Anzahl der Zeichenmodi fr verbreiterte Linien
                          *)
                         thickLnModes : CARDINAL;
                         
                         (*  Gibt die verfgbaren grafischen
                          *  Grundfunktionen an
                          *)
                         possibleGDPs : ARRAY GDPFkt OF GDPAttribute;
                         
                         (*  Folgende Flags bestimmen ob gewisse
                          *  Operationen mit dem beschriebenen
                          *  Gert mglich sind und zwar:
                          *)
                         color,         (*  Farbe                       *)
                         fill,          (*  Fllmuster                  *)
                         cArray,        (*  Cell-Arrays                 *)
                         zooming,       (*  Skalierung von Rastern      *)
                         lookUpTab,     (*  Color Look Up Table (CLUT)  *)
                         textJust,      (*  Textausrichtung             *)
                         contFill,      (*  contour fill                *)
                         penChange,     (*  Plotterstift austauschen    *)
                         colorRibbon,   (*  Farbband (Drucker)          *)
                         thickLnTyps    (*  verbreiterte Linientypen    *)
                                      : BOOLEAN;
                         
                         (*  Folgende Variable bestimmen das Eingabegert
                          *  fr diverse Arten der Eingabe und zwar fr:
                          *)
                         grafCCtrl,     (*  grafische Eingaben        *)
                         valueIn,       (*  Werteingaben              *)
                         caseIn,        (*  Auswahleingaben           *)
                         alphanumIn     (*  alphanumerische Eingaben  *)
                                      : InputDev;
                         
                         (*  Typ des beschriebenen Gertes
                          *)
                         deviceType   : DeviceType;
                         
                         (*  Art des Bildschirms
                          *)
                         screen       : ScreenType;
                         
                         (*  Untersttzte Texteffekte
                          *)
                         useTEffects  : TEffectSet;
                         
                         (*  Art der untersttzten Textrotation
                          *)
                         textRot      : TextRotType;
                         
                       END;
     
PROCEDURE DeviceParameter (handle: DeviceHandle): PtrDevParm;

        (*  Liefert die Gerteparameter eines geffneten Gertes.
         *
         *  'handle' -- Gertereferenz des Gertes von dem die Parameter
         *              ermittelt werden sollen.
         *)


PROCEDURE CurrGemHandle (): GemHandle;

        (*  Ermittelt die aktuelle GEM-Referenz ('GemHandle').
         *)

PROCEDURE SetCurrGemHandle (handle: GemHandle; VAR success: BOOLEAN);

        (*  Setzt die aktuelle GEM-Refrenz.
         *
         *  'handle'  -- Neu zu setzende GEM-Referenz.
         *  'success' -- Wird hier 'FALSE' geliefert, so ist 'handle'
         *               keine gltige GEM-Referenz und die aktuelle
         *               Refrenz wurde nicht verndert.
         *)
         

                        (*  Fehlerbehandlung  *)
                        (*  ================  *)

VAR     ErrorProc: PROC;

PROCEDURE GemError (): BOOLEAN;

        (*  Ermittelt, ob beim letzten Aufruf einer GEM-Routine ein
         *  Fehler aufgetretten ist.
         *
         *  Tritt ein Fehler auf, der nicht mittels dieser Prozedur
         *  erfragt wird, so ruft die GEM-Bibliothek beim nchsten
         *  Aufruf einer GEM-Routine die Prozedur 'ErrorProc' auf.
         *  Ist letztere von der Applikation nicht verndert worden,
         *  so wird die Modula-Standardprozedur 'HALT' aufgerufen.
         *)

PROCEDURE ErrorNumber (): INTEGER;

        (*  Ermittelt im Fehlerfall den Fehler auslsenden Wert.
         *
         *  Ist 'GemError () = TRUE', so liefert diese Funktion
         *  den INTEGER-Wert, der von der zuletzt benutzten ROM-
         *  Routine geliefert wurde, um den Fehler anzuzeigen.
         *)

VAR ErrHdlProc: PROC;

        (*  Wird bei Auftreten eines Fehlers aufgerufen.
         *  Die normalerweise hier installierte Routine tut nichts.
         *  Wenn aber ber die 'ErrorProc' der Fehler gemeldet wird,
         *  kann hierber herausgefunden werden, _wo_ der Fehler
         *  auftrat.
         *)


                        (*   Nachfragefunktionen  *)
                        (*   ===================  *)
         
PROCEDURE GEMAvailable (): BOOLEAN;

        (*  Erfragt, ob das GEM schon initalisiert ist.
         *
         *  Dies ist zum Beispiel bei Auto-Ordner-Programmen nicht der
         *  Fall.
         *  Solange diese Routine kein 'TRUE' liefert ist eine Anmeldung
         *  mittels 'InitGem' sinnlos.
         *)

PROCEDURE GDOSAvailable (): BOOLEAN;

        (*  Liefert 'TRUE', sobald ein GDOS-Treiber vorhanden ist.
         *  Bercksichtigt auch das GEM 2.1 (liefert dort immer TRUE).
         *)

PROCEDURE GEMVersion (): CARDINAL;

        (*  Liefert die Versionsnummer, die das GEM beim Anmelden einer
         *  Applikation zurckgibt.
         *
         *  Das zuerst von Atari ausgelieferte TOS und das Blitter-TOS
         *  liefern den Wert $120, das TOS 1.4 den Wert $140.
         *
         *  ACHTUNG: Damit diese Routine funktionieren kann mu die
         *           Funktionsprozedur 'GemActive' den Wert 'TRUE'
         *           liefern, also schon ein 'InitGem' durchgefhrt
         *           sein.
         *)

PROCEDURE ApplicationID (): CARDINAL;

        (*  Liefert die GEM-Identifikationsnummer der aktuellen
         *  GEM-Refrenz.
         *)

PROCEDURE MaxPoints (): CARDINAL;

        (*  Liefert die maximale Anzahl der Punkte, die in einem Aufruf
         *  von 'PolyLine', 'PolyMarker', etc. verarbeitet werden knnen.
         *  Ein Wert von 0 bedeutet, da die Anzahl nicht begrenzt ist.
         *)
         
         
(*   Jede der nachfolgenden Routinen erlaubtes einen Status abzufragen,
 *   der fr Module die ihrerseits andere GEM benutzende Module aufrufen
 *   von Interesse sein kann. Ist z.B. 'NoUpdateWindow () # 0', so ist
 *   es nicht mglich eine Menuzeile zu benutzen, man mu also erst die
 *   entsprechende Anzahl von 'UpdateWindow (FALSE)' durchfhren.
 *)
         
PROCEDURE NoHideCursor (device: DeviceHandle): CARDINAL;

        (*  Liefert die Anzahl der 'HideCursor'-Aufrufe, die noch nicht
         *  mit 'ShowCursor' rckgnig gemacht wurden.
         *)

PROCEDURE NoGrafMouseOff (): CARDINAL;

        (*  Liefert die Anzahl der 'GrafMouse (mouseOff, NIL)'-Aufrufe,
         *  die noch nicht mit 'GrafMouse (mouseOn, NIL)' rckgnig ge-
         *  macht wurden.
         *)

PROCEDURE NoUpdateWindow (): CARDINAL;

        (*  Liefert die Anzahl der 'UpdateWindow (TRUE)'-Aufrufe, die noch
         *  nicht mit 'UpdateWindow (FALSE)' rckgnig gemacht wurden.
         *)

PROCEDURE NoMouseControl (): CARDINAL;

        (*  Liefert die Anzahl der 'MouseControl (TRUE)-Aufrufe, die noch
         *  nicht mit 'MouseControl (FALSE)' rckgnig gemacht wurden.
         *)

PROCEDURE MouseInput (start: BOOLEAN);

        (*  Sorgt dafr, da der Mauszeiger, unabhnig von seinem aktuellen
         *  Zustand, sichtbar wird. Dies ist zum Beispiel vor dem Benutzen
         *  einer Dialogbox sinnvoll.
         *
         *  TRUE  -- Der Mauszeiger wird sichtbar
         *  FALSE -- Der Mauszeiger erhlt seinen alten Status wieder
         *
         *  HINWEIS: Diese Routine sollte normallerweise nicht benutzt
         *           werden. Sie ist systeminternen Funktionen vorbehalten.
         *)



PROCEDURE SysInitGem (    sysKoor: CARDINAL;
                      VAR handle : DeviceHandle;
                      VAR success: BOOLEAN);

PROCEDURE SysInitApplication (VAR success: BOOLEAN);

END GEMEnv.