 MODULE MM2Shell; (*$Z+,P+,V+,R-*)
 
 (*
!*----------------------------------------------------------------------------
!* Copyright Februar 1987 Thomas Tempelmann & Manuel Chakravarty
!*----------------------------------------------------------------------------
!* Modul-Beschreibung : GEM-Shell fr MOS / Megamax Modula-2
!*----------------------------------------------------------------------------
!* Version            : 2.3g        /     Interne Version: V#1806
!*----------------------------------------------------------------------------
!* MCH: Manuel Chakravarty
!* TT:  Thomas Tempelmann
!* MS:  Michael Seyfried, Unterer Mauergarten 17, D-W6520 Worms 24
!* DS:  Dirk Steins
!*----------------------------------------------------------------------------
!* Datum   Version  Autor  Bemerkung (Arbeitsbericht)
!*----------------------------------------------------------------------------
!* 22.02.87  0.0    TT/OJO Erstellung unter C aus MyShell v. Oliver Joppich
!* 24.02.87  0.0    TT     Erste lauffhige Version
!* 18.07.87  0.1    TT     Individuelle Pathlisten fr Compiler/Linker
!* 16.09.87  0.1    TT/MCH GEM-Moduln v. MCH; FileSelector nur bei GEM-Prgs.
!* 18.09.87  0.1    TT     FileSelect rettet/restauriert Screen bei TOS-Prgs.
!* 15.10.87  0.2    MCH    ShellShell
!* 07.11.87  0.2    MCH    Anpassung an GEM V 0.10
!* 23.12.87  0.3    MCH    'load' und 'unload' impl.
!* 24.12.87  0.3    MCH    Nachfolgendes von TT bernommen:
!* 05.10.87         TT     Scan mit Modul 'GEMScan'
!* 07.10.87         TT     berflssige Importe raus, Terminal.Write->Bconout
!* 16.10.87         TT     SplitPath/Name: set_names, call,
!* 13.11.87         TT     SetLinkName, GEMError nicht mehr importiert
!* 14.01.88  0.4    MCH    TT's UserBrk eingebunden.
!* 06.02.88  1.0a   TT     Fertigstellung der ersten auslieferbaren Version:
!*                           diverse Kommentierung; Akt.File bleibt bei Tool-
!*                           Aufruf erhalten; Taste 'R' fr Residente Module;
!*                           Klick auf Mem-Fenster toggled 'allMem';
!*                           viele kleine Optimierungen...
!* 19.02.88  1.0b   TT     Bei Prg-Start kann mit ALT-Taste der aktuelle Pfad
!*                           erhalten bleiben.
!* 01.03.88  1.0c   TT     'ShellMsg.TextName' enthlt "aktuelle Datei".
!* 14.04.88  1.0d   TT     SHELL.INF: mehrere inaktive LINK-Namen bestimmbar;
!*                           writeList nicht mehr rekursiv; readEntry: Compare
!*                           mit '..' optimiert.
!* 15.05.88  1.0e   TT     Prozedur 'fastCompare' neu. Desktop wird wiederher-
!*                           gestellt nach CALL-Anweisung in SHELL.INF
!* 28.05.88  1.0f   TT     Mit 'ESC' kann Laden von Modulen beim Starten unter-
!*                           drckt werden; MouseInput(TRUE) und ShowMouse
!*                           (TRUE) bei Rckkehr aus Programm in Shell; Bei
!*                           Code-Filter werden DEF-Module nicht ausgegeben.
!* 01.06.88  1.1    TT     Linker-Optionen erweitert fr optimierenden Linker;
!*                           LinkStackSize kann nun > 64KB sein.
!* 09.06.88         TT     "Upper (LinkList[i].name)" aus "doLinkOptBox" ent-
!*                           fernt.
!* 25.06.88  1.1b   TT     "FastStrings" verwendet, einige Copy-Aufrufe durch
!*                           Delete ersetzt.
!* 19.07.88  1.2    MCH    Auslagerung von 'EasyGEM0'
!* 20.07.88  1.2    MCH    Alle Module die nur in 'ShellShell' gebraucht
!*                         werden, werden qualifiziert importiert.
!*                         Auslagerung von 'forceDeskRedraw' und
!*                         'redrawDeskObj0' in 'EasyGEM0'
!* 27.07.88  1.3    MCH    Benutzung von 'WindowLists'
!* 28.07.88  1.3    MCH         "     "         "
!* 03.08.88  1.3b   MCH    'dragSensitive' + Anfang der Selektierung
!* 04.08.88  1.3c   MCH    Selektierung mit Draggen funktioniert
!* 07.08.88  1.4    MCH    Benutzung der Funktionen fr komplexere Dialog-
!*                         boxen aus 'EasyGem0'
!* 17.08.88  1.5    MCH    Neue Resource
!* 22.08.88  1.5    MCH    Neue Resource + "Formatieren" begonnen
!* 24.08.88  1.5    MCH    "Formatieren" fertig + 'makeFolder' +  kopieren
!*                         + lschen
!* 25.08.88  1.5    MCH    Schnheitsoperationen beim Kopieren und Lschen
!* 27.08.88  1.5    MCH    Fileinformation
!* 28.08.88  1.5    MCH    Editor-Parameter-Box
!* 29.08.88  1.6    MCH    Parameter sichern und laden
!* 30.08.88  1.7    MCH    Shelling
!* 31.08.88  2.0    MCH    Vorversion fr die Atari-Messe ('88)
!* 01.12.88  2.0    MCH    Neues 'WindowLists' V0.07
!* 05.12.88  2.0    MCH    Rausschmi der 'selected'-Liste (WL V0.08)
!* 13.12.88  2.0    MCH    Erweiterung auf 10 Arbeitsdateien
!* 26.12.88  2.0    MCH         "       "  "        "
!* 27.12.88  2.0    MCH         "       "  "        "
!* 19.01.89  2.0    MCH    Kleine nderungen
!* 26.01.89  2.0    MCH    Kleine nderungen
!* 01.02.89  2.0    MCH    Schnellerer Fenster-Redraw
!* 11.02.89  2.0    MCH    Batch-Erweiterung
!* 12.02.89  2.0    MCH    Aligning der Icons macht nun round und nicht trunc
!* 14.02.89  2.0    MCH    Temporre Editor-Parameter-Dateien
!* 06.03.89  2.0    MCH    Kein doppelter Backslash im Parameterpfad
!* 04.06.89  2.0    MCH    Parameter-file-name wird aus der Argumentzeile
!*                         bernommen und beim Verlassen autom. Speicherung
!*                         des Parm.-files.
!* 07.06.89  2.0    MCH    Drive.Icons werden richtig deselektiert + Kopieren
!*                         in einen Ordner im gleichen Fenster fkt. richtig.
!* 13.06.89  2.0    MCH
!* 19.06.89  2.0    MCH    nderungen von TT bernommen: pathSize auf 64 ge-
!*                         setzt.
!* 05.07.89  2.0    MCH    Quick-Quit
!* 03.08.89  2.0    MCH    Dir.-Eintrge werden jetzt immer richtig sortiert
!* 05.08.89  2.0    MCH    Der Default-Code-Pfad fr neue Arbeitsdateien wird
!*                         jetzt mit Hilfe von 'Paths' ermittelt. Und eine neu
!*                         erzeugtes Arbeitsdatei-Objekt wird zum Aktuellen.
!* 06.08.89  2.0    MCH    Arg.-Zeile wird gemerkt; Kein Copy auf selektierte
!*                         Eintrge; Default-Code-Pfad erst beim Starten er-
!*                         mitteln; FileBox enthlt bei Arbeitsdateien default-
!*                         mig den aktuellen Source-Namen
!* 07.08.89  2.0    MCH    'Loader.DefaultStackSize' in M2P sichern; LOAD
!*                         in M2B's verndert Default-Pfad nicht mehr;
!*                         Bei COMPILE in Batch-Dateien ist im Fehlerfall
!*                         das Edieren des Files mglich
!* 10.08.89  2.0    MCH    'HelpBox' und 'InfoBox' impl.; es kann wieder in
!*                         Ordner kopiert werden; Zielfenster wird nach
!*                         kopieren wieder neugezeichnet.
!* 11.08.89  2.0    MCH    'HelpBox' debugging; Shift-F1..10 funktioniert;
!*                         Es wird auch beim Ausfhren von Source-Files nach
!*                         einem evtl. existierende Code gesucht.
!* 16.08.89  2.0e   MCH/TT nderungen von TT bernommen; Editor comp. Datei
!*                         bei exec. nur wenn ntig; Res.Mod. anklicken
!*                         => akt.Code setzen; 'LastCodeName/Size' impl.
!* 17.08.89  2.0f   MCH    Make eingebunden und ein paar bugs beseitigt;
!*                         beim Dir. ffnen gilt rechter Mausknopf wie
!*                         Shift; nur on line drives werden angezeigt;
!*                         'WrapAlert' aus 'EasyGem0'
!* 19.08.89  2.0g   MCH    Pfadlisten werden richtig gelscht und besetzt;
!*                         'MakeFileName' in Umgebungs-Box; 'SearchFile'
!*                         wird auf 'LibFileName' angewendet.
!* 22.08.89  2.1    TT     nderungen von TT bernommen; alle Pfade validiert;
!*                         Source-Suffices aus ShellMsg importiert; MBT->M2B;
!*                         MSP->M2P; callEdit schaltet Ctrl-C temporr ab.
!* 23.08.89         TT     args werden nur verwendet, wenn sie auch explizit
!*                         eingegeben wurden
!* 31.08.89         TT     'PrepareScan' setzt 'ScanOpts'
!* 03.09.89         TT     Wenn Fehler beim ffnen von Dir auf akt. Pfad
!*                         wird Wurzel geffnet.
!* 06.09.89  2.1c   TT     KbdEvents wird whrend Shell-Dialog aktiviert
!* 11.09.89  2.1d   TT     KbdEvents wird anders aktiviert; neue Batch-Cmds;
!*                         call-Funktion verbessert -> nun wird immer der
!*                         Code-Pfad als akt. Pfad gesetzt, wenn nicht
!*                         'noDirChange'.
!* 14.09.89  2.1e   TT     Editor-Parms: Toolbox-Flag raus, stattdessen
!*                         Flag f. Box-Anzeige nach Comp-Fehler; Editor
!*                         kann nun auch mit leerem Dateinamen gestartet
!*                         werden;
!* 20.09.89  2.1f   TT     Tool-Namen werden mit Endung angezeigt;
!*                         Tools und Systemprgs erhalten akt. Pfad, wenn
!*                         kein extra-Pfad angegeben ist;
!*                         Eventuelles 'HomeSymbol' in shellParm.batchPath,
!*                         editorParm.tempEditorName/tempShellName,
!*                         TemporaryPath u. DefLibName wird beim Lesen der
!*                         Parameter durch Shell-Homepath ersetzt;
!*                         Code-Suche in hdrun.getCodeDateTime korrigiert
!* 11.01.90  2.1g   TT     Inconsistent-Abfrage nach CallModule
!* 15.01.90         TT     insertDirEntry: subDir-Aufruf durch Inline ersetzt;
!*                         Reihenfolgen in RECORDs, die auf Disk gesichert
!*                         werden verndert. ForceMediaChange-Aufruf
!* 17.01.90         TT     CompilerParm nach ShellMsg bertragen
!* 28.02.90         TT     Rsc um CompilerArgs erweitert, auch in M2P;
!*                         initWorkfile nach LoadParameter aufgerufen;
!*                         Real-Format in Env-Box angezeigt, Rsc: alle ber-
!*                         schriften mit Schattenbreite 2, Buttons verkleinert.
!* 14.03.90  2.1h   MCH    Verhalten beim Selektieren dem Desktop angeglichen;
!*                         Compile-Execute auf Plus-Taste; ALT-e/c/l rufen
!*                         Editor-, Compiler- bzw. Linker-Box auf; Beim Ende
!*                         eines Help-Textes wir der Abbruch-Button zum Default;
!*                         Keine Fehlermeldung mehr, falls in Parm.-Datei ein
!*                         leerer Batchpfad gesetzt ist; Ausfhren setzt
!*                         aktuellen Code jetzt richtig
!* 16.03.90         TT     Compiler, Editor, Make und Linker erhalten feste
!*                         StackSize beim Start
!* 01.05.90  2.1i   TT     'HomePath' wird nicht mehr dauerhaft ersetzt, sondern
!*                         nur jeweils bei Benutzung, soda ein '*' im Pfad
!*                         dort erhalten bleibt; (Siehe "!TT")
!*                         Conditionals fr KbdEvents-Aufrufe; HomePath wird
!*                         durch ShellRead ermittelt; ELSE teilw. bei CASE;
!*                         'getFname' gelscht, weil totaler Mist; In den
!*                         Umgebungsinfos kann bestimmt werden, ob nach Ende
!*                         eines nicht-GEM-Prgs auf einen Tastendruck gewartet
!*                         werden soll; Pfadname der M2P-Datei wird immer
!*                         korrekt eingesetzt.
!* 28.05.90  2.1j   TT     'call' bercksichtigt 'HomePath', wenn er im Prg-
!*                         namen vorkommt.
!* 30.05.90         TT     Batch-Dateien werden nun auf den Default-Pfaden
!*                         gesucht
!* 14.06.90         TT     Im Init-Teil vom lokalen Modul 'ShellShell' knnen
!*                         nun zentral alle Dateiendungen definiert werden.
!* 16.06.90  2.1k   TT     Batch-Befehle DEFOUT, IMPOUT, MODOUT
!* 12.08.90         MCH    ShellRead wieder eingesetzt
!* 05.10.90  2.1l   MCH    nderungen bernommen
!* 07.10.90  2.1m   MCH    Noch mehr nderungen bernommen
!* 24.10.90  2.1n   TT     $W- raus und 'alert' entspr. korrigiert; Anpassung
!*                         an neuen FormatDrive-Typ.
!* 20.11.90  2.1o   TT     Anpassung an neuen Loader ohne Stacksize-Parm;
!*                         M2P wird auf HomePath gesucht und weitere Korrekturen
!*                         in ShellShell-Body.
!* 01.12.90  2.1p   MCH    Benutzt neue 'EasyGEM0'-Routinen; das Starten von
!*                         Tools, die einen leeren Dateinamen besitzen wird
!*                         ignoriert; EXEC-Batch-Befehl funktioniert auch auf
!*                         Batch-Dateien; 'ShellGet'-Buffer ist jetzt auch fr
!*                         den TT ausreichend; Icons werden autom. in den
!*                         sichtbaren Teil des Desktop-Koor.systems gebracht.
!* 11.12.90  2.2    TT     FormError-Aufruf bei bestimmten Exitcodes ('call');
!*                         TermProcess (fInsufficientMemory), wenn InitSS
!*                         fehlschlgt; ShellName bei ShellWrite zurckgesetzt,
!*                         Flag 'DoShellWrite'; TermProcess (0), wenn keine RSC
!* 07.04.91  2.2b   TT     Hhe der Menzeile korrigiert; ACCs werden vor/nach
!*                         Start von Programmen geschlossen; FileInformation
!*                         geht auch bei Ordnern; 'installDriveIcons' wird
!*                         nun erst nach Ausfhren der Shell-Batch-Datei
!*                         durchgefhrt, das hat den Vorteil, da nun im
!*                         Batch temporr eine RAMDisk installiert werden kann;
!*                         Batch-Befehle "POSTAMBLE1/2" zum Starten von Prgs
!*                         vor Verlassen der Shell; Codename von Workfiles wird
!*                         nun immer korrekt behalten; beim Formatieren wird
!*                         nun das richtige Laufwerk ausgewhlt.
!* 20.05.91  2.2d   TT     Bei manueller Arbeitsdateieingabe wird die Datei
!*                         auf den Source-Pfaden gesucht.
!* 20.10.91  2.3    TT     Linker-Option-Box ermglicht Symboldatei-Erzeugung.
!*                  MS     Shell nun MultiGEM-fhig, dazu 'call' berarbeitet.
!* 22.05.93  2.3b   TT     Shell nun MultiTOS-fhig.
!* 15.07.93  2.3c   DS     Shell nun wirklich MultiTOS-fhig. Die Shell mit den
!*                         nderungen von TT lief bei mir nicht unter MTOS.
!*                         Wichtigste nderung: Unter MTOS wird kein ShelWrite
!*                         mehr vor einem Programmstart durchgefhrt, da das
!*                         Programme direkt startet. Weiterhin wird der
!*                         GEMErrorHandler ausgeschaltet, da dieser anscheinend
!*                         unter MTOS fehlerhaft ist.
!*                         Alle Laufwerke werden angezeigt, auch die, die nicht
!*                         im DESKTOP.INF (bzw. NEWDESK.INF) drin sind.
!*                         Stacksize fr Linker erhht, da ich ein Programm
!*                         nicht mehr linken konnte.
!*                         Ganz sauber luft die Shell brigens noch immer nicht
!*                         unter MTOS, nach dem Linken hngt das System und auch
!*                         kann es ab und zu nach dem Compiler oder Make zu
!*                         Hngern kommen.
!* 12.12.93  2.3d   TT     Nochmalige berarbeitung der V2.3c f. MultiTOS.
!* 14.01.94  2.3e   TT     Font kann nun in Shellparms eingestellt werden.
!* 29.03.94  2.3f   TT     Nun werden alle Laufwerke v. A bis Z bercksichtigt.
!*----------------------------------------------------------------------------
!*)
 
 
 (*  Qualified imports for 'ShellShell'  *)
 
 IMPORT Clock, ModCtrl, TimeConvert,
'FileManagement,
 
'GEMBase, AESMisc,
'GrafBase, GEMGlobals, GEMEnv,
'AESForms, AESObjects, AESWindows, AESResources, AESGraphics, AESMenus,
'AESEvents,
'VDIControls, VDIOutputs, VDIAttributes, VDIInquires,
'ObjHandler, EventHandler, TextWindows, EasyGEM0, EasyGEM1, WindowLists;
 
 
 FROM SYSTEM     IMPORT LONGWORD, WORD, ADDRESS, BYTE,
7ASSEMBLER, ADR, LOAD, STORE;
 
 IMPORT Mm2shellRsc;  (* RSC-Datei *)
 
 FROM RealCtrl   IMPORT AnyRealFormat, UsedFormat;
 
 FROM StrConv    IMPORT CardToStr, IntToStr, StrToLCard, StrToCard,
7StrToInt, LHexToStr;
 
 FROM Loader     IMPORT LoaderResults, DefaultStackSize,
7LoadModule, CallModule, UnLoadModule;
 
 FROM PathEnv    IMPORT HomeReplaced, HomeSymbol, ReplaceHome, HomePath;
 FROM PathCtrl   IMPORT PathList;
 FROM Paths      IMPORT SearchFile, ListPos;
 
 FROM Storage    IMPORT ALLOCATE, DEALLOCATE, MemAvail, AllAvail, Inconsistent;
 
 FROM Strings    IMPORT PosLen, String, Relation, Compare, Space, Upper, Empty,
7EatSpaces, Append, StrEqual, Delete, Concat, Assign,
7Split, Insert, Length, Copy, Pos;
 
 IMPORT Lists;
 
 IMPORT SysUtil0;
 
 FROM MOSConfig IMPORT StdDateMask;
 IMPORT MOSConfig;
 
 IMPORT MOSCtrl, MOSGlobals;
 
 FROM MOSGlobals IMPORT MemArea, BusFault, OddBusAddr, NoValidRETURN,
7OutOfStack, FileStr, PathStr, NameStr,
7fOK, fFileNotFound, fDriveNotReady, fWriteProtected,
7fPathNotFound, fInvalidDrive, fAccessDenied,
7fTooManyOpen, fInsufficientMemory, fEOF;
 
 FROM ShellMsg   IMPORT ScanMode, ScanAddr, TextName, ErrorMsg, DefPaths,
7ModPaths, ErrListFile, ImpPaths, SrcPaths, DefSfx,
7ImpSfx, ModSfx, CodeName, Active, LinkDesc,
7LLRange, ScanIndex, TextLine, TextCol,
7MakeFileName, TemporaryPath, MainOutputPath,
7DefLibName, DefOutPath, ImpOutPath, ModOutPath,
7ShellPath, ImpSrcSfx, ModSrcSfx, DefSrcSfx, CodeSize,
7StdPaths, CompilerArgs, CompilerParm, ScanOpts,
7LinkMode, LinkerParm, EditorParm;
 
 FROM Directory  IMPORT FileAttr, FileAttrSet, DirEntry, DirQueryProc,
7SetCurrentDir, GetCurrentDir, DefaultDrive,
7DirQuery, SetDefaultDrive, DrivesOnline,
7CreateDir, GetDefaultPath, SetFileAttr,
7ForceMediaChange, MakeFullPath, SetDefaultPath,
7FreeSpace;
 
 FROM FileNames  IMPORT StrToDrive, SplitPath, SplitName, DriveToStr,
7NameConc, ValidatePath, ConcatPath, ConcatName,
7FileName, FilePath;
 
 FROM Files      IMPORT File, Access, ReplaceMode,
7Create, Open, Close, State, ResetState, GetStateMsg,
7Remove, EOF, SetDateTime, GetDateTime;
 
 FROM Binary     IMPORT ReadBlock, ReadBytes, WriteBlock;
 
 IMPORT Text;
 
 FROM GEMScan    IMPORT InputScan, CallingChain, ChainDepth;
 
 FROM PrgCtrl    IMPORT EnvlpCarrier,
7SetEnvelope, TermProcess;
4
 FROM SysTypes   IMPORT ExcDesc, ExcSet, TRAP5;
 
 FROM Excepts    IMPORT InstallPreExc;
 
 FROM SysBuffers IMPORT ExceptsStack;
 
 FROM UserBreak  IMPORT EnableBreak, DisableBreak;
 
 FROM EasyGEM0   IMPORT WrapAlert;
 
 FROM KbdEvents  IMPORT DeInstallKbdEvents, InstallKbdEvents;
 
 FROM TextWindows IMPORT BusyRead;
 
 FROM EasyGEM0   IMPORT SetGetMode, ShowArrow, HideMouse, ShowMouse;
 
 FROM AESForms   IMPORT FormError, FormAlert;
 
 
 CONST   DebugWdw = FALSE; (* Flag zur Fehlersuche (Debug-Fenster) *)
 
((* Versionskennung der Shell.
)*)
(ShellRevision           = ' 2.3g ';
 
((*
)* Ist die folg. Konstante TRUE, wird das Modul "KbdEvents"
)* verwendet, das dafr sorgt, da Tastendrcke, bei denen
)* Shift, Control oder Alternate gedrckt werden, immer richtig
)* erkannt werden.
)* Andernfalls kann es passieren, da diese Umschalttasten
)* ignoriert werden, wenn die gewnschte Aktion erst nach
)* dem Tastendruck gestartet wird.
)* Siehe auch Hinweise im Definitions-Text des Moduls
)*)
(UseExtKeys = TRUE;
 
((*
)* Ist die folg. Konstante TRUE, startet die Shell GEM-Programme
)* korrekt mit der AES-Funktion "ShellWrite", sofern TOS 1.4
)* oder hher verwendet wird. Dies kann aber zu Problemen fhren,
)* beispielsweise, wenn die Shell von NEODESK gestartet wird,
)* weshalb sie dazu auf FALSE gesetzt werden kann.
)*)
(DoShellWrite = TRUE;
 
((*
)* Stack-Gren fr die Systemprogramme. Sie sollten vergrert
)* werden, wenn bei einem der Programme ein "Stackberlauf"
)* auftritt.
)*)
(CompilerStackSize = 16000;
(LinkerStackSize = 16000;
(EditorStackSize = 16000;
(MakeStackSize = 8000;
 
((*
)* Maximale Anzahl von Suchpfaden, die in einer Batch-Datei
)* definiert werden knnen. Ist zu erhhen, wenn beim Starten
)* der Shell oder eines Batches eine diesbezgliche Fehler-
)* meldung erscheint.
)*)
(MaxSearchPaths = 40;
 
((*
)*  Name der Datei in der alle zu compilierenden Module
)*  vom Make abgelegt werden. Das Verzeichnis (Pfad), in dem
)*  diese Datei erzeugt wird, ist der "temporre Pfad", der
)*  in der Shell-Parameter-Box anzugeben ist!
)*)
(MakeCompFileName        = 'MAKE.M2C';
 
 
 TYPE    actionType      = (doEdit, doComp, doLink, doExec, doScan, doCpEx,
;doLoad, doUnLd, doCont, doBtch, doParm, doMake,
;doMkEx, doDftM);
(MySuf           = (prg, app, tos, ttp, mos, mtp, mod, def, imp, m2p,
;m2b, m2m, m2d);
 
(Str128          = ARRAY [0..127] OF CHAR;
 
(ptrString       = POINTER TO String;
 
(PathEntry       = POINTER TO PathStr;
 
(Drive = ( defaultDrv, drvA, drvB, drvC, drvD, drvE, drvF, drvG,
2drvH, drvI, drvJ, drvK, drvL, drvM, drvN, drvO, drvP,
2drvQ, drvR, drvS, drvT, drvU, drvV, drvW, drvX, drvY, drvZ);
 
(DriveSet = SET OF [drvA..drvZ];
 
 
 VAR     lastFn, currFn,
(workFName, workCName       : FileStr;
(args                       : ARRAY[0..127] OF CHAR;
 
(suf: ARRAY MySuf OF ARRAY [0..2] OF CHAR;
 
 
0(*  Konfigurationsvariablen  *)
0(*  =======================  *)
 
(shellParm       : RECORD
<breakActive       : BOOLEAN;
<confirmDelete     : BOOLEAN;
<confirmCopy       : BOOLEAN;
<defaultOpenCurrDir: BOOLEAN;
<useAllMemForCopy  : BOOLEAN;
<batchPath         : PathStr;
<parameterPath     : PathStr;
<sectors           : CARDINAL;
<tracks            : CARDINAL;
<sides             : CARDINAL;
<makeName          : String;
<waitOnReturn      : BOOLEAN;
:END;
 
(fontSetting: RECORD
7name: ARRAY [0..31] OF CHAR;
7size: CARDINAL
5END;
 
(noDirChange: BOOLEAN;
 
 PROCEDURE conc ( REF s1,s2: ARRAY OF CHAR ): Str128;
"VAR s: Str128;
&voidO: BOOLEAN;
"BEGIN
$Concat (s1,s2,s, voidO);
$RETURN s
"END conc;
 
 
 FORWARD action (what:actionType;wrkFile,tool:BOOLEAN);
 
 FORWARD FileAlert (errNo: INTEGER);
 FORWARD SaveParameter;
 FORWARD LoadParameter (REF name: ARRAY OF CHAR);
 FORWARD ExecuteBatch (name: ARRAY OF CHAR; load: BOOLEAN);
 
 
 MODULE ShellShell;      (* Verwaltet alle GEM-Aktionen der Modula Shell *)
 
 
 IMPORT Text, SysUtil0,
 
'DebugWdw,   (*  debug flag  *)
'
0(*  resource indicies  *)
*
'Menu, Mibox, Mshell, Mdatei, Mparms, Minfo,
'Mtools, Dinfo, Mdinfo, Mdfolder, Mdformat, Mdclose,
'Mdclosew, Mdnwork, Mdkwork, Mdquit, Mpshell, Mpeditor,
'Mpcomp, Mplink, Mpsave, Mienv, Mihelp, Midocu, Tibox,
'Mtool1, Mtool2, Mtool3, Mtool4, Mtool5, Mtool6,
'Mtool7, Mtool8, Mtool9, Mtool10, Desktop, Currfile,
'Cfhead, Cfname, Cftext, Cfcode, Driveb, Drivec,
'Drived, Drivee, Drivef, Driveg, Driveh, Drivei,
'Drivej, Drivek, Drivel, Drivem, Driven, Driveo,
'Drivep, Trash, Scan, Edit, Compile, Execute,
'Link, Resident, Work0, Work1, Work2, Work6,
'Work7, Work8, Work3, Drivea, Work9, Work4,
'Work5, Finfobox, Finame, Fiok, Fiquit, Fisize,
'Firw, Fiprot, Optbox, Oquit, Ook, Oquite,
'Opmark, Opwidth, Oppath, Ooutput, Oargs, Oerror, Olibrary,
'Oname, Shellbox, Version, Scanbox, Sok, Squit,
'Saddr, Filebox, Cfok, Cfcurr, Cfedit, Cfbok, Stponrtn,
'Cfwork, Snamebox, Snedit, Snok, Snwork, Snquit,
'Argbox, Aedit, Aok, Loptbox, Locheck1, Locheck2,
'Locheck3, Locheck4, Locheck5, Locheck6, Locheck7, Locheck8,
'Lofname1, Lofname2, Lofname3, Lofname4, Lofname5, Lofname6,
'Lofname7, Lofname8, Lochecks, Lostack, Lofull, Lomiddle,
'Lonoopt, Lonamopt, Lomaxmod, Look, Loquit, Loname,
'Lofastld, Lofastco, Lofastme, Losymfil, Loadbox,
'Lfname, Fldrbox, Fdfolder, Fdname, Fdok, Fdconf,
'Confibox, Codelete, Conumber, Cook, Coquit, Cocopy,
'Cowork, Formabox, Fosingle, Fodouble, Fo80, Fo81,
'Foremain, Fo9, Fo10, Foa, Fob, Foquit,
'Foname, Sparmbox, Sproot, Spcurr, Spcopy, Spbreak,
'Spdelete, Spallmem, Spbaname, Sppaname, Spok, Spquit,
'Spscpath, Spfontn, Spfonts, Spmake, Msgbar, Mbmsg, Eparmbox,
'Epname, Epsearch, Epstoper, Epshtemp, Epshname, Epedtemp,
'Epedname, Eparg, Eparname, Eparpos, Eparerro, Epok,
'Epquit, Helpbox, Hpnext, Hpprev, Hpquit, Hpmsgs,
'Hpmsg1, Hpmsg2, Hpmsg3, Hpmsg4, Hpmsg5, Hpmsg6,
'Hpmsg7, Hpmsg8, Hpmsg9, Hpmsg10, Hpmsg11, Hpmsg12,
'Hpmsg13, Hpmsg14, Infobox, Incode, Ihome, Inlength, Inpath, Realform,
'Instack, Inmkfile, Inblock, Inall, Inok, Inquit, Nowdwalt,
'Pathalt, Windalt, Optalt, Memalt, Icon2alt, Spacemsg,
'Editstr, Editbstr, Npathstr, Debugalt, Noldstr, Okstr,
'Nouldstr, Noexestr, Retstr, Contmalt,
'Edstr, Workstr, Compstr, Linkstr, Infstr, Contstr,
'Formaalt, Parmsalt, Foerralt, Noparalt, Nowrkalt,
'Exitalt, Loadalt, Alrtfont, Nohlpalt, Makestr,
 
%
0(*  from the library  *)
 
'ADDRESS, BYTE, WORD,
'ASSEMBLER, ADR, LOAD, STORE,
'
'(*  Storage  *)
'ALLOCATE, DEALLOCATE, MemAvail, AllAvail,
 
'(* RealCtrl *)
'AnyRealFormat, UsedFormat,
'
'(*  Strings  *)
'String, Relation,
'Concat, Insert, Split, Assign, Length, Compare, Copy, Space,
'Upper, Empty, EatSpaces, Append, StrEqual, PosLen, Delete, Pos,
'
'MOSConfig,
'DefSrcSfx, ImpSrcSfx, ModSrcSfx, StdDateMask,
'
'(*  StrConv  *)
'CardToStr, IntToStr, StrToCard, StrToLCard, LHexToStr,
 
'(*  Directory  *)
'FileAttr, FileAttrSet, DirEntry, DirQueryProc, Drive, DriveSet,
'DirQuery, SplitPath, SplitName, SetFileAttr, StrToDrive, FreeSpace,
'DriveToStr, DefaultDrive, CreateDir, GetCurrentDir, SetDefaultDrive,
'SetCurrentDir, FileStr, PathStr, NameStr, DrivesOnline, ValidatePath,
'ForceMediaChange, MakeFullPath, ConcatPath, ConcatName, SetDefaultPath,
'FileName, GetDefaultPath, FilePath,
'
'(*  ShellMsg  *)
'ScanMode, TextName, CodeName, DefSfx, ImpSfx, ModSfx, ScanAddr,
'ErrListFile, LinkDesc, TemporaryPath, LLRange,
'ShellPath, MakeFileName, DefLibName, MainOutputPath, ScanOpts,
'SrcPaths, DefPaths, EditorParm, CompilerParm, LinkerParm, LinkMode,
'
'(*  Loader  *)
'DefaultStackSize,
'
'(*  MOSGlobals  *)
'MOSGlobals,
'fOK, fEOF, fFileNotFound,
'MemArea,
'
'(*  Files  *)
'File, Access,
'State, Open, Close, ResetState,
'
'(*  Binary  *)
'ReadBlock, WriteBlock,
'
'(*  GEMScan  *)
'ChainDepth,
'
'(*  Exceptions  *)
'TRAP5, ExcSet, ExcDesc,
'ExceptsStack, InstallPreExc,
'
'(*  Paths  *)
'ListPos,
'ReplaceHome, SearchFile,
'HomePath, HomeSymbol,
'
'(*  PrgCtrl  *)
'TermProcess,
'
'(*  from the outer module  *)
'CompilerArgs,
'actionType, Str128,
'lastFn, currFn, MySuf, ShellRevision,
'action, suf, args, noDirChange, fontSetting, shellParm, conc,
'SaveParameter, LoadParameter, FileAlert, ExecuteBatch;
 
 (*  MOS  *)
 
 FROM MOSCtrl            IMPORT RealMode;
 
 FROM Clock              IMPORT Date, Time;
 
 FROM ModCtrl            IMPORT ModQuery;
 
 FROM TimeConvert        IMPORT TimeToText, DateToText;
 
 FROM Lists              IMPORT List, LDir, InitList,
?CreateList, DeleteList, ResetList, AppendEntry,
?InsertEntry, NextEntry, PrevEntry, RemoveEntry,
?CurrentEntry, ListEmpty, ScanEntries,
?NoOfEntries, EndOfList;
 
 FROM FileManagement     IMPORT FormatDrive, FormatResult,
?FormatDisk, CountFilesAndDirs, CopyFiles,
?DeleteFiles, FileInformation;
 
 (*  Graphics  *)
 
 FROM GrafBase   IMPORT black, Pnt, Rect, PtrBitPattern, WritingMode,
7Point, Rectangle, TransRect, MinPoint, ClipRect,
7FrameRects;
5
 (*  General GEM  *)
 
 FROM GEMGlobals IMPORT Root, MaxDepth, NoObject, MaxStr,
7PtrObjTree, GemChar, MouseButton, MButtonSet,
7SpecialKeySet, ObjState, OStateSet, ObjFlag,
7OFlagSet, ObjType, FillType, SpecialKey, PtrMaxStr,
7LineType;
 
 FROM GEMEnv     IMPORT RC, GemHandle, DeviceHandle, DevParm, PtrDevParm,
7InitGem, ExitGem, GemActive, CurrGemHandle,
7SetCurrGemHandle, GemError, MouseInput, DeviceParameter;
 
 (*  VDI  *)
 
 FROM VDIControls        IMPORT SetClipping, DisableClipping;
 
 FROM VDIOutputs         IMPORT PolyLine;
 
 FROM VDIInquires        IMPORT GetFaceName, GetFaceInfo;
 
 FROM VDIAttributes      IMPORT SetLineType, SetLineColor, SetWritingMode,
?DefUserLine;
 
 (*  AES  *)
 
 FROM AESForms           IMPORT FormDialMode,
?FormDial, FormDo, FormAlert;
 
 FROM AESObjects         IMPORT FindObject, DrawObject;
 
 FROM AESWindows         IMPORT DeskHandle,
?MouseControl, SetNewDesk, UpdateWindow;
 
 FROM AESResources       IMPORT ResourcePart,
?LoadResource, FreeResource, ResourceAddr;
 
 FROM AESGraphics        IMPORT MouseForm,
?DragBox, MouseKeyState, GrafMouse, RubberBox;
 
 FROM AESMenus           IMPORT MenuBar, NormalTitle, EnableItem, MenuText,
?CheckItem;
 
 FROM AESEvents          IMPORT menuSelected, Event, RectEnterMode;
 
 FROM AESMisc            IMPORT ShellGet, ShellRead;
 
 IMPORT GEMBase;
 
 (*  Beyond GEM  *)
 
 FROM ObjHandler         IMPORT SetPtrChoice,
?SetCurrObjTree, CurrObjTree,
?ObjectState, SetObjSpace, ObjectSpace,
?ObjectFlags, BorderThickness, AssignTextStrings,
?GetTextStrings, ObjTreeError, LinkTextString,
?SetObjFlags, CreateSpecification, ObjectType,
?SetObjType, SetIconForm, GetIconForm,
?SetIconLook, GetIconLook, GetComplexColor,
?SetComplexColor, GetIconColor, SetIconColor,
?SetObjState, GetObjRelatives, RightSister;
 
 FROM EventHandler       IMPORT EventProc, WatchDogCarrier,
?HandleEvents, ShareTime, DeInstallWatchDog,
?InstallWatchDog, FlushEvents;
 
 IMPORT TextWindows;
 (*
 FROM TextWindows        IMPORT Window, ForceMode, WindowQuality, WQualitySet,
?NoWind,
?Write, WriteString, WriteLn, GotoXY,
?Read, WritePg, BusyRead;
!*)
 
 FROM EasyGEM0           IMPORT SetGetMode, ObjEnumRef,
?ShowArrow, HideMouse, ShowMouse,
?ObjectSpaceWithAttrs, AbsObjectSpace,
?GetTextString, SetTextString, SetObjStateElem,
?ToggleObjState, ObjectStateElem, SetObjFlag,
?PrepareBox, ReleaseBox, DoSimpleBox,
?ForceDeskRedraw, DrawObjInWdw, DeskSize,
?DeselectButton, ToggleCheckBox, ToggleCheckPlus,
?SetGetBoxLCard, SetGetBoxStr, SetGetBoxEnum,
?SetGetBoxState, SetGetBoxCard, CharSize,
?ToggleSelectBox, ObjectFlag, TreeAddress,
?TextStringAddress;
 
 FROM WindowLists        IMPORT WindowList, NoWindowList, DetectModeWL,
?EntryToStrProcWL, CloseProcWL,
?SelectEntryProcWL, AttributeWL,
?AttributesWL, CenterWindowWL, MaxWindowWL,
?QueryDirectionWL, ErrorStateWL, CreateWL,
?DeleteWL, SetListWL, GetListWL, ShowWindowWL,
?HideWindowWL, DetectWindowWL, IsTopWindowWL,
?SelectAreaWL, WindowSizeWL, EntryAttributesWL,
?SetEntryAttributesWL, QueryListWL, GetEntryBoxWL,
?StateWL, ResetStateWL, ViewLineWL,
?PutWindowOnTopWL, SetWindowSizeWL;
 
 
 EXPORT TellMode, MaxTool, ToolField, NoPathsStr, EditBatStr,
'NoLoadStr, OkStr, NoUnloadStr, NoExecStr, RetStr, EdStr, MakeStr,
'WorkStr, CompStr, LinkStr, InfStr, ContMakeAlt, noParmAlt, ContStr,
'InitSS, ExitSS, ShowSS, HideSS, TalkWithUser, RequestArg, ScanBox,
'TellLoading, ClearDeskAndShowMsg, ShowBee, SetGetWindows,
'SetGetDeskPositions, WorkField, IsSourceName,
'memErrorAlt, ShellName, LastCodeName, LastCodeSize, EditStr,
'maxWorkFiles, appl_init, appl_exit, multiGEM, multiTOS,
'(*$ ? DebugWdw: dWriteLn, dWrite, dWait, *)
'SetWindowSizes, SetFonts, AESUpdateWindow, InitWorkfile, IsMBTFile;
 
 CONST   minNecessaryMem = 50L * 1024L;  (*  min. 50k Speicher  *)
 
(screenColumns   = 80;           (*  screen width in chars  *)
 
(MaxTool         = 10;
(maxWorkFiles    = 10;
 
(resourceFile    = 'MM2SHELL.RSC';
(batchFile       = 'MM2SHELL.M2B';
(parameterFile   = 'MM2SHELL.M2P';
(helpFile        = 'MM2SHELL.HLP';
(noDrvIcons      = 16;           (*  Anzahl der Drive-Icons  *)
(minDrv          = drvA;
(maxDrv          = drvP;
(fileBoxLength   = 41;           (*  Lnge des file box edit strings  *)
(maxDftPathInfo  = 43;           (*  'infoBox.Inpath' length *)
(maxCodeFileInfo = 43;           (*  'infoBox.Incode' length  *)
(maxDefLibName   = 33;           (*  'infoBox.Inmkfile' length *)
 
(maxWfChars      = 24;  (*  Maximale Anzahl der Zeichen, die im Ar-
@*  beitsdatei-Icon des Desks angezeigt werden
@*)
(msgStrLen       = 70;
(
(noRscAlt1       = '[3][Das Resource File kann|nicht geladen werden!]';
(noRscAlt2       = '[ Bye Bye... ]';
(
(noGemAlt1       = '[3][Anmeldung beim GEM|ist nicht gelungen!]';
(noGemAlt2       = '[ Pech ?! ]';
(
(memErrorAlt     = 'Fehler in Speicherverwaltung|Neustart empfohlen!';
(
(stdProtWidth    = 80;  (* Standardbreite des Compilerprotokolls *)
(
(undoKey         = BYTE (97);
(
(
 TYPE    ptrRectangle    = POINTER TO Rectangle;
(ptrList         = POINTER TO List;
(ptrString       = POINTER TO String;
(
(driveDskr       = RECORD
<available : BOOLEAN;
<treeIndex : CARDINAL;
:END;
9
:
0(*  definitions for the shell windows  *)
0(*  ---------------------------------  *)
:
 CONST   dirLeftBorder   = 3;    (*  Formatierungskonstanten fr  *)
(dirNameLen      = 9;    (*  die Dir.-Fensterausgabe      *)
(dirExtLen       = 3;
(dirGap          = 3;
(dirSizeLen      = 7;
(dirRightBorder  = 1;
(dirTimeLen      = 5;
(dirWidthNoDate  = dirLeftBorder + dirNameLen + dirExtLen + dirGap +
:dirSizeLen + dirGap + dirTimeLen + dirGap +
:dirRightBorder;
(dirVisibleWidth = dirLeftBorder + dirNameLen + dirExtLen + dirGap;
 VAR     dirDateLen,
(dirWdwWidth     : CARDINAL;
 
 CONST   modWdwTitle     = ' Geladene Module ';
(modWdwTitleAll  = ' Residente Module ';
(
(maxModNameLen   = 20;      (*  Max. Zahl der Zeichen eines Modul-
D*  namens die im Fenster sichtbar sind.
D*)
(lCardLog        = 10;      (*  Max. Dezimalstellen eines LONGCARD's  *)
(modGap          = 1;
(modModFlag      = ' Modul';
(modModLen       = 6;       (*  Anzahl der Zeichen in 'modModFlag'  *)
(modLoadFlag     = 'Geladen';
(modLoadLen      = 7;       (*  = Length (modLoadFlag)  *)
(modRsdFlag      = 'Resident';
(modRsdLen       = 8;       (*  = Length (modRsdFlag)  *)
(
(modDataLen      = modGap + lCardLog +modGap + lCardLog + modGap +
:modModLen + modGap + modRsdLen;
(modDataLenAll   = modDataLen + modGap + modLoadLen;
:
(modWdwWidth     = maxModNameLen + modDataLen;
(modWdwWidthAll  = maxModNameLen + modDataLenAll;
:
 CONST   maxWdw          = 5;   (* Max. Fensterzahl *)
(firstWdwColumn  = 40;
(
 TYPE    modEntry        = RECORD          (*  entry of the module list  *)
<name        : ARRAY[0..79] OF CHAR;
<lenOfCode   : LONGCARD;
<lenOfVar    : LONGCARD;
<isModul     : BOOLEAN;
<wasLoaded   : BOOLEAN;
<isResident  : BOOLEAN;
:END;
(ptrModEntry     = POINTER TO modEntry;
(
(ptrDirEntry     = POINTER TO RECORD
<entry: DirEntry;
<str  : String;
:END;
:
(wdwSlotIdx      = [1..maxWdw];
(wdwKind         = (dirWdw, modWdw);
(wdwSlot         = RECORD
<wl        : WindowList;   (*  handle  *)
<used,
<isTop     : BOOLEAN;
<noSelected: CARDINAL;
<tmpSpace  : Rectangle;
<CASE kind: wdwKind OF
>dirWdw    : path  : Str128|
>modWdw    : all   : BOOLEAN|   (*  all modules  *)
<END;
:END;
(ptrWdwSlot      = POINTER TO wdwSlot;
:
 VAR     wdws            : ARRAY wdwSlotIdx OF ptrWdwSlot;
 
 
 CONST   noCurrentWorkfile       = -1;   (*  more info at 'WorkField'  *)
(
 VAR
0(*  globale handles  *)
 
(dev                     : DeviceHandle;
(gemHdl                  : GemHandle;
(multiGEM                : BOOLEAN;
(multiTOS                : BOOLEAN;
(menu, desk, scanBox,
(shellBox, optBox,
(fileInfoBox, fileBox,
(shellParmBox, editorParmBox,
(sNameBox, argBox,
(linkBox, loadBox,
(fNameBox, formatBox,
(msgBar, confirmBox,
(helpBox, infoBox        : PtrObjTree;
(
(aesPB                   : GEMBase.AESPB;
(vdiPB                   : GEMBase.VDIPB;
(
(noWindAlt, pathToLongAlt,
(windErrAlt, formatAlt,
(cOptToLongAlt, wrgIcon2Alt,
(memFullAlt, drvSpaceMsg,
(debugAlt, formatErrAlt,
(NoLoadStr, OkStr, NoPathsStr,
(NoUnloadStr, NoExecStr,
(RetStr, EdStr, WorkStr,
(CompStr, LinkStr, InfStr,
(ContMakeAlt, ContStr, EditStr, EditBatStr,
(parmSaveAlt, noParmAlt,
(noNewWorkAlt, loadFailedAlt,
(exitShellAlt, noHelpAlt,
(fontErrAlt,
(MakeStr                  : PtrMaxStr;
(
(linkBoxIdx  : ARRAY[1..8] OF RECORD
8check,
8path        : CARDINAL;
6END;
(
(drives      : ARRAY[minDrv..maxDrv] OF driveDskr;
(
(ToolField   : ARRAY[1..MaxTool] OF RECORD
8index       : CARDINAL; (*  Menu-Obj.  *)
8
8CASE used :BOOLEAN OF
:TRUE : name : FileStr;
8END;
6END;
 
((*  Contains all work files.
)*)
(WorkField   : RECORD
8noUsed : CARDINAL;
8current: INTEGER;
8elems  : ARRAY[0..maxWorkFiles - 1] OF RECORD
CnameIdx     : CARDINAL;
CidentIdx    : CARDINAL;
CcarrierIdx  : CARDINAL;
Cused        : BOOLEAN;
CcodeName    : FileStr;
CsourceName  : FileStr;
AEND;
6END;
(
(msgStr                  : String;
(
(
0(* Variablen, die die aktuellen Shellparameter speichern *)
 
(selectedDrive           : Drive;   (*  '= defaultDrv' <=> none sel.  *)
(quitStatus              : (noQuit, quit, quickQuit);
(LastCodeName            : FileStr;
(LastCodeSize            : LONGCARD;
(
0(* Globale Infovariablen *)
(
(deskSize,
(alignedDeskSize         : Rectangle;
(charWidth, charHeight   : CARDINAL;
(
(tellSpace               : Rectangle;    (*  Darf nur von 'TellLoading'
Q*  benutzt werden.
Q*)
 
(lastArgs: ARRAY [0..127] OF CHAR;
 
(ShellName: FileStr;
 
0(* Globale Kurzzeitvariablen *)
(
(ok      : BOOLEAN;      (*  Siehe auch 'notOKAlert'  *)
(but     : CARDINAL;
(
0(*  global dummies  *)
(
(voidC    : CARDINAL;
(voidO    : BOOLEAN;
(voidCh   : CHAR;
(voidI    : INTEGER;
(void128  : ARRAY [0..127] OF CHAR;
(voidSlot : wdwSlotIdx;
(voidADR  : ADDRESS;
(voidFrame: Rectangle;
 
 (*$ ? DebugWdw:
(
(dWdw    : Window;
(
 PROCEDURE dWriteLn (str: ARRAY OF CHAR);
 
 BEGIN
"WriteString (dWdw, str); WriteLn (dWdw);
 END dWriteLn;
 
 PROCEDURE dWrite (str: ARRAY OF CHAR);
 
 BEGIN
"WriteString (dWdw, str);
 END dWrite;
 
 PROCEDURE dWait;
 VAR ch: CHAR;
 BEGIN
"Read (dWdw,ch)
 END dWait;
 
 PROCEDURE dWriteCard (c, spc: CARDINAL);
 
 BEGIN
"dWrite (CardToStr (c, spc));
 END dWriteCard;
 
 PROCEDURE dWriteInt (c: INTEGER; spc: CARDINAL);
 
 BEGIN
"dWrite (IntToStr (c, spc));
 END dWriteInt;
 
 
 *)
 
 
8(*  Diverse Hilfsroutinen  *)
8(*  =====================  *)
 
((*  mouse  *)
(
 PROCEDURE mouseImage;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
*DC.W    $0, $0, $1, $0, $1
*DC.W    $07F0,$07F0,$07F0,$07F0,$0FF8,$1FFC,$3FFE,$3FFF
*DC.W    $3FFF,$3FFF,$1FFF,$0FFF,$0FFF,$07FF,$03FF,$03FE
*DC.W    $0000,$03E0,$03E0,$02A0,$07F0,$0E38,$1F7C,$1FFD
*DC.W    $1FFC,$1FFD,$0FF8,$07F2,$07FD,$03E0,$01CA,$01E8
$END;
"END mouseImage;
"(*$L=*)
 
 PROCEDURE appl_init;
"BEGIN
$WITH aesPB DO
&WITH pcontrl^ DO
(opcode:= 10;
(sintin:=  0;
(sintout:= 1;
(sadrin:=  0;
(sadrout:= 0;
&END;
$END;
$GEMBase.CallAES( ADR( aesPB));
"END appl_init;
 
 PROCEDURE appl_exit;
"BEGIN
$WITH aesPB DO
&WITH pcontrl^ DO
(opcode:= 19;
(sintin:=  0;
(sintout:= 1;
(sadrin:=  0;
(sadrout:= 0;
&END;
$END;
$GEMBase.CallAES( ADR( aesPB));
"END appl_exit;
 
 PROCEDURE ShowBee;
"BEGIN
$IF multiTOS THEN
&GrafMouse (bee, NIL);
$ELSE
&GrafMouse (userCursor, ADDRESS (mouseImage))
$END;
"END ShowBee;
 
 PROCEDURE AESUpdateWindow (b: BOOLEAN);
!BEGIN
#UpdateWindow (b)
!END AESUpdateWindow;
 
 PROCEDURE SetFonts;
"(* aktualisiert Fonts bei TextWindows und WindowLists *)
"VAR c: CARDINAL; i: INTEGER; ok: BOOLEAN; dummyList: List; slot: wdwSlotIdx;
"BEGIN
$WITH fontSetting DO
&IF Empty (name) THEN GetFaceName (dev, 1, name); END;
&IF size = 0 THEN size:= 10; END;
&(* zuerst den Default-Font bei TextWindows setzen *)
&TextWindows.ReSpecify (TextWindows.Window(NIL), 0, size, name, ok);
&IF ~ok THEN
((* Font kann nicht eingestellt werden. Vermutlich ist Name falsch *)
(FormAlert (1, fontErrAlt^, c);
&ELSE
((* Default-Font nun bei WindowLists setzen *)
(SetListWL (NoWindowList, dummyList, EntryToStrProcWL (NIL),
,CloseProcWL (NIL), SelectEntryProcWL (NIL), NIL, size, name);
((* zuletzt Font bei offenen Fenstern setzen *)
(FOR slot := MIN (wdwSlotIdx) TO MAX (wdwSlotIdx) DO
*WITH wdws[slot]^ DO
,SetListWL (wl, dummyList, EntryToStrProcWL (NIL), CloseProcWL (NIL),
0SelectEntryProcWL (NIL), NIL, size, name);
*END;
(END;
&END;
$END;
"END SetFonts;
 
 PROCEDURE SetWindowSizes;
"VAR slot: wdwSlotIdx;
"BEGIN
$FOR slot:= MIN (wdwSlotIdx) TO MAX (wdwSlotIdx) DO
&SetWindowSizeWL (wdws[slot]^.wl, wdws[slot]^.tmpSpace);
$END
"END SetWindowSizes;
 
 
 VAR     gemChar  : GemChar;
(charValid: BOOLEAN;
 
 (*$Z-*)
 PROCEDURE readKey (VAR ch: GemChar; VAR specials: SpecialKeySet): BOOLEAN;
 (*$Z=*)
 
"BEGIN
$gemChar := ch;
$charValid := TRUE;
$RETURN FALSE
"END readKey;
 
 (*$Z-*)
 PROCEDURE timeDummy (): BOOLEAN;
 (*$Z=*)
 
"BEGIN
$RETURN FALSE
"END timeDummy;
"
 PROCEDURE busyReadGemChar (VAR ch: GemChar; VAR valid: BOOLEAN);
 
"VAR   worker: ARRAY [1..2] OF EventProc;
 
"BEGIN
$charValid := FALSE;
$worker[1].event := keyboard;
$worker[1].keyHdler := readKey;
$worker[2].event := timer;
$worker[2].timeHdler := timeDummy;
$HandleEvents (1, MButtonSet{}, MButtonSet{},
2lookForEntry, Rect (0,0,0,0),
2lookForEntry, Rect (0,0,0,0),
20L,
2worker, 0);
$
$ch := gemChar; valid := charValid;
"END busyReadGemChar;
"
 
((*  strings  *)
 
 (*  appendSpcTo -- Fgt Spaces an 'str' an, bis 'Length (str) = i'
!*)
(
 PROCEDURE appendSpcTo (i: CARDINAL; VAR str: ARRAY OF CHAR);
 
"VAR   l       : CARDINAL;
"
"BEGIN
$l := HIGH (str);
$IF i < l THEN l := i END;
$Append (Space (l - Length (str)), str, voidO);
"END appendSpcTo;
 
 (*  truncCopyStr -- 'source' wird nach 'dest' kopiert. Es gibt 'maxDestLen'
!*                  die Gre von 'dest' an, ist 'source' grer, so wird
!*                  der vordere Teil abgeschnitten und ein '..' vorange-
!*                  stellt.
!*)
!
 PROCEDURE truncCopyString (    source    : ARRAY OF CHAR;
?maxDestLen: CARDINAL;
;VAR dest      : ARRAY OF CHAR);
 
"VAR   sourceLen: CARDINAL;
 
"BEGIN
$sourceLen := Length (source);
$IF sourceLen > maxDestLen THEN
&Copy (source, sourceLen - maxDestLen - 2, sourceLen, dest, voidO);
&Insert ('..', 0, dest, voidO);
$ELSE Assign (source, dest, voidO) END;
"END truncCopyString;
&
&
((*  lists  *)
 
 TYPE    listApplyProc   = PROCEDURE ((*entry: *) ADDRESS,
E(*env  : *) ADDRESS): BOOLEAN;
 
 PROCEDURE applyAtList (    l   : List;
;(*$Z-*)
;work: listApplyProc;
;(*$Z=*)
;env : ADDRESS;
7VAR cut : BOOLEAN);
 
"VAR   entry   : ADDRESS;
"
"BEGIN
$cut := FALSE; ResetList (l);
$LOOP
&entry := NextEntry (l);
&IF entry = NIL THEN EXIT                                  (*  EXIT  *)
&ELSIF ~ work (entry, env) THEN cut := TRUE; EXIT END;     (*  EXIT  *)
$END;
"END applyAtList;
 
 PROCEDURE deleteList (VAR l: List);
 
"VAR   entry: ADDRESS;
"
"BEGIN
$ResetList (l);
$entry := PrevEntry (l);
$WHILE entry # NIL DO
&RemoveEntry (l, voidO);
&entry := CurrentEntry (l);
$END;
$DeleteList (l, voidO);
"END deleteList;
 
 (*  deleteSimpleList -- Deletes the list 'l' completly. The elements of the
!*                      list must be dynamical allocated variables and would
!*                      all be disposed.
!*                      If 'killCarrier = TRUE' then list-carrier would be
!*                      deleted.
!*)
 
 PROCEDURE deleteSimpleList (VAR l: List; killCarrier: BOOLEAN);
 
"VAR   entry: ADDRESS;
 
"BEGIN
$ResetList (l);
$entry := PrevEntry (l);
$WHILE entry # NIL DO
&RemoveEntry (l, voidO);
&DEALLOCATE (entry, 0L);
&entry := CurrentEntry (l);
$END;
$IF killCarrier THEN DeleteList (l, voidO) END;
"END deleteSimpleList;
 
 
((*  'WindowLists'  *)
 
 PROCEDURE entrySelected (slotPtr : ptrWdwSlot;
9entry   : ADDRESS;
9selected: BOOLEAN);
 
"VAR   oldAttrs: AttributesWL;
(count   : BOOLEAN;
"
"BEGIN
$(*  'count' := "This call causes a change in the number of selected
%*              entries".
%*)
$oldAttrs := EntryAttributesWL (slotPtr^.wl, entry);
$count := ((selectedWL IN oldAttrs) # selected);
$
$IF selected THEN
&SetEntryAttributesWL (slotPtr^.wl, entry,
;oldAttrs + AttributesWL{selectedWL});
&IF count THEN
(INC (slotPtr^.noSelected)
&END;
$ELSE
&SetEntryAttributesWL (slotPtr^.wl, entry,
;oldAttrs - AttributesWL{selectedWL});
&IF count THEN
(DEC (slotPtr^.noSelected)
&END;
$END;
"END entrySelected;
 
 (*  firstSelectedEntry -- Returns the first entry of 'slot's window list,
!*                        that is selected. If none exists, NIL is returned.
!*)
 
 (*$Z-*)
 PROCEDURE isNotSelected (entry, env: ADDRESS; VAR attrs: AttributesWL): BOOLEAN;
 (*$Z=*)
 
"BEGIN
$RETURN ~ (selectedWL IN attrs)
"END isNotSelected;
"
 PROCEDURE firstSelectedEntry (slot: wdwSlotIdx): ADDRESS;
 
"VAR   result: ADDRESS;
(found : BOOLEAN;
 
"BEGIN
$QueryListWL (wdws[slot]^.wl, forwardWL, isNotSelected, NIL, found, result);
$IF ~ found THEN result := NIL END;
$
$RETURN result
"END firstSelectedEntry;
"
"
((*  tests  *)
 
 PROCEDURE withShift (VAR s: SpecialKeySet): BOOLEAN;
 
"BEGIN
$RETURN (leftShiftKey IN s) OR (rightShiftKey IN s)
"END withShift;
 
 PROCEDURE withBothShifts (VAR s: SpecialKeySet): BOOLEAN;
 
"BEGIN
$RETURN (leftShiftKey IN s) AND (rightShiftKey IN s)
"END withBothShifts;
 
 PROCEDURE withCtrl (VAR s: SpecialKeySet): BOOLEAN;
 
"BEGIN
$RETURN controlKey IN s
"END withCtrl;
 
 PROCEDURE withAlt (VAR s: SpecialKeySet): BOOLEAN;
 
"BEGIN
$RETURN alternateKey IN s
"END withAlt;
 
 PROCEDURE isSubdir (VAR entry: DirEntry): BOOLEAN;
 
"BEGIN
$RETURN subdirAttr IN entry.attr
"END isSubdir;
"
 
 (*$Z-*)
 PROCEDURE fastCompare (VAR s1, s2: ARRAY OF CHAR): Relation;
 (*$Z=*)
"(*$L-*)
"BEGIN
$(*
&IF s1[0] > s2[0] THEN
(RETURN greater
&ELSIF s1[0] < s2[0] THEN
(RETURN less
&ELSE
(RETURN Compare (s1,s2)
&END
$*)
$ASSEMBLER
(MOVE.L  -12(A3),A1      ; ADR (s1)
(MOVE.L  -06(A3),A2      ; ADR (s2)
(MOVE.B  (A1),D1         ; s1[0]
(MOVE.B  (A2),D2         ; s2[0]
(CMP.B   D2,D1
(BHI     gr
(BCS     le
(JMP     Compare         ; s1[0] = s2[0]
$le: SUBA.W  #12,A3
(MOVE    #less,(A3)+
(RTS
$gr: SUBA.W  #12,A3
(MOVE    #greater,(A3)+
$END
"END fastCompare;
"(*$L=*)
"
"
((*  proc.s for AES objects  *)
 
 (*  formDo -- Is same as 'FormDo', but clears the most significant bit
!*            of 'exit' (double click).
!*)
!
 PROCEDURE formDo (tree: PtrObjTree; start: CARDINAL; VAR exit: CARDINAL);
 
"BEGIN
$FormDo (tree, start, exit);
$exit := exit MOD (MaxCard DIV 2);
"END formDo;
"
 PROCEDURE drawObject (tree: PtrObjTree; obj: CARDINAL);
 
"VAR   space   : Rectangle;
 
"BEGIN
$space := AbsObjectSpace (tree, obj);
$DrawObject (tree, Root, MaxDepth, space);
"END drawObject;
"
 PROCEDURE hideObj (obj: CARDINAL; hide: BOOLEAN);
 
"BEGIN
$SetObjFlag (CurrObjTree (), obj, hideTreeFlg, hide);
"END hideObj;
 
 PROCEDURE hideAndRedrawObj (obj: CARDINAL; hide: BOOLEAN);
 
"BEGIN
$hideObj (obj, hide);
$drawObject (CurrObjTree (), obj);
"END hideAndRedrawObj;
"
0(*  Operations on path/file names  *)
 
 (*  killPoint -- Wandelt einen Filenamen, der einen Punkt enthlt in einen
!*               eine Zeichenkette, die aus max. 11 Zeichen besteht. Dabei
!*               sind die ersten 8 Zeichen Name und die letzten 3 Extension.
!*)
 
 PROCEDURE killPoint (REF str: ARRAY OF CHAR): NameStr;
 
"VAR     result: NameStr;
*i, j  : INTEGER;
*l     : CARDINAL;
*pref, suf: ARRAY [0..7] OF CHAR;
 
"BEGIN
$SplitName (str, result, suf);
$IF suf[0] # 0C THEN
&Append (Space (8 - Length (result)), result, voidO);
&Append (suf, result, voidO);
$END;
$RETURN result
"END killPoint;
 
 PROCEDURE addPoint (VAR str:ARRAY OF CHAR) :String;
 
"VAR     result  : String;
*i       : INTEGER;
"
"BEGIN
$Assign (str,result, voidO);
$IF Length (result) > 8 THEN Insert ('.', 8, result, voidO) END;
$EatSpaces (result);
$RETURN result;
"END addPoint;
 
 (*  IsSourceName -- Is TRUE, if 'path' descibes a source file else FALSE.
!*)
 
 PROCEDURE IsSourceName (REF path: ARRAY OF CHAR): BOOLEAN;
 
"VAR   name    : NameStr;
(prefix  : ARRAY[0..64] OF CHAR;
(suffix  : ARRAY[0..2] OF CHAR;
(sufcnt  : MySuf;
(isSource: BOOLEAN;
(
"BEGIN
$SplitPath (path, prefix, name);
$SplitName (name, name, suffix);
$isSource := suffix[0]#'';
$IF isSource THEN
&sufcnt:= MIN (MySuf);
&LOOP
(IF StrEqual (suffix, suf[sufcnt]) THEN isSource := FALSE; EXIT
(ELSIF sufcnt = MAX (MySuf) THEN EXIT
(ELSE INC (sufcnt) END
&END;
$END;
$RETURN isSource
"END IsSourceName;
 
 PROCEDURE isMSPFile (REF name: ARRAY OF CHAR): BOOLEAN;
"VAR n: ARRAY [0..11] OF CHAR;
"BEGIN
$SplitPath (name, void128, n);
$SplitName (n, void128, n);
$RETURN StrEqual (n, suf[m2p])
"END isMSPFile;
"
 PROCEDURE IsMBTFile (REF name: ARRAY OF CHAR): BOOLEAN;
"VAR n: ARRAY [0..11] OF CHAR;
"BEGIN
$SplitPath (name, void128, n);
$SplitName (n, void128, n);
$RETURN StrEqual (n, suf[m2b])
"END IsMBTFile;
"
 PROCEDURE isMakeFile (REF name: ARRAY OF CHAR): BOOLEAN;
"VAR n: ARRAY [0..11] OF CHAR;
"BEGIN
$SplitPath (name, void128, n);
$SplitName (n, void128, n);
$RETURN StrEqual (n, suf[m2m])
"END isMakeFile;
"
"
0(*  Alerts  *)
0(*  ======  *)
 
 PROCEDURE doAlert (alt: PtrMaxStr);
 
"BEGIN
$FormAlert (1, alt^, voidC);
"END doAlert;
"
 
 (*  multiStringAlert -- Setzt aus den zwei Zeichenketten eine Alarmmeldung
!*                      zusammen und gibt diese aus.
!*)
 
 PROCEDURE multiStringAlert (REF str1, str2: ARRAY OF CHAR; VAR but: CARDINAL);
 
"VAR     str     : ARRAY[0..255] OF CHAR;
"
"BEGIN
$Concat (str1, str2, str, voidO);
$FormAlert (1, str, but);
"END multiStringAlert;
 
 (*  notOKAlert -- Falls die globale Variable 'ok = FALSE' ist, so wird der
!*                bergebene FileStr 'str' innerhalb einer Alert-Box ange-
!*                zeigt.
!*)
!
 PROCEDURE notOKAlert (str: PtrMaxStr);
 
"BEGIN
$IF ~ ok THEN doAlert (str) END;
"END notOKAlert;
 
 PROCEDURE flexAlert (default: CARDINAL; REF str1,str2:ARRAY OF CHAR; alt:PtrMaxStr;
5VAR but:CARDINAL);
5
 VAR     str, strx       : ARRAY[0..255] OF CHAR;
(i, j            : INTEGER;
5
 BEGIN
"i:=Pos ('&',alt^, 0);
"j:=Pos ('&',alt^, i + 1);
"Copy (alt^, 0,i, str, voidO);
"Append (str1, str, voidO);
"IF j >= 0 THEN
$Copy (alt^, i + 1,j - i - 1, strx, voidO);
$Append (strx, str, voidO);
$Append (str2, str, voidO);
$i:=j;
"END;
"Copy (alt^, i + 1,Length (alt^) - CARDINAL (i) - 1, strx, voidO);
"Append (strx, str, voidO);
"FormAlert (default,str, but);
 END flexAlert;
 
 (*  concatPath -- Wie normales Concat', nur wird bei berlauf des
!*                Zielstrings ein FormAlert ausgelt.
!*                Das 's1, s2' VAR-Parm. sind hat nur Effizenzgrnde.
!*)
!
 PROCEDURE concatPath (VAR s1, s2 : ARRAY OF CHAR;
6VAR dest   : ARRAY OF CHAR;
6VAR success: BOOLEAN);
"BEGIN
$Concat (s1,s2, dest, success);
$IF ~ success THEN doAlert (pathToLongAlt) END;
"END concatPath;
 
 PROCEDURE appendPath (VAR s      : ARRAY OF CHAR;
6VAR dest   : ARRAY OF CHAR;
6VAR success: BOOLEAN);
6
"BEGIN
$Append (s, dest, success);
$IF ~ success THEN doAlert (pathToLongAlt) END;
"END appendPath;
 
 PROCEDURE reportOutOfMemory;
 
"BEGIN
$doAlert (memFullAlt);
"END reportOutOfMemory;
 
(
8(*  Desk-Operationen  *)
8(*  ================  *)
(
 PROCEDURE deskObjSpace (obj: CARDINAL): Rectangle;
 
"BEGIN
$RETURN AbsObjectSpace (desk, obj)
"END deskObjSpace;
 
 PROCEDURE redrawDeskObj (obj:CARDINAL);
 
"BEGIN
$DrawObjInWdw (desk, obj, TRUE, DeskHandle);
"END redrawDeskObj;
 
 PROCEDURE toggleDeskObj (obj:CARDINAL; VAR newState:BOOLEAN);
 
"BEGIN
$ToggleObjState (desk, obj, selectObj, FALSE);
$redrawDeskObj (obj);
$newState := ObjectStateElem (desk, obj, selectObj);
"END toggleDeskObj;
 
 PROCEDURE selectDeskObj (obj:CARDINAL; state:BOOLEAN; VAR oldState: BOOLEAN);
 
"BEGIN
$oldState := ObjectStateElem (desk, obj, selectObj);
$SetObjStateElem (desk, obj, selectObj, state);
$redrawDeskObj (obj);
"END selectDeskObj;
 
 PROCEDURE careOfDeselectDrive;
 
"BEGIN
$IF selectedDrive # defaultDrv THEN
&toggleDeskObj (drives[selectedDrive].treeIndex, voidO);
&selectedDrive := defaultDrv;
$END;
"END careOfDeselectDrive;
 
 PROCEDURE selectDrive (drv: Drive);
 
"BEGIN
$IF selectedDrive # drv THEN
&IF selectedDrive # defaultDrv THEN careOfDeselectDrive END;
&selectedDrive := drv;
&toggleDeskObj (drives[selectedDrive].treeIndex, voidO);
$END;
"END selectDrive;
 
 (*  ensureVisibility  -- Ensures, that the given object lies within the
!*                       borders of the desk, e.g. is visible and that it
!*                       is aligned to char. coor.s.
!*)
!
 PROCEDURE ensureVisibility (obj: CARDINAL);
 
"PROCEDURE ensure0 (VAR pos,
9width      : INTEGER;
9borderPos,
9borderWidth: INTEGER;
9alignWidth : CARDINAL);
"
$BEGIN
&pos := pos - pos MOD INTEGER (alignWidth);
&WHILE pos + width > borderPos + borderWidth DO
(pos := pos DIV 2;
&END;
&IF pos < borderPos THEN pos := borderPos END;
$END ensure0;
 
"VAR   space: Rectangle;
"
"BEGIN
$space := ObjectSpace (obj);
$ensure0 (space.x, space.w, alignedDeskSize.x, alignedDeskSize.w, charWidth);
$ensure0 (space.y, space.h, alignedDeskSize.y, alignedDeskSize.h, charHeight);
$SetObjSpace (obj, space);
"END ensureVisibility;
"
"
 PROCEDURE moveDeskPart (obj:CARDINAL);
 
"VAR     newPos  : Point;
"
"BEGIN
$AESUpdateWindow (TRUE);
$
$SetCurrObjTree (desk, FALSE);
$hideObj (obj, TRUE);
$redrawDeskObj (obj);
$
$DragBox (ObjectSpaceWithAttrs (desk, obj), deskSize, newPos);
$WITH newPos DO
&x := x + INTEGER (charWidth) DIV 2; x := x - x MOD INTEGER (charWidth);
&y := y + INTEGER (charHeight) DIV 2; y := y - y MOD INTEGER (charHeight);
$END;
$SetObjSpace (obj, TransRect (ObjectSpace (obj), newPos) );
$
$hideObj (obj, FALSE);
$redrawDeskObj (obj);
$
$AESUpdateWindow (FALSE);
"END moveDeskPart;
 
 (*  setCurrTextAndCode -- Set the current file.
!*)
 
 PROCEDURE setCurrTextAndCode (REF str: ARRAY OF CHAR);
 
"VAR   name    : NameStr;
(isSrc,
(isMXX   : BOOLEAN;
"
"BEGIN
$SplitPath (str, void128, name);
$
$IF name[0]='' THEN
&lastFn := '';
&TextName := '';
&CodeName := '';
$ELSE
$
&isSrc := IsSourceName (str);
&isMXX := (IsMBTFile (name) OR isMSPFile (name) OR isMakeFile (name));
&IF isSrc OR isMXX THEN
(Assign (str, TextName, voidO);
(Assign (str, lastFn, voidO);
&END;
(
&IF ~ isSrc OR isMXX THEN Assign (str, CodeName, voidO) END;
&
&notOKAlert (pathToLongAlt);
$END;
"END setCurrTextAndCode;
 
 (*  redrawWorkfile -- Sets the 'WorkField'-values to the objects and
!*                    draws the object.
!*)
 
 PROCEDURE redrawWorkfile (i: CARDINAL);
 
"VAR   name: NameStr;
 
"BEGIN
$WITH WorkField.elems[i] DO
&SplitPath (sourceName, void128, name);
&SetTextString (desk, nameIdx, name);
&SetObjStateElem (desk, identIdx, selectObj,
7WorkField.current = INTEGER (i));
&hideObj (carrierIdx, ~ used);
&redrawDeskObj (carrierIdx);
$END;
"END redrawWorkfile;
"
 (*  searchDrive -- Ist das Objekt 'obj' ein Drive-Icon, so liefert 'drive'
!*                 die LW-Kennung und 'valid = TRUE'.
!*                 Sonst 'valid = FALSE'.
!*)
 
 PROCEDURE searchDrive (obj: CARDINAL; VAR drive: Drive; VAR valid: BOOLEAN);
"
"BEGIN
$drive := minDrv;
$LOOP
&IF drives[drive].available AND (obj = drives[drive].treeIndex)
&THEN valid := TRUE; EXIT
&ELSIF drive = maxDrv THEN valid := FALSE; EXIT
&ELSE INC (drive) END;
$END;
"END searchDrive;
 
 (*  searchWorkfile -- If 'obj' is an element of a workfile object, the
!*                    return the workfile index in 'workfileIdx' and
!*                    'valid = TRUE'.
!*)
 
 PROCEDURE searchWorkfile (    obj        : CARDINAL;
:VAR workfileIdx: CARDINAL;
:VAR valid      : BOOLEAN);
 
"BEGIN
$workfileIdx := 0; valid := FALSE;
$WHILE (workfileIdx < maxWorkFiles) AND ~ valid DO
$
&WITH WorkField.elems[workfileIdx] DO
(valid := ((obj = carrierIdx) OR (obj = identIdx) OR (obj = nameIdx))
&END;
&
&INC (workfileIdx);
&
$END;
$DEC (workfileIdx);
"END searchWorkfile;
"
 PROCEDURE SetGetDeskPositions (f: File; mode: SetGetMode);
 
"VAR success: BOOLEAN;
 
"PROCEDURE setGetOnePos (obj: CARDINAL);
"
$VAR loc     : Point;
"
$BEGIN
&IF ~ success THEN RETURN END;
&
&IF mode = setValue THEN
&
(ReadBlock (f, loc);
(IF State (f) < fOK THEN success := FALSE; RETURN END;
(WITH loc DO
*x := x * INTEGER (charWidth); y := y * INTEGER (charWidth);
(END;
(SetObjSpace (obj, TransRect (ObjectSpace (obj), loc));
(ensureVisibility (obj);  (*  Icon should be within 'deskSize'  *)
(
&ELSE
(
(loc := MinPoint (ObjectSpace (obj));
(WITH loc DO
*x := x DIV INTEGER (charWidth); y := y DIV INTEGER (charWidth);
(END;
(WriteBlock (f, loc);
(IF State (f) < fOK THEN success := FALSE END;
(
&END;
$END setGetOnePos;
$
"VAR   d: Drive;
$
"BEGIN
$success := TRUE;
$
$SetCurrObjTree (desk, FALSE);
$FOR d := minDrv TO maxDrv DO setGetOnePos (drives[d].treeIndex) END;
$setGetOnePos (Trash);
$setGetOnePos (Edit); setGetOnePos (Compile);
$setGetOnePos (Execute); setGetOnePos (Link);
$setGetOnePos (Resident); setGetOnePos (Scan);
$setGetOnePos (Currfile);
$setGetOnePos (Work0); setGetOnePos (Work1);
$setGetOnePos (Work2); setGetOnePos (Work3);
$setGetOnePos (Work4); setGetOnePos (Work5);
$setGetOnePos (Work6); setGetOnePos (Work7);
$setGetOnePos (Work8); setGetOnePos (Work9);
"END SetGetDeskPositions;
 
 (*  setWorkfileName -- Assigns the specified workfile a new name.
!*)
 
 PROCEDURE setWorkfileName (idx: CARDINAL; VAR name: ARRAY OF CHAR);
 
"BEGIN
$Upper (name);
$WITH WorkField.elems[idx]
$DO
&Assign (name, sourceName, voidO);
&codeName := '';
$END;
$
$redrawWorkfile (idx);
"END setWorkfileName;
"
 
8(*  menu proc.s  *)
8(*  ===========  *)
 
 (*  setTools -- Verndert den Menubaum so, da nur noch die in 'ToolField'
!*              vorhandenen Menu-Tool-Eintrge sichtbar sind.
!*)
 
 PROCEDURE setTools;
 
"CONST   toolNameLen = 12;
 
"VAR   f1, f2    : Rectangle;
(h         : INTEGER;
(i         : CARDINAL;
(str, str2 : FileStr;
"
"BEGIN
"
$SetCurrObjTree (menu, FALSE);
$h := 0;
$FOR i := 1 TO MaxTool DO
&WITH ToolField[i]
&DO
(IF used THEN
(
*GetTextString (menu, index, str);
*SplitPath (name, void128, str2);
*Append (Space (toolNameLen - Length (str2)), str2, voidO);
*Delete (str, 2, toolNameLen, voidO);
*Insert (str2, 2, str, voidO);
*MenuText (menu, index, str);
*f1 := ObjectSpace (index);
*h := h + f1.h
*
(END;
(hideObj (index, NOT used);
&END
$END;
$IF h = 0
$THEN
&IF NOT ObjectFlag (menu, Mtools, hideTreeFlg)
&THEN
(hideObj (Mtools, TRUE);
(f1 := ObjectSpace (Mibox);
(f2 := ObjectSpace (Mtools);
(DEC (f1.w, f2.w);
(SetObjSpace (Mibox, f1);
&END;
$ELSE
&IF ObjectFlag (menu, Mtools, hideTreeFlg) THEN
(hideObj (Mtools, FALSE);
(f1 := ObjectSpace (Mibox);
(f2 := ObjectSpace (Mtools);
(INC (f1.w, f2.w);
(SetObjSpace (Mibox, f1);
&END;
&f1 := ObjectSpace (Tibox);
&f1.h := h;
&SetObjSpace (Tibox, f1);
$END;
$
"END setTools;
 
 PROCEDURE animateMenuTitle (title: CARDINAL; VAR space: Rectangle);
 
"BEGIN
$NormalTitle (menu, title, FALSE);
$space := AbsObjectSpace (menu, title);
"END animateMenuTitle;
 
 PROCEDURE deAnimateMenuTitle (title: CARDINAL);
 
"BEGIN
$NormalTitle (menu, title, TRUE);
"END deAnimateMenuTitle;
"
 
0(*  Routinen fr das Dialogbox-Managment  *)
0(*  ====================================  *)
 
((*  misc. box primitives  *)
 
 TYPE    arrayOfTwoCards = ARRAY[1..2] OF CARDINAL;
 
 PROCEDURE twoCardsInArray (c1, c2: CARDINAL): arrayOfTwoCards;
 
"VAR   res: arrayOfTwoCards;
"
"BEGIN
$res[1] := c1;
$res[2] := c2;
$RETURN res
"END twoCardsInArray;
"
 TYPE    arrayOfTwoEnumRefs      = ARRAY[1..2] OF ObjEnumRef;
 
 PROCEDURE twoEnumsInRefArray (obj1      : CARDINAL;
>enumValue1: WORD;
>obj2      : CARDINAL;
>enumValue2: WORD): arrayOfTwoEnumRefs;
 
"VAR   refs: arrayOfTwoEnumRefs;
(i   : CARDINAL;
(
"BEGIN
$refs[1].obj := obj1;
$refs[1].value := enumValue1;
$refs[2].obj := obj2;
$refs[2].value := enumValue2;
$
$RETURN refs
"END twoEnumsInRefArray;
 
 
((*  box handlers  *)
"
 PROCEDURE doCompilerOptionBox;
 
"PROCEDURE setGetCompOpts (mode: SetGetMode);
"
$VAR notProtocol,
(found      : BOOLEAN;
(fname      : FileStr;
"
$BEGIN
&WITH CompilerParm DO
(SetGetBoxStr (optBox, Oname, mode, name);
(Upper (name);
(SetGetBoxState (optBox, Oquite, mode, checkObj, shortMsgs);
(SetGetBoxState (optBox, Opmark, mode, checkObj, protocol);
(IF mode = setValue THEN
*notProtocol := ~ protocol;
*SetGetBoxState (optBox, Oppath, setValue, disableObj, notProtocol);
*SetGetBoxState (optBox, Opwidth, setValue, disableObj, notProtocol);
(END;
(SetGetBoxStr (optBox, Oargs, mode, CompilerArgs);
(SetGetBoxStr (optBox, Oppath, mode, protName);
(SetGetBoxCard (optBox, Opwidth, mode, protWidth);
(IF protWidth < 10 THEN protWidth := stdProtWidth END;
(
(SetGetBoxStr (optBox, Ooutput, mode, MainOutputPath);
(ValidatePath (MainOutputPath);
(SetGetBoxStr (optBox, Olibrary, mode, DefLibName);
(IF mode = getValue THEN
*Upper (DefLibName);
*IF Length (FilePath (DefLibName)) = 0 THEN
,SearchFile (DefLibName, DefPaths, fromStart, found, DefLibName);
*END
(END;
(SetGetBoxStr (optBox, Oerror, mode, ErrListFile);
(Upper (ErrListFile);
&END;
$END setGetCompOpts;
$
 
"VAR   space, start    : Rectangle;
(exit            : CARDINAL;
"
"BEGIN
$AESUpdateWindow (TRUE);
$animateMenuTitle (Mparms, start);
$
$setGetCompOpts (setValue);
$PrepareBox (optBox, start, space);
$
$LOOP
&formDo (optBox, Ooutput, exit);
&
&CASE exit OF
(Ook, Oquit: DeselectButton (optBox, exit); EXIT|
(Oquite    : ToggleCheckBox (optBox, Oquite)|
(Opmark    : ToggleCheckPlus (optBox, Opmark,
EtwoCardsInArray (Oppath, Opwidth))|
&ELSE
&END;
$END;
$
$IF exit = Ook THEN setGetCompOpts (getValue) END;
$
$ReleaseBox(optBox, start, space);
$deAnimateMenuTitle (Mparms);
$AESUpdateWindow (FALSE);
"END doCompilerOptionBox;
 
 PROCEDURE doLinkerOptionBox;
 
"PROCEDURE setGetLinkOpts (mode: SetGetMode);
 
$VAR i       : CARDINAL;
(valid,
(notValid: BOOLEAN;
(refs    : ARRAY [1..4] OF ObjEnumRef;
$
$BEGIN
&SetGetBoxStr (linkBox, Loname, mode, LinkerParm.name);
&Upper (LinkerParm.name);
&FOR i:= 1 TO 8 DO
(WITH linkBoxIdx[i] DO
*SetGetBoxState (linkBox, check, mode, checkObj, LinkerParm.linkList[i].valid);
*IF mode = setValue THEN
,notValid := ~ LinkerParm.linkList[i].valid;
,SetGetBoxState (linkBox, path, setValue, disableObj, notValid);
*END;
*SetGetBoxStr (linkBox, path, mode, LinkerParm.linkList[i].name);
(END
&END;
&valid := (LinkerParm.linkStackSize # 0L); notValid := ~ valid;
&SetGetBoxState (linkBox, Lochecks, mode, checkObj, valid);
&IF mode = setValue THEN
(SetGetBoxState (linkBox, Lostack, setValue, disableObj, notValid);
&END;
&SetGetBoxLCard (linkBox, Lostack, mode, LinkerParm.linkStackSize);
&IF ~ valid THEN LinkerParm.linkStackSize := 0L END;
&SetGetBoxCard (linkBox, Lomaxmod, mode, LinkerParm.maxLinkMod);
&
&SetGetBoxState (linkBox, Lofastld, mode, checkObj, LinkerParm.fastLoad);
&SetGetBoxState (linkBox, Lofastco, mode, checkObj, LinkerParm.fastCode);
&SetGetBoxState (linkBox, Lofastme, mode, checkObj, LinkerParm.fastMemory);
&
&SetGetBoxState (linkBox, Losymfil, mode, checkObj, LinkerParm.symbolFile);
&
&refs[1].obj := Lonoopt;
&refs[1].value := WORD (noOptimize);
&refs[2].obj := Lonamopt;
&refs[2].value := WORD (nameOptimize);
&refs[3].obj := Lomiddle;
&refs[3].value := WORD (partOptimize);
&refs[4].obj := Lofull;
&refs[4].value := WORD (fullOptimize);
&i := ORD (LinkerParm.optimize);
&SetGetBoxEnum (linkBox, refs, mode, i);
&LinkerParm.optimize := VAL (LinkMode, i);
$END setGetLinkOpts;
$
 
"VAR   space, start    : Rectangle;
(exit, i         : CARDINAL;
"
"BEGIN
$AESUpdateWindow (TRUE);
$animateMenuTitle (Mparms, start);
$
$setGetLinkOpts (setValue);
$PrepareBox (linkBox, start, space);
$
$LOOP
&formDo (linkBox, Root, exit);
&
&IF (exit = Look) OR (exit = Loquit) THEN
(DeselectButton (linkBox, exit); EXIT
&ELSIF exit = Lochecks THEN
(ToggleCheckPlus (linkBox, Lochecks, Lostack)
&ELSIF (exit = Lofastld) OR (exit = Lofastco) OR (exit = Lofastme)
&OR (exit = Losymfil) THEN
(ToggleCheckBox (linkBox, exit)
&ELSE
(FOR i := 1 TO 8 DO
*IF linkBoxIdx[i].check = exit THEN
,ToggleCheckPlus (linkBox, exit, linkBoxIdx[i].path)
*END
(END;
&END;
$END;
$
$IF exit = Look THEN setGetLinkOpts (getValue) END;
"
$ReleaseBox(linkBox, start,space);
$deAnimateMenuTitle (Mparms);
$AESUpdateWindow (FALSE);
"END doLinkerOptionBox;
"
 PROCEDURE doScanBox (): BOOLEAN;
 
"VAR     but : CARDINAL;
"
"BEGIN
$ScanAddr := 0L;
$SetTextString (scanBox, Saddr, '');
$DoSimpleBox (scanBox, deskObjSpace (Scan), but);
$IF but = Sok THEN SetGetBoxLCard (scanBox, Saddr, getValue, ScanAddr) END;
$RETURN ScanAddr # 0L
"END doScanBox;
 
 (*  doFileBox -- Inquires a file name from the user, that becomes the new
!*               work file number 'idx', if 'idx # noCurrentWorkfile',
!*               else the new current file.
!*)
 
 PROCEDURE doFileBox (idx: INTEGER);
 
"VAR     str   : FileStr;
*but   : CARDINAL;
*space : Rectangle;
"
"BEGIN
$AESUpdateWindow (TRUE);
$SetCurrObjTree (fileBox, FALSE);
$IF idx = noCurrentWorkfile THEN
&hideObj (Cfcurr, FALSE);
&hideObj (Cfwork, TRUE);
&space := deskObjSpace (Cfname);
$ELSE
&str := WorkField.elems[idx].sourceName;
&IF Length (str) > fileBoxLength THEN str := '' END;
&SetTextString (fileBox, Cfedit, str);
&hideObj (Cfcurr, TRUE);
&hideObj (Cfwork, FALSE);
&space := deskObjSpace (WorkField.elems[idx].carrierIdx);
$END;
"
$DoSimpleBox (fileBox, space, but);
$
$IF but = Cfbok THEN
&GetTextString (fileBox, Cfedit, str); Upper (str);
&SearchFile (str, SrcPaths, fromStart, voidO, str);
&IF idx = noCurrentWorkfile THEN setCurrTextAndCode (str)
&ELSE setWorkfileName (idx, str) END;
$END;
$IF idx # noCurrentWorkfile THEN SetTextString (fileBox, Cfedit, '') END;
$AESUpdateWindow (FALSE);
"END doFileBox;
 
 TYPE    fNameBoxMode    = (requestFolderName, nameConflict);
 
 PROCEDURE doFNameBox (    mode: fNameBoxMode;
6VAR name: ARRAY OF CHAR;
6VAR ok  : BOOLEAN);
 
"VAR   but     : CARDINAL;
(start   : Rectangle;
(folder  : BOOLEAN;
 
"BEGIN
$folder := (mode = requestFolderName);
$IF folder THEN animateMenuTitle (Mdatei, start) ELSE start.w := -1 END;
$
$SetCurrObjTree (fNameBox, FALSE);
$hideObj (Fdfolder, NOT folder); hideObj (Fdconf, folder);
$
$SetTextString (fNameBox, Fdname, killPoint (name));
$DoSimpleBox (fNameBox, start, but);
$ok := (but = Fdok);
$IF ok THEN
&GetTextString (fNameBox, Fdname, name); Upper (name);
&Assign (addPoint (name), name, voidO);
$END;
$
$IF folder THEN deAnimateMenuTitle (Mdatei) END;
"END doFNameBox;
 
 (*$Z-*)
 PROCEDURE doConflictBox (VAR name: ARRAY OF CHAR): BOOLEAN;
 (*$Z=*)
 
"VAR   ok: BOOLEAN;
 
"BEGIN
$doFNameBox (nameConflict, name, ok); FlushEvents; ShowBee;
$IF shellParm.confirmCopy THEN drawObject (confirmBox, Root) END;
$RETURN ok
"END doConflictBox;
 
 PROCEDURE doShellParameterBox;
 
"PROCEDURE setGetShellParm (mode: SetGetMode);
"
$BEGIN
&WITH shellParm DO
(SetGetBoxEnum (shellParmBox,
7twoEnumsInRefArray (Sproot, FALSE, Spcurr, TRUE),
7mode, defaultOpenCurrDir);
(SetGetBoxState (shellParmBox, Spcopy, mode, checkObj, confirmCopy);
(SetGetBoxState (shellParmBox, Spdelete, mode, checkObj, confirmDelete);
(SetGetBoxState (shellParmBox, Spbreak, mode, checkObj, breakActive);
(SetGetBoxState (shellParmBox, Spallmem, mode, checkObj,
8useAllMemForCopy);
(SetGetBoxStr (shellParmBox, Spbaname, mode, batchPath);
(Upper (batchPath);
(SetGetBoxStr (shellParmBox, Sppaname, mode, parameterPath);
(Upper (parameterPath);
(SetGetBoxStr (shellParmBox, Spscpath, mode, TemporaryPath);
(ValidatePath (TemporaryPath);
(IF TemporaryPath[0] # HomeSymbol THEN
*MakeFullPath (TemporaryPath, voidI);
(END;
(SetGetBoxStr (shellParmBox, Spmake, mode, makeName);
(SetGetBoxStr (shellParmBox, Spfontn, mode, fontSetting.name);
(SetGetBoxCard (shellParmBox, Spfonts, mode, fontSetting.size);
(Upper (makeName);
&END;
$END setGetShellParm;
$
"VAR   space, start    : Rectangle;
(exit            : CARDINAL;
"
"BEGIN
$animateMenuTitle (Mparms, start);
$
$setGetShellParm (setValue);
$PrepareBox (shellParmBox, start, space);
$
$LOOP
&formDo (shellParmBox, Root, exit);
&
&CASE exit OF
(Spok, Spquit: DeselectButton (shellParmBox, exit); EXIT|
(
(Spcopy,
(Spdelete,
(Spbreak,
(Spallmem    : ToggleCheckBox (shellParmBox, exit)|
&ELSE
&END;
$END;
$
$IF exit = Spok THEN
&setGetShellParm (getValue);
&SetFonts;
$END;
$
$ReleaseBox(shellParmBox, start, space);
$deAnimateMenuTitle (Mparms);
"END doShellParameterBox;
 
 PROCEDURE doEditorParameterBox;
 
"PROCEDURE setGetEditorParm (mode: SetGetMode);
"
$VAR disable: BOOLEAN;
"
$BEGIN
&WITH EditorParm DO
(SetGetBoxStr (editorParmBox, Epname, mode, name);
(Upper (name);
(SetGetBoxState (editorParmBox, Epsearch, mode,
8checkObj, searchSources);
(SetGetBoxState (editorParmBox, Epstoper, mode,
8checkObj, waitOnError);
(SetGetBoxState (editorParmBox, Epshtemp, mode,
8checkObj, tempShellFile);
(disable := ~ tempShellFile;
(SetGetBoxState (editorParmBox, Epshname, mode, disableObj, disable);
(SetGetBoxStr (editorParmBox, Epshname, mode, tempShellName);
(
(SetGetBoxState (editorParmBox, Epedtemp, mode,
8checkObj, tempEditorFile);
(disable := ~ tempEditorFile;
(SetGetBoxState (editorParmBox, Epedname, mode, disableObj, disable);
(SetGetBoxStr (editorParmBox, Epedname, mode, tempEditorName);
 
(SetGetBoxState (editorParmBox, Eparg, mode,
8checkObj, passArgument);
(SetGetBoxState (editorParmBox, Eparname, mode,
8checkObj, passName);
(SetGetBoxState (editorParmBox, Eparerro, mode,
8checkObj, passErrorText);
(SetGetBoxState (editorParmBox, Eparpos, mode,
8checkObj, passErrorPos);
&END;
$END setGetEditorParm;
$
"VAR   start, space: Rectangle;
(exit        : CARDINAL;
 
"BEGIN
$animateMenuTitle (Mparms, start);
$
$setGetEditorParm (setValue);
$PrepareBox (editorParmBox, start, space);
$
$LOOP
&formDo (editorParmBox, Root, exit);
&
&CASE exit OF
(Epok, Epquit: DeselectButton (editorParmBox, exit); EXIT|
(
(Epsearch,
(Epstoper,
(Eparg,
(Eparname,
(Eparerro,
(Eparpos     : ToggleCheckBox (editorParmBox, exit)|
(Epshtemp    : ToggleCheckPlus (editorParmBox, Epshtemp, Epshname)|
(Epedtemp    : ToggleCheckPlus (editorParmBox, Epedtemp, Epedname)|
&ELSE
&END;
$END;
$
$IF exit = Epok THEN setGetEditorParm (getValue) END;
"
$ReleaseBox(editorParmBox, start, space);
$deAnimateMenuTitle (Mparms);
"END doEditorParameterBox;
"
 PROCEDURE showFormatStatus (tracks: CARDINAL; VAR stop: BOOLEAN);
 
"VAR   ch   : GemChar;
(valid: BOOLEAN;
 
"BEGIN
$SetGetBoxCard (formatBox, Foremain, setValue, tracks);
$drawObject (formatBox, Foremain);
$
$busyReadGemChar (ch, valid);
$stop := valid AND (ch.scan = undoKey);
"END showFormatStatus;
"
 PROCEDURE doFormatBox;
 
"PROCEDURE setGetFormat (mode: SetGetMode; VAR volName: NameStr);
"
$BEGIN
&SetGetBoxEnum (formatBox,
5twoEnumsInRefArray (Fosingle, 1, Fodouble, 2),
5mode, shellParm.sides);
&SetGetBoxEnum (formatBox,
5twoEnumsInRefArray (Fo80, 80, Fo81, 81),
5mode, shellParm.tracks);
&SetGetBoxEnum (formatBox,
5twoEnumsInRefArray (Fo9, 9, Fo10, 10),
5mode, shellParm.sectors);
&IF mode = setValue THEN volName := '' END;
&SetGetBoxStr (formatBox, Foname, mode, volName);
&volName := killPoint (volName);
$END setGetFormat;
$
"VAR   start,
(space    : Rectangle;
(volName  : NameStr;
(exit     : CARDINAL;
(drive    : FormatDrive;
(result   : FormatResult;
(driveName: CHAR;
 
"BEGIN
$AESUpdateWindow (TRUE);
$animateMenuTitle (Mdatei, start);
$setGetFormat (setValue, volName);
$hideObj (Foremain, TRUE);
$
$PrepareBox (formatBox, start, space);
$LOOP
&formDo (formatBox, Root, exit);
&DeselectButton (formatBox, exit);
&
&IF exit = Foquit THEN EXIT
&ELSE
(IF exit = Foa THEN drive := MOSGlobals.drvA; driveName := 'A'
(ELSE drive := MOSGlobals.drvB; driveName := 'B' END;
(
(flexAlert (2, driveName, '', formatAlt, exit);
(IF exit = 1 THEN
(
*ShowBee;
*hideObj (Foremain, FALSE);
*setGetFormat (getValue, volName);
*
*WITH shellParm DO
,FormatDisk (drive, sides, tracks, sectors, 1, volName,
8showFormatStatus, result);
*END;
*
*hideAndRedrawObj (Foremain, TRUE);
*ShowArrow;
*
*IF result # okFR THEN doAlert (formatErrAlt) END;
*
(END;
&END;
$END;
$
$ReleaseBox (formatBox, start, space);
$deAnimateMenuTitle (Mdatei);
$AESUpdateWindow (FALSE);
"END doFormatBox;
 
 PROCEDURE doFileInfoBox (VAR entry: DirEntry);
 
"VAR   name  : NameStr;
(isProt: BOOLEAN;
(
"PROCEDURE setGetFileInfo (mode: SetGetMode);
"
$BEGIN
&SetGetBoxStr (fileInfoBox, Finame, mode, name);
&SetGetBoxLCard (fileInfoBox, Fisize, mode, entry.size);
&SetGetBoxEnum (fileInfoBox, twoEnumsInRefArray (Firw, FALSE,
VFiprot, TRUE),
5mode, isProt);
$END setGetFileInfo;
$
"VAR   start : Rectangle;
(but   : CARDINAL;
 
"BEGIN
$animateMenuTitle (Mdatei, start);
$
$Assign (killPoint (entry.name), name, voidO);
$isProt := (readOnlyAttr IN entry.attr);
$setGetFileInfo (setValue);
$
$DoSimpleBox (fileInfoBox, start, but);
$
$IF but = Fiok THEN
&setGetFileInfo (getValue);
&Upper (name);
&Assign (addPoint (name), entry.name, voidO);
&IF isProt THEN INCL (entry.attr, readOnlyAttr)
&ELSE EXCL (entry.attr, readOnlyAttr) END;
$END;
$deAnimateMenuTitle (Mdatei);
"END doFileInfoBox;
"
 PROCEDURE doHelpBox (REF fname: ARRAY OF CHAR);
 
"CONST noLines = 14;   (*  Anzahl der Zeilen in der Hilfe-Box  *)
(noRows  = 65;
 
"VAR   start, space    : Rectangle;
(but, i,
(visibleLines    : CARDINAL;
(text            : List;
(err, end, first : BOOLEAN;
(f               : File;
(str             : ptrString;
(path            : PathStr;
 
"PROCEDURE fileErr (): BOOLEAN;
"
$VAR state: INTEGER;
$
$BEGIN
&state := State (f);
&IF (state < fOK) OR (state = fEOF)
&THEN
)ResetState (f);
)FileAlert (state);
)RETURN TRUE
&ELSE
)RETURN FALSE
&END;
$END fileErr;
$
"PROCEDURE addLine (obj: CARDINAL);
"
$BEGIN
&IF NOT end THEN
(str := NextEntry (text);
(IF str = NIL THEN end := TRUE ELSE INC (visibleLines) END;
&END;
&IF end THEN SetTextString (helpBox, obj, '')
&ELSE
(IF Length (str^) > noRows THEN
*Delete (str^, noRows, Length (str^) - noRows, voidO);
(END;
(SetTextString (helpBox, obj, str^);
&END;
$END addLine;
$
"BEGIN
$AESUpdateWindow (TRUE);
$animateMenuTitle (Minfo, start);
$
$(*  Lies Hilfe-Datei ein.
%*)
 
$Concat (ShellPath, fname, path, voidO);
$CreateList (text, err);
$IF err THEN
&reportOutOfMemory;
&deAnimateMenuTitle (Minfo);
&AESUpdateWindow (FALSE);
&RETURN
$END;
$ShowBee;
$Open (f, path, readSeqTxt);
$IF (State (f)) # fOK
$THEN
&doAlert (noHelpAlt);
&DeleteList (text, voidO);
&deAnimateMenuTitle (Minfo);
&ShowArrow;
&AESUpdateWindow (FALSE);
&RETURN
$END;
$LOOP
$
&NEW (str);
&IF str = NIL THEN reportOutOfMemory; EXIT END;
&IF fileErr () THEN DISPOSE (str); EXIT END;
&Text.ReadString (f, str^);
&AppendEntry (text, str, err);
&IF err THEN reportOutOfMemory; DISPOSE (str); EXIT END;
&IF fileErr () THEN EXIT END;
&Text.ReadLn (f);
$
$END;
$Close (f);
$ShowArrow;
$AESUpdateWindow (FALSE);
$
$(*  Zeige Hilfe-Datei an.
%*)
%
$ResetList (text);
$but := Hpnext; visibleLines := 0; first := TRUE;
$REPEAT
$
&IF but = Hpprev THEN
(IF EndOfList (text) THEN INC (visibleLines) END;
(FOR i := 1 TO noLines + visibleLines DO voidADR := PrevEntry (text) END;
&END;
&SetObjStateElem (helpBox, Hpprev, disableObj, EndOfList (text));
&end := FALSE; visibleLines := 0;
&addLine (Hpmsg1); addLine (Hpmsg2); addLine (Hpmsg3);
&addLine (Hpmsg4); addLine (Hpmsg5); addLine (Hpmsg6);
&addLine (Hpmsg7); addLine (Hpmsg8); addLine (Hpmsg9);
&addLine (Hpmsg10); addLine (Hpmsg11); addLine (Hpmsg12);
&addLine (Hpmsg13); addLine (Hpmsg14);
&SetObjStateElem (helpBox, Hpnext, disableObj, EndOfList (text));
&SetObjFlag (helpBox, Hpnext, defaultFlg, NOT EndOfList (text));
&SetObjFlag (helpBox, Hpquit, defaultFlg, EndOfList (text));
&
&IF first THEN PrepareBox (helpBox, start, space); first := FALSE
&ELSE DrawObject (helpBox, Root, MaxDepth, space) END;
&formDo (helpBox, Root, but);
&DeselectButton (helpBox, but);
&
$UNTIL but = Hpquit;
$ReleaseBox (helpBox, start, space);
$
$(*  Lsche Hilfe-Datei.
%*)
$deleteSimpleList (text, TRUE);
$
$deAnimateMenuTitle (Minfo);
"END doHelpBox;
 
 
 PROCEDURE doInfoBox;
 
 (*
!* Umgebungsinformationen
!*)
 
"VAR   dftPath,
(codeFile        : FileStr;
(dftPathEditable : BOOLEAN;
(
"PROCEDURE setGetInfo (mode: SetGetMode);
"
$VAR lc: LONGCARD; s: ARRAY [0..13] OF CHAR;
"
$BEGIN
&SetObjFlag (infoBox, Inpath, editFlg, dftPathEditable);
&SetGetBoxStr (infoBox, Inpath, mode, dftPath);
&SetGetBoxLCard (infoBox, Instack, mode, DefaultStackSize);
&SetGetBoxStr (infoBox, Inmkfile, mode, MakeFileName);
&SetGetBoxState (infoBox, Stponrtn, mode, checkObj, shellParm.waitOnReturn);
&Upper (MakeFileName);
&IF mode = setValue THEN
(lc := MemAvail ();
(SetGetBoxLCard (infoBox, Inblock, setValue, lc);
(lc := AllAvail ();
(SetGetBoxLCard (infoBox, Inall, setValue, lc);
(SetGetBoxStr (infoBox, Ihome, setValue, HomePath);
(SetGetBoxStr (infoBox, Incode, setValue, codeFile);
(SetGetBoxLCard (infoBox, Inlength, setValue, LastCodeSize);
(IF UsedFormat = IEEEReal THEN
*IF RealMode = 2 THEN
,s:= 'IEEE (ST-FPU)'
*ELSE
,s:= 'IEEE (TT-FPU)'
*END
(ELSE
*s:= 'Megamax'
(END;
(SetGetBoxStr (infoBox, Realform, setValue, s);
&END;
$END setGetInfo;
$
"VAR   space, start   : Rectangle;
(exit     : CARDINAL;
(res     : INTEGER;
 
"BEGIN
$animateMenuTitle (Minfo, start);
$
$GetDefaultPath (dftPath);
$dftPathEditable := (maxDftPathInfo >= Length (dftPath));
$truncCopyString (dftPath, maxDftPathInfo, dftPath);
$truncCopyString (LastCodeName, maxCodeFileInfo, codeFile);
$setGetInfo (setValue);
$
$PrepareBox (infoBox, start, space);
$LOOP
&formDo (infoBox, Root, exit);
&CASE exit OF
(Inok, Inquit: DeselectButton (infoBox, exit); EXIT|
(Stponrtn    : ToggleCheckBox (infoBox, exit)|
&ELSE
&END;
$END;
$ReleaseBox(infoBox, start, space);
$
$IF exit = Inok THEN
&setGetInfo (getValue);
&IF dftPathEditable THEN
(ValidatePath (dftPath);
(ReplaceHome (dftPath);
(SetDefaultPath (dftPath, res);
(FileAlert (res);
&END;
$END;
$deAnimateMenuTitle (Minfo);
"END doInfoBox;
"
 
0(*  Exportierte Box-Funktionen  *)
 
 PROCEDURE ScanBox (VAR name: ARRAY OF CHAR): BOOLEAN;
 
"VAR   but: CARDINAL;
 
"BEGIN
$SetTextString (sNameBox, Snedit, name);
$DoSimpleBox (sNameBox, deskObjSpace (Scan), but);
$CASE but OF
&Snok  : GetTextString(sNameBox, Snedit, name); Upper (name)|
&Snwork: WITH WorkField DO
0IF current >= 0
0THEN Assign(elems[current].sourceName, name, voidO)
0ELSE Assign ('', name, voidO); END;
.END|
$ELSE
$END;
$RETURN but # Snquit
"END ScanBox;
 
 PROCEDURE RequestArg (VAR name: ARRAY OF CHAR);
 
"BEGIN
$SetTextString (argBox, Aedit, name);
$DoSimpleBox (argBox, Rect (0, 0, 50, 30), voidC);
$GetTextString (argBox, Aedit, name);
"END RequestArg;
 
 TYPE    TellMode        = (initTell, newTellValue, endTell);
 
 PROCEDURE TellLoading (mode: TellMode; REF fname: ARRAY OF CHAR);
 
"VAR     start   : Rectangle;
"
"BEGIN
$start := Rect (0, 0, 50, 30);
$
$CASE mode OF
&initTell            : SetTextString (loadBox, Lfname, '');
<PrepareBox (loadBox, start, tellSpace);
<ShowBee|
<
&newTellValue        : SetTextString (loadBox, Lfname, '            ');
<drawObject (loadBox, Lfname);
<SetTextString (loadBox, Lfname, FileName (fname));
<drawObject (loadBox, Lfname)|
<
&endTell             : ReleaseBox (loadBox, start, tellSpace);
<ShowArrow|
$END;
"END TellLoading;
 
 
8(*  window managment  *)
8(*  ================  *)
(
((*  misc.  *)
 
 CONST   onlyOneSelected   = 0L;
(multipleSelect    = 1L;
(pickUpSelect      = 2L;
(pickUpMultiple    = multipleSelect + pickUpSelect;
(doubleClickSelect = 4L;
(
 
 (*  scanSlots -- calls the proc. 'match' for every window slot, until
!*               'match' supplies TRUE. Therefor the result is:
!*
!*     [(match (slot) = TRUE) AND (success = TRUE)] OR
!*     [(<for all> slot <elem> wdwSlotIdx : match (slot) = FALSE) AND
!*      (success = FALSE)]
!*)
 
 TYPE    scanProc        = PROCEDURE ((*slot: *) wdwSlotIdx): BOOLEAN;
 
 PROCEDURE scanSlots ((*$Z-*)
9match  : scanProc;
5(*$Z=*)
5VAR slot   : wdwSlotIdx;
5VAR success: BOOLEAN);
"BEGIN
$slot := MIN (wdwSlotIdx);
$LOOP
&IF match (slot) THEN success := TRUE; EXIT
&ELSIF slot = MAX (wdwSlotIdx) THEN success := FALSE; EXIT
&ELSE INC (slot) END;
$END;
"END scanSlots;
"
 PROCEDURE slotIsFree (slot: wdwSlotIdx): BOOLEAN;
 
"BEGIN
$RETURN ~ wdws[slot]^.used
"END slotIsFree;
"
 (*
 PROCEDURE slotIsUsed (slot: wdwSlotIdx): BOOLEAN;
 
"BEGIN
$RETURN wdws[slot]^.used
"END slotIsUsed;
!*)
 
 PROCEDURE isDirWdw (slot: wdwSlotIdx): BOOLEAN;
 
"BEGIN
$WITH wdws[slot]^ DO RETURN used AND (kind = dirWdw)
$END;
"END isDirWdw;
"
 PROCEDURE isModWdw (slot: wdwSlotIdx): BOOLEAN;
 
"BEGIN
$WITH wdws[slot]^ DO RETURN used AND (kind = modWdw)
$END;
"END isModWdw;
"
 PROCEDURE isTopWdw (slot: wdwSlotIdx): BOOLEAN;
 
"BEGIN
$RETURN IsTopWindowWL (wdws[slot]^.wl)
"END isTopWdw;
 
 PROCEDURE hasSelectedEntries (slot: wdwSlotIdx): BOOLEAN;
 
"BEGIN
$RETURN wdws[slot]^.noSelected > 0
"END hasSelectedEntries;
"
 
 (*$Z-*)
 PROCEDURE deselectEntry (entry, env: ADDRESS; VAR attrs: AttributesWL): BOOLEAN;
 (*$Z=*)
 
"BEGIN
$IF selectedWL IN attrs THEN entrySelected (env, entry, FALSE) END;
$RETURN TRUE
"END deselectEntry;
"
 PROCEDURE deselectWList (slotPtr: ptrWdwSlot);
 
"BEGIN
$QueryListWL (slotPtr^.wl, forwardWL, deselectEntry, slotPtr,
1voidO, voidADR);
"END deselectWList;
 
 
 PROCEDURE selectEntry (wl     : WindowList;
7entry,
7env    : ADDRESS;
7selMode: LONGCARD);
 
"VAR   slotPtr        : ptrWdwSlot;
(slot           : wdwSlotIdx;
(success,
(alreadySelected,
(err            : BOOLEAN;
(entry2         : ADDRESS;
 
"BEGIN
$slotPtr := ptrWdwSlot (env);
$
$careOfDeselectDrive;
$
$WITH slotPtr^ DO
&alreadySelected := selectedWL IN EntryAttributesWL (wl, entry);
&
&scanSlots (hasSelectedEntries, slot, success);
&IF success AND ((selMode = onlyOneSelected) OR (slotPtr # wdws[slot])
6OR (selMode = doubleClickSelect)
6OR ((selMode = pickUpSelect) AND ~ alreadySelected) )
&THEN
(deselectWList (wdws[slot])
&END;
$
&entrySelected (slotPtr, entry,
5NOT alreadySelected
5OR (alreadySelected AND (selMode # multipleSelect))
4);
$END;
"END selectEntry;
"
"
((*  directory windows  *)
 
 VAR     dirList  : List;
 
 (*$Z-*)
 PROCEDURE insertDirEntry (REF path: ARRAY OF CHAR; entry: DirEntry): BOOLEAN;
 (*$Z=*)
 
"VAR   data, e : ptrDirEntry;
(ins, err: BOOLEAN;
 
"BEGIN
$IF (entry.name[0] # '.')
'AND (entry.attr * FileAttrSet{hiddenAttr, systemAttr, volLabelAttr}
,= FileAttrSet{})
$THEN
$
&NEW (data);         (*  alloc. carrier  *)
&data^.entry := entry;
&data^.entry.attr := data^.entry.attr * FileAttrSet{subdirAttr};
&data^.str := '';
$
&(*  alphabetic order, folders first
'*)
'
&ResetList (dirList);
&LOOP
(e := NextEntry (dirList);
(IF e = NIL THEN
(
*AppendEntry (dirList, data, err);
*IF err THEN reportOutOfMemory; RETURN FALSE END;
*EXIT
*
(ELSE
*ins := (subdirAttr IN data^.entry.attr)
1AND NOT (subdirAttr IN e^.entry.attr);
*IF ~ ins AND (data^.entry.attr = e^.entry.attr)
*THEN
,ins := (fastCompare (data^.entry.name, e^.entry.name) = less)
*END;
*IF ins THEN
*
,e := PrevEntry (dirList);
,InsertEntry (dirList, data, err);
,IF err THEN reportOutOfMemory; RETURN FALSE END;
,EXIT
,
*END;
(END;
&END;
$
$END;
&
$RETURN TRUE
"END insertDirEntry;
 
 FORWARD dirEntryToStr (entry, env: ADDRESS; VAR str: MaxStr);
 
 FORWARD closeDirWdw (wl: WindowList; env: ADDRESS);
 
 PROCEDURE createDirList (slotPtr: ptrWdwSlot; VAR success:BOOLEAN);
 
"VAR err     : BOOLEAN;
&wildName: Str128;
&res     : INTEGER;
"
"BEGIN
$ShowBee;
$
$WITH slotPtr^ DO
$
&Concat (path, '*.*', wildName, success);
&IF ~ success THEN doAlert (pathToLongAlt); ShowArrow; RETURN END;
&
&CreateList (dirList, err); success := ~ err;
&IF err THEN reportOutOfMemory; ShowArrow; RETURN END;
$
&DirQuery (wildName, FileAttrSet{subdirAttr}, insertDirEntry, res);
&IF (res # fFileNotFound) AND (res # fOK)
&THEN
(FileAlert (res);
&END;
&
&SetListWL (wl, dirList,
5dirEntryToStr, closeDirWdw, selectEntry, slotPtr,
5dirWdwWidth, path);
5
$END;
$
$ShowArrow;
"END createDirList;
 
 PROCEDURE deleteDirList (slotPtr: ptrWdwSlot);
 
"VAR   l: List;
 
"BEGIN
$GetListWL (slotPtr^.wl, l);
$deleteSimpleList (l, TRUE);
$slotPtr^.noSelected := 0;
"END deleteDirList;
 
 
 (*  dirEntryToString -- Wandelt einen Directoryeintrag in einen String um.
!*)
!
 PROCEDURE dirEntryToStr (entry, env: ADDRESS; VAR str: MaxStr);
 
"CONST subdirChar      = 7C;   (*  Das Ordnerzeichen  *)
 
"VAR   dataPtr         : ptrDirEntry;
(slotPtr         : ptrWdwSlot;
(
(pre, suf        : ARRAY[0..7] OF CHAR;
(pos             : CARDINAL;
(str0            : String;
"
"PROCEDURE extendStr (offset: CARDINAL);
"
$BEGIN
&pos := pos + offset;
&appendSpcTo (pos, str);
$END extendStr;
$
"
"BEGIN
$dataPtr := ptrDirEntry (entry);
$slotPtr := ptrWdwSlot (env);
$
$IF Empty (dataPtr^.str) THEN
$
&WITH dataPtr^.entry DO
&
(pos := 0; str := '';
(
(IF isSubdir (dataPtr^.entry) THEN         (*  folder  *)
*Concat (' ',subdirChar, str, voidO)
(END;
(extendStr (dirLeftBorder);
(
(SplitName (name, pre, suf);
(Append (pre, str, voidO);                 (*  name  *)
(extendStr (dirNameLen);
(
(Append (suf, str, voidO);                 (*  extension  *)
(extendStr (dirExtLen + dirGap);
(
(IF ~ isSubdir (dataPtr^.entry) THEN       (*  size  *)
*Append (CardToStr (size, dirSizeLen), str, voidO);
(END;
(extendStr (dirSizeLen + dirGap);
(
(DateToText (date, '', str0);              (*  date  *)
(Append (str0, str, voidO);
(extendStr (dirDateLen + dirGap);
(
(TimeToText (time, '', str0);                  (*  time  *)
(Delete (str0, 5, 3, voidO);
(Append (str0, str, voidO);
(extendStr (dirTimeLen + dirRightBorder);
(
&END;
&
&Assign (str, dataPtr^.str, voidO);
$
$ELSE Assign (dataPtr^.str, str, voidO) END;
$
"END dirEntryToStr;
(
 PROCEDURE closeDirWdw (wl: WindowList; env: ADDRESS);
 
"VAR   slotPtr: ptrWdwSlot;
(i, j,
(len : INTEGER;
 
"BEGIN
$slotPtr := ptrWdwSlot (env);
$
$deleteDirList (slotPtr);
$ViewLineWL (slotPtr^.wl, 1);
&
$WITH slotPtr^ DO
$
&len := INTEGER (Length (path));
&i := PosLen ('\', path, 0);
&j := PosLen ('\', path, i + 1);
&IF j = len THEN                   (*  close root => close window  *)
&
(used := FALSE;
(HideWindowWL (wl);
(
&ELSE                              (*  close folder  *)
&
(WHILE j < (len - 1) DO
*i := j;
*j := PosLen ('\', path, i + 1);
(END;
(Delete (path, i + 1, j - i, voidO);
(createDirList (slotPtr, voidO);
(
&END;
$END;
"END closeDirWdw;
 
 (*  openDirWdw -- Opens a new directory window on drive 'drive'. Depending on
!*                on 'openCurrDir' the root or the current path of the drive
!*                is displayed.
!*                Result is the used window slot in 'slot' and 'success = TRUE'
!*                if no error occured.
!*)
"
 PROCEDURE openDirWdw (VAR slot       : wdwSlotIdx;
:driv       : Drive;
:openCurrDir: BOOLEAN);
 
"VAR   str    : Str128;
(drive  : MOSGlobals.Drive;
(result : INTEGER;
(success: BOOLEAN;
 
"BEGIN
$drive:= VAL (MOSGlobals.Drive, ORD (driv));
$
$scanSlots (slotIsFree, slot, success);
$IF ~ success THEN doAlert (noWindAlt); RETURN END;
$
$WITH wdws[slot]^ DO         (*  init.  *)
$
&Assign (DriveToStr (drive), path, voidO);
&IF openCurrDir
&THEN
(GetCurrentDir (drive, str);
(SetCurrentDir (drive, str, result);
(IF result < fOK
(THEN
*openCurrDir := FALSE;
*IF str[1] = 0C THEN RETURN END; (* RETURN, if 'str' describes root  *)
(END;
&END;
&IF openCurrDir
&THEN
(Append (str, path, success);
&ELSE
(Append ('\', path, success);
&END;
&
&kind := dirWdw;
&
$END;
$
$(*  create and display the 'WindowList'
%*)
$
$createDirList (wdws[slot], success); IF ~ success THEN RETURN END;
$ShowBee; ShowWindowWL (wdws[slot]^.wl); ShowArrow;
$IF StateWL (wdws[slot]^.wl) = cantShowWL THEN
&ResetStateWL (wdws[slot]^.wl);
&deleteDirList (wdws[slot]);
&doAlert (noWindAlt);
&RETURN
$END;
$wdws[slot]^.used := TRUE;
"END openDirWdw;
"
 PROCEDURE openFolder (slotPtr: ptrWdwSlot; data: ptrDirEntry);
 
"VAR   newPath : Str128;
(success : BOOLEAN;
 
"BEGIN
$IF isSubdir (data^.entry) THEN
$
&concatPath (slotPtr^.path, data^.entry.name, newPath, success);
&IF success THEN
(Append ('\', newPath, success);
(IF ~ success THEN doAlert (pathToLongAlt) END;
&END;
&
&IF success THEN
&
(deleteDirList (slotPtr);
(ViewLineWL (slotPtr^.wl, 1);
(Assign (newPath, slotPtr^.path, voidO);
(createDirList (slotPtr, success);
(
&END;
&
$END;
"END openFolder;
"
"
((*  module windows  *)
 
 (*  insertModEntry -- Inserts one module alphabetical in the 'modList'.
!*                    'modFlag = TRUE' means to insert every module, else
!*                    there are only loaded moduls inserted.
!*)
 
 VAR     modList: List;
(modFlag: BOOLEAN;
 
 PROCEDURE insertModEntry (REF codeName: ARRAY OF CHAR;
>codeAddr: ADDRESS;
>codeLen : LONGCARD;
>varAddr : ADDRESS;
>varLen  : LONGCARD;
:REF fileName: ARRAY OF CHAR;
>module  : BOOLEAN;
>loaded  : BOOLEAN;
>resident: BOOLEAN );
 
"VAR   data, e: ptrModEntry;
(err    : BOOLEAN;
"
"BEGIN
$IF modFlag OR loaded THEN
$
&NEW (data);
&IF data = NIL THEN reportOutOfMemory; RETURN END;
&
&WITH data^ DO
(Assign (codeName, name, voidO);
(lenOfCode := codeLen;
(lenOfVar := varLen;
(isModul := module;
(wasLoaded := loaded;
(isResident := resident;
&END;
&
&ResetList (modList);
&LOOP
(e := NextEntry (modList);
(IF e = NIL THEN
(
*AppendEntry (modList, data, err);
*IF err THEN reportOutOfMemory; RETURN END;
*EXIT
*
(ELSE
(
*IF fastCompare (data^.name, e^.name) = less THEN
*
,e := PrevEntry (modList);
,InsertEntry (modList, data, err);
,IF err THEN reportOutOfMemory; RETURN END;
,EXIT
,
*END;
(END;
&END;
&
$END;
"END insertModEntry;
 
 FORWARD modEntryToStr (entry, env: ADDRESS; VAR str: MaxStr);
 
 FORWARD closeModWdw (wl: WindowList; env: ADDRESS);
 
 PROCEDURE createModList (slotPtr: ptrWdwSlot; VAR success:BOOLEAN);
 
"VAR   err : BOOLEAN;
(w   : CARDINAL;
(name: FileStr;
"
"BEGIN
$AESUpdateWindow (TRUE);
$ShowBee;
$
$CreateList (modList, err); success := ~ err;
$IF err THEN reportOutOfMemory; ShowArrow; AESUpdateWindow (FALSE); RETURN END;
$WITH slotPtr^ DO
$
&modFlag := all;
$
&ModQuery (insertModEntry);
&
&IF all THEN
(Assign (modWdwTitleAll, name, voidO);
(w := modWdwWidthAll;
&ELSE
(Assign (modWdwTitle, name, voidO);
(w := modWdwWidth;
&END;
&SetListWL (wl, modList,
5modEntryToStr, closeModWdw, selectEntry, slotPtr,
5w, name);
5
$END;
$
$ShowArrow;
$AESUpdateWindow (FALSE);
"END createModList;
 
 PROCEDURE deleteModList (slotPtr: ptrWdwSlot);
 
"VAR   l: List;
"
"BEGIN
$GetListWL (slotPtr^.wl, l);
$deleteSimpleList (l, TRUE);
$slotPtr^.noSelected := 0;
"END deleteModList;
"
 
 PROCEDURE modEntryToStr (entry, env: ADDRESS; VAR str: MaxStr);
 
"VAR   dataPtr: ptrModEntry;
(slotPtr: ptrWdwSlot;
(
(pos    : CARDINAL;
"
"PROCEDURE extendStr (offset: CARDINAL);
"
$BEGIN
&pos := pos + offset;
&appendSpcTo (pos, str);
$END extendStr;
"
"PROCEDURE appFlg (REF text: ARRAY OF CHAR; len: CARDINAL; flg: BOOLEAN);
6
$BEGIN
&extendStr (modGap);
&
&IF flg THEN Append (text, str, voidO) END;
&extendStr (len);
$END appFlg;
$
"
"BEGIN
$dataPtr := ptrModEntry (entry);
$slotPtr := ptrWdwSlot (env);
$
$WITH dataPtr^ DO
$
&pos := 0; str := '';
&
&Assign (name, str, voidO);
&extendStr (maxModNameLen + modGap);
&
&Append (CardToStr (lenOfCode, lCardLog), str, voidO);
&extendStr (lCardLog + modGap);
&
&Append (CardToStr (lenOfVar, lCardLog), str, voidO);
&extendStr (lCardLog);
&
&appFlg (modModFlag, modModLen, isModul);
&IF slotPtr^.all THEN appFlg (modLoadFlag, modLoadLen, wasLoaded) END;
&appFlg (modRsdFlag, modRsdLen, isResident);
&
$END;
$
"END modEntryToStr;
 
 PROCEDURE closeModWdw (wl: WindowList; env: ADDRESS);
 
"VAR   slotPtr: ptrWdwSlot;
 
"BEGIN
$slotPtr := ptrWdwSlot (env);
$
$deleteModList (slotPtr);
$WITH slotPtr^
$DO
&used := FALSE;
&HideWindowWL (wl);
$END;
"END closeModWdw;
"
 PROCEDURE openModWdw (VAR slot       : wdwSlotIdx;
:allMods    : BOOLEAN);
"
"VAR   success: BOOLEAN;
"
"BEGIN
$scanSlots (slotIsFree, slot, success);
$IF ~ success THEN doAlert (noWindAlt); RETURN END;
$
$WITH wdws[slot]^ DO         (*  init.  *)
$
&all := allMods;
&
&kind := modWdw;
&used := TRUE;
&
$END;
$
$(*  create and display the 'WindowList'
%*)
$
$AESUpdateWindow (TRUE);
$createModList (wdws[slot], success); IF ~ success THEN AESUpdateWindow (FALSE); RETURN END;
$ShowBee; ShowWindowWL (wdws[slot]^.wl); ShowArrow;
$IF StateWL (wdws[slot]^.wl) = cantShowWL THEN
&ResetStateWL (wdws[slot]^.wl);
&doAlert (noWindAlt);
$END;
$AESUpdateWindow (FALSE);
"END openModWdw;
"
"
((*  general window proc.s  *)
 
 (*  getSelectedName -- Ermittelt die zu dem aktuell selektierten Fenster-
!*                     eintrag gehrende Zeichenkette.
!*                     Zustzlich wird noch der Typ des Eintrages geliefert.
!*                     Ist kein Eintrag oder sind mehrere selektiert, so
!*                     wird 'kind = noNK' geliefert.
!*                     'slot' liefert den Fensterslot, in dem sich der Eintrag
!*                     befindet.
!*)
 
 TYPE    nameKind        = (noNK, fileNK, folderNK, modulNK);
 
 PROCEDURE getSelectedName (VAR name      : ARRAY OF CHAR;
;VAR slot      : wdwSlotIdx;
;VAR kindOfName: nameKind);
 
"VAR   somethingSelected: BOOLEAN;
(entry            : ADDRESS;
(dirEntryPtr      : ptrDirEntry;
(modEntryPtr      : ptrModEntry;
(success          : BOOLEAN;
 
"BEGIN
$scanSlots (hasSelectedEntries, slot, somethingSelected);
$IF somethingSelected AND (wdws[slot]^.noSelected = 1) THEN
$
&WITH wdws[slot]^ DO
(entry := firstSelectedEntry (slot);
(IF kind = dirWdw THEN                   (*  dir. wdw  *)
(
*dirEntryPtr := ptrDirEntry (entry);
*concatPath (path, dirEntryPtr^.entry.name, name, success);
*IF success THEN
,IF isSubdir (dirEntryPtr^.entry) THEN kindOfName := folderNK
,ELSE kindOfName := fileNK END;
*ELSE kindOfName := noNK END;
*
(ELSE                                    (*  mod. wdw  *)
(
*modEntryPtr := ptrModEntry (entry);
*Assign (modEntryPtr^.name, name, voidO);
*kindOfName := modulNK;
*
(END;
&END;
&
$ELSE kindOfName := noNK END;
"END getSelectedName;
"
 PROCEDURE careOfDeselectEntries;
 
"VAR   slot   : wdwSlotIdx;
(success: BOOLEAN;
 
"BEGIN
$scanSlots (hasSelectedEntries, slot, success);
$IF success THEN deselectWList (wdws[slot]) END;
"END careOfDeselectEntries;
 
 PROCEDURE closeTopWdw (complete: BOOLEAN);
 
"VAR   slot   : wdwSlotIdx;
(success: BOOLEAN;
 
"BEGIN
$AESUpdateWindow (TRUE);
$scanSlots (isTopWdw, slot, success);
$IF success
$THEN
&WITH wdws[slot]^ DO CASE kind OF
&
(dirWdw  : IF complete THEN path := '' END;      (*  forces closure  *)
2closeDirWdw (wl, wdws[slot])|
(modWdw  : closeModWdw (wl, wdws[slot])|
(
&END END;
$END;
$AESUpdateWindow (FALSE);
"END closeTopWdw;
 
 PROCEDURE closeWdw (slot: wdwSlotIdx): BOOLEAN;
 
"BEGIN
$AESUpdateWindow (TRUE);
$WITH wdws[slot]^ DO IF used THEN CASE kind OF
&
(dirWdw  : path := '';                   (*  forces closure  *)
2closeDirWdw (wl, wdws[slot])|
(modWdw  : closeModWdw (wl, wdws[slot])|
(
$END END END;
$AESUpdateWindow (FALSE);
$RETURN FALSE
"END closeWdw;
 
 PROCEDURE hideWdw (slot: wdwSlotIdx): BOOLEAN;
 
"BEGIN
$WITH wdws[slot]^ DO IF used THEN
$
&CASE kind OF
$
(dirWdw  : deleteDirList (wdws[slot])|
(modWdw  : deleteModList (wdws[slot])|
(
&END;
&HideWindowWL (wl);
&
$END END;
$RETURN FALSE
"END hideWdw;
"
 PROCEDURE setTopWdw (slot: wdwSlotIdx): BOOLEAN;
 
"BEGIN
$IF wdws[slot]^.used AND wdws[slot]^.isTop THEN
&PutWindowOnTopWL (wdws[slot]^.wl);
$END;
$RETURN TRUE
"END setTopWdw;
"
 PROCEDURE showWdw (slot: wdwSlotIdx): BOOLEAN;
 
"VAR   success: BOOLEAN;
 
"BEGIN
$WITH wdws[slot]^ DO IF used THEN
$
&CASE kind OF
&
(dirWdw  : createDirList (wdws[slot], success)|
(modWdw  : createModList (wdws[slot], success)|
(
&END;
&IF success THEN
(AESUpdateWindow (TRUE);
(ShowBee; ShowWindowWL (wl); ShowArrow;
(AESUpdateWindow (FALSE);
(IF StateWL (wl) = cantShowWL THEN
*ResetStateWL (wl);
*voidO := hideWdw (slot);
*used := FALSE;
(END;
&ELSE used := FALSE END;
&
$END END;
$RETURN FALSE
"END showWdw;
 
 PROCEDURE updateModWdw (slot: wdwSlotIdx): BOOLEAN;
 
"VAR   slotPtr: ptrWdwSlot;
 
"BEGIN
$slotPtr := wdws[slot];
$AESUpdateWindow (TRUE);
$IF slotPtr^.used AND (slotPtr^.kind = modWdw) THEN
&deleteModList (slotPtr);
&createModList (slotPtr, voidO);
$END;
$AESUpdateWindow (FALSE);
$
$RETURN FALSE
"END updateModWdw;
"
 PROCEDURE updateWdw (slotPtr: ptrWdwSlot);
 
"BEGIN
$AESUpdateWindow (TRUE);
$CASE slotPtr^.kind OF
&dirWdw    : deleteDirList (slotPtr);
2createDirList (slotPtr, voidO)|
&modWdw    : deleteModList (slotPtr);
2createModList (slotPtr, voidO)|
$END;
$AESUpdateWindow (FALSE);
"END updateWdw;
"
 
 (*  detectWdw -- tries to find a window at 'loc', if success then
!*               'contSearch = FALSE' and 'slotPtr' references
!*               the slot of the window. If there is also an entry
!*               beneath 'loc', then 'entry' is a reference to the
!*               entry. In any other case 'entry = NIL'. 'clicks',
!*               'specials' and 'buts' are used to calc. the selection
!*               mode. 'mode' says, if a selection has to be done.
!*)
!
 PROCEDURE detectWdws (    loc       : Point;
:mode      : DetectModeWL;
:clicks    : CARDINAL;
:specials  : SpecialKeySet;
:buts      : MButtonSet;
6VAR entry     : ADDRESS;
6VAR slotPtr   : ptrWdwSlot;
6VAR contSearch: BOOLEAN);
(
"VAR   wls     : ARRAY wdwSlotIdx OF WindowList;
(wl      : WindowList;
(slot    : wdwSlotIdx;
(selMode : LONGCARD;
(env     : ADDRESS;
 
"BEGIN
$FOR slot := MIN (wdwSlotIdx) TO MAX (wdwSlotIdx) DO
&wls[slot] := wdws[slot]^.wl
$END;
$IF clicks = 1 THEN
&IF withShift (specials) THEN selMode := multipleSelect
&ELSE selMode := onlyOneSelected END;
&IF msBut1 IN buts THEN selMode := selMode + pickUpSelect END;
$ELSE selMode := doubleClickSelect END;
$
$DetectWindowWL (wls,0, loc, mode, selMode, wl, entry, env, contSearch);
$
$IF wl = NoWindowList THEN entry := NIL END;
$slotPtr := ptrWdwSlot (env);
"END detectWdws;
 
 
 PROCEDURE SetGetWindows (f: File; mode: SetGetMode);
 
"VAR   slot          : wdwSlotIdx;
"
(wdwParmCarrier: RECORD
(
:used, isTop : BOOLEAN;
:space       : Rectangle;
:
:CASE kind: wdwKind
:OF
<dirWdw    : path  : Str128|
<modWdw    : all   : BOOLEAN|
:END;
:
8END;
 
"BEGIN
$FOR slot := MIN (wdwSlotIdx) TO MAX (wdwSlotIdx) DO WITH wdws[slot]^ DO
&IF mode = setValue THEN
&
(ReadBlock (f, wdwParmCarrier); IF State (f) < fOK THEN RETURN END;
(
(tmpSpace:= wdwParmCarrier.space;
(used := wdwParmCarrier.used;
(isTop := wdwParmCarrier.isTop;
(IF used THEN
*kind := wdwParmCarrier.kind;
*CASE kind OF
,dirWdw    : path := wdwParmCarrier.path|
,modWdw    : all := wdwParmCarrier.all|
*END;
(END;
(
&ELSE
&
(wdwParmCarrier.space := WindowSizeWL (wl);
(wdwParmCarrier.used := used;
(wdwParmCarrier.isTop := isTop;
(IF used THEN
*wdwParmCarrier.kind := kind;
*CASE kind OF
,dirWdw    : wdwParmCarrier.path := path|
,modWdw    : wdwParmCarrier.all := all|
*END;
(END;
(
(WriteBlock (f, wdwParmCarrier); IF State (f) < fOK THEN RETURN END;
(
&END;
$END END;
"END SetGetWindows;
"
"
8(*  drag procs  *)
8(*  ==========  *)
 
 TYPE    dragObjectKind  = (fileDOK, filesDOK, modulDOK, modulsDOK);
(
(targetObjectKind= (objTOK, wdwTOK);
 
(targetObject    = RECORD
<CASE kind: targetObjectKind OF
<
>objTOK  : obj     : CARDINAL|
>
>(*  'valid = TRUE' means, that 'entry'
?*  is a valid target.
?*)
>wdwTOK  : slotPtr : ptrWdwSlot;
Hvalid   : BOOLEAN;
Hentry   : ADDRESS|
H
<END;
:END;
 
 (*  toggleTarget -- Toggle the target object, which is desribed by 'which'.
!*                  Don't toggle wdws without entry and the 'Root' object.
!*)
 
 PROCEDURE toggleTarget (which: targetObject; selected: BOOLEAN);
 
"VAR   found: BOOLEAN;
"
"BEGIN
$WITH which DO CASE kind OF
&objTOK  : IF obj # Root THEN toggleDeskObj (obj, voidO) END|
&wdwTOK  : IF valid THEN
2entrySelected (slotPtr, entry, selected)
0END|
$END END;
"END toggleTarget;
 
 TYPE    selObj          = RECORD
<loc  : Point;
<boxes: List;
:END;
(ptrSelObj       = POINTER TO selObj;
 
 PROCEDURE toggleSelectedBox (entry, env: ADDRESS): BOOLEAN;
 
"VAR   selObjPtr : ptrSelObj;
(data      : ptrRectangle;
(
(pts       : ARRAY[0..4] OF Point;
(x, y, w, h: INTEGER;
"
"BEGIN
$selObjPtr := ptrSelObj (env);
$data := ptrRectangle (entry);
$
$x := selObjPtr^.loc.x + data^.x; x := x - x MOD 2;
$y := selObjPtr^.loc.y + data^.y; y := y - y MOD 2;
$w := data^.w - data^.w MOD 2;
$h := data^.h - data^.h MOD 2;
$pts[0].x := x;
$pts[0].y := y;
$pts[1].x := x + w;
$pts[1].y := y;
$pts[2].x := x + w;
$pts[2].y := y + h;
$pts[3].x := x;
$pts[3].y := y + h;
$pts[4].x := x;
$pts[4].y := y;
$PolyLine (dev, pts, 0);
$
$RETURN TRUE
"END toggleSelectedBox;
"
 PROCEDURE dragSensitive (    objFrame: Rectangle;
=object  : ADDRESS;
=objKind : dragObjectKind;
9VAR loc     : Point;
9VAR result  : targetObject);
"
"(*  scanTarget -- Scans at 'loc' for icons, wdws, etc. Looks only at objects
#*                that are interesting for 'objKind'.
#*                If a wdw entry is not interesting 'result.valid = FALSE'
#*                and if an icon is not interesting 'result.obj = Root'.
#*
#*    This proc.s logic depends strongly on the semantic of the shells objs.
#*)
 
"PROCEDURE scanTarget (    loc      : Point;
<objKind  : dragObjectKind;
<oldResult: targetObject;
8VAR result   : targetObject);
 
$VAR contSearch,
(isModul,
(onlyOne,
(foundDrive,
(foundWorkfile: BOOLEAN;
(d            : Drive;
(i            : CARDINAL;
(dirEntryPtr  : ptrDirEntry;
"
$BEGIN
&isModul := (objKind = modulDOK) OR (objKind = modulsDOK);
&onlyOne := (objKind = modulDOK) OR (objKind = fileDOK);
&WITH result DO
&
(kind := wdwTOK;
(detectWdws (loc, scanWL, 0, SpecialKeySet {}, MButtonSet {}, entry,
4slotPtr, contSearch);
(
(IF ~ contSearch THEN
(
*(*  'valid = TRUE' is only allowed, if entry is a subdirectory
+*  and there are files moved and subdir. is not selected yet,
+*  or if it is same entry as the last entry (within 'oldResult').
+*)
*IF slotPtr^.kind = dirWdw THEN
,dirEntryPtr := ptrDirEntry (entry);
,valid := NOT ((entry = NIL) OR ~ isSubdir (dirEntryPtr^.entry)
:OR isModul
:OR ((selectedWL IN EntryAttributesWL (slotPtr^.wl,
_entry))
>AND ((entry # oldResult.entry)
COR NOT oldResult.valid
COR (oldResult.kind # wdwTOK))
9) );
*ELSE valid := FALSE; entry := NIL END;
*
(ELSE
(
*kind := objTOK;
*obj := FindObject (desk, Root, MaxDepth, loc);
*searchDrive (obj, d, foundDrive);
*searchWorkfile (obj, i, foundWorkfile);
*IF (obj # Trash) AND
-(~ onlyOne OR (obj # Execute)) AND
-(isModul OR ~ foundDrive) AND
-((objKind # fileDOK) OR
.((obj # Edit) AND (obj # Compile) AND (obj # Link) AND
/(obj # Scan) AND (obj # Resident) AND (obj # Cfname) AND
/~ foundWorkfile
.)
-) THEN obj := Root END;
(END;
*
&END;
$END scanTarget;
"
"PROCEDURE toggleObj (loc: Point; object: ADDRESS);
"
$VAR selObjPtr: ptrSelObj;
"
$BEGIN
&selObjPtr := ptrSelObj (object);
&
&SetClipping (dev, deskSize);
&SetLineColor (dev, black);
&SetWritingMode (dev, xorWrt);
&SetLineType (dev, userLn);
&DefUserLine (dev, $5555);
&
&HideMouse;
&selObjPtr^.loc := loc;
&applyAtList (selObjPtr^.boxes, toggleSelectedBox, object, voidO);
&ShowMouse;
&
$END toggleObj;
$
"PROCEDURE notSame (trgObj1, trgObj2: targetObject): BOOLEAN;
"
$VAR res: BOOLEAN;
"
$BEGIN
&res := (trgObj1.kind # trgObj2.kind);
&IF ~ res THEN
(IF trgObj1.kind = objTOK THEN res := (trgObj1.obj # trgObj2.obj)
(ELSE res := (trgObj1.slotPtr # trgObj2.slotPtr) OR
4(trgObj1.entry   # trgObj2.entry)
(END;
&END;
&RETURN res
$END notSame;
$
$
"VAR   buts     : MButtonSet;
(specials : SpecialKeySet;
(
(oldLoc   : Point;
(oldResult: targetObject;
(
(deskSize : Rectangle;
"
"BEGIN
$MouseControl (TRUE);
$
$deskSize := DeskSize ();
$MouseKeyState (oldLoc, buts, specials);
$oldLoc := loc;
$oldResult.kind := objTOK;
$oldResult.obj := Root;
$
$toggleObj (MinPoint (objFrame), object);
$
$WHILE msBut1 IN buts DO
$
&IF (loc.x # oldLoc.x) OR (loc.y # oldLoc.y) THEN
"
(toggleObj (MinPoint (objFrame), object);
(
(objFrame.x := objFrame.x - oldLoc.x + loc.x;
(objFrame.y := objFrame.y - oldLoc.y + loc.y;
"
(WITH objFrame DO                           (* Rahmen innerhalb Desk! *)
*IF x < deskSize.x THEN x := deskSize.x END;
*IF y < deskSize.y THEN y := deskSize.y END;
*IF (x + w) > (deskSize.x + deskSize.w) THEN
,x := deskSize.x + deskSize.w - w END;
*IF (y + h) > (deskSize.y + deskSize.h) THEN
,y := deskSize.y + deskSize.h - h END;
(END;
(
(scanTarget (loc, objKind, oldResult, result);
(
(IF notSame (result, oldResult) THEN
*toggleTarget (oldResult, FALSE);
*toggleTarget (result, TRUE);
*oldResult := result;
(END;
$
(toggleObj (MinPoint (objFrame), object);
(oldLoc := loc;
(
&END;(*IF*)
"
&MouseKeyState (loc, buts, specials);
"
$END;(*WHILE*)
$
$toggleObj (MinPoint (objFrame), object);
$
$MouseControl (FALSE);
"END dragSensitive;
 
 
 TYPE    (*  Environment record for 'frameSelectedBox' and 'buildObject'.
)*)
(fBEnvRec        = RECORD
<wl    : WindowList;
<frame : Rectangle;
<selObj: ptrSelObj;
:END;
(ptrFBEnv        = POINTER TO fBEnvRec;
 
 (*$Z-*)
 PROCEDURE frameSelectedBox (entry, env: ADDRESS; VAR attrs: AttributesWL): BOOLEAN;
 (*$Z=*)
 
"VAR   framerEnv: ptrFBEnv;
(box      : Rectangle;
 
"BEGIN
$IF selectedWL IN attrs THEN
$
&framerEnv := ptrFBEnv (env);
&
&GetEntryBoxWL (framerEnv^.wl, entry, box, voidO);
&box.w := box.w DIV INTEGER (dirWdwWidth) * INTEGER (dirVisibleWidth);
&IF framerEnv^.frame.h = 0 THEN framerEnv^.frame := box
&ELSE
(framerEnv^.frame := FrameRects (framerEnv^.frame, box)
&END;
&
$END;
$
$RETURN TRUE
"END frameSelectedBox;
 
 (*$Z-*)
 PROCEDURE buildObject (entry, env: ADDRESS; VAR attrs: AttributesWL): BOOLEAN;
 (*$Z=*)
 
"VAR   builderEnv: ptrFBEnv;
(box       : Rectangle;
(data      : ptrRectangle;
(err       : BOOLEAN;
(
"BEGIN
$builderEnv := ptrFBEnv (env);
$
$IF selectedWL IN attrs THEN WITH builderEnv^ DO
$
&GetEntryBoxWL (wl, entry, box, voidO);
&
&NEW (data);
&IF data = NIL THEN RETURN FALSE END;
&WITH box DO
(data^ := Rect (x - selObj^.loc.x, y - selObj^.loc.y,
7w DIV INTEGER (dirWdwWidth) * INTEGER (dirVisibleWidth),
7h);
&END;
&AppendEntry (selObj^.boxes, data, err);
&IF err THEN DISPOSE (data); RETURN FALSE END;
&
$END END;
&
$RETURN TRUE
"END buildObject;
"
 PROCEDURE moveFileModul (    slotPtr: ptrWdwSlot;
=which  : dragObjectKind;
=loc    : Point;
9VAR result : targetObject;
9VAR success: BOOLEAN);
9
"VAR   fBEnv : fBEnvRec;
(
(err   : BOOLEAN;
"
"BEGIN
$WITH slotPtr^ DO IF noSelected > 0 THEN
$
&fBEnv.wl := wl;
&fBEnv.frame.h := 0;
&QueryListWL (wl, forwardWL, frameSelectedBox, ADR (fBEnv),
3voidO, voidADR);
&
&NEW (fBEnv.selObj); success := (fBEnv.selObj # NIL);
&IF success THEN
(CreateList (fBEnv.selObj^.boxes, err); success := ~ err;
(IF NOT success THEN DISPOSE (fBEnv.selObj) END;
&END;
&IF err THEN reportOutOfMemory; RETURN END;
&fBEnv.selObj^.loc := MinPoint (fBEnv.frame);
&QueryListWL (wl, forwardWL, buildObject, ADR (fBEnv), voidO, voidADR);
&
&dragSensitive (fBEnv.frame, fBEnv.selObj, which, loc, result);
&
&deleteSimpleList (fBEnv.selObj^.boxes, TRUE);
&DISPOSE (fBEnv.selObj);
&
$END END;
"END moveFileModul;
"
 
8(*  misc. II  *)
8(*  ========  *)
 
 PROCEDURE enableAndDisableMenuItems;
 
"VAR   slot            : wdwSlotIdx;
(aDirWdwIsOpen,
(aModWdwIsOpen,
(aTopWdw,
(bothOpen        : BOOLEAN;
(kindOfName      : nameKind;
 
"BEGIN
$scanSlots (isDirWdw, slot, aDirWdwIsOpen);
$scanSlots (isModWdw, slot, aModWdwIsOpen);
$scanSlots (isTopWdw, slot, aTopWdw);
$
$bothOpen := (aDirWdwIsOpen OR aModWdwIsOpen);
$
$EnableItem (menu,Mdclose, bothOpen);
$EnableItem (menu,Mdclosew, bothOpen);
$EnableItem (menu,Mdfolder, aTopWdw AND (wdws[slot]^.kind = dirWdw));
$
$getSelectedName (void128, voidSlot, kindOfName);
$
$EnableItem (menu,Mdinfo, (kindOfName = fileNK)
=OR (kindOfName = folderNK)
=OR (selectedDrive # defaultDrv));
$
$EnableItem (menu,Mdnwork, WorkField.noUsed < maxWorkFiles);
$EnableItem (menu,Mdkwork, WorkField.current # noCurrentWorkfile);
"END enableAndDisableMenuItems;
 
0(*  Arbeitende Routinen  *)
0(*  ===================  *)
 
 FORWARD HideSS (complete: BOOLEAN);
 FORWARD ShowSS (isCompleteHidden: BOOLEAN);
 
 (*  selectWorkfile -- Selects another work file object. Only used slots would
!*                    be selected.
!*)
!
 PROCEDURE selectWorkfile (i: INTEGER);
 
"VAR   old: INTEGER;
 
"BEGIN
$IF ~ WorkField.elems[i].used THEN i := noCurrentWorkfile END;
$old := WorkField.current;
$WorkField.current := i;
$IF old >= 0 THEN redrawWorkfile (old) END;
$IF i >= 0 THEN redrawWorkfile (i) END;
"END selectWorkfile;
 
 (*  makeNewWorkfile -- Tries to make another work file object.
!*)
!
 PROCEDURE makeNewWorkfile;
 
"VAR   i    : CARDINAL;
(
"BEGIN
$animateMenuTitle (Mdatei, voidFrame);
$
$(*  find free slot.
%*)
$(* wir wollen mit Nr. 1 anfangen, erst nach Nr. 9 soll Nr. 0 kommen *)
$i := 1;
$WHILE (i <= maxWorkFiles) AND WorkField.elems[i MOD 10].used DO INC (i) END;
$IF i = 10 THEN i:= 0 END;
$
$IF i < maxWorkFiles THEN    (*  if found, then init. slot  *)
$
&INC (WorkField.noUsed);
&WITH WorkField.elems[i] DO
(used := TRUE;
(sourceName := '';
(codeName := '';
&END;
&selectWorkfile (i);
&
$ELSE
&doAlert (noNewWorkAlt)
$END;
$
$deAnimateMenuTitle (Mdatei);
"END makeNewWorkfile;
 
 (*  killWorkfile -- Releases the current workfile object.
!*)
 
 PROCEDURE killWorkfile;
 
"BEGIN
$animateMenuTitle (Mdatei, voidFrame);
$
$WITH WorkField DO
&IF current # noCurrentWorkfile THEN
&
(DEC (noUsed);
(elems[current].used := FALSE;
(redrawWorkfile (current);
(current := noCurrentWorkfile;
(
&END;
$END;
&
$deAnimateMenuTitle (Mdatei);
"END killWorkfile;
#
 PROCEDURE saveParameter;
 
"VAR   but: CARDINAL;
 
"BEGIN
$FormAlert (1, parmSaveAlt^, but);
$IF but = 1 THEN SaveParameter END;
"END saveParameter;
 
 PROCEDURE makeFolder;
 
"VAR   ok,
(success: BOOLEAN;
(name   : Str128;
(slot   : wdwSlotIdx;
(result : INTEGER;
 
"BEGIN
$IF ObjectStateElem (menu, Mdfolder, disableObj) THEN RETURN END;
$
$AESUpdateWindow (TRUE);
$name := '';
$doFNameBox (requestFolderName, name, ok);
$IF ok THEN
$
&scanSlots (isTopWdw, slot, success);
&IF ~ success THEN
(AESUpdateWindow (FALSE);
(RETURN
&END;
&concatPath (wdws[slot]^.path, name, name, success);
&IF ~ success THEN AESUpdateWindow (FALSE); RETURN END;
&
&ShowBee;
&CreateDir (name, result); FileAlert (result);
&ShowArrow;
&
&updateWdw (wdws[slot]);
&
$END;
$AESUpdateWindow (FALSE);
"END makeFolder;
 
 PROCEDURE inform;
 
"VAR   spc          : LONGCARD;
(slot         : wdwSlotIdx;
(name         : Str128;
(kindOfName   : nameKind;
 
"BEGIN
$AESUpdateWindow (TRUE);
$IF selectedDrive # defaultDrv THEN          (*  drive info  *)
&ShowBee; spc := FreeSpace (MOSGlobals.Drive(selectedDrive)); ShowArrow;
&flexAlert (1, DriveToStr (MOSGlobals.Drive(selectedDrive)),
(CardToStr (spc, 0), drvSpaceMsg, voidC);
$ELSE
&getSelectedName (name, slot, kindOfName);
&IF (kindOfName=fileNK) OR (kindOfName=folderNK) THEN  (* file info *)
(FileInformation (name, doFileInfoBox, FileAlert);
(updateWdw (wdws[slot]);
&END;
$END;
$AESUpdateWindow (FALSE);
"END inform;
 
 (*$Z-*)
 PROCEDURE addEntryToList (entry, env: ADDRESS; VAR attrs: AttributesWL): BOOLEAN;
 (*$Z=*)
 
"VAR   dirEntryPtr: ptrDirEntry;
(listPtr    : ptrList;
(err        : BOOLEAN;
 
"BEGIN
$dirEntryPtr := ptrDirEntry (entry);
$listPtr := ptrList (env);
$
$IF selectedWL IN attrs
$THEN
&AppendEntry (listPtr^, ADR (dirEntryPtr^.entry.name), err)
$ELSE err := FALSE END;
$
$RETURN ~ err
"END addEntryToList;
 
 PROCEDURE showCopyStatus (noFiles: CARDINAL; VAR stop: BOOLEAN);
 
"VAR   ch   : GemChar;
(valid: BOOLEAN;
 
"BEGIN
$IF shellParm.confirmCopy THEN
&SetGetBoxCard (confirmBox, Conumber, setValue, noFiles);
&drawObject (confirmBox, Conumber);
$END;
$
$busyReadGemChar (ch, valid);
$stop := valid AND (ch.scan = undoKey);
"END showCopyStatus;
"
 PROCEDURE showDeleteStatus (noFiles: CARDINAL; VAR stop: BOOLEAN);
 
"VAR   ch   : GemChar;
(valid: BOOLEAN;
 
"BEGIN
$IF shellParm.confirmDelete THEN
&SetGetBoxCard (confirmBox, Conumber, setValue, noFiles);
&drawObject (confirmBox, Conumber);
$END;
$
$busyReadGemChar (ch, valid);
$stop := valid AND (ch.scan = undoKey);
"END showDeleteStatus;
"
 TYPE    copyDeleteMode  = (copyCDM, deleteCDM);
 
 PROCEDURE prepareCopyAndDelete (    slotPtr: ptrWdwSlot;
Dmode   : copyDeleteMode;
@VAR files  : List;
@VAR noFiles: CARDINAL;
@VAR space  : Rectangle;
@VAR ok     : BOOLEAN;
@VAR err    : BOOLEAN);
 
"VAR   exitBut: CARDINAL;
 
"BEGIN
$WITH slotPtr^ DO
&CreateList (files, err);
&IF err THEN reportOutOfMemory; RETURN END;
&QueryListWL (wl, forwardWL, addEntryToList, ADR (files), err, voidADR);
&IF err THEN deleteList (files); reportOutOfMemory; RETURN END;
&
&IF ((mode = copyCDM) AND shellParm.confirmCopy)
)OR ((mode = deleteCDM) AND shellParm.confirmDelete) THEN
)
(ShowBee;
(CountFilesAndDirs (path, files, noFiles);
(
(SetCurrObjTree (confirmBox, FALSE);
(hideObj (Cocopy, mode = deleteCDM); hideObj (Codelete, mode = copyCDM);
(hideObj (Cook, FALSE); hideObj (Coquit, FALSE);
(hideObj (Cowork, TRUE);
(SetGetBoxCard (confirmBox, Conumber, setValue, noFiles);
(
(PrepareBox (confirmBox, Rect (-1, -1, -1, -1), space);
(formDo (confirmBox, Root, exitBut);
(DeselectButton (confirmBox, exitBut);
(ok := (exitBut = Cook);
(
(IF ok THEN
*SetCurrObjTree (confirmBox, FALSE);
*hideAndRedrawObj (Cook, TRUE); hideAndRedrawObj (Coquit, TRUE);
*hideAndRedrawObj (Cowork, FALSE);
(END;
&
&ELSE noFiles := 0; ok := TRUE END;
$END;
$ShowBee;
"END prepareCopyAndDelete;
 
 PROCEDURE copyFiles (slotPtr  : ptrWdwSlot;
5REF destPath : ARRAY OF CHAR;
5deleteOld: BOOLEAN);
 
"VAR   files  : List;
(noFiles: CARDINAL;
(ok, err: BOOLEAN;
(space  : Rectangle;
 
"BEGIN
$prepareCopyAndDelete (slotPtr, copyCDM, files, noFiles, space, ok, err);
$IF err THEN RETURN END;
$IF ok THEN
&CopyFiles (slotPtr^.path, files, noFiles, destPath,
1deleteOld, shellParm.useAllMemForCopy,
1doConflictBox, showCopyStatus, FileAlert);
$END;
$IF shellParm.confirmCopy THEN
&ReleaseBox (confirmBox, Rect (-1, -1, -1, -1), space)
$END;
$deleteList (files);
$ShowArrow;
"END copyFiles;
 
 PROCEDURE deleteFiles (slotPtr: ptrWdwSlot);
 
"VAR   files  : List;
(noFiles: CARDINAL;
(ok, err: BOOLEAN;
(space  : Rectangle;
 
"BEGIN
$prepareCopyAndDelete (slotPtr, deleteCDM, files, noFiles, space, ok, err);
$IF err THEN RETURN END;
$IF ok THEN
&DeleteFiles (slotPtr^.path, files, noFiles, showDeleteStatus, FileAlert);
$END;
$IF shellParm.confirmDelete THEN
&ReleaseBox (confirmBox, Rect (-1, -1, -1, -1), space)
$END;
$deleteList (files);
$ShowArrow;
"END deleteFiles;
 
 (*  actManager -- Prepares the shell to execute a shell action and then calls
!*                the 'action' procedure in the outer module.
!*
!*                'obj'       -- Desktop object associated with the desired
!*                               action.
!*                'specials'  -- Special keys pressed at action selection time.
!*                'work'      -- Parameter of the action is a work file?
!*                'tool'      -- Is a executed file a tool? (to set the correct
!*                               path in 'call')
!*                'alsoExec'  -- Also excecute code after compilation?
!*)
"
 PROCEDURE actManager (obj     : CARDINAL;
6specials: SpecialKeySet;
6work,
6tool,
6alsoExec: BOOLEAN);
 
"PROCEDURE assignMsg (REF name: ARRAY OF CHAR);
$BEGIN
&truncCopyString (name, msgStrLen, msgStr);
$END assignMsg;
 
"PROCEDURE setSourceCurrFnAndMsg;
$BEGIN
&IF ~work AND (currFn[0]='') THEN
(currFn := lastFn;
&END;
&IF work THEN
(WITH WorkField DO
*IF current >= 0 THEN assignMsg (elems[current].sourceName)
*ELSE msgStr := '' END;
(END;
&ELSE assignMsg (currFn) END;
$END setSourceCurrFnAndMsg;
$
"PROCEDURE setCodeCurrFnAndMsg;
$BEGIN
&IF ~work AND (currFn[0]='') THEN
(currFn := CodeName;
&END;
&IF work THEN
(WITH WorkField DO
*IF current # noCurrentWorkfile THEN
,assignMsg (elems[current].codeName)
*ELSE msgStr := '' END;
(END;
&ELSE assignMsg (currFn) END;
$END setCodeCurrFnAndMsg;
"
"TYPE  testProc        = PROCEDURE (REF (* name: *) ARRAY OF CHAR): BOOLEAN;
$
"PROCEDURE testWorkAndCurrFn ((*$Z-*)test: testProc(*$Z=*)): BOOLEAN;
$BEGIN
&WITH WorkField DO
(IF work AND (current = noCurrentWorkfile) THEN RETURN FALSE
(ELSE
*RETURN (work AND test (elems[current].sourceName)) OR test (currFn)
(END;
&END;
$END testWorkAndCurrFn;
$
"VAR slot       : wdwSlotIdx;
&wasSelected: BOOLEAN;
 
"BEGIN
$selectDeskObj (obj, TRUE, wasSelected);
$CASE obj OF
&Compile  : setSourceCurrFnAndMsg;
1IF testWorkAndCurrFn (isMakeFile) THEN
3IF alsoExec THEN action (doMkEx, work, tool)
3ELSE action (doMake, work, tool) END;
1ELSE
3IF alsoExec THEN action (doCpEx, work, tool)
3ELSE action (doComp, work, tool) END;
1END|
&Edit     : setSourceCurrFnAndMsg; action (doEdit, work, tool)|
&Execute  : setCodeCurrFnAndMsg;
1Assign (lastFn, TextName, voidO);
1IF ~ work AND IsSourceName (currFn) THEN
3assignMsg (currFn);
3action (doExec, work, tool);
1ELSE
3IF testWorkAndCurrFn (IsMBTFile)    (*  exec. Batch-File  *) THEN
5action (doBtch, work, tool);
3ELSIF testWorkAndCurrFn (isMSPFile) (*  exec. Parm.-File  *) THEN
5action (doParm, work, tool);
3ELSIF testWorkAndCurrFn (isMakeFile)(*  exec. Make-File  *) THEN
5action (doMkEx, work, tool);
3ELSE                                (*  exec. norm. code  *)
5IF withShift (specials) THEN
7RequestArg (lastArgs);
7args := lastArgs;
5ELSE
7args := '';
5END;
5noDirChange := withAlt (specials);
5action (doExec, work, tool);
5noDirChange := FALSE;
3END;
1END;
1Assign (TextName, lastFn, voidO)|
&Link     : setCodeCurrFnAndMsg; action (doLink, work, tool)|
&
&Scan     : setSourceCurrFnAndMsg;
1IF (ChainDepth < 0) OR ~ withShift (specials) THEN
3IF doScanBox () THEN
5action (doScan, work, tool);
3END;
1ELSE msgStr := ''; action (doCont, TRUE, tool) END|
1
&Resident : setCodeCurrFnAndMsg;
1IF work THEN
3openModWdw (slot, withAlt (specials))
1ELSE
3AESUpdateWindow (TRUE);
3HideSS (FALSE);
3TellLoading (initTell, '');
3action (doLoad, FALSE, tool);
3TellLoading (endTell, '');
3ShowSS (FALSE);
3scanSlots (updateModWdw, voidSlot, voidO);
3AESUpdateWindow (FALSE);
1END|
$ELSE
$END;
$IF ~ wasSelected THEN selectDeskObj (obj, FALSE, voidO) END;
"END actManager;
9
 PROCEDURE executeTool (i: CARDINAL; specials: SpecialKeySet);
 
"VAR   code: FileStr;
 
"BEGIN
$IF ToolField[i].used AND NOT Empty (ToolField[i].name) THEN
&currFn := ToolField[i].name;
&code := CodeName;           (* Akt. Code-Datei retten *)
&actManager (Execute, specials, FALSE, TRUE, FALSE);
&CodeName := code;           (* Akt. Code-Datei wiederherstellen *)
$END;
"END executeTool;
 
 PROCEDURE editDocu (specials: SpecialKeySet);
 
"VAR   oldText, oldLast: FileStr;
"
"BEGIN
$animateMenuTitle (Minfo, voidFrame);
$
$ConcatName (shellParm.parameterPath, suf[m2d], currFn);
$oldText := TextName;
$oldLast := lastFn;
$actManager (Edit, specials, FALSE, FALSE, FALSE);
$TextName := oldText;
$lastFn := oldLast;
$
$deAnimateMenuTitle (Minfo);
"END editDocu;
"
 
 CONST   maxObjsElem             = 1023;
 
 TYPE    loadAndUnloadMode       = (loadModuls, unloadModuls);
(loadAndUnloadEnv        = RECORD
(
Dmode: loadAndUnloadMode;
D
D(*  Storage area for the obj. names.
E*  Seperated through '0C's. 'free'
E*  points to the next free elem.
E*)
Dobjs: ARRAY[0..maxObjsElem] OF CHAR;
Dfree: CARDINAL;
D
BEND;
(ptrLoadAndUnloadEnv     = POINTER TO loadAndUnloadEnv;
 
 (*$Z-*)
 PROCEDURE loadAndUnloadOneModul (    entry,
Eenv   : ADDRESS;
AVAR attrs : AttributesWL): BOOLEAN;
 (*$Z=*)
 
"VAR   envPtr          : ptrLoadAndUnloadEnv;
(dirEntryPtr     : ptrDirEntry;
(modEntryPtr     : ptrModEntry;
(l, i            : CARDINAL;
 
"BEGIN
$envPtr := ptrLoadAndUnloadEnv (env);
$
$IF selectedWL IN attrs
$THEN
&WITH envPtr^ DO
&
(IF mode = loadModuls THEN               (*  laden  *)
&
*dirEntryPtr := ptrDirEntry (entry);
*l := Length (dirEntryPtr^.entry.name);
*IF (l + free) > maxObjsElem THEN RETURN FALSE END;
*FOR i := 0 TO l - 1 DO
,objs[free] := dirEntryPtr^.entry.name[i];
,INC (free);
*END;
*objs[free] := 0C;
*INC (free);
*(*Insert (dirEntryPtr^.entry.name, free, objs); is wohl put*)
*
(ELSE                                    (*  lschen  *)
(
*modEntryPtr := ptrModEntry (entry);
*l := Length (modEntryPtr^.name);
*IF (l + free) > maxObjsElem THEN RETURN FALSE END;
*FOR i := 0 TO l - 1 DO
,objs[free] := modEntryPtr^.name[i];
,INC (free);
*END;
*objs[free] := 0C;
*INC (free);
*(*Insert (modEntryPtr^.name, free, objs); is wohl put*)
*
(END;
((*INC (free, l + 1);    (*  '0C' nicht vergessen  *)*)
(
&END;
$END;
$
$RETURN TRUE
"END loadAndUnloadOneModul;
 
 PROCEDURE loadAndUnload (slotPtr: ptrWdwSlot; mode: loadAndUnloadMode);
 
"VAR   env     : loadAndUnloadEnv;
(str     : ARRAY[0..79] OF CHAR;
(i, j    : CARDINAL;
(err,
(success : BOOLEAN;
 
"BEGIN
$env.mode := mode;
$env.free := 0;
$QueryListWL (slotPtr^.wl, forwardWL, loadAndUnloadOneModul, ADR (env),
1err, voidADR);
$IF err THEN doAlert (loadFailedAlt); RETURN END;
$
$AESUpdateWindow (TRUE);
$HideSS (FALSE);
$IF mode = loadModuls THEN TellLoading (initTell, '') END;
$
$i := 0;
$j := 0;
$WHILE j < env.free DO
&str[i] := env.objs[j];
&INC (i);
&IF env.objs[j] = 0C THEN
(IF mode = loadModuls THEN
*TellLoading (newTellValue, str);
*concatPath (slotPtr^.path, str, currFn, success);
*IF success THEN action (doLoad, FALSE, FALSE) END;
(ELSE
*Assign (str, currFn, voidO);
*action (doUnLd, FALSE, FALSE);
(END;(*ELSE*)
(i := 0;
&END;(*IF*)
&INC (j);
$END;(*WHILE*)
$IF mode = loadModuls THEN TellLoading (endTell, '') END;
&
$ShowSS (FALSE);
$scanSlots (updateModWdw, voidSlot, voidO);  (*  mod. wdws updaten  *)
$AESUpdateWindow (FALSE);
"END loadAndUnload;
!
 
0(*  Routinen zur De-/Aktivierung der ShellShell  *)
0(*  ===========================================  *)
"
 PROCEDURE ClearDeskAndShowMsg;
 
"BEGIN
$MenuBar (NIL, FALSE);
$SetNewDesk (NIL, Root);
$ForceDeskRedraw;
$IF NOT multiGEM & NOT multiTOS THEN
&(* MS unter MultiGEM nichts in Menleise zeichnen *)
&DrawObject (msgBar, Root, MaxDepth, ObjectSpaceWithAttrs (msgBar, Root));
$END;
"END ClearDeskAndShowMsg;
 
 PROCEDURE ShowSS (isCompleteHidden: BOOLEAN);
 
"VAR   i   : INTEGER;
(name: NameStr;
 
"BEGIN
$IF isCompleteHidden THEN
$
&SetCurrGemHandle (gemHdl, ok);
&IF ~ ok THEN (* Shell mu hier terminieren ! *) HALT END;
&
&setTools;
&FOR i := 0 TO maxWorkFiles - 1 DO WITH WorkField.elems[i] DO
(SplitPath (sourceName, void128, name);
(SetTextString (desk, nameIdx, name);
(SetObjStateElem (desk, identIdx, selectObj,
9WorkField.current = INTEGER (i));
(hideObj (carrierIdx, ~ used);
&END END;
&
&MouseInput (TRUE);
&ShowArrow;
&SetNewDesk (desk, Root);
&ForceDeskRedraw;
&MenuBar (menu, TRUE);
$END;
$
$scanSlots (showWdw, voidSlot, voidO);
$scanSlots (setTopWdw, voidSlot, voidO);
"END ShowSS;
"
 
 (*  InitWorkfile -- Set hide-flag of the object carrier and find out the
!*                  object indices.
!*                  The box-char is completely covered from an i-box, that
!*                  is the box-char's only child!
!*)
!
 PROCEDURE InitWorkfile (workfileNumber, crrIdx: CARDINAL);
 
"VAR head, tail: CARDINAL;
&space     : Rectangle;
 
"BEGIN
$hideObj (crrIdx, TRUE);
$ensureVisibility (crrIdx);
$WITH WorkField.elems[workfileNumber] DO
$
&carrierIdx := crrIdx;
&
&GetObjRelatives (carrierIdx, voidC, head, tail);
&LOOP
&
(IF ObjectType (head) = boxCharObj THEN
*GetObjRelatives (head, voidC, identIdx, voidC)
(ELSIF ObjectType (head) = boxTextObj THEN nameIdx := head END;
(
(IF head # tail THEN head := RightSister (head)
(ELSE EXIT END;
(
&END;
&
$END;
"END InitWorkfile;
 
 PROCEDURE InitSS () :BOOLEAN;
 
"(*  installDriveIcons -- Das 'drives'-Array wird init. und fr jedes vor-
#*                       handene LW wird ein Icon auf dem Desktop erzeugt.
#*                       ACHTUNG: Voraussetzung ist, das LW A: vorhanden ist.
#*)
 
"PROCEDURE installDriveIcons;
"
$CONST bufferSize = 4096;    (*  4k are necessary for TT  *)
"
$VAR   d,d2      : Drive;
*
*p, q      : Point;
*f1, f2    : Rectangle;
*text      : String;
*p1, p2    : PtrBitPattern;
*t         : ObjType;
*s         : Rectangle;
*col1, col2,
*pos, len  : CARDINAL;
*fl        : OFlagSet;
*obj       : CARDINAL;
*infBuf    : ARRAY[0..bufferSize - 1] OF CHAR;
*online    : DriveSet;
*found     : BOOLEAN;
(
$BEGIN
&online := DriveSet (DrivesOnline ());
&SetCurrObjTree (desk, FALSE);
&FOR d := minDrv TO maxDrv DO
(drives[d].available := FALSE;
(hideObj (drives[d].treeIndex, TRUE);
&END;
&
&(*  get the object parm.s from drive A:
'*)
'
&obj := Drivea;
&t := ObjectType (obj); s := ObjectSpace (obj);
&fl := ObjectFlags (obj) - OFlagSet{lastObjFlg, hideTreeFlg};
&GetIconColor (obj, col1, col2);
&GetIconForm (obj, p, f1, f2);
&GetIconLook (obj, p1, p2, void128, voidCh);
&
&ShellGet (infBuf, 0); pos := 0; len := Length (infBuf);
&
&FOR d := drvA TO maxDrv DO
(IF d IN online THEN
*drives[d].available := TRUE;
*obj := drives[d].treeIndex;
*SetObjType (obj, t);
*SetObjSpace (obj, TransRect (s, MinPoint (ObjectSpace (obj))));
*ensureVisibility (obj);
*SetObjFlags (obj, fl);
*IF obj # Drivea THEN
,CreateSpecification (obj, NIL);
,IF ObjTreeError () THEN doAlert (memFullAlt) END;
*END;
*SetIconColor (obj, col1, col2);
*SetIconForm (obj, p, f1, f2);
7
*(* get disk name *)
*pos := 0;
*found := FALSE;
*LOOP
,pos := PosLen ('#M', infBuf, pos);
,IF pos >= len THEN EXIT END;
,pos := pos + 17;
,Concat (infBuf[pos - 2], ':', text, voidO);
,d2 := Drive (StrToDrive (text));
,IF (d2 IN online) & (d2 = d) THEN
.Copy (infBuf, pos, PosLen ('@', infBuf, pos) - pos, text, found);
.EXIT;
,END;
*END;
*IF found THEN
,SetIconLook (obj, p1,p2,create,text,CHR (ORD ('A') + ORD (d) - 1 ))
*ELSE
,Assign ('Laufwerk',text,voidO);
,SetIconLook (obj, p1,p2,create,text,CHR (ORD ('A') + ORD (d) - 1 ))
*END;
(END;
&END;
&
$END installDriveIcons;
"
"VAR     success: BOOLEAN;
*slot   : wdwSlotIdx;
*devParm: PtrDevParm;
*space  : Rectangle;
*x, w   : INTEGER;
"
"BEGIN
$IF MemAvail () < minNecessaryMem THEN RETURN FALSE END;
$
$InitGem (RC,dev, success);
$IF ~ success THEN
&IF GemActive () THEN
(multiStringAlert (noGemAlt1,noGemAlt2, voidC);
&END;
&RETURN FALSE
$ELSE
&gemHdl:=CurrGemHandle ();
$END;
$ShellPath:= HomePath;
$
$GEMBase.GetPBs (gemHdl, vdiPB, aesPB);
$multiGEM:= aesPB.pglobal^.count > 1;
$multiTOS:= aesPB.pglobal^.count = -1;
$
 (*$ ? DebugWdw:
"
$TextWindows.Open (dWdw, 40,20, WQualitySet{titled, dynamic, movable},
6TextWindows.noHideWdw, noForce, ' Debug - Fenster ',
655,3,20,10, voidO);
$
!*)
#
$deskSize := DeskSize ();
$CharSize (dev, charWidth, charHeight);
$IF deskSize.x MOD INTEGER (charWidth) # 0
$THEN
&alignedDeskSize.x := deskSize.x + INTEGER (charWidth)
;- deskSize.x MOD INTEGER (charWidth);
&alignedDeskSize.w := deskSize.w - (alignedDeskSize.x - deskSize.x);
$ELSE
&alignedDeskSize.x := deskSize.x;
&alignedDeskSize.w := deskSize.w;
$END;
$IF deskSize.y MOD INTEGER (charHeight) # 0
$THEN
&alignedDeskSize.y := deskSize.y + INTEGER (charHeight)
;- deskSize.y MOD INTEGER (charHeight);
&alignedDeskSize.h := deskSize.h - (alignedDeskSize.y - deskSize.y);
$ELSE
&alignedDeskSize.y := deskSize.y;
&alignedDeskSize.h := deskSize.h;
$END;
$
2(*  Resource laden und Baumadressen ermitteln  *)
2
$LoadResource (resourceFile);
$IF GemError () THEN
&multiStringAlert (noRscAlt1,noRscAlt2, voidC);
&ExitGem (gemHdl);
&TermProcess (0)
$END;
$
$menu          := TreeAddress (Menu);
$msgBar        := TreeAddress (Msgbar);
$desk          := TreeAddress (Desktop);
$scanBox       := TreeAddress (Scanbox);
$shellBox      := TreeAddress (Shellbox);
$optBox        := TreeAddress (Optbox);
$fileInfoBox   := TreeAddress (Finfobox);
$fileBox       := TreeAddress (Filebox);
$sNameBox      := TreeAddress (Snamebox);
$argBox        := TreeAddress (Argbox);
$linkBox       := TreeAddress (Loptbox);
$loadBox       := TreeAddress (Loadbox);
$fNameBox      := TreeAddress (Fldrbox);
$shellParmBox  := TreeAddress (Sparmbox);
$formatBox     := TreeAddress (Formabox);
$confirmBox    := TreeAddress (Confibox);
$editorParmBox := TreeAddress (Eparmbox);
$helpBox       := TreeAddress (Helpbox);
$infoBox       := TreeAddress (Infobox);
$
$noWindAlt     := TextStringAddress (Nowdwalt);
$pathToLongAlt := TextStringAddress (Pathalt);
$windErrAlt    := TextStringAddress (Windalt);
$cOptToLongAlt := TextStringAddress (Optalt);
$wrgIcon2Alt   := TextStringAddress (Icon2alt);
$memFullAlt    := TextStringAddress (Memalt);
$drvSpaceMsg   := TextStringAddress (Spacemsg);
$debugAlt      := TextStringAddress (Debugalt);
$parmSaveAlt   := TextStringAddress (Parmsalt);
$formatAlt     := TextStringAddress (Formaalt);
$formatErrAlt  := TextStringAddress (Foerralt);
$noParmAlt     := TextStringAddress (Noparalt);
$ContMakeAlt   := TextStringAddress (Contmalt);
$noNewWorkAlt  := TextStringAddress (Nowrkalt);
$exitShellAlt  := TextStringAddress (Exitalt);
$loadFailedAlt := TextStringAddress (Loadalt);
$noHelpAlt     := TextStringAddress (Nohlpalt);
$fontErrAlt    := TextStringAddress (Alrtfont);
$
$NoLoadStr     := TextStringAddress (Noldstr);
$OkStr         := TextStringAddress (Okstr);
$EditStr       := TextStringAddress (Editstr);
$EditBatStr    := TextStringAddress (Editbstr);
$NoPathsStr    := TextStringAddress (Npathstr);
$NoUnloadStr   := TextStringAddress (Nouldstr);
$NoExecStr     := TextStringAddress (Noexestr);
$RetStr        := TextStringAddress (Retstr);
$EdStr         := TextStringAddress (Edstr);
$WorkStr       := TextStringAddress (Workstr);
$CompStr       := TextStringAddress (Compstr);
$LinkStr       := TextStringAddress (Linkstr);
$InfStr        := TextStringAddress (Infstr);
$ContStr       := TextStringAddress (Contstr);
$MakeStr       := TextStringAddress (Makestr);
$
$
2(*  'desk' und 'msgBar'-Ausmae der Gre
3*   des Ausgabegerts anpassen
3*)
"
$devParm := DeviceParameter (dev);
$
$SetCurrObjTree (desk, FALSE);
$space := ObjectSpace (Root);
$space.w := devParm^.rasterWidth + 1;
$space.h := devParm^.rasterHeight + 1;
$SetObjSpace (Root, space);
$
$SetCurrObjTree (msgBar, FALSE);
$space.h := deskSize.y-1;
$SetObjSpace (Root, space);
$SetObjSpace (Mbmsg, space);
$
$LinkTextString (Mbmsg, ADR (msgStr));
 
2(* Indizes ermitteln *)
 
$linkBoxIdx[1].check := Locheck1;
$linkBoxIdx[1].path  := Lofname1;
$linkBoxIdx[2].check := Locheck2;
$linkBoxIdx[2].path  := Lofname2;
$linkBoxIdx[3].check := Locheck3;
$linkBoxIdx[3].path  := Lofname3;
$linkBoxIdx[4].check := Locheck4;
$linkBoxIdx[4].path  := Lofname4;
$linkBoxIdx[5].check := Locheck5;
$linkBoxIdx[5].path  := Lofname5;
$linkBoxIdx[6].check := Locheck6;
$linkBoxIdx[6].path  := Lofname6;
$linkBoxIdx[7].check := Locheck7;
$linkBoxIdx[7].path  := Lofname7;
$linkBoxIdx[8].check := Locheck8;
$linkBoxIdx[8].path  := Lofname8;
$
2(* Bume initalisieren *)
2
$drives[drvA].treeIndex := Drivea;
$drives[drvB].treeIndex := Driveb;
$drives[drvC].treeIndex := Drivec;
$drives[drvD].treeIndex := Drived;
$drives[drvE].treeIndex := Drivee;
$drives[drvF].treeIndex := Drivef;
$drives[drvG].treeIndex := Driveg;
$drives[drvH].treeIndex := Driveh;
$drives[drvI].treeIndex := Drivei;
$drives[drvJ].treeIndex := Drivej;
$drives[drvK].treeIndex := Drivek;
$drives[drvL].treeIndex := Drivel;
$drives[drvM].treeIndex := Drivem;
$drives[drvN].treeIndex := Driven;
$drives[drvO].treeIndex := Driveo;
$drives[drvP].treeIndex := Drivep;
$
$(*  init. work file obj.s
%*)
$SetCurrObjTree (desk, FALSE);
$InitWorkfile (0, Work0);
$InitWorkfile (1, Work1);
$InitWorkfile (2, Work2);
$InitWorkfile (3, Work3);
$InitWorkfile (4, Work4);
$InitWorkfile (5, Work5);
$InitWorkfile (6, Work6);
$InitWorkfile (7, Work7);
$InitWorkfile (8, Work8);
$InitWorkfile (9, Work9);
$
$ensureVisibility (Trash);
$ensureVisibility (Edit); ensureVisibility (Compile);
$ensureVisibility (Execute); ensureVisibility (Link);
$ensureVisibility (Resident); ensureVisibility (Scan);
$ensureVisibility (Currfile);
$
$SetTextString (fileBox, Cfedit, '');
$SetTextString (shellBox, Version, ShellRevision);
$
$
2(*  Initalisiere 'Tools'-Indizies  *)
2
$ToolField[1].index := Mtool1;
$ToolField[2].index := Mtool2;
$ToolField[3].index := Mtool3;
$ToolField[4].index := Mtool4;
$ToolField[5].index := Mtool5;
$ToolField[6].index := Mtool6;
$ToolField[7].index := Mtool7;
$ToolField[8].index := Mtool8;
$ToolField[9].index := Mtool9;
$ToolField[10].index := Mtool10;
$
$(*  init of the window slots
%*)
$
$x := firstWdwColumn;
$w := (screenColumns - firstWdwColumn - dirVisibleWidth) DIV maxWdw;
$
$FOR slot := MIN (wdwSlotIdx) TO MAX (wdwSlotIdx) DO
$
&NEW (wdws[slot]);
&WITH wdws[slot]^ DO
(CreateWL (wl, FALSE, Rect (x, CenterWindowWL,
CdirVisibleWidth, MaxWindowWL));
(used := FALSE;
(noSelected := 0;
(x := x + w;
&END;
&
$END;
$
$TemporaryPath:= ShellPath;
$LoadParameter (shellParm.parameterPath);
$
$installDriveIcons;
$
$ShowSS (TRUE);
$
$RETURN TRUE;
"END InitSS;
 
 PROCEDURE HideSS (complete: BOOLEAN);
 
"BEGIN
$scanSlots (hideWdw, voidSlot, voidO);
$IF complete THEN ClearDeskAndShowMsg END;
$ShowBee;
"END HideSS;
 
 PROCEDURE ExitSS;
 
"VAR     slot: wdwSlotIdx;
"
"BEGIN
$msgStr := '';
$HideSS (TRUE);
$
$(*  deinit of the window slots
%*)
$
$FOR slot := MIN (wdwSlotIdx) TO MAX (wdwSlotIdx) DO WITH wdws[slot]^ DO
&DeleteWL (wl);
&DISPOSE (wdws[slot]);
$END END;
$
$FreeResource;
$(* ExitGem (gemHdl); *)
"END ExitSS;
 
*
0(*  Routinen zur Event-Verarbeitung  *)
0(*  ===============================  *)
 
 (*  keyManager -- Bearbeitet alle keyboard events
!*)
 
 (*$Z-*)
 PROCEDURE keyManager (VAR ch: GemChar; VAR specials: SpecialKeySet): BOOLEAN;
 (*$Z=*)
 
"CONST   aCode   = BYTE (30);    (*  Buchstabentasten  *)
*cCode   = BYTE (46);
*eCode   = BYTE (18);
*fCode   = BYTE (33);
*iCode   = BYTE (23);
*lCode   = BYTE (38);
*nCode   = BYTE (49);
*mCode   = BYTE (50);
*oCode   = BYTE (24);
*pCode   = BYTE (25);
*qCode   = BYTE (16);
*rCode   = BYTE (19);
*sCode   = BYTE (31);
*uCode   = BYTE (22);
*xCode   = BYTE (45);
*
*code1A  = BYTE (2);     (*  Ziffern  *)
*code0A  = BYTE (11);
*code7N  = BYTE (103);
*code0N  = BYTE (112);
*
*plusCode= BYTE (27);    (*  <+>  *)
*
*clrHome = BYTE (71);    (*  <Clr>-Taste  *)
*delete  = BYTE (83);    (*  <Delete>-Taste  *)
*help    = BYTE (98);    (*  <Help>-Taste  *)
*escape  = BYTE (1);     (*  <Esc>-Taste  *)
*f1      = BYTE (59);    (*  <F1>  *)
*f10     = BYTE (68);    (*  <F10>  *)
*shiftF1 = BYTE (84);    (*  Shift + <F1>  *)
*shiftF10= BYTE (93);    (*  Shift + <F10>  *)
"
"VAR     buts    : MButtonSet;
*loc     : Point;
*
*slot    : wdwSlotIdx;
*slotPtr : ptrWdwSlot;
*success : BOOLEAN;
*msg     : String;
*
$PROCEDURE withoutCtrl () :BOOLEAN;
$BEGIN
&RETURN ~ (controlKey IN specials)
$END withoutCtrl;
"
"BEGIN
"
$(* MouseKeyState (loc, buts, specials); *)
$CASE ch.scan OF
$
&escape   : scanSlots (isTopWdw, slot, success);  (*  update window  *)
1IF success THEN
1
3slotPtr := wdws[slot];
3CASE slotPtr^.kind OF
1
5dirWdw : ForceMediaChange (StrToDrive (slotPtr^.path)) |
5modWdw : slotPtr^.all := (alternateKey IN specials)|
5
3END;
3updateWdw (slotPtr);
3
1END|
(
&(*  Icons  *)
&
&aCode    : actManager (Execute, specials, withoutCtrl (), FALSE, FALSE)|
&cCode    : IF withAlt (specials) THEN doCompilerOptionBox
1ELSE
3actManager (Compile, specials, withoutCtrl (), FALSE, FALSE)
1END|
&eCode    : IF withAlt (specials) THEN doEditorParameterBox
1ELSE
3actManager (Edit, specials, withoutCtrl (), FALSE, FALSE)
1END|
&lCode    : IF withAlt (specials) THEN doLinkerOptionBox
1ELSE
3actManager (Link, specials, withoutCtrl (), FALSE, FALSE)
1END|
&sCode    : actManager (Scan, specials, withoutCtrl (), FALSE, FALSE)|
&rCode    : actManager (Resident, specials, withoutCtrl (), FALSE, FALSE)|
&plusCode : actManager (Compile, specials, withoutCtrl (), FALSE, TRUE)|
&
&pCode    : IF withCtrl (specials) THEN doFileBox (noCurrentWorkfile)
1ELSIF WorkField.current # noCurrentWorkfile THEN
3doFileBox (WorkField.current);
1END|
&
&mCode    : Concat ('Making: ', MakeFileName, msg, voidO);
1truncCopyString (msg, msgStrLen, msgStr);
1action (doDftM, FALSE, FALSE)|
 
&(*  Menu: Datei  *)
&
&iCode    : inform|
&oCode    : makeFolder|
&clrHome  : IF withBothShifts (specials)
1THEN
3scanSlots (closeWdw, voidSlot, voidO);
1ELSE
3closeTopWdw (withShift (specials));
1END|
&nCode    : makeNewWorkfile|
&delete   : killWorkfile|
&qCode    : IF withCtrl (specials) THEN quitStatus := quickQuit
1ELSE quitStatus := quit END|
&
&(*  Menu: Parameter  *)
&
&xCode    : IF withCtrl (specials) THEN saveParameter
1ELSE doShellParameterBox END|
&
&(*  Menu: Info  *)
&
&uCode    : doInfoBox|
&help     : IF withShift (specials) THEN editDocu (specials)
1ELSE doHelpBox (helpFile) END|
&
&(*  Menu: Tools  *)
&
&f1..f10  : executeTool (ORD (ch.scan) - ORD (f1) + 1, specials)|
&shiftF1..shiftF10
/: INCL (specials, leftShiftKey);
1executeTool (ORD (ch.scan) - ORD (shiftF1) + 1, specials)|
&
&(*  work files  *)
&
&code1A..code0A,
&code7N..code0N
/: selectWorkfile (ORD (ch.ascii) - ORD ('0'))|
1
$ELSE RETURN TRUE END;
$
$RETURN FALSE;
"END keyManager;
 
 (*  butManager -- Bearbeitet alle mouse button events
!*)
 
 PROCEDURE moveFiles (slotPtr: ptrWdwSlot; loc: Point; specials: SpecialKeySet);
 
"VAR   result       : targetObject;
(success,
(foundDrive,
(foundWorkfile: BOOLEAN;
(objKind      : dragObjectKind;
(name,
(destPath     : Str128;
(kindOfName   : nameKind;
(dirEntryPtr  : ptrDirEntry;
(drive        : Drive;
(workfileIdx  : CARDINAL;
 
"BEGIN
$getSelectedName (name, voidSlot, kindOfName);
$IF kindOfName = fileNK THEN objKind := fileDOK
$ELSE objKind := filesDOK END;
$
$moveFileModul (slotPtr, objKind, loc, result, success);
$IF ~ success THEN RETURN END;
$
$toggleTarget (result, FALSE);
$CASE result.kind OF
$
&objTOK: searchDrive (result.obj, drive, foundDrive);
.searchWorkfile (result.obj, workfileIdx, foundWorkfile);
.IF foundDrive THEN                (*  copy into drive  *)
0Assign (DriveToStr (MOSGlobals.Drive(drive)), destPath, voidO);
0copyFiles (slotPtr, destPath, FALSE);
.ELSIF foundWorkfile THEN
0setWorkfileName (workfileIdx, currFn)
.ELSE                              (*  action  *)
0CASE result.obj OF
2Trash    : deleteFiles (slotPtr);
=updateWdw (slotPtr)|
2Edit,
2Compile,
2Execute,
2Link,
2Resident,
2Scan     : actManager (result.obj, specials,
IFALSE, FALSE, FALSE)|
0END;
.END|
.
&wdwTOK: IF (result.entry = NIL)
1OR NOT (selectedWL IN EntryAttributesWL (result.slotPtr^.wl,
Zresult.entry)) THEN
.
0IF result.slotPtr^.kind = dirWdw  (*  dir. wdw  *)
0THEN
2destPath := result.slotPtr^.path; (* copy into wdw/folder  *)
2IF result.valid THEN
4dirEntryPtr := ptrDirEntry (result.entry);
4appendPath (dirEntryPtr^.entry.name, destPath, success);
2END;
2copyFiles (slotPtr, destPath, FALSE);
2IF NOT result.valid THEN updateWdw (result.slotPtr) END;
2
0ELSE                              (*  mod. wdw  *)
2loadAndUnload (slotPtr, loadModuls)
0END;
0
.END|
0
$END;
$
"END moveFiles;
"
 PROCEDURE moveModuls (slotPtr: ptrWdwSlot; loc: Point; specials: SpecialKeySet);
 
"VAR   result : targetObject;
(success: BOOLEAN;
(kind   : dragObjectKind;
 
"BEGIN
$kind := modulDOK;
$IF slotPtr^.noSelected > 1 THEN kind := modulsDOK END;
$
$moveFileModul (slotPtr, kind, loc, result, success);
$IF ~ success THEN RETURN END;
 
$CASE result.kind OF
$
&objTOK: CASE result.obj OF
&
0Execute       : actManager (Execute, specials,
LFALSE, FALSE, FALSE)|
0Trash         : (* HideSS (FALSE);
@action (doUnLd, FALSE, FALSE);
@ShowSS (FALSE);
A*)
@(*scanSlots (updateModWdw, voidSlot, voidO); *)
@loadAndUnload (slotPtr, unloadModuls)|
0
.ELSE doAlert (wrgIcon2Alt) END|
.
&wdwTOK: doAlert (wrgIcon2Alt)|
&
$END;
*
$toggleTarget (result, FALSE);
"END moveModuls;
 
 
 (*$Z-*)
 PROCEDURE butManager (clicks  : CARDINAL;
6loc     : Point;
6buts    : MButtonSet;
6specials: SpecialKeySet): BOOLEAN;
 (*$Z=*)
 
"VAR     obj, but        : CARDINAL;
*on              : BOOLEAN;
*str10           : ARRAY[0..10] OF CHAR;
*lStr            : Str128;
*sc              : SpecialKeySet;
*
*slot            : wdwSlotIdx;
*slotPtr         : ptrWdwSlot;
*dirEntryPtr     : ptrDirEntry;
*modEntryPtr     : ptrModEntry;
*entry           : ADDRESS;
*
*kindOfName      : nameKind;
*
*mode            : DetectModeWL;
*openCurrDir     : BOOLEAN;
*loc2            : Point;
*
*drive           : Drive;
*workfileIdx     : CARDINAL;
*foundDrive,
*foundWorkfile,
*contSearch      : BOOLEAN;
*
$PROCEDURE selectArea;
$
&VAR      selMode: LONGCARD;
&
&BEGIN
(RubberBox (Rect (loc.x, loc.y, 0, 0), loc2);
2
(IF withShift (specials) THEN selMode := multipleSelect
(ELSE selMode := onlyOneSelected END;
(SelectAreaWL (slotPtr^.wl, Rect (loc.x, loc.y, loc2.x, loc2.y),
9selMode, multipleSelect);
&END selectArea;
$
$PROCEDURE withShiftOrRightButton (): BOOLEAN;
$
&BEGIN
(RETURN withShift (specials) OR (msBut2 IN buts)
&END withShiftOrRightButton;
&
"BEGIN (* butManager *)
"
$MouseKeyState (loc2, buts, sc);  (*  Welche Knpfe sind noch gedrckt?  *)
"
*(* Teste Fenster ab *)
"
$IF withCtrl (specials) THEN mode := scanWL ELSE mode := selectWL END;
$detectWdws (loc, mode, clicks, specials, buts, entry, slotPtr, contSearch);
$
$IF entry # NIL THEN           (*  a window entry is selected  *)
$
&getSelectedName (currFn, voidSlot, kindOfName);
&
&CASE slotPtr^.kind OF
&
(dirWdw : dirEntryPtr := ptrDirEntry (entry);      (*  directory wdws  *)
(
1IF clicks > 1 THEN       (*  double click  *)
1
3IF isSubdir (dirEntryPtr^.entry) THEN
5AESUpdateWindow (TRUE);
5openFolder (slotPtr, dirEntryPtr);
5AESUpdateWindow (FALSE);
3ELSE
5IF IsSourceName (currFn) THEN
7actManager (Edit, specials, FALSE, FALSE, FALSE)
5ELSE
7actManager (Execute, specials, FALSE, FALSE, FALSE)
5END
3END;
3
1ELSIF msBut1 IN buts THEN(*  button down  *)
1
3IF withCtrl (specials) THEN
5selectArea
3ELSE
5moveFiles (slotPtr, loc, specials)
3END;
1
1ELSE                     (*  simple click  *)
3IF ~ isSubdir (dirEntryPtr^.entry) THEN
5setCurrTextAndCode (currFn)
3END;
1END|
1
(modWdw : modEntryPtr := ptrModEntry (entry);      (*  module wdws  *)
(
1IF clicks > 1 THEN       (*  double click  *)
1
3(* getSelectedName (currFn, voidSlot, kindOfName); *)
3actManager (Execute, specials, FALSE, FALSE, FALSE)
(
1ELSIF msBut1 IN buts THEN(*  button down  *)
1
3IF withCtrl (specials) THEN selectArea
3ELSE
5moveModuls (slotPtr, loc, specials)
3END;
3
1ELSE                     (*  simple click  *)
3setCurrTextAndCode (currFn)
1END|
(
&END;
$END;
"
$IF contSearch THEN  (* 'findWind' ergab, da kein Fenster selektiert wurde *)
*
*(* Teste Desktop ab *)
&
&obj := FindObject (desk, Root, MaxDepth, loc);
"
&IF obj = NoObject THEN
&
(RETURN TRUE  (* kein eigenes Objekt -> Ende *)
(
&ELSE
(searchDrive (obj, drive, foundDrive);
(searchWorkfile (obj, workfileIdx, foundWorkfile);
(SetCurrObjTree (desk, FALSE);
(
(IF clicks > 1 THEN                (*  Doppelklick  *)
(
*CASE obj OF
*
,Compile,
,Edit,
,Execute,
,Link,
,Resident,
,Scan      : actManager (obj, specials, ~ (msBut2 IN buts),
DFALSE, FALSE)|
,
,Cftext,
,Cfcode    : doFileBox (noCurrentWorkfile)|
,
*ELSE
,IF foundDrive THEN
,
.AESUpdateWindow (TRUE);
.selectDrive (drive);
.openCurrDir := (shellParm.defaultOpenCurrDir
>AND ~ withShiftOrRightButton ())
=OR (~ shellParm.defaultOpenCurrDir
AAND withShiftOrRightButton ());
.openDirWdw (slot, drive, openCurrDir);
.careOfDeselectDrive;
.AESUpdateWindow (FALSE);
,
,ELSIF foundWorkfile THEN doFileBox (workfileIdx) END;
*END;(*CASE -- Doppelklick *)
*
(ELSIF msBut1 IN buts THEN         (*  Button festgehalten  *)
(
*CASE obj OF
*
,Compile,
,Edit,
,Execute,
,Link,
,Resident,
,Scan,
,Trash     : moveDeskPart (obj)|
,
,Currfile,
,Cfhead    : moveDeskPart (Currfile)|
,
,Cftext,
,Cfcode    : (* moveFile (deskObjSpace (Cfname), FALSE,
BiconNo,destWind,destElem, moveResult);
8IF iconNo # NoObject THEN
:CASE iconNo OF
:
<Compile,
<Compexec,
<Edit,
<Execute,
<Link,
<Resident,
<Scan     : actManager (iconNo, specials,
SFALSE, FALSE, FALSE)|
<
<Trash    : setCurrTextAndCode ('')|
:ELSE
<(* nix *)
:END;
8ELSE
:(* nix
<IF moveResult # noWindMF THEN END;
:*)
8END*)|
,
*ELSE
,IF foundDrive THEN moveDeskPart (obj)
,ELSIF foundWorkfile THEN
.moveDeskPart (WorkField.elems[workfileIdx].carrierIdx)
,END;
*END;(* CASE -- Klick mit festhalten *)
*
(ELSE                              (*  Einfacher Klick  *)
(
*careOfDeselectDrive;
*careOfDeselectEntries;
*IF foundDrive THEN selectDrive (drive)
*ELSIF foundWorkfile THEN selectWorkfile (workfileIdx) END;
*
(END;(*IF -- Klickunterscheidung *)
&
&END;
$END;(*IF contSearch*)
$
$RETURN FALSE;
"END butManager;
 
 (*  menuManager -- Bearbeitet alle message events, die durch Anklicken der
!*                 Menuzeile entstehen.
!*)
!
 (*$Z-*)
 PROCEDURE menuManager (title, item: CARDINAL): BOOLEAN;
 (*$Z=*)
"
"VAR     i       : CARDINAL;
*buts    : MButtonSet;
*specials: SpecialKeySet;
*loc     : Point;
*start   : Rectangle;
#
"BEGIN
$MouseKeyState (loc,buts,specials);
$CASE item OF
&
&(*  MShell  *)
%
&Dinfo     : animateMenuTitle (Mshell, start);
2DoSimpleBox (shellBox, start, voidC);
2deAnimateMenuTitle (Mshell)|
&
&(*  Datei  *)
&
&Mdinfo    : inform|
&Mdfolder  : makeFolder|
&Mdformat  : doFormatBox|
&Mdclose   : closeTopWdw (FALSE)|
&Mdclosew  : closeTopWdw (TRUE)|
&Mdnwork   : makeNewWorkfile|
&Mdkwork   : killWorkfile|
&Mdquit    : quitStatus := quit|
&
&(*  Parameter  *)
&
&Mpshell   : doShellParameterBox|
&Mpeditor  : doEditorParameterBox|
&Mpcomp    : doCompilerOptionBox|
&Mplink    : doLinkerOptionBox|
&Mpsave    : saveParameter|
&
&(*  Info  *)
&
&Mienv     : doInfoBox|
&Mihelp    : doHelpBox (helpFile)|
&Midocu    : editDocu (specials)|
&
$ELSE
&
&(*  Tools  *)
$
&FOR i := 1 TO MaxTool DO
(IF item = ToolField[i].index THEN executeTool (i, specials) END
&END;
&
$END;
$
$NormalTitle (menu,title, TRUE);
$
$RETURN FALSE;
"END menuManager;
 
 PROCEDURE TalkWithUser;
 
"VAR     worker  : ARRAY [1..3] OF EventProc;
*
*slot, i : wdwSlotIdx;
*success : BOOLEAN;
*
*firstA3,
*newA3   : LONGCARD;
*
*button  : CARDINAL;
"
"(*  careOfNewName  -- Falls ein Unterschied zwischen dem in 'str' enthaltenen
#*                    Filenamen und dem String des Objektes 'obj' des Desk-
#*                    top-Baumes besteht, so wird der Name aus 'str' in das
#*                    Objekt geschreiben und neugezeichnet.
#*)
#
"PROCEDURE careOfNewName (VAR str:ARRAY OF CHAR; obj:CARDINAL);
 
$VAR   lF, old: ARRAY[0..11] OF CHAR;
$
$BEGIN
&SplitPath (str, void128, lF);
&GetTextString (desk, obj, old);
&IF NOT StrEqual (old, lF) THEN
(SetTextString (desk, obj, lF);
(redrawDeskObj (obj);
&END;
$END careOfNewName;
"
 
"BEGIN
$careOfNewName (lastFn, Cftext);     (* Aktuelles File aktual. *)
$careOfNewName (CodeName, Cfcode);
"
$worker[1].event := keyboard;
$worker[1].keyHdler := keyManager;
$worker[2].event := mouseButton;
$worker[2].butHdler := butManager;
$worker[3].event := message;
$worker[3].msgType := menuSelected;
$worker[3].menuHdler := menuManager;
"
$STORE (11, firstA3);
"
$REPEAT
"
&HandleEvents (2, MButtonSet{msBut1}, MButtonSet{msBut1},
4lookForEntry, Rect (0,0,0,0),
4lookForEntry, Rect (0,0,0,0),
40, worker, 0);
"
&STORE (11, newA3);
&IF newA3 # firstA3 THEN
(LOAD (firstA3, 11);
(FormAlert (1, '[1][Heap fault][ OK ]', voidC);
&END;
&
&enableAndDisableMenuItems;
"
&FOR i := MIN (wdwSlotIdx) TO MAX (wdwSlotIdx) DO
(wdws[i]^.isTop := FALSE;
&END;
&scanSlots (isTopWdw, slot, success);
&IF success THEN
&
(wdws[slot]^.isTop := TRUE;
(IF wdws[slot]^.kind = dirWdw THEN
*SetDefaultPath (wdws[slot]^.path, voidI);
(END;
(
&END;
"
&currFn := '';         (* Damit 'lastFn' zum Zuge kommen kann *)
&
&careOfNewName (lastFn, Cftext);     (* Aktuelles File aktual. *)
&careOfNewName (CodeName, Cfcode);
"
&(*  handle a quit shell request
'*)
&IF quitStatus = quit THEN
(FormAlert (1, exitShellAlt^, button);
(IF button = 3 THEN quitStatus := noQuit
(ELSIF button = 1 THEN SaveParameter END;
&END;
$
$UNTIL quitStatus # noQuit;
"END TalkWithUser;
 
 (*$Z-*)
 PROCEDURE hdlTrap5 (VAR desc: ExcDesc): BOOLEAN;
 (*$Z=*)
"BEGIN
$doAlert (debugAlt);   (*  Fehlermeldung  *)
$TermProcess (0);      (*  und ab damit  *)
$RETURN FALSE          (* Nur um des Compilers Willen  *)
"END hdlTrap5;
 
 
 VAR     i       : CARDINAL;
(hdl     : ADDRESS;
(wsp     : MemArea;
 
 BEGIN (* ShellShell *)
 
"(*  Vom Modula-System und der Shell benutzte Suffices:
#*)
"suf[prg] := 'PRG';
"suf[app] := 'APP';
"suf[tos] := 'TOS';
"suf[ttp] := 'TTP';
"suf[m2p] := 'M2P';
"suf[m2b] := 'M2B';
"suf[m2m] := 'M2M';
"suf[m2d] := 'M2D';
"(*
#* Die folgenden Endungen knnen verndert werden:
#* (Shell dann neu linken und alle Dateien mit den neuen Endungen
#* versehen - auch diejenigen in der Library "MM2DEF.M2L"!)
#*)
"suf[mod] := 'MOD';   (* Object-Files, GEM-Application *)
"suf[mos] := 'MOS';   (* Object-Files, TOS-Application *)
"suf[mtp] := 'MTP';   (* Object-Files, TTP-Application *)
"suf[imp] := 'IMP';   (* Object-Files bei Implementationsmodulen *)
"suf[def] := 'DEF';   (* Symbol-Files (bersetzte Definitionsmodule *)
"DefSrcSfx:= 'D';     (* ModRef: Definitions-Texte *)
"ImpSrcSfx:= 'I';     (* ModRef: Implementations-Texte *)
"ModSrcSfx:= 'M';     (* ModRef: Hauptmodul-Texte *)
 
"(* Fr Compiler: Suffices fr erzeugte Dateien *)
"DefSfx:= suf[def];   (* Extension f. Symboldatei-Codes *)
"ImpSfx:= suf[imp];   (* Extension f. Implementations-Codes *)
"ModSfx:= suf[mod];   (* Extension f. Hauptmodul-Codes *)
 
"(* Suffices fr Loader (CallModule, LoadModule) *)
"MOSConfig.DftSfx:= suf[mod]; (* Default-Endung bei 'CallModule' *)
"MOSConfig.ImpSfx:= suf[imp]; (* Endung der importierten Module *)
 
"(*  calc. of the directory window width (including the date)
#*)
"dirDateLen := Length (StdDateMask);
"dirWdwWidth := dirWidthNoDate + dirDateLen;
"
"(*  some box info vars
#*)
"LastCodeName := '';
"LastCodeSize := 0L;
 
"(*  default configuration
#*)
 
"MakeFileName := '';
 
"WITH shellParm DO
$breakActive := TRUE;
$defaultOpenCurrDir := FALSE;
$confirmCopy := TRUE;
$confirmDelete := TRUE;
$useAllMemForCopy := TRUE;
$
$batchPath := batchFile;
$
$ShellRead (ShellName, args); (* Liest Pfad/Name der Shell und Argumentzeile *)
$IF args [0] # 0C THEN
&(* M2P-Dateiname wurde in Argumentzeile bergeben *)
&Assign (args, parameterPath, voidO)
$ELSE
&(* M2P-Dateiname wird aus Shell-Pfad u. "MM2SHELL.M2P" zusammengesetzt *)
&ConcatPath (ShellName, parameterFile, parameterPath)
$END;
$ConcatName (parameterPath, suf[m2p], parameterPath);
$MakeFullPath (parameterPath, voidI);
$
$sides := 2;
$tracks := 80;
$sectors := 9;
$
$waitOnReturn := FALSE;
"END;
"
"(*  no work file.
#*)
"FOR i := 0 TO maxWorkFiles - 1 DO WorkField.elems[i].used := FALSE END;
"WorkField.noUsed := 0;
"WorkField.current := noCurrentWorkfile;
"
"WITH EditorParm DO
$name:= 'GME';
$searchSources := FALSE;
$waitOnError := FALSE;
$tempShellFile := FALSE;
$tempShellName := '';
$tempEditorFile := FALSE;
$tempEditorName := '';
$passArgument := TRUE;
$passName := TRUE;
$passErrorText := TRUE;
$passErrorPos := TRUE;
"END;
"
"ErrListFile := 'MODULA.ERR';
"MainOutputPath := '';
"WITH CompilerParm DO          (*  Compiler-Parameter:     *)
$name:= 'MM2Comp';
$shortMsgs := FALSE;         (*  - keine Kurzausgaben    *)
$protocol := FALSE;          (*  - kein Protokoll        *)
$protWidth := stdProtWidth;
$protName := '';
"END;
"
"WITH LinkerParm DO
$name := 'MM2Link';
$FOR i := MIN (LLRange) TO MAX (LLRange) DO
&linkList[i].valid := FALSE;
&linkList[i].name := '';
$END;
$optimize := fullOptimize; (*  - Vollstndige Optimierung  *)
$linkStackSize := 0;
$maxLinkMod := 100;
$fastLoad := TRUE;
$fastCode := TRUE;
$fastMemory := TRUE;
$symbolFile:= FALSE;
$symbolArgs:= '';  (* optional: Argumente f. 'MM2LnkIO.OutputSymbols' *)
$outputName:= '';  (* optional: Name d. Ausgabedatei *)
"END;
"
"FOR i := 1 TO MaxTool DO ToolField[i].used := FALSE END;  (*  Keine Tools  *)
"
"msgStr := '';
"selectedDrive := defaultDrv;  (*  Kein Laufwerk angewhlt  *)
"
"(* TRAP #5 belegen, um Fehlermeldung auszugeben, wenn in einem Modul $D+
#* verwendet wird, ohne 'Debug'-Modul importiert zu haben *)
"wsp.bottom := ADR (ExceptsStack);
"wsp.length := SIZE (ExceptsStack);
"InstallPreExc (ExcSet{TRAP5}, hdlTrap5, TRUE, wsp, hdl);
 
"quitStatus := noQuit;
 
 END ShellShell;
 
 
((***************************)
((* Hier endet 'ShellShell' *)
((***************************)
 
 
 CONST   mspFileMagic    = 10071898L + 00700000000L;
(escKey          = 33C;
 
 TYPE    PtrStr = POINTER TO String;
(AutoCmd = (noCmd, scan, edit, compile, execute, comp_exec, exec_src,
3make_exec, dftMake, dftMake_exec, contMake);
 
 VAR  ready    : BOOLEAN;
%dummy    : INTEGER;
%handle   : INTEGER;
%strVal   : BOOLEAN;
%buttonNum: CARDINAL;
%editorsMakeCmd,
%autoCmd    : AutoCmd;
%shellStart,
%makeActive : BOOLEAN;
%callRes    : LoaderResults;
%callMsg    : String;
%exitCode   : INTEGER;
%voidO      : BOOLEAN;
%voidI      : INTEGER;
%voidC      : CARDINAL;
 
%withPost1, withPost2: BOOLEAN;
%postAmble1, postAmble2, postArgs1, postArgs2: String;
 
 
 PROCEDURE FileAlert (errNo: INTEGER);
 
"VAR     msg     : ARRAY[0..50] OF CHAR;
 
"BEGIN
$IF (errNo < fOK) AND (errNo # fDriveNotReady) AND (errNo # fWriteProtected)
$THEN
&GetStateMsg (errNo, msg);
&Concat ('[1][', msg, msg, voidO);
&Append ('][  OK  ]', msg, voidO);
&FormAlert (1, msg, voidC);
$END;
"END FileAlert;
 
 PROCEDURE SaveParameter;
 
"VAR   f      : File;
"
"PROCEDURE ioErr (): BOOLEAN;
"
$VAR ioRes: INTEGER;
"
$BEGIN
&ioRes := State (f);
&IF ioRes < fOK THEN
(ResetState (f);
(FileAlert (ioRes);
(Remove (f);
(ShowArrow;
&END;
&RETURN ioRes < fOK
$END ioErr;
$
"PROCEDURE wBlock (VAR data: ARRAY OF BYTE): BOOLEAN;
"
$BEGIN
&WriteBlock (f, data);
&RETURN ~ ioErr ()
$END wBlock;
"
"VAR   magic: LONGCARD;
(ok: BOOLEAN;
"BEGIN
$ShowBee;
$
$Create (f, HomeReplaced (shellParm.parameterPath), writeOnly, replaceOld);
$IF State (f) # fOK THEN FileAlert (State (f)); RETURN END;
$
$magic := mspFileMagic;
$LOOP (* Ist keine echte Schleife - lediglich f. einfacheres EXIT *)
&ok:= FALSE;
&IF ~ wBlock (magic) THEN EXIT END;
&IF ~ wBlock (shellParm) THEN EXIT END;
&IF ~ wBlock (WorkField) THEN EXIT END;
&IF ~ wBlock (lastFn) THEN EXIT END;
&IF ~ wBlock (CodeName) THEN EXIT END;
&IF ~ wBlock (EditorParm) THEN EXIT END;
&IF ~ wBlock (CompilerParm) THEN EXIT END;
&IF ~ wBlock (LinkerParm) THEN EXIT END;
&IF ~ wBlock (DefaultStackSize) THEN EXIT END;
&IF ~ wBlock (TemporaryPath) THEN EXIT END;
&IF ~ wBlock (MakeFileName) THEN EXIT END;
&IF ~ wBlock (DefLibName) THEN EXIT END;
&IF ~ wBlock (ErrListFile) THEN EXIT END;
&IF ~ wBlock (MainOutputPath) THEN EXIT END;
&IF ~ wBlock (CompilerArgs) THEN EXIT END;
&SetGetDeskPositions (f, getValue); IF ioErr () THEN EXIT END;
&SetGetWindows (f, getValue); IF ioErr () THEN EXIT END;
&IF ~ wBlock (fontSetting) THEN EXIT END;
&ok:= TRUE;
&EXIT
$END;
$IF NOT ok THEN RETURN END;
$
$Close (f);
$
$ShowArrow;
"END SaveParameter;
 
 PROCEDURE LoadParameter (REF name: ARRAY OF CHAR);
 
"VAR   f      : File;
(fname  : FileStr;
 
"PROCEDURE ioErr (): BOOLEAN;
"
$VAR ioRes: INTEGER;
"
$BEGIN
&ioRes := State (f);
&IF ioRes < fOK THEN
(ResetState (f);
(FileAlert (ioRes);
(Close (f);
(ShowArrow;
&END;
&RETURN ioRes < fOK
$END ioErr;
$
"PROCEDURE rBlock (VAR data: ARRAY OF BYTE): BOOLEAN;
"
$BEGIN
&ReadBlock (f, data);
&RETURN ~ ioErr ()
$END rBlock;
 
"VAR   magic, n: LONGCARD;
(ch: CHAR;
(ok: BOOLEAN;
"
"BEGIN
$ShowBee;
$
$Assign (name, fname, voidO);
$ReplaceHome (fname);
$MakeFullPath (fname, voidI);
$Open (f, fname, readOnly);
$IF State (f) # fOK THEN FormAlert (1, noParmAlt^, voidC); ShowArrow; RETURN END;
$
$IF ~ rBlock (magic) THEN ShowArrow; RETURN END;
$IF magic = mspFileMagic THEN
&LOOP (* Ist keine echte Schleife - lediglich f. einfacheres EXIT *)
(ok:= FALSE;
(IF ~ rBlock (shellParm) THEN EXIT END;
(IF ~ rBlock (WorkField) THEN EXIT END;
(IF ~ rBlock (lastFn) THEN EXIT END;
(IF ~ rBlock (CodeName) THEN EXIT END;
(IF ~ rBlock (EditorParm) THEN EXIT END;
(IF ~ rBlock (CompilerParm) THEN EXIT END;
(IF ~ rBlock (LinkerParm) THEN EXIT END;
(IF ~ rBlock (DefaultStackSize) THEN EXIT END;
(IF ~ rBlock (TemporaryPath) THEN EXIT END;
(IF ~ rBlock (MakeFileName) THEN EXIT END;
(IF ~ rBlock (DefLibName) THEN EXIT END;
(IF ~ rBlock (ErrListFile) THEN EXIT END;
(IF ~ rBlock (MainOutputPath) THEN EXIT END;
(IF ~ rBlock (CompilerArgs) THEN EXIT END;
(SetGetDeskPositions (f, setValue); IF ioErr () THEN EXIT END;
(SetGetWindows (f, setValue); IF ioErr () THEN EXIT END;
(IF ~EOF (f) THEN
*IF ~rBlock (fontSetting) THEN EXIT END;
(ELSE
*fontSetting.name:= '';
*fontSetting.size:= 0;
(END;
(ok:= TRUE;
(EXIT
&END;
&IF NOT ok THEN ShowArrow; RETURN END;
 
&InitWorkfile (0, Work0);
&InitWorkfile (1, Work1);
&InitWorkfile (2, Work2);
&InitWorkfile (3, Work3);
&InitWorkfile (4, Work4);
&InitWorkfile (5, Work5);
&InitWorkfile (6, Work6);
&InitWorkfile (7, Work7);
&InitWorkfile (8, Work8);
&InitWorkfile (9, Work9);
&Assign (fname, shellParm.parameterPath, voidO);
&SetFonts;
&SetWindowSizes;
$ELSE
&FormAlert (1, noParmAlt^, voidC)
$END;
$Close (f);
$
$(*  If a batch file is specified, execute it. Don't load modules, if
%*  the <ESC>-key is pressed.
%*)
$BusyRead (ch);
$IF NOT Empty (shellParm.batchPath) THEN
&ExecuteBatch (shellParm.batchPath, ch # escKey)
$END;
$
$ShowArrow;
"END LoadParameter;
 
 
 PROCEDURE PrepareScan;
 
"BEGIN
$ScanAddr := CallingChain [ScanIndex].relAddr;
$ScanOpts := CallingChain [ScanIndex].codeOpts;
$Assign (CallingChain [ScanIndex].sourceName, TextName, voidO);
"END PrepareScan;
 
 PROCEDURE readWorkNames;
"BEGIN
$WITH WorkField DO
&IF current >= 0 THEN
(workFName := elems[current].sourceName;
(workCName := elems[current].codeName;
&ELSE
(workFName := ''; workCName := '';
&END;
$END;
"END readWorkNames;
 
 PROCEDURE writeWorkName (REF source, code: ARRAY OF CHAR);
"VAR i : INTEGER;
"BEGIN (* richtige Arbeitsdatei suchen und Code speichern *)
$WITH WorkField DO
&IF current >= 0 THEN
(FOR i:= 0 TO maxWorkFiles-1 DO
*IF elems[i].used & StrEqual (source, elems[i].sourceName) THEN
,Assign (code, elems[i].codeName, voidO);
,RETURN
*END
(END
&END;
$END;
"END writeWorkName;
 
 PROCEDURE Bconout ( c: CHAR );
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #1,A3
(MOVEQ   #0,D0
(MOVE.B  -(A3),D0
(MOVE    D0,-(A7)
(MOVE    #2,-(A7)
(MOVE    #3,-(A7)
(TRAP    #13
(ADDQ.L  #6,A7
$END
"END Bconout;
"(*$L=*)
 
 (*$Z-*)
 PROCEDURE Bconin (): CHAR;
 (*$Z=*)
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    #2,-(A7)
(MOVE    #2,-(A7)
(TRAP    #13
(ADDQ.L  #4,A7
(MOVE.B  D0,(A3)+
(CLR.B   (A3)+
$END
"END Bconin;
"(*$L=*)
 
 (*$Z-*)
 PROCEDURE Bconstat (): BOOLEAN;
 (*$Z=*)
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    #2,-(A7)
(MOVE    #1,-(A7)
(TRAP    #13
(ADDQ.L  #4,A7
(TST     D0
(SNE     D0
(ANDI    #1,D0
(MOVE.W  D0,(A3)+
$END
"END Bconstat;
"(*$L=*)
 
 PROCEDURE clrscr;
"BEGIN
$Bconout (33C); Bconout ('E');
"END clrscr;
 
 PROCEDURE curon;
"BEGIN
$Bconout (33C); Bconout ('e');
"END curon;
 
 PROCEDURE curoff;
"BEGIN
$Bconout (15C); Bconout (33C); Bconout ('f');
"END curoff;
 
 PROCEDURE bing;
"BEGIN
$Bconout (7C);
"END bing;
 
 
 PROCEDURE alert ( REF s1,s2,s3: ARRAY OF CHAR );
"VAR msg: ARRAY [0..269] OF CHAR;
"BEGIN
$Assign (s1, msg, voidO);
$WrapAlert (msg, 0);
$IF s2[0] # 0C THEN
&Append ('|', msg, strVal);
&Append (s2, msg, voidO);
&WrapAlert (msg, 0);
$END;
$Insert ('[0][',0,msg,strVal);
$Append ('][]',msg,strVal);
$Insert (s3,CARDINAL(Length(msg)-1),msg, voidO);
$FormAlert (1, msg,buttonNum);
"END alert;
"
 PROCEDURE load;
"VAR     r       : LoaderResults;
*msg     : ARRAY [0..79] OF CHAR;
*name    : FileStr;
"BEGIN
$IF Empty (currFn) THEN name := CodeName ELSE name := currFn END;
$TellLoading (newTellValue, name);
$LoadModule (name, StdPaths, name, msg, r);
$IF r # noError THEN alert (conc (name, NoLoadStr^), msg, OkStr^) END;
"END load;
 
 PROCEDURE unload;
"VAR     r       : LoaderResults;
*name    : FileStr;
"BEGIN
$IF Empty (currFn) THEN name := CodeName ELSE name := currFn END;
$UnLoadModule (name, r);
$IF r # noError THEN alert (conc (name, NoUnloadStr^), '', OkStr^) END;
"END unload;
 
 PROCEDURE closeAllWindows;
"VAR w: CARDINAL;
"BEGIN
$AESUpdateWindow (TRUE);
$LOOP
&w:= AESWindows.TopWindow ();
&IF w = 0 THEN EXIT END;
&AESWindows.CloseWindow (w);
&AESWindows.DeleteWindow (w);
$END;
$IF (GEMEnv.GEMVersion() >= $140) THEN
&AESWindows.ResetWindows ();
$ELSE
&AESUpdateWindow (FALSE);
$END;
"END closeAllWindows;
 
 PROCEDURE call ( VAR modname: ARRAY OF CHAR; args: ARRAY OF CHAR;
1stackSize: LONGCARD; interactive, checkError, tool:BOOLEAN );
 
"TYPE SufSet = SET OF MySuf;
"
"VAR sufstr            : ARRAY[0..2] OF CHAR;
&dummy             : ARRAY[0..12] OF CHAR;
&name, path,
&oldPath           : PathStr;
&getparm           : BOOLEAN;
&prgType           : AESMisc.ProgramType;
&sufcnt, suffix    : MySuf;
&res               : INTEGER;
&dummyChar         : CHAR;
&hdl               : ADDRESS;
&prevStackSize     : LONGCARD;
 
"BEGIN
$Assign (modname, name, voidO);
$Upper (name);
 
$SplitPath (name, path, dummy);
$SplitName (dummy,dummy,sufstr);
$suffix:= mod;
$IF sufstr[0] = 0C THEN
&ConcatName (name, suf[mod], name)
$ELSE
&FOR sufcnt:= MIN (MySuf) TO MAX (MySuf) DO
(IF StrEqual (sufstr,suf[sufcnt]) THEN
*suffix := sufcnt;
(END
&END;
$END;
$prgType:= AESMisc.graphicPrgm;
$getparm:= FALSE;
$IF suffix IN SufSet {ttp,mtp} THEN getparm:= interactive END;
$IF suffix IN SufSet {ttp,mtp,tos,mos} THEN prgType:= AESMisc.textPrgm END;
 
$IF getparm THEN
&RequestArg (args);
$END;
 
$GetDefaultPath (oldPath);
$IF ~noDirChange THEN
&IF (path[0] = 0C) AND NOT tool THEN
((* Ist kein Pfad angegeben, bleibt bei Tools und
)* Systemprgs der akt. Pfad erhalten
)*)
(SearchFile (name, StdPaths, fromStart, voidO, name);
(SplitPath (name, path, dummy);
&END;
&ReplaceHome (path);
&SetDefaultPath (path, voidI)
$END;
$
$(*$? UseExtKeys: IF NOT tool THEN DeInstallKbdEvents END; *)
$
$IF NOT multiGEM & NOT multiTOS THEN
&closeAllWindows; (* alle noch offenen Fenster (von ACCs) schlieen *)
$END;
$
$IF prgType = AESMisc.textPrgm THEN
&HideMouse;
&clrscr;
&curon;
$END;
$
$IF DoShellWrite AND (GEMEnv.GEMVersion() >= $140) THEN
&IF ~multiTOS THEN
(AESMisc.ShellWrite (TRUE, prgType, name, args);
&END
$END;
 
$IF NOT multiGEM & NOT multiTOS THEN
&(* AC_CLOSE-Nachricht an alle Accessories schicken *)
&appl_exit; (* nach appl_exit kein AES-Aufruf mehr! *)
$END;
$
$(* ---------------------- Programmstart ------------------------ *)
$prevStackSize:= DefaultStackSize;
$IF stackSize # 0 THEN DefaultStackSize:= stackSize END;
$CallModule (name, StdPaths, args, NIL, exitCode, callMsg, callRes);
$DefaultStackSize:= prevStackSize;
$(* ---------------------- Programmende ------------------------- *)
$
$IF NOT multiGEM & NOT multiTOS THEN
&(* beim GEM wieder anmelden *)
&appl_init;  (* erst jetzt wieder AES-Aufrufe erlaubt! *)
$END;
 
$IF DoShellWrite AND (GEMEnv.GEMVersion() >= $140) THEN
&(* Dies alles funktioniert erst ab TOS 1.4 richtig *)
&IF ~multiTOS THEN
(AESMisc.ShellWrite (FALSE, AESMisc.graphicPrgm, ShellName, '');
&END
$END;
$
$IF prgType = AESMisc.textPrgm THEN
&(* Nach Programmende bei TOS-Programmen auf Tastendruck warten *)
&IF interactive & shellParm.waitOnReturn
)& NOT ScanMode & (callRes = noError) THEN
(WHILE Bconstat () DO dummyChar:= Bconin () END;
(curon;
(dummyChar:= Bconin ()
&END;
&curoff;
&ShowMouse
$END;
 
$GEMEnv.MouseInput (TRUE); (* ...falls Programm die Maus abgeschaltet hat *)
$ShowArrow;
 
$IF NOT multiGEM & NOT multiTOS THEN
&closeAllWindows; (* alle noch offenen Fenster (von ACCs) schlieen *)
$END;
 
$ClearDeskAndShowMsg;
$
$AESUpdateWindow (TRUE);
 
$IF Inconsistent () THEN
&alert (memErrorAlt, '', OkStr^)
$END;
 
$(*$? UseExtKeys: IF NOT tool THEN InstallKbdEvents END; *)
 
$SetDefaultPath (oldPath, res);
 
$IF checkError THEN
&IF callRes # noError THEN
(IF callRes = exitFault THEN
*alert (callMsg, '', OkStr^)
(ELSE
*alert (conc (name, NoExecStr^), callMsg, OkStr^)
(END
&ELSIF ScanMode THEN
(PrepareScan;
(IF ScanBox (TextName) THEN
*autoCmd := scan
(ELSE
*autoCmd := noCmd
(END
&ELSIF exitCode # 0 THEN
(CASE exitCode OF
*fFileNotFound,
*fPathNotFound,
*fInvalidDrive: FormError (2)|
4(* "Diese Anwendung kann Datei oder Ordner nicht finden" *)
*fAccessDenied: FormError (5)|
6(* "Datei existiert bereits oder ist Schreibgeschtzt" *)
*fTooManyOpen,
*fInsufficientMemory: FormError (8)|
-(* "Es steht nicht genug Speicher fr diese Anw. zur Verfgung" *)
(ELSE
*alert (conc (RetStr^, IntToStr (exitCode, 0)), '', OkStr^)
(END
&END
$END;
$ScanMode := FALSE;
 
$AESUpdateWindow (FALSE);
 
"END call;
 
 
 PROCEDURE callEdit (VAR s0: ARRAY OF CHAR; errMsg: BOOLEAN);
 
"VAR s, voidStr,
&tempPath  : ARRAY [0..126] OF CHAR;
&f         : File;
&lastBreak : BOOLEAN;
&zero      : CARDINAL;
 
"PROCEDURE writeTempFile;
 
$PROCEDURE stateError (): BOOLEAN;
 
&BEGIN
(IF State (f) # fOK THEN
*FileAlert (State (f));
*ResetState (f);
*Remove (f);
*RETURN TRUE
(ELSE RETURN FALSE END;
&END stateError;
$
$PROCEDURE writeLn (VAR str: ARRAY OF CHAR): BOOLEAN;
$
&BEGIN
(Text.WriteString (f, str);
(IF stateError () THEN RETURN FALSE END;
(Text.WriteLn (f);
(IF stateError () THEN RETURN FALSE END;
(RETURN TRUE
&END writeLn;
$
$VAR s2: Str128;
&
$BEGIN
&ReplaceHome (tempPath);
&Create (f, tempPath, writeSeqTxt, replaceOld);
&IF stateError () THEN RETURN END;
&IF ~ EditorParm.passName THEN
(IF ~ writeLn (TextName) THEN RETURN END;
&END;
&IF ~ EditorParm.passErrorPos AND errMsg THEN
(Assign (CardToStr (TextLine, 0), s2, voidO);
(Append (' ', s2, voidO);
(Append (CardToStr (TextCol - 1, 0), s2, voidO);
(IF ~ writeLn (s2) THEN RETURN END;
&END;
&IF ~ EditorParm.passErrorText AND errMsg THEN
(IF ~ writeLn (ErrorMsg) THEN RETURN END;
&END;
&Close (f);
$END writeTempFile;
 
"BEGIN
$Split (s0, PosLen (' ', s0, 0), TextName, s, voidO);
$IF EditorParm.searchSources THEN
&SearchFile (TextName, SrcPaths, fromStart, voidO, TextName)
$END;
$IF EditorParm.passName THEN Insert (TextName, 0, s, voidO) END;
 
$(* Zeiger auf akt. Dateinamen dem Editor mit bergeben
&IF isToolbox THEN
(Append (' ^', s, voidO);
(Append (CardToStr (LONGCARD (ADR (TextName)), 0), s, voidO);
(Append (' ', s, voidO);
&END;
$*)
 
$IF EditorParm.tempShellFile THEN
&SplitPath (EditorParm.name, tempPath, voidStr);
&Append (EditorParm.tempShellName, tempPath, voidO);
&Append (tempPath, s, strVal);
&writeTempFile;
$END;
$
$IF ~ EditorParm.passArgument THEN s := '' END;
$
$lastBreak:= shellParm.breakActive;
$shellParm.breakActive:= FALSE;
$call (EditorParm.name, s, EditorStackSize, FALSE, FALSE, TRUE);
$shellParm.breakActive:= lastBreak;
$
$IF EditorParm.tempEditorFile THEN
&SplitPath (EditorParm.name, tempPath, voidStr);
&Append (EditorParm.tempEditorName, tempPath, voidO);
&ReplaceHome (tempPath);
&Open (f, tempPath, readSeqTxt);
&IF State (f) = fOK THEN
(Text.ReadString (f, s);
(Close (f);
(zero := 0;
(exitCode := StrToCard (s, zero, strVal);
(IF ~ strVal THEN exitCode := 0 END;
&ELSE
(exitCode:= 0
&END;
$END;
$
$autoCmd := noCmd;
$IF callRes # noError THEN
&alert (EdStr^, callMsg, OkStr^)
$ELSE
&CASE exitCode OF
(1: autoCmd := compile|
(2: autoCmd := exec_src|
(3: autoCmd := dftMake|
(4: autoCmd := dftMake_exec|
&ELSE
&END;
&IF (autoCmd = dftMake_exec) OR (autoCmd = dftMake) THEN
(IF NOT makeActive THEN
*editorsMakeCmd:= autoCmd;
*makeActive:= TRUE;
(END;
(autoCmd:= contMake
&ELSE
(IF makeActive THEN
*FormAlert (1, ContMakeAlt^, buttonNum);
*IF buttonNum = 1 THEN
,autoCmd:= contMake
*END
(END
&END
$END;
"END callEdit;
 
 PROCEDURE hdedit (wrk: BOOLEAN);
 
"VAR name1, name2: NameStr;
&dummy       : Str128;
"
"BEGIN
$IF wrk THEN
&callEdit (workFName, FALSE);
$ELSE
&callEdit (currFn, FALSE)
$END;
$Upper (TextName);
$SplitPath (TextName, dummy, name1);
$SplitPath (workFName, dummy, name2);
$IF NOT StrEqual (name1, name2) THEN lastFn := TextName END;
"END hdedit;
 
 PROCEDURE hdrun (wrk, tool: BOOLEAN);
 
"VAR   found,
(codeOK  : BOOLEAN;
(f       : File;
(cDate,
(sDate   : Clock.Date;
(cTime,
(sTime   : Clock.Time;
(sname,
(cname,
(voidStr,
(suffix  : FileStr;
 
 
"PROCEDURE longTime (d:Clock.Date; t:Clock.Time): LONGCARD;
$BEGIN
&RETURN LONG (Clock.PackDate (d)) * $10000 + LONG (Clock.PackTime (t))
$END longTime;
 
"PROCEDURE getCodeDateTime (    suffix: MySuf;
Apaths : PathList;
=VAR cname : FileStr;
=VAR found : BOOLEAN);
$VAR testName: FileStr;
(testN2: FileStr;
(path: ptrString;
$BEGIN
&found:= FALSE;
 
&ConcatName (cname, suf[suffix], testN2);
&IF NOT Empty (MainOutputPath) THEN
((* Eingestellten Ausgabe-Pfad prfen *)
(Concat (MainOutputPath, testN2, testName, voidO);
&ELSE
((* Ausgabe-Pfad aus Compiler-Pfaden prfen *)
(IF suffix = imp THEN
*Concat (ImpOutPath, testN2, testName, voidO);
(ELSE
*Concat (ModOutPath, testN2, testName, voidO);
(END
&END;
&ReplaceHome (testName);
&Open (f, testName, readOnly);
&found:= (State (f) >= fOK);
&IF NOT found THEN
((* Datei auf Default-Pfaden suchen *)
(SearchFile (testN2, paths, fromStart, found, testName);
(IF found THEN
*Open (f, testName, readOnly);
(END
&END;
&IF found THEN
(GetDateTime (f, cDate, cTime);
(Close (f);
(cname:= testName;
&END;
$END getCodeDateTime;
 
"BEGIN (* hdrun *)
$codeOK := FALSE;
$(* check, wether code is valid if source is executed *)
$IF wrk THEN
&SearchFile (workFName, SrcPaths, fromStart, found, sname);
$ELSIF IsSourceName (currFn) THEN
&SearchFile (currFn, SrcPaths, fromStart, found, sname)
$ELSE
&(* wir haben einen Code -> sofort ausfhren *)
&codeOK := TRUE
$END;
$IF NOT codeOK THEN
&IF found THEN
((* Source vorhanden *)
(IF wrk THEN
*workFName:= sname; cname:= workCName
(ELSE
*currFn:= sname; cname:= ''
(END;
(IF Empty (cname) THEN
*(* Wir mssen den Code suchen *)
*SplitPath (sname, voidStr, cname);
*SplitName (cname, cname, suffix);
*getCodeDateTime (mod, ModPaths, cname, codeOK);
*IF NOT codeOK THEN
,getCodeDateTime (mos, ModPaths, cname, codeOK) END;
*IF NOT codeOK THEN
,getCodeDateTime (mtp, ModPaths, cname, codeOK) END;
*IF NOT codeOK THEN
,getCodeDateTime (imp, ImpPaths, cname, codeOK) END;
(ELSE
*(* Code schon vorhanden *)
*Open (f, cname, readOnly);
*codeOK:= (State (f) = fOK);
*IF codeOK THEN
,GetDateTime (f, cDate, cTime);
,Close (f);
*END;
(END;
(IF codeOK THEN
*(* Code vorhanden -> Zeit der Source ermitteln und mit Code vergl. *)
*Open (f, sname, readOnly);
*GetDateTime (f, sDate, sTime);
*Close (f);
*codeOK:= longTime (cDate,cTime) >= longTime (sDate,sTime);
(END;
&ELSE
((* Source nicht vorhanden -> Fehler melden? *)
((* wenn nicht, wird einfach Compiler gestartet... (weil codeOK=FALSE) *)
&END;
$ELSE
&cname:= currFn
$END;
$IF codeOK THEN
&IF wrk THEN workCName := cname
&ELSE CodeName := cname END;
&call (cname, args, 0, TRUE, TRUE, tool)
$ELSE
&IF wrk THEN workCName:= '' END;
&TextName := sname;
&autoCmd := comp_exec
$END
"END hdrun;
 
 
 PROCEDURE DoEditBox (batch, mustShow: BOOLEAN; VAR cont: BOOLEAN);
"VAR s: String;
&msg: Str128;
&buttonNum: CARDINAL;
"BEGIN
$(* Signalton: *)
$bing;
$IF mustShow OR EditorParm.waitOnError THEN
&msg := '[2][][]';
&IF batch THEN
(Insert (EditBatStr^, 6, msg, voidO)
&ELSE
(Insert (EditStr^, 6, msg, voidO)
&END;
&s:= ErrorMsg;
&WrapAlert (s, 0);
&Insert (s, 4, msg, voidO);
&FormAlert (1, msg, buttonNum);
&IF buttonNum = 1 THEN
(autoCmd:= edit; cont:= FALSE;
&ELSE
(autoCmd:= noCmd; cont:= (buttonNum = 2);
&END
$ELSE
&autoCmd:= edit; cont:= FALSE;
$END
"END DoEditBox;
 
 
 (*  callComp -- Calls the compiler to compile the file 'modName'.
!*              'work = TRUE' means the workfile is compiled.
!*              'batch = TRUE' means the compiler is called while
!*              executing a batch file. In that case 'cont' states,
!*              if the execution of the batch file has to continue
!*              after this proc. returns.
!*)
 
 PROCEDURE callComp (VAR modname: ARRAY OF CHAR;
8work,
8batch  : BOOLEAN;
4VAR cont   : BOOLEAN);
 
"VAR i:INTEGER;
&s,msg:Str128;
 
"BEGIN
$(*  String mit Compileroptionen aufbauen.
%*)
$WITH CompilerParm DO
&IF shortMsgs THEN s:= ' -Q' ELSE s:= ' +Q' END;
&Append (' ', s, voidO);
&Append (CompilerArgs, s, voidO);
&IF ~ Empty (MainOutputPath) THEN
(Append (' /O', s, voidO);
(Append (MainOutputPath, s, voidO);
&END;
&IF protocol THEN
(Append (' /C', s, voidO);
(Append (CardToStr (protWidth, 0), s, voidO);
(Append (' /P', s, voidO);
(Append (protName, s, voidO);
&END;
$END;
$
$CodeName:= '';
$IF autoCmd = scan THEN ScanMode:= TRUE END;
$call (CompilerParm.name, conc (modname, s),
*CompilerStackSize, FALSE, FALSE, TRUE);
$
$cont:= TRUE;
$IF callRes # noError THEN
&alert (CompStr^, callMsg, OkStr^);
&autoCmd:= noCmd
$ELSE
&CASE exitCode OF
(0:   IF autoCmd = scan THEN
/autoCmd:= edit
-ELSIF ~ batch THEN
-
/IF makeActive THEN
1CodeName:= LastCodeName;
/ELSE
1Upper (CodeName);
1LastCodeName:= CodeName;
1LastCodeSize:= CodeSize;
/END;
/IF work THEN
1workCName:= CodeName;
1writeWorkName (TextName, CodeName);
/END;
/IF autoCmd = comp_exec THEN
1autoCmd:= execute
/ELSE
1autoCmd:= noCmd
/END;
/
-END|
(2:   DoEditBox (batch, TRUE, cont)|
(3:   DoEditBox (batch, FALSE, cont)
&ELSE
(autoCmd:= noCmd
&END
$END
"END callComp;
 
 
 PROCEDURE callLink (VAR moduleName: ARRAY OF CHAR);
 
"VAR s: ARRAY [0..124] OF CHAR;
"
"BEGIN
$Assign (moduleName, s, voidO);
$WITH LinkerParm DO
&IF optimize = partOptimize THEN
(Append (' -H', s, voidO);
&ELSIF optimize = nameOptimize THEN
(Append (' -M', s, voidO);
&ELSIF optimize = fullOptimize THEN
(Append (' -F', s, voidO);
&END;
&IF fastLoad THEN
(Append (' -0', s, voidO)
&END;
&IF fastCode THEN
(Append (' -1', s, voidO)
&END;
&IF fastMemory THEN
(Append (' -2', s, voidO)
&END;
&IF symbolFile THEN
(Append (' -S', s, voidO);
(Append (symbolArgs, s, voidO)
&END;
&IF outputName[0] # '' THEN
(Append (' -O', s, voidO);
(Append (outputName, s, voidO)
&END;
&call (name, s, LinkerStackSize, FALSE, FALSE, TRUE);
$END;
$IF callRes # noError THEN
&alert (LinkStr^, callMsg, OkStr^)
$END
"END callLink;
 
 
 PROCEDURE callMake (REF name: ARRAY OF CHAR; batch: BOOLEAN; VAR cont: BOOLEAN);
 
"BEGIN
$call (shellParm.makeName, name, MakeStackSize, FALSE, FALSE, TRUE);
$cont:= TRUE;
$IF callRes # noError THEN
&alert (MakeStr^, callMsg, OkStr^);
&autoCmd:= noCmd;
$ELSE
&CASE exitCode OF
(0: LastCodeName:= CodeName;
+LastCodeSize:= 0L;
+ConcatPath (TemporaryPath, MakeCompFileName, TextName);
+ReplaceHome (TextName);
+IF autoCmd = make_exec THEN autoCmd:= comp_exec
+ELSE autoCmd:= compile END|
(1: IF autoCmd = make_exec THEN autoCmd:= execute
+ELSE autoCmd:= noCmd END|
(2: DoEditBox (batch, FALSE, cont)
&ELSE
(autoCmd:= noCmd;
&END;
$END
"END callMake;
 
 
 PROCEDURE hdscan (wrk: BOOLEAN);
 
"BEGIN
$ErrorMsg:= '<Scanned>';
$autoCmd:= scan;
$IF wrk THEN callComp (workFName, TRUE, FALSE, voidO);
$ELSIF Empty (currFn) THEN callComp (lastFn, FALSE, FALSE, voidO)
$ELSE callComp (currFn, FALSE, FALSE, voidO) END;
"END hdscan;
 
 PROCEDURE hdcomp (wrk: BOOLEAN);
 
"BEGIN
$IF wrk THEN callComp (workFName, TRUE, FALSE, voidO);
$ELSE callComp (currFn, FALSE, FALSE, voidO); lastFn:= currFn; END;
"END hdcomp;
 
 PROCEDURE hdlink (wrk: BOOLEAN);
 
"BEGIN
$IF wrk THEN callLink (workCName)
$ELSE callLink (currFn) END;
"END hdlink;
"
 PROCEDURE hdmake (wrk: BOOLEAN);
 
"BEGIN
$IF wrk THEN callMake (workFName, FALSE, voidO)
$ELSE callMake (currFn, FALSE, voidO) END;
"END hdmake;
 
 PROCEDURE action (what: actionType; wrkFile, tool: BOOLEAN);
 
"TYPE aTypeSet = SET OF actionType;
"
"CONST noHideAction = aTypeSet {doLoad, doUnLd, doCont};
"
"VAR s       : Str128;
&dummy, i: CARDINAL;
&n1, n2  : ARRAY [0..11] OF CHAR;
&hidden  : BOOLEAN;
 
"BEGIN
$IF wrkFile THEN readWorkNames END;
$
$IF what IN noHideAction THEN hidden:= FALSE
$ELSE HideSS (TRUE); hidden:= TRUE END;
$
$editorsMakeCmd:= noCmd;
$makeActive:= FALSE;
$CASE what OF
&doEdit: hdedit (wrkFile)|
&doComp: hdcomp (wrkFile)|
&doExec: hdrun (wrkFile, tool);
.IF wrkFile THEN writeWorkName (workFName, workCName) END|
&doLink: hdlink (wrkFile)|
&doScan: hdscan (wrkFile)|
&doCpEx: autoCmd := comp_exec; hdcomp (wrkFile)|
&doLoad: load|
&doUnLd: unload|
&doCont: InputScan (ErrorMsg, ScanIndex);
.PrepareScan;
.IF ScanBox (TextName) THEN
0HideSS (TRUE); hidden:= TRUE;
0autoCmd:= scan;
0callComp (TextName, FALSE, FALSE, voidO)
.END|
&doBtch: IF wrkFile THEN ExecuteBatch (workFName, TRUE)
.ELSE ExecuteBatch (currFn, TRUE) END|
&doParm: IF wrkFile THEN LoadParameter (workFName)
.ELSE LoadParameter (currFn) END|
&doMake,
&doMkEx,
&doDftM: makeActive:= TRUE;
.autoCmd:= contMake
$ELSE
$END;
 
$REPEAT
&CASE autoCmd OF
 
(contMake:  CASE what OF
5doMake: autoCmd:= noCmd; hdmake (wrkFile)|
5doMkEx: autoCmd:= make_exec; hdmake (wrkFile)|
5doDftM: autoCmd:= dftMake
3ELSE
5autoCmd:= editorsMakeCmd
3END|
 
(edit     : Concat (TextName, ' ', s, strVal);
3IF EditorParm.passErrorPos THEN
5Append (CardToStr (TextLine, 0), s, strVal);
5Append (' ', s, strVal);
5Append (CardToStr (TextCol - 1, 0), s, strVal);
5Append (' ', s, strVal);
3END;
3IF EditorParm.passErrorText THEN
5Append ('"', s, strVal);
5Append (ErrorMsg, s, voidO);
5Append ('" ', s, strVal);
3END;
3callEdit (s, TRUE)|
 
(scan,
(compile,
(comp_exec: callComp (TextName, wrkFile, FALSE, voidO)|
(
(exec_src : autoCmd:= noCmd;
3workFName:= '';
3workCName:= '';
3wrkFile:= FALSE;
3WITH WorkField DO
5IF current >= 0 THEN
7i:= 0;
7LOOP (* workFile richtig bestimmen *)
9WITH elems[i] DO
;IF used & StrEqual (TextName, sourceName) THEN
=workFName:= sourceName;
=workCName:= codeName;
=wrkFile:= TRUE;
=EXIT
;END;
9END;
9INC (i);
9IF i = maxWorkFiles THEN
;EXIT
9END;
7END
5END;
3END;
3IF ~wrkFile THEN currFn:= TextName END;
3hdrun (wrkFile, tool);
3IF wrkFile THEN writeWorkName (workFName, workCName) END|
 
(execute  : autoCmd:= noCmd;
3call (CodeName, args, 0, TRUE, TRUE, tool)|
 
(dftMake_exec,
(dftMake  : IF autoCmd = dftMake_exec THEN autoCmd:= make_exec END;
3callMake ('' (* >> Make verw. Default-Namen aus ShellMsg *), FALSE, voidO)|
&ELSE
&END
$UNTIL autoCmd = noCmd;
$
$Assign (lastFn, TextName, voidO);
$
$IF hidden THEN ShowSS (TRUE) END;
"END action;
 
 
 
 TYPE    pathEntry       = RECORD
<used: BOOLEAN;
<path: PathStr;
:END;
 
 VAR     pathArray: ARRAY [1..MaxSearchPaths] OF pathEntry;
 
 PROCEDURE ExecuteBatch (name: ARRAY OF CHAR; load: BOOLEAN);
 
"VAR f                 : File;
&s, arg            : ARRAY[0..255] OF CHAR;
&gotLine, cont,
&doIt              : BOOLEAN;
&result            : INTEGER;
&oldDrive          : Drive;
&oldPath           : PathStr;
"
"PROCEDURE delSpc (VAR s:ARRAY OF CHAR);
$BEGIN
&WHILE s[0] = ' ' DO Delete (s,0,1, voidO) END
$END delSpc;
"
"PROCEDURE equ (a,b: ARRAY OF CHAR): BOOLEAN;
$BEGIN
&Upper (a);
&Upper (b);
&RETURN Compare (FileName (a), FileName (b)) = equal
$END equ;
 
"PROCEDURE setLinkName (VAR n:ARRAY OF CHAR);
$VAR first: CHAR;
(i: CARDINAL;
(useEmpty: BOOLEAN;
$BEGIN
&first:=n[0];
&IF (first = '-') OR (first = '+') THEN
(Delete (n, 0, 1, voidO);
(delSpc (n);
&END;
&FOR useEmpty:= FALSE TO TRUE DO
(FOR i:= MIN (LLRange) TO  MAX (LLRange) DO
*IF equ (LinkerParm.linkList[i].name, n)
*OR (useEmpty AND Empty (LinkerParm.linkList[i].name)) THEN
,LinkerParm.linkList[i].valid:= (first # '-');
,Assign (n, LinkerParm.linkList[i].name, voidO);
,RETURN
*END
(END
&END
$END setLinkName;
"
"PROCEDURE setToolName (VAR n:ARRAY OF CHAR);
$VAR i: CARDINAL;
$BEGIN
&FOR i:=1 TO MaxTool DO
(IF ~ToolField[i].used THEN
*ToolField[i].used:= TRUE;
*Assign (n,ToolField[i].name, voidO);
*RETURN
(END
&END
$END setToolName;
"
"PROCEDURE getFirstPath (paths: PathList; VAR path: ARRAY OF CHAR);
$VAR entry: PathEntry;
$BEGIN
&Lists.ResetList (paths);
&entry:= Lists.NextEntry (paths);
&IF entry # NIL THEN
(Assign (entry^, path, voidO)
&ELSE
(path[0]:= ''
&END
$END getFirstPath;
"
"PROCEDURE killPaths (VAR paths: PathList);
"
$VAR entry: ADDRESS;
(idx  : CARDINAL;
"
$BEGIN
&Lists.ResetList (paths);
&entry:= Lists.PrevEntry (paths);
&WHILE entry # NIL DO
(idx:= 1;
(WHILE (idx <= MaxSearchPaths)
.AND (ADR (pathArray[idx].path) # entry) DO INC (idx) END;
(IF idx <= MaxSearchPaths THEN pathArray[idx].used:= FALSE END;
(Lists.RemoveEntry (paths, voidO);
(entry:= Lists.CurrentEntry (paths);
&END;
$END killPaths;
"
"PROCEDURE setP ( VAR paths: PathList );
$VAR err:BOOLEAN; c:CHAR; idx: CARDINAL;
$BEGIN
&killPaths (paths);
&idx:= 1;
&LOOP
(IF EOF (f) THEN EXIT END;
(Text.ReadString (f,s);
(IF s[0] # ' ' THEN EXIT END;
(WHILE (idx <= MaxSearchPaths) AND pathArray[idx].used DO INC (idx) END;
(IF idx <= MaxSearchPaths THEN
*EatSpaces (s);
*IF Compare ('.',s) = equal THEN s:= '' END;
*ValidatePath (s);
*Assign (s,pathArray[idx].path,err);
*Lists.AppendEntry (paths,ADR(pathArray[idx].path),err);
*pathArray[idx].used:= TRUE;
*INC (idx)
(ELSE
*alert (NoPathsStr^, '', OkStr^)
(END
&END;
&gotLine:= TRUE;
$END setP;
"
"PROCEDURE is (REF s0:ARRAY OF CHAR): BOOLEAN;
$BEGIN
&RETURN StrEqual (s0,s)
$END is;
 
"PROCEDURE prep (REF in: ARRAY OF CHAR): BOOLEAN;
$BEGIN
&Split (in,PosLen (' ',in,0),s,arg,strVal);
&delSpc (arg);
&Upper (s);
&RETURN (s[0] # 0C) AND (s[0] # '*')
$END prep;
 
"PROCEDURE getLC (VAR l: LONGCARD);
$VAR i: CARDINAL;
$BEGIN
&i:= 0;
&l:= StrToLCard (arg, i, strVal);
$END getLC;
 
"VAR found, tell: BOOLEAN;
&i: CARDINAL;
&res : INTEGER;
 
"PROCEDURE unTell;
$BEGIN
&IF tell THEN
(TellLoading (endTell, '');
(tell:= FALSE
&END;
$END unTell;
 
"BEGIN
$AESUpdateWindow (TRUE);
$ShowBee;
$tell:= FALSE;
$SearchFile (name, StdPaths, fromStart, found, name);
$Open (f, name, readSeqTxt);
$IF State (f) < 0 THEN
&GetStateMsg (State(f), s);
&alert (InfStr^, s, OkStr^);
$ELSE
&gotLine:= FALSE;
&cont:= TRUE;
&REPEAT
 
(IF NOT gotLine THEN Text.ReadString (f, s) END;
(gotLine:= FALSE;
(
(doIt:= FALSE;
(IF prep (s) THEN
*IF is ('IF_SHELLSTART') THEN    (*  IF-Clause  *)
,IF shellStart THEN
.doIt:= prep (arg);
,END;
*ELSIF is ('IF_EXITCODE') THEN
,i:= 0;
,IF StrToInt (arg, i, voidO) = exitCode THEN
.Copy (arg, i, 200, arg, voidO);
.doIt:= prep (arg);
,END
*ELSE
,doIt:= TRUE
*END;
(END;
 
(IF doIt THEN
H(*  misc  *)
*IF is ('WAIT') THEN
,alert (arg,'',ContStr^);
*ELSIF is ('STACKSIZE') THEN
,getLC (DefaultStackSize);
,IF DefaultStackSize < 1024L THEN DefaultStackSize:= 1024 END;
 
H(*  tools  *)
*ELSIF is ('DELETETOOLS') THEN
,FOR i:= 1 TO MaxTool DO ToolField[i].used:= FALSE END;  (*  Keine Tools  *)
*ELSIF is ('TOOL') THEN
,setToolName (arg)
H(*  loader commands  *)
*ELSIF is ('EXEC') THEN
,Split (arg, PosLen (' ', arg, 0), arg, s, strVal);
,delSpc (s);
,unTell;
,ShowArrow;
,AESUpdateWindow (FALSE);
,Upper (arg);
,IF IsMBTFile (arg) THEN
.ExecuteBatch (arg, load)
,ELSE
.call (arg, s, 0, FALSE, TRUE, FALSE);
,END;
,AESUpdateWindow (TRUE);
,ShowBee;
,IF autoCmd # noCmd THEN cont:= FALSE END;
*ELSIF is ('POSTAMBLE1') THEN
,Split (arg,PosLen (' ',arg,0),postAmble1,postArgs1,strVal);
,delSpc (postArgs1);
,withPost1:= TRUE;
*ELSIF is ('POSTAMBLE2') THEN
,Split (arg,PosLen (' ',arg,0),postAmble2,postArgs2,strVal);
,delSpc (postArgs2);
,withPost2:= TRUE;
*ELSIF is ('LOAD') THEN
,IF load THEN
.IF NOT tell THEN
0TellLoading (initTell, ''); tell:= TRUE
.END;
.TellLoading (newTellValue, arg);
.LoadModule (arg, StdPaths, callMsg (* dummy *), callMsg,
:callRes);
,END
*ELSIF is ('UNLOAD') THEN
,IF load THEN
.UnLoadModule (arg, callRes)
,END
*
*ELSIF is ('LINKSTACKSIZE') THEN
,getLC (LinkerParm.linkStackSize);
*ELSIF is ('NO_OPTIMIZE') THEN
,LinkerParm.optimize:= noOptimize
*ELSIF is ('NAME_OPTIMIZE') THEN
,LinkerParm.optimize:= nameOptimize
*ELSIF is ('PART_OPTIMIZE') THEN
,LinkerParm.optimize:= partOptimize
*ELSIF is ('FULL_OPTIMIZE') THEN
,LinkerParm.optimize:= fullOptimize
*ELSIF is ('DRIVER') THEN
,setLinkName (arg)
*ELSIF is ('DELETEDRIVERS') THEN
,SysUtil0.ClearVar (LinkerParm.linkList);
 
H(*  comp./link/make  *)
*ELSIF is ('COMPILE') THEN
,autoCmd:= noCmd;
,unTell;
,ShowArrow;
,AESUpdateWindow (FALSE);
,callComp (arg, FALSE, TRUE, cont);
,AESUpdateWindow (TRUE);
,ShowBee;
*ELSIF is ('MAKE') THEN
,autoCmd:= noCmd;
,unTell;
,ShowArrow;
,AESUpdateWindow (FALSE);
,callMake (arg, TRUE, cont);
,AESUpdateWindow (TRUE);
,ShowBee;
*ELSIF is ('LINK') THEN
,autoCmd:= noCmd;
,unTell;
,ShowArrow;
,AESUpdateWindow (FALSE);
,callLink (arg);
,AESUpdateWindow (TRUE);
,ShowBee;
*ELSIF is ('EDIT') THEN
,autoCmd:= noCmd;
,unTell;
,ShowArrow;
,AESUpdateWindow (FALSE);
,callEdit (arg, FALSE);
,AESUpdateWindow (TRUE);
,ShowBee;
H(*  paths  *)
*ELSIF is ('SETDIR') THEN
,SetCurrentDir (MOSGlobals.defaultDrv, arg, voidI);
*ELSIF is ('SETDRIVE') THEN
,SetDefaultDrive (StrToDrive (arg))
*ELSIF is ('SETPATH') THEN
,SetDefaultPath (arg, voidI)
 
*ELSIF is ('DEFAULTPATH') THEN
,setP ( StdPaths );
*ELSIF is ('DEFPATH') THEN
,setP ( DefPaths );
,getFirstPath (DefPaths, DefOutPath);
*ELSIF is ('IMPPATH') THEN
,setP ( ImpPaths );
,getFirstPath (ImpPaths, ImpOutPath);
*ELSIF is ('MODPATH') THEN
,setP ( ModPaths );
,getFirstPath (ModPaths, ModOutPath);
*ELSIF is ('SOURCEPATH') THEN
,setP ( SrcPaths )
*ELSIF is ('DEFOUT') THEN
,Assign (arg, DefOutPath, voidO);
,ValidatePath (DefOutPath)
*ELSIF is ('IMPOUT') THEN
,Assign (arg, ImpOutPath, voidO);
,ValidatePath (ImpOutPath)
*ELSIF is ('MODOUT') THEN
,Assign (arg, ModOutPath, voidO);
,ValidatePath (ModOutPath)
*ELSIF is ('MAINOUTPUTPATH') THEN
,Assign (arg, MainOutputPath, voidO);
,ValidatePath (MainOutputPath);
*END;
(
(END;
(
&UNTIL EOF (f) OR NOT cont;
&Close (f);
 
&(* getFirstPath-Aufrufe hier weg und oben eingefgt *)
 
$END;
$unTell;
$
$ShowArrow;
$AESUpdateWindow (FALSE);
"END ExecuteBatch;
 
 VAR     level   : CARDINAL;
 
 PROCEDURE envlpProc (start, inChild:BOOLEAN; VAR i:INTEGER);
 
"BEGIN
$IF ~inChild THEN
&IF start THEN
(IF level = 0 THEN
*IF shellParm.breakActive THEN voidO:=EnableBreak () END
(END;
(INC (level);
&ELSE
(DEC (level);
(IF level = 0 THEN
*IF shellParm.breakActive THEN DisableBreak END;
(END;
&END
$END;
"END envlpProc;
"
 
 VAR     err     : BOOLEAN;
(wsp     : MemArea;
(envlpHdl: EnvlpCarrier;
(ch      : CHAR;
(idx     : CARDINAL;
 
 BEGIN (* Main of MShell *)
 
"(*  ShellMsg - Variablen initialisieren
#*)
"Active:= TRUE;
"
"(*  Pfadlisten anlegen
#*)
"Lists.CreateList (StdPaths,err);
"Lists.CreateList (DefPaths,err);
"Lists.CreateList (ImpPaths,err);
"Lists.CreateList (ModPaths,err);
"Lists.CreateList (SrcPaths,err);
"FOR idx:= 1 TO MaxSearchPaths DO pathArray[idx].used:= FALSE END;
 
"autoCmd:= noCmd;
"
"shellStart:= TRUE;
"
"IF InitSS () THEN
"
$(*  Kontrolle gestarteter Prozesse zur Ctrl-C - Aktivierung
%*)
$SetEnvelope (envlpHdl, envlpProc, wsp);
$
$shellStart:= FALSE;
$(*$? UseExtKeys: InstallKbdEvents; *)
$TalkWithUser;               (* Hauptschleife der Shell *)
$(*$? UseExtKeys: DeInstallKbdEvents; *)
 
$IF withPost1 THEN
&call (postAmble1, postArgs1, 0L, FALSE, TRUE, FALSE);
$END;
$IF withPost2 THEN
&call (postAmble2, postArgs2, 0L, FALSE, TRUE, FALSE);
$END;
 
$(* eigenen Namen lschen, damit GEMINI die Shell nicht nochmal startet *)
$IF DoShellWrite & (GEMEnv.GEMVersion () >= $140) THEN
&IF ~multiTOS THEN
(AESMisc.ShellWrite (FALSE, AESMisc.graphicPrgm, '', '');
&END
$END;
$
$ExitSS;
$
"ELSE
$TermProcess (fInsufficientMemory)
"END
"
 END MM2Shell.
 
(* $FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$000001B9$FFE59909$0002F09F$FFE59909$0002E5B4$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$FFE59909$0002E5AAT.......T.......T.......T.......T...............T....T..T.......T.......T.......$000229C6$000229EE$00022A36$00022A71$00022AEA$0002296C$00022949$00022966$000232F2$0002E5AA$00004BBA$000001B9$0001F739$0001F720$00022941$000229AB*)
