 MODULE RealTest;
 (*$F* *)
 
 (*
!* Testprogramm fr Reals.
!* Jeweils mit/ohne FPU und mit beiden Real-Typen (s.u.: "Real"-Type) testen
!*)
 
 (*
 IMPORT TOSIO; (*$E MOS*)
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER;
 
 FROM GEMEnv IMPORT DeviceHandle,InitGem,RC;
 FROM GrafBase IMPORT Point;
 FROM InOut IMPORT FlushKbd,KeyPressed,WriteLn,WriteReal,WriteString,
"WriteEng, WriteLHex,OpenOutput;
 FROM MathLib0 IMPORT arcsin,cos,pi,sin,sqrt;
 FROM VDIControls IMPORT ClearWorkstation;
 FROM VDIOutputs IMPORT PolyLine;
 
 TYPE Real = LONGREAL;
 
 CONST
"Punkt_Anzahl    = 16;
"Steps           = 10;
"
 TYPE
"DreiD_Koord     = RECORD
6x,y,z : Real
4END;
"DreiD_Koord_Arr = ARRAY [0..Punkt_Anzahl - 1] OF DreiD_Koord;
"ZweiD_Koord_Arr = ARRAY [0..Punkt_Anzahl - 1] OF Point;
"Matrix          = ARRAY [0..3],[0..3] OF Real;
"
 VAR
"a,b    : DreiD_Koord;
"xyz,
"xyz_I  : DreiD_Koord_Arr;
"xy     : ZweiD_Koord_Arr;
"handle : DeviceHandle;
"ch     : CHAR;
"ok     : BOOLEAN;
"mats   : ARRAY [0..6] OF Matrix;
"t      : Matrix;
"d,e,
"step   : Real;
"i,j,k  : CARDINAL;
 
 
 PROCEDURE writeMat (VAR t: Matrix);
"VAR i,j: CARDINAL; p: POINTER TO RECORD n1,n2: LONGCARD END;
"BEGIN
$WriteLn;
$FOR i := 0 TO 3 DO
&FOR j := 0 TO 3 DO
(WriteEng (t[i,j],18,6);
&END;
&WriteLn
$END;
$FlushKbd; REPEAT UNTIL KeyPressed(); FlushKbd;
"END writeMat;
 
 (*----------------------------------------------------------------------------*)
 
 PROCEDURE GenEinheitsMat ( VAR m : Matrix );
"VAR
$i,j : CARDINAL;
"BEGIN
$FOR i := 0 TO 3 DO
&FOR j := 0 TO 3 DO
(IF i = j THEN
*m[i,j] := 1.0
(ELSE
*m[i,j] := 0.0
(END
&END
$END
"END GenEinheitsMat;
 
 (*----------------------------------------------------------------------------*)
 
 PROCEDURE GenTranslMat ( a,b,c : Real; VAR m : Matrix );
"BEGIN
$GenEinheitsMat(m);
 
$m[0,3] := a;
$m[1,3] := b;
$m[2,3] := c
"END GenTranslMat;
"
 (*----------------------------------------------------------------------------*)
 
 PROCEDURE GenSkalMat ( a,b,c : Real; VAR m : Matrix );
"BEGIN
$GenEinheitsMat(m);
$
$m[0,0] := a;
$m[1,1] := b;
$m[2,2] := c;
"END GenSkalMat;
"
 (*----------------------------------------------------------------------------*)
 
 PROCEDURE GenXRotMat ( w : Real; VAR m : Matrix );
"BEGIN
$GenEinheitsMat(m);
$
$m[1,1] := cos(w);
$m[1,2] := sin(w);
$m[2,1] := -sin(w);
$m[2,2] := cos(w)
"END GenXRotMat;
"
 (*----------------------------------------------------------------------------*)
 
 PROCEDURE GenYRotMat ( w : Real; VAR m : Matrix );
"BEGIN
$GenEinheitsMat(m);
$
$m[0,0] := cos(w);
$m[0,2] := -sin(w);
$m[2,0] := sin(w);
$m[2,2] := cos(w)
"END GenYRotMat;
 
 (*----------------------------------------------------------------------------*)
 
 PROCEDURE GenZRotMat ( w : Real; VAR m : Matrix );
"BEGIN
$GenEinheitsMat(m);
$
$m[0,0] := cos(w);
$m[0,1] := sin(w);
$m[1,1] := cos(w);
$m[1,0] := -sin(w)
"END GenZRotMat;
 
 (*----------------------------------------------------------------------------*)
 
 PROCEDURE GenWuerfelArr ( a, b, c, d : Real; VAR xyz : DreiD_Koord_Arr );
"(*$D-*)
"BEGIN
$WITH xyz[0]  DO x := a;   y := b;   z := c   END;
$WITH xyz[1]  DO x := a;   y := b+d; z := c   END;
$WITH xyz[2]  DO x := a+d; y := b+d; z := c   END;
$WITH xyz[3]  DO x := a+d; y := b;   z := c   END;
$WITH xyz[4]  DO x := a;   y := b;   z := c   END;
$WITH xyz[5]  DO x := a;   y := b;   z := c+d END;
$WITH xyz[6]  DO x := a;   y := b+d; z := c+d END;
$WITH xyz[7]  DO x := a+d; y := b+d; z := c+d END;
$WITH xyz[8]  DO x := a+d; y := b;   z := c+d END;
$WITH xyz[9]  DO x := a;   y := b;   z := c+d END;
$WITH xyz[10] DO x := a;   y := b+d; z := c+d END;
$WITH xyz[11] DO x := a;   y := b+d; z := c   END;
$WITH xyz[12] DO x := a+d; y := b+d; z := c   END;
$WITH xyz[13] DO x := a+d; y := b+d; z := c+d END;
$WITH xyz[14] DO x := a+d; y := b;   z := c+d END;
$WITH xyz[15] DO x := a+d; y := b;   z := c   END
"(*$D-*)
"END GenWuerfelArr;
 
 (*----------------------------------------------------------------------------*)
 
 PROCEDURE Perspektive (     xyz : DreiD_Koord_Arr;
8VAR xy  : ZweiD_Koord_Arr );
"CONST
$xfakt = 0.8660254038/2.0;
$yfakt = 0.5000000000/2.0;
$
"TYPE
$RealPoint = RECORD
2x,y : Real
0END;
"VAR
$i     : CARDINAL;
$(*$Reg*) y: Real;
$xyz_h : ARRAY [0..Punkt_Anzahl - 1] OF RealPoint;
$
"BEGIN
$(*$D-*)
$FOR i := 0 TO Punkt_Anzahl - 1 DO
&xyz_h[i].x := (xyz[i].x + xyz[i].y*xfakt)*400.0;
&xyz_h[i].y := (xyz[i].z + xyz[i].y*yfakt)*400.0
$END;
$FOR i := 0 TO Punkt_Anzahl - 1 DO
&IF (xyz_h[i].x > 0.0) AND (xyz_h[i].x < 399.0) THEN
(xy[i].x := SHORT(TRUNC(xyz_h[i].x))
&ELSE
(xy[i].x := 639
&END;
&y:= xyz_h[i].y;
&IF (y > 0.0) AND (y < 399.0) THEN
(xy[i].y := 400 - SHORT(TRUNC(xyz_h[i].y))
&ELSE
(xy[i].y := 399
&END
$END
$(*$D-*)
"END Perspektive;
"
 (*----------------------------------------------------------------------------*)
 
 PROCEDURE Mats_Mult ( VAR mats : ARRAY OF Matrix; VAR erg : Matrix );
 
"VAR
$i    : CARDINAL;
$help : Matrix;
$
"PROCEDURE mat_mult ( a,b : Matrix; VAR c : Matrix );
$VAR
&i,j,k : CARDINAL;
&(*$Reg*) sum: Real;
$BEGIN
&FOR i := 0 TO 3 DO
(FOR j := 0 TO 3 DO
*sum := 0.0;
*FOR k := 0 TO 3 DO
,(*
,WriteReal (a[i,k], 18, 6);
,WriteReal (b[k,j], 18, 6);
,WriteReal (a[i,k]*b[k,j], 18, 6);
,WriteReal (sum, 18, 6);
,WriteLn;
,*)
,sum := sum + a[i,k] * b[k,j];
*END;
*c[i,j] := sum
(END;
&END;
$END mat_mult;
$
"BEGIN
$mat_mult(mats[6],mats[5],erg);
$(*writeMat (erg);*)
$FOR i := 4 TO 0 BY -1 DO
&help := erg;
&mat_mult(help,mats[i],erg);
&(*writeMat (erg)*)
$END
"END Mats_Mult;
 
 (*----------------------------------------------------------------------------*)
 
 PROCEDURE Mat_Vec_Mult (     m   : Matrix;
=v   : DreiD_Koord_Arr;
9VAR erg : DreiD_Koord_Arr );
"VAR
$i : CARDINAL;
$
"BEGIN
$(*$D-*)
$FOR i := 0 TO Punkt_Anzahl - 1 DO
&erg[i].x := m[0,0]*v[i].x + m[0,1]*v[i].y + m[0,2]*v[i].z;
&erg[i].y := m[1,0]*v[i].x + m[1,1]*v[i].y + m[1,2]*v[i].z;
&erg[i].z := m[2,0]*v[i].x + m[2,1]*v[i].y + m[2,2]*v[i].z;
&(*
&WriteEng (erg[i].x,18,7);
&WriteEng (erg[i].y,18,7);
&WriteEng (erg[i].z,18,7);
&WriteLn;
&*)
$END;
$(*$D-*)
"END Mat_Vec_Mult;
 
 
 (*----------------------------------------------------------------------------*)
 
 VAR r: Real;
 
 BEGIN
 
"(*
"OpenOutput ('TXT');
"*)
"
"GenWuerfelArr(0.4,0.4,0.2,0.2,xyz);
"
"(*
"FOR i := 0 TO Punkt_Anzahl - 1 DO
$WriteReal(xyz[i].x,18,7);
$WriteReal(xyz[i].y,18,7);
$WriteReal(xyz[i].z,18,7);
$WriteLn;
"END;
"RETURN;
"FlushKbd; REPEAT UNTIL KeyPressed(); FlushKbd;
"*)
"
"WITH a DO x := 0.0; y := 0.0; z := 0.0 END;
"WITH b DO x := 1.0; y := 1.0; z := 1.0 END;
"
"InitGem(RC,handle,ok);
"IF NOT ok THEN HALT END;
"
"ClearWorkstation(handle);
"Perspektive(xyz,xy);
"(*$D-*)
"PolyLine(handle,xy,Punkt_Anzahl-1);
"
"FlushKbd; REPEAT UNTIL KeyPressed(); FlushKbd;
"
"d:= b.x*b.x + b.y*b.y;
"d := sqrt (d);
"e := sqrt (b.x*b.x + b.y*b.y + b.z*b.z);
"step := VAL(Real,Steps)*3.1415/180.0;
"
"GenTranslMat (-a.x, -a.y, -a.z, mats[0]);
"GenZRotMat (arcsin (b.y/d), mats[1]);
"GenYRotMat (arcsin (d/e), mats[2]);
"GenZRotMat (step, mats[3]);
"GenYRotMat (-arcsin (d/e), mats[4]);
"GenZRotMat (-arcsin (b.y/d), mats[5]);
"GenTranslMat (a.x, a.y, a.z, mats[6]);
"Mats_Mult (mats, t);
"
"(*
"FOR i:= 0 TO 6 DO
$writeMat (mats[i])
"END;
"*)
"
"WriteString ("Transformationsmatrix: ");
"WriteLn;
"writeMat (t);
"
"ClearWorkstation(handle);
"WriteString ('Start!');
"FOR i := 1 TO 360 BY Steps DO
$ClearWorkstation(handle);
$Mat_Vec_Mult(t,xyz,xyz_I);
$Perspektive(xyz_I,xy);
$PolyLine(handle,xy,Punkt_Anzahl-1);
$xyz := xyz_I;
"END;
"PolyLine(handle,xy,Punkt_Anzahl-1);
"
"(*
"FlushKbd;
"REPEAT UNTIL KeyPressed()
"*)
 END RealTest.
 
(* $FFF6A412$000006FA$000007EE$000008DF$000009EF$00000AFF$00001024$0000138D$000016B2$FFF6A412$FFF6A412$0000022B$FFF6A412$00001EF5$FFF6A412$00000662$FFF6A412$00001919$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$00000226$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$FFF6A412$0000022BT.......T.......T.......T.......T.......T.......TT......T.......T.......T.......$0000097D$00000BB2$00001E81$00000020$000005EE$0000022B$00000012$0000009F$000000BF$00001EB6$00001E81$00001E7E$00001E4B$00001E15$000001B7$00000992*)
