#ifndef _INET_IP
#define _INET_IP

#ifndef _INET_PKT
#include "pktdrv.h"
#endif

#ifndef _INET_CUST
#include "inetcust.h"
#endif

#define IP_ICMP	1		/* protocols to serve */
#define IP_GGP	3
#define IP_ST	5
#define IP_TCP	6
#define IP_UDP	17

#define MAXIP	10		/* max nr. of protocols to serve   */
#define IP_NBUF	10		/* default number of packetbuffers */

#define MAXIPSEG	1500

#ifndef INADDR
#define INADDR unsigned long
#endif

/* The Internet Header: */
typedef struct 
{
	u_char	vh;				/* version, hdrlen */
	u_char	tos;			/* type of service */
	u_short	length;
	u_short	ident;
	u_short	frag;
	u_char	ttl;
	u_char	protocol;
	u_short	chksum;
	INADDR	src_inaddr;
	INADDR	dst_inaddr;
} IP;

typedef struct
{
	ETH		et;
	IP		ip;
	union
	{
		char	opt[40];
		char	data[MAXIPSEG-sizeof(IP)];
	}od;
} IP_PACKET;

#define ip_opt	od.opt
#define ip_dat	od.data
#define IPPKTSIZE	((int)sizeof(PACKET))

#define IP_VERSION	4
#define IP_HDR		5
#define IP_TTL		255
#define IP_TOS		0
#define IP_FRAG		0x8000
#define ip_version(ip) (((ip)->vh >> 4) & 0xf)
#define ip_hdrlen(ip)  (((ip)->vh & 0xf) << 2)

#define ip_head(pkt) ((IP *)( ((PACKET *)pkt)->pkt_data ))
#define ip_data(pkt) (((char *)ip_head(pkt)) + ip_hdrlen(ip_head(pkt)))

int ip_open(int,int (*)(PACKET *,int,INADDR),int (*)(IP *));
int ip_close(int);
int ip_init(void);
int ip_exit(void);
int ip_demux(void);
int ip_dudemux(IP *);
int ip_send(int,PACKET *,int,INADDR);
PACKET *ip_alloc(int,int);
int ip_free(PACKET *);
int ip_requeue(PACKET *);
INADDR	ip_myaddr(void);




#endif