/************************************
    ftp client for TUW-TCP or ANS
************************************/
/* P. Mayer fortec TU Vienna 1992,1993  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <aes.h>
#include <tos.h>
#include <ext.h>
#include "cookie.h"
#include "inetcust.h" 
#include "tcpdef.h"
#include "tndefs.h"	

#define log(x) w_output(p_ftp_win,x,strlen(x))

#define FTP_CMD		21
#define FTP_DATA	20

#define BUFFERSIZE (0x7fa4L)
#define DATASIZE   BUFFERSIZE+2
#define FTPWND     5824L
#define DIRWND     1024L
#define FTPDISPLAYSIZE	128

static char *inputprompt = "\r\nTUW-FTP> ";
static char *str;

static int  replpos;
static char logstr[100];
static char ftp_respbuf[120];

static char *ftp_script[3];
static char ftpscriptbuf[3][100];
static int  ftp_scriptline;
static char ftp_retrfile[80];
static char tempfile[MAXPATH];
static char ftp_echoMode;
static char *px;

static long btime, tcount;
static char transfermode = 'a';
static int  puthandle,gethandle,dataindex;
static int  lendata,getlen;
static char sendpass,senduser,isport,interactive,verbose,mget,mput,getline,verb_cancel;

static struct wi_str *p_ftp_win;

static char ftp_outbuf[80];
static char ftp_inbuf[80];
static char ftp_outbufix, ftp_outbuflen, ftp_inbuflen;
static int  ftp_rcvState;
static char ftp_databuffer[DATASIZE];
static unsigned char abor_cmd1[2] = 
{TN_IAC,TN_IP};
static unsigned char abor_cmd2[7] = 
{TN_DM,'A','B','O','R','\r','\n'};


int ftpbusy = 0;

extern char keeppath[MAXPATH];
extern void w_output(struct wi_str *wp, unsigned char *ptr, short charcount);
extern void w_info(struct wi_str *wp, char *name);
extern void traps(void);
extern int connect(int port, char * host, int tcp_id);
extern int ftp_data, ftp_ctl;
extern DESTI desti, my;
extern TCPSTAT tstat;

void  dodir(int list,char *dirpath);
int process_cmd(void);
int setport(void);
int do_mget(void);
int do_mput(void);
void dosify(char *);

#define DOABORT \
          tcp_write(ftp_ctl,abor_cmd1,2,PUSH,NO_URGENT);\
          tcp_write(ftp_ctl,abor_cmd1,1,PUSH,URGENT);\
          tcp_write(ftp_ctl,abor_cmd2,7,PUSH,NO_URGENT);\

#define ftp_StateGETCMD      0       /* get a command from the user */
#define ftp_StateDOCMD       1       /* prepare command */
#define ftp_StateSENDCOMMAND 2       /* command beeing sent */
#define ftp_StateRCVRESP     3       /* awaiting first response */
#define ftp_StateINRESP      4       /* awaiting more response */
#define ftp_StateCLOSING     5       /* closing data connection */
#define ftp_StateWAITCOMPL   6       /* wait for closing data connection */

#define PUTOK                 0
#define PUTCLOSED 	      1
#define PUTABORT              2

#define GETOK                 0
#define GETCLOSED             1
#define GETABORT              2

#define CTLOK                 0
#define CTLABORT              2

int getHandler(void)
{
  int i;
  long t;

do
{
  if((int)tcp_stat(ftp_data,&tstat) < ESTABLISHED)
  {
   return 0;
  }
  if(gethandle > 0)
    i = (int)tcp_read(ftp_data,&ftp_databuffer[getlen],(int)(BUFFERSIZE - getlen));
  else
    i = (int)tcp_read(ftp_data,&ftp_databuffer,FTPDISPLAYSIZE);

  if(i < 0)
  {
    tcp_close(ftp_data);
    ftp_data = -1;
    if(gethandle > 0)
    {
      if(getlen)
      {
        if(getlen != Fwrite(gethandle,(long)getlen,ftp_databuffer))
        {
          log("\r\nWrite error!\r\n"); 
          DOABORT
          mget = mput = 0;
          ftp_data = -1;
          Fclose(gethandle);
          gethandle = mget = 0;
          ftp_inbuflen = 0;
          ftp_rcvState = ftp_StateGETCMD;
          return GETABORT;
        }
      }
      if(gethandle != mget) Fclose(gethandle);
      else if (mget) Fseek(0L,mget,0);
    }
    gethandle=getlen=0;
    t=(clock()-btime)/CLK_TCK;
    if(t == 0) t = 1;
    sprintf(logstr,"\r\n%ld bytes transferred in %ld seconds (%ld bytes/sec).\r\n",tcount,t,tcount/t);
    log(logstr);
    return GETCLOSED;
  }
  else/* if(i)*/
  {
/*  traps();*/
    ftp_databuffer[getlen+i] = 0;
    if (gethandle > 0)
    {
      getlen += i;
      if(getlen == BUFFERSIZE)
      {
        if(getlen != Fwrite(gethandle,(long)getlen,ftp_databuffer))
        {
          log("\r\nWrite error!\r\n");
          DOABORT
          mget = mput = 0;
          ftp_data = -1;
          Fclose(gethandle);
          gethandle = mget = 0;
          ftp_inbuflen = 0;
          ftp_rcvState = ftp_StateGETCMD;
          return GETABORT;
        }
        
        
        getlen = 0;
      }
      /*else if(i == 0) while(clock() == clock());*/
    }
    else
    {
      if(transfermode == 'i')
      {
        p_ftp_win->lfmode = 1;
        log(ftp_databuffer);
        p_ftp_win->lfmode = 0;
      }
      else log(ftp_databuffer);
    }
    tcount += i;
  }
}while(i && gethandle > 0);
  return GETOK;
}

int putHandler(void)
{
  int i;
  long t;

  if((int)tcp_stat(ftp_data,&tstat) < ESTABLISHED) return 0;

  i=0;
  
do
{
  if(lendata==0)
  {
    lendata = (int)Fread(puthandle,BUFFERSIZE,ftp_databuffer);
    if(lendata > 0) tcount += lendata;
    dataindex=0;
    if(lendata <= 0)
    {
      Fclose(puthandle);
      tcp_close(ftp_data);
      ftp_data = -1;
      puthandle = 0;
      t=(clock()-btime)/CLK_TCK;
      if(t == 0) t = 1;
      if(lendata == 0)
      {
        sprintf(logstr,"\r\n%ld bytes transferred in %ld seconds (%ld bytes/sec).\r\n",tcount,t,tcount/t);
        log(logstr);
        return PUTCLOSED;
      }
      else
      {
        log("Read error!\r\n");
        return PUTABORT;
      }
    }
  }

  {
    if(tcp_stat(ftp_data,&tstat) == ESTABLISHED)
    {
      i = (int)tcp_write(ftp_data,&ftp_databuffer[dataindex],lendata-dataindex,PUSH,NO_URGENT);
      traps();
      if(i < 0)
      {
        if(puthandle > 0) Fclose(puthandle);
        log("Data connection closed.\r\n"); 
        puthandle = 0;
        tcp_close(ftp_data);
        ftp_data = -1;
        return PUTABORT;
      }
      else
      {
        dataindex += i;
        if(dataindex >= lendata)  lendata = 0;
      }
    }
  }
}while(i > 0);
  return PUTOK;
}

int ftp_check()
{
  char *s;
  int i;

  if(gethandle) getHandler();
  if(puthandle) putHandler();  

  if(ftp_rcvState == ftp_StateWAITCOMPL && (isport || (!gethandle && !puthandle)))
  {
    if(!isport && !mget && !mput) log(inputprompt);
    ftp_rcvState = ftp_StateGETCMD;
    isport = 0;
  }

  i = (int)tcp_read(ftp_ctl,&ftp_respbuf[replpos],(int)sizeof(ftp_respbuf)-1-replpos);
  if(i < 0)
  {
    w_info(p_ftp_win,"<Status: connection closed.>");
    if(ftp_data > 0) tcp_close(ftp_data);
    ftp_data = -1;
    replpos = 0;
    if(gethandle > 0) Fclose(gethandle);
    if(puthandle > 0) Fclose(puthandle);
    gethandle = puthandle = 0;
    return CTLABORT;
  }
  else if(i)
  {
    ftp_respbuf[replpos+i] = 0;
    replpos += i;

    if(ftp_rcvState == ftp_StateRCVRESP)
    {
      ftp_rcvState = ftp_StateINRESP;
    }  

    switch(ftp_rcvState) 
    {
    case ftp_StateRCVRESP:
    case ftp_StateINRESP:
    case ftp_StateWAITCOMPL:
      {
        do
        {
          s = strchr(ftp_respbuf,'\n');
          if(s)
          {
            if (( ftp_respbuf[0] == '2' || ftp_respbuf[0] == '3' 
                || ftp_respbuf[0] == '4' || ftp_respbuf[0] == '5') 
            && ftp_respbuf[3] == ' ')
            {
              if (( ftp_respbuf[0] == '4' || ftp_respbuf[0] == '5') 
              && ftp_respbuf[3] == ' ')
              {
                if(gethandle > 0) Fclose(gethandle);
                if(puthandle > 0) Fclose(puthandle);
                gethandle = puthandle = 0;
              } 
              ftp_rcvState = ftp_StateWAITCOMPL;
            }
            *s = 0;
            if(((verbose || verb_cancel) && (isport || gethandle != -1)) || ftp_respbuf[0] == '4' || ftp_respbuf[0] == '5')
            {
              log(ftp_respbuf);
              if(transfermode == 'i') log("\r");
              log("\n");
            }

            if ( ftp_respbuf[0] == '3' && ftp_respbuf[1] == '3' 
                && ftp_respbuf[2] == '1' && ftp_respbuf[3] == ' ')
              sendpass = 1; 

            strcpy(ftp_respbuf, s+1);
            replpos = (int)strlen(ftp_respbuf);
          }  
        }
        while(s);  
        break;
      }
    }
  }
  return CTLOK;
}

int ftp_application(struct wi_str *wp)
{
  int i;
  char *s;
  int ftp_check(void);
  int putHandler(void);
  int getHandler(void);

  p_ftp_win = wp;

  switch (ftp_rcvState) 
  {
  case ftp_StateGETCMD:
    verb_cancel = 0;
    if(ftp_check() == CTLABORT) return 2;

    if(ftp_scriptline >= 0) 
    {

      s = ftp_script[ftp_scriptline];
      if ( s == NULL )
      {
        if(mget)
        {
          if(do_mget())
            ftp_rcvState = ftp_StateDOCMD;
        }
        else if(mput)
        {
          if(do_mput())
            ftp_rcvState = ftp_StateDOCMD;
        }
        else
        {
          ftp_scriptline = -1;
          ftp_inbuflen = 0;
          break;
        }
      }
      else
      {
        ftp_scriptline++;
        strcpy(ftp_outbuf,s);
        ftp_outbuflen = (int)strlen((char *)ftp_outbuf);
        ftp_outbufix = 0;
        ftp_rcvState = ftp_StateSENDCOMMAND;
      }
    }
    else if(sendpass)
    {
      if(!getline)
      {
        getline = 1;
        log("Password: ");
        ftp_echoMode = 0;
      }
      else if(getline == 2)
      {
        strcpy(ftp_outbuf,"pass ");
        strcat(ftp_outbuf,ftp_inbuf);
        strcat(ftp_outbuf,"\r\n");
        ftp_outbuflen = (int)strlen((char *)ftp_outbuf);
        ftp_outbufix = 0;
        ftp_rcvState = ftp_StateSENDCOMMAND;
        ftp_echoMode = 1;
        sendpass = getline = 0;
      }
    }
    else if(senduser)
    {
      if(!getline)
      {
        getline = 1;
        log("Username: ");
        ftp_echoMode = 1;
      }
      else if(getline == 2)
      {
        strcpy(ftp_outbuf,"user ");
        strcat(ftp_outbuf,ftp_inbuf);
        strcat(ftp_outbuf,"\r\n");
        ftp_outbuflen = (int)strlen((char *)ftp_outbuf);
        ftp_outbufix = 0;
        ftp_rcvState = ftp_StateSENDCOMMAND;
        ftp_echoMode = 1;
        senduser = getline = 0;
      }
    }
    break;

  case ftp_StateRCVRESP:
  case ftp_StateINRESP:
  case ftp_StateWAITCOMPL:
    if(ftp_check() == 2) return 2;
    break;

  case ftp_StateDOCMD:
    {
      if(process_cmd())
      {
        ftp_rcvState = ftp_StateGETCMD;
        break;
      }
    }
  case ftp_StateSENDCOMMAND:
    if(ftp_outbuflen - ftp_outbufix > 0)
    {
      i = (int)tcp_write(ftp_ctl,&ftp_outbuf[ftp_outbufix],ftp_outbuflen-ftp_outbufix,PUSH,NO_URGENT);
      ftp_outbufix += i;
    }
    else
    {
      ftp_inbuflen = 0;
      ftp_rcvState = ftp_StateRCVRESP;
      replpos = 0;
    }
    break;
  }

  return 0;
}

int ftpinit(struct wi_str * wp, char *user, char *passwd)
{
  char * tempf;
  
  p_ftp_win = wp;
  if(GetIPAddr(NULL,my.IPAddr))
  {
    log("Error: don't know my Internetaddress.\r\n");
    return 2;
  }

  sendpass = isport = getline = verb_cancel = 0;
  ftp_data = -1;
  puthandle = gethandle = mget = mput = 0;
  /* set up the script for this session */
  ftp_script[0] = NULL;
  ftp_script[1] = NULL;
  ftp_script[2] = NULL;
  ftp_echoMode = interactive = verbose = 1;
  ftp_scriptline = -1;
  if(*user)
  {
    sprintf(ftpscriptbuf[0],"user %s\r\n",user);
    ftp_scriptline = 0;
    ftp_script[0] = ftpscriptbuf[0];
    if(*passwd)
    {
      sprintf(ftpscriptbuf[1],"pass %s\r\n",passwd);
      ftp_script[1] = ftpscriptbuf[1];
    }
  }
  else senduser = 1;
  /* set up state variables */
  ftp_rcvState = ftp_StateRCVRESP;
  replpos = ftp_inbuflen = 0;
  tempf = getenv("FTPTMP");
  if(tempf == NULL) strcpy(tempfile,"C:\\TMP\\ftp__tmp.tmp");
  else strcpy(tempfile,tempf);
  return 0;
}

void handle_key(struct wi_str *wp, char key)
{
  w_info(p_ftp_win,"<Status: connected.>");
  p_ftp_win = wp;
  ftp_inbuf[ftp_inbuflen] = 0;

  switch (key) 
  {
  case 'H' & 037:
  case 0177:
    if ( ftp_inbuflen > 0 ) 
    {
      ftp_inbuflen--;
      if(!stricmp(ftp_inbuf,"pass ")) ftp_echoMode = 1;
      if(ftp_echoMode) log("\b \b");
    }
    break;

  case 'R' & 037:
    if ( ftp_echoMode )
    {
      log(inputprompt);
      log(ftp_inbuf);
    }
    break;

  case 033:
    if(!sendpass) ftp_echoMode = ! ftp_echoMode;
    break;
  case 'C' & 037:
    if(ftp_rcvState != ftp_StateGETCMD || mget || mput)
    {
      ftp_echoMode = 1;
      sendpass = senduser = 0;
      DOABORT
      mget = mput = 0;
      ftp_data = -1;
      if(gethandle > 0) Fclose(gethandle);
      if(puthandle) Fclose(puthandle);
      gethandle = 0;
      puthandle = 0;
      ftp_inbuflen = 0;
      log(inputprompt);
      ftp_rcvState = ftp_StateGETCMD;
    }
    else
    {
      ftp_inbuflen = 0;
      log(inputprompt);
    }
    break;
  case '\r':
    log("\r\n");
    if(!getline)
    {
     if(ftp_rcvState == ftp_StateGETCMD)
     {
      ftp_echoMode = 1;
      sendpass = senduser = 0;
      if(ftp_inbuflen)
      {
        ftp_rcvState = ftp_StateDOCMD;
        strcpy(ftp_outbuf,ftp_inbuf);
      }
      else log(inputprompt);
     }
     else 
     {
      if(!strnicmp((char *)ftp_inbuf,"abort",5L))
      {
        DOABORT
        mget = mput = 0;
        ftp_data = -1;
        if(gethandle > 0) Fclose(gethandle);
        if(puthandle) Fclose(puthandle);
        gethandle = puthandle = 0;
      }
      else
      {
        log("\r\nTransfer in progress; only ABORT is acceptable\r\n");
      }
     }
    }
    else 
    {
      getline = 2;
    }
    ftp_inbuflen = 0;
    break;

  default:
    if ( key >= ' ' && ftp_inbuflen < sizeof ftp_inbuf ) 
    {
      ftp_inbuf[ftp_inbuflen++] = key;
      ftp_inbuf[ftp_inbuflen] = 0;

      if (ftp_echoMode) log(&ftp_inbuf[ftp_inbuflen-1]);
    }
    if(!strnicmp(ftp_inbuf,"pass ",5)) ftp_echoMode = 0;
  }
}

void  dodir(int list,char *dirpath)
{
  long fsum = 0;
  int	 nfiles = 0;
  struct ffblk de;  /* directory entry */
  DISKINFO di;
  int found;
  char str[100];

  if(!dirpath || *dirpath == 0) dirpath = "*.*";
  if(list == 0 && *dirpath == '-')
  {
    list = 1;
    dirpath = strchr(dirpath,' ');
    if(!dirpath) dirpath = "*.*";
    else dirpath++;
  } 
  if((strlen(dirpath) == 2) && dirpath[1] == ':') strcat(dirpath,"\\*.*");
  if(!findfirst(dirpath,&de,FA_DIREC | FA_SYSTEM | FA_HIDDEN | FA_ARCH))
  {
    found = 1;
    if(!strrchr(dirpath,'*') && (de.ff_attrib & FA_DIREC) && de.ff_name[0] != '.')
    {
      strcat(dirpath,"\\*.*");
      found = !findfirst(dirpath,&de,FA_DIREC | FA_SYSTEM | FA_HIDDEN | FA_ARCH);
    }
    while(found)
    {
      if(de.ff_name[0] != '.')
      {
        if(list != 2)
        {
          if(de.ff_attrib & FA_DIREC)
          {
            sprintf(str,"%-12s  <DIR> ",de.ff_name);
          }
          else
          {
            sprintf(str,"%-12s%7ld ",strlwr(de.ff_name),de.ff_fsize);
            fsum += de.ff_fsize;
          }
          sprintf(str+strlen(str),"  %2.2d:%2.2d   %2.2d.%2.2d.%4.4d\r\n",
          (de.ff_ftime >> 11) & 0x1f, 	/* hour */
          (de.ff_ftime >> 5) & 0x3f, 	/* minute */
          (de.ff_fdate ) & 0x1f,   	/* day */
          (de.ff_fdate >> 5) & 0xf,	/* month */
          (de.ff_fdate >> 9) + 1980);  	/* year */
        }
        else
        {
          strcpy(str,strlwr(de.ff_name));
          strcat(str,"\r\n");
        }
        nfiles++;
        if(list == 2) Fwrite(gethandle,strlen(str),str);
        else w_output(p_ftp_win,str,strlen(str));
      }
      found = !findnext(&de);
    }
  }
  if(list == 1)
  {
    Dfree(&di,0);
    sprintf(str,"%5u files     %10lu bytes\r\n"
        "                %10lu bytes free\r\n",
    nfiles,fsum,di.b_free*di.b_secsiz*di.b_clsiz);
  }
  else sprintf(str,"\r\n");

  if(list == 2)
  {
    Fseek(0L,gethandle,0);
    gethandle = 0;
  }
  else w_output(p_ftp_win,str,strlen(str));
}

int process_cmd(void)
{
  int i;
  char *s;
  strcat(ftp_outbuf,"\r\n"); 

  ftp_outbuflen=0;

  if(!strnicmp((char *)ftp_outbuf,"port",4L))
  {
    isport = 1;
  }
  else if(!strnicmp((char *)ftp_outbuf,"get",3L))
  {
    memcpy((char *)&ftp_outbuf[4],(char *)&ftp_outbuf[3],strlen((char *)&ftp_outbuf[3])+1);
    memcpy(ftp_outbuf,"retr",4);
  }

  if(!strnicmp((char *)ftp_outbuf,"retr",4L))
  {
    if((px = strtok(&ftp_outbuf[5]," \r\n")) != NULL)
    {
      sscanf(px,"%80s",ftp_retrfile);
      if((px = strtok(NULL,"\r\n")) != NULL)
        sscanf(px,"%80s",ftp_retrfile);
      ftp_retrfile[79] = 0;
      dosify(ftp_retrfile);

      gethandle = Fcreate(ftp_retrfile,0);

      if(gethandle < 0)
      {
        gethandle = 0;
        sprintf(logstr,"!! Could not open '%s'.\r\n",ftp_retrfile);
        log(logstr);
        ftp_inbuflen = 0;
        log(inputprompt);
        replpos = 0;
        return 1;
      }
      else
      {
        getlen = 0;
        tcount = 0;
        btime = clock();
        sprintf(logstr,"Source %s, destination %s\r\n",&ftp_outbuf[5], ftp_retrfile);
        log(logstr);
        strcat(ftp_outbuf,"\r\n");
        if(setport() > 0) return 1;
      }
    }
  }

  if(!strnicmp((char *)ftp_outbuf,"status",6L))
  {
    verb_cancel = TRUE;
    getcwd(keeppath,(int)sizeof(keeppath));
    sprintf(ftp_outbuf,"\r\nlocal directory is %s\r\n",keeppath);
    log(ftp_outbuf);
    log("Host status:\r\n");    
    strcpy(ftp_outbuf,"stat\r\n");
  }
  else if(!strnicmp((char *)ftp_outbuf,"help",4L))
  {
    log("Supported commands are:\r\n");
    log(" lcd ldir lls lpwd show help status abort\r\n");
    log(" user passwd cd pwd dir ls get put mget mput quit\r\n");
    log("Host commands:\r\n");    
    verb_cancel = TRUE;
  }
  else if(!strnicmp((char *)ftp_outbuf,"abort",5L))
  {
    strcpy(ftp_outbuf,"abor\r\n");
  }
  else if(!strnicmp((char *)ftp_outbuf,"put",3L))
  {
    memcpy((char *)&ftp_outbuf[4],(char *)&ftp_outbuf[3],strlen((char *)&ftp_outbuf[3])+1);
    memcpy(ftp_outbuf,"stor",4);
  }
  else if(strnicmp((char *)ftp_outbuf,"send",4L) == 0)
  {
    memcpy(ftp_outbuf,"stor",4);
  }

  if(strnicmp((char *)ftp_outbuf,"stor",4L) == 0)
  {
    if((px = strtok(&ftp_outbuf[5]," \r\n")) != NULL)
    {

      sscanf(px,"%80s\n",ftp_retrfile);
      ftp_retrfile[79] = 0;
      dosify(ftp_retrfile);

      puthandle = Fopen(ftp_retrfile,0);
    }

    if(puthandle < 0)
    {
      sprintf(logstr,"Could not open '%s'.\r\n",ftp_retrfile);
      log(logstr);
      puthandle = 0;
      ftp_inbuflen = 0;
      log(inputprompt);
      replpos = 0;
      return 1;
    }
    else
    {
      btime = clock();
      tcount = 0;
      if((px = strtok(NULL," \r\n")) != NULL) strcpy(&ftp_outbuf[5],px);
      sprintf(logstr,"Source %s, destination %s\r\n",ftp_retrfile,&ftp_outbuf[5]);
      log(logstr);
      lendata=dataindex=0;
      strcat(ftp_outbuf,"\r\n");            
      if(setport() > 0)   return 1;
    }
  }
  else if(strnicmp((char *)ftp_outbuf,"dir",3L) == 0)
  {
    memcpy((char *)&ftp_outbuf[4],(char *)&ftp_outbuf[3],strlen((char *)&ftp_outbuf[3])+1);
    memcpy(ftp_outbuf,"list",4);
    gethandle = -1;
    tcount = 0;
    btime = clock();
    if(setport() > 0)
      return 1;
  }
  else if(strnicmp((char *)ftp_outbuf,"list",4L) == 0)
  {
    gethandle = -1;
    tcount = 0;
    btime = clock();
    if(setport() > 0)
      return 1;
  }
  else if(strnicmp((char *)ftp_outbuf,"ascii",5L) == 0)
  {
    strcpy(ftp_outbuf,"type a\r\n");
    transfermode = 'a';
  }
  else if(strnicmp((char *)ftp_outbuf,"binary",6L) == 0)
  {
    strcpy(ftp_outbuf,"type i\r\n");
    transfermode = 'i';
  }
  else if(strnicmp((char *)ftp_outbuf,"type",4L) == 0)
  {
    px = strtok(&ftp_outbuf[5]," \r\n");
    if(px &&( *px == 'a' || *px == 'i'))
    {
      strcat(ftp_outbuf,"\r\n");
      transfermode = *px;
    }
  }
  else if(strnicmp((char *)ftp_outbuf,"pwd",3L) == 0)
  {
    verb_cancel = TRUE;
    memcpy((char *)&ftp_outbuf[4],(char *)&ftp_outbuf[3],strlen((char *)&ftp_outbuf[3])+1);
    memcpy(ftp_outbuf,"xpwd",4);
  }
  else if(strnicmp((char *)ftp_outbuf,"ls",2L) == 0)
  {
    memcpy((char *)&ftp_outbuf[4],(char *)&ftp_outbuf[2],strlen((char *)&ftp_outbuf[2])+1);
    memcpy(ftp_outbuf,"nlst",4);
    gethandle = -1;
    tcount = 0;
    btime = clock();
    if(setport() >0)
      return 1;
  }
  else if(strnicmp((char *)ftp_outbuf,"nlst",4L) == 0)
  {
    gethandle = -1;
    tcount = 0;
    btime = clock();
    if(setport() >0)
      return 1;
  }
  else if(strnicmp((char *)ftp_outbuf,"mget",4L) == 0)
  {
    gethandle = Fcreate(tempfile,0);

    if(gethandle < 0)
    {
      gethandle = 0;
      sprintf(logstr,"!! Could not open intermediate file.\r\n");
      log(logstr);
      ftp_inbuflen = 0;
      log(inputprompt);
      replpos = 0;
      return 1;
    }
    else
    {
      mget = gethandle;
      memcpy(ftp_outbuf,"nlst",4);
      if(setport() >0)
        return 1;
    }
  }
  else if(strnicmp((char *)ftp_outbuf,"mput",4L) == 0)
  {
    gethandle = Fcreate(tempfile,0);

    if(gethandle < 0)
    {
      gethandle = 0;
      sprintf(logstr,"!! Could not open intermediate file.\r\n");
      log(logstr);
      ftp_inbuflen = 0;
      log(inputprompt);
      replpos = 0;
      return 1;
    }
    else
    {
      mput = gethandle;
      strtok(ftp_outbuf,"\r");
      i = (int)strspn(&ftp_outbuf[4]," ");
      s = ftp_outbuf + 4 + i;
      strupr(s);
      dodir(2,s);
      ftp_inbuflen = 0;
      replpos = 0;

      if(setport() > 0)
      {
        ftp_script[1] = NULL;
        return 1;
      }
    }
  }
  else if(strnicmp((char *)ftp_outbuf,"cd",2L) == 0)
  {
    memcpy((char *)&ftp_outbuf[3],(char *)&ftp_outbuf[2],strlen((char *)&ftp_outbuf[2])+1);
    memcpy((char *)ftp_outbuf,"cwd",3);
  }
  else if(strnicmp((char *)ftp_outbuf,"show",4L) == 0)
  {
    memcpy((char *)ftp_outbuf,"retr",4);
    gethandle = -1;
    if(setport() > 0)
      return 1;
  }

  /* local commands */
  if((strnicmp((char *)ftp_outbuf,"lpwd",4L) == 0) || (strnicmp((char *)ftp_outbuf,"!pwd",4L) == 0))
  {
    getcwd(keeppath,(int)sizeof(keeppath));
    sprintf(ftp_outbuf,"\r\nlocal directory is %s\r\n",keeppath);
    w_output(p_ftp_win,ftp_outbuf,strlen(ftp_outbuf));
    ftp_inbuflen = 0;
    log(inputprompt);
    replpos = 0;
    return 1;
  }
  else if((strnicmp((char *)ftp_outbuf,"lcd",3L) == 0) || (strnicmp((char *)ftp_outbuf,"!cd",3L) == 0))
  {
    strtok(ftp_outbuf,"\r");
    i = (int)strspn(&ftp_outbuf[3]," ");
    str = &ftp_outbuf[3 + i];
    strupr(str);
    if(str[1] == ':' && str[0] >= 'A' && str[0] <= 'Z') Dsetdrv(str[0] - 'A');
    if(Dsetpath(str))
    {
      sprintf(keeppath,"\r\nno such directory: %s\r\n",str);
      w_output(p_ftp_win,keeppath,strlen(keeppath));
    }
    getcwd(keeppath,(int)sizeof(keeppath));
    sprintf(ftp_outbuf,"\r\ncurrent local directory is %s\r\n",keeppath);
    w_output(p_ftp_win,ftp_outbuf,strlen(ftp_outbuf));
    ftp_inbuflen = 0;
    log(inputprompt);
    replpos = 0;
    return 1;
  }
  else if((strnicmp((char *)ftp_outbuf,"ldir",4L) == 0) || (strnicmp((char *)ftp_outbuf,"!dir",4L) == 0))
  {
    strtok(ftp_outbuf,"\r");
    i = (int)strspn(&ftp_outbuf[4]," ");
    s = ftp_outbuf + 4 + i;
    strupr(s);
    dodir(1,s);
    ftp_inbuflen = 0;
    log(inputprompt);
    replpos = 0;
    return 1;
  }
  else if((strnicmp((char *)ftp_outbuf,"lls",3L) == 0) || (strnicmp((char *)ftp_outbuf,"!ls",3L) == 0))
  {
    strtok(ftp_outbuf,"\r");
    i = (int)strspn(&ftp_outbuf[3]," ");
    s = ftp_outbuf + 3 + i;
    strupr(s);
    dodir(0,s);
    ftp_inbuflen = 0;
    log(inputprompt);
    replpos = 0;
    return 1;
  }
  else if(strnicmp((char *)ftp_outbuf,"prompt",6L) == 0)
  {
    interactive = !interactive;
    log(interactive ? "interactive mode on\r\n" : "interactive mode off\r\n"); 
    ftp_inbuflen = 0;
    log(inputprompt);
    replpos = 0;
    return 1;
  }
  else if(strnicmp((char *)ftp_outbuf,"verbose",7L) == 0)
  {
    verbose = !verbose;
    ftp_inbuflen = 0;
    log(inputprompt);
    replpos = 0;
    return 1;
  }
  else
  {
    ftp_inbuflen = 0;
    ftp_outbuflen = (int)strlen((char *)ftp_outbuf);
    ftp_outbufix = 0;
    ftp_rcvState = ftp_StateSENDCOMMAND;
    /* fall through */
  }
  return 0;
}

int setport(void)
{
#define TRIES 10

  int state,i;
  char *term;
  long tcp_buff;
  
  desti.Port = FTP_DATA;
  term = (char *)getenv("FTPWIN");
  if(term) tcp_buff = atol(term);
  else tcp_buff = FTPWND;
  if(gethandle < 0) tcp_buff = DIRWND;
  
  for(i = 0;i < TRIES;i++)
  {
   ftp_data = (int)  tcp_open(0,&desti,PASSIV,60,tcp_buff);
   while(ftp_data > 0 && (state = (int)tcp_stat(ftp_data,&tstat)) != LISTEN)
   {
    evnt_timer(10,0);
    if(state == CLOSED)
    {
      ftp_data = -1;
      break;
    }
   }
   if(ftp_data >0) break;
   w_info(p_ftp_win,"<Status: retrying to open data connection>");
   evnt_timer(10,0);
  }
  
  if(ftp_data <= 0)
  {
    ftp_script[0] = NULL;
    ftp_rcvState = ftp_StateGETCMD;
    w_info(p_ftp_win,"<Error: Could not open data connection>");
    log(inputprompt);
    replpos = 0;
  }
  else
  {
    my.Port = tstat.TCP_Port;
    sprintf(ftpscriptbuf[0],"port %d,%d,%d,%d,%d,%d\r\n",my.IPAddr[0],my.IPAddr[1],my.IPAddr[2],my.IPAddr[3],my.Port/256,my.Port&255);
    ftp_script[0] = ftpscriptbuf[0];
    ftp_script[1] = NULL;
    isport = 1;
    strcpy(ftpscriptbuf[1],ftp_outbuf);
    ftp_script[1] = ftpscriptbuf[1];
    ftp_script[2] = NULL;
    ftp_scriptline = 0;
  }
  return(ftp_data);
}

int do_mget()
{
  int i;

 if(!getline)
 {
  strcpy(ftp_outbuf,"retr ");

  i = 5;
  while(Fread(mget,1,&ftp_outbuf[i]) == 1 && ftp_outbuf[i] != '\n') i++;

  if(ftp_outbuf[i] != '\n')
  {
    Fclose(mput);
    Fdelete(tempfile);
    mget = 0;
    log(inputprompt);
    return 0;
  }
  ftp_outbuf[i+1] = 0;

  if(ftp_outbuf[i-1] != '\r')
  {
    strcpy(&ftp_outbuf[i],"\r\n");
    i++;
  }
  if(interactive)
  {
    log("\r\n");
    strcpy(logstr,ftp_outbuf);
    memcpy(logstr," get ",5L);
    strcpy(&logstr[i-1]," ? ");
    log(logstr);
    getline = 1;
    return 0;
  }
 }
 else if(getline == 2)
 {
   getline = 0;
   if(!strnicmp(ftp_inbuf,"y",1)) return 1;	/* do file */
   else return 0;				/* skip file */
 }
 else return 0;
 return 1;
}

int do_mput()
{
  int i;

 if(!getline)
 {
  strcpy(ftp_outbuf,"stor ");
  i = 5;
  while(Fread(mput,1,&ftp_outbuf[i]) == 1 && ftp_outbuf[i] != '\n') i++;
  if(ftp_outbuf[i] != '\n')
  {
    Fclose(mput);
    Fdelete(tempfile);
    mput = 0;
    log(inputprompt);
    return 0;
  }
  ftp_outbuf[i+1] = 0;
  if(interactive)
  {
    log("\r\n");
    strcpy(logstr,ftp_outbuf);
    memcpy(logstr," put ",5L);
    strcpy(&logstr[i-1]," ? ");
    log(logstr);
    getline = 1;
    return 0;
  }
 }
 else if(getline == 2)
 {
   getline = 0;
   if(!strnicmp(ftp_inbuf,"y",1)) return 1;	/* do file */
   else return 0;				/* skip file */
 }
 else return 0;
 return 1;
}

void dosify(char * s)
{
  while(*s)
  {
    if(*s == '/')	*s = '\\';
    s++;
  }
}
