#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tos.h>
#include <ext.h>
#include <aes.h>
#include "cookie.h"
#include "time.h"
#include "tndefs.h"
#include "tcpdef.h"
#include "inetcust.h"
#include "name.h"

extern void w_info(struct wi_str *wp, char *name);
#define noDEBUG

long resolv(char *host, char ipaddr[4],struct wi_str *wp)
{
INETCUST *custom;
COOKIE	 *cookie;
int udp,a[4],i;
NMITEM	*nm;
long    timeout;
DESTI   dest;
long	got;
char buf[512];

	if(host && sscanf(host,"%ld.",&got) == 1)
	{
	  if(sscanf(host,"%3d.%3d.%3d.%3d",&a[0],&a[1],&a[2],&a[3]) == 4)
	  {
	        ipaddr[0] = a[0];
	        ipaddr[1] = a[1];
	        ipaddr[2] = a[2];
	        ipaddr[3] = a[3];
			return 0L;
	  }
	  else return -1L;
	}
	if(!GetIPAddr(host,ipaddr))
		return 0L;
	if(!host || !strlen(host))
		return -1L;
        if(GetIPAddr("NAMESERVER",dest.IPAddr))
        {
	 cookie = get_cookie(INETCUSTCOOKIE);
	 if(!cookie || (custom = (INETCUST *)(cookie->val))==NULL)
	 {
                w_info(wp,"<Error: no name server specified.>");
		return(-1L);
	 }
	
	 if(!custom->nameserver[0])
	 {
                w_info(wp,"<Error: no name server specified.>");
		return(-1L);
	 }
	
	 *(INADDR *)dest.IPAddr = custom->nameserver[0];
        }
	dest.Port = NAMESERVPORT;

	nm = (NMITEM *)buf;
  
	udp = (int)udp_open(0);
	if(udp <= 0)
	{
		return(-1L);
	}
	
	nm->nm_type = NI_NAME;
	nm->nm_len  = (unsigned char)strlen(host);
	strcpy(nm->nm_item,host);
	
	for(i=0;i < NM_TRIES;i++)
	{
         w_info(wp,"<Status: contacting name server.>");
	 if(udp_write(udp,buf,(unsigned int)nm->nm_len+2,&dest) <= 0)
	 {
		udp_close(udp);
		return(-1L);
	 }
	 timeout = clock() + CLK_TCK * NM_WAIT;	/* wait 10 sec */
	 do
	 {
		evnt_timer(10,0);
		got = udp_read(udp,buf,&dest);
	 } while(got == 0L && clock() < timeout);
     if(got) break;
    }
	udp_close(udp);
	if(got < 0L)
	{
		return(-1L);	/* error */
	}
	else if(!got)
		return(-1L);			/* timeout */
	else if(got > strlen(host)+2)
	{
		if(!strncmp(nm->nm_item, host, (size_t)nm->nm_len)) 
		{
			nm = (NMITEM *)((char *)nm + nm->nm_len + 2);
			if(nm->nm_type == NI_ADDR) 
			{
				for(i=0; i < nm->nm_len; i++)
					ipaddr[i] = nm->nm_item[i];
				return(0L);		/* host found */
			}
		}
	}
	return(-1L);	/* host unknown */
}