#ifndef __INET__
#define __INET__

#ifdef __INET_KERNEL__

#define INETCOOKIE 0x494e45554L		/*  "INET" */

#define NSOCKET		0
#define NCONNECT	1				/* function id's to hook into */
#define NACCEPT		2
#define NBIND		3
#define NCLOSE		4
#define NWRITE		5
#define NREAD		6
#define NOPTION		7
#define NFLUSH		8


typedef struct _socket
{
	BASPAG *pid;
	int		protocol;
	int 	handle;
	int		state;
	long	opt;
	unsigned short lport;
} SOCKET;

#define SS_CLOSED	0
#define SS_OPENING	1
#define SS_OPEN		2
#define SS_CLOSING	3
#define SS_ALLOC	4

#endif


struct sockaddr
{
	unsigned short	sa_family;			/* address family */
	char			sa_data[14];
};

struct sockaddr_in
{
	unsigned short	sin_family;
	unsigned short	sin_port;
	long			sin_addr;
	char			sin_zero[8];
};


#define SOCK_STREAM		1
#define SOCK_DGRAM		2

extern int nsocket(int protocol);
extern int (*nconnect)(int s, struct sockaddr *name, size_t namelen);
extern int (*naccept)(int s, struct sockaddr *addr, size_t addrlen);
extern int (*nbind)(int s,int port);
extern int (*nclose)(int s);
extern long (*nwrite)(int s, long len, char *msg);
extern long (*nread)(int s, long len, char *msg);
extern long (*noption)(int s, long option);
extern int (*nflush)(int s);

#define OPT_NOBLOCK	0x40000000L
#define OPT_BLOCK	0x20000000L
#define OPT_GET		0x80000000L

#define NET_OK			( 0)
#define NET_ENOTINST	(-1)
#define NET_RESET		(-2)
#define NET_NOREACH		(-3)
#define NET_NOENT		(-4)
#define NET_NOSOCKET	(-5)
#define NET_SOCKUSED	(-6)
#define NET_NOMEM		(-7)

#endif
