
	.text
	.super
	
	xdef	lnc_install
	xdef	pterm_install
	xdef	memcopy
	xdef    berr_catch
	xdef    berr_tt_catch
	xdef	old_intr
	xref	ext_tab
	xref	new_stack
	xref	old_stack
	xref	old_pterm
	xref	net_reset
	xref	ihandler
	xref	lnc_vector
	xref    memok
	
berr_catch:					; bus error handler
	addq.w	#1,memok
	add.l	#8,a7
	rte

berr_tt_catch:					; bus error handler
	addq.w	#1,memok
	andi.w	#$FEFF,$0A(a7)		; clear rerun bit
	rte
	
lnc_install:
		movea.l	lnc_vector,a0
		move.l	(a0),old_intr
		move.l	#lance_interrupt,(a0)
		rts

		dc.b		'XBRA_PKT'
old_intr:	dc.l	0

lance_interrupt:
		move.l	a7,old_stack
		lea		old_stack,a7
		movem.l	d0-a6,-(a7)
		movea.l	ihandler,a0
		beq		nohandler
		jsr		(a0)
nohandler:
		movem.l	(a7)+,d0-a6
		movea.l	old_stack,a7
		rte


memcopy:
          move.w  a0,d2 
          move.w  a1,d1 
          eor.b   d1,d2 
          btst.l  #0,d2 
          beq     wmove 
          move.w  d0,d1
          tst.w   d1
          beq     done
          subq.w  #1,d1 
bloop:    move.b  (a1)+,(a0)+ 
          dbf     d1,bloop
          bra     done
wmove:    move.w  d0,d1
          tst.w   d1
          beq     done
          move.w  a1,d2 
          btst.l  #0,d2 
          beq     doit
          move.b  (a1)+,(a0)+ 
          subq.l  #1,d1 
doit:     cmpi.w  #1,d1 
          ble     bmove 
          move.w  d1,d0 
          asr.w   #1,d0 
          subq.w  #1,d0 
wloop:    move.w  (a1)+,(a0)+ 
          dbf     d0,wloop
bmove:    btst.l  #0,d1 
          beq     done
          move.b  (a1)+,(a0)+ 
done:     rts 

clock:	  move.l	$4BA,d0
          rts
          