NAME
    refcheck - berprft und korrigiert automatisch die Konsistenz von 
               REF-Bibliotheken des ST-Guide oder bearbeitet REF-Dateien 
               und -Bibliotheken.

SYNOPSIS
    refcheck [-hH][-rR reflib][-acdfgims]|[[-A|-D|-E|-F|-L|-M] [file ...]]

ALLGEMEINES
    Das Programm REFCHECK dient dazu, die vom HCP erzeugten REF-Dateien und
    REF-Bibliotheken zu verwalten und auf dem Laufenden zu halten.

    Diese Bibliothek dient dem  ST-Guide  zum  Auffinden  von  Stichworten,
    welche in anderen als der aktuell dargestellten Hypertextdatei definiert
    wurden.

    Als Bibliothek wird hierbei defaultmig die in der
    ST-GUIDE.INF-Variablen 'REF' angegebene Datei verwendet. Falls diese 
    Variable nicht existiert, und in der Kommandozeile auch keine 
    Bibliotheks-Datei angegeben wurde (Option -r), so wird eine Datei namens 
    'ALL.REF' im aktuellen Verzeichnis verwendet.

BESCHREIBUNG
    REFCHECK kennt zwei Arten von Optionen. Die kleingeschriebenen
    (CHECK-Modus) und die grogeschriebenen (LINK-Modus). Diese
    Unterscheidung ergibt sich aus Kompatibilittsgrnden zu frheren
    Versionen und zu REFLINK. CHECK- und LINK-Optionen drfen in der
    Kommandozeile nicht gemischt werden (also entweder oder)! Von den
    LINK-Optionen darf immer nur eine alleine benutzt werden. 

    CHECK-Modus (kleine Optionsbuchstaben)
    --------------------------------------

    Im CHECK-Modus liest REFCHECK zuerst aus der Datei ST-GUIDE.INF die
    Variablen PATHS und REF (Ausnahme siehe Option -r). Sollte auerdem die 
    Variable REFPATHS existieren, wird diese anstelle von PATHS benutzt. So 
    kann man bestimmen, da nur die REF-Dateien von Hypertexten aus 
    bestimmten Pfaden in die ALL.REF aufgenommen werden.
    
    Die in der Variablen REF stehende REF-Bibliothek (z.B. ALL.REF) wird
    geladen und auf ihre Korrektheit und Aktualitt berprft.

    Dazu werden alle HYP-Dateien, die sich in den hinter [REF]PATHS 
    angegebenen Pfaden befinden, gesucht, mit der ALL.REF verglichen und in 
    der ALL.REF berflssige Module (zu denen keine HYP-Datei existiert) 
    angezeigt. Evtl. vorhandene (und zu den HYPs passende) REF-Dateien 
    werden auf Aktualitt und Existenz in der ALL.REF berprft. Auf Wunsch
    wird die ALL.REF automatisch aktualisiert (Optionen -a, -d und -g).

    Wahlweise kann anschlieend automatisch ein Programm zur Erzeugung eines 
    neuen Kataloges aufgerufen werden ($STOOL).

    Ist die Option -s nicht gesetzt werden alle gefundenen HYP-Dateien und
    Modulnamen zusammen mit Offset und Lnge des Moduls auf dem Bildschirm
    ausgegeben. Erscheint hinter einem Modulnamen ein Ausrufezeichen (!),
    bedeutet das, da der Dateiname nicht mit dem Modulnamen bereinstimmt,
    was aber nur selten vorkommt. Bei solchen Hypertexten sollte man die
    REF-Datei nicht lschen, weil REFCHECK sonst beim nchsten Lauf das
    Modul in der ALL.REF nicht zu einem Hypertext zuordnen kann und evtl.
    wieder lschen lt! Bei gesetzter Option -m werden solche Files 
    automatisch so behandelt, als wre nur die Option -a gesetzt!

    Der CHECK-Modus ist auch aktiv, wenn REFCHECK mit leerer Kommandozeile
    aufgerufen wird!

    LINK-Modus (groe Optionsbuchstaben)
    ------------------------------------

    In diesem Modus kann man gezielt bestimmte REF-Dateien, REF-Bibliotheken
    und Module daraus bearbeiten (hinzufgen, lschen, auflisten u.a.).

    Um die Bildschirm-Ausgaben von REFCHECK in eine Datei zu schreiben,
    benutzen Sie eine Kommando-Shell mit Ausgabeumlenkung (z.B. Mupfel)!

OPTIONEN
    Globale Optionen:
    -----------------
    -h oder -H
        (hold)
        Am Ende auf Tastendruck warten.

    -r reflib oder -R reflib
        (set REF)
        Normalerweise wird bei allen Optionen/Kommandos automatisch die
        REF-Bibliothek bearbeitet, die in der Datei ST-GUIDE.INF mit der
        Variablen REF definiert ist. Mit dieser Option kann man eine
        beliebige andere REF-Datei/-Bibliothek bestimmen, die stattdessen
        bearbeitet wird.

    
    CHECK-Optionen:
    ---------------
    -a
        (add)
        Neue bzw. aktuellere REF-Dateien in [REF]PATHS automatisch in REF
        aufnehmen bzw. aktualisieren.

    -c
        (make catalog)
        Falls beim REFCHECK-Lauf nderungen gefunden wurden, wird
        anschlieend automatisch das Programm aufgerufen, das in der 
        ST-GUIDE.INF hinter der Variablen $STOOL definiert ist. Hierbei ist 
        mit 'nderungen' das Hinzufgen von REF-Dateien oder das Lschen von 
        Modulen gemeint (auch wenn dieses nur angezeigt und nicht 
        ausgefhrt wird).
        Da zuerst versucht wird, $STOOL ber das system()-Kommando zu 
        starten, kann es sich dabei z.B. auch um ein Mupfel-Script handeln, 
        sofern eine System-Shell installiert ist!

    -d
        (delete)
        Bei in [REF]PATHS nicht mehr vorhandenen HYP-Dateien automatisch 
        die dazu gehrenden Module aus REF lschen.

    -f
        (force making of catalog)
        Hiermit wird $STOOL nach dem REFCHECK-Lauf immer aufgerufen, auch
        wenn keine nderungen gefunden wurden. Ansonsten gelten die
        Aussagen bei der Beschreibung zur Option -c.
        Die Option -f ist dann sinnvoll, wenn man die Variable REFPATHS
        in ST-GUIDE.INF definiert hat und somit evtl. nicht alle Hypertexte
        erfat werden.
    
    -g
        (global)
        Alle in [REF]PATHS gefundenen REF-Dateien in REF aufnehmen bzw.
        aktualisieren, egal ob schon vorhanden und/oder gleiche Modullnge.

    -i
        (interactive)
        Bei -a/-d/-g einzeln nachfragen. Dabei wird jeweils die zu 
        bearbeitende REF-Datei bzw. das Modul angezeigt und kontextabhngig 
        gefragt, ob das Hinzufgen bzw. die Lschung durchgefhrt werden 
        soll. Man kann whlen zwischen:
        J: Aktion ausfhren (auch Return, deshalb ein groes "J").
        n: Aktion nicht ausfhren.
        a: Wie "J" und alle weiteren Aktionen ohne Nachfrage. Die Option -i
           wird also zurckgesetzt.
        q: Wie "n" und keine weiteren Aktionen mehr durchfhren. Intern
           werden hierbei die Optionen -a/-d/-g gelscht.

    -m
        (move into)
        Bei -a/-g werden hinzugefgte REF-Dateien anschlieend automatisch
        gelscht (s.a. LINK-Option -M).

    -s
        (silent)
        Die Bildschirmausgaben werden auf das ntigste beschrnkt, wodurch
        eine hhere Geschwindigkeit erzielt wird.

    Alle CHECK-Optionen knnen auch ber die Variable REFCHECK-OPT in der
    Datei ST-GUIDE.INF gesetzt werden. Diese Variable wird aber nur
    ausgewertet, wenn die Kommandozeile von REFCHECK leer ist!

    Beispiel: REFCHECK-OPT=ads


    LINK-Optionen:
    --------------
    Bedeutung der unten verwendeten Namen:
    'reffile' = REF-Datei (kann auch eine REF-Bibliothek sein).
    'reflib'  = REF-Bibliothek (mehrere REF-Dateien in eier Datei).
    'REF'     = REF-Bibliothek, die in der ST-GUIDE.INF hinter der Variablen
                REF angegeben ist bzw. die mit der Option -r gesetzte
                REF-Bibliothek.
    'module'  = Bestandteil (einzelne REF-Datei) einer REF-Bibliothek, wobei
                Module in einer REF-Bibliothek immer ohne die Extension 
                '.REF' erscheinen und auch so anzugeben sind.

    Angaben in eckigen Klammern sind optional und knnen weggelassen werden.
    Drei Punkte bedeuten, da beliebig viele Argumente des vor den Punkten
    stehenden Typs bergeben werden drfen.
    
    [-A] reffile ...
        (Add to reflib, default)
        Die REF-Dateien 'reffile ...' werden zur REF-Bibliothek REF
        hinzugefgt. Ist eine der REF-Dateien in REF schon vorhanden, wird 
        sie ersetzt. Der Optionsbuchstabe -A kann hier auch weggelassen
        werden. So ist es mglich eine oder mehrere REF-Dateien (mehrere 
        z.B. unter Gemini, Thing, Ease, ...) auf REFCHECK.TTP zu ziehen, um 
        diese in seine ALL.REF aufnehmen zu lassen. Auerdem kann man
        natrlich REFCHECK im Desktop auf den Dateityp "*.REF" anmelden, so
        da REFCHECK beim Doppelklick auf eine REF-Datei gestartet wird und
        die REF-Datei in die Default-REF-Bibliothek einfgt.

    -M reffile ...
        (Move into REF)
        Wie -A, nur da die reffiles nach dem Hinzufgen gleich gelscht
        werden, also ein Verschieben in die REF-Bibliothek stattfindet.
    
    -D module ...
        (Delete)
        Alle angegebenen Module 'module ...' werden aus REF gelscht. 
        
    -E module ...
        (Extract)
        Die angegebenen Module 'module ...' werden aus REF extrahiert,
        d.h. aus jedem Modul wird eine REF-Datei auf der Platte erzeugt. Die 
        extrahierten Module bleiben in REF erhalten.
        
    -F [reflib ...]
        (list module names in REF-Files)
        Listet die Namen aller Module aus den REF-Dateien bzw. -Bibliotheken
        'reflib ...' (Default: REF) auf dem Bildschirm auf. 

    -L [reflib ...]
        (List contents of REF-files)
        Listet den Inhalt aller Module aus den REF-Dateien bzw. 
        -Bibliotheken 'reflib ...' (Default: REF) auf dem Bildschirm auf. 

    Bei unbekannten Optionen (z.B. -?) wird eine Hilfe ausgegeben!

BEISPIELE
    refcheck
        Die Ergebnisse werden nur am Bildschirm angezeigt (evtl. -h setzen).
        Es finden keine Schreibzugriffe statt. Hiermit kann man sich also
        erstmal einen berblick verschaffen.

    refcheck -ad
        Die ALL.REF wird automatisch und ohne Nachfragen auf den neuesten
        Stand gebracht.

    refcheck -dg
        refcheck erkennt genderte Module mit der Option -a nur daran, da
        sich die Modullnge gendert hat. Will man ganz sicher gehen, kann
        man mit der Option -g ALLE REF-Dateien nochmal neu in die ALL.REF
        schreiben lassen. Anschlieend enthlt diese auf jeden Fall alle
        aktuellen REF-Dateien! Wenn man viele Hypertexte mit REF-Dateien
        hat, kann das natrlich etwas lnger dauern!

DATEIEN
    ST-GUIDE.INF
        Mu sich im HOME-Directory oder im Wurzelverzeichnis des
        Bootlaufwerkes befinden. Aus dieser Datei werden die Variablen
        REF, PATHS, [REFPATHS], REFCHECK-OPT und $STOOL gelesen.

ENVIRONMENT
    HOME
        Wird bei der Suche nach der ST-GUIDE.INF ausgewertet.

    SHELL
        Wird evtl. beim Aufruf von $STOOL benutzt.

VERSIONEN
    1.0 - Erstverffentlichung.

    1.1 - Compiliert mit hcc 2.00x23 und gelinkt mit den neuen XDLibs aus
          dem Sozobon-Release 07.
        - Sollte jetzt auch mit Alias-Programmen unter Gemini zurechtkommen
          (reflink.ttp), da zuerst versucht wird, das Programm mit system()
          zu starten.
        - Bugfix: Ein lokales Array war zu gro fr den Stack. Eigentlich
          htte das Programm abstrzen mssen. Warum es trotzdem lief,
          wei ich auch nicht;-)
        - In den Beipielen der man page stand "reflink" statt "refcheck".
        - Man page jetzt auch als Hypertext REFCHECK.HYP.
        - Modulnamen wurden evtl. nicht in voller Lnge verglichen. Z.B.
          wurde beim Modul "aip" irrtmlich auch "aip_auto" oder "aip_prog"
          erkannt!
        - Neues Konzept: Es wird nicht mehr nach REF-Dateien, sondern nach
          HYP-Dateien und dann erst nach der passenden REF-Datei gesucht!
          Dadurch funktioniert der Schalter -d jetzt auch, wenn man nur mit
          der ALL.REF arbeitet und die Module werden nicht gelscht. Nur,
          wenn die HYP-Datei fehlt, wird ein Modul aus der ALL.REF gelscht!
        - Maximale Anzahl der HYP-Dateien auf 1024 erhht (bisher 200). Ich
          denke, das sollte frs erste ausreichen!

    1.2 - Neue Option -k. Hiermit werden die REF-Dateien nach erfolgreicher
          Aktualisierung/Aufnahme von der Platte gelscht! Besonders
          geeignet fr diejenigen, die nur mit der ALL.REF arbeiten!
        - Optionsbeschreibung im Usage-Text an die man page angepat.
        - Wenn die Environmentvariable HOME existiert, wird die ST-GUIDE.INF
          zuerst dort gesucht.

   1.21 - Starten von REFLINK funktionierte nicht richtig, wenn weder eine
          Shell gefunden wurde, noch die System-Environmentvariable PATH
          existierte oder einen gltigen Pfad fr REFLINK enthielt. Im
          aktuellen Verzeichnis wurde auch nicht gesucht. Jetzt wird, wenn
          keie Shell existiert, zuerst im aktuellen Verzeichnis gesucht und
          erst wenn das fehlschgt, wird REFLINK mit spawnlp() gestartet.

    1.3 - Bei den Suchvorgngen werden jetzt alle gefundenen Module und
          Dateien angezeigt. Beim Scannen der ALL.REF wird jeweils
          Modulname, Offset und -lnge, bei der HYP-Suche HYP-Name und falls
          vorhanden "+REF", Modulname und -lnge ausgegeben!
        - Absturz beseitigt, wenn die ALL.REF ein Modul mit einer Lnge
          >32767 Bytes enthielt.
        - REFCHECK bercksichtigt jetzt die Tatsache, da auch einfache
          REF-Dateien mehr als ein Modul enthalten knnen, z.B. ENG_GER.REF.
        - Wenn die Option -k gesetzt ist, wird die REF-Datei jetzt nicht
          mehr von REFCHECK gelscht, sondern REFLINK mit der Option -m
          (move) gestartet.
        - Speicheranforderungen (malloc) werden jetzt berprft.
        - Fehlerhaftes spawn-Binding ersetzt. Dank an Jerry Geiger @ B,
          der mir die korrigierte spawn3.o als UUE geschickt hat:-)
        - REFLINK-Aufrufe mit der Option -d (lschen) werden jetzt in einem
          einzigen Aufruf zusammengefat, wenn die REFCHECK-Option -i nicht
          gesetzt ist oder bei einer Abfrage durch [a] deaktiviert wurde!
        - Option -s (silent) beschrnkt die Bildschirmausgaben auf das
          ntigste -> schneller.
        - Die Option -g (global) wurde nicht beachtet, wenn eine REF-Datei
          noch nicht in der ALL.REF vorhanden war.

    1.4 - Variablen REFLINK und REFCHECK-OPT in der Datei ST-GUIDE.INF
          werden ausgewertet.

    1.5 - HYP/REF-Dateien und Module in der ALL.REF werden jetzt auch dann
          einander korrekt zugeordnet, wenn der Name der HYP-Datei nicht mit
          dem Modulnamen in der REF-Datei bereinstimmt. Aktuelles Beispiel:
          Dateiname: POV.HYP/REF, Modulname: POV_DEUT (deutsche Version)!
        - Wenn der Dateiname nicht mit dem Modulnamen bereinstimmt,
          erscheint in der Ausgabeliste (wenn Option -s nicht gesetzt) ein
          Ausrufezeichen (!) hinter dem Modulnamen. Auerdem wird eine
          gesetzte move-Option (-k) fr diese REF-Datei deaktiviert, damit
          die Datei erhalten bleibt und REFCHECK beim nchsten Aufruf den
          Modulnamen korrekt zuordnen kann (sonst wrde das Modul evtl.
          gleich wieder aus der ALL.REF gelscht)!

    1.6 - Zum Starten von REFLINK mu jetzt zwingend die Variable
          REFLINK in der ST-GUIDE.INF definiert sein. Der Start ber
          eine System-Shell wird nicht mehr untersttzt!
        - Wenn in der ST-GUIDE.INF die Variable REFPATHS gefunden wird, wird
          diese anstelle von PATHS benutzt. So kann man bestimmen, da nur
          die REF-Dateien von Hypertexten aus bestimmten Pfaden in die
          ALL.REF aufgenommen werden.
        - Die mgliche Anzahl der HYP-Dateien/Module ist nur noch durch
          den freien Speicherplatz beschrnkt.

    1.7 - Bugfix: REFCHECK strzte ab, wenn keine ALL.REF existierte.
    
    2.0 - Super() (bei der Ermittlung des Bootlaufwerks) durch Supexec()
          ersetzt.
        - REFLINK wird jetzt als externes Programm nicht mehr bentigt, da
          es komplett in REFCHECK integriert wurde (Dank an Holger fr den
          Quelltext)!
        - Das Hinzufgen von REF-Dateien zur ALL.REF im REFCHECK-Modus wurde
          erheblich beschleunigt, da nun alle Files auf einmal behandelt
          werden, sofern die Option -i nicht gesetzt ist. Die Add-Routine
          des REFLINK-Moduls wurde dahingehend optimiert.
        - REFCHECK-Option -k heit jetzt -m (move into).
        - Zwei neue Optionen zum automatischen Aufruf eines 
          Katalogerzeugungsprogramms, das ber die Variable $STOOL in der
          ST-GUIDE.INF definiert sein mu. Da zuerst versucht wird, $STOOL
          ber das system()-Kommando zu starten, kann es sich dabei z.B. 
          auch um ein Mupfel-Script handeln, sofern eine System-Shell 
          installiert ist! Die beiden Optionen sind:
          -c: $STOOL aufrufen, wenn nderungen gefunden wurden. Hierbei ist
              mit 'nderungen' das Hinzufgen einer REF-Datei oder das
              Lschen eines Moduls gemeint (auch wenn dieses nur angezeigt
              und nicht ausgefhrt wird).
          -f: $STOOL auf jeden Fall aufrufen.
        - Neue Option '-r reflib', mit der man fr alle Aktionen die zu
          bearbeitende REF-Bibliothek festlegen kann. Defaultmig wird die
          REF-Bibliothek aus der ST-GUIDE.INF-Variablen REF benutzt. Die
          Angabe der REF-Bibliothek als erstes File in der Kommandozeile,
          wie frher bei REFLINK ist also bei keiner Option mehr ntig bzw.
          mglich und mu explizit ber die Option -r erfolgen, wenn nicht
          die Default-REF benutzt werden soll.
   2.01 - Bugfix: Die Envrionmentvariable SHELL (zum Starten von $STOOL)
          wurde nicht gefunden, weil ich fr meinen letzten Test "SHELLx"
          draus gemacht hatte und dann vergessen habe, das x wieder zu
          entfernen;-)
         
COPYRIGHT
    REFCHECK ist Freeware, d.h. das Programm darf beliebig  weitergegeben
    werden, allerdings nur unverndert und komplett mit allen Dateien.

DISCLAIMER
    Ich bernehme keine Haftung fr Schden jeglicher Art, die durch die
    Benutzung oder Nicht-Benutzung von REFCHECK entstanden sind.

AUTOR
    Frank Rger
    Tecklenburger Strae 21
    D-49525 Lengerich

    email: Frank Rger @ OS2 im Mausnetz bzw.
           Frank_Rueger@os2.maus.de aus dem InterNet

    Vielen Dank an Holger Weets @ OL (Autor des ST-Guide-Systems) fr die
    Zurverfgungstellung (nettes Wort:-) des REFLINK-Quelltextes, der von
    mir noch etwas berarbeitet wurde.
