// Persistence of Vision Raytracer 2.0
// Image by George Ganoe

#include "colors.inc"           // Standard colors library
#include "shapes.inc"           // Commonly used object shapes
#include "textures.inc"         // LOTS of neat textures.  Lots of NEW textures.
#include "stones.inc"

camera {
   location  <-2.10, 3.0, -4.0>
   direction <0.0,  0.0,  2.7>
   up        <0.0,  1.0,  0>
   right     <4/3,  0.0,  0>
   look_at   <2.0,    0,   0.8>}

light_source {<-100, 100,  -200> color White}
light_source {<100, 100,  -200> color Gray50}

#declare DomCutout = box { <-0.45, -0.45, -0.02>, <0.45, 0.45, 0.02> }
#declare DomDivide = box { <-0.45, -0.015, -0.01>, <0.45, 0.015, 0.01> }
#declare DomBox = union {
   box { <-0.5, -0.94, -0.125>, <0.5, 0.94, 0.125> }
   box { <-0.44, -1.0, -0.125>, <0.44, 1.0, 0.125> }
   cylinder { <-0.44, 0.94, -0.125>, <-0.44, 0.94,  0.125>, 0.06 }
   cylinder { <-0.44, -0.94, -0.125>, <-0.44, -0.94,  0.125>, 0.06 }
   cylinder { <0.44, 0.94, -0.125>, <0.44, 0.94,  0.125>, 0.06 }
   cylinder { <0.44, -0.94, -0.125>, <0.44, -0.94,  0.125>, 0.06 }
}

#declare DomRout = union {
   object {
      DomDivide
      translate <0, 0, -0.125>
   }
   object {
      DomCutout
      translate <0, 0.5, -0.125>
   }
   object {
      DomCutout
      translate <0, -0.5, -0.125>
   }
}

#declare DomBlank = difference
{
   object { DomBox }
   object { DomRout }
   texture {
      pigment { Gray10 }
      normal{ bumps 0.2 scale 0.01 }
      finish { Shiny }
   }
   bounded_by { box { <-0.501, -1.01, -0.126>, <0.501, 1.01, 0.126> } }
}

#declare Dom2Sph = union {
   sphere { <-0.27, -0.27, 0>, 0.08 }
   sphere { < 0.27,  0.27, 0>, 0.08 }
}

#declare Dom2Dip = union {
   sphere { <-0.27, -0.27, -0.1833>, 0.2 }
   sphere { < 0.27,  0.27, -0.1833>, 0.2 }
}

#declare Dom2Dot = difference {
   object { Dom2Sph }
   object { Dom2Dip }
   texture {
      pigment { Gray85 }
      finish { Shiny }
   }
}

#declare Dom3Sph = union {
   sphere { < 0,     0,    0>, 0.08 }
   sphere { <-0.27, -0.27, 0>, 0.08 }
   sphere { < 0.27,  0.27, 0>, 0.08 }
}

#declare Dom3Dip = union {
   sphere { < 0,     0,    -0.1833>, 0.2 }
   sphere { <-0.27, -0.27, -0.1833>, 0.2 }
   sphere { < 0.27,  0.27, -0.1833>, 0.2 }
}

#declare Dom3Dot = difference {
   object { Dom3Sph }
   object { Dom3Dip }
   texture {
      pigment { Gray85 }
      finish { Shiny }
   }
}

#declare Dom7Sph = union {
   sphere { < 0,     0,    0>, 0.08 }
   sphere { <-0.27,  0.27, 0>, 0.08 }
   sphere { <-0.27,  0,    0>, 0.08 }
   sphere { <-0.27, -0.27, 0>, 0.08 }
   sphere { < 0.27,  0.27, 0>, 0.08 }
   sphere { < 0.27,  0,    0>, 0.08 }
   sphere { < 0.27, -0.27, 0>, 0.08 }
}

#declare Dom7Dip = union {
   sphere { < 0,     0,    -0.1833>, 0.2 }
   sphere { <-0.27,  0.27, -0.1833>, 0.2 }
   sphere { <-0.27,  0,    -0.1833>, 0.2 }
   sphere { <-0.27, -0.27, -0.1833>, 0.2 }
   sphere { < 0.27,  0.27, -0.1833>, 0.2 }
   sphere { < 0.27,  0,    -0.1833>, 0.2 }
   sphere { < 0.27, -0.27, -0.1833>, 0.2 }
}

#declare Dom7Dot = difference {
   object { Dom7Sph }
   object { Dom7Dip }
   texture {
      pigment { Gray85 }
      finish { Shiny }
   }
}

object {
   union {
      difference {
         object { DomBlank }
         union {
            object {
               Dom7Sph
               translate <0, 0.5, -0.105>
            }
            object {
               Dom3Sph
               translate <0, -0.5, -0.105>
            }
         }
      }
      union {
         object {
            Dom7Dot
            translate <0, 0.5, -0.105>
         }
         object {
            Dom3Dot
            translate <0, -0.5, -0.105>
         }
      }
   }
   translate < 2.5, 0, 0.0 >
}

object {
   DomBlank
   translate < 2.50, 0, 0.0 >
   rotate -25*y
}

object {
   union {
      difference {
         object { DomBlank }
         union {
            object {
               Dom2Sph
               translate <0, 0.5, -0.105>
            }
            object {
               Dom3Sph
               translate <0, -0.5, -0.105>
            }
         }
      }
      union {
         object {
            Dom2Dot
            translate <0, 0.5, -0.105>
         }
         object {
            Dom3Dot
            translate <0, -0.5, -0.105>
         }
      }
   }
   translate < 2.50, 0, 0.0 >
   rotate -50*y
}

object {
   DomBlank
   translate < 2.50, 0, 0.0 >
   rotate -75*y
}

/*
object {
   DomBlank
   translate < 2.50, 0, 0.0 >
   rotate -100*y
}

object {
   DomBlank
   translate < 2.50, 0, 0.0 >
   rotate -125*y
}

object {
   DomBlank
   translate < 2.50, 0, 0.0 >
   rotate -150*y
}

object {
   DomBlank
   translate < 2.50, 0, 0.0 >
   rotate -175*y
}
*/

plane { y, -1.001 
/*
   texture {
      pigment { Aquamarine }
      finish { Dull }
   }
*/
   texture {
      Stone1
      pigment {
         octaves 3
         rotate 90*z
      }
      finish { reflection 0.05 }
   }
}

sphere { <0, 0, 0>, 1000
   texture {
      pigment { White }
      finish { Luminous }
   }
}

// end of file
