/* amigaizepath

   Special changes:	"/dev/null" is changed to "NULL:"
			"/dev/tty" is changed to "CON:"
			"/dev/console" is changed to "CON:"
   Main purpose:

	"./" (current dir) and "../" (parent dir) show up in all sorts of PERL
	scripts.  Since the Amiga doesn't assign any meaning to "." or "..",
	we steal them for Unix compatibility.

	Amigaizepath modifies all "./" and "../" in the argument string.

	In detail, we recognize a "../" or "./" at the beginning of the line
	or if preceeded by any non-alphanumeric character.  Note that this
	precludes (from within PERL) the use of AmigDOS directory names ending
	in a "." which have special characters preceeding it. (e.g. /a/b+./xx)

	Except for the special cases listed above, pathnames with a leading
	'/' are left entirely alone, as are multiple '/'s in a row.

	Plain "." is turned into "", which is the current directory in both
	AmigaDOS and is usually treated that way in Unix.

	Plain ".." is turned into '/', the parent directory.

	[It's not perfect, but it keeps all sorts of PERL scripts happy.]

   Return:
	The number of characters removed, so "len" can be updated in caller.
*/

int amigaizepath(char *to)
{
    char *from = to;
    int last = 0, removed = 0;

    while (*from == ' ') {
	from++;
	removed++;
    }

    if (*from == '/') {
	if (strncmp(from, "/dev/", 5)) return(removed);

	from += 5;
	if (!strcmp(from, "null")) {
	    strcpy (to, "NULL:");
	    removed += 4;
	} else if (!strcmp(from, "tty")) {
	    strcpy (to, "CON:");
	    removed += 4;
	} else if (!strcmp(from, "console")) {
	    strcpy (to, "CON:");
	    removed += 8;
	}
	return (removed);
    }

    while (*from) {
	if (*from == '.') {			/* Found ".", need hacking? */
	    /* If beginning of line or last char was not alphanumeric */
	    if (!last || !isalnum(last)) {
		if (!last) {			/* Look for plain "." & ".." */
		    if (!*(from + 1)) {
			*from = '\0';		/* Change it to "" */
			return(0);
		    } else if (*(from + 1) == '.' && !*(from + 2)) {
			*from = '/';		/* Change it to "/" */
			*(from+1) = '\0';
			return(0);
		    }
		}

		if (*(from + 1) == '/') {
		    from += 2;			/* Skip "./" */
		    removed += 2;
		    last = '/';
		    continue;			/* And go on to next char */
		} else if (*(from + 1) == '.') {
		    if (*(from + 2) == '/') {	/* Found "../"; skip ".." and */
			from += 2;		/*  fall through allowing '/' */
			removed += 2;
		    }
		}				/*  to be assigned below      */
	    }
	}
	last = *from;
	*to++ = *from++;
    }
    *to = '\0';
    return (removed);
}
