.TH info 1 "20th October 1991"
.SH NAME
rtf2TeX \- Convert RTF (Rich Text Format) to TeX
.SH SYNOPSIS
.B rtf2TeX
[
.B \-i include-file
]
[
.B \-h
]
[
.B {-+}cstT
]
[
.B \-v[#]
]
[
.B \-V
]
[
.B RTF-file
]
.SH DESCRIPTION
.LP
.I rtf2TeX
is a filter built on Paul DuBois' RTF reader that converts
RTF (Microsoft's Rich Text Format) into TeX.
.I rtf2TeX
expends a good deal of effort in an attempt to make the resulting
TeX maintainable and modifiable.

There are a large number of features that
.I rtf2TeX
doesn't support due to a lack of motivation; many could be easily
added without making any major changes to the programme, by just
adding short sections of code.  I would be happy to receive such
patches from you and will attempt to merge them into an evolving
version of rtf2TeX. However, I doubt if I will have much chance to
work on the code myself.

.SH OPTIONS

.TP
.B +-c
By default (\+c)
.I rtf2TeX
tries to cleanup the TeX that it emits, for example replacing
strings such as $\\beta$$^{\\alpha}$ with $\\beta^\\alpha$;
if you choose \-c no such attempt is made.

.TP
.B \-h
Print a summary of your options.

.TP
.B \-i include-file
Generate a line
.B \\input include-file
at an appropriate place in the generated TeX file.
.I rtf2TeX
uses a small number of definitions that are not present in plain TeX
for example, a macro to draw an outline box, and one to change the
point-size of a font. Rather than wire these macros into the
code,
.I rtf2TeX
provides a TeX file
.B TeX_defs.tex
containing a specimen set of such definitions; including it should allow
the output TeX to be processed smoothly.

.TP
.B +-s
Turn style expansion on (+, default) or off (-). RTF maintains a set
of `styles' that specify some combination of fonts and paragraph properties.
By default,
.I rtf2TeX
expands these styles when it sees them in the course of reading a document.
If you turn off style expansion it instead defines a macro for each style
at the head of the document, and calls that macro when needed.

Because style names can have embedded blanks and other characters that
TeX doesn't allow in macro names, spaces are removed (and the following
character capitalised), and digits are replaced by letters (1 --> A etc,
0 --> O).

.TP
.B -+t
Don't try to generate \\haligns (-, default) or do (+).
.I rtf2TeX
has some primitive ability to handle tabs in RTF files. When the RTF
style explicitly sets tabstops,
.I rtf2TeX
tries to generate a table using \\halign. Otherwise, a tab is simply
mapped into an \qquad.
The \\halign strategy is not always a great success, but it can be turned on
with \+t.

.TP
.B +-T
Ignore widths in tables (-) or keep them (+, default). This refers to
the \\halign tables that
.I rtf2TeX
usually generates in response to tabs. If you specify \-T, no widths
are specified in the preamble, and TeX uses it's usual algorithms to
choose column widths. You should note that many RTF tables have slightly
different tab settings from line to line, in which case
.I rtf2TeX
is forced to generate a large number of small tables; with \-T each will
have its widths calculated separately.

.TP
.B -v[#]
Turn on verbose messages; # defaults to one. The larger the value of
the verbosity, the more messages you'll get. 

.TP
.B -V
Print the current version number.

.TP
.B RTF-file
The RTF file to convert. If you don't specify an input file
.I rtf2TeX
will read the standard output.

.SH SEE ALSO
.BR tex(1)

.SH BUGS
Sometimes incorrect TeX is produced (e.g. {\\it \\/}).
.br
The treatment of tables is at best incomplete, and may be buggy.
.br
Many keywords aren't dealt with, although it would not be hard
to support them.

.SH AUTHOR
.RS
Robert Lupton
.br
rhl@astro.princeton.edu
