/* first example in the article */

#include <stdio.h>
#include "sim.h"
#include "sim_lib.h"
#include <float.h>

DEFINE_CREATE(customers);

DEFINE_QUEUE(q_loan_officer);
DEFINE_QUEUE(q_Biff);
QUEUE_STRUCT *q_array[]={&q_loan_officer_q,&q_Biff_q};
#define NUM_QUEUES	(sizeof(q_array)/sizeof(QUEUE_STRUCT *))

DEFINE_SERVICE(s_loan_officer);
DEFINE_SERVICE(s_Biff);
SERV_DATA *s_array[]={&s_loan_officer_s,&s_Biff_s};
#define NUM_SERVS	(sizeof(s_array)/sizeof(SERV_DATA *))

void decision_1(ENTITY *);
void decision_2(ENTITY *);
void term(ENTITY *);
void stop(void);

void main(int ac,char **av)
{
long runtime=0;
extern long strtol();
        if (ac > 1) runtime = strtol(av[1],0,0);
	SCHEDULE(customers,0,0);
	SCHEDULE(stop,0,(double)runtime);
	engine();
	}

CREATE(customers,now,0,expon(15.0),q_loan_officer)

QUEUE(q_loan_officer,s_loan_officer)
SERVICE(s_loan_officer,2,unfrm(20.0,30.0),decision_1)

void decision_1(ENTITY *entity)
{
	TRACE(decision_1);        /* debug code */
	PR_ENTITY(entity);        /* debug code */
	if (drand() < .6) term(entity);
	else q_Biff(entity);
	}

QUEUE(q_Biff,s_Biff)
SERVICE(s_Biff,1,normal(45.0,10.0),decision_2)

void decision_2(ENTITY *entity)
{
	TRACE(decision_2);       /* debug code */
	PR_ENTITY(entity);       /* debug code */
	if (drand()	< .85) term(entity);
	else q_loan_officer(entity);
	}

static systime_t total_time, max_time, min_time = FLT_MAX;
static unsigned count;

void term(ENTITY *entity)
{
systime_t tis;

	TRACE(term);             /* debug code */
	PR_ENTITY(entity);       /* debug code */
	count++;
	tis = now - entity->time;
	total_time += tis;
	if (max_time < tis) max_time = tis;
	if (min_time > tis) min_time = tis;
	free(entity);
	}

void stop(void)
{
int i;

	TRACE(stop);
	printf("Total time in system =   %10.4f, count = %d\n",
		total_time,count);
	printf("Average time in system = %10.4f\n",total_time/count);
	printf("Max time in system =     %10.4f\n",max_time);
	printf("Min time in system =     %10.4f\n",min_time);
	printf("\nSERVICES:  name|total|total busy|utilization|\n\
---------------|-----|----------|-----------|\n");
	for (i=0;i<NUM_SERVS;i++)
		printf("%15.s|%5.ld|%10.4f| %10.4f|\n",
			s_array[i]->name,
			s_array[i]->total,
			s_array[i]->total_busy,
			(s_array[i]->srvtime)
			       ? s_array[i]->total_busy/s_array[i]->srvtime
			       : 0
			);
	printf("\nQUEUES:    name|max_len|cur_len|total_wait|count|\
average_wait|\n\
---------------|-------|-------|----------|-----|------------|\n");
	for (i=0;i<NUM_QUEUES;i++)
		printf("%15.s|%7.d|%7.d|%10.4f|%5.d|  %10.4f|\n",
			q_array[i]->name,
			q_array[i]->max_len,
			q_array[i]->cur_len,
			q_array[i]->total_wait,
			q_array[i]->count,
			(q_array[i]->count)
				? q_array[i]->total_wait/q_array[i]->count
				: 0
			);
	exit(0);
	}
