/* $Id: statuswin.c,v 1.2 90/05/06 14:00:34 pturner Exp Locker: pturner $
 *
 * status popup and about_grtool()
 *
 */

#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include "globals.h"
#include "defines.h"

extern Frame main_frame;
extern Pixfont *winfont;
extern char version[];

Frame status_frame;
static Frame status_panel;
static Panel_item header_item1;
static Panel_item status_items_x[MAXPLOT];
static Panel_item status_items_y[MAXPLOT];

FILE *resfp = stdout;

/*
 * write s to the results file - this is a remnant of
 * the old textsw I used in an earlier version
 */
void stufftext(s)
    char *s;
{
    fprintf(resfp, s);
    fflush(resfp);
}

/*
 * routines for the status of sets popup
 */
void do_status_proc(item, event)
    Panel_item item;
    Event *event;
{
    window_set(status_frame, WIN_SHOW, TRUE, 0);
}

static void status_done_proc()
{
    window_set(status_frame, WIN_SHOW, FALSE, 0);
}

void update_status(setno)
    int setno;
{
    double x1, y1, x2, y2, xbar, ybar, xsd, ysd, *getx(), *gety();

    getsetminmax(setno, &x1, &x2, &y1, &y2);
    if (isactive(setno)) {
	stasum(getx(setno), getsetlength(setno), &xbar, &xsd, 0);
	stasum(gety(setno), getsetlength(setno), &ybar, &ysd, 0);
    } else {
	xbar = 0.0;
	ybar = 0.0;
	xsd = 0.0;
	ysd = 0.0;
    }
    sprintf(buf, "%2d %4d %3s  X  %8.5g %8.5g %8.5g %8.5g   %s", setno, getsetlength(setno), onoff(isactive(setno)), x1, x2, xbar, xsd, getcomment(setno));
    panel_set_value(status_items_x[setno], buf);
    sprintf(buf, "             Y  %8.5g %8.5g %8.5g %8.5g", y1, y2, ybar, ysd);
    panel_set_value(status_items_y[setno], buf);
}

static void update_status_popup()
{
    int i;

    for (i = 0; i < maxplot; i++) {
	update_status(i);
    }
}

/*
 * write the status to the results file
 */
static void update_stuff_status()
{
    double x1, y1, x2, y2, xbar, ybar, xsd, ysd, *getx(), *gety();
    int i;

    sprintf(buf, "\nStatus of sets\n");
    stufftext(buf);
    for (i = 0; i < maxplot; i++) {
	getsetminmax(i, &x1, &x2, &y1, &y2);
	if (isactive(i)) {
	    stasum(getx(i), getsetlength(i), &xbar, &xsd, 0);
	    stasum(gety(i), getsetlength(i), &ybar, &ysd, 0);
	} else {
	    xbar = 0.0;
	    ybar = 0.0;
	    xsd = 0.0;
	    ysd = 0.0;
	}
	sprintf(buf, "%2d %4d %3s  X  %8.5g %8.5g %8.5g %8.5g   %s\n", i, getsetlength(i), onoff(isactive(i)), x1, x2, xbar, xsd, getcomment(i));
	stufftext(buf);
	sprintf(buf, "             Y  %8.5g %8.5g %8.5g %8.5g\n", y1, y2, ybar, ysd);
	stufftext(buf);
    }
}

void define_status_popup()
{
    int i;

    status_frame = window_create(main_frame, FRAME,
				 WIN_Y, 50,
				 WIN_FONT, winfont,
				 FRAME_LABEL, "Status",
				 FRAME_SHOW_LABEL, TRUE,
			      WIN_ERROR_MSG, "Couldn't create status_frame",
				 0);
    status_panel = window_create(status_frame, PANEL,
				 WIN_FONT, winfont,
				 WIN_VERTICAL_SCROLLBAR, scrollbar_create(0),
				 0);

    sprintf(buf, "set# n  stat        min     max     mean   std. dev.   comment");
    header_item1 = panel_create_item(status_panel, PANEL_MESSAGE,
				     PANEL_LABEL_FONT, winfont,
				     PANEL_LABEL_STRING, buf,
				     PANEL_ITEM_X, ATTR_COL(1),
				     PANEL_ITEM_Y, ATTR_ROW(0),
				     0);
    for (i = 0; i < maxplot; i++) {
	status_items_x[i] = panel_create_item(status_panel, PANEL_TEXT,
					      PANEL_VALUE_FONT, winfont,
					      PANEL_ITEM_X, ATTR_COL(1),
					  PANEL_ITEM_Y, ATTR_ROW(1 + 2 * i),
					 PANEL_VALUE_DISPLAY_LENGTH, 80, 0);
	status_items_y[i] = panel_create_item(status_panel, PANEL_TEXT,
					      PANEL_VALUE_FONT, winfont,
					      PANEL_ITEM_X, ATTR_COL(1),
					  PANEL_ITEM_Y, ATTR_ROW(2 + 2 * i),
					 PANEL_VALUE_DISPLAY_LENGTH, 80, 0);
    }
    panel_create_item(status_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	       panel_button_image(status_panel, "Write status", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(31),
		      PANEL_NOTIFY_PROC, update_stuff_status,
		      0);
    panel_create_item(status_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	      panel_button_image(status_panel, "Update status", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(20),
		      PANEL_ITEM_Y, ATTR_ROW(31),
		      PANEL_NOTIFY_PROC, update_status_popup,
		      0);
    panel_create_item(status_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(status_panel, "Done", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(40),
		      PANEL_ITEM_Y, ATTR_ROW(31),
		      PANEL_NOTIFY_PROC, status_done_proc,
		      0);
    window_fit(status_panel);
    window_fit(status_frame);
}


void cancel_ok(item, event)
    Panel_item item;
    Event *event;
{
    window_return(panel_get(item, PANEL_CLIENT_DATA));
}

static Panel_setting eotproc(item, event)
    Panel_item item;
    Event *event;
{
    switch (event_id(event)) {
    case '\t':
	return PANEL_INSERT;
    case '\r':
    case '\n':
	window_return(TRUE);
	return PANEL_NONE;

    default:
	return PANEL_INSERT;
    }
}

/*
 * get a string - blocking popup
 */
int get_msg(oldmsg, newmsg, header, prompt)
    char *oldmsg, *newmsg, *header, *prompt;
{
    int status;
    Frame getmsg_frame;
    Panel getmsg_panel;
    Panel_item msg_item;
    Panel_item msg_header_item;

    getmsg_frame = window_create(0, FRAME,
				 WIN_Y, 50,
				 WIN_X, 50,
				 WIN_FONT, winfont,
				 FRAME_SHOW_LABEL, FALSE,
				 FRAME_NO_CONFIRM, TRUE,
			      WIN_ERROR_MSG, "Couldn't create getmsg_frame",
				 0);
    getmsg_panel = window_create(getmsg_frame, PANEL,
				 WIN_FONT, winfont,
				 0);
    msg_item = panel_create_item(getmsg_panel, PANEL_TEXT,
				 PANEL_LABEL_STRING, prompt,
				 PANEL_ITEM_X, ATTR_COL(1),
				 PANEL_ITEM_Y, ATTR_ROW(1),
				 PANEL_NOTIFY_STRING, "\r\t\n",
				 PANEL_NOTIFY_PROC, eotproc,
				 PANEL_VALUE_DISPLAY_LENGTH, 60, 0);
    msg_header_item = panel_create_item(getmsg_panel, PANEL_MESSAGE,
					PANEL_LABEL_STRING, header,
					PANEL_ITEM_X, ATTR_COL(1),
					PANEL_ITEM_Y, ATTR_ROW(0),
					0);
    panel_create_item(getmsg_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(3),
		      PANEL_LABEL_IMAGE,
		      panel_button_image(getmsg_panel, "Cancel", 6, 0),
		      PANEL_CLIENT_DATA, FALSE,
		      PANEL_NOTIFY_PROC, cancel_ok, 0);

    panel_create_item(getmsg_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(10),
		      PANEL_ITEM_Y, ATTR_ROW(3),
		      PANEL_LABEL_IMAGE,
		      panel_button_image(getmsg_panel, " OK ", 6, 0),
		      PANEL_CLIENT_DATA, TRUE,
		      PANEL_NOTIFY_PROC, cancel_ok, 0);
    window_fit(getmsg_panel);
    window_fit(getmsg_frame);
    panel_set_value(msg_item, oldmsg);
    status = (int) window_loop(getmsg_frame);
    strcpy(newmsg, (char *) panel_get_value(msg_item));
    window_destroy(getmsg_frame);
    return status;
}

/*
 * say a few things about grtool, number of graphs, set size
 */
void about_grtool()
{
    Frame about_frame;
    Panel about_panel;
    Panel_item about_item[8];

    about_frame = window_create(main_frame, FRAME,
				WIN_Y, 50,
				WIN_X, 50,
				WIN_FONT, winfont,
				FRAME_SHOW_LABEL, FALSE,
				FRAME_NO_CONFIRM, TRUE,
				WIN_ERROR_MSG, "Couldn't create about_frame",
				0);
    about_panel = window_create(about_frame, PANEL,
				WIN_FONT, winfont,
				0);
    strcpy(buf, version);
    about_item[0] = panel_create_item(about_panel, PANEL_MESSAGE,
				      PANEL_ITEM_X, ATTR_COL(1),
				      PANEL_ITEM_Y, ATTR_ROW(0),
				      PANEL_LABEL_STRING, buf, 0);
    sprintf(buf, "Max number of sets = %d", MAXPLOT);
    about_item[1] = panel_create_item(about_panel, PANEL_MESSAGE,
				      PANEL_ITEM_X, ATTR_COL(1),
				      PANEL_ITEM_Y, ATTR_ROW(1),
				      PANEL_LABEL_STRING, buf, 0);
    sprintf(buf, "Max set length = %d (soft limit)", MAXARR);
    about_item[2] = panel_create_item(about_panel, PANEL_MESSAGE,
				      PANEL_ITEM_X, ATTR_COL(1),
				      PANEL_ITEM_Y, ATTR_ROW(2),
				      PANEL_LABEL_STRING, buf, 0);
    sprintf(buf, "Max number of graphs = %d", MAXGRAPH);
    about_item[3] = panel_create_item(about_panel, PANEL_MESSAGE,
				      PANEL_ITEM_X, ATTR_COL(1),
				      PANEL_ITEM_Y, ATTR_ROW(3),
				      PANEL_LABEL_STRING, buf, 0);
    sprintf(buf, "Max number of lines per graph = %d", MAXLINES);
    about_item[4] = panel_create_item(about_panel, PANEL_MESSAGE,
				      PANEL_ITEM_X, ATTR_COL(1),
				      PANEL_ITEM_Y, ATTR_ROW(4),
				      PANEL_LABEL_STRING, buf, 0);
    sprintf(buf, "Max number of boxes per graph = %d", MAXBOXES);
    about_item[5] = panel_create_item(about_panel, PANEL_MESSAGE,
				      PANEL_ITEM_X, ATTR_COL(1),
				      PANEL_ITEM_Y, ATTR_ROW(5),
				      PANEL_LABEL_STRING, buf, 0);
    sprintf(buf, "Maximum number of strings per graph = %d", MAXSTR);
    about_item[6] = panel_create_item(about_panel, PANEL_MESSAGE,
				      PANEL_ITEM_X, ATTR_COL(1),
				      PANEL_ITEM_Y, ATTR_ROW(6),
				      PANEL_LABEL_STRING, buf, 0);
    panel_create_item(about_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(10),
		      PANEL_ITEM_Y, ATTR_ROW(8),
		      PANEL_LABEL_IMAGE,
		      panel_button_image(about_panel, " OK ", 6, 0),
		      PANEL_CLIENT_DATA, TRUE,
		      PANEL_NOTIFY_PROC, cancel_ok, 0);
    window_fit(about_panel);
    window_fit(about_frame);
    window_loop(about_frame);
    window_destroy(about_frame);
}
