/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

#include <sys/time.h>

#include "sim.h"

#ifdef FSIM
# define ONE 1.0
#else
# define ONE 1000
#endif

UFweightedsum(up)
     Unit * up;

{
  register Link * ip;
  register FLINT sum = 0;

  for (ip = up->sites->inputs; ip != NULL; ip = ip->next)
	sum += (ip->weight) * (*(ip->value));
  up->output = (sum/ONE);
}

build()

{
  int i,j,k,n;
  int l,m;
  int start, finish;
  Unit * up;

  struct timeval tp;
  struct timezone tzp;

  printf("how many units > ");
  scanf("%d",&l);
  printf("how many links per unit > ");
  scanf("%d",&m);
  printf("%d units, %d links per unit\n",l,m);
  i = l;
  j = m;
  gettimeofday(&tp,&tzp);
  start = tp.tv_sec;

  AllocateUnits(i);
  for (k = 0; k < i; k++)
    {
      MakeUnit("vertex",UFweightedsum,(FLINT)0,(FLINT)0,(FLINT)k,(FLINT)0,0,0);
      AddSite(k,"excite",NULL, (FLINT) k);
      SetFlagP((up = UnitList+k),NO_SITE_FUNC_FLAG);
      SetFlagP(up,NO_LINK_FUNC_FLAG);
    }
  for (k = 0; k < i; k++)
    for (n = 0; n < j; n++)
      MakeLink(random() % i,k,"excite",ONE,(FLINT)k,NULL);

  gettimeofday(&tp,&tzp);
  finish = tp.tv_sec;
  printf("time = %ld seconds\n",finish - start);
}
