/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

#include "sim.h"
#include <sys/time.h>

int Count;
extern int Echo;

UFweightedsum(up)
     Unit * up;

{
  register Link * ip;
  register FLINT sum = 0;

  for (ip = up->sites->inputs;
       ip != NULL;
       sum += (ip->weight) * (*(ip->value)), ip = ip->next);
  up->output = (sum/1000);
}

build(argc,argv)
     int argc;
     char ** argv;

{
  int i,j,k,n;
  int l,m;
  int start, finish;
  Unit * up;

  struct timeval tp;
  struct timezone tzp;
  
  sscanf(argv[1],"%d",&l);
  sscanf(argv[2],"%d",&m);
  printf("%d units, %d links per unit\n",l,m);
  i = l;
  j = m;
  gettimeofday(&tp,&tzp);
  start = tp.tv_sec;

  AllocateUnits(i);
  for (k = 0; k < i; k++)
    {
#ifdef TSIM
      MakeDelayUnit("vertex",UFweightedsum,(FLINT)0,(FLINT)0,(FLINT)k,(FLINT)0,0,0,255);
#else
      MakeUnit("vertex",UFweightedsum,(FLINT)0,(FLINT)0,(FLINT)k,(FLINT)0,0,0);
#endif
      AddSite(k,"excite",NULL, (FLINT) k);
      SetFlagP((up = UnitList+k),NO_SITE_FUNC_FLAG);
      SetFlagP(up,NO_LINK_FUNC_FLAG);
    }
  for (k = 0; k < i; k++)
    for (n = 0; n < j; n++)
#ifdef TSIM
      MakeDelayLink(random() % i,k,"excite",(FLINT)1000,(FLINT)k,NULL,
	       1+(random()%254));
#else
      MakeLink(random() % i,k,"excite",(FLINT)1000,(FLINT)k,NULL);
#endif

  gettimeofday(&tp,&tzp);
  finish = tp.tv_sec;
  printf("time = %ld seconds\n",finish - start);
}

addlinks(argc,argv)
     int argc;
     char ** argv;

{
  int i,j,k,n;
  int l,m;
  int start, finish;
  sscanf(argv[1],"%d",&l);	/* low or high */
  sscanf(argv[2],"%d",&m);	/* no links */

  i = l;
  j = m;

  if (i == 0)
    {
      l = 0;
      m = NoUnits/2;
    }
  else
    {
      l = NoUnits/2;
      m = NoUnits;
    }
  fprintf(stderr,"Adding %d links to units %d - %d\n",j,l,m);
  for (k = l; k < m; k++)
    for (n = 0; n < j; n++)
#ifdef TSIM
      MakeDelayLink(random() % (NoUnits-1),k,"excite",(FLINT)1000,(FLINT)k,NULL,
	       1+(random()%254));
#else
      MakeLink(random() % (NoUnits-1),k,"excite",(FLINT)1000,(FLINT)k,NULL);
#endif
}

#ifdef TSIM
test_delay()

{
  int i;

  Echo = FALSE;
  MakeUnit("vertex",UFsum,(FLINT)0,(FLINT)0,(FLINT)0,(FLINT)0,0,0);
  MakeDelayUnit("vertex",UFsum,(FLINT)0,(FLINT)0,(FLINT)0,(FLINT)0,0,0,10);
  AddSite(0,"excite",SFsum, (FLINT) 0);
  AddSite(1,"excite",SFsum, (FLINT) 0);
  AddSite(0,"inhibit",NULL, (FLINT) 0);
  AddSite(1,"inhibit",NULL, (FLINT) 0);
  AddSite(0,"boreme",SFsum, (FLINT) 0);
  AddSite(1,"boreme",SFsum, (FLINT) 0);
  MakeLink(0, 1,"excite",(FLINT)1000,(FLINT)0,NULL);
  MakeDelayLink(1, 0,"excite",(FLINT)1000,(FLINT)0,NULL,20);
  MakeLink(0, 1,"inhibit",(FLINT)1000,(FLINT)0,NULL);
  MakeDelayLink(1, 0,"inhibit",(FLINT)1000,(FLINT)0,NULL,20);
  if (GetDelay(1,0,"excite") != 20)
    goto terr;
  SetDelay(1,0,"excite",30);
  if (GetDelay(1,0,"excite") != 30)
    goto terr;
  DeleteLinks(0,1,FALSE,0,0,1,FALSE,0,"excite");
  DeleteSites(0,0,FALSE,0,"excite");
  MakeDelayLink(1, 0,"boreme",(FLINT)1000,(FLINT)0,NULL,10);
  MakeDelayLink(0, 1,"boreme",(FLINT)1000,(FLINT)0,NULL,20);
  if (GetDelay(1,0,"boreme") != 10)
    goto terr;
  if (GetDelay(0,1,"boreme") != 20)
    goto terr;
  SetOutput(1,(FLINT)10);
  if (GetOutput(1) != 10 || GetOutput(0) != 0)
    goto terr;
  for (i = 0; i < 9; i++)
    {
      Step(1);
      if (GetOutput(1) != 0 || GetOutput(0) != 0)
	goto terr;
    }
  Step(1);
  if (GetOutput(1) != 0 || GetOutput(0) != 10)
    goto terr;
  for (i = 0; i < 19; i++)
    {
      Step(1);
      if (GetOutput(1) != 0 || GetOutput(0) != 0)
	goto terr;
    }
  Step(1);
  if (GetOutput(1) != 10 || GetOutput(0) != 0)
    goto terr;
  DisplayUnit(0);
  DisplayUnit(1);
  printf("\n\nPassed basic test if following links have these delays:\n\n");
  printf("From\tTo\tSite\tDelay\n");
  printf("%d\t%d\t%s\t%d\n",1,0,"boreme",10);
  printf("%d\t%d\t%s\t%d\n",0,1,"boreme",20);
  printf("%d\t%d\t%s\t%d\n",0,1,"inhibit",1);
  printf("%d\t%d\t%s\t%d\n",1,0,"inhibit",20);
  printf("\n\t and if unit 1 but not unit 0 has a site excite with no links\n");
  return;

 terr: printf("Failed basic test\n");
}
#endif

test_loadcode(argc,argv)
     int argc;
     char ** argv;

{
  char * argvx[3];
  int i, j, k;

  argvx[0] = "loadcode";
  argvx[1] = "testload";
  argvx[2] = "all";

  if (argc != 2)
    k = 1;
  else
    sscanf(argv[1],"%d",&k);
  for (j = 0; j < k; j++)
    for (i = 0; i < 100; i++)
      {
	Cmd_loadcode(2,argvx);
	printf("loaded %d times\n",(j*100) + i + 1);
      }
}

