/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/*********************************************************************
 * Graphics Interface
 * ------------------
 * This file contains the routines that access and maintain    
 * the message panel.
 *
 * Kenton Lynne
 ********************************************************************/

#include "macros.h"
#include "externs.h"
#include "panel.h"
#include <X11/Xmu.h>
#include <X11/Form.h>
#include <X11/Label.h>

#undef DEBUG

Widget msg_panel;
extern Widget gi_control_panel;

static Widget msg_item;
static char msg_item_buf[MAX_CMD_LENGTH+1];

/*******************************************************************/
gi_make_msg_panel()
{
/* creates the message panel 
*/

  static Arg p[] = 
    {
      { XtNjustify, (XtArgVal) XtJustifyLeft },
      { XtNlabel, (XtArgVal) msg_item_buf },
      { XtNborderWidth, (XtArgVal) 0 },
      { XtNfont, (XtArgVal) &gi_default_font },
      { XtNleft, (XtArgVal) XtChainLeft },
      { XtNhorizDistance, (XtArgVal) 10 },
    };

  /* define the message panel */
  if ((msg_panel=XtCreateManagedWidget("MSG_PANEL", formWidgetClass, gi_tool,
				       NULL, 0)) == NULL)
  {
    fputs("Can't create message panel\n", stderr);
    exit(1);
  }

  /* add the message item to the panel */
  (void) sprintf(msg_item_buf, "Remember to first build your network!");
  msg_item = XtCreateManagedWidget("msg_item", labelWidgetClass, msg_panel,
				   p, XtNumber(p));
}

/*******************************************************************/
gi_put_error(string)
  char *string;
{
/* displays a message
 * in the message panel prefaced by "ERR:"
 */
  strcpy(msg_item_buf,"ERR: ");
  strncat(msg_item_buf,string, MAX_CMD_LENGTH - 5);
  msg_item_buf[MAX_CMD_LENGTH] = '\0';
  SetValue(msg_item, XtNlabel, (XtArgVal) msg_item_buf);
}

/*******************************************************************/
gi_put_message(string)
  char *string;
{
/* displays a message
 * in the message panel
 */
  strncpy(msg_item_buf,string, MAX_CMD_LENGTH);
  msg_item_buf[MAX_CMD_LENGTH] = '\0';
  SetValue(msg_item, XtNlabel, (XtArgVal) msg_item_buf);
}
