/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

#ifndef _Display_h
#define _Display_h

/****************************************************************
 *
 * Display widget for RCS
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0
 actionCallback      Callback           Callback        NULL
 redrawCallback      Callback           Callback        NULL
 exposeCallback      Callback           Callback        NULL
*/

/* define any special resource names here that are not in <X11/StringDefs.h> */

#define XtNredrawCallback               "redrawCallback"
#define XtNexposeCallback               "exposeCallback"
#define XtNactionCallback               "actionCallback"

/* declare specific DisplayWidget class and instance datatypes */

typedef struct _DisplayClassRec*	DisplayWidgetClass;
typedef struct _DisplayRec*		DisplayWidget;

/* declare the class constant */

extern DisplayWidgetClass displayWidgetClass;

#endif  _Display_h
