/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/*
  This code implements a simple scrollbar widget that attaches to a
  variable known to the simulator and controls its value.  The variable
  is assumed to be a float, but it should be simple to change it to
  an int if required.  The MappingTable field mte.item is a union of
  pointers, so can be used for float or int.  The pointer to a float
  is accessed as mte.item.floatval.  A pointer to an int would be
  accessed as mte.item.intval.
*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Scroll.h>
#include "sim.h"
extern Widget gi_tool;

static void jump_proc(sbar, param, percent)
     Widget sbar;                          /* scrollbar widget */
     caddr_t param;                        /* address of control parameter (float *) */
     caddr_t percent;                      /* percentage from top */
{
  register float * p = (float *) param;    /* address of parameter */
  *p = 1.0 - (* (float *) percent);        /* copy value */
}

MakeControl(argc, argv)
     int argc;
     char ** argv;
{
  Widget shell, scroll;
  NameDesc nte;
  MappingTable mte;
  static Arg scroll_args[] =
    {
      { XtNlength, (XtArgVal) 100},
      { XtNwidth, (XtArgVal) 20 },
    };
  if (FindName(argv[1],&nte))             /* get Name Table entry for variable */
    {
    IndexToItem(nte.index,&mte);          /* get Mapping Table entry for variable*/
    shell = XtCreatePopupShell(argv[1],topLevelShellWidgetClass, gi_tool, NULL, 0);
    scroll = XtCreateManagedWidget("scroll", scrollbarWidgetClass, shell,
                                   scroll_args, XtNumber(scroll_args));
    XtAddCallback(scroll, XtNjumpProc, jump_proc, mte.item.floatval);
    XtPopup(shell, XtGrabNone);           /* popup scrollbar widget, move thumb */
    XtScrollBarSetThumb(scroll, 1.0-*(mte.item.floatval), 0.05);
    }
  else
	LOGfprintf(stderr, "MakeControl: '%s' not found\n", argv[1]);
}
