/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

#include	"sim.h"
#ifdef	FSIM
#	define	BP_ONE	1.0
#	define	BP_ZERO	0.0
#	define	CAST	float
#else
#	define	BP_ONE	1000
#	define	BP_ZERO	0
#	define	CAST	int
#endif
#include "bp.h"

build(argc, argv)
int	argc;
char	*argv[];
{
	register int	i,j;

	srandom(getpid());
	AllocateUnits(40);
	BPmodule(argv[1], 2);
	BPinput(8);
	BPhidden(3, UFh_o, SFbpsigmoid, 1, BP_ONE/2, BP_ZERO, BP_ZERO, BP_ZERO, BP_ZERO, 0, 0);
	BPoutput(8, UFh_o, SFbpsigmoid, SFerror, 1, BP_ONE/2, BP_ZERO, BP_ZERO, BP_ZERO, BP_ZERO, 0, 0);
	BPteach();
	BPfire();
	for(i = 0; i < 8; i++)
		for(j = 0; j < 3; j++)
		{	BPlink(0, i, 1, j, (random()%700)*(BP_ONE/1000)+(BP_ONE/10));
			BPlink(1, j, 2, i, (random()%700)*(BP_ONE/1000)+(BP_ONE/10));
		}
	BPendmod(argv[1]);
}

cycle(argc, argv)
int	argc;
char	*argv[];
{
	register int	i,j,k;
	NameDesc	nd;

	if(argc != 3)
	{	fprintf(stderr, "Wrong # args\n");
		return;
	}
	FindName(argv[1], &nd);
	j = atoi(argv[2]);
	for(k = 0; k < j; k++)
	  {
		for(i = 0; i < 8; i++)
		{	BPsetinput(argv[1], i, BP_ONE);
			BPsetteach(argv[1], i, BP_ONE);
			BPcycle(argv[1], 1);
			gi_do_steps(nd.index*2,nd.index*2);
			BPsetinput(argv[1], i, BP_ZERO);
			BPsetteach(argv[1], i, BP_ZERO);
		}
		fprintf(stdout, "Completed %d cycles of each pattern\n", k+1);
          }
}

testgi(argc, argv)
int	argc;
char	*argv[];
{
	register int	i, j;
	NameDesc	nd;

	i = atoi(argv[2]) - 2;
	FindName(argv[1], &nd);
	for (j = 0; j < 8; j++)
	  BPsetinput(argv[1], j, BP_ZERO);
	BPsetinput(argv[1], i, BP_ONE);
	BPsetteach(argv[1], i, BP_ONE);
	SetOutput(nd.length, (CAST)4);
	gi_do_steps(4,4);
	BPsetteach(argv[1], i, BP_ZERO);
}

test(argc, argv)
int	argc;
char	*argv[];
{
	register int	i, j;
	NameDesc	nd;

	i = atoi(argv[2]);
	FindName(argv[1], &nd);
	for (j = 0; j < 8; j++)
	  BPsetinput(argv[1], j, BP_ZERO);
	BPsetinput(argv[1], i, BP_ONE);
	BPsetteach(argv[1], i, BP_ONE);
	SetOutput(nd.length, (CAST)4);
	Step(4);
	BPsetteach(argv[1], i, BP_ZERO);
}



