static char rcsid[] = "$Header: execution.c,v 1.2 87/10/21 17:39:09 goddard Exp $";
/*----------------------------------------------------------------------------

  The Rochester Connectionist Simulator.  Copyright Univesity of Rochester.
  Author: Nigel Goddard
  Date: May 1 1987

----------------------------------------------------------------------------*/

#pragma segment SEGM2

#ifdef BSIM
#  include "bflysim.h"
#else
#  include "Stupido:rochester:include:uniproc.h"
#endif

#include <stdlib.h>

/***** Step *****/
/*---------------------------------------------------------------------------
  Makes the network go.Simulates  count  steps.  Echoes and shows will
  be done if appropriate.

  Execution styles:      synchronous - every unit updated each time step,
                                       outputs updated after all done.
                        
                         asynchronous- every unit updated each time step,
                                       immediate output update, random order

                         fair async  - fixed fraction updated each time step,
                                       chosen at random from all units,
                                       outputs updated immediately,
                                       guaranteed all done at least once
                                       after limit number of steps.

----------------------------------------------------------------------------*/
#ifdef TSIM

#define PUSHBUFFER(top,new) \
  { \
    for (ip = (Link *) ((top) + 1), sp  = (Site *) (top + (tempint = *(top))); \
         ip < (Link *) sp; \
         *((Output *) sp) = *(((Output *) sp) -1), sp = (Site *)(((Output *) sp)-1)); \
    *((Output *) ip) = (new); \
  }

/* above macro equivalent to this function...
static PushBuffer(op,new)
     Output * op, new;

{
  register Output * top;
  register Output * sop;
  register int temp;

  for (top = op + 1, sop = op + (temp = *op);
       top < sop;       
       *sop = *(sop-1), sop--);
  *top = new;
}
*/
#endif


#ifndef LINDA

Step(no_steps)
    int no_steps;
{
    register Link * ip;
    register Site * sp;
    register Unit * up;
    register int which;
    register int ucount;
    int step_count,most,first,done,tempint;
    Outvec * op;
    Output * top;

    /* do step_count simulation steps;
       repeated code is to save milliseconds; oh well */

BFLYCATCH
#ifdef BFLY
  TimeStart = rtc;
#endif  
    switch (SyncFlag)
      {
      case SYNC:                                  /* synchronous simulation */
        for (step_count = 0; step_count < no_steps; step_count++)
          {
            Clock += 1;
            for ( ucount = 0; ucount < NoUnits; ucount++)
              {
                if(!TestFlagF((which = (up = UnitList+ucount)->flags),
                              NO_UNIT_FUNC_FLAG))
                  {
                    if(!TestFlagF(which,NO_SITE_FUNC_FLAG))
                      for(sp = up->sites;sp != NULL;sp = sp->next)
                        {
                          sp->site_f(up,sp);
                          if(!TestFlagF(which,NO_LINK_FUNC_FLAG))
                            for(ip = sp->inputs; ip != NULL; ip = ip->next)
                              ip->link_f(up,sp,ip);
                        }
                    up->unit_f(up);
                  }
              }
#ifndef BFLY
            for (which = 0,up = UnitList,op = Outputs;
                 which < ucount;                  /* ucount is NoUnits */
                 which++,up++,op++)
#ifndef TSIM
                *op = up->output;                 /* update outputs */
#else
                PUSHBUFFER(*op,up->output);
#endif

            if(Echo && ((step_count + 1) % EchoStep) == 0) 
              printf("finished %d out of %d steps\n",step_count + 1,no_steps);
            
            if(Show && ((step_count + 1) % ShowStep) == 0)
              {
                ShowUnits();
                printf("\n");
                if(Pause && step_count + 1 != no_steps)
                  if (UserWait("PAUSE (<any key> - continue; q - quit)") == 'q')
                    break;
              }
#endif
          }
        break;

      case ASYNC:                                 /* asynchronous simulation */
        for (step_count = 0; step_count < no_steps; step_count++)
          {
            Clock += 1;
            /* do 90% randomly */
            most = (int) (0.8 * NoUnits);
            for(done = 0; done < most;done++)
              {
                which = NoUnits;                  /* get in register */
                while (TestFlagP((up = UnitList+(ucount = rand()%which)),
                                 STEP_SIM_FLAG)); /* get unit pointer in reg*/
                if(!TestFlagF((which = up->flags),NO_UNIT_FUNC_FLAG))
                  {                               /* get unit flags in reg */
                    if(!TestFlagF(which,NO_SITE_FUNC_FLAG))
                      for(sp = up->sites;sp != NULL;sp = sp->next)
                        {
                          sp->site_f(up,sp);
                          if(!TestFlagF(which,NO_LINK_FUNC_FLAG))
                            for(ip = sp->inputs; ip != NULL; ip = ip->next)
                              ip->link_f(up,sp,ip);
                        }
                    up->unit_f(up);
#ifndef TSIM
                    Outputs[ucount] = up->output;
#else
                    PUSHBUFFER(Outputs[ucount],up->output);
#endif
                  }
                SetFlagP(up,STEP_SIM_FLAG);
              }
            /* add a search to last 10% to lower search time */
            most = NoUnits - most;
            for(done = 0;done < most;done++)
              {
                which = NoUnits;                  /* get in register */
                for(up = UnitList+(ucount = rand()%which);
                    TestFlagP(up,STEP_SIM_FLAG);
                    up = UnitList+(ucount = ++ucount%which));
                if(!TestFlagF((which = up->flags),NO_UNIT_FUNC_FLAG))
                  {
                    if(!TestFlagF(which,NO_SITE_FUNC_FLAG))
                      for(sp = up->sites;sp != NULL;sp = sp->next)
                        {
                          sp->site_f(up,sp);
                          if(!TestFlagF(which,NO_LINK_FUNC_FLAG))
                            for(ip = sp->inputs; ip != NULL; ip = ip->next)
                              ip->link_f(up,sp,ip);
                        }
                    up->unit_f(up);
#ifndef TSIM
                    Outputs[ucount] = up->output;
#else
                    PUSHBUFFER(Outputs[ucount],up->output);
#endif
                  }
                SetFlagP(up,STEP_SIM_FLAG);
              }

            for ( which = 0, up = UnitList, ucount = NoUnits;
                 which < ucount;
                 which++,up++)
              UnsetFlagP(up,STEP_SIM_FLAG);       /*  unset for next step */
#ifndef BFLY
            if(Echo && ((step_count + 1) % EchoStep) == 0) 
              printf("finished %d out of %d steps\n",step_count + 1,no_steps);
            
            if(Show && ((step_count + 1) % ShowStep) == 0)
              {
                ShowUnits();
                printf("\n");
                if(Pause && step_count + 1 != no_steps)
                  if (UserWait("PAUSE (<any key> - continue; q - quit)") == 'q')
                    break;
              }
#endif
          }
        break;
        
      case FAIRASYNC:                     /* fair asynchronous */
        for (step_count = 0; step_count < no_steps; step_count++)
          {
            Clock += 1;
            done = 0;
            if (!(Clock % ExecLimit))             /* make sure all done */
              for (ucount = 0,up = UnitList; ucount < NoUnits; ucount++, up++)
                if (!TestFlagF((which = up->flags),LIMIT_SIM_FLAG))
                  {                               /* not done, so do now */
                    done++;
                    if(!TestFlagF(which,NO_UNIT_FUNC_FLAG))
                      {
                        if(!TestFlagF(which,NO_SITE_FUNC_FLAG))
                          for(sp = up->sites;sp != NULL;sp = sp->next)
                            {
                              sp->site_f(up,sp);
                              if(!TestFlagF(which,NO_LINK_FUNC_FLAG))
                                for(ip = sp->inputs; ip != NULL; ip = ip->next)
                                  ip->link_f(up,sp,ip);
                            }
                        up->unit_f(up);
                      }
                    SetFlagP(up,STEP_SIM_FLAG);   /* done this step */
                  }
                else
                  UnsetFlagP(up,LIMIT_SIM_FLAG); /* unset for next cycle*/

            most = (NoUnits * ExecFract)/100;     /* total to be done */
            for(; done < most;done++)
              {
                which = NoUnits;                  /* get in register */
                while (TestFlagP((up = UnitList+(ucount =
                                                 (rand()%which))),
                                 STEP_SIM_FLAG)); /* get unit pointer in reg*/
                if(!TestFlagF((which = up->flags),NO_UNIT_FUNC_FLAG))
                  {                               /* get unit flags in reg */
                    if(!TestFlagF(which,NO_SITE_FUNC_FLAG))
                      for(sp = up->sites;sp != NULL;sp = sp->next)
                        {
                          sp->site_f(up,sp);
                          if(!TestFlagF(which,NO_LINK_FUNC_FLAG))
                            for(ip = sp->inputs; ip != NULL; ip = ip->next)
                              ip->link_f(up,sp,ip);
                        }
                    up->unit_f(up);
#ifndef TSIM
                    Outputs[ucount] = up->output;
#else
                    PUSHBUFFER(Outputs[ucount],up->output);
#endif
                  }
                SetFlagP(up,STEP_SIM_FLAG);
                SetFlagP(up,LIMIT_SIM_FLAG);
              }
            
            for (which = 0,up = UnitList, ucount = NoUnits;
                 which < ucount;
                 which++,up++)
              UnsetFlagP(up,STEP_SIM_FLAG);
#ifndef BFLY
            if (Echo || Show)
              {
                if(Echo && ((step_count + 1) % EchoStep) == 0) 
                  printf("finished %d out of %d steps\n",step_count + 1,no_steps);
                
                if(Show && ((step_count + 1) % ShowStep) == 0)
                  {
                    ShowUnits();
                    printf("\n");
                    if(Pause && step_count + 1 != no_steps)
                      if (UserWait("PAUSE (<any key> - continue; q - quit)") == 'q')
                        break;
                  }
              }
#endif
          }
        break;

      default:
        fprintf(stderr,
                "Internal error: execution mode not SYNC, ASYNC or FSYNC\n");
      } /*switch*/
#ifdef BFLY
  TimeFinish = rtc;
#endif  

BFLYTHROW("Step",MySimNumber)
} /* Step */

#endif

/***** SetPotential *****/
/*
   Sets unit "index" to have potential "value".
*/
SetPotential(index,value)
     int index;
     FLINT value;
{
BFLYCATCH
    if(LegalUnit(index))
        UnitList[index].potential = value;
    else
        fprintf(stderr,"SetPotential: illegal unit %d\n",index);
BFLYTHROW("SetPotential",MySimNumber)
}

FLINT GetPotential(index)
     int index;

/* Returns potential of unit "index" */

{
BFLYCATCH
    if(LegalUnit(index))
      return UnitList[index].potential;
    else
      fprintf(stderr,"GetPotential: illegal unit %d\n",index);
BFLYTHROW("GetPotential",MySimNumber)
}

/***** SetOutput *****/
/*
   Sets unit "index" to have output "value".
*/
SetOutput(index,value)
     int index;
     FLINT value;
{
BFLYCATCH
    if(LegalUnit(index))
#ifndef TSIM
      Outputs[index]= UnitList[index].output = value;
#else
      *(Outputs[index]+1) = UnitList[index].output = value;
#endif
    else
        fprintf(stderr,"SetOutput: illegal unit %d\n",index);
BFLYTHROW("SetOutput",MySimNumber)
}

FLINT GetOutput(index)
    int index;

/* Returns output of unit "index" */

{
BFLYCATCH
    if(LegalUnit(index))
        return UnitList[index].output;
    else fprintf(stderr,"GetOutput: illegal unit %d\n",index);
BFLYTHROW("GetOutput",MySimNumber)
}

/***** SetState *****/
/*
   Sets unit "index" to have state "value".
*/
SetState(index,value)
    int index,value;
{
BFLYCATCH
    if(LegalUnit(index))
        UnitList[index].state = value;
    else
        fprintf(stderr,"SetState: illegal unit %d\n",index);
BFLYTHROW("SetState",MySimNumber)

}

/*---------------------------------------------------------------------------
  This function sets all the network weights to values in the range 
  mean-pert  to  mean+pert .  The values are evenly distributed
  throughout this range.
----------------------------------------------------------------------------*/

RandomiseWeights(mean,pert)
     FLINT mean;
     int pert;

{
  int i;
  Link * lp;
  Site * sp;
  register FLINT minval;
  int range;

  minval = mean - pert;
#ifdef FSIM
  range = 2*pert/100;
#else
  range = 2*pert;
#endif
  for (i = 0; i < NoUnits; i++)
    for (sp = UnitList[i].sites; sp != NULL; sp = sp->next)
      for (lp = sp->inputs; lp != NULL; lp = lp->next)
#ifdef FSIM
        lp->weight = minval + ((rand() % 100)*range);
#else
        lp->weight = minval + (rand() % range);
#endif
}

/*---------------------------------------------------------------------------
This function sets the weights on one or more links.  The first four
parameters specify the units from which the links originate.  The
second four parameters specify the destination units.   sitename
 is the name of the site at which the links arrive, or optionally
ALL, meaning any site on a destination unit.  The last three
values specify the weight.  If  randomval  is FALSE, the weight
is simply  val .  If  randomval  is TRUE, then the weights
are randomly distributed in the range  val-pert  to  val+pert
.

The source and destination units are in the range  ul(ow)  to
 uh(igh) .  If  uset  is FALSE, all the units in these two
ranges are considered.  If  us(et)  is TRUE, then only those units
in the range that are in the set whose number is  usind  (for
source units) or  usetind  (for destination units) are
considered. 
----------------------------------------------------------------------------*/

SetWeight(ul,uh,us,usind,ulow,uhigh,uset,usetind,sitename,randomval,val,pert)
     int ul,uh,us,usind,ulow,uhigh,uset,usetind,randomval;
     FLINT val,pert;
     char * sitename;

{
  int ut,uf;
  Link * lp;
  Site * sp;
  register FLINT minval;
  register FLINT range;
  
  minval = val - pert;
#ifdef FSIM
  range = 2*pert/100;
#else
  range = 2*pert;
#endif
  if (strcmp(sitename,"all") && strcmp(sitename,"ALL"))
    for (ut = ulow; ut <= uhigh; ut++)
      {
        if (!uset || (UnitList[ut].sets >> usetind) & 1)
          {
            for (sp = UnitList[ut].sites;
                 sp != NULL && strcmp(sp->name,sitename);
                 sp = sp->next);
            if (sp != NULL)
              for (lp = sp->inputs; lp != NULL; lp = lp->next)
                if (lp->from_unit >= ul && lp->from_unit <= uh &&
                    (!us || (UnitList[lp->from_unit].sets >> usind) & 1))
                  if (randomval)
#ifdef FSIM
                    lp->weight = minval + ((rand() % 100)*range);
#else
                    lp->weight = minval + (rand() % range);
#endif

                  else
                    lp->weight = val;
          }
      }
  else
    for (ut = ulow; ut <= uhigh; ut++)
      if (!uset || (UnitList[ut].sets >> usetind) & 1)
        for (sp = UnitList[ut].sites; sp != NULL; sp = sp->next)
          for (lp = sp->inputs; lp != NULL; lp = lp->next)
            if (lp->from_unit >= ul && lp->from_unit <= uh &&
                    (!us || (UnitList[lp->from_unit].sets >> usind) & 1))
              if (randomval)
#ifdef FSIM
                lp->weight = minval + ((rand() % 100)*range);
#else
                lp->weight = minval + (rand() % range);
#endif
              else
                lp->weight = val;
}

int GetState(index)
    int index;

/* Returns state of unit "index" */

{
BFLYCATCH
    if(LegalUnit(index))
        return UnitList[index].state;
    else
        fprintf(stderr,"GetState: illegal unit %d\n",index);
BFLYTHROW("GetState",MySimNumber)
}

/***** SetData *****/
/*
   Sets unit "index" to have data "value".
*/
SetData(index,value)
    int index,value;
{
BFLYCATCH
    if(LegalUnit(index))
        UnitList[index].data = value;
    else
        fprintf(stderr,"SetData: illegal unit %d\n",index);
BFLYTHROW("SetData",MySimNumber)
}

FLINT GetData(index)
    int index;

/* Returns data of unit "index" */

{
BFLYCATCH
    if(LegalUnit(index))
        return UnitList[index].data;
    else
        fprintf(stderr,"GetData: illegal unit %d\n",index);
BFLYTHROW("GetData",MySimNumber)
}

/***** Reset *****/
/*
   Set system Clock back to 0.
   Set potential and state to initial values.
   Set site values to 0.
   Set output to 0.
*/
 
Reset()
{
  register Unit * up;
  register int ucount;
  register Output * op;
  register int cnt;
 
BFLYCATCH
    Clock = 0;
    for (up = UnitList+NoUnits-1, ucount = NoUnits;
         ucount > 0;
         ucount--, up-- )
      {
        if (TestFlagP(up,NO_UNIT_FUNC_FLAG))
          continue;
        up -> potential = up -> init_potential;
        up -> state = up -> init_state;
        up -> output = 0;
#ifndef TSIM
        Outputs[ucount-1] = 0;
#else
        for (op = Outputs[ucount-1]+1, cnt = *(op-1);
             cnt > 0;
             *op = 0, op++, cnt--);
#endif
      }    
BFLYTHROW("Reset",MySimNumber)
} /* Reset */

Sync()                          /* put simulator in synchronous mode */
{
    SyncFlag = 1;
}

Async(seed)                     /* put simulator in asynchronous mode */
    int seed;
{
BFLYCATCH
    SyncFlag = 0;
    if (seed)
      srandom(seed);
    else
#ifdef BFLY
      srandom(rtc);
#else
      srandom(time(0));
#endif
BFLYTHROW("Async",MySimNumber)
}

#ifdef BFLY
Update()

{
    register Unit * up;
    register int which;
    register int ucount;
    register Output * op;

    for ( which = 0,up = UnitList,op = Outputs;
         which < ucount;                  /* ucount is NoUnits */
         which++,up++,op++)
      *op = up->output;                   /* update outputs */
}
#endif
