static char rcsid[] = "$Header: display.c,v 1.2 87/10/21 17:39:05 goddard Exp $";
/*----------------------------------------------------------------------------

  The Rochester Connectionist Simulator.  Copyright Univesity of Rochester.
  Author: Nigel Goddard
  Date: May 1 1987

----------------------------------------------------------------------------*/

#pragma segment SEGM2

#ifdef BSIM
#  include "bflysim.h"
#else
#  include <time.h>
#  include <stdio.h>
#  include <ioctl.h>
#  include <ctype.h>
#  include "Stupido:rochester:include:uniproc.h"
#endif

#ifdef BFLY
#  define UNIT_INDEX(i) \
     ABSOLUTE_IND(i)
#  define abs(i) \
     ((i > 0) ? i : 0-i)
#else
#  define UNIT_INDEX(i) \
     i
#endif

/*---------------------------------------------------------------------------
  following #define's are for position formatting for listing and
  displaying.  L_ is for a list, S_ for a show.  Numbers indicate minimum
  position from the left that the item should be placed.
----------------------------------------------------------------------------*/

#define LINE_LENGTH 80
#define L_INDEX 1
#define L_NAME 10
#define L_TYPE 30
#define L_POT 40
#define L_OUT 52
#define L_STATE 64
#define L_NL_POS 54

#define S_INDEX 0
#define S_UNAME 2
#define S_UTYPE 20
#define S_UFUNC 30
#define S_POT 2
#define S_OUT 2
#define S_STATE 2
#define S_UDATA 2
#define S_UNL_POS 4
#define S_SET 2
#define S_SETNL_POS 4
#define S_SNAME 2
#define S_SFUNC 2
#define S_SVAL 2
#define S_SDATA 2
#define S_SNL_POS 4
#define S_LNAME 4
#define S_LFUNC 4
#define S_WEIGHT 4
#define S_LVAL 4
#define S_LDATA 4
#define S_LNL_POS 6


#define INITBUFF line_buff[0] = '\0'

static char line_buff[2*LINE_LENGTH];

/*---------------------------------------------------------------------------
  Adds an item to the output line, and LOGfprintf's it if it completes
  the line.  fp is the file to write to.  tag is the tag associated with
  the value, e.g. "value: ".  val is the value to be printed, as a character
  string.  pos is the minimum position from the left the item should be.  If
  the item is too long, the line is ended and the item started on a new line.
  If the item is too long to fit on the line, given pos, pos is ignored.
----------------------------------------------------------------------------*/

si_additem(fp,tag,val,pos,nlpos)
     FILE * fp;
     char * tag, *val;
     int pos,nlpos;

{
  register short i;
  register short tv;
  register short l;

  tv = strlen(tag)+strlen(val); /* item length */
  if (strlen(line_buff) + tv > LINE_LENGTH - 1) /* line full already ? */
    {
      LOGfprintf(Dispf,"%s\n",line_buff);
      for (i = 0; i < nlpos; i++)
        line_buff[i] = ' ';
      line_buff[nlpos] = '\0';
      pos = nlpos;
    }
  else
    if (pos + tv > LINE_LENGTH - 1) /* item too long given pos ? */
      {
        LOGfprintf(Dispf,"%s",line_buff);
        for (i = 0; i < nlpos; i++)
          line_buff[i] = ' ';
        line_buff[nlpos] = '\0';
        pos = nlpos;
      }
  if (pos + tv > LINE_LENGTH - 1 && pos > 0) /* readjust pos if too right */
    pos = LINE_LENGTH - 1 - tv;
  if (strlen(line_buff) < pos-1) /* pad the line to the position */
    {
      for (i = strlen(line_buff); i < pos; i++)
        line_buff[i] = ' ';
      line_buff[pos] = '\0';
    }
  else
    if (strlen(line_buff) != 0)
      strcat(line_buff,"  ");   /* at least pad two spaces */
  strcat(line_buff,tag);
  strcat(line_buff,val);
}

si_termitem(fp)                 /* called after last item to flush */
     FILE * fp;

{
  LOGfprintf(Dispf,"%s\n",line_buff);
  INITBUFF;
}

/***** ListUnits *****/
/*---------------------------------------------------------------------------
  Used for listing units.  If  all  is nonzero (TRUE), it writes a
  one line description of all units to the display output file  Dispf.
  If all is zero (FALSE) it writes the description only for units
  with the list flag set.  Each line contains the unit index, name (**NO
  NAME** if not named), type, potential, output and state.
----------------------------------------------------------------------------*/

ListUnits(all)
    int all;
{

BFLYCATCH
    PipeBegin();
    LOGfprintf(Dispf,"\nClock = %d\n",Clock);
    INITBUFF;
    si_additem(Dispf,"Index","",L_INDEX,L_NL_POS);
    si_additem(Dispf,"Name","",L_NAME,L_NL_POS);
    si_additem(Dispf,"Type","",L_TYPE,L_NL_POS);
    si_additem(Dispf,"Potential","",L_POT,L_NL_POS);
    si_additem(Dispf,"Output","",L_OUT,L_NL_POS);
    si_additem(Dispf,"State","",L_STATE,L_NL_POS);
    LOGfprintf(Dispf,"%s\n\n",line_buff);
    INITBUFF;
    si_LU(all);
}

si_LU(all)
     int all;

{
    int ucount;
    Unit * up;
    char  tbuff[LINE_LENGTH];								/* changed for Mac version */

    for(ucount = 0;ucount < NoUnits;ucount++)
      {
        up = & UnitList[ucount];
        if(all || TestFlag(ucount,LIST_FLAG))
          {
		  	sprintf(tbuff,"%d",UNIT_INDEX(ucount));			/* changed for Mac version */
            si_additem(Dispf,"",tbuff,L_INDEX,L_NL_POS);
			sprintf(tbuff,"%s",IndToName(UNIT_INDEX(ucount)));
            si_additem(Dispf,"",tbuff,L_NAME,L_NL_POS);
			sprintf(tbuff,"%s",up->type);
            si_additem(Dispf,"",tbuff,L_TYPE,L_NL_POS);
			sprintf(tbuff,POT_S_TYPE,up->potential);
            si_additem(Dispf,"",tbuff,L_POT,L_NL_POS);
			sprintf(tbuff,OUT_S_TYPE,up->output);
            si_additem(Dispf,"",tbuff,L_OUT,L_NL_POS);
			sprintf(tbuff,"%s",StateToName(up->state));
            si_additem(Dispf,"",tbuff,L_STATE,L_NL_POS);
            LOGfprintf(Dispf,"%s\n",line_buff);
            INITBUFF;
          }
      }
    PipeEnd();
BFLYTHROW("ListUnits",MySimNumber)
} /* ListUnits */

/***** ShowUnits *****/
/*---------------------------------------------------------------------------
   Does a show.  If a unit has its show flag set, or it has potential
   greater than the show potential or it is a member of a show set, then
   the unit is displayed.
----------------------------------------------------------------------------*/

ShowUnits()

{

BFLYCATCH
    PipeBegin();
    INITBUFF;
    si_additem(Dispf,"Index","",L_INDEX,L_NL_POS);
    si_additem(Dispf,"Name","",L_NAME,L_NL_POS);
    si_additem(Dispf,"Type","",L_TYPE,L_NL_POS);
    si_additem(Dispf,"Potential","",L_POT,L_NL_POS);
    si_additem(Dispf,"Output","",L_OUT,L_NL_POS);
    si_additem(Dispf,"State","",L_STATE,L_NL_POS);
    LOGfprintf(Dispf,"%s\n\n",line_buff);
    INITBUFF;
    si_SU();
}

si_SU()

{
    int ucount;
    Unit * up;
    char tbuff[LINE_LENGTH];

    for(ucount = 0;ucount < NoUnits;ucount++)
      {
        up = & UnitList[ucount];
        if(TestFlag(ucount,SHOW_FLAG) || abs(up->potential) >= ShowPot
            || up->sets & ShowSets)
          {
		  	sprintf(tbuff,"%d",UNIT_INDEX(ucount));
            si_additem(Dispf,"",tbuff, L_INDEX,L_NL_POS);
			sprintf(tbuff,"%s",IndToName(UNIT_INDEX(ucount)));
            si_additem(Dispf,"",tbuff, L_NAME,L_NL_POS);
			sprintf(tbuff,"%s",up->type);
            si_additem(Dispf,"",tbuff, L_TYPE,L_NL_POS);
			sprintf(tbuff,POT_S_TYPE,up->potential);
            si_additem(Dispf,"",tbuff, L_POT,L_NL_POS);
			sprintf(tbuff,OUT_S_TYPE,up->output);
            si_additem(Dispf,"",tbuff, L_OUT,L_NL_POS);
			sprintf(tbuff,"%s",StateToName(up->state));
            si_additem(Dispf,"",tbuff, L_STATE,L_NL_POS);
            LOGfprintf(Dispf,"%s\n",line_buff);
            INITBUFF;
          }
      }
    PipeEnd();
BFLYTHROW("ShowUnits",MySimNumber)
} /* ListUnits */


/***** DisplayUnit *****/
/*---------------------------------------------------------------------------
  Writes a complete description of the unit with index  u  to the
  display output file  Dispf , including descriptions of all the
  links to that unit.   DisplayUnitP  avoids having to index into
  the unit array by having the unit pointer passed in as a parameter.
----------------------------------------------------------------------------*/


DisplayUnit(u)
     int u;
{
    int i;
    Link * ip;
    Site * sp;
    Unit * up;
    int (* func)();

BFLYCATCH
    if (!LegalUnit(u))
      {
        LOGfprintf(Dispf, "No unit with index %d defined\n",UNIT_INDEX(u));
        return;
      }
    up = &UnitList[u];
    DisplayUnitP(u,up);
BFLYTHROW("DisplayUnit",MySimNumber)
}

DisplayUnitP(u,uptr)
     int u;
     Unit * uptr;
{
    int i;
    Link * ip;
    Site * sp;
    Unit * up;
    func_ptr func;
    char tbuff[LINE_LENGTH];

BFLYCATCH
    up = uptr;
    INITBUFF;
	sprintf(tbuff,"%d",UNIT_INDEX(u));
    si_additem(Dispf,"\nUnit:",tbuff, S_INDEX,S_UNL_POS);
    si_additem(Dispf,"Name:",IndToName(UNIT_INDEX(u)),S_UNAME,S_UNL_POS);
    si_additem(Dispf,"Type:",up->type,S_UTYPE,S_UNL_POS);
	sprintf(tbuff,"%s",FuncToName(up->unit_f));
    si_additem(Dispf,"function:",tbuff, S_UFUNC,S_UNL_POS);
    LOGfprintf(Dispf,"%s\n",line_buff);
    INITBUFF;
	sprintf(tbuff,POT_S_TYPE,up->potential);
    si_additem(Dispf,"potential:",tbuff, S_POT,S_UNL_POS);
	sprintf(tbuff,OUT_S_TYPE,up->output);
    si_additem(Dispf,"output:",tbuff, S_OUT,S_UNL_POS);
	sprintf(tbuff,"%s",StateToName(up->state));
    si_additem(Dispf,"state:",tbuff, S_STATE,S_UNL_POS);
    if (si_User_Unit_Display == NULL)             /* User function pointer */
      {
	  	sprintf(tbuff,DATA_S_TYPE,up->data);
        si_additem(Dispf,"data:",tbuff, S_UDATA,S_UNL_POS);
        LOGfprintf(Dispf,"%s\n",line_buff);
        INITBUFF;
      }
    else
      {
        LOGfprintf(Dispf,"%s\n",line_buff);
        INITBUFF;
        si_User_Unit_Display(Dispf,up);           /* Call user function */
      }
#ifndef BFLY
    si_additem(Dispf,"Set memberships: ","",S_SET,S_SETNL_POS);
    for(i = 0;i < LastSet;i++)
      if(SetNames[i] != NULL && MemberSet(SetNames[i],u))  {
	  	sprintf(tbuff,"%s",SetNames[i]);
        si_additem(Dispf,"",tbuff, S_SET,S_SETNL_POS);
	  }
    LOGfprintf(Dispf,"%s\n",line_buff);
    INITBUFF;
#endif
    for(sp = up -> sites;sp != NULL;sp = sp->next)
      {
        si_additem(Dispf,"sitename:",sp->name,S_SNAME,S_SNL_POS);
        si_additem(Dispf,"function:",FuncToName(sp->site_f),S_SFUNC,S_SNL_POS);
		sprintf(tbuff,OUT_S_TYPE,sp->value);
        si_additem(Dispf,"value:",tbuff, S_SVAL,S_SNL_POS);
        if (si_User_Site_Display == NULL) /* User function pointer */
          {
		  	sprintf(tbuff,DATA_S_TYPE,sp->data);
            si_additem(Dispf,"data:",tbuff, S_SDATA,S_SNL_POS);
            LOGfprintf(Dispf,"%s\n",line_buff);
            INITBUFF;
          }
        else
          {
            LOGfprintf(Dispf,"%s\n",line_buff);
            INITBUFF;
            si_User_Site_Display(Dispf,up,sp); /* Call user function */
          }
        for(ip = sp -> inputs;ip != NULL;ip = ip->next)
          {
#ifndef TSIM
			sprintf(tbuff,"%s (%d)",IndToName(ip->from_unit),ip->from_unit);
            si_additem(Dispf,"link:", tbuff, S_LNAME,S_LNL_POS);
#else
			sprintf(tbuff,"%s (%d) delay: %d",IndToName(ip->from_unit),
                     ip->from_unit,ip->value - Outputs[ip->from_unit]);
            si_additem(Dispf,"link:", tbuff, S_LNAME,S_LNL_POS);
#endif
            si_additem(Dispf,"func:",FuncToName(ip->link_f), S_LFUNC,S_LNL_POS);
			sprintf(tbuff,WEIGHT_S_TYPE,ip->weight);
            si_additem(Dispf,"weight:",tbuff , S_SVAL,S_LNL_POS);
			sprintf(tbuff,OUT_S_TYPE,*(ip->value));
            si_additem(Dispf,"value:", tbuff, S_LVAL,S_LNL_POS);
            if (si_User_Link_Display == NULL) /* User function pointer */
              {
			  	sprintf(tbuff,DATA_S_TYPE,ip->data);
                si_additem(Dispf,"data:",tbuff, S_LDATA,S_LNL_POS);
                LOGfprintf(Dispf,"%s\n",line_buff);
                INITBUFF;
              }
            else
              {
                LOGfprintf(Dispf,"%s\n",line_buff);
                INITBUFF;
                si_User_Link_Display(Dispf,up,sp,ip); /* Call user function */
              }
          }
      }
BFLYTHROW("DisplayUnitP",MySimNumber)
} /* DisplayUnitP */




/***** ListLinks *****/
/*---------------------------------------------------------------------------
  Writes a one-line description of each link to the display output file
   Dispf  with a header.  The line consists of the four values:
  source index, destination index, weight, and data.
----------------------------------------------------------------------------*/

ListLinks()
{
    int ucount;
    Link * ip;
    Site * sp;
    Unit * up;

BFLYCATCH
    PipeBegin();
#ifndef TSIM
    LOGfprintf(Dispf,"Source\t\tDestination\tWeight\t\tData\n");
#else
    LOGfprintf(Dispf,"Source\t\tDestination\tDelay\tWeight\tData\n");
#endif
    if (si_User_Link_List == NULL)                        /* data field an integer */
      for ( ucount = 0; ucount < NoUnits; ucount++)
        {
          up = &UnitList[ucount];
          for(sp = up->sites;sp != NULL;sp = sp->next)
            for(ip = sp->inputs;ip != NULL;ip = ip->next)
              {
                LOGfprintf(Dispf," %d\t\t     %d\t\t  ",
                           ip->from_unit,UNIT_INDEX(ucount));
#ifdef TSIM
                LOGfprintf(Dispf,"%d\t  ",
                           ip->value - Outputs[ip->from_unit]);
#endif
                LOGfprintf(Dispf,WEIGHT_S_TYPE,ip->weight);
                LOGfprintf(Dispf,"\t  ");
                LOGfprintf(Dispf,DATA_S_TYPE,ip->data);
                LOGfprintf(Dispf,"\n");
              }
        }
    else                                          /* data field a user type */
      for ( ucount = 0; ucount < NoUnits; ucount++)
        {
          up = & UnitList[ucount];
          for(sp = up->sites;sp != NULL;sp = sp->next)
            for(ip = sp->inputs;ip != NULL;ip = ip->next)
              {
                LOGfprintf(Dispf," %d\t\t     %d\t\t",
                           ip->from_unit,UNIT_INDEX(ucount));
#ifdef TSIM
                LOGfprintf(Dispf,"%d\t ",
                           ip->value - Outputs[ip->from_unit]);
#endif
                LOGfprintf(Dispf,WEIGHT_S_TYPE,ip->weight);
                LOGfprintf(Dispf,"\t\t");
                si_User_Link_List(Dispf,up,sp,ip);
              }
        }
    PipeEnd();
BFLYTHROW("ListLinks",MySimNumber)
} /* ListLinks */
