static char rcsid[] = "$Header: chkpoint.c,v 1.2 87/10/21 17:38:55 goddard Exp $";

/*----------------------------------------------------------------------------

  The Rochester Connectionist Simulator.  Copyright Univesity of Rochester.
  Author: Nigel Goddard
  Date: May 1 1987

----------------------------------------------------------------------------*/

#include <stdio.h>
#include <ctype.h>
#ifdef BFLY
# include "bflysim.h"
#else
# include "Stupido:rochester:include:uniproc.h"
#endif

static char  buffer[80];
static char **strings;

/*---------------------------------------------------------------------------
  The function complimentary to  NetCheckpoint .  Reads in and
  checks the time stamp in the file  nfp  with  CheckStamp ,
  and then restores the  state  of the network using Restore State
---------------------------------------------------------------------------*/

RestoreNetwork(nfp) 
    FILE *nfp;
  
{
  int version, c;

/*---------------------------check time stamp on file---------------------*/
  
/*  if (!CheckStamp(nfp,1))     */ /* check time stamp 1 means checkpoint file */
/*    {
      LOGfprintf(stderr,"File header check failed, restore not done\n");
      return;
    }	*/
  
/*---------------------------check version number correct----------------*/

  c = getc(nfp);
  while(isspace(c)) c = getc(nfp);
  if(c != '#' || getc(nfp) != '#')
    {
      printf("network file format incorrect (no initial ##)\n");
      return;
    }
  fscanf(nfp,"%d",&version); 
#ifdef TSIM
  if (version != 4)
#else
  if (version != 3)
#endif
    {
      LOGfprintf(stderr,
              "expecting different network file format; cannot load version %d\n",
              version);
      return;
    }
/*-------------------------------restore network values-------------------*/

  RestoreState(nfp);
}

/*-------------------------------------------------------------------------
  Restores the  state  of the network from file  nfp .
---------------------------------------------------------------------------*/

RestoreState(nfp)
     FILE *nfp;

{
    int ucount,scount,icount,t1,t2,i,j,no_strings,delay;
    int nosets,no_state,no_units,set_no;
    short no_sites,no_inputs;
    register Link * ip;
    register Site * sp;
    register Unit * up;
    NameDesc *nt, nte;
    int index, type, size, length;
    char buff[80];                                /* change to use buffer */
    Output * op;
    FLINT flval;

/*----------------------------restore unit values------------------------*/

    LOGfprintf(stdout,"restoring unit state...");
    if (fscanf(nfp,"%d", &no_units) != 1)
      {
        LOGfprintf(stderr,"restore error: Number of units not specified\n");
        exit(1);
      }
    if (no_units > NoUnits)
      {
        LOGfprintf(stderr,"restore error: Less units now than when network was checkpointed\n");
        exit(1);
      }
    for ( ucount = 0; ucount < NoUnits; ucount++) {
        if(ucount % 10 == 0)
          {                                       /* output . every 10 units */
            putchar('.');
            fflush(stdout);
          }
        up =  UnitList+ucount;          /* up points to current unit struct */

        /* unit fields */
        if (fscanf(nfp,
                   UNIT_VALUES,
                   &(up->potential),
                   &(up->init_potential),
                   &(up->state),
                   &(up->init_state),
                   &(up->output),
                   &(up->flags),
                   &(up->sets),
                   &no_sites  ) != 8)
          {
            LOGfprintf(stderr,
                    "restore error: couldn't read unit fields for unit %d\n",
                    ucount);
            exit(1);
          }
        if (up->no_site != no_sites)
          {
            LOGfprintf(stderr,
                    "restore error: number of sites on unit %d has changed fromv %hd to %hd\n",ucount, no_sites, up->no_site);
            exit(1);
          }
#ifdef TSIM
        if (fscanf(nfp,"%d",&delay) != 1)
          {
            LOGfprintf(stderr,
                       "restore error: couldn't read unit delay buffer for unit %d\n",
                       ucount);
            exit(1);
          }

        if (delay != *Outputs[ucount]) /* buffer size is different */
          ChangeDelayBuffer(ucount,delay);
        
        for (i = 0, op = Outputs[ucount]+1; i < delay; i++,op++)
#ifdef FSIM
          if (fscanf(nfp,"%f",&flval) != 1)
#else
          if (fscanf(nfp,"%d",&flval) != 1)
#endif
            {
              LOGfprintf(stderr,
                         "restore error: couldn't read unit delay buffer for unit %d\n",
                         ucount);
              exit(1);
            }
          else
            *op = flval;
#endif
        if (si_User_Unit_Restore != NULL)
          si_User_Unit_Restore(nfp, up);
        else
          if (fscanf(nfp, DATA_S_TYPE ,&(up->data)) != 1)
            {
              LOGfprintf(stderr,
                      "restore error: couldn't read data field for unit %d\n",
                      ucount);
              exit(1);
            }
#ifndef TSIM
        Outputs[ucount] = up->output;
#else
        *(Outputs[ucount]+1) = up->output;
#endif
        /* read in sites for a unit */

        for ( scount = 0, sp = up->sites;
             scount < no_sites && sp != NULL;
             scount++, sp = sp->next)
          {
            if(fscanf(nfp,SITE_VALUES,&(sp->value),&no_inputs) != 2) /*SITE_VALUES*/
              {
                LOGfprintf(stderr,"restore error: site specification\n");
                exit(1);
              }
            if (no_inputs != sp->no_inputs)
              {
                LOGfprintf(stderr,"restore error: number of links to site %s of unit %d has changed\n", sp->name, ucount);
                exit(1);
              }
        if (si_User_Site_Restore != NULL)
          si_User_Site_Restore(nfp, up, sp);
        else
          if (fscanf(nfp,DATA_S_TYPE,&(sp->data)) != 1)
            {
              LOGfprintf(stderr,
                      "restore error: couldn't read data field for site %s of unit %d\n",
                      sp->name, ucount);
              exit(1);
            }
            
            /* read in inputs for a site */
            for ( icount = 0,ip = sp->inputs;
                 icount < no_inputs && ip != NULL;
                 icount++,ip = ip->next )
              {
                if(fscanf(nfp, LINK_VALUES,
                         & t1,
                         & (ip -> weight)) != 2)
                  {
                    LOGfprintf(stderr,"restore error: link specification\n");
                    exit(1);
                  }
                if (t1 != ip->from_unit)
                  {
                    LOGfprintf(stderr,"restore error: in unit #%d, site %s, link from unit %d now comes from unit %d\n", ucount, sp->name, t1, ip->from_unit);
                    exit(1);
                  }
        if (si_User_Link_Restore != NULL)
          si_User_Link_Restore(nfp, up, sp, ip);
        else
          if (fscanf(nfp,DATA_S_TYPE,&(ip->data)) != 1)
            {
              LOGfprintf(stderr,
                      "restore error: couldn't read data field for link from unit %d to site %s of unit %d\n",
                      ip->from_unit,sp->name,ucount);
              exit(1);
            }

              }
          }
        if(fscanf(nfp,"%s",buffer) != 1 || buffer[0] != '$'){
            LOGfprintf(stderr,"no '$' at end of unit %d",ucount);
            exit(1);
        }
      }
   
/*--------------------------------restore sets---------------------------*/

    LOGfprintf(stdout,"\nrestoring set names\n");
    if (fscanf(nfp,"%d", &nosets) != 1)
      {
        LOGfprintf(stderr,"restore error: number of sets not found\n");
        si_Cleanup();
        return;
      }

    for (i = 0; i < LastSet; i++)
      SetNames[i] = NULL;

    for (i = NoSets = 0; i < nosets; i++)
      {
        if (fscanf(nfp,"%s %d",buffer,&t1) != 2)  /* get first name and num */
          {
            LOGfprintf(stderr, "restore error: set specification\n");
            si_Cleanup();
            return;
          }
        if (0 > t1 || LastSet <= t1)  /* get first name and num */
          {
            LOGfprintf(stderr,
                       "restore error: invalid index %d for set %s index\n",
                       t1, buffer);
            si_Cleanup();
            return;
          }
        if (FindName(buffer,&nte) != NULL &&
            !(nte.type == SET_SYM || nte.type == STRING_SYM))
          {
            LOGfprintf(stderr,"restore warning: cannot restore set %s, name already in use as a %s\n",buffer,NameToType(nte.type));
            for (j = 0; j < NoUnits; j++)
              RemSet(j,t1);
          }
        else
          {
            SetNames[t1] = AlterName(buffer,SET_SYM,t1,0,0);
            NoSets++;
          }
      }

    if (fscanf(nfp,"%s",buffer) != 1 || buffer[0] != '$')
      {
        LOGfprintf(stderr,"input error: $ after sets\n");
        si_Cleanup();
        return;
      }

/*-------------------------load state/number mapping----------------------*/

    LOGfprintf(stdout,"restoring state names\n");
    if (fscanf(nfp,"%d", &no_state) != 1)
      {
        LOGfprintf(stderr,"restore error: can't read number of states\n");
        si_Cleanup();
        return;
      }

    if (StateCount != no_state)
      LOGfprintf(stderr,
              "restore warning: number of states does not correspond\nCurrently %d states, restoring %d states\n",StateCount, no_state);

    for (i = 0; i < NoStates; i++)
      StateNames[i] = NULL;

    for(i = StateCount = 0;i < no_state;i += 1)
      {
        if(fscanf(nfp,"%s %d",buffer,&t1) != 2)
          {
             LOGfprintf(stderr,"restore error: can't read state name / number\n");
             si_Cleanup();
             return;
           }
        if (0 > t1 || NoStates <= t1)
          LOGfprintf(stderr,
                     "restore error: invalid index %d for state %s, ignored\n",
                     t1, buffer);
        else
          if (FindName(buffer,&nte) != NULL &&
              !(nte.type == STATE_SYM || nte.type == STRING_SYM))
            LOGfprintf(stderr,"restore warning: cannot restore state %s, name already in use as a %s\n",buffer,NameToType(nte.type));
          else
            {
              StateNames[t1] = AlterName(buffer,STATE_SYM,t1,0,0);
              StateCount++;
            }
      }

    if (fscanf(nfp,"%s",buffer) != 1 || buffer[0] != '$')
      {
        LOGfprintf(stderr,"input error: $ after states\n");
        exit(1);
      }
    printf(" state restored.\n");
    fflush(stdout);

} /* RestoreState */

/***** NetCheckpoint ******/
/*-------------------------------------------------------------------------
  save the current state of the network into the given file descriptor.
  Writes a time stamp into the file  savef  using  StampTime
  , followed by the  state  of the network, that is all the
  weights, potentials, outputs, etc.  Uses SaveState to save the state.
---------------------------------------------------------------------------*/

NetCheckpoint(savef)
FILE    *savef;
{
    int ct;
    register int i;
    register int ucount;


    /* Stamp file */
/*    StampFile(savef,1);     */    /* timestamp file 1 means checkpoint file */

#ifdef TSIM
    fprintf(savef, "##4\n");
#else
    fprintf(savef, "##3\n");
#endif

    SaveState(savef);

  }

/*-------------------------------------------------------------------------
  Writes the  state  of the network to file for reading in later.
---------------------------------------------------------------------------*/

SaveState(savef)
     FILE *savef;
{
    printf("saving state\n");

    /* Save units */
    SaveUnits(savef);

    /* save set information */
    SaveSets(savef);

    /* save state name stuff */
    SaveStates(savef);

    printf("\n");

}

static SaveSets(savef)          /* save the set information */
     FILE *savef;
     
{
  register int i;
  register int ct;
  
  ct = 0;
  for(i = 0; i < 32; i++)
    if(SetNames[i] != NULL)
      ct++;
  fprintf(savef,"%d\n",ct);
  for(i = 0; i < 32; i++)
    if(SetNames[i] != NULL)
      fprintf(savef,"%s %d\n",SetNames[i],i);
  fprintf(savef,"$\n");
}

static SaveStates(savef)        /* save the state mapping */
     FILE *savef;
     
{
  register int i;
  
  fprintf(savef, "%d\n", StateCount);
  for (i = 0; i < NoStates; i++)
    if (StateNames[i] != NULL)
      fprintf(savef, "%s %d\n", StateNames[i], i);
  fprintf(savef, "$\n");
}

static SaveUnits (savef)        /* save all the units, sites and links */
  FILE *savef;

{   register Link *ip;
    register Site *sp;
    register Unit *up;
    register int ucount;
    int i, j;
    Output *op;

    fprintf(savef, "%d\n", NoUnits);
    for(ucount = 0; ucount < NoUnits; ucount++)
      {
        if(ucount % 10 == 0)
          {                     /* output . every 10 units */
            putchar('.');
            fflush(stdout);
          }
        up = UnitList + ucount;
        fprintf(savef, UNIT_VALUES,
            up->potential, up->init_potential, up->state,
            up->init_state, up->output, up->flags, up->sets, up->no_site);
#ifdef TSIM
        fprintf(savef, " %d \n\t\t\t", (j = *(Outputs[ucount])));
        for (i = 0, op = Outputs[ucount]+1; i < j; i++,op++)
#ifdef FSIM
          fprintf(savef, " %f ",*op);
#else
          fprintf(savef, " %d ",*op);
#endif
#endif
        if (si_User_Unit_Checkpoint == NULL)
          {
            fprintf(savef,DATA_S_TYPE,up->data);
            fprintf(savef,"\n");
          }
        else
          si_User_Unit_Checkpoint(savef,up);
    
    /* Save sites for a unit */
        
        for(sp = up->sites;sp != NULL;sp = sp->next)
          {
            fprintf(savef, SITE_VALUES,
              sp->value,
              sp->no_inputs);
            if (si_User_Site_Checkpoint == NULL)
              {
                fprintf(savef,DATA_S_TYPE,sp->data);
                fprintf(savef,"\n");
              }
            else
              si_User_Site_Checkpoint(savef, up, sp);

            /* save inputs for a site */
            for(ip = sp->inputs;ip != NULL;ip = ip->next)
              {
                fprintf(savef, LINK_VALUES,
                        ip->from_unit,
                        ip->weight);
                if (si_User_Link_Checkpoint == NULL)
                  {
                    fprintf(savef,DATA_S_TYPE,ip->data);
                    fprintf(savef,"\n");
                  }
                else
                  si_User_Link_Checkpoint(savef, up, sp, ip);
              }
          }
        fprintf(savef, "$\n");
      }
}
