/* definitons common to butterfly control/sim node and uniprocessor code */

#undef FALSE                    /* for butterfly cross compiler */
#undef TRUE
#define FALSE           0
#define TRUE            1

#define SCALAR          0
#define VECTOR          1
#define ARRAY           2
#define SET_SYM         3
#define STATE_SYM       4
#define STRING_SYM      5
#define TYPE_SYM        6
#define FUNC_SYM        7
#define SITE_SYM        8
#define DATA_SYM        9
#define CODE_SYM        10

#define ASYNC           0
#define SYNC            1
#define FAIRASYNC       2

#define ARGLEN          40
#define NUMARGS         40
#define MAX_COMMAND_LEN 180                       /* max command length */

#ifdef FSIM

  typedef float weight_type;
  typedef float data_type;
  typedef float func_type;
  typedef float pot_type;
  typedef float Output;
# define UNIT_VALUES "%f %f %hd %hd %f %d %d %hd "
# define SITE_VALUES "\t%f %hd "
# define LINK_VALUES "\t\t%d %f "
# define DATA_S_TYPE "%f"
# define OUT_S_TYPE "%f"
# define POT_S_TYPE "%f"
# define WEIGHT_S_TYPE "%f"
# define FLINT float

#else

  typedef short weight_type;
  typedef int data_type;
  typedef int func_type;
  typedef short pot_type;
  typedef short Output;
# define UNIT_VALUES "%hd %hd %hd %hd %hd %d %d %hd "
# define SITE_VALUES "\t%hd %hd "
# define LINK_VALUES "\t\t%d %hd "
# define DATA_S_TYPE "%d"
# define OUT_S_TYPE "%hd"
# define POT_S_TYPE "%hd"
# define WEIGHT_S_TYPE "%d"
# define FLINT int

#endif

#ifdef TSIM                     /* if delay links simulated */
#  define Outvec Output *
#else
#  define Outvec Output
#endif

typedef func_type (* func_ptr)();

/* link */
typedef struct link{
    func_ptr link_f;
    weight_type weight;
    Output * value;
    data_type data;
    int from_unit;
    struct link *next;
} Link;

/* site */
typedef struct site{
    char * name;
    Output value;
    short no_inputs;
    data_type data;
    func_ptr site_f;
    Link * inputs;              /* array of inputs */
    struct site *next;
} Site;

/* unit */
typedef struct unit{
    unsigned int flags;         /* misc. flags */
    char * type;                /* pointer to stored string */
    func_ptr unit_f;    /* function pointers */
#ifndef BFLY
    char * name;                /* ptr to stored string */
#endif
    pot_type init_potential;
    pot_type potential;         /* potential */
    Output output;              /* output */
    short init_state;
    short state;                /* state */
    short no_site;
    data_type data;
    unsigned int sets;          /* set membership bits */
    Site * sites;               /* array of sites */
} Unit;

typedef union i_p
{                               /* points to an item in core */
  int * intval;                 /* four byte quantity */
  float * floatval;
  func_ptr func;
  char * fileinfo;
} item_ptr;

typedef struct d_m              /* Item Table entry type */
{
  int next;                     /* index in table of next item for this file */
  char * name;                  /* pointer to name of item */
  item_ptr item;                /* for the data pointer to name mapping */
} MappingTable;

/* system defined flags */
#define SHOW_FLAG 0
#define LIST_FLAG 1
#define NO_LINK_FUNC_FLAG 2
#define NO_SITE_FUNC_FLAG 3
#define NO_UNIT_FUNC_FLAG 4
#define STEP_SIM_FLAG 5
#define LIMIT_SIM_FLAG 6

extern int MakeUnit();
extern Site * AddSite();
extern Link * MakeLink();
#ifdef TSIM
extern Link * MakeDelayLink();
#endif
extern char * si_malloc();      /* if not enough space, calls ScavengeLinks */
extern char * si_calloc();

extern int NoUnits;             /* number of units in the net */
extern int LastUnit;            /* last unit made */

extern char **StateNames;       /* state Names */
extern int NoStates;            /* number of states with Names */
extern int StateCount;          /* actual number of states with Names */

extern char *SetNames[32];      /* set Names */
extern int LastSet;
extern int NoSets;

extern int NoLinks;

extern int Clock;               /* the system Clock */

extern FILE *Dispf;             /* display output (pipe to more) */

extern int SyncFlag;

extern int ExecFract;

extern int ExecLimit;

extern int Pause;               /* if 1, Pause after every Show */
extern int Echo;                /* if 1, echo after EchoStep steps */
extern int EchoStep;            /* print message after EchoStep steps
                                   of simulation */
extern char PipeCommand[];      /* pipe command string */
extern int PipeFlag;            /* 0 means pipe off, 1 means pipe on*/

extern char * si_Program;       /* holds executable name for time-stamp */
extern int Debug;               /* 0 if not debug, != 0 if debugging */
extern unsigned int Errors;     /* bit vector for debug errors */
extern int AutoFix;             /* 0 if no auto-fix, for debugging */
extern int Logging;             /* 0 if not logging, 1 if logging */
extern FILE * LogFile;          /* file pointer for Log file */
extern int LogCmd;              /* 0 if not logging commands, 1 if logging */
extern FILE * CmdFile;          /* file pointer for command log file */
extern int Format;              /* on for auto-line breaking in dispaly */

extern int Guarded;             /* 0 means interrupts processed at once */

extern int si_GiErrCnt;         /* error count for graphics */

extern int Show;                /* global flag indicating Show on/off */
extern int ShowStep;            /* plot values at ShowStep time steps */
extern FLINT ShowPot;             /* potential threshold for Showing */
extern unsigned int ShowSets;   /* set bits for sets to be shown */

extern Index * EnterName();
extern Index * AlterName();

/* name table functions */
extern NameDesc *FindName();
extern char *IndToName();
extern char *StateToName();
extern func_ptr NameToFunc();
extern char *FuncToName();
extern func_type NullFunc();
extern MappingTable * IndexToItem();
extern MappingTable * NameToItem();
extern MappingTable * PointerToItem();

/*macro which tests if unit index is within range */
#define LegalUnit(x) ((x) >= 0 && (x) < NoUnits)
  
                                /* initialised in main.c */
extern int (* si_User_Unit_Display)(); /* pointers to user supplied functions */
extern int (* si_User_Site_Display)(); /* for displaying and listing the data */
extern int (* si_User_Link_Display)(); /* in user-defined data fields of the */
extern int (* si_User_Link_List)();    /* standard structures */
extern int (* si_User_Unit_Checkpoint)(); /* for checkpointing unit data */
extern int (* si_User_Site_Checkpoint)(); /* for checkpointing site data */
extern int (* si_User_Link_Checkpoint)(); /* for checkpointing link data */
extern int (* si_User_Unit_Restore)(); /* for Restoring unit data */
extern int (* si_User_Site_Restore)(); /* for Restoring site data */
extern int (* si_User_Link_Restore)(); /* for Restoring link data */
extern int (* si_User_Unit_Save)(); /* for Saving unit data */
extern int (* si_User_Site_Save)(); /* for Saving site data */
extern int (* si_User_Link_Save)(); /* for Saving link data */
extern int (* si_User_Unit_Load)(); /* for Loading unit data */
extern int (* si_User_Site_Load)(); /* for Loading site data */
extern int (* si_User_Link_Load)(); /* for Loading link data */
extern int (* si_User_Help_Info)(); /* for Loading link data */
 
/* end of common definitions */
