#include "sim.h"
#include "lex.h"

LFdelay(up,sp,lp)
     Unit * up;
     Site * sp;
     Link * lp;

{
  int i, j, k;

  for (i = 0; i < lp->data->count - 1; i++)
    lp->data->inputs[i] = lp->data->inputs[i+1];
  lp->data->inputs[i].weight = lp->weight;
  lp->data->inputs[i].value = *(lp->value);
}

SFdelayweightedsum(up,sp)
     Unit * up;
     Site * sp;

{
  Link * lp;
  int sum = 0;

  for (lp = sp->inputs; lp != NULL; lp = lp->next)
    sum += lp->data->inputs[0].weight * lp->data->inputs[0].value;
  sp->value = sum/1000;
}

MakeLinkData(lp,count)
     int count;
     Link * lp;

{
  int i,j;

  lp->data = (link_data_type) malloc (sizeof(struct l_d_type));
  lp->data->count = count;
  lp->data->inputs = (input *) malloc (sizeof(input) * count);
  for (i = 0; i < count; i++)
    lp->data->inputs[i].weight = lp->data->inputs[i].value = 0;
}

User_Link_Display(fp,up,sp,lp)
     FILE * fp;
     Unit * up;
     Site * sp;
     Link * lp;

{
  int i;

  for (i = 0; i < lp->data->count; i++)
    fprintf(fp,"\t\t%d delay - value: %d weight: %d\n",i+1,
            lp->data->inputs[i].value,lp->data->inputs[i].weight);
}

User_Link_List(fp,up,sp,lp)
     FILE * fp;
     Unit * up;
     Site * sp;
     Link * lp;

{
  fprintf(fp,"delay: %d\n",lp->data->count);
}

User_Link_Checkpoint(fp,up,sp,lp)
     FILE * fp;
     Unit * up;
     Site * sp;
     Link * lp;
    
{
  int i,j,k;

  fprintf(fp," %hd",lp->data->count);
  for (i = 0; i < lp->data->count; i++)
    fprintf(fp," %hd %hd",lp->data->inputs[i].weight,
            lp->data->inputs[i].value);
  fprintf(fp,"\n");
}

User_Link_Restore(fp,up,sp,lp)
     FILE * fp;
     Unit * up;
     Site * sp;
     Link * lp;

{
  int i, count;

  fscanf(fp,"%d",&count);
  for (i = 0; i < count; i++)
    fscanf(fp,"%hd %hd",&(lp->data->inputs[i].weight),
            &(lp->data->inputs[i].value));
}

User_Link_Save(fp,up,sp,lp)
     FILE * fp;
     Unit * up;
     Site * sp;
     Link * lp;

{
  fprintf(fp," %d ",lp->data->count);
}
  
User_Link_Load(fp,up,sp,lp)
     FILE * fp;
     Unit * up;
     Site * sp;
     Link * lp;

{
  int count;

  fscanf(fp,"%d",&count);
  MakeLinkData(lp,count);
}

build()

{
  int i,j,k, u;
  Link * lp;

  AllocateUnits(10);
  for (i = 0; i < 10; i++)
    {
      u = MakeUnit("neuron",UFsum,0,0,0,0,0,0);
      AddSite(u,"excite",SFdelayweightedsum,0);
    }
  for (i = 0; i < 10; i++)
    for (j = 0; j < 10; j++)
      if (i != j)
        {
          lp = MakeLink(i,j,"excite",1000,0,LFdelay);
          MakeLinkData(lp,(10+i-j)%10);
        }
}

Cmd_linkdata(argc,argv)
          int argc;
          char ** argv;

{
  int from, to, delay, weight, value;
  char sitename[100];
  Unit * up;
  Site * sp;
  Link * lp;

  if (argc == 2 && Lex(argv[1]) == HELP)
    goto helpinfo;
  if (argc != 7) goto synerror;
  sscanf(argv[1],"%d",&from);
  sscanf(argv[2],"%d",&to);
  sscanf(argv[3],"%s",sitename);
  sscanf(argv[4],"%d",&delay);
  sscanf(argv[5],"%d",&weight);
  sscanf(argv[6],"%d",&value);
  up = &UnitList[to];
  for (sp = up->sites;
       sp != NULL && strcmp(sp->name,sitename);
       sp = sp->next);
  if (sp == NULL)
    {
      LOGfprintf(stderr,"Can't find site %s on unit %d\n",sitename,to);
      return 0;
    }
  for (lp = sp->inputs;
       lp != NULL && lp->from_unit != from;
       lp = lp->next);
  if (lp == NULL)
    {
      LOGfprintf(stderr,
                 "Can't find link from unit %d to site %s on unit %d\n",
                 from,sitename,to);
      return 0;
    }
  if (delay > lp->data->count)
    {
      LOGfprintf(stderr,
                 "Link from unit %d to site %s on unit %d has %d step delay!\n",
                 from,sitename,to,lp->data->count);
      return 0;
    }
  lp->data->inputs[delay-1].weight = weight;
  lp->data->inputs[delay-1].value = value;
  return 0;

 helpinfo:
  Format = TRUE;                                  /* print detailed hel\p */
  LOGfprintf(Dispf,"The linkdata command is used to set the weight and value in a time delayed link.  You must give, in order, the unit from which the link originates, the unit to which it goes, the site at which it arrives, which delay you want to adjust the values for, the new weight, and the new value\n");
  Format = FALSE;

 synerror:
  LOGfprintf(Dispf,"\nUsage: linkdata [<From-UnitID> <To-UnitID> <To-site> <delay> <weight> <value>\n\n");
  return 0;
}

User_Help_Info()

{
  Format = TRUE;
  LOGfprintf(Dispf,"This simulator is augmented to model fibre propogation delays.  If you display a unit, you will notice each link has a series of delays.  Every link has at least one delay.  At a given time step, the current incoming value and the current weight are saved at the bottom of the list.  At each time step the values and weights percolate up the list one place.  When a value/weight pair reaches the top of the list, it is used by the site function.\n\n");
  Format = FALSE;
}
