/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/rpc/sources/RCS/ui_rpcsel.ph,v $
  SHORTNAME      : ui_rpcsel.ph
  SNNS VERSION   : 4.1

  PURPOSE        : private header for ui_rpcsel.c
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.5 $
  LAST CHANGE    : $Date: 1995/11/16 07:28:00 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#ifndef _UI_RPCSEL_DEFINED_
#define _UI_RPCSEL_DEFINED_

/* begin global definition section */

#define MAXITEMS 40

typedef struct {
	bool selected;
	char *formatstr;
	char *name;
	char *formattitle;
}items;

items itemsList[MAXITEMS] = {
	{TRUE  , "%-16s " ,"HOSTNAME","%-16s "},
	{FALSE , "%-30s " ,"DOMAINNAME","%-30s "},
	{FALSE , "%-16s " ,"HOSTADRESS","%-16s "},
	{TRUE  , "%-9ld " ,"KERNELNO","%-9s "},
	{FALSE , "%-8ld " ,"KERNELID","%-8s "},
	{FALSE , "%-7s "  ,"K_TYPE","%-7s "},
	{TRUE  , "%-9s "  ,"STATUS","%-9s "},
	{FALSE , "%-9ld " ,"CYCLES","%-9s "},
	{FALSE , "%-9ld " ,"EPOCH","%-9s "},
	{FALSE , "%10.5f ","SSE","%-10s "},
	{FALSE , "%10.5f ","MSE","%-10s "},
	{FALSE , "%11.5f ","SSE/o-units","%-11s "},
	{FALSE , "%-11ld ","NO. PATTERN","%-11s "},
	{FALSE , "%-10ld ","NO. UNITS","%-10s "},
	{FALSE , "%-10ld ","NO. INPUT","%-10s "},
	{FALSE , "%-10ld ","NO. HIDDEN","%-10s "},
	{FALSE , "%-10ld ","NO. OUTPUT","%-10s "},
	{FALSE , "%-19s " ,"NET NAME","%-19s "},
	{FALSE , "%-19s " ,"PATTERN SET NAME 1","%-19s "},
	{FALSE , "%-19s " ,"PATTERN SET NAME 2","%-19s "},
	{FALSE , "%-19s " ,"PATTERN SET NAME 3","%-19s "},
	{FALSE , "%-19s " ,"PATTERN SET NAME 4","%-19s "},
	{FALSE , "%-19s " ,"PATTERN SET NAME 5","%-19s "},
	{FALSE , "%-8.3f " ,"LEARN 1","%-8s "},
	{FALSE , "%-8.3f " ,"LEARN 2","%-8s "},
	{FALSE , "%-8.3f " ,"LEARN 3","%-8s "},
	{FALSE , "%-8.3f " ,"LEARN 4","%-8s "},
	{FALSE , "%-8.3f " ,"LEARN 5","%-8s "},
	{FALSE , "%-8.3f " ,"UPDATE 1","%-8s "},
	{FALSE , "%-8.3f " ,"UPDATE 2","%-8s "},
	{FALSE , "%-8.3f " ,"UPDATE 3","%-8s "},
	{FALSE , "%-8.3f " ,"UPDATE 4","%-8s "},
	{FALSE , "%-8.3f " ,"UPDATE 5","%-8s "},
	{FALSE , "%-6.3f " ,"INIT 1","%-6s "},
	{FALSE , "%-6.3f " ,"INIT 2","%-6s "},
	{FALSE , "%-6.3f " ,"INIT 3","%-6s "},
	{FALSE , "%-6.3f " ,"INIT 4","%-6s "},
	{FALSE , "%-6.3f " ,"INIT 5","%-6s "},
};

int selectedShowItems[MAXITEMS+1];

void ui_displaySelectHostPanelItems(Widget w, Widget button, caddr_t call_data);
void ui_RPC_createItemsLists(void);

/* end global definition section */

/* begin private definition section */

static int aktselitem1=-1;
static int aktselitem2=-1;
static int anzitemlist1 = 0;
static int anzitemlist2 = 0;
static char *seliteml1[MAXITEMS+1];
static char *seliteml2[MAXITEMS+1];
static int notselectedShowItems[MAXITEMS+1];



static Bool ui_RPCselectHostPanelItemsIsCreated = FALSE; 	
	/* RPC Select Items panel created yes or no */

static Widget ui_popRPCselItem,RPCselItemsL1,RPCselItemsL2;

static void ui_RPCmoveItemRightCallback(Widget w, caddr_t client_data, caddr_t data);
static void ui_RPCmoveItemLeftCallback(Widget w, caddr_t client_data, caddr_t data);
static void ui_RPCmoveItemUpCallback(Widget w, caddr_t client_data, caddr_t data);
static void ui_RPCmoveItemDownCallback(Widget w, caddr_t client_data, caddr_t data);
static void ui_RPCselItemCallback(Widget w, caddr_t client_data, XawListReturnStruct * selektion);
static void ui_RPCselItemCloseCallback(Widget w, caddr_t client_data, XawListReturnStruct * selektion);
static void ui_RPC_createOrderdItemsLists(void);







/* end private definition section */
#endif /* UI_RPCSEL */
