/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/rpc/sources/RCS/ui_rpcCo.c,v $
  SHORTNAME      : ui_rpcCo
  SNNS VERSION   : 4.1

  PURPOSE        : 
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.4 $
  LAST CHANGE    : $Date: 1995/11/16 07:27:40 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#ifdef RPCSNNS
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <rpc/rpc.h>
#include <rpc/types.h>

#include "ui.h"

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include "kr_ui_rpc.h"
#include "kr_ui_rpc_main.h"
#include "ui_rpcsnns.h"
#include "ui_rpcP.h"
#include "ui_rpc.h"

#include "ui_rpcCo.ph"

/*****************************************************************************
  FUNCTION : ui_checkCoopMaster

  PURPOSE  : Check the coopKernels and the host structure.
  RETURNS  : was the struct modified (TRUE/FALSE)
  NOTES    :

  UPDATE   :
*****************************************************************************/
bool ui_checkCoopMaster(void)
{
    int i;
    int master = -1,slave=-1;
    
    /* First check the host structure */
    for(i=1 ;i < anzHostEntries ;i ++){
	if (host[i].kernel_config->kernelMode == COOP_M_KERNEL){
	    if(master >= 0){
		/* There ist already a master => reset to normal */
		host[i].kernel_config->kernelMode = NORMALKERNEL;
	    }else{
		/* First Master */
		master = i;
		coopMaster = master;
	    }
	}
    }

    if (master < 0){
/*	ui_tw_errorMessage("No master found !!");*/
	anzCoopEntries = 0;
	return(FALSE);
    }
    /* the master is always the first */
    anzCoopEntries = 0;
    coopKernels[anzCoopEntries].kernelid = host[master].kernelid;
    coopKernels[anzCoopEntries].kernelno = host[master].kernelno;
    coopKernels[anzCoopEntries].host = host[master].hostname;
    coopKernels[anzCoopEntries].domain = host[master].domainname;
    coopKernels[anzCoopEntries].hostaddr = host[master].hostaddr;
    anzCoopEntries++;
    
    /* Fill the coopKernels structure */
    for(i=0 ;i < anzHostEntries ;i ++){
	if (host[i].kernel_config->kernelMode == COOP_S_KERNEL){
	    coopKernels[anzCoopEntries].kernelid = host[i].kernelid;
	    coopKernels[anzCoopEntries].kernelno = host[i].kernelno;
	    coopKernels[anzCoopEntries].host = host[i].hostname;
	    coopKernels[anzCoopEntries].domain = host[i].domainname;
	    coopKernels[anzCoopEntries].hostaddr = host[i].hostaddr;
	    anzCoopEntries++;
	}
    }
    coopModified = TRUE;
    return(TRUE);
}

/*****************************************************************************
  FUNCTION : ui_setCoopMaster

  PURPOSE  : Set the Master and rebuild the structures
  RETURNS  : bool modified
  NOTES    : Call ui_checkCoopMaster() next.

  UPDATE   :
*****************************************************************************/

bool ui_setCoopMaster(int master)
{
    int i,old = -1;
    bool modi = FALSE;

    if(master <0 || master >= anzHostEntries)
	/* For safety return TRUE */
	return TRUE;
    
    for(i=0 ;i < anzHostEntries ;i ++){
	if (host[i].kernel_config->kernelMode == COOP_M_KERNEL){
	    host[i].kernel_config->kernelMode = NORMALKERNEL;
	    if(old < 0)
		old = i;
	    else
		modi = TRUE;
	}
    }
    if (old != master)
	modi = TRUE;
    host[master].kernel_config->kernelMode = COOP_M_KERNEL;
    coopMaster = master;
    return(modi);
}

/*****************************************************************************
  FUNCTION : ui_broadCoopConfig

  PURPOSE  : Broadcast the CoopConfig
  RETURNS  : 
  NOTES    : 

  UPDATE   :
*****************************************************************************/

void ui_broadCoopConfig(parallel_kernels *par)
{
    int *res,i;

    for(i=0 ; i < anzCoopEntries ; i++){
	res = set_coopconfig_40(par,host[ui_CheckKernelID(coopKernels[i].kernelid)].cl);
    }
}
#endif






