#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include "readline/readline.h"
#include "readline/history.h"

#include "fudgit.h"
#include "command.h"
#include "macro.h"
#include "head.h"

static char **fudgit_completion(char *text, int start, int end);
static char *com_generator(char *text, int state);

extern void *malloc (size_t);

int Ft_initreadline(void)
{
	char buffer[512];
	extern char Ft_Home[];

    rl_readline_name = "Fudgit";
    rl_attempted_completion_function = (UFunction *)fudgit_completion;
    hl_using_history();
	sprintf(buffer, "%s/%s", Ft_Home, HISTORY);
	hl_read_history(buffer);
	hl_stifle_history(HISTNUM);
    return(0);
}

static char **fudgit_completion(char *text, int start, int end)
{
    char **matches;
    extern char *Ft_var_generator(char *text, int state);
    extern char *username_completion_function();
	extern char *rl_line_buffer;
	extern int Ft_Mode;

    matches = (char **)NULL;
	if (Ft_Mode == CMODE) {
        matches = completion_matches(text, Ft_var_generator);
	}
	else {
    	if (start == 0)
        	matches = completion_matches(text, com_generator);
		else if (rl_line_buffer[start-1] == '$')
        	matches = completion_matches(text, Ft_var_generator);
    	/********************
		else if (rl_line_buffer[start] == '~')
        	matches = completion_matches(text, username_completion_function);
    	else
        	matches = completion_matches(text, arg_generator);
    	********************/
	}
    return(matches);
}

static char *com_generator(char *text, int state)
{
    static int list_index2, len, done1;
    register char *name, *cp;
	register Macro *mpp;
	static Macro *mp;
    extern Command Ft_Cmds[];
	extern Macro *Ft_mplisp(void);

    if (!state) {
        list_index2 = 0;
		done1 = 0;
		mp = Ft_mplisp();
        len = strlen(text);
    }
	if (!done1) { /* search for aliases */
    	while (mp) {
			mpp = mp;
			mp = mp->next;
			if (mpp->type != ANALIAS && mpp->type != AMACRO)
				continue;
			name = mpp->fname;
       		if (strncmp(name, text, len) == 0) {
           		cp = (char *)malloc(strlen(name) + 1);
           		strcpy(cp, name);
           		return(cp);
       		}
    	}
		done1 = 1;
	}
    while ((name = Ft_Cmds[list_index2].fname)) {
       	list_index2++;
       	if (strncmp(name, text, len) == 0) {
           	cp = (char *)malloc(strlen(name) + 1);
           	strcpy(cp, name);
           	return(cp);
       	}
    }
    return((char  *)NULL);
}

/***************************************
char *arg_generator(text, state)
char *text;
int state;
{
    static int list_index1, list_index2, len;
    char *name, *cp;
    extern Command Shows[], Sets[];

    if (!state) {
        list_index1 = list_index2 = 0;
        len = strlen(text);
    }
    while (name = Sets[list_index1].fname) {
        list_index1++;
        while (*name != ' ' && *name != '\0')
            name++;
        name++;
        if (strncmp(name, text, len) == 0) {
            cp = (char *)malloc(strlen(name) + 1);
            strcpy(cp, name);
            return(cp);
        }
    }
    while (name = Shows[list_index2].fname) {
        list_index2++;
        while (*name != ' ' && *name != '\0')
            name++;
        name++;
        if (strncmp(name, text, len) == 0) {
            cp = (char *)malloc(strlen(name) + 1);
            strcpy(cp, name);
            return(cp);
        }
    }
    return(NULL);
}
**********************/
